/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazioneDiagnosticaAppenderAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String tipo = confHelper.getParameter("tipo");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            if (confHelper.isEditModeInProgress()) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
                lstParam.add(new Parameter("Elenco Appender Messaggi Diagnostici", "configurazioneDiagnosticaAppenderList.do"));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addTipoDiagnosticaAppenderToDati(TipoOperazione.ADD, "protocol", dati, null, 0);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneDiagnosticaAppender", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.diagnosticaAppenderCheckData(TipoOperazione.ADD);
            if (!isOk) {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
                lstParam.add(new Parameter("Elenco Appender Messaggi Diagnostici", "configurazioneDiagnosticaAppenderList.do"));
                lstParam.add(ServletUtils.getParameterAggiungi());
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addTipoDiagnosticaAppenderToDati(TipoOperazione.ADD, tipo, dati, null, 0);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneDiagnosticaAppender", (ForwardParams)ForwardParams.ADD());
            }
            Configurazione newConfigurazione = confCore.getConfigurazioneGenerale();
            MessaggiDiagnostici md = newConfigurazione.getMessaggiDiagnostici();
            if (md == null) {
                md = new MessaggiDiagnostici();
            }
            OpenspcoopAppender oa = new OpenspcoopAppender();
            oa.setTipo(tipo);
            md.addOpenspcoopAppender(oa);
            newConfigurazione.setMessaggiDiagnostici(md);
            confCore.performUpdateOperation(userLogin, confHelper.smista(), newConfigurazione);
            newConfigurazione = confCore.getConfigurazioneGenerale();
            md = newConfigurazione.getMessaggiDiagnostici();
            confHelper.prepareDiagnosticaAppenderList(md.getOpenspcoopAppenderList());
            pd.setMessage("Configurazione modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneDiagnosticaAppender", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneDiagnosticaAppender", (ForwardParams)ForwardParams.ADD());
        }
    }
}

