/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeFiltro;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.allarmi.constants.TipoPeriodo;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.ModalitaIdentificazione;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaleConfigurazioneNodo;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Dump;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.OpenspcoopSorgenteDati;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.FaseMessageHandler;
import org.openspcoop2.core.config.constants.FaseServiceHandler;
import org.openspcoop2.core.config.constants.PluginCostanti;
import org.openspcoop2.core.config.constants.PluginSorgenteArchivio;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaCacheDigestQueryParameter;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoGestioneCORS;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.Cache;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneControlloTraffico;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneRateLimiting;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneRateLimitingProprieta;
import org.openspcoop2.core.controllo_traffico.TempiRispostaErogazione;
import org.openspcoop2.core.controllo_traffico.TempiRispostaFruizione;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.constants.CacheAlgorithm;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoApplicabilita;
import org.openspcoop2.core.controllo_traffico.constants.TipoBanda;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.core.controllo_traffico.constants.TipoErrore;
import org.openspcoop2.core.controllo_traffico.constants.TipoFiltroApplicativo;
import org.openspcoop2.core.controllo_traffico.constants.TipoFinestra;
import org.openspcoop2.core.controllo_traffico.constants.TipoLatenza;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoRealtime;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoStatistico;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mvc.properties.utils.ConfigManager;
import org.openspcoop2.core.mvc.properties.utils.PropertiesSourceConfiguration;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.utils.handlers.ConfigurazioneHandlerBean;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.IDSoggettoDB;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.monitor.engine.alarm.AlarmContext;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiUtils;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeHistoryBean;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicValidator;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.constants.ParameterType;
import org.openspcoop2.monitor.sdk.exceptions.ValidationException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.plugins.FiltersConfiguration;
import org.openspcoop2.monitor.sdk.plugins.GroupByConfiguration;
import org.openspcoop2.pdd.config.ConfigurazionePdD;
import org.openspcoop2.pdd.core.connettori.ConnettoreCheck;
import org.openspcoop2.pdd.core.controllo_traffico.policy.config.PolicyConfiguration;
import org.openspcoop2.pdd.core.integrazione.GruppoIntegrazione;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.TipologiaResponseAttributeAuthority;
import org.openspcoop2.pdd.logger.filetrace.FileTraceGovWayState;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.InformazioniProtocollo;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.utils.ProtocolUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.DAOConsoleFactory;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.costanti.MultitenantSoggettiErogazioni;
import org.openspcoop2.web.ctrlstat.costanti.MultitenantSoggettiFruizioni;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.servlet.ApiKeyState;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCanaliUtilities;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazionePluginsTipoPluginUtils;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateHelper;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.CheckboxStatusType;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementImage;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.mvc.dynamic.components.BaseComponent;
import org.openspcoop2.web.lib.mvc.dynamic.components.Hidden;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class ConfigurazioneHelper
extends ConsoleHelper {
    public ConfigurazioneHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public ConfigurazioneHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public List<DataElement> addIdProprietaToDati(TipoOperazione tipoOp, String idprop, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("IdProp");
        de.setValue(idprop);
        de.setType(DataElementType.HIDDEN);
        de.setName("idprop");
        dati.add(de);
        return dati;
    }

    public List<DataElement> addTipoTracciamentoAppenderToDati(TipoOperazione tipoOp, String tipo, List<DataElement> dati, String idAppenderDati, int dimensioneAppenderDati) {
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Appender");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setValue(tipo);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("tipo");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneTracciamentoAppenderPropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("id", idAppenderDati)});
            if (contaListe != null && contaListe.booleanValue()) {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(dimensioneAppenderDati));
            } else {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            }
            dati.add(de);
        }
        return dati;
    }

    public String convertLifeCacheValue(String v) {
        if (v == null) {
            return "-1";
        }
        try {
            int vInt = Integer.valueOf(v);
            if (vInt > 0) {
                return "" + vInt;
            }
            return "-1";
        }
        catch (Exception e) {
            return "-1";
        }
    }

    public void setDataElementCRLCacheInfo(List<DataElement> dati, String nomeParametroCrlLifeCache, String crllifecache, boolean allHidden) {
        boolean view = this.isModalitaAvanzata() && !allHidden;
        DataElement de = new DataElement();
        de.setLabel("CRL/OCSP Life Time (Secondi)");
        int value = -1;
        try {
            value = Integer.valueOf(crllifecache);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value > 0) {
            de.setValue("" + value);
        }
        if (view) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setNote("Non indicare i secondi per avere un tempo infinito");
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName(nomeParametroCrlLifeCache);
        de.setSize(this.getSize());
        dati.add(de);
    }

    public void setDataElementCache(List<DataElement> dati, String intestazioneSezione, String nomeParametroStatoCache, String statocache, String nomeParametroDimensioneCache, String dimensionecache, String nomeParametroAlgoritmoCache, String algoritmocache, String nomeParametroIdleCache, String idlecache, String nomeParametroLifeCache, String lifecache, boolean allHidden) {
        boolean view;
        boolean bl = view = this.isModalitaAvanzata() && !allHidden;
        if (view) {
            DataElement de = new DataElement();
            de.setLabel(intestazioneSezione);
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        String[] tipoStatoCache = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
        DataElement de = new DataElement();
        de.setLabel("Stato");
        de.setName(nomeParametroStatoCache);
        if (view && !"Cache (Risposte)".equals(intestazioneSezione) && !"Cache (Load Balancer)".equals(intestazioneSezione)) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoStatoCache);
            de.setSelected(statocache);
            de.setPostBack(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(statocache);
        }
        dati.add(de);
        if (statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO)) {
            de = new DataElement();
            de.setLabel("Dimensione (Elementi)");
            de.setValue(dimensionecache);
            if (view) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName(nomeParametroDimensioneCache);
            de.setSize(this.getSize());
            dati.add(de);
            String[] tipoAlg = new String[]{"lru", "mru"};
            String[] labelsAlg = new String[]{"LRU", "MRU"};
            de = new DataElement();
            de.setLabel("Algoritmo");
            de.setName(nomeParametroAlgoritmoCache);
            if (view) {
                de.setType(DataElementType.SELECT);
                de.setLabels(labelsAlg);
                de.setValues(tipoAlg);
                de.setSelected(algoritmocache);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(algoritmocache);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Item Life Time (Secondi)");
            int value = -1;
            try {
                value = Integer.valueOf(lifecache);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value > 0) {
                de.setValue("" + value);
            }
            if (view && !"Cache (Risposte)".equals(intestazioneSezione) && !"Cache (Load Balancer)".equals(intestazioneSezione)) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName(nomeParametroLifeCache);
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Item Idle Time (Secondi)");
            de.setValue(idlecache);
            if (view && !"Cache (Load Balancer)".equals(intestazioneSezione)) {
                de.setType(DataElementType.TEXT_EDIT);
                if (!"Cache (Keystore)".equals(intestazioneSezione)) {
                    de.setNote("Non indicare i secondi per avere un tempo infinito");
                }
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName(nomeParametroIdleCache);
            de.setSize(this.getSize());
            dati.add(de);
        }
    }

    public List<DataElement> addConfigurazioneRegistroToDati(String statocache, String dimensionecache, String algoritmocache, String idlecache, String lifecache, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Registro");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.LINK);
        de.setUrl("configurazioneRegistriList.do");
        de.setValue("Elenco registri");
        dati.add(de);
        this.setDataElementCache(dati, "Cache (Registro API)", "statocacheRegistry", statocache, "dimensionecacheRegistry", dimensionecache, "algoritmocacheRegistry", algoritmocache, "idlecacheRegistry", idlecache, "lifecacheRegistry", lifecache, false);
        if (this.isModalitaStandard()) {
            this.pd.disableEditMode();
        }
        dati = this.addParameterApplicaModifica(dati);
        return dati;
    }

    public List<DataElement> addTipoDiagnosticaAppenderToDati(TipoOperazione tipoOp, String tipo, List<DataElement> dati, String idAppenderDati, int dimensioneAppenderDati) {
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Appender");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setValue(tipo);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("tipo");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneDiagnosticaAppenderPropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("id", idAppenderDati)});
            if (contaListe != null && contaListe.booleanValue()) {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(dimensioneAppenderDati));
            } else {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            }
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addDiagnosticaDatasourceToDati(TipoOperazione tipoOp, String nome, String nomeJndi, String tipoDatabase, String[] tipoDbList, List<DataElement> dati, String idSorgenteDati, int dimensioneSorgenteDati) {
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Sorgenti Dati");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("nome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome Jndi");
        de.setValue(nomeJndi);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("nomeJndi");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo Database");
        de.setType(DataElementType.SELECT);
        de.setName("tipoDatabase");
        de.setValues(tipoDbList);
        if (tipoDatabase != null) {
            de.setSelected(tipoDatabase);
        }
        de.setRequired(true);
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneDiagnosticaDatasourcePropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("id", idSorgenteDati)});
            if (contaListe != null && contaListe.booleanValue()) {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(dimensioneSorgenteDati));
            } else {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            }
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addTracciamentoDatasourceToDati(TipoOperazione tipoOp, String nome, String nomeJndi, String tipoDatabase, String[] tipoDbList, List<DataElement> dati, String idSorgenteDati, int dimensioneSorgenteDati) {
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Sorgenti Dati");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("nome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome Jndi");
        de.setValue(nomeJndi);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("nomeJndi");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo Database");
        de.setType(DataElementType.SELECT);
        de.setName("tipoDatabase");
        de.setValues(tipoDbList);
        if (tipoDatabase != null) {
            de.setSelected(tipoDatabase);
        }
        de.setRequired(true);
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneTracciamentoDatasourcePropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("id", idSorgenteDati)});
            if (contaListe != null && contaListe.booleanValue()) {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(dimensioneSorgenteDati));
            } else {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            }
            dati.add(de);
        }
        return dati;
    }

    public void prepareTracciamentoDatasourceList(List<OpenspcoopSorgenteDati> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneTracciamentoDatasource", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            Boolean contaListe = ServletUtils.getConfigurazioniPersonalizzateFromSession((HttpSession)this.session);
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Sorgenti Dati Tracciamento", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Nome", "Nome Jndi", "Tipo Database", "Propriet&agrave;"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    OpenspcoopSorgenteDati od = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pid = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + od.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneTracciamentoDatasourceChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pid});
                    de.setValue(od.getNome());
                    de.setIdToRemove("" + od.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(od.getNomeJndi());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(od.getTipoDatabase());
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("configurazioneTracciamentoDatasourcePropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pid});
                    if (contaListe != null && contaListe.booleanValue()) {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(od.sizePropertyList()));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean tracciamentoDatasourceCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String nome = this.getParameter("nome");
            String nomeJndi = this.getParameter("nomeJndi");
            String tipoDatabase = this.getParameter("tipoDatabase");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Il campo Nome deve essere specificato.");
                return false;
            }
            if (nomeJndi == null || "".equals(nomeJndi)) {
                this.pd.setMessage("Il campo Nome Jndi deve essere specificato.");
                return false;
            }
            if (tipoDatabase == null || "".equals(tipoDatabase)) {
                this.pd.setMessage("Il campo Tipo Database deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoDatasource = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                Tracciamento t = newConfigurazione.getTracciamento();
                if (t != null) {
                    List lista = t.getOpenspcoopSorgenteDatiList();
                    OpenspcoopSorgenteDati od = null;
                    for (int j = 0; j < t.sizeOpenspcoopSorgenteDatiList(); ++j) {
                        od = (OpenspcoopSorgenteDati)lista.get(j);
                        if (!nome.equals(od.getNome())) continue;
                        trovatoDatasource = true;
                        break;
                    }
                }
                if (trovatoDatasource) {
                    this.pd.setMessage("Esiste gi&agrave; un sorgente dati con nome " + nome);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareTracciamentoAppenderPropList(OpenspcoopAppender oa, List<Property> lista) throws Exception {
        try {
            org.openspcoop2.web.lib.mvc.Parameter pOaId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + oa.getId());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneTracciamentoAppenderProperties", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId});
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Appender Tracciamento", "configurazioneTracciamentoAppenderList.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Propriet&agrave; di " + oa.getTipo(), null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Nome", "Valore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    Property oap = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pOapId = new org.openspcoop2.web.lib.mvc.Parameter("idprop", "" + oap.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneTracciamentoAppenderPropertiesChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId, pOapId});
                    de.setValue(oap.getNome());
                    de.setIdToRemove("" + oap.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(oap.getValore());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean tracciamentoAppenderPropCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String nome = this.getParameter("nome");
            String valore = this.getParameter("valore");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Il campo Nome deve essere specificato.");
                return false;
            }
            if (valore == null || "".equals(valore)) {
                this.pd.setMessage("Il campo Valore deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovataProp = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                Tracciamento t = newConfigurazione.getTracciamento();
                OpenspcoopAppender oa = null;
                for (int j = 0; j < t.sizeOpenspcoopAppenderList() && idInt != (oa = t.getOpenspcoopAppender(j)).getId().intValue(); ++j) {
                }
                if (oa == null) {
                    throw new DriverControlStationException("Appender non trovato");
                }
                Property oap = null;
                for (int i = 0; i < oa.sizePropertyList(); ++i) {
                    oap = oa.getProperty(i);
                    if (!nome.equals(oap.getNome())) continue;
                    trovataProp = true;
                    break;
                }
                if (trovataProp) {
                    this.pd.setMessage("Esiste gi&agrave; una Propriet\u00e0 con nome " + nome);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareTracciamentoDatasourcePropList(OpenspcoopSorgenteDati od, List<Property> lista) throws Exception {
        try {
            org.openspcoop2.web.lib.mvc.Parameter pOdId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + od.getId());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneTracciamentoDatasourceProperties", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[]{pOdId});
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Sorgenti Dati Tracciamento", "configurazioneTracciamentoDatasourceList.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Propriet&agrave; di " + od.getNome(), null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Nome", "Valore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    Property odp = lista.get(i);
                    org.openspcoop2.web.lib.mvc.Parameter pOapId = new org.openspcoop2.web.lib.mvc.Parameter("idprop", "" + odp.getId());
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneTracciamentoDatasourcePropertiesChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pOdId, pOapId});
                    de.setValue(odp.getNome());
                    de.setIdToRemove("" + odp.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(odp.getValore());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean tracciamentoDatasourcePropCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String nome = this.getParameter("nome");
            String valore = this.getParameter("valore");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Il campo Nome deve essere specificato.");
                return false;
            }
            if (valore == null || "".equals(valore)) {
                this.pd.setMessage("Il campo Valore deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovataProp = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                Tracciamento t = newConfigurazione.getTracciamento();
                List lista = t.getOpenspcoopSorgenteDatiList();
                OpenspcoopSorgenteDati od = null;
                for (int j = 0; j < t.sizeOpenspcoopSorgenteDatiList() && idInt != (od = (OpenspcoopSorgenteDati)lista.get(j)).getId().intValue(); ++j) {
                }
                if (od == null) {
                    throw new DriverControlStationException("Datasource non trovato");
                }
                List lista1 = od.getPropertyList();
                Property odp = null;
                for (int i = 0; i < od.sizePropertyList(); ++i) {
                    odp = (Property)lista1.get(i);
                    if (!nome.equals(odp.getNome())) continue;
                    trovataProp = true;
                    break;
                }
                if (trovataProp) {
                    this.pd.setMessage("Esiste gi&agrave; una Propriet\u00e0 con nome " + nome);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareTracciamentoAppenderList(List<OpenspcoopAppender> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneTracciamentoAppender", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Appender Tracciamento", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Tipo", "Propriet&agrave;"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    OpenspcoopAppender oa = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + oa.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneTracciamentoAppenderChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
                    de.setValue(oa.getTipo());
                    de.setIdToRemove("" + oa.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("configurazioneTracciamentoAppenderPropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
                    if (contaListe != null && contaListe.booleanValue()) {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(oa.sizePropertyList()));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean tracciamentoAppenderCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String tipo = this.getParameter("tipo");
            if (tipo == null || "".equals(tipo)) {
                this.pd.setMessage("Il campo Tipo deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoAppender = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                Tracciamento t = newConfigurazione.getTracciamento();
                if (t != null) {
                    OpenspcoopAppender oa = null;
                    for (int j = 0; j < t.sizeOpenspcoopAppenderList(); ++j) {
                        oa = t.getOpenspcoopAppender(j);
                        if (!tipo.equals(oa.getTipo())) continue;
                        trovatoAppender = true;
                        break;
                    }
                }
                if (trovatoAppender) {
                    this.pd.setMessage("Esiste gi&agrave; un Appender con tipo " + tipo);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareDumpAppenderList(List<OpenspcoopAppender> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneDumpAppender", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Appender Dump", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Tipo", "Propriet&agrave;"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    OpenspcoopAppender oa = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + oa.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneDumpAppenderChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
                    de.setValue(oa.getTipo());
                    de.setIdToRemove("" + oa.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("configurazioneDumpAppenderPropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
                    if (contaListe != null && contaListe.booleanValue()) {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(oa.sizePropertyList()));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean dumpAppenderCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String tipo = this.getParameter("tipo");
            if (tipo == null || "".equals(tipo)) {
                this.pd.setMessage("Il campo Tipo deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoAppender = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                Dump dump = newConfigurazione.getDump();
                if (dump != null) {
                    OpenspcoopAppender oa = null;
                    for (int j = 0; j < dump.sizeOpenspcoopAppenderList(); ++j) {
                        oa = dump.getOpenspcoopAppender(j);
                        if (!tipo.equals(oa.getTipo())) continue;
                        trovatoAppender = true;
                        break;
                    }
                }
                if (trovatoAppender) {
                    this.pd.setMessage("Esiste gi&agrave; un Appender con tipo " + tipo);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addTipoDumpAppenderToDati(TipoOperazione tipoOp, String tipo, List<DataElement> dati, String idAppenderDati, int dimensioneAppenderDati) {
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Appender");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setValue(tipo);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("tipo");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneDumpAppenderPropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("id", idAppenderDati)});
            if (contaListe != null && contaListe.booleanValue()) {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(dimensioneAppenderDati));
            } else {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            }
            dati.add(de);
        }
        return dati;
    }

    public void prepareDumpAppenderPropList(OpenspcoopAppender oa, List<Property> lista) throws Exception {
        try {
            org.openspcoop2.web.lib.mvc.Parameter pOaId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + oa.getId());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneDumpAppenderProperties", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId});
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Appender Dump", "configurazioneDumpAppenderList.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Propriet&agrave; di " + oa.getTipo(), null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Nome", "Valore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    Property oap = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pOapId = new org.openspcoop2.web.lib.mvc.Parameter("idprop", "" + oap.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneDumpAppenderPropertiesChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId, pOapId});
                    de.setValue(oap.getNome());
                    de.setIdToRemove("" + oap.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(oap.getValore());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean dumpAppenderPropCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String nome = this.getParameter("nome");
            String valore = this.getParameter("valore");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Il campo Nome deve essere specificato.");
                return false;
            }
            if (valore == null || "".equals(valore)) {
                this.pd.setMessage("Il campo Valore deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovataProp = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                Dump dump = newConfigurazione.getDump();
                OpenspcoopAppender oa = null;
                for (int j = 0; j < dump.sizeOpenspcoopAppenderList() && idInt != (oa = dump.getOpenspcoopAppender(j)).getId().intValue(); ++j) {
                }
                if (oa == null) {
                    throw new DriverControlStationException("Appender non trovato");
                }
                Property oap = null;
                for (int i = 0; i < oa.sizePropertyList(); ++i) {
                    oap = oa.getProperty(i);
                    if (!nome.equals(oap.getNome())) continue;
                    trovataProp = true;
                    break;
                }
                if (trovataProp) {
                    this.pd.setMessage("Esiste gi&agrave; una Propriet&agrave; con nome " + nome);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean systemPropertiesCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String nome = this.getParameter("nome");
            String valore = this.getLockedParameter("valore", false);
            if (nome.equals("") || valore.equals("")) {
                Object tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                if (valore.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Valore" : (String)tmpElenco + ", Valore";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei nomi");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (!this.core.getDriverBYOKUtilities().isEnabledBYOK() || !this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(valore)) {
                if (valore.startsWith(" ") || valore.endsWith(" ")) {
                    this.pd.setMessage("Non inserire spazi all'inizio o alla fine dei valori");
                    return false;
                }
                if (!this.checkLength255(valore, "Valore")) {
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato = false;
                SystemProperties sps = this.confCore.getSystemPropertiesPdD();
                if (sps != null) {
                    for (int i = 0; i < sps.sizeSystemPropertyList(); ++i) {
                        Property tmpSP = sps.getSystemProperty(i);
                        if (!nome.equals(tmpSP.getNome())) continue;
                        giaRegistrato = true;
                        break;
                    }
                }
                if (giaRegistrato) {
                    this.pd.setMessage("La propriet\u00e0 di sistema " + nome + " &egrave; gi&agrave; stata registrata");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareSystemPropertiesList(ISearch ricerca, List<Property> lista) throws Exception {
        try {
            String id = this.getParameter("id");
            org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("id", id);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneSystemProperties", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
            int idLista = Liste.SYSTEM_PROPERTIES;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Propriet&agrave; di Sistema", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Propriet&agrave; di Sistema", "configurazioneSystemPropertiesList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Propriet&agrave; di Sistema", (String)search);
            }
            String[] labels = new String[]{"Nome", "Valore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Property sp : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pIdProp = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + sp.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneSystemPropertiesChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdProp});
                    de.setValue(sp.getNome());
                    de.setIdToRemove(sp.getNome());
                    de.setSize(100);
                    e.add(de);
                    de = new DataElement();
                    if (sp.getValore() != null && StringUtils.isNotEmpty((CharSequence)sp.getValore()) && BYOKManager.isEnabledBYOK() && this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(sp.getValore())) {
                        de.setValue("******");
                    } else {
                        de.setValue(sp.getValore());
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void refreshSystemProperties() {
        List<String> aliases = this.confCore.getJmxPdDAliases();
        boolean resetOk = false;
        if (aliases != null && !aliases.isEmpty()) {
            resetOk = true;
            for (String alias : aliases) {
                String stato = null;
                try {
                    stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaSystemPropertiesPdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoRefreshPersistentConfiguration(alias));
                    if (!this.isErroreHttp(stato, "refresh System Properties")) continue;
                    throw new DriverControlStationException(stato);
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error("Errore durante il refresh via jmx delle system properties (alias: " + alias + "): " + e.getMessage(), (Throwable)e);
                    resetOk = false;
                }
            }
        }
        if (!resetOk) {
            this.pd.setMessage("Configurazione Propriet&agrave; di Sistema modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", org.openspcoop2.web.lib.mvc.Costanti.MESSAGE_TYPE_INFO);
        }
    }

    public boolean routingCheckData(String[] registriList) throws Exception {
        try {
            String registrorotta;
            String nomesoggrotta;
            String tiposoggrotta;
            String rottaenabled = this.getParameter("rottaenabled");
            String tiporotta = this.getParameter("tiporotta");
            if (tiporotta == null) {
                tiporotta = "gateway";
            }
            if ((tiposoggrotta = this.getParameter("tiposoggrotta")) == null) {
                tiposoggrotta = "";
            }
            if ((nomesoggrotta = this.getParameter("nomesoggrotta")) == null) {
                nomesoggrotta = "";
            }
            if ((registrorotta = this.getParameter("registrorotta")) == null) {
                registrorotta = "";
            }
            if (!tiporotta.equals("gateway") && !tiporotta.equals("registro")) {
                this.pd.setMessage("Tipo Rotta dev'essere gateway o registro");
                return false;
            }
            if (rottaenabled.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && tiporotta.equals("gateway") && (tiposoggrotta.equals("") || tiposoggrotta.equals("-") || nomesoggrotta.equals(""))) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare Tipo e Nome Soggetto");
                return false;
            }
            if (tiporotta.equals("gateway") && (tiposoggrotta.indexOf(" ") != -1 || nomesoggrotta.indexOf(" ") != -1)) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (tiporotta.equals("registro")) {
                boolean trovatoReg = false;
                for (int i = 0; i < registriList.length; ++i) {
                    String tmpReg = registriList[i];
                    if (!tmpReg.equals(registrorotta)) continue;
                    trovatoReg = true;
                }
                if (!trovatoReg) {
                    this.pd.setMessage("Il registro dev'essere 'all' oppure dev'essere scelto tra quelli definiti nel pannello Registri");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean routingListCheckData(TipoOperazione tipoOp, String[] registriList) throws Exception {
        try {
            String tipo = this.getParameter("tipo");
            String nome = this.getParameter("nome");
            String tiporotta = this.getParameter("tiporotta");
            String tiposoggrotta = this.getParameter("tiposoggrotta");
            String nomesoggrotta = this.getParameter("nomesoggrotta");
            String registrorotta = this.getParameter("registrorotta");
            if (!tiporotta.equals("gateway") && !tiporotta.equals("registro")) {
                this.pd.setMessage("Tipo Rotta dev'essere gateway o registro");
                return false;
            }
            if (tipo.equals("") || nome.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare Tipo e Nome");
                return false;
            }
            if (tiporotta.equals("gateway") && (tiposoggrotta.equals("") || nomesoggrotta.equals(""))) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare Tipo e Nome Soggetto");
                return false;
            }
            if (tipo.indexOf(" ") != -1 || nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (tiporotta.equals("gateway") && (tiposoggrotta.indexOf(" ") != -1 || nomesoggrotta.indexOf(" ") != -1)) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (tiporotta.equals("registro")) {
                boolean trovatoReg = false;
                for (int i = 0; i < registriList.length; ++i) {
                    String tmpReg = registriList[i];
                    if (!tmpReg.equals(registrorotta)) continue;
                    trovatoReg = true;
                }
                if (!trovatoReg) {
                    this.pd.setMessage("Il registro dev'essere 'all' oppure dev'essere scelto tra quelli definiti nel pannello Registri");
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato = false;
                RoutingTable rt = this.confCore.getRoutingTable();
                for (int i = 0; i < rt.sizeDestinazioneList(); ++i) {
                    RoutingTableDestinazione rtd = rt.getDestinazione(i);
                    if (!nome.equals(rtd.getNome()) || !tipo.equals(rtd.getTipo())) continue;
                    giaRegistrato = true;
                    break;
                }
                if (giaRegistrato) {
                    this.pd.setMessage("La destinazione " + tipo + "/" + nome + " &egrave; gi&agrave; stata registrata");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareRoutingList(ISearch ricerca, List<RoutingTableDestinazione> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneRoute", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.ROUTING;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tabella di Routing", "configurazioneRouting.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Destinazioni", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Destinazioni", "configurazioneRouteList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Destinazioni", (String)search);
            }
            String[] labels = new String[]{"Destinatario", "Tipo rotta"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (RoutingTableDestinazione rtd : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + rtd.getId());
                    de.setUrl("configurazioneRouteChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
                    de.setValue(rtd.getTipo() + "/" + rtd.getNome());
                    e.add(de);
                    Route r = rtd.getRoute(0);
                    de = new DataElement();
                    if (r.getGateway() != null) {
                        de.setValue("gateway");
                    } else {
                        de.setValue("registro");
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean registroCheckData() throws Exception {
        try {
            String statocache = this.getParameter("statocacheRegistry");
            String dimensionecache = this.getParameter("dimensionecacheRegistry");
            String algoritmocache = this.getParameter("algoritmocacheRegistry");
            String idlecache = this.getParameter("idlecacheRegistry");
            String lifecache = this.getParameter("lifecacheRegistry");
            return this.checkDatiCache("AccessoRegistroServizi", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean checkDatiCache(String nomeCache, String statocache, String dimensionecache, String algoritmocache, String idlecache, String lifecache) throws Exception {
        try {
            if (statocache.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare lo Stato in " + nomeCache);
                return false;
            }
            if (statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && (dimensionecache.indexOf(" ") != -1 || idlecache.indexOf(" ") != -1 || lifecache.indexOf(" ") != -1)) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO)) {
                this.pd.setMessage("Stato Cache " + nomeCache + " dev'essere abilitato o disabilitato");
                return false;
            }
            if (statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !algoritmocache.equals("lru") && !algoritmocache.equals("mru")) {
                this.pd.setMessage("Algoritmo della Cache " + nomeCache + " dev'essere LRU o MRU");
                return false;
            }
            if (statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && (dimensionecache == null || dimensionecache.equals(""))) {
                this.pd.setMessage("Deve essere indicato un valore per la Dimensione della Cache " + nomeCache);
                return false;
            }
            if (statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !dimensionecache.equals("") && !this.checkNumber(dimensionecache, "Dimensione (Elementi)(" + nomeCache + ")", false)) {
                return false;
            }
            if (statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !idlecache.equals("") && !this.checkNumber(idlecache, "Item Idle Time (Secondi)(" + nomeCache + ")", false)) {
                return false;
            }
            return !statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) || lifecache == null || lifecache.equals("") || this.checkNumber(lifecache, "Item Life Time (Secondi)(" + nomeCache + ")", false);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean registriCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String nome = this.getParameter("nome");
            String location = this.getParameter("location");
            String tipo = this.getParameter("tipo");
            String utente = this.getParameter("utente");
            String password = this.getParameter("password");
            if (nome.equals("") || location.equals("") || tipo.equals("")) {
                Object tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                if (location.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Location" : (String)tmpElenco + ", Location";
                }
                if (tipo.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Tipo" : (String)tmpElenco + ", Tipo";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                return false;
            }
            if (nome.indexOf(" ") != -1 || location.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(location, "Location")) {
                return false;
            }
            if (utente != null && !"".equals(utente) && !this.checkLength255(utente, "Utente")) {
                return false;
            }
            if (password != null && !"".equals(password) && !this.checkLength255(password, "Password")) {
                return false;
            }
            if (!tipo.equals("xml") && !tipo.equals("db")) {
                this.pd.setMessage("Tipo dev'essere xml, db");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato = false;
                AccessoRegistro ar = this.confCore.getAccessoRegistro();
                for (int i = 0; i < ar.sizeRegistroList(); ++i) {
                    AccessoRegistroRegistro arr = ar.getRegistro(i);
                    if (!nome.equals(arr.getNome())) continue;
                    giaRegistrato = true;
                    break;
                }
                if (giaRegistrato) {
                    this.pd.setMessage("Il registro " + nome + " &egrave; gi&agrave; stato registrato");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareRegistriList(ISearch ricerca, List<AccessoRegistroRegistro> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneRegistri", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.REGISTRI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Registro", "configurazioneAccessoRegistroServizi.do"));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco registri", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco registri", "configurazioneRegistriList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Registri", (String)search);
            }
            String[] labels = new String[]{"Nome", "Tipo"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (AccessoRegistroRegistro arr : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    org.openspcoop2.web.lib.mvc.Parameter pNome = new org.openspcoop2.web.lib.mvc.Parameter("nome", arr.getNome());
                    de.setUrl("configurazioneRegistriChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pNome});
                    de.setValue(arr.getNome());
                    de.setIdToRemove(arr.getNome());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(arr.getTipo().toString());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareResponseCachingConfigurazioneRegolaList(ISearch ricerca, List<ResponseCachingConfigurazioneRegola> lista, Integer defaultCacheSeconds) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneResponseCachingConfigurazioneRegola", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.CONFIGURAZIONE_RESPONSE_CACHING_CONFIGURAZIONE_REGOLA;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setSearch("");
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            this.pd.setSearchDescription("");
            ServletUtils.disabledPageDataSearch((PageData)this.pd);
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Regole di Caching Risposta", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Codice Risposta", "Fault", "Cache Timeout (Secondi)"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (ResponseCachingConfigurazioneRegola regola : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setIdToRemove("" + regola.getId());
                    Integer statusMin = regola.getReturnCodeMin();
                    Integer statusMax = regola.getReturnCodeMax();
                    if (statusMin != null && statusMin <= 0) {
                        statusMin = null;
                    }
                    if (statusMax != null && statusMax <= 0) {
                        statusMax = null;
                    }
                    Object statusValue = null;
                    statusValue = statusMin != null && statusMax != null ? (statusMax.longValue() == statusMin.longValue() ? "" + statusMin : "[" + statusMin + " - " + statusMax + "]") : (statusMin != null && statusMax == null ? "&gt;" + statusMin : (statusMin == null && statusMax != null ? "&lt;" + statusMax : "Qualsiasi"));
                    de.setValue((String)statusValue);
                    e.add(de);
                    de = new DataElement();
                    de.setValue(regola.getFault() ? "Si" : "No");
                    e.add(de);
                    de = new DataElement();
                    de.setValue(regola.getCacheTimeoutSeconds() != null ? "" + regola.getCacheTimeoutSeconds() : "default (" + defaultCacheSeconds + ")");
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean responseCachingConfigurazioneRegolaCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            boolean giaRegistrato;
            if (!this.checkRegolaResponseCaching()) {
                return false;
            }
            String returnCode = this.getParameter("resCacheCCRegCode");
            String statusMinS = this.getParameter("resCacheCCRegMinCode");
            String statusMaxS = this.getParameter("resCacheCCRegMaxCode");
            String faultS = this.getParameter("resCacheCCRegFault");
            Integer statusMin = null;
            Integer statusMax = null;
            boolean fault = ServletUtils.isCheckBoxEnabled((String)faultS);
            if (!returnCode.equals("qualsiasi")) {
                if (StringUtils.isNotEmpty((CharSequence)statusMinS)) {
                    statusMin = Integer.parseInt(statusMinS);
                }
                if (returnCode.equals("intervallo") && StringUtils.isNotEmpty((CharSequence)statusMaxS)) {
                    statusMax = Integer.parseInt(statusMaxS);
                }
                if (returnCode.equals("esatto")) {
                    statusMax = statusMin;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD) && (giaRegistrato = this.confCore.existsResponseCachingConfigurazioneRegola(statusMin, statusMax, fault))) {
                this.pd.setMessage("&Egrave; gi&agrave; presente una Regola di Response Caching con in parametri indicati.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean configurazioneCheckData() throws Exception {
        try {
            boolean isAllHiddenCache;
            String inoltromin = this.getParameter("inoltromin");
            String stato = this.getParameter("stato");
            String controllo = this.getParameter("controllo");
            String integman = this.getParameter("integman");
            String nomeintegman = this.getParameter("nomeintegman");
            String profcoll = this.getParameter("profcoll");
            String connessione = this.getParameter("connessione");
            String utilizzo = this.getParameter("utilizzo");
            String validman = this.getParameter("validman");
            String gestman = this.getParameter("gestman");
            String registrazioneTracce = this.getParameter("registrazioneTracce");
            if (inoltromin.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare una cadenza");
                return false;
            }
            if (inoltromin.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!(stato == null || stato.equals("") || stato.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) || stato.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO) || stato.equals("warningOnly"))) {
                this.pd.setMessage("Stato dev'essere abilitato, disabilitato o warningOnly");
                return false;
            }
            if (!(controllo == null || controllo.equals("") || controllo.equals("rigido") || controllo.equals("normale"))) {
                this.pd.setMessage("Controllo dev'essere rigido o normale");
                return false;
            }
            boolean foundIM = false;
            for (int i = 0; i < ConfigurazioneCostanti.PARAMETRI_CONFIGURAZIONE_IM.length; ++i) {
                if (!ConfigurazioneCostanti.PARAMETRI_CONFIGURAZIONE_IM[i].equals(integman)) continue;
                foundIM = true;
                break;
            }
            if (!foundIM && !integman.equals("custom")) {
                this.pd.setMessage("Tipo autenticazione per integrationManager sconosciuto");
                return false;
            }
            if (!(profcoll == null || profcoll.equals("") || profcoll.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) || profcoll.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO))) {
                this.pd.setMessage("Profilo di collaborazione dev'essere abilitato o disabilitato");
                return false;
            }
            if (!(connessione == null || connessione.equals("") || connessione.equals("new") || connessione.equals("reply"))) {
                this.pd.setMessage("Connessione dev'essere abilitato o disabilitato");
                return false;
            }
            if (!(utilizzo == null || utilizzo.equals("") || utilizzo.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) || utilizzo.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO))) {
                this.pd.setMessage("Utilizzo dev'essere abilitato o disabilitato");
                return false;
            }
            if (!(validman == null || validman.equals("") || validman.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) || validman.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO))) {
                this.pd.setMessage("Manifest attachments dev'essere abilitato o disabilitato");
                return false;
            }
            if (!gestman.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !gestman.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO)) {
                this.pd.setMessage("Gestione dev'essere abilitato o disabilitato");
                return false;
            }
            if (!registrazioneTracce.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !registrazioneTracce.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO)) {
                this.pd.setMessage("Buste dev'essere abilitato o disabilitato");
                return false;
            }
            if (!this.checkNumber(inoltromin, "Inoltro Buste non Riscontrate", false)) {
                return false;
            }
            if (integman.equals("custom") && (nomeintegman == null || nomeintegman.equals(""))) {
                this.pd.setMessage("Indicare un nome per il tipo autenticazione");
                return false;
            }
            String configurazioneCachesTmp = this.getParameter("configCaches");
            boolean isAllHiddenConfigurazione = ServletUtils.isCheckBoxEnabled((String)configurazioneCachesTmp);
            boolean bl = isAllHiddenCache = !isAllHiddenConfigurazione;
            if (!this.registryCheckDataCache()) {
                return false;
            }
            if (!this.configurazioneCheckDataCache()) {
                return false;
            }
            if (!this.datiAutorizzazioneCheckDataCache()) {
                return false;
            }
            if (!this.datiAutenticazioneCheckDataCache()) {
                return false;
            }
            if (!this.datiGestioneTokenCheckDataCache()) {
                return false;
            }
            if (!this.datiAttributeAuthorityCheckDataCache()) {
                return false;
            }
            if (!this.datiKeystoreCheckDataCache()) {
                return false;
            }
            if (!isAllHiddenCache && !this.controlloTrafficoCheckDataCache()) {
                return false;
            }
            if (!this.datiResponseCachingCheckDataCache()) {
                return false;
            }
            if (!this.datiGestoreConsegnaApplicativiCheckDataCache()) {
                return false;
            }
            if (!this.checkDataURLInvocazione()) {
                return false;
            }
            if (!this.checkDataCors()) {
                return false;
            }
            if (!this.checkDataResponseCaching()) {
                return false;
            }
            return this.canaliCheckData();
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    private boolean canaliCheckData() throws Exception {
        try {
            List canaleList;
            String canaliEnabledTmp = this.getParameter("canaliStato");
            boolean canaliEnabled = ServletUtils.isCheckBoxEnabled((String)canaliEnabledTmp);
            Configurazione configurazione = this.confCore.getConfigurazioneGenerale();
            CanaliConfigurazione gestioneCanali = configurazione.getGestioneCanali();
            List list = canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : null;
            if (canaliEnabled) {
                String canaliNome = this.getParameter("canaliNome");
                String canaliDescrizione = this.getParameter("canaliDescrizione");
                String canaliDefault = this.getParameter("canaliDefault");
                if (canaleList == null || canaleList.size() == 0) {
                    if (!this.canaleDatiCheckData(canaliNome, canaliDescrizione)) {
                        return false;
                    }
                } else {
                    if (StringUtils.isEmpty((CharSequence)canaliDefault)) {
                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Default"));
                        return false;
                    }
                    boolean found = false;
                    for (CanaleConfigurazione canaleConfigurazione : canaleList) {
                        if (!canaleConfigurazione.getNome().equals(canaliDefault)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.pd.setMessage("Il Canale di default selezionato non &egrave' registrato nel sistema.");
                        return false;
                    }
                }
            } else {
                boolean oldEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
                StringBuilder inUsoMessage = new StringBuilder();
                if (oldEnabled && canaleList != null) {
                    for (CanaleConfigurazione canale : canaleList) {
                        if (!ConfigurazioneCanaliUtilities.isCanaleInUsoRegistro(canale, this.confCore, this, inUsoMessage, "<br/>")) continue;
                        this.pd.setMessage(MessageFormat.format("Impossibile disabilitare la configurazione dei Canali perch&egrave; : {0}", inUsoMessage.toString()));
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    private boolean canaleDatiCheckData(String canaliNome, String canaliDescrizione) throws Exception {
        if (StringUtils.isEmpty((CharSequence)canaliNome)) {
            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Nome"));
            return false;
        }
        if (!this.checkSpazi(canaliNome, "Nome")) {
            return false;
        }
        if (!this.checkLength255(canaliNome, "Nome")) {
            return false;
        }
        return this.checkLength255(canaliDescrizione, "Descrizione");
    }

    public boolean registryCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheRegistry");
            String dimensionecache = this.getParameter("dimensionecacheRegistry");
            String algoritmocache = this.getParameter("algoritmocacheRegistry");
            String idlecache = this.getParameter("idlecacheRegistry");
            String lifecache = this.getParameter("lifecacheRegistry");
            return this.checkDatiCache("Cache (Registro API)", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean configurazioneCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheConfig");
            String dimensionecache = this.getParameter("dimensionecacheConfig");
            String algoritmocache = this.getParameter("algoritmocacheConfig");
            String idlecache = this.getParameter("idlecacheConfig");
            String lifecache = this.getParameter("lifecacheConfig");
            return this.checkDatiCache("ConfigurazionePdD", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean datiAutorizzazioneCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheAuthz");
            String dimensionecache = this.getParameter("dimensionecacheAuthz");
            String algoritmocache = this.getParameter("algoritmocacheAuthz");
            String idlecache = this.getParameter("idlecacheAuthz");
            String lifecache = this.getParameter("lifecacheAuthz");
            return this.checkDatiCache("DatiAutorizzazione", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean datiAutenticazioneCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheAuthn");
            String dimensionecache = this.getParameter("dimensionecacheAuthn");
            String algoritmocache = this.getParameter("algoritmocacheAuthn");
            String idlecache = this.getParameter("idlecacheAuthn");
            String lifecache = this.getParameter("lifecacheAuthn");
            return this.checkDatiCache("DatiAutenticazione", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean datiGestioneTokenCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheToken");
            String dimensionecache = this.getParameter("dimensionecacheToken");
            String algoritmocache = this.getParameter("algoritmocacheToken");
            String idlecache = this.getParameter("idlecacheToken");
            String lifecache = this.getParameter("lifecacheToken");
            return this.checkDatiCache("GestioneToken", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean datiAttributeAuthorityCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheAA");
            String dimensionecache = this.getParameter("dimensionecacheAA");
            String algoritmocache = this.getParameter("algoritmocacheAA");
            String idlecache = this.getParameter("idlecacheAA");
            String lifecache = this.getParameter("lifecacheAA");
            return this.checkDatiCache("AttributeAuthority", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean datiKeystoreCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheKeystore");
            String dimensionecache = this.getParameter("dimensionecacheKeystore");
            String algoritmocache = this.getParameter("algoritmocacheKeystore");
            String idlecache = this.getParameter("idlecacheKeystore");
            String lifecache = this.getParameter("lifecacheKeystore");
            boolean esito = this.checkDatiCache("Keystore", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
            if (!esito) {
                return false;
            }
            String crllifecache = this.getParameter("crllifecacheKeystore");
            return !statocache.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) || crllifecache == null || crllifecache.equals("") || this.checkNumber(crllifecache, "CRL/OCSP Life Time (Secondi)(" + crllifecache + ")", false);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean controlloTrafficoCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("CTCacheStato");
            String dimensionecache = this.getParameter("CTCacheDimensione");
            String algoritmocache = this.getParameter("CTCacheAlgoritmo");
            String idlecache = this.getParameter("CTCacheIdleTime");
            String lifecache = this.getParameter("CTCacheLifeTime");
            return this.checkDatiCache("Cache (Controllo Traffico - Dati Statistici)", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean datiGestoreConsegnaApplicativiCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheKeystore");
            String dimensionecache = this.getParameter("dimensionecacheKeystore");
            String algoritmocache = this.getParameter("algoritmocacheKeystore");
            String idlecache = this.getParameter("idlecacheKeystore");
            String lifecache = this.getParameter("lifecacheKeystore");
            return this.checkDatiCache("LoadBalancer", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean datiResponseCachingCheckDataCache() throws Exception {
        try {
            String statocache = this.getParameter("statocacheRisposte");
            String dimensionecache = this.getParameter("dimensionecacheRisposte");
            String algoritmocache = this.getParameter("algoritmocacheRisposte");
            String idlecache = this.getParameter("idlecacheRisposte");
            String lifecache = this.getParameter("lifecacheRisposte");
            return this.checkDatiCache("ResponseCaching", statocache, dimensionecache, algoritmocache, idlecache, lifecache);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareDiagnosticaAppenderList(List<OpenspcoopAppender> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneDiagnosticaAppender", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Appender Messaggi Diagnostici", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Tipo", "Propriet&agrave;"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    OpenspcoopAppender oa = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pOaId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + oa.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneDiagnosticaAppenderChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId});
                    de.setValue(oa.getTipo());
                    de.setIdToRemove("" + oa.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("configurazioneDiagnosticaAppenderPropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId});
                    if (contaListe != null && contaListe.booleanValue()) {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(oa.sizePropertyList()));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean diagnosticaAppenderCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String tipo = this.getParameter("tipo");
            if (tipo == null || "".equals(tipo)) {
                this.pd.setMessage("Il campo Tipo deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoAppender = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                MessaggiDiagnostici md = newConfigurazione.getMessaggiDiagnostici();
                if (md != null) {
                    OpenspcoopAppender oa = null;
                    for (int j = 0; j < md.sizeOpenspcoopAppenderList(); ++j) {
                        oa = md.getOpenspcoopAppender(j);
                        if (!tipo.equals(oa.getTipo())) continue;
                        trovatoAppender = true;
                        break;
                    }
                }
                if (trovatoAppender) {
                    this.pd.setMessage("Esiste gi&agrave; un Appender con tipo " + tipo);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareDiagnosticaAppenderPropList(OpenspcoopAppender oa, List<Property> lista) throws Exception {
        try {
            org.openspcoop2.web.lib.mvc.Parameter pOaId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + oa.getId());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneDiagnosticaAppenderProperties", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId});
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Appender Messaggi Diagnostici", "configurazioneDiagnosticaAppenderList.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Propriet&agrave; di " + oa.getTipo(), null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Nome", "Valore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    Property oap = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pIdProp = new org.openspcoop2.web.lib.mvc.Parameter("idprop", "" + oap.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneDiagnosticaAppenderPropertiesChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pOaId, pIdProp});
                    de.setValue(oap.getNome());
                    de.setIdToRemove("" + oap.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(oap.getValore());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean diagnosticaAppenderPropCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String nome = this.getParameter("nome");
            String valore = this.getParameter("valore");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Il campo Nome deve essere specificato.");
                return false;
            }
            if (valore == null || "".equals(valore)) {
                this.pd.setMessage("Il campo Valore deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovataProp = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                MessaggiDiagnostici md = newConfigurazione.getMessaggiDiagnostici();
                OpenspcoopAppender oa = null;
                for (int j = 0; j < md.sizeOpenspcoopAppenderList() && idInt != (oa = md.getOpenspcoopAppender(j)).getId().intValue(); ++j) {
                }
                if (oa == null) {
                    throw new DriverControlStationException("Appender non trovato");
                }
                Property oap = null;
                for (int i = 0; i < oa.sizePropertyList(); ++i) {
                    oap = oa.getProperty(i);
                    if (!nome.equals(oap.getNome())) continue;
                    trovataProp = true;
                    break;
                }
                if (trovataProp) {
                    this.pd.setMessage("Esiste gi&agrave; una Propriet\u00e0 con nome " + nome);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareDiagnosticaDatasourceList(List<OpenspcoopSorgenteDati> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneDiagnosticaDatasource", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Sorgenti Dati Messaggi Diagnostici", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Nome", "Nome Jndi", "Tipo Database", "Propriet&agrave;"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    OpenspcoopSorgenteDati od = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + od.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneDiagnosticaDatasourceChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
                    de.setValue(od.getNome());
                    de.setIdToRemove("" + od.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(od.getNomeJndi());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(od.getTipoDatabase());
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("configurazioneDiagnosticaDatasourcePropertiesList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
                    if (contaListe != null && contaListe.booleanValue()) {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(od.sizePropertyList()));
                    } else {
                        ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean diagnosticaDatasourceCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String nome = this.getParameter("nome");
            String nomeJndi = this.getParameter("nomeJndi");
            String tipoDatabase = this.getParameter("tipoDatabase");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Il campo Nome deve essere specificato.");
                return false;
            }
            if (nomeJndi == null || "".equals(nomeJndi)) {
                this.pd.setMessage("Il campo Nome Jndi deve essere specificato.");
                return false;
            }
            if (tipoDatabase == null || "".equals(tipoDatabase)) {
                this.pd.setMessage("Il campo Tipo Database deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoDatasource = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                MessaggiDiagnostici md = newConfigurazione.getMessaggiDiagnostici();
                if (md != null) {
                    List lista = md.getOpenspcoopSorgenteDatiList();
                    OpenspcoopSorgenteDati od = null;
                    for (int j = 0; j < md.sizeOpenspcoopSorgenteDatiList(); ++j) {
                        od = (OpenspcoopSorgenteDati)lista.get(j);
                        if (!nome.equals(od.getNome())) continue;
                        trovatoDatasource = true;
                        break;
                    }
                }
                if (trovatoDatasource) {
                    this.pd.setMessage("Esiste gi&agrave; un sorgente dati con nome " + nome);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareDiagnosticaDatasourcePropList(OpenspcoopSorgenteDati od, List<Property> lista) throws Exception {
        try {
            org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + od.getId());
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneDiagnosticaDatasourceProperties", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[]{pId});
            if (lista == null) {
                this.pd.setNumEntries(0);
            } else {
                this.pd.setNumEntries(lista.size());
            }
            this.pd.setSearchDescription("");
            this.pd.setSearch("off");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Tracciamento", "configurazioneTracciamentoTransazioni.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Elenco Sorgenti Dati Messaggi Diagnostici", "configurazioneDiagnosticaDatasourceList.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Propriet&agrave; di " + od.getNome(), null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            String[] labels = new String[]{"Nome", "Valore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    Property odp = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pOdpId = new org.openspcoop2.web.lib.mvc.Parameter("idprop", "" + odp.getId());
                    DataElement de = new DataElement();
                    de.setUrl("configurazioneDiagnosticaDatasourcePropertiesChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pId, pOdpId});
                    de.setValue(odp.getNome());
                    de.setIdToRemove("" + odp.getId());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(odp.getValore());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean diagnosticaDatasourcePropCheckData(TipoOperazione tipoOp) throws Exception {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String nome = this.getParameter("nome");
            String valore = this.getParameter("valore");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Il campo Nome deve essere specificato.");
                return false;
            }
            if (valore == null || "".equals(valore)) {
                this.pd.setMessage("Il campo Valore deve essere specificato.");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean trovataProp = false;
                Configurazione newConfigurazione = this.core.getConfigurazioneGenerale();
                MessaggiDiagnostici md = newConfigurazione.getMessaggiDiagnostici();
                List lista = md.getOpenspcoopSorgenteDatiList();
                OpenspcoopSorgenteDati od = null;
                for (int j = 0; j < md.sizeOpenspcoopSorgenteDatiList() && idInt != (od = (OpenspcoopSorgenteDati)lista.get(j)).getId().intValue(); ++j) {
                }
                if (od == null) {
                    throw new DriverControlStationException("Datasource non trovato");
                }
                List lista1 = od.getPropertyList();
                Property odp = null;
                for (int i = 0; i < od.sizePropertyList(); ++i) {
                    odp = (Property)lista1.get(i);
                    if (!nome.equals(odp.getNome())) continue;
                    trovataProp = true;
                    break;
                }
                if (trovataProp) {
                    this.pd.setMessage("Esiste gi&agrave; una Propriet\u00e0 con nome " + nome);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addValoriRottaToDati(TipoOperazione tipoOp, String nome, String tipo, String tiporotta, String registrorotta, String[] registriList, String[] registriListLabel, List<DataElement> dati, String tiposoggrotta, String nomesoggrotta, String[] tipiSoggettiLabel, String[] tipiSoggettiLabelPerProtocollo) throws DriverRegistroServiziException {
        DataElement de = new DataElement();
        de.setLabel("Destinatario");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setSelected(tipo);
        de.setValues(tipiSoggettiLabel);
        de.setType(DataElementType.SELECT);
        de.setName("tipo");
        de.setPostBack(true);
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("nome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Rotta");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] tipoR = new String[]{"gateway", "registro"};
        de = new DataElement();
        de.setLabel("Tipo");
        de.setType(DataElementType.SELECT);
        de.setName("tiporotta");
        de.setValues(tipoR);
        de.setSelected(tiporotta);
        de.setPostBack(true);
        dati.add(de);
        if (tiporotta.equals("gateway")) {
            de = new DataElement();
            de.setLabel("Tipo Soggetto");
            de.setSelected(tiposoggrotta);
            de.setValues(tipiSoggettiLabelPerProtocollo);
            de.setType(DataElementType.SELECT);
            de.setName("tiposoggrotta");
            de.setSize(this.getSize());
            de.setRequired(true);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome Soggetto");
            de.setValue(nomesoggrotta);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("nomesoggrotta");
            de.setSize(this.getSize());
            de.setRequired(true);
            dati.add(de);
        }
        if (tiporotta.equals("registro")) {
            de = new DataElement();
            de.setLabel("Registro");
            de.setType(DataElementType.SELECT);
            de.setName("registrorotta");
            de.setValues(registriList);
            de.setLabels(registriListLabel);
            de.setSelected(registrorotta);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addRoutingToDati(TipoOperazione tipoOp, String tiporotta, String tiposoggrotta, String nomesoggrotta, String registrorotta, String rottaenabled, String[] registriList, String[] registriListLabel, String[] tipiSoggettiLabel, List<DataElement> dati) throws DriverRegistroServiziException {
        if (dati == null) {
            throw new DriverRegistroServiziException("Dati is null");
        }
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Routing delle Buste");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        DataElement de = new DataElement();
        String[] tipoRouting = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
        de = new DataElement();
        de.setLabel("Stato");
        de.setType(DataElementType.SELECT);
        de.setName("rottaenabled");
        de.setValues(tipoRouting);
        de.setSelected(rottaenabled);
        de.setPostBack(true);
        dati.add(de);
        if (rottaenabled.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO)) {
            de = new DataElement();
            de.setLabel("Rotta di Default");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] tipoR = new String[]{"gateway", "registro"};
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.SELECT);
            de.setName("tiporotta");
            de.setValues(tipoR);
            de.setSelected(tiporotta);
            de.setPostBack(true);
            dati.add(de);
            if (tiporotta.equals("gateway")) {
                de = new DataElement();
                de.setLabel("Tipo Soggetto");
                de.setType(DataElementType.SELECT);
                de.setName("tiposoggrotta");
                de.setValues(tipiSoggettiLabel);
                de.setSelected(tiposoggrotta);
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Nome Soggetto");
                de.setValue(nomesoggrotta);
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("nomesoggrotta");
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
            }
            if (tiporotta.equals("registro")) {
                de = new DataElement();
                de.setLabel("Registro");
                de.setType(DataElementType.SELECT);
                de.setName("registrorotta");
                de.setValues(registriList);
                de.setLabels(registriListLabel);
                de.setSelected(registrorotta);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Rotte statiche");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneRouteList.do");
            de.setValue("Destinazioni");
            dati.add(de);
        }
        dati = this.addParameterApplicaModifica(dati);
        return dati;
    }

    public List<DataElement> addRegistroToDati(TipoOperazione tipoOP, String nome, String location, String tipo, String utente, String password, String confpw, List<DataElement> dati) {
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Registro");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        DataElement de = new DataElement();
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (TipoOperazione.ADD.equals((Object)tipoOP)) {
            de.setType(DataElementType.TEXT_EDIT);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Location");
        de.setValue(location);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("location");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        String[] tipoReg = new String[]{"xml", "db"};
        de = new DataElement();
        de.setLabel("Tipo");
        de.setType(DataElementType.SELECT);
        de.setName("tipo");
        de.setValues(tipoReg);
        de.setSelected(tipo);
        de.setPostBack(true);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addConfigurazioneToDati(boolean allHidden, String inoltromin, String stato, String controllo, String severita, String severita_log4j, String integman, String nomeintegman, String profcoll, String connessione, String utilizzo, String validman, String gestman, String registrazioneTracce, String dumpPD, String dumpPA, String xsd, String tipoValidazione, String confPers, Configurazione configurazione, List<DataElement> dati, String applicaMTOM, String urlInvocazionePA, String urlInvocazionePD, boolean multitenantEnabled, String multitenantSoggettiFruizioni, String multitenantSoggettiErogazioni, boolean editModeEnabled, boolean corsStato, TipoGestioneCORS corsTipo, boolean corsAllAllowOrigins, boolean corsAllAllowHeaders, boolean corsAllAllowMethods, String corsAllowHeaders, String corsAllowOrigins, String corsAllowMethods, boolean corsAllowCredential, String corsExposeHeaders, boolean corsMaxAge, int corsMaxAgeSeconds, boolean responseCachingEnabled, int responseCachingSeconds, boolean responseCachingMaxResponseSize, long responseCachingMaxResponseSizeBytes, boolean responseCachingDigestUrlInvocazione, boolean responseCachingDigestHeaders, boolean responseCachingDigestPayload, String responseCachingDigestHeadersNomiHeaders, StatoFunzionalitaCacheDigestQueryParameter responseCachingDigestQueryParameter, String responseCachingDigestNomiParametriQuery, boolean responseCachingCacheControlNoCache, boolean responseCachingCacheControlMaxAge, boolean responseCachingCacheControlNoStore, boolean visualizzaLinkConfigurazioneRegola, String servletResponseCachingConfigurazioneRegolaList, List<org.openspcoop2.web.lib.mvc.Parameter> paramsResponseCachingConfigurazioneRegolaList, int numeroResponseCachingConfigurazioneRegola, int numeroRegoleProxyPass, boolean canaliEnabled, int numeroCanali, int numeroNodi, String canaliNome, String canaliDescrizione, List<CanaleConfigurazione> canaleList, String canaliDefault, int numeroArchiviPlugins, int numeroClassiPlugins) throws Exception {
        DataElement de = new DataElement();
        if (!this.isModalitaCompleta() || allHidden) {
            de = new DataElement();
            de.setLabel("Cadenza (minuti)");
            de.setValue(inoltromin);
            de.setType(DataElementType.HIDDEN);
            de.setName("inoltromin");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.HIDDEN);
            de.setName("stato");
            de.setValue(stato);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Controllo");
            de.setType(DataElementType.HIDDEN);
            de.setName("controllo");
            de.setValue(controllo);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Profilo di collaborazione");
            de.setType(DataElementType.HIDDEN);
            de.setName("profcoll");
            de.setValue(profcoll);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Manifest attachments");
            de.setType(DataElementType.HIDDEN);
            de.setName("validman");
            de.setValue(validman);
            dati.add(de);
        } else {
            de.setLabel("Inoltro Buste non Riscontrate");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Cadenza (minuti)");
            de.setValue(inoltromin);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("inoltromin");
            de.setRequired(true);
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Validazione Buste");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] tipoStato = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO, "warningOnly"};
            de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.SELECT);
            de.setName("stato");
            de.setValues(tipoStato);
            de.setSelected(stato);
            dati.add(de);
            String[] tipoControllo = new String[]{"rigido", "normale"};
            de = new DataElement();
            de.setLabel("Controllo");
            de.setType(DataElementType.SELECT);
            de.setName("controllo");
            de.setValues(tipoControllo);
            de.setSelected(controllo);
            dati.add(de);
            String[] tipoPF = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
            de = new DataElement();
            de.setLabel("Profilo di collaborazione");
            de.setType(DataElementType.SELECT);
            de.setName("profcoll");
            de.setValues(tipoPF);
            de.setSelected(profcoll);
            dati.add(de);
            String[] tipoVM = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
            de = new DataElement();
            de.setLabel("Manifest attachments");
            de.setType(DataElementType.SELECT);
            de.setName("validman");
            de.setValues(tipoVM);
            de.setSelected(validman);
            dati.add(de);
        }
        this.addMessaggiDiagnosticiToDatiAsHidden(severita, severita_log4j, dati);
        this.addTracciamentoToDatiAsHidden(registrazioneTracce, configurazione, dati);
        this.addRegistrazioneMessaggiToDatiAsHidden(dumpPD, dumpPA, configurazione, dati);
        if (!this.isModalitaCompleta() || allHidden) {
            de = new DataElement();
            de.setLabel("Connessione");
            de.setType(DataElementType.HIDDEN);
            de.setName("connessione");
            de.setValue("reply");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Utilizzo");
            de.setType(DataElementType.HIDDEN);
            de.setName("utilizzo");
            de.setValue(CostantiConfigurazione.DISABILITATO.toString());
            de.setSelected(utilizzo);
            dati.add(de);
        } else {
            de = new DataElement();
            de.setLabel("Validazione Contenuti Applicativi");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] tipoXsd = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO, "warningOnly"};
            de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.SELECT);
            de.setName("xsd");
            de.setValues(tipoXsd);
            de.setPostBack(true);
            if (xsd == null) {
                de.setSelected(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
            } else {
                de.setSelected(xsd);
            }
            dati.add(de);
            if (ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(xsd) || "warningOnly".equals(xsd)) {
                String[] tipi_validazione = new String[]{"xsd", "wsdl"};
                de = new DataElement();
                de.setLabel("Tipo");
                de.setType(DataElementType.SELECT);
                de.setName("tipo_validazione");
                de.setValues(tipi_validazione);
                if (tipoValidazione == null) {
                    de.setSelected("xsd");
                } else {
                    de.setSelected(tipoValidazione);
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("Accetta MTOM");
                if (this.isModalitaAvanzata()) {
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)applicaMTOM) || CostantiRegistroServizi.ABILITATO.equals(applicaMTOM)) {
                        de.setSelected(true);
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(applicaMTOM);
                }
                de.setName("applicaMTOMReq");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Risposte");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] tipoConn = new String[]{"new", "reply"};
            de = new DataElement();
            de.setLabel("Connessione");
            de.setType(DataElementType.SELECT);
            de.setName("connessione");
            de.setValues(tipoConn);
            de.setSelected(connessione);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Indirizzo Telematico");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] tipoU = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
            de = new DataElement();
            de.setLabel("Utilizzo");
            de.setType(DataElementType.SELECT);
            de.setName("utilizzo");
            de.setValues(tipoU);
            de.setSelected(utilizzo);
            dati.add(de);
        }
        if (this.isModalitaCompleta() && !allHidden) {
            de = new DataElement();
            de.setLabel("Manifest Attachments");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        String[] tipoGM = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
        de = new DataElement();
        de.setName("gestman");
        de.setLabel("Gestione");
        if (!this.isModalitaCompleta() || allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoGM);
            de.setSelected(gestman);
        }
        de.setValue(gestman);
        dati.add(de);
        if (!allHidden) {
            de = new DataElement();
            de.setLabel("Multi-Tenant");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        boolean existsMoreThanOneSoggettoOperativoPerProtocollo = false;
        List<Soggetto> l = this.soggettiCore.getSoggettiOperativi();
        HashMap<String, Integer> countSoggettoOperativiByProtocol = new HashMap<String, Integer>();
        if (l != null && !l.isEmpty()) {
            for (Soggetto soggetto : l) {
                String protocol = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggetto.getTipo());
                int count = 0;
                if (countSoggettoOperativiByProtocol.containsKey(protocol)) {
                    count = (Integer)countSoggettoOperativiByProtocol.remove(protocol);
                }
                if (++count > 1) {
                    existsMoreThanOneSoggettoOperativoPerProtocollo = true;
                    break;
                }
                countSoggettoOperativiByProtocol.put(protocol, count);
            }
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("ConfMTStato");
        if (allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else if (!existsMoreThanOneSoggettoOperativoPerProtocollo) {
            de.setType(DataElementType.SELECT);
            de.setPostBack(true);
            de.setValues(ConfigurazioneCostanti.STATI);
            de.setSelected(multitenantEnabled ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setValue(multitenantEnabled ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
        dati.add(de);
        if (multitenantEnabled) {
            String multi;
            String[] labels2;
            String[] values;
            boolean linkSoggettiFiltroDominioImpostato = false;
            if (!allHidden && linkSoggettiFiltroDominioImpostato) {
                de = new DataElement();
                de.setValue("Soggetti");
                de.setType(DataElementType.LINK);
                de.setUrl("soggettiList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("internalDomain", "true")});
                dati.add(de);
            }
            if (!allHidden) {
                de = new DataElement();
                de.setLabel("Fruizioni");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Soggetto Erogatore");
            de.setName("ConfMTFruSoggEro");
            if (!allHidden && editModeEnabled) {
                de.setType(DataElementType.SELECT);
                values = MultitenantSoggettiFruizioni.toEnumNameArray();
                labels2 = MultitenantSoggettiFruizioni.toArray();
                de.setValues(values);
                de.setLabels(labels2);
                de.setSelected(multitenantSoggettiFruizioni);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue(multitenantSoggettiFruizioni);
            dati.add(de);
            if (!editModeEnabled) {
                de = new DataElement();
                de.setLabel("Soggetto Erogatore");
                de.setName("ConfMTFruSoggEro__label");
                multi = MultitenantSoggettiFruizioni.SOLO_SOGGETTI_ESTERNI.getValue();
                try {
                    multi = MultitenantSoggettiFruizioni.valueOf(multitenantSoggettiFruizioni).getValue();
                }
                catch (Exception labels2) {
                    // empty catch block
                }
                de.setValue(multi);
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                }
                dati.add(de);
            }
            if (!allHidden) {
                de = new DataElement();
                de.setLabel("Erogazioni");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Soggetti Fruitori");
            de.setName("ConfMTEroSoggFru");
            if (!allHidden && editModeEnabled) {
                de.setType(DataElementType.SELECT);
                values = MultitenantSoggettiErogazioni.toEnumNameArray();
                labels2 = MultitenantSoggettiErogazioni.toArray();
                de.setValues(values);
                de.setLabels(labels2);
                de.setSelected(multitenantSoggettiErogazioni);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue(multitenantSoggettiErogazioni);
            dati.add(de);
            if (!editModeEnabled) {
                de = new DataElement();
                de.setLabel("Soggetti Fruitori");
                de.setName("ConfMTEroSoggFru__label");
                multi = MultitenantSoggettiErogazioni.SOLO_SOGGETTI_ESTERNI.getValue();
                try {
                    multi = MultitenantSoggettiErogazioni.valueOf(multitenantSoggettiErogazioni).getValue();
                }
                catch (Exception labels3) {
                    // empty catch block
                }
                de.setValue(multi);
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                }
                dati.add(de);
            }
        }
        if (!allHidden) {
            de = new DataElement();
            de.setLabel("URL di Invocazione API");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Base URL");
        de.setName("protocolConfigUrlPA");
        if (allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        }
        de.setValue(urlInvocazionePA);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Base URL Fruizione");
        de.setName("protocolConfigUrlPD");
        if (allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(false);
        }
        de.setValue(urlInvocazionePD);
        dati.add(de);
        if (!allHidden) {
            boolean contaListeFromSession;
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneProxyPassRegolaList.do");
            boolean bl = contaListeFromSession = ServletUtils.getContaListeFromSession((HttpSession)this.session) != null ? ServletUtils.getContaListeFromSession((HttpSession)this.session) : false;
            if (contaListeFromSession) {
                de.setValue("Regole Proxy Pass (" + numeroRegoleProxyPass + ")");
            } else {
                de.setValue("Regole Proxy Pass");
            }
            dati.add(de);
            String send = "exporterArchivi?tipoExport=" + ArchiveType.CONFIGURAZIONE_URL_INVOCAZIONE.name();
            List<String> protocolli = this.confCore.getProtocolli(this.request, this.session, true);
            String protocollo = protocolli.get(0);
            if (protocollo != null && !"".equals(protocollo)) {
                send = send + "&protocollo=" + protocollo;
            }
            ExporterUtils exporterUtils = new ExporterUtils(this.archiviCore);
            List<ExportMode> exportModes = exporterUtils.getExportModesCompatibleWithAllProtocol(protocolli, ArchiveType.CONFIGURAZIONE_URL_INVOCAZIONE);
            String exportMode = null;
            if (exportModes != null) {
                exportMode = exportModes.contains(Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE) ? Costanti.OPENSPCOOP_EXPORT_ARCHIVE_MODE.toString() : exportModes.get(0).toString();
            }
            if (exportMode != null && !"".equals(exportMode)) {
                send = send + "&tipologiaArchivio=" + exportMode;
            }
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl(send);
            de.setValue("Esporta Configurazione");
            dati.add(de);
        }
        this.addConfigurazioneCorsToDati(dati, corsStato, corsTipo, corsAllAllowOrigins, corsAllAllowHeaders, corsAllAllowMethods, corsAllowHeaders, corsAllowOrigins, corsAllowMethods, corsAllowCredential, corsExposeHeaders, corsMaxAge, corsMaxAgeSeconds, true, allHidden);
        this.addResponseCachingToDati(dati, responseCachingEnabled, responseCachingSeconds, responseCachingMaxResponseSize, responseCachingMaxResponseSizeBytes, responseCachingDigestUrlInvocazione, responseCachingDigestHeaders, responseCachingDigestPayload, true, responseCachingDigestHeadersNomiHeaders, responseCachingDigestQueryParameter, responseCachingDigestNomiParametriQuery, responseCachingCacheControlNoCache, responseCachingCacheControlMaxAge, responseCachingCacheControlNoStore, visualizzaLinkConfigurazioneRegola, servletResponseCachingConfigurazioneRegolaList, paramsResponseCachingConfigurazioneRegolaList, numeroResponseCachingConfigurazioneRegola, allHidden);
        this.addConfigurazioneCanaliToDati(dati, canaliEnabled, numeroCanali, numeroNodi, canaliNome, canaliDescrizione, true, allHidden, canaleList, canaliDefault);
        boolean integrationManagerSupported = this.confCore.isIntegrationManagerEnabled();
        if (integrationManagerSupported && !this.isModalitaStandard() && !allHidden) {
            de = new DataElement();
            de.setLabel("Integration Manager");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        int totEl = ConfigurazioneCostanti.PARAMETRI_CONFIGURAZIONE_IM.length;
        if (confPers.equals("true")) {
            ++totEl;
        }
        String[] tipoIM = new String[totEl];
        for (int i = 0; i < ConfigurazioneCostanti.PARAMETRI_CONFIGURAZIONE_IM.length; ++i) {
            tipoIM[i] = ConfigurazioneCostanti.PARAMETRI_CONFIGURAZIONE_IM[i];
        }
        if (confPers.equals("true")) {
            tipoIM[totEl - 1] = "custom";
        }
        de = new DataElement();
        de.setName("integman");
        de.setLabel("Tipo autenticazione");
        if (!integrationManagerSupported || this.isModalitaStandard() || allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoIM);
            de.setSelected(integman);
            de.setPostBack(true);
        }
        de.setValue(integman);
        dati.add(de);
        de = new DataElement();
        de.setLabel("");
        if (!integrationManagerSupported || this.isModalitaStandard() || allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else if (integman == null || !integman.equals("custom")) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
        }
        de.setName("nomeintegman");
        de.setValue(nomeintegman);
        dati.add(de);
        boolean pluginsAbilitati = this.core.isConfigurazionePluginsEnabled();
        if (!allHidden && pluginsAbilitati && !this.isModalitaStandard()) {
            boolean contaListeFromSession = ServletUtils.getContaListeFromSession((HttpSession)this.session) != null ? ServletUtils.getContaListeFromSession((HttpSession)this.session) : false;
            de = new DataElement();
            de.setLabel("Plugins");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazionePluginsArchiviList.do");
            if (contaListeFromSession) {
                de.setValue("Registro Archivi (" + numeroArchiviPlugins + ")");
            } else {
                de.setValue("Registro Archivi");
            }
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazionePluginsClassiList.do");
            if (contaListeFromSession) {
                de.setValue("Registro Classi (" + numeroClassiPlugins + ")");
            } else {
                de.setValue("Registro Classi");
            }
            dati.add(de);
        }
        boolean handlerAbilitati = this.core.isConfigurazioneHandlersEnabled();
        if (!allHidden && handlerAbilitati && !this.isModalitaStandard()) {
            this.visualizzaLinkHandlers(dati, true, null, null, null);
        }
        if (!allHidden && !multitenantEnabled) {
            de = new DataElement();
            de.setLabel("Gestione Profilo");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        ProtocolFactoryManager pManager = ProtocolFactoryManager.getInstance();
        MapReader mapPFactory = pManager.getProtocolFactories();
        Enumeration protocolName = mapPFactory.keys();
        ArrayList<String> protocolliDispondibili = new ArrayList<String>();
        while (protocolName.hasMoreElements()) {
            String protocollo = (String)protocolName.nextElement();
            protocolliDispondibili.add(protocollo);
        }
        for (String protocollo : ProtocolUtils.orderProtocolli(protocolliDispondibili)) {
            IProtocolFactory pFactory = (IProtocolFactory)mapPFactory.get((Object)protocollo);
            InformazioniProtocollo infoProt = pFactory.getInformazioniProtocol();
            User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
            String userLogin = user.getLogin();
            if (mapPFactory.size() > 1 && !allHidden && !multitenantEnabled) {
                de = new DataElement();
                de.setLabel(infoProt.getLabel());
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Nome");
            de.setName("protocolConfigName" + protocollo);
            de.setType(DataElementType.HIDDEN);
            de.setValue(protocollo);
            dati.add(de);
            if (multitenantEnabled) continue;
            IDSoggetto idSoggetto = this.soggettiCore.getSoggettoOperativoDefault(userLogin, protocollo);
            long idSoggettoLong = this.soggettiCore.getIdSoggetto(idSoggetto.getNome(), idSoggetto.getTipo());
            de = new DataElement();
            de.setLabel("Soggetto");
            de.setName("protocolConfigSoggetto" + protocollo);
            de.setValue(this.getLabelNomeSoggetto(protocollo, idSoggetto.getTipo(), idSoggetto.getNome()));
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.TEXT);
            }
            dati.add(de);
            if (allHidden) continue;
            de = new DataElement();
            de.setValue("Visualizza Dati Soggetto");
            de.setType(DataElementType.LINK);
            de.setUrl("soggettiChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("id", "" + idSoggettoLong), new org.openspcoop2.web.lib.mvc.Parameter("nomeprov", idSoggetto.getNome()), new org.openspcoop2.web.lib.mvc.Parameter("tipoprov", idSoggetto.getTipo()), new org.openspcoop2.web.lib.mvc.Parameter("modificaDatiOperativo", "true")});
            dati.add(de);
        }
        if (!allHidden && this.isModalitaCompleta()) {
            de = new DataElement();
            de.setLabel("Registro dei Servizi");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneAccessoRegistroServizi.do");
            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tabella di Routing");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneRouting.do");
            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            dati.add(de);
        }
        if (!allHidden) {
            de = new DataElement();
            de.setLabel("Propriet&agrave; di Sistema");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneSystemPropertiesList.do");
            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            dati.add(de);
        }
        return dati;
    }

    private void addConfigurazioneCanaliToDati(List<DataElement> dati, boolean canaliEnabled, int numeroCanali, int numeroNodi, String canaliNome, String canaliDescrizione, boolean addTitle, boolean allHidden, List<CanaleConfigurazione> canaleList, String canaliDefault) throws Exception {
        DataElement de;
        boolean contaListeFromSession;
        boolean bl = contaListeFromSession = ServletUtils.getContaListeFromSession((HttpSession)this.session) != null ? ServletUtils.getContaListeFromSession((HttpSession)this.session) : false;
        if (!allHidden && addTitle) {
            de = new DataElement();
            de.setLabel("Canali");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        boolean funzionalitaDisabilitabile = true;
        if (canaliEnabled && canaleList != null) {
            for (CanaleConfigurazione canale : canaleList) {
                if (!ConfigurazioneCanaliUtilities.isCanaleInUsoRegistro(canale, this.confCore, this, new StringBuilder(), "<br/>")) continue;
                funzionalitaDisabilitabile = false;
                break;
            }
        }
        de = new DataElement();
        de.setLabel(addTitle ? "Stato" : "");
        de.setName("canaliStato");
        if (allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else if (!funzionalitaDisabilitabile) {
            de.setType(DataElementType.TEXT);
        } else {
            de.setType(DataElementType.SELECT);
            de.setPostBack(true);
            de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA);
            de.setSelected(canaliEnabled ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
        }
        de.setValue(canaliEnabled ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
        dati.add(de);
        if (!allHidden && canaliEnabled) {
            if (numeroCanali == 0) {
                de = new DataElement();
                de.setLabel("Canale di Default");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Nome");
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("canaliNome");
                de.setValue(canaliNome);
                de.setRequired(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Descrizione");
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("canaliDescrizione");
                de.setValue(canaliDescrizione);
                dati.add(de);
            } else {
                de = new DataElement();
                de.setLabel("Default");
                de.setName("canaliDefault");
                de.setType(DataElementType.SELECT);
                ArrayList canaliListValues = canaleList != null ? canaleList.stream().map(CanaleConfigurazione::getNome).collect(Collectors.toList()) : new ArrayList();
                de.setValues(canaliListValues);
                de.setLabels(canaliListValues);
                de.setSelected(canaliDefault);
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneCanaliList.do");
                if (contaListeFromSession) {
                    de.setValue("Canali (" + numeroCanali + ")");
                } else {
                    de.setValue("Canali");
                }
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneCanaliNodiList.do");
                if (contaListeFromSession) {
                    de.setValue("Nodi (" + numeroNodi + ")");
                } else {
                    de.setValue("Nodi");
                }
                dati.add(de);
            }
        }
    }

    public void addRegistrazioneMessaggiToDatiAsHidden(String dumpPD, String dumpPA, Configurazione configurazione, List<DataElement> dati) {
        DataElement de = new DataElement();
        de = new DataElement();
        de.setName("dumpConnettorePD");
        de.setLabel("Fruizioni");
        de.setType(DataElementType.HIDDEN);
        de.setValue(dumpPD);
        dati.add(de);
        de = new DataElement();
        de.setName("dumpConnettorePA");
        de.setLabel("Erogazioni");
        de.setType(DataElementType.HIDDEN);
        de.setValue(dumpPA);
        dati.add(de);
    }

    public void addRegistrazioneMessaggiToDati(String dumpApplicativo, String dumpPD, String dumpPA, Configurazione configurazione, List<DataElement> dati, Boolean contaListe) {
        DataElement de = new DataElement();
        de.setLabel("Registrazione Messaggi");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] tipoDump = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
        de = new DataElement();
        de.setName("dump");
        de.setLabel("Stato");
        de.setType(DataElementType.SELECT);
        de.setValues(tipoDump);
        de.setSelected(dumpApplicativo);
        de.setPostBack_viaPOST(true);
        dati.add(de);
        if (dumpApplicativo.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO)) {
            String oldDumpApplicativo = null;
            if (configurazione.getDump().getStato() != null) {
                oldDumpApplicativo = configurazione.getDump().getStato().toString();
            }
            if (dumpApplicativo.equals(oldDumpApplicativo)) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneDumpConfigurazione.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("dumpConfigType", TipoPdD.APPLICATIVA.getTipo())});
                de.setValue("Configurazione Erogazioni");
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneDumpConfigurazione.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("dumpConfigType", TipoPdD.DELEGATA.getTipo())});
                de.setValue("Configurazione Fruizioni");
                dati.add(de);
            }
        }
        if (this.isModalitaAvanzata() && this.confCore.isDumpShowConfigurazioneCustomAppender()) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneDumpAppenderList.do");
            if (contaListe != null && contaListe.booleanValue()) {
                int totAppender = 0;
                if (configurazione.getDump() != null) {
                    totAppender = configurazione.getDump().sizeOpenspcoopAppenderList();
                }
                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Appender", (Long)Long.valueOf(totAppender));
            } else {
                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Appender");
            }
            dati.add(de);
        }
        if (this.isModalitaAvanzata()) {
            de = new DataElement();
            de.setLabel("Log4j Dump Binario");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        String[] tipoDumpConnettorePA = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
        de = new DataElement();
        de.setName("dumpConnettorePA");
        de.setLabel("Erogazioni");
        if (this.isModalitaAvanzata()) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoDumpConnettorePA);
            de.setSelected(dumpPA);
            de.setNote("govway_dumpBinarioPA.log");
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(dumpPA);
        }
        dati.add(de);
        String[] tipoDumpConnettorePD = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
        de = new DataElement();
        de.setName("dumpConnettorePD");
        de.setLabel("Fruizioni");
        if (this.isModalitaAvanzata()) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoDumpConnettorePD);
            de.setSelected(dumpPD);
            de.setNote("govway_dumpBinarioPD.log");
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(dumpPD);
        }
        dati.add(de);
    }

    public void addTracciamentoToDatiAsHidden(String registrazioneTracce, Configurazione configurazione, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setName("registrazioneTracce");
        de.setLabel("Stato");
        de.setType(DataElementType.HIDDEN);
        de.setValue(registrazioneTracce);
        dati.add(de);
    }

    public void addTracciamentoToDati(String registrazioneTracce, Configurazione configurazione, List<DataElement> dati, Boolean contaListe) {
        DataElement de;
        boolean showTitleSection;
        boolean bl = showTitleSection = this.isModalitaCompleta() || this.isModalitaAvanzata() && (this.confCore.isTracceShowConfigurazioneCustomAppender() || this.confCore.isTracceShowSorgentiDatiDatabase());
        if (showTitleSection && this.isModalitaAvanzata()) {
            de = new DataElement();
            de.setLabel("Tracce");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        String[] tipoBuste = new String[]{ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO, ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO};
        de = new DataElement();
        de.setName("registrazioneTracce");
        de.setLabel("Stato");
        if (this.isModalitaCompleta()) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoBuste);
            de.setSelected(registrazioneTracce);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(registrazioneTracce);
        }
        dati.add(de);
        if (this.isModalitaAvanzata()) {
            if (this.confCore.isTracceShowConfigurazioneCustomAppender()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneTracciamentoAppenderList.do");
                if (contaListe != null && contaListe.booleanValue()) {
                    int totAppender = 0;
                    if (configurazione.getTracciamento() != null) {
                        totAppender = configurazione.getTracciamento().sizeOpenspcoopAppenderList();
                    }
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Appender", (Long)Long.valueOf(totAppender));
                } else {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Appender");
                }
                dati.add(de);
            }
            if (this.confCore.isTracceShowSorgentiDatiDatabase()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneTracciamentoDatasourceList.do");
                if (contaListe != null && contaListe.booleanValue()) {
                    int totDs = 0;
                    if (configurazione.getTracciamento() != null) {
                        totDs = configurazione.getTracciamento().sizeOpenspcoopSorgenteDatiList();
                    }
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Sorgenti Dati", (Long)Long.valueOf(totDs));
                } else {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Sorgenti Dati");
                }
                dati.add(de);
            }
        }
    }

    public void addMessaggiDiagnosticiToDatiAsHidden(String severita, String severita_log4j, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Livello di Log su DB");
        de.setType(DataElementType.HIDDEN);
        de.setName("severita");
        de.setValue(severita);
        dati.add(de);
        de = new DataElement();
        de.setName("severita_log4j");
        de.setLabel("Livello di Log su File");
        de.setType(DataElementType.HIDDEN);
        de.setValue(severita_log4j);
        dati.add(de);
    }

    public void addConfigurazioneTracciamentoToDati(List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Transazioni");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.LINK);
        de.setUrl("configurazioneTracciamentoTransazioni.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("tipo_configurazione", "tracePA")});
        de.setValue("Configurazione Erogazioni");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.LINK);
        de.setUrl("configurazioneTracciamentoTransazioni.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("tipo_configurazione", "tracePD")});
        de.setValue("Configurazione Fruizioni");
        dati.add(de);
    }

    public void addMessaggiDiagnosticiToDati(String severita, String severita_log4j, Configurazione configurazione, List<DataElement> dati, Boolean contaListe) {
        this.addSeveritaMessaggiDiagnosticiToDati(severita, severita_log4j, dati);
        if (this.isModalitaAvanzata()) {
            DataElement de;
            if (this.confCore.isMsgDiagnosticiShowConfigurazioneCustomAppender()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneDiagnosticaAppenderList.do");
                if (contaListe != null && contaListe.booleanValue()) {
                    int totAppender = 0;
                    if (configurazione.getMessaggiDiagnostici() != null) {
                        totAppender = configurazione.getMessaggiDiagnostici().sizeOpenspcoopAppenderList();
                    }
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Appender", (Long)Long.valueOf(totAppender));
                } else {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Appender");
                }
                dati.add(de);
            }
            if (this.confCore.isMsgDiagnosticiShowSorgentiDatiDatabase()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneDiagnosticaDatasourceList.do");
                if (contaListe != null && contaListe.booleanValue()) {
                    int totDs = 0;
                    if (configurazione.getMessaggiDiagnostici() != null) {
                        totDs = configurazione.getMessaggiDiagnostici().sizeOpenspcoopSorgenteDatiList();
                    }
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Sorgenti Dati", (Long)Long.valueOf(totDs));
                } else {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Sorgenti Dati");
                }
                dati.add(de);
            }
        }
    }

    public List<DataElement> addConfigurazioneSistemaSelectListNodiCluster(List<DataElement> dati, String[] nodiSelezionati) throws Exception {
        DataElement de = new DataElement();
        de.setType(DataElementType.MULTI_SELECT);
        de.setValues(this.confCore.getJmxPdDAliases());
        ArrayList<String> labels = new ArrayList<String>();
        for (String string : this.confCore.getJmxPdDAliases()) {
            labels.add(this.confCore.getJmxPdDDescrizione(string));
        }
        de.setLabels(labels);
        de.setName("aliasNodi");
        de.setLabel("ID Cluster");
        de.setSize(this.getSize());
        de.setPostBack(true);
        if (labels.size() > 10) {
            de.setRows(10);
        } else {
            de.setRows(labels.size());
        }
        de.setSelezionati(nodiSelezionati);
        dati.add(de);
        boolean resetAllCaches = false;
        if (this.confCore.isVisualizzaLinkClearAllCachesRemoteCheckCacheStatus()) {
            for (String alias : this.confCore.getJmxPdDAliases()) {
                List<String> caches = this.confCore.getJmxPdDCaches(alias);
                if (caches != null && caches.size() > 0) {
                    for (String cache : caches) {
                        String stato;
                        block19: {
                            stato = null;
                            try {
                                stato = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), cache, this.confCore.getJmxPdDCacheNomeAttributoCacheAbilitata(alias));
                                if (stato.equalsIgnoreCase("true")) {
                                    stato = "abilitata";
                                    break block19;
                                }
                                if (stato.equalsIgnoreCase("false")) {
                                    stato = "disabilitata";
                                    break block19;
                                }
                                throw new DriverControlStationException("Stato [" + stato + "] sconosciuto");
                            }
                            catch (Exception e) {
                                this.logError("Errore durante la lettura dello stato della cache [" + cache + "](jmxResourcePdD): " + e.getMessage(), e);
                                stato = "Informazione non disponibile";
                            }
                        }
                        if (!"abilitata".equals(stato)) continue;
                        resetAllCaches = true;
                        break;
                    }
                }
                if (!resetAllCaches) continue;
                break;
            }
        } else {
            resetAllCaches = true;
        }
        if (resetAllCaches) {
            de = new DataElement();
            de.setUrl("configurazioneSistemaAdd.do?nomeCache=ResetAllCaches&nomeMetodo=__resetAllCachesAllNodes__");
            de.setType(DataElementType.LINK);
            de.setName("ResetAllCaches");
            de.setValue("Svuota le Cache di tutti i nodi");
            de.setSize(this.getSize());
            dati.add(de);
            StringBuilder stringBuilder = new StringBuilder("");
            if (nodiSelezionati != null && nodiSelezionati.length > 0) {
                for (int i = 0; i < nodiSelezionati.length; ++i) {
                    stringBuilder.append("&");
                    stringBuilder.append("aliasNodi");
                    stringBuilder.append("=");
                    stringBuilder.append(nodiSelezionati[i]);
                }
            }
            de = new DataElement();
            de.setUrl("configurazioneSistemaAdd.do?nomeCache=ResetSelectedCaches&nomeMetodo=__resetAllCachesSelectedNodes__" + stringBuilder.toString());
            de.setType(DataElementType.LINK);
            de.setName("ResetSelectedCaches");
            de.setValue("Svuota le Cache dei nodi selezionati");
            de.setSize(this.getSize());
            dati.add(de);
            Map<String, List<String>> map = this.confCore.getJmxPdDGruppiAliases();
            if (map != null && !map.isEmpty()) {
                ArrayList<String> gruppi = new ArrayList<String>();
                for (String gruppo : map.keySet()) {
                    gruppi.add(gruppo);
                }
                Collections.sort(gruppi);
                int indexGr = 0;
                for (String gruppo : gruppi) {
                    ++indexGr;
                    List<String> aliases = map.get(gruppo);
                    StringBuilder sbGruppi = new StringBuilder("");
                    if (aliases == null || aliases.size() <= 0) continue;
                    for (int i = 0; i < aliases.size(); ++i) {
                        sbGruppi.append("&");
                        sbGruppi.append("aliasNodi");
                        sbGruppi.append("=");
                        sbGruppi.append(aliases.get(i));
                    }
                    de = new DataElement();
                    de.setUrl("configurazioneSistemaAdd.do?nomeCache=ResetSelectedCaches&nomeMetodo=__resetAllCachesSelectedNodes__" + sbGruppi.toString());
                    de.setType(DataElementType.LINK);
                    de.setName("ResetSelectedCaches__gr" + indexGr);
                    de.setValue("Svuota le Cache dei nodi 'GRUPPO'".replace("GRUPPO", gruppo));
                    de.setSize(this.getSize());
                    dati.add(de);
                }
            }
        }
        return dati;
    }

    private void addInformazioneNonDisponibile(List<DataElement> dati, String label) {
        DataElement de = this.newDataElementStyleRuntime();
        de.setLabel(label);
        de.setValue("Informazione non disponibile");
        de.setType(DataElementType.TEXT);
        de.setSize(this.getSize());
        dati.add(de);
    }

    private DataElement newDataElementStyleRuntime() {
        DataElement de = new DataElement();
        de.setLabelStyleClass("labelMedium");
        return de;
    }

    public List<DataElement> addConfigurazioneSistema(List<DataElement> dati, String alias) throws Exception {
        String label;
        String value;
        String label2;
        HashMap<String, String> statoConnessioniAltriDB;
        HashMap<String, String> infoConnessioneAltriDB;
        Object label3;
        List<String> caches;
        DataElement de;
        block296: {
            String tipo;
            String[] labels;
            String v;
            String livelloSeverita;
            String v2;
            String[] tipoMsg;
            boolean enable;
            String value2;
            de = this.newDataElementStyleRuntime();
            de.setType(DataElementType.TITLE);
            de.setLabel("Runtime");
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setName("aliasNodo");
            de.setLabel("aliasNodo");
            de.setType(DataElementType.HIDDEN);
            de.setValue(alias);
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setLabel("Download");
            de.setUrl("exporterConfigurazione", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("aliasNodo", alias)});
            de.setType(DataElementType.LINK);
            de.setName("Download");
            de.setValue("Download");
            de.setSize(this.getSize());
            dati.add(de);
            boolean resetAllCaches = false;
            caches = this.confCore.getJmxPdDCaches(alias);
            if (caches != null && !caches.isEmpty()) {
                for (String cache : caches) {
                    String stato;
                    block295: {
                        stato = null;
                        try {
                            stato = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), cache, this.confCore.getJmxPdDCacheNomeAttributoCacheAbilitata(alias));
                            if (stato.equalsIgnoreCase("true")) {
                                stato = "abilitata";
                                break block295;
                            }
                            if (stato.equalsIgnoreCase("false")) {
                                stato = "disabilitata";
                                break block295;
                            }
                            throw new DriverControlStationException("Stato [" + stato + "] sconosciuto");
                        }
                        catch (Exception e) {
                            this.logError("Errore durante la lettura dello stato della cache [" + cache + "](jmxResourcePdD): " + e.getMessage(), e);
                            stato = "Informazione non disponibile";
                        }
                    }
                    if (!"abilitata".equals(stato)) continue;
                    resetAllCaches = true;
                    break;
                }
            }
            if (resetAllCaches) {
                de = this.newDataElementStyleRuntime();
                de.setLabel("Svuota tutte le Cache");
                de.setUrl("configurazioneSistemaAdd.do?aliasNodo=" + alias + "&nomeCache=ResetAllCaches&nomeMetodo=" + this.confCore.getJmxPdDCacheNomeMetodoResetCache(alias));
                de.setType(DataElementType.LINK);
                de.setName("ResetAllCaches");
                de.setValue("Svuota tutte le Cache");
                de.setSize(this.getSize());
                dati.add(de);
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Informazioni Generali");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String versionePdD = null;
            try {
                versionePdD = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVersionePdD(alias));
                if (this.isErroreHttp(versionePdD, "versione della PdD")) {
                    versionePdD = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura della versione della PdD (jmxResourcePdD): " + e.getMessage(), e);
                versionePdD = "Informazione non disponibile";
            }
            if (versionePdD != null) {
                versionePdD = StringEscapeUtils.escapeHtml4((String)versionePdD);
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Versione");
            de.setValue(versionePdD);
            de.setType(DataElementType.TEXT);
            de.setName("versionePdD");
            de.setSize(this.getSize());
            dati.add(de);
            String versioneBaseDati = null;
            try {
                versioneBaseDati = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVersioneBaseDati(alias));
                if (this.isErroreHttp(versioneBaseDati, "versione della base dati")) {
                    versioneBaseDati = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura della versione della base dati (jmxResourcePdD): " + e.getMessage(), e);
                versioneBaseDati = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Versione BaseDati");
            de.setValue(versioneBaseDati);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("versioneBaseDati");
            de.setRows(4);
            de.setCols(60);
            de.setSize(this.getSize());
            dati.add(de);
            String confDir = null;
            try {
                confDir = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoDirectoryConfigurazione(alias));
                if (this.isErroreHttp(confDir, "directory di configurazione")) {
                    confDir = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura della directory di configurazione (jmxResourcePdD): " + e.getMessage(), e);
                confDir = "Informazione non disponibile";
            }
            if (confDir != null) {
                confDir = StringEscapeUtils.escapeHtml4((String)confDir);
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Directory di Configurazione");
            de.setValue(confDir);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("directoryConfigurazione");
            de.setRows(4);
            de.setCols(60);
            de.setSize(this.getSize());
            dati.add(de);
            String vendorJava = null;
            try {
                vendorJava = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVendorJava(alias));
                if (this.isErroreHttp(vendorJava, "vendor di java")) {
                    vendorJava = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul vendor di java (jmxResourcePdD): " + e.getMessage(), e);
                vendorJava = "Informazione non disponibile";
            }
            if (vendorJava != null) {
                vendorJava = StringEscapeUtils.escapeHtml4((String)vendorJava);
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Vendor Java");
            de.setValue(vendorJava);
            de.setType(DataElementType.TEXT);
            de.setName("vendorJava");
            de.setSize(this.getSize());
            dati.add(de);
            String versioneJava = null;
            try {
                versioneJava = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVersioneJava(alias));
                if (this.isErroreHttp(versioneJava, "versione di java")) {
                    versioneJava = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura della versione di java (jmxResourcePdD): " + e.getMessage(), e);
                versioneJava = "Informazione non disponibile";
            }
            if (versioneJava != null) {
                versioneJava = StringEscapeUtils.escapeHtml4((String)versioneJava);
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Versione Java");
            de.setValue(versioneJava);
            de.setType(DataElementType.TEXT);
            de.setName("versioneJava");
            de.setSize(this.getSize());
            dati.add(de);
            String messageFactory = null;
            try {
                messageFactory = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoMessageFactory(alias));
                if (this.isErroreHttp(messageFactory, "message factory")) {
                    messageFactory = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura della message factory (jmxResourcePdD): " + e.getMessage(), e);
                messageFactory = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Message Factory");
            de.setValue(messageFactory.trim().contains(" ") ? messageFactory.trim().replace(" ", "\n") : messageFactory);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setRows(2);
            de.setCols(60);
            de.setName("messageFactory");
            de.setSize(this.getSize());
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setType(DataElementType.TITLE);
            de.setLabel("Stato Servizi");
            dati.add(de);
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaDelegata(alias));
                enable = CostantiConfigurazione.ABILITATO.getValue().equals(value2);
                tipoMsg = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("statoServizioPD");
                de.setLabel("Porta Delegata");
                v2 = enable ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato del servizio Porta Delegata (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Porta Delegata");
            }
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaApplicativa(alias));
                enable = CostantiConfigurazione.ABILITATO.getValue().equals(value2);
                tipoMsg = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("statoServizioPA");
                de.setLabel("Porta Applicativa");
                v2 = enable ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato del servizio Porta Applicativa (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Porta Applicativa");
            }
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioIntegrationManager(alias));
                enable = CostantiConfigurazione.ABILITATO.getValue().equals(value2);
                tipoMsg = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("statoServizioIM");
                de.setLabel("Integration Manager");
                v2 = enable ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato del servizio Integration Manager (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Integration Manager");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Informazioni Diagnostica");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            try {
                livelloSeverita = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoSeveritaDiagnostici(alias));
                String[] tipoMsg2 = new String[]{"off", "fatal", "errorProtocol", "errorIntegration", "infoProtocol", "infoIntegration", "debugLow", "debugMedium", "debugHigh", "all"};
                de = this.newDataElementStyleRuntime();
                de.setLabel("Livello di Log su DB");
                de.setType(DataElementType.SELECT);
                de.setName("severita");
                de.setValues(tipoMsg2);
                de.setSelected(livelloSeverita);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul livello dei diagnostici (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Livello di Log su DB");
            }
            try {
                livelloSeverita = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoSeveritaDiagnosticiLog4j(alias));
                String[] tipoMsg3 = new String[]{"off", "fatal", "errorProtocol", "errorIntegration", "infoProtocol", "infoIntegration", "debugLow", "debugMedium", "debugHigh", "all"};
                de = this.newDataElementStyleRuntime();
                de.setName("severita_log4j");
                de.setLabel("Livello di Log su File");
                if (this.core.isVisualizzazioneConfigurazioneDiagnosticaLog4J()) {
                    de.setType(DataElementType.SELECT);
                    de.setValues(tipoMsg3);
                    de.setSelected(livelloSeverita);
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setType(DataElementType.TEXT);
                    de.setValue(livelloSeverita);
                }
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul livello dei diagnostici log4j (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Livello di Log su File");
            }
            try {
                String log4j_diagnostica = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jDiagnostica(alias));
                boolean enable2 = "true".equals(log4j_diagnostica);
                de = this.newDataElementStyleRuntime();
                de.setName("statoLog4jDiagnostica");
                de.setLabel("Log4j XML Diagnostici");
                de.setNote("govway_diagnostici.log");
                v = enable2 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.TEXT);
                de.setValue(v);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato di log del file govway_diagnostici.log (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Log4j XML Diagnostici");
            }
            try {
                String log4j_openspcoop = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jOpenspcoop(alias));
                boolean enable3 = "true".equals(log4j_openspcoop);
                de = this.newDataElementStyleRuntime();
                de.setName("statoLog4jOpenspcoop");
                de.setLabel("Log4j Diagnostici");
                de.setNote("govway.log");
                v = enable3 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.TEXT);
                de.setValue(v);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato di log del file govway.log (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Log4j Diagnostici");
            }
            try {
                String log4j_integrationManager = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jIntegrationManager(alias));
                boolean enable4 = "true".equals(log4j_integrationManager);
                de = this.newDataElementStyleRuntime();
                de.setName("statoLog4jIntegrationManager");
                de.setLabel("Log4j IntegrationManager");
                de.setNote("govway_integrationManager.log");
                v = enable4 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.TEXT);
                de.setValue(v);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato di log del file govway_integrationManager.log (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Log4j IntegrationManager");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Informazioni Tracciamento");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTracciamento(alias));
                boolean enable5 = "true".equals(value2);
                tipoMsg = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("registrazioneTracce");
                de.setLabel("Buste");
                String string = v2 = enable5 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                if (this.isModalitaAvanzata()) {
                    if (this.isModalitaCompleta()) {
                        de.setType(DataElementType.SELECT);
                        de.setValues(tipoMsg);
                        de.setSelected(v2);
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setType(DataElementType.TEXT);
                        de.setValue(v2);
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(v2);
                }
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul tracciamento (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Buste");
            }
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoDumpPA(alias));
                boolean enable6 = "true".equals(value2);
                tipoMsg = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("dumpConnettorePA");
                de.setLabel("Log4j Dump Binario Erogazioni");
                de.setNote("govway_dumpBinarioPA.log");
                v2 = enable6 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul dump binario sulla Porta Applicativa (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Log4j Dump Binario Erogazioni");
            }
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoDumpPD(alias));
                boolean enable7 = "true".equals(value2);
                tipoMsg = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("dumpConnettorePD");
                de.setLabel("Log4j Dump Binario Fruizioni");
                de.setNote("govway_dumpBinarioPD.log");
                v2 = enable7 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul dump binario sulla Porta Delegata (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Log4j Dump Binario Fruizioni");
            }
            try {
                String log4j_tracciamento = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jTracciamento(alias));
                boolean enable8 = "true".equals(log4j_tracciamento);
                de = this.newDataElementStyleRuntime();
                de.setName("statoLog4jTracciamento");
                de.setLabel("Log4j Tracciamento");
                de.setNote("govway_tracciamento.log");
                v = enable8 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.TEXT);
                de.setValue(v);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato di log del file govway_tracciamento.log (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Log4j Tracciamento");
            }
            try {
                String log4j_dump = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jDump(alias));
                boolean enable9 = "true".equals(log4j_dump);
                de = this.newDataElementStyleRuntime();
                de.setName("statoLog4jDump");
                de.setLabel("Log4j Dump");
                de.setNote("govway_dump.log");
                v = enable9 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.TEXT);
                de.setValue(v);
                dati.add(de);
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sullo stato di log del file govway_dump.log (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Log4j Dump");
            }
            try {
                boolean fileTraceEnabled;
                String fileTraceGovWayState = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetFileTrace(alias));
                FileTraceGovWayState stateFileTrace = FileTraceGovWayState.toConfig((String)fileTraceGovWayState, (boolean)true);
                boolean bl = fileTraceEnabled = stateFileTrace != null && stateFileTrace.isEnabled();
                if (fileTraceEnabled) {
                    de = this.newDataElementStyleRuntime();
                    de.setLabel("File Trace");
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                }
                de = this.newDataElementStyleRuntime();
                de.setName("fileTrace");
                if (fileTraceEnabled) {
                    de.setLabel("Stato");
                } else {
                    de.setLabel("File Trace");
                }
                v2 = fileTraceEnabled ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.TEXT);
                de.setValue(v2);
                dati.add(de);
                if (fileTraceEnabled) {
                    de = this.newDataElementStyleRuntime();
                    de.setName("fileTraceConfig");
                    de.setLabel("Configurazione");
                    de.setType(DataElementType.TEXT);
                    de.setValue(stateFileTrace.getPath());
                    dati.add(de);
                    String[] valori = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                    label3 = new String[]{"Aggiorna la configurazione", stateFileTrace.getLastModified()};
                    de = this.newDataElementStyleRuntime();
                    de.setName("fileTraceUpdate");
                    de.setLabel("Ultimo Aggiornamento");
                    de.setType(DataElementType.SELECT);
                    de.setValues(valori);
                    de.setLabels(label3);
                    de.setSelected(CostantiConfigurazione.DISABILITATO.getValue());
                    de.setPostBack_viaPOST(true);
                    dati.add(de);
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul FileTrace (jmxResourcePdD): " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "File Trace");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Errori generati dal Gateway");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setLabel("Codici di errore 'GovWay-Transaction-ErrorType'");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalRequestError(alias));
                boolean enable10 = "true".equals(value2);
                String[] tipoMsg4 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrTypeProcessRequest");
                de.setLabel("Richiesta");
                v2 = enable10 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg4);
                labels = new String[]{"Errore puntuale", "Errore generico 'Bad Request'"};
                de.setLabels(labels);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                String tipo2 = "Codici di errore 'GovWay-Transaction-ErrorType' (Richiesta)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo2 + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Richiesta");
            }
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeBadResponse(alias));
                String value22 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalResponseError(alias));
                boolean enable11 = "true".equals(value2) && "true".equals(value22);
                String[] tipoMsg5 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrTypeProcessResponse");
                de.setLabel("Risposta");
                String v3 = enable11 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg5);
                String[] labels2 = new String[]{"Errore puntuale", "Errore generico 'Invalid Response'"};
                de.setLabels(labels2);
                de.setSelected(v3);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                tipo = "Codici di errore 'GovWay-Transaction-ErrorType' (Risposta)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Risposta");
            }
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalError(alias));
                boolean enable12 = "true".equals(value2);
                String[] tipoMsg6 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrTypeInternalError");
                de.setLabel("Errori Interni");
                v2 = enable12 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg6);
                labels = new String[]{"Errore puntuale", "Errore generico 'Service Unavailable'"};
                de.setLabels(labels);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                tipo = "Codici di errore 'GovWay-Transaction-ErrorType' (Errori Interni)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Errori Interni");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Codici di errore specifici 'GovWay-Transaction-ErrorStatus'");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorStatusCode(alias));
                boolean enable13 = "true".equals(value2);
                String[] tipoMsg7 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrStatusCode");
                de.setLabel("Http Header / Problem Detail");
                v2 = enable13 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg7);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                String tipo3 = "Codici di errore specifici 'GovWay-Transaction-ErrorStatus' (Http Header / Problem Detail)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo3 + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Http Header / Problem Detail");
            }
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorUseStatusCodeAsFaultCode(alias));
                boolean enable14 = "true".equals(value2);
                String[] tipoMsg8 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrStatusCodeAsSoapFault");
                de.setLabel("SOAP Fault Code");
                v2 = enable14 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg8);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                String tipo4 = "Codici di errore specifici 'GovWay-Transaction-ErrorStatus' (SOAP Fault Code)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo4 + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "SOAP Fault Code");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Dettagli di errore puntuali");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorDetails(alias));
                boolean enable15 = "true".equals(value2);
                String[] tipoMsg9 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrDetails");
                de.setLabel("Stato");
                v2 = enable15 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg9);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                String tipo5 = "Dettagli di errore puntuali (Stato)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo5 + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Stato");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Claim 'instance' nei Problem");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorInstanceId(alias));
                boolean enable16 = "true".equals(value2);
                String[] tipoMsg10 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrInstanceId");
                de.setLabel("Stato");
                v2 = enable16 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg10);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                String tipo6 = "Claim 'instance' nei Problem (Stato)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo6 + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Stato");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Header http 'GovWay-Transaction-ErrorCode' su protocollo SOAP");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            try {
                value2 = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorGenerateHttpHeaderGovWayCode(alias));
                boolean enable17 = "true".equals(value2);
                String[] tipoMsg11 = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                de = this.newDataElementStyleRuntime();
                de.setName("trErrGenerateHttpCodeSoap");
                de.setLabel("Stato");
                v2 = enable17 ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue();
                de.setType(DataElementType.SELECT);
                de.setValues(tipoMsg11);
                de.setSelected(v2);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
            catch (Exception e) {
                String tipo7 = "Header http 'GovWay-Transaction-ErrorCode' su protocollo SOAP (Stato)";
                this.logError("Errore durante la lettura delle informazioni (jmxResourcePdD) [" + tipo7 + "]: " + e.getMessage(), e);
                this.addInformazioneNonDisponibile(dati, "Stato");
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Informazioni Database");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] infoDatabase = null;
            try {
                String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniDatabase(alias));
                if (this.isErroreHttp(tmp, "informazioni sul database")) {
                    tmp = null;
                }
                infoDatabase = tmp != null ? tmp.split("\n") : null;
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sul database (jmxResourcePdD): " + e.getMessage(), e);
            }
            if (infoDatabase == null || infoDatabase.length <= 0) {
                this.addInformazioneNonDisponibile(dati, "");
            } else {
                for (int i = 0; i < infoDatabase.length; ++i) {
                    try {
                        String label4 = infoDatabase[i];
                        String value3 = "";
                        if (infoDatabase[i].contains(":")) {
                            label4 = infoDatabase[i].split(":")[0];
                            value3 = infoDatabase[i].split(":")[1];
                        }
                        de = this.newDataElementStyleRuntime();
                        de.setLabel(label4);
                        if (value3 != null) {
                            value3 = StringEscapeUtils.escapeHtml4((String)value3);
                        }
                        de.setValue(value3);
                        de.setType(DataElementType.TEXT);
                        de.setName("infoDatabase_" + i);
                        de.setSize(this.getSize());
                        dati.add(de);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante la lettura delle informazioni sul database (jmxResourcePdD): " + e.getMessage(), e);
                    }
                }
            }
            infoConnessioneAltriDB = null;
            statoConnessioniAltriDB = null;
            try {
                String nomiDatasource;
                int numeroDatasource = 0;
                try {
                    String stato = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoNumeroDatasourceGW(alias));
                    if (stato != null && !"".equals(stato)) {
                        if (this.isErroreHttp(stato, "stato delle connessioni verso altri database")) {
                            throw new DriverControlStationException(stato);
                        }
                        numeroDatasource = Integer.valueOf(stato);
                    }
                }
                catch (Exception e) {
                    ControlStationCore.logDebug("Numero di datasource attivi non ottenibili: " + e.getMessage());
                }
                if (numeroDatasource > 0 && (nomiDatasource = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetDatasourcesGW(alias))) != null && !"".equals(nomiDatasource)) {
                    if (this.isErroreHttp(nomiDatasource, "stato delle connessioni verso altri database")) {
                        throw new DriverControlStationException(nomiDatasource);
                    }
                    String[] lines = nomiDatasource.split("\n");
                    if (lines != null && lines.length > 0) {
                        for (String line : lines) {
                            String[] tmp;
                            if (!line.startsWith("(") || (tmp = line.split(" ")) == null || tmp.length <= 3) continue;
                            String nomeDS = tmp[2] + " " + tmp[1];
                            try {
                                int indexOf_paramIdentificazioneDataSource = tmp[2].indexOf(":");
                                String paramIdentificazioneDataSource = tmp[2].substring(indexOf_paramIdentificazioneDataSource + 1, tmp[2].length());
                                String statoInfo = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetInformazioniDatabaseDatasourcesGW(alias), paramIdentificazioneDataSource);
                                if (infoConnessioneAltriDB == null) {
                                    infoConnessioneAltriDB = new HashMap();
                                }
                                infoConnessioneAltriDB.put(nomeDS, statoInfo);
                                if (this.confCore.isClusterAsyncUpdate()) continue;
                                String statoDB = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetUsedConnectionsDatasourcesGW(alias), paramIdentificazioneDataSource);
                                if (this.isErroreHttp(statoDB, "stato delle connessioni verso database " + nomeDS)) {
                                    throw new DriverControlStationException(statoDB);
                                }
                                if (statoConnessioniAltriDB == null) {
                                    statoConnessioniAltriDB = new HashMap();
                                }
                                statoConnessioniAltriDB.put(nomeDS, statoDB);
                            }
                            catch (Exception e) {
                                ControlStationCore.logError("Errore durante la lettura delle informazioni verso il database " + nomeDS + " (jmxResourcePdD): " + e.getMessage(), e);
                                if (infoConnessioneAltriDB == null) {
                                    infoConnessioneAltriDB = new HashMap();
                                }
                                infoConnessioneAltriDB.put(nomeDS, "Informazione non disponibile");
                                if (this.confCore.isClusterAsyncUpdate()) continue;
                                if (statoConnessioniAltriDB == null) {
                                    statoConnessioniAltriDB = new HashMap();
                                }
                                statoConnessioniAltriDB.put(nomeDS, "Informazione non disponibile");
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura delle informazioni verso gli altri database (jmxResourcePdD): " + e.getMessage(), e);
                if (infoConnessioneAltriDB == null) {
                    infoConnessioneAltriDB = new HashMap<String, String>();
                }
                infoConnessioneAltriDB.put("GovWayDatasources", "Informazione non disponibile");
                if (this.confCore.isClusterAsyncUpdate()) break block296;
                if (statoConnessioniAltriDB == null) {
                    statoConnessioniAltriDB = new HashMap<String, String>();
                }
                statoConnessioniAltriDB.put("GovWayDatasources", "Informazione non disponibile");
            }
        }
        if (infoConnessioneAltriDB != null && infoConnessioneAltriDB.size() > 0) {
            Iterator it = infoConnessioneAltriDB.keySet().iterator();
            int index = 0;
            while (it.hasNext()) {
                String idAltroDB = (String)it.next();
                String infoConnessioneAltroDB = (String)infoConnessioneAltriDB.get(idAltroDB);
                de = this.newDataElementStyleRuntime();
                de.setLabel("Informazioni Database " + idAltroDB.split(" ")[0]);
                de.setType(DataElementType.TITLE);
                dati.add(de);
                String[] infoConnessioneDatabase = infoConnessioneAltroDB.split("\n");
                if (infoConnessioneDatabase == null || infoConnessioneDatabase.length <= 0) {
                    this.addInformazioneNonDisponibile(dati, "");
                } else {
                    for (int i = 0; i < infoConnessioneDatabase.length; ++i) {
                        try {
                            label2 = infoConnessioneDatabase[i];
                            value = "";
                            if (infoConnessioneDatabase[i].contains(":")) {
                                label2 = infoConnessioneDatabase[i].split(":")[0];
                                value = infoConnessioneDatabase[i].split(":")[1];
                            }
                            de = this.newDataElementStyleRuntime();
                            de.setLabel(label2);
                            if (value != null) {
                                value = StringEscapeUtils.escapeHtml4((String)value);
                            }
                            de.setValue(value);
                            de.setType(DataElementType.TEXT);
                            de.setName("infoDatabase__db" + index + "_" + i);
                            de.setSize(this.getSize());
                            dati.add(de);
                            continue;
                        }
                        catch (Exception e) {
                            this.logError("Errore durante la lettura delle informazioni sul database (jmxResourcePdD): " + e.getMessage(), e);
                        }
                    }
                }
                ++index;
            }
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Informazioni SSL");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] infoSSL = null;
        try {
            String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniSSL(alias));
            if (this.isErroreHttp(tmp, "informazioni SSL")) {
                tmp = null;
            }
            infoSSL = tmp != null ? tmp.split("\n") : null;
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle informazioni SSL (jmxResourcePdD): " + e.getMessage(), e);
        }
        if (infoSSL == null || infoSSL.length <= 0) {
            this.addInformazioneNonDisponibile(dati, "");
        } else {
            for (int i = 0; i < infoSSL.length; ++i) {
                try {
                    label3 = infoSSL[i];
                    String value4 = "";
                    if (infoSSL[i].contains(":")) {
                        label3 = infoSSL[i].split(":")[0];
                        value4 = infoSSL[i].split(":")[1];
                    }
                    de = this.newDataElementStyleRuntime();
                    de.setLabel((String)label3);
                    if (value4 != null) {
                        value4 = StringEscapeUtils.escapeHtml4((String)value4);
                    }
                    de.setValue(value4);
                    de.setType(DataElementType.TEXT);
                    de.setName("infoSsl_" + i);
                    de.setSize(this.getSize());
                    dati.add(de);
                    continue;
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura delle informazioni SSL (jmxResourcePdD): " + e.getMessage(), e);
                }
            }
        }
        if (this.core.isJmxPdD_configurazioneSistemaShowInformazioniCryptographyKeyLength()) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("Informazioni Cryptography (Key Length)");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            String[] infoCryptoKeyLength = null;
            try {
                String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCryptographyKeyLength(alias));
                if (this.isErroreHttp(tmp, "informazioni CryptographyKeyLength")) {
                    tmp = null;
                }
                infoCryptoKeyLength = tmp != null ? tmp.split("\n") : null;
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle informazioni sulla lunghezza delle chiavi di cifratura (jmxResourcePdD): " + e.getMessage(), e);
            }
            if (infoCryptoKeyLength == null || infoCryptoKeyLength.length <= 0) {
                this.addInformazioneNonDisponibile(dati, "");
            } else {
                for (int i = 0; i < infoCryptoKeyLength.length; ++i) {
                    try {
                        label = infoCryptoKeyLength[i];
                        String value5 = "";
                        if (infoCryptoKeyLength[i].contains(":")) {
                            label = infoCryptoKeyLength[i].split(":")[0];
                            value5 = infoCryptoKeyLength[i].split(":")[1];
                        }
                        de = this.newDataElementStyleRuntime();
                        de.setLabel(label);
                        if (value5 != null) {
                            value5 = StringEscapeUtils.escapeHtml4((String)value5);
                        }
                        de.setValue(value5);
                        de.setType(DataElementType.TEXT);
                        de.setName("infoCrypto_" + i);
                        de.setSize(this.getSize());
                        dati.add(de);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante la lettura delle informazioni sulla lunghezza delle chiavi di cifratura (jmxResourcePdD): " + e.getMessage(), e);
                    }
                }
            }
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Informazioni Charset");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] infoCharset = null;
        try {
            String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCharset(alias));
            if (this.isErroreHttp(tmp, "informazioni Charset")) {
                tmp = null;
            }
            infoCharset = tmp != null ? tmp.split("\n") : null;
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle informazioni sull'internazionalizzazione (jmxResourcePdD): " + e.getMessage(), e);
        }
        if (infoCharset == null || infoCharset.length <= 0) {
            this.addInformazioneNonDisponibile(dati, "");
        } else {
            for (int i = 0; i < infoCharset.length; ++i) {
                try {
                    label = infoCharset[i];
                    String value6 = "";
                    if (infoCharset[i].contains(":")) {
                        label = infoCharset[i].split(":")[0];
                        value6 = infoCharset[i].substring(infoCharset[i].indexOf(":") + 1);
                    }
                    de = this.newDataElementStyleRuntime();
                    if (value6 == null || "".equals(value6)) {
                        value6 = label;
                        label = "Name";
                    }
                    de.setLabel(label);
                    if (value6 != null) {
                        value6 = StringEscapeUtils.escapeHtml4((String)value6);
                    }
                    de.setValue(value6);
                    de.setType(DataElementType.TEXT);
                    de.setName("infoCharset_" + i);
                    de.setSize(this.getSize());
                    dati.add(de);
                    continue;
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura delle informazioni sul charset (jmxResourcePdD): " + e.getMessage(), e);
                }
            }
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Informazioni Internazionalizzazione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] infoInternazionalizzazione = null;
        try {
            String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniInternazionalizzazione(alias));
            if (this.isErroreHttp(tmp, "informazioni Internazionalizzazione")) {
                tmp = null;
            }
            infoInternazionalizzazione = tmp != null ? tmp.split("\n") : null;
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle informazioni sull'internazionalizzazione (jmxResourcePdD): " + e.getMessage(), e);
        }
        if (infoInternazionalizzazione == null || infoInternazionalizzazione.length <= 0) {
            this.addInformazioneNonDisponibile(dati, "");
        } else {
            for (int i = 0; i < infoInternazionalizzazione.length; ++i) {
                try {
                    String label5 = infoInternazionalizzazione[i];
                    String value7 = "";
                    if (infoInternazionalizzazione[i].contains(":")) {
                        label5 = infoInternazionalizzazione[i].split(":")[0];
                        value7 = infoInternazionalizzazione[i].substring(infoInternazionalizzazione[i].indexOf(":") + 1);
                    }
                    de = this.newDataElementStyleRuntime();
                    if (value7 == null || "".equals(value7)) {
                        value7 = label5;
                        label5 = "Name";
                    }
                    de.setLabel(label5);
                    if (value7 != null) {
                        value7 = StringEscapeUtils.escapeHtml4((String)value7);
                    }
                    de.setValue(value7);
                    de.setType(DataElementType.TEXT);
                    de.setName("infoI18N_" + i);
                    de.setSize(this.getSize());
                    dati.add(de);
                    continue;
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura delle informazioni sull'internazionalizzazione (jmxResourcePdD): " + e.getMessage(), e);
                }
            }
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Informazioni TimeZone");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] infoTimezone = null;
        try {
            String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniTimeZone(alias));
            if (this.isErroreHttp(tmp, "informazioni Internazionalizzazione")) {
                tmp = null;
            }
            infoTimezone = tmp != null ? tmp.split("\n") : null;
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle informazioni sul TimeZone (jmxResourcePdD): " + e.getMessage(), e);
        }
        if (infoTimezone == null || infoTimezone.length <= 0) {
            this.addInformazioneNonDisponibile(dati, "");
        } else {
            for (int i = 0; i < infoTimezone.length; ++i) {
                try {
                    String label6 = infoTimezone[i];
                    String value8 = "";
                    if (infoTimezone[i].contains(":")) {
                        label6 = infoTimezone[i].split(":")[0];
                        value8 = infoTimezone[i].substring(infoTimezone[i].indexOf(":") + 1);
                    }
                    de = this.newDataElementStyleRuntime();
                    if (value8 == null || "".equals(value8)) {
                        value8 = label6;
                        label6 = "Name";
                    }
                    de.setLabel(label6);
                    if (value8 != null) {
                        value8 = StringEscapeUtils.escapeHtml4((String)value8);
                    }
                    de.setValue(value8);
                    de.setType(DataElementType.TEXT);
                    de.setName("infoTimeZone_" + i);
                    de.setSize(this.getSize());
                    dati.add(de);
                    continue;
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura delle informazioni sul TimeZone (jmxResourcePdD): " + e.getMessage(), e);
                }
            }
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Informazioni Java Networking");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] infoJavaNet = null;
        try {
            String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniProprietaJavaNetworking(alias));
            if (this.isErroreHttp(tmp, "informazioni Java Networking")) {
                tmp = null;
            }
            infoJavaNet = tmp != null ? tmp.split("\n") : null;
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle informazioni di Java Networking (jmxResourcePdD): " + e.getMessage(), e);
        }
        if (infoJavaNet == null || infoJavaNet.length <= 0) {
            this.addInformazioneNonDisponibile(dati, "");
        } else {
            for (int i = 0; i < infoJavaNet.length; ++i) {
                try {
                    if (infoJavaNet[i] == null || "".equals(infoJavaNet[i].trim())) continue;
                    label2 = infoJavaNet[i];
                    value = "";
                    if (infoJavaNet[i].contains("=")) {
                        label2 = infoJavaNet[i].split("=")[0];
                        value = infoJavaNet[i].substring(infoJavaNet[i].indexOf("=") + 1);
                    }
                    de = this.newDataElementStyleRuntime();
                    if (value == null || "".equals(value)) {
                        if (label2.startsWith("SecurityManager ")) {
                            String tmp = label2;
                            label2 = "SecurityManager";
                            value = tmp.substring("SecurityManager ".length());
                        } else {
                            value = label2;
                            label2 = "Name";
                        }
                    }
                    de.setLabel(label2);
                    if (value != null) {
                        value = StringEscapeUtils.escapeHtml4((String)value);
                    }
                    de.setValue(value);
                    de.setType(DataElementType.TEXT);
                    de.setName("infoJavaNet_" + i);
                    de.setSize(this.getSize());
                    dati.add(de);
                    continue;
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura delle informazioni di Java Networking (jmxResourcePdD): " + e.getMessage(), e);
                }
            }
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Informazioni Profili Interoperabilit\u00e0");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] infoProtocolli = null;
        try {
            String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoPluginProtocols(alias));
            infoProtocolli = tmp.split("\n");
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle informazioni sui protocolli (jmxResourcePdD): " + e.getMessage(), e);
        }
        if (infoProtocolli == null || infoProtocolli.length <= 0) {
            this.addInformazioneNonDisponibile(dati, "");
        } else {
            boolean addProtocollo = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < infoProtocolli.length; ++i) {
                try {
                    String context = infoProtocolli[i].split(" ")[0];
                    String protocol = infoProtocolli[i].split(" ")[1];
                    protocol = protocol.split(":")[1];
                    protocol = protocol.substring(0, protocol.length() - 1);
                    if (map.containsKey(protocol)) {
                        String c = (String)map.remove(protocol);
                        map.put(protocol, c + ", " + context);
                        continue;
                    }
                    map.put(protocol, context);
                    continue;
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura delle informazioni sui protocolli (jmxResourcePdD): " + e.getMessage(), e);
                }
            }
            int index = 0;
            for (String protocollo : map.keySet()) {
                addProtocollo = true;
                de = this.newDataElementStyleRuntime();
                de.setLabel(protocollo);
                Object value9 = "contesti: " + (String)map.get(protocollo);
                if (value9 != null) {
                    value9 = StringEscapeUtils.escapeHtml4((String)value9);
                }
                de.setValue((String)value9);
                de.setType(DataElementType.TEXT);
                de.setName("infoProtocollo_" + index);
                de.setSize(this.getSize());
                dati.add(de);
                ++index;
            }
            if (!addProtocollo) {
                this.addInformazioneNonDisponibile(dati, "");
            }
        }
        caches = this.confCore.getJmxPdDCaches(alias);
        if (caches != null && !caches.isEmpty()) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("Cache ");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            for (String cache : caches) {
                int i;
                String stato;
                block297: {
                    de = this.newDataElementStyleRuntime();
                    de.setLabel(cache);
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                    stato = null;
                    try {
                        stato = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), cache, this.confCore.getJmxPdDCacheNomeAttributoCacheAbilitata(alias));
                        if (stato.equalsIgnoreCase("true")) {
                            stato = "abilitata";
                            break block297;
                        }
                        if (stato.equalsIgnoreCase("false")) {
                            stato = "disabilitata";
                            break block297;
                        }
                        throw new DriverControlStationException("Stato [" + stato + "] sconosciuto");
                    }
                    catch (Exception e) {
                        this.logError("Errore durante la lettura dello stato della cache [" + cache + "](jmxResourcePdD): " + e.getMessage(), e);
                        stato = "Informazione non disponibile";
                    }
                }
                if ("abilitata".equals(stato)) {
                    de = this.newDataElementStyleRuntime();
                    de.setLabel("Svuota tutte le Cache");
                    de.setUrl("configurazioneSistemaAdd.do?aliasNodo=" + alias + "&nomeCache=" + cache + "&nomeMetodo=" + this.confCore.getJmxPdDCacheNomeMetodoResetCache(alias));
                    de.setType(DataElementType.LINK);
                    de.setName("ResetCache");
                    de.setValue("Svuota la Cache");
                    de.setSize(this.getSize());
                    dati.add(de);
                    if (this.confCore.getJmxPdDCachesPrefill(alias).contains(cache)) {
                        de = this.newDataElementStyleRuntime();
                        de.setLabel("Prefill Cache");
                        de.setUrl("configurazioneSistemaAdd.do?aliasNodo=" + alias + "&nomeCache=" + cache + "&nomeMetodo=" + this.confCore.getJmxPdDCacheNomeMetodoPrefillCache(alias));
                        de.setType(DataElementType.LINK);
                        de.setName("PrefillCache");
                        de.setValue("PrefillCache");
                        de.setSize(this.getSize());
                        dati.add(de);
                    }
                }
                de = this.newDataElementStyleRuntime();
                de.setLabel("Stato");
                de.setValue(stato);
                de.setType(DataElementType.TEXT);
                de.setName("Stato");
                de.setSize(this.getSize());
                dati.add(de);
                if (!"abilitata".equals(stato)) continue;
                String[] params = null;
                try {
                    String tmp = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDCacheType(alias), cache, this.confCore.getJmxPdDCacheNomeMetodoStatoCache(alias));
                    params = tmp.split("\n");
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura dello stato della cache [" + cache + "](jmxResourcePdD): " + e.getMessage(), e);
                    stato = "Informazione non disponibile";
                }
                if (params == null || params.length <= 0) continue;
                ArrayList<String> listDe = null;
                HashMap<String, ArrayList<DataElement>> mapDe = null;
                if ("DatiRichieste".equals(cache)) {
                    listDe = new ArrayList<String>();
                    mapDe = new HashMap<String, ArrayList<DataElement>>();
                }
                String internalCache = null;
                for (i = 0; i < params.length; ++i) {
                    try {
                        String label7;
                        String labelCorretta = label7 = params[i];
                        String value10 = "";
                        if (params[i].contains(":")) {
                            labelCorretta = label7 = params[i].split(":")[0];
                            value10 = params[i].split(":")[1];
                            if ("ElementiInCache".equals(label7)) {
                                labelCorretta = "Elementi in Cache";
                            } else if ("MemoriaOccupata".equals(label7)) {
                                labelCorretta = "Memoria Occupata";
                            } else if ("IdleTime".equals(label7)) {
                                labelCorretta = "Idle Time";
                            } else if ("LifeTime".equals(label7)) {
                                labelCorretta = "Life Time";
                            }
                        }
                        if ("DatiRichieste".equals(cache)) {
                            if ("Nome".equals(label7)) {
                                internalCache = value10;
                                if (value10.startsWith("gestoreRichieste-")) {
                                    internalCache = value10.substring("gestoreRichieste-".length());
                                }
                                listDe.add(internalCache);
                                continue;
                            }
                            if ("ElementiInCache".equals(label7) || "MemoriaOccupata".equals(label7)) {
                                de = this.newDataElementStyleRuntime();
                                de.setLabel(labelCorretta);
                                if (value10 != null) {
                                    value10 = StringEscapeUtils.escapeHtml4((String)value10);
                                }
                                de.setValue(value10);
                                de.setType(DataElementType.TEXT);
                                de.setName("Stato_" + i);
                                de.setSize(this.getSize());
                                ArrayList<DataElement> l = (ArrayList<DataElement>)mapDe.get(internalCache);
                                if (l == null) {
                                    l = new ArrayList<DataElement>();
                                    mapDe.put(internalCache, l);
                                }
                                l.add(de);
                                continue;
                            }
                        }
                        if (!ConfigurazioneCostanti.CONFIGURAZIONE_SISTEMA_CACHE_STATO_ELEMENTI_VISUALIZZATI.contains(label7) || listDe != null && listDe.size() > 1) continue;
                        de = this.newDataElementStyleRuntime();
                        de.setLabel(labelCorretta);
                        if (value10 != null) {
                            value10 = StringEscapeUtils.escapeHtml4((String)value10);
                        }
                        de.setValue(value10);
                        de.setType(DataElementType.TEXT);
                        de.setName("Stato_" + i);
                        de.setSize(this.getSize());
                        dati.add(de);
                        continue;
                    }
                    catch (Exception e) {
                        this.logError("Errore durante la lettura dello stato della cache [" + cache + "]: " + e.getMessage(), e);
                    }
                }
                if (listDe == null || listDe.isEmpty()) continue;
                i = 0;
                for (String internalCacheName : listDe) {
                    de = this.newDataElementStyleRuntime();
                    de.setLabel("");
                    de.setValue("<i>" + internalCacheName + "</i>");
                    de.setType(DataElementType.TEXT);
                    de.setName("Stato_int_" + i);
                    de.setSize(this.getSize());
                    dati.add(de);
                    ++i;
                    List lDe = (List)mapDe.get(internalCacheName);
                    if (lDe == null || lDe.isEmpty()) continue;
                    for (DataElement dea : lDe) {
                        dati.add(dea);
                    }
                }
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Cache DPoP JTI (Anti-Replay)");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            String statoDPoPJti = null;
            try {
                statoDPoPJti = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaGestioneToken(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoPrintStatsDPoPJtiCaches(alias));
                if (this.isErroreHttp(statoDPoPJti, "statistiche cache DPoP JTI")) {
                    statoDPoPJti = "Nessuna cache DPoP JTI attiva";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura delle statistiche cache DPoP JTI (jmxResourcePdD): " + e.getMessage(), e);
                statoDPoPJti = "Nessuna cache DPoP JTI attiva";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            de.setValue(statoDPoPJti);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("cacheDpopJtiStato");
            de.setSize(this.getSize());
            de.setRows(10);
            de.setCols(80);
            dati.add(de);
        }
        String stato = null;
        if (!this.confCore.isClusterAsyncUpdate()) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("Connessioni Attive");
            de.setType(DataElementType.TITLE);
            de.abilitaRefresh();
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setLabel("Database");
            de.setType(DataElementType.SUBTITLE);
            de.abilitaRefresh();
            dati.add(de);
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniDB(alias));
                if (this.isErroreHttp(stato, "stato delle connessioni al database")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura dello stato delle connessioni al database (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("connessioniDB");
            de.setSize(this.getSize());
            de.setRows(6);
            de.setCols(80);
            dati.add(de);
            if (statoConnessioniAltriDB != null && statoConnessioniAltriDB.size() > 0) {
                Iterator it = statoConnessioniAltriDB.keySet().iterator();
                int index = 0;
                while (it.hasNext()) {
                    String idAltroDB = (String)it.next();
                    String statoConnessioniAltroDB = (String)statoConnessioniAltriDB.get(idAltroDB);
                    de = this.newDataElementStyleRuntime();
                    de.setLabel("Database " + idAltroDB.split(" ")[0]);
                    de.setType(DataElementType.SUBTITLE);
                    de.abilitaRefresh();
                    dati.add(de);
                    de = this.newDataElementStyleRuntime();
                    de.setLabel("Stato");
                    de.setValue(statoConnessioniAltroDB);
                    de.setLabelAffiancata(false);
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setName("connessioniDB_ds" + index++);
                    de.setSize(this.getSize());
                    de.setRows(6);
                    de.setCols(80);
                    dati.add(de);
                }
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Broker JMS");
            de.setType(DataElementType.SUBTITLE);
            de.abilitaRefresh();
            dati.add(de);
            stato = null;
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniJMS(alias));
                if (this.isErroreHttp(stato, "stato delle connessioni JMS")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura dello stato delle connessioni JMS (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("connessioniJMS");
            de.setSize(this.getSize());
            de.setRows(6);
            de.setCols(80);
            dati.add(de);
        }
        if (!this.confCore.isClusterAsyncUpdate()) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("Transazioni Attive");
            de.setType(DataElementType.TITLE);
            de.abilitaRefresh();
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setLabel("Identificativi");
            de.setType(DataElementType.SUBTITLE);
            de.abilitaRefresh();
            dati.add(de);
            stato = null;
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoIdTransazioniAttive(alias));
                if (this.isErroreHttp(stato, "identificativi delle transazioni attive")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura degli identificativi delle transazioni attive (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("transazioniID");
            de.setSize(this.getSize());
            de.setRows(6);
            de.setCols(80);
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setLabel("Identificativi di Protocollo");
            de.setType(DataElementType.SUBTITLE);
            de.abilitaRefresh();
            dati.add(de);
            stato = null;
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoIdProtocolloTransazioniAttive(alias));
                if (this.isErroreHttp(stato, "identificativi di protocollo delle transazioni attive")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura degli identificativi di protocollo delle transazioni attive (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("transazioniIDProt");
            de.setSize(this.getSize());
            de.setRows(6);
            de.setCols(80);
            dati.add(de);
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Connessioni HTTP Attive");
        de.setType(DataElementType.TITLE);
        de.abilitaRefresh();
        dati.add(de);
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiVerificaConnessioniAttive(alias), "timerGestoreMessaggiVerificaConnessioniAttive", "Verifica Connessioni Attive");
        if (!this.confCore.isClusterAsyncUpdate()) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("In uscita dal modulo InoltroBuste");
            de.setType(DataElementType.SUBTITLE);
            de.abilitaRefresh();
            dati.add(de);
            stato = null;
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniPD(alias));
                if (this.isErroreHttp(stato, "stato delle connessioni http verso le PD")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura dello stato delle connessioni http verso le PD (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("connessioniPD");
            de.setSize(this.getSize());
            de.setRows(6);
            de.setCols(80);
            dati.add(de);
            de = this.newDataElementStyleRuntime();
            de.setLabel("In uscita dal modulo ConsegnaContenutiApplicativi");
            de.setType(DataElementType.SUBTITLE);
            de.abilitaRefresh();
            dati.add(de);
            stato = null;
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniPA(alias));
                if (this.isErroreHttp(stato, "stato delle connessioni http verso le PA")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura dello stato delle connessioni http verso le PA (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("connessioniPA");
            de.setSize(this.getSize());
            de.setRows(6);
            de.setCols(80);
            dati.add(de);
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Thread Attivi");
        de.setType(DataElementType.TITLE);
        de.abilitaRefresh();
        dati.add(de);
        de = this.newDataElementStyleRuntime();
        de.setLabel("HTTP Client - BIO");
        de.setType(DataElementType.SUBTITLE);
        de.abilitaRefresh();
        dati.add(de);
        stato = null;
        try {
            stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.jmxPdDConfigurazioneSistemaNomeMetodoBIOHttpClientConnectionManagerStatus(alias));
            if (this.isErroreHttp(stato, "stato del connection manager http per le connessioni BIO")) {
                stato = "Informazione non disponibile";
            }
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura dello stato del connection manager http per le connessioni BIO (jmxResourcePdD): " + e.getMessage(), e);
            stato = "Informazione non disponibile";
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Stato");
        de.setValue(stato);
        de.setLabelAffiancata(false);
        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
        de.setName("bioStatus");
        de.setSize(this.getSize());
        de.setRows(2);
        de.setCols(80);
        dati.add(de);
        de = this.newDataElementStyleRuntime();
        de.setLabel("HTTP Client - NIO");
        de.setType(DataElementType.SUBTITLE);
        de.abilitaRefresh();
        dati.add(de);
        boolean nioEnabled = true;
        stato = null;
        try {
            stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.jmxPdDConfigurazioneSistemaNomeMetodoNIOHttpClientConnectionManagerStatus(alias));
            if (this.isErroreHttp(stato, "stato del connection manager http per le connessioni NIO")) {
                stato = "Informazione non disponibile";
            } else if ("Funzionalit\u00e0 disabilitata".equals(stato)) {
                nioEnabled = false;
            }
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura dello stato del connection manager http per le connessioni NIO (jmxResourcePdD): " + e.getMessage(), e);
            stato = "Informazione non disponibile";
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Stato");
        de.setValue(stato);
        de.setLabelAffiancata(false);
        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
        de.setName("nioStatus");
        de.setSize(this.getSize());
        de.setRows(2);
        de.setCols(80);
        dati.add(de);
        if (nioEnabled) {
            stato = null;
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.jmxPdDConfigurazioneSistemaNomeMetodoNIOWorkerThreadPoolStatus(alias));
                if (this.isErroreHttp(stato, "stato del pool di thread utilizzata per inviare la richiesta in streaming tramite connettore HTTP NIO")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura dello stato del pool di thread utilizzata per inviare la richiesta in streaming tramite connettore HTTP NIO (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Threads Pool");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("nioThPool");
            de.setSize(this.getSize());
            de.setRows(3);
            de.setCols(80);
            dati.add(de);
            stato = null;
            try {
                stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), this.confCore.jmxPdDConfigurazioneSistemaNomeMetodoNIOHttpClientConnectionManagerIOThreadCount(alias));
                if (this.isErroreHttp(stato, "numero di thread dedicati per IORactor del connettore HTTP NIO")) {
                    stato = "Informazione non disponibile";
                }
            }
            catch (Exception e) {
                this.logError("Errore durante la lettura del numero di thread dedicati per IORactor del connettore HTTP NIO (jmxResourcePdD): " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Threads IO-Reactor");
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("nioThIO");
            de.setSize(this.getSize());
            de.setRows(1);
            de.setCols(80);
            dati.add(de);
        }
        List<String> code = this.confCore.getConsegnaNotificaCode();
        de = this.newDataElementStyleRuntime();
        de.setLabel("Consegna Notifiche");
        de.setType(DataElementType.SUBTITLE);
        de.abilitaRefresh();
        dati.add(de);
        boolean timerAttivo = this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerConsegnaContenutiApplicativi(alias), "timerConsegnaContenutiApplicativi", "Stato");
        if (timerAttivo) {
            for (String coda : code) {
                String labelCoda = this.confCore.getConsegnaNotificaCodaLabel(coda);
                if (code.size() > 1) {
                    de = this.newDataElementStyleRuntime();
                    de.setLabel(labelCoda);
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                }
                stato = null;
                try {
                    stato = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetThreadPoolStatus(alias), coda);
                    if (this.isErroreHttp(stato, "stato del thread pool per la consegna agli applicativi")) {
                        stato = "Informazione non disponibile";
                    }
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura dello stato del thread pool per la consegna agli applicativi (jmxResourcePdD): " + e.getMessage(), e);
                    stato = "Informazione non disponibile";
                }
                de = this.newDataElementStyleRuntime();
                de.setLabel("Threads Pool");
                de.setValue(stato);
                de.setLabelAffiancata(false);
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                de.setName("threadsPA");
                de.setSize(this.getSize());
                de.setRows(2);
                de.setCols(80);
                dati.add(de);
                String configurazioneCoda = null;
                try {
                    configurazioneCoda = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetQueueConfig(alias), coda);
                    if (this.isErroreHttp(configurazioneCoda, "Configurazione del thread pool '" + labelCoda + "' per la consegna agli applicativi")) {
                        configurazioneCoda = "Informazione non disponibile";
                    }
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura della configurazione del thread pool '" + labelCoda + "' per la consegna agli applicativi (jmxResourcePdD): " + e.getMessage(), e);
                    configurazioneCoda = "Informazione non disponibile";
                }
                de = this.newDataElementStyleRuntime();
                de.setLabel("Configurazione");
                de.setValue(configurazioneCoda);
                de.setLabelAffiancata(false);
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                de.setName("threadsPACfg");
                de.setSize(this.getSize());
                de.setRows(2);
                de.setCols(80);
                dati.add(de);
                String connettoriPrioritari = null;
                try {
                    connettoriPrioritari = this.confCore.getInvoker().invokeJMXMethod(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetConnettoriPrioritari(alias), coda);
                    if (this.isErroreHttp(connettoriPrioritari, "Connettori prioritari del thread pool '" + labelCoda + "' per la consegna agli applicativi")) {
                        connettoriPrioritari = "Informazione non disponibile";
                    }
                }
                catch (Exception e) {
                    this.logError("Errore durante la lettura dei connettori prioritari del thread pool '" + labelCoda + "' per la consegna agli applicativi (jmxResourcePdD): " + e.getMessage(), e);
                    connettoriPrioritari = "Informazione non disponibile";
                }
                de = this.newDataElementStyleRuntime();
                de.setLabel("Consegna Immediata");
                de.setValue(connettoriPrioritari);
                de.setLabelAffiancata(false);
                de.setName("threadsPAPrio");
                if ("".equals(connettoriPrioritari)) {
                    de.setType(DataElementType.TEXT);
                    de.setValue("Nessun Connettore");
                } else {
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setSize(this.getSize());
                    de.setRows(2);
                    de.setCols(80);
                }
                dati.add(de);
                if ("".equals(connettoriPrioritari)) continue;
                de = this.newDataElementStyleRuntime();
                de.setLabel("Disattiva la 'Consegna Immediata' da tutti i connettori");
                de.setUrl("configurazioneSistemaAdd.do?aliasNodo=" + alias + "&nomeCache=" + coda + "&nomeMetodo=" + this.confCore.getJmxPdDConfigurazioneSistemaNomeMetodoResetConnettoriPrioritari(alias));
                de.setType(DataElementType.LINK);
                de.setName("EliminaConnettoriPrioritari");
                de.setValue("Disattiva la 'Consegna Immediata' da tutti i connettori");
                de.setSize(this.getSize());
                dati.add(de);
            }
        }
        if (code.size() > 1) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("Thread Attivi");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Generazione Statistiche");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheOrarie(alias), "timerStatisticheOrarie", "Orarie");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheGiornaliere(alias), "timerStatisticheGiornaliere", "Giornaliere");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheSettimanali(alias), "timerStatisticheSettimanali", "Settimanali");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheMensili(alias), "timerStatisticheMensili", "Mensili");
        if (ProtocolFactoryManager.getInstance().existsProtocolFactory("modipa")) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("Tracciamento PDND");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerPdndTracciamentoGenerazione(alias), "timerPdndTracciamentoGenerazione", "Generazione");
            this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerPdndTracciamentoPubblicazione(alias), "timerPdndTracciamentoPubblicazione", "Pubblicazione");
            de = this.newDataElementStyleRuntime();
            de.setLabel("Repository Chiavi PDND");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreChiaviPDND(alias), "timerChiaviPDND", "Gestione Eventi");
            this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreCacheChiaviPDND(alias), "timerCacheChiaviPDND", "Gestione Cache");
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Pulizia Repository di Runtime");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiEliminati(alias), "timerGestoreMessaggiPuliziaMessaggiEliminati", "Messaggi Gestiti");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiScaduti(alias), "timerGestoreMessaggiPuliziaMessaggiScaduti", "Messaggi Scaduti");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreRepositoryBuste(alias), "timerGestoreRepositoryBuste", "Buste Gestite/Scadute");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaCorrelazioneApplicativa(alias), "timerGestoreMessaggiPuliziaCorrelazioneApplicativa", "Correlazioni Applicative Scadute");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiNonGestiti(alias), "timerGestoreMessaggiPuliziaMessaggiNonGestiti", "Richieste Parziali");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestorePuliziaMessaggiAnomali(alias), "timerGestorePuliziaMessaggiAnomali", "Messaggi Inconsistenti");
        if (this.confCore.isClusterAsyncUpdate()) {
            this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreOperazioniRemote(alias), "timerGestoreOpRemote", "Esecuzione Operazioni Remote", true);
            this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerSvecchiamentoOperazioniRemote(alias), "timerDeleteOpRemote", "Svecchiamento Operazioni");
        }
        de = this.newDataElementStyleRuntime();
        de.setLabel("Monitoraggio Risorse");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerMonitoraggioRisorseThread(alias), "timerMonitoraggioRisorseThread", "Risorse di Sistema");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerThresholdThread(alias), "timerThresholdThread", "Spazio Disco");
        de = this.newDataElementStyleRuntime();
        de.setLabel("Attivit\u00e0 di Sistema");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerEventi(alias), "timerEventi", "Generazione Eventi");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerFileSystemRecovery(alias), "timerFileSystemRecovery", "FileSystem Recovery");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreBusteOnewayNonRiscontrate(alias), "timerGestoreBusteOnewayNonRiscontrate", "Rispedizione Ack Oneway");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreBusteAsincroneNonRiscontrate(alias), "timerGestoreBusteAsincroneNonRiscontrate", "Rispedizione Ack Asincroni");
        this.addTimerState(dati, alias, this.confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerRepositoryStatefulThread(alias), "timerRepositoryStatefulThread", "Repository Stateful");
        if (this.confCore.isConfigurazioneAllarmiEnabled()) {
            de = this.newDataElementStyleRuntime();
            de.setLabel("Allarmi Attivi");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            AlarmEngineConfig alarmEngineConfig = this.confCore.getAllarmiConfig();
            stato = null;
            try {
                stato = AllarmiUtils.getActiveThreadImages((Logger)this.log, (AlarmEngineConfig)alarmEngineConfig);
            }
            catch (Exception e) {
                this.logError("Riscontrato errore durante la lettura dello stato degli allarmi attivi: " + e.getMessage(), e);
                stato = "Informazione non disponibile";
            }
            if (stato != null && !"".equals(stato)) {
                de = this.newDataElementStyleRuntime();
                de.setName("allarmiAttiviStop");
                de.setLabel("Termina tutti gli allarmi");
                de.setValue("Termina tutti gli allarmi");
                de.setUrl("configurazioneSistemaAdd.do?aliasNodo=" + alias + "&allarmiAttiviManager=allarmiAttiviStop");
                de.setType(DataElementType.LINK);
                dati.add(de);
                de = this.newDataElementStyleRuntime();
                de.setName("allarmiAttiviRestart");
                de.setLabel("Riavvia tutti gli allarmi");
                de.setValue("Riavvia tutti gli allarmi");
                de.setUrl("configurazioneSistemaAdd.do?aliasNodo=" + alias + "&allarmiAttiviManager=allarmiAttiviRestart");
                de.setType(DataElementType.LINK);
                dati.add(de);
            } else {
                boolean existsAllarmi = this.confCore.existsAllarmi(TipoAllarme.ATTIVO);
                if (existsAllarmi) {
                    de = this.newDataElementStyleRuntime();
                    de.setName("allarmiAttiviStart");
                    de.setLabel("Avvia tutti gli allarmi");
                    de.setValue("Avvia tutti gli allarmi");
                    de.setUrl("configurazioneSistemaAdd.do?aliasNodo=" + alias + "&allarmiAttiviManager=allarmiAttiviStart");
                    de.setType(DataElementType.LINK);
                    dati.add(de);
                }
            }
            de = this.newDataElementStyleRuntime();
            de.setLabel("Stato");
            if ("".equals(stato)) {
                stato = "Nessun allarme attivo";
            }
            de.setValue(stato);
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setName("allarmiAttivi");
            de.setSize(this.getSize());
            de.setRows(5);
            de.setCols(80);
            dati.add(de);
        }
        return dati;
    }

    private boolean addTimerState(List<DataElement> dati, String alias, String nomeAttributo, String nomeParametro, String labelParametro) {
        return this.addTimerState(dati, alias, nomeAttributo, nomeParametro, labelParametro, false);
    }

    private boolean addTimerState(List<DataElement> dati, String alias, String nomeAttributo, String nomeParametro, String labelParametro, boolean forceText) {
        try {
            String stato = this.confCore.getInvoker().readJMXAttribute(alias, this.confCore.getJmxPdDConfigurazioneSistemaType(alias), this.confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), nomeAttributo);
            TimerState timerState = TimerState.valueOf((String)stato);
            DataElement de = this.newDataElementStyleRuntime();
            de.setName(nomeParametro);
            de.setLabel(labelParametro);
            if (TimerState.OFF.equals((Object)timerState)) {
                de.setType(DataElementType.TEXT);
                de.setValue(TimerState.OFF.name());
            } else if (forceText) {
                de.setType(DataElementType.TEXT);
                switch (timerState) {
                    case ENABLED: {
                        de.setValue(CostantiConfigurazione.ABILITATO.getValue());
                        break;
                    }
                    case DISABLED: {
                        de.setValue(CostantiConfigurazione.DISABILITATO.getValue());
                        break;
                    }
                    default: {
                        de.setValue(TimerState.OFF.name());
                        break;
                    }
                }
            } else {
                String[] labels = new String[]{CostantiConfigurazione.ABILITATO.getValue(), CostantiConfigurazione.DISABILITATO.getValue()};
                String[] values = new String[]{TimerState.ENABLED.name(), TimerState.DISABLED.name()};
                de.setType(DataElementType.SELECT);
                de.setValues(values);
                de.setLabels(labels);
                de.setSelected(stato);
                de.setPostBack_viaPOST(true);
            }
            dati.add(de);
            return !TimerState.OFF.equals((Object)timerState);
        }
        catch (Exception e) {
            this.logError("Errore durante la lettura delle informazioni sul '" + nomeAttributo + "' (jmxResourcePdD): " + e.getMessage(), e);
            this.addInformazioneNonDisponibile(dati, labelParametro);
            return false;
        }
    }

    public boolean isErroreHttp(String stato, String risorsa) {
        if (stato != null && stato.startsWith("[httpCode ")) {
            this.logError("Errore durante la lettura della risorsa [" + risorsa + "]: " + stato);
            return true;
        }
        return false;
    }

    public boolean checkConfigurazioneTracciamento(TipoOperazione tipoOperazione, String configurazioneEsiti, String tipoConfigurazione) throws DriverControlStationException {
        if ("trace".equals(tipoConfigurazione)) {
            String registrazioneTracce = this.getParameter("registrazioneTracce");
            if (!registrazioneTracce.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !registrazioneTracce.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO)) {
                this.pd.setMessage("Buste dev'essere abilitato o disabilitato");
                return false;
            }
        } else if (!"tracePD".equals(tipoConfigurazione) && !"tracePA".equals(tipoConfigurazione) && "dump".equals(tipoConfigurazione)) {
            String dumpApplicativo = this.getParameter("dump");
            String dumpPD = this.getParameter("dumpConnettorePD");
            String dumpPA = this.getParameter("dumpConnettorePA");
            if (!dumpApplicativo.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !dumpApplicativo.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO)) {
                this.pd.setMessage("Dump Applicativo dev'essere abilitato o disabilitato");
                return false;
            }
            if (!dumpPD.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !dumpPD.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO)) {
                this.pd.setMessage("Dump Binario Porta Delegata dev'essere abilitato o disabilitato");
                return false;
            }
            if (!dumpPA.equals(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO) && !dumpPA.equals(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO)) {
                this.pd.setMessage("Dump Binario Porta Applicativa dev'essere abilitato o disabilitato");
                return false;
            }
        }
        return true;
    }

    public void addConfigurazionControlloTrafficoToDati(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazioneGenerale configurazioneControlloTraffico, long sizePolicy, long sizeGlobalPolicy, boolean configurazioneTerminata) throws Exception {
        boolean first = this.isFirstTimeFromHttpParameters("CTFirstTime");
        this.addToDatiConfigurazioneControlloTraffico(dati, tipoOperazione, configurazioneControlloTraffico.getControlloTraffico());
        this.addToDatiConfigurazioneRateLimiting(dati, tipoOperazione, configurazioneControlloTraffico, first, configurazioneTerminata, sizePolicy, sizeGlobalPolicy);
        DataElement de = new DataElement();
        de.setLabel("Tempi Risposta");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        this.addToDatiTempiRispostaFruizione(dati, tipoOperazione, true, configurazioneControlloTraffico.getTempiRispostaFruizione());
        this.addToDatiTempiRispostaErogazione(dati, tipoOperazione, true, configurazioneControlloTraffico.getTempiRispostaErogazione());
        this.addToDatiConfigurazioneCache(dati, tipoOperazione, configurazioneControlloTraffico.getCache(), this.isModalitaAvanzata());
        this.addToDatiFirstTimeDisabled(dati, "CTFirstTime");
    }

    public void addToDatiConfigurazioneControlloTraffico(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazioneControlloTraffico controlloTraffico) throws Exception {
        TipoErrore tipoErroEnum;
        DataElement de = new DataElement();
        de.setLabel("Limitazione Numero di Richieste Complessive");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("CTNumMaxReqStato");
        de.setType(DataElementType.SELECT);
        de.setValues(ConfigurazioneCostanti.STATI_CON_WARNING);
        if (controlloTraffico != null && controlloTraffico.isControlloMaxThreadsEnabled()) {
            if (controlloTraffico.isControlloMaxThreadsWarningOnly()) {
                de.setSelected(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.getValue());
            } else {
                de.setSelected(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.getValue());
            }
        } else {
            de.setSelected(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.getValue());
        }
        de.setPostBack(true);
        dati.add(de);
        Long numeroThreadComplessivi = null;
        de = new DataElement();
        de.setLabel("Max Richieste Simultanee");
        de.setName("CTNumMaxReqSoglia");
        if (controlloTraffico != null && controlloTraffico.isControlloMaxThreadsEnabled()) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (controlloTraffico != null && controlloTraffico.getControlloMaxThreadsSoglia() != null) {
            numeroThreadComplessivi = controlloTraffico.getControlloMaxThreadsSoglia();
            de.setValue("" + numeroThreadComplessivi);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Includi Descrizione Errore");
        de.setName("CTNumMaxReqTipoErroreDescr");
        if (!this.isModalitaStandard() && controlloTraffico.isControlloMaxThreadsEnabled() && !controlloTraffico.isControlloMaxThreadsWarningOnly()) {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(controlloTraffico.isControlloMaxThreadsTipoErroreIncludiDescrizione());
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + controlloTraffico.isControlloMaxThreadsTipoErroreIncludiDescrizione());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo Errore per le API SOAP");
        de.setName("CTNumMaxReqTipoErrore");
        if (controlloTraffico.isControlloMaxThreadsEnabled() && !controlloTraffico.isControlloMaxThreadsWarningOnly()) {
            if (this.isModalitaStandard()) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(ConfigurazioneCostanti.TIPI_ERRORE);
                de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_ERRORE);
                if (controlloTraffico.getControlloMaxThreadsTipoErrore() != null && (tipoErroEnum = TipoErrore.toEnumConstant((String)controlloTraffico.getControlloMaxThreadsTipoErrore())) != null) {
                    de.setSelected(tipoErroEnum.getValue());
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (controlloTraffico.getControlloMaxThreadsTipoErrore() != null && (tipoErroEnum = TipoErrore.toEnumConstant((String)controlloTraffico.getControlloMaxThreadsTipoErrore())) != null) {
            de.setValue(tipoErroEnum.getValue());
        }
        dati.add(de);
        if (controlloTraffico.isControlloMaxThreadsEnabled()) {
            de = new DataElement();
            de.setName("CTStateView");
            de.setLabel("Visualizza Informazioni Runtime");
            de.setValue("Visualizza Informazioni Runtime");
            de.setUrl("configurazioneControlloTrafficoRuntime.do");
            de.setType(DataElementType.LINK);
            dati.add(de);
        }
        if (controlloTraffico.isControlloMaxThreadsEnabled()) {
            de = new DataElement();
            de.setLabel("Controllo della Congestione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato");
            de.setName("CTStatoControlloCongestione");
            de.setType(DataElementType.SELECT);
            de.setValues(ConfigurazioneCostanti.STATI);
            de.setSelected(controlloTraffico.isControlloCongestioneEnabled() ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
            de.setPostBack(true);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Soglia di Attivazione (%)");
            de.setName("CTpercentualeCongestioneThreshold");
            if (controlloTraffico.isControlloCongestioneEnabled()) {
                de.setType(DataElementType.SELECT);
                String[] v = new String[100];
                for (int i = 0; i < 100; ++i) {
                    v[i] = "" + (i + 1);
                }
                de.setValues(v);
                if (controlloTraffico.getControlloCongestioneThreshold() != null) {
                    de.setSelected("" + controlloTraffico.getControlloCongestioneThreshold());
                }
                de.setPostBack(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            if (controlloTraffico.getControlloCongestioneThreshold() != null) {
                de.setValue("" + controlloTraffico.getControlloCongestioneThreshold());
            }
            dati.add(de);
            Integer soglia = controlloTraffico.getControlloCongestioneThreshold();
            Long numeroThreadCongestionamento = null;
            if (numeroThreadComplessivi != null && soglia != null) {
                double numD = numeroThreadComplessivi.doubleValue();
                double totale = 100.0;
                double sogliaD = soglia.doubleValue();
                Double numeroThreadCongestionamentoD = numD / totale * sogliaD;
                numeroThreadCongestionamento = numeroThreadCongestionamentoD.longValue();
            }
            if (numeroThreadCongestionamento != null && controlloTraffico.isControlloCongestioneEnabled()) {
                de = new DataElement();
                de.setType(DataElementType.NOTE);
                de.setValue("GovWay viene considerato congestionato se vengono superate le NUM richieste simultanee".replace("NUM", "" + numeroThreadCongestionamento));
                dati.add(de);
            }
        }
    }

    public void addToDatiConfigurazioneRateLimiting(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazioneGenerale controlloTraffico, boolean first, boolean finished, long sizePolicy, long sizeGlobalPolicy) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Rate Limiting");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Includi Descrizione Errore");
        de.setName("CTRateLimitTipoErroreDescr");
        if (this.isModalitaStandard()) {
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + controlloTraffico.getRateLimiting().isTipoErroreIncludiDescrizione());
        } else {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(controlloTraffico.getRateLimiting().isTipoErroreIncludiDescrizione());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo Errore per le API SOAP");
        de.setName("CTRateLimitTipoErrore");
        TipoErrore tipoErroEnum = null;
        if (controlloTraffico.getRateLimiting().getTipoErrore() != null) {
            tipoErroEnum = TipoErrore.toEnumConstant((String)controlloTraffico.getRateLimiting().getTipoErrore());
        }
        if (this.isModalitaStandard()) {
            de.setType(DataElementType.HIDDEN);
            if (tipoErroEnum != null) {
                de.setValue(tipoErroEnum.getValue());
            }
        } else {
            de.setType(DataElementType.SELECT);
            de.setValues(ConfigurazioneCostanti.TIPI_ERRORE);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_ERRORE);
            if (tipoErroEnum != null) {
                de.setSelected(tipoErroEnum.getValue());
            }
        }
        dati.add(de);
        ArrayList<Proprieta> listProprieta = new ArrayList<Proprieta>();
        if (controlloTraffico.getRateLimiting().sizeProprietaList() > 0) {
            for (ConfigurazioneRateLimitingProprieta rtProp : controlloTraffico.getRateLimiting().getProprietaList()) {
                Proprieta p = new Proprieta();
                p.setNome(rtProp.getNome());
                p.setValore(rtProp.getValore());
                listProprieta.add(p);
            }
        }
        PolicyConfiguration policyConfig = new PolicyConfiguration(listProprieta, this.core.getControlloTrafficoPolicyRateLimitingTipiGestori(), false);
        String ctModalitaSincronizzazione = policyConfig.getSyncMode();
        String ctImplementazione = policyConfig.getImpl();
        String ctContatori = policyConfig.getCount();
        String ctTipologia = policyConfig.getEngineType();
        String ctHeaderHttp = policyConfig.getHttpMode();
        String ctHeaderHttp_limit = policyConfig.getHttpMode_limit();
        String ctHeaderHttp_remaining = policyConfig.getHttpMode_remaining();
        String ctHeaderHttp_reset = policyConfig.getHttpMode_reset();
        String ctHeaderHttp_retryAfter = policyConfig.getHttpMode_retry_after();
        String ctHeaderHttp_retryAfterBackoff = policyConfig.getHttpMode_retry_after_backoff();
        this.addOpzioniAvanzateRateLimitingToDati(dati, false, false, ctModalitaSincronizzazione, ctImplementazione, ctContatori, ctTipologia, ctHeaderHttp, ctHeaderHttp_limit, ctHeaderHttp_remaining, ctHeaderHttp_reset, ctHeaderHttp_retryAfter, ctHeaderHttp_retryAfterBackoff);
        de = new DataElement();
        de.setLabel("Policy");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setName("CTVisualizzaPolicy");
        de.setLabel("Policy");
        de.setType(DataElementType.LINK);
        de.setUrl("configurazioneControlloTrafficoConfigurazionePolicyList.do");
        de.setValue("Registro Policy (" + sizePolicy + ")");
        dati.add(de);
        de = new DataElement();
        de.setName("CTVisualizzaPolicyGlobali");
        de.setLabel("Policy Globali");
        de.setType(DataElementType.LINK);
        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyList.do");
        de.setValue("Policy Globali (" + sizeGlobalPolicy + ")");
        dati.add(de);
    }

    public void addConfigurazioneControlloTrafficoJmxStateToDati(List<DataElement> dati, TipoOperazione tipoOperazione) throws Exception {
        List<String> aliases = this.getCore().getJmxPdDAliases();
        if (aliases == null || aliases.size() <= 0) {
            throw new DriverControlStationException("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
        }
        DataElement de = new DataElement();
        de.setLabel("Informazioni Runtime");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setName("CTStateView");
        de.setLabel("Refresh");
        de.setValue("Refresh");
        de.setUrl("configurazioneControlloTrafficoRuntime.do");
        de.setType(DataElementType.LINK);
        dati.add(de);
        for (String alias : aliases) {
            String descrizioneAlias = this.getCore().getJmxPdDDescrizione(alias);
            de = new DataElement();
            de.setLabel(descrizioneAlias);
            de.setValue(descrizioneAlias);
            de.setType(DataElementType.TITLE);
            dati.add(de);
            Object threadsAttivi = null;
            try {
                threadsAttivi = this.getCore().getInvoker().readJMXAttribute(alias, "type", "ControlloTraffico", "threadsAttivi");
            }
            catch (Exception e) {
                String errorMessage = "Errore durante il recupero dell'attributo [threadsAttivi] sulla risorsa [ControlloTraffico]: " + e.getMessage();
                ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                threadsAttivi = errorMessage;
            }
            de = new DataElement();
            de.setName("CTStateViewActiveThreads");
            de.setLabel("Richieste Attive");
            de.setType(DataElementType.TEXT);
            de.setValue((String)threadsAttivi);
            dati.add(de);
            Object pddCongestionata = null;
            try {
                pddCongestionata = this.getCore().getInvoker().readJMXAttribute(alias, "type", "ControlloTraffico", "portaDominioCongestionata");
            }
            catch (Exception e) {
                String errorMessage = "Errore durante il recupero dell'attributo [portaDominioCongestionata] sulla risorsa [ControlloTraffico]: " + e.getMessage();
                ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                pddCongestionata = errorMessage;
            }
            de = new DataElement();
            de.setName("CTStateViewCongestione");
            de.setLabel("Congestione in Corso");
            de.setType(DataElementType.TEXT);
            de.setValue((String)pddCongestionata);
            dati.add(de);
            this.getPd().disableEditMode();
        }
    }

    public void addToDatiTempiRispostaFruizione(List<DataElement> dati, TipoOperazione tipoOperazione, boolean editEnabled, TempiRispostaFruizione tempiRispostaFruizione) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Fruizioni");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Connection Timeout");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setName("CTConnectionTimeoutFruizione");
        if (editEnabled) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        if (tempiRispostaFruizione.getConnectionTimeout() != null) {
            de.setValue("" + tempiRispostaFruizione.getConnectionTimeout());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Read Timeout");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setName("CTReadTimeoutFruizione");
        if (editEnabled) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        if (tempiRispostaFruizione.getReadTimeout() != null) {
            de.setValue("" + tempiRispostaFruizione.getReadTimeout());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tempo Medio di Risposta");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setName("CTTempoMedioRispostaFruizione");
        if (editEnabled) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        if (tempiRispostaFruizione.getTempoMedioRisposta() != null) {
            de.setValue("" + tempiRispostaFruizione.getTempoMedioRisposta());
        }
        dati.add(de);
    }

    public void addToDatiTempiRispostaErogazione(List<DataElement> dati, TipoOperazione tipoOperazione, boolean editEnabled, TempiRispostaErogazione tempiRispostaErogazione) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Erogazioni");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Connection Timeout");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setName("CTConnectionTimeoutErogazione");
        if (editEnabled) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        if (tempiRispostaErogazione.getConnectionTimeout() != null) {
            de.setValue("" + tempiRispostaErogazione.getConnectionTimeout());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Read Timeout");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setName("CTReadTimeoutErogazione");
        if (editEnabled) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        if (tempiRispostaErogazione.getReadTimeout() != null) {
            de.setValue("" + tempiRispostaErogazione.getReadTimeout());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tempo Medio di Risposta");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setName("CTTempoMedioRispostaErogazione");
        if (editEnabled) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        if (tempiRispostaErogazione.getTempoMedioRisposta() != null) {
            de.setValue("" + tempiRispostaErogazione.getTempoMedioRisposta());
        }
        dati.add(de);
    }

    public void addToDatiConfigurazioneCache(List<DataElement> dati, TipoOperazione tipoOperazione, Cache cache, boolean enabled) throws Exception {
        DataElement de;
        if (enabled) {
            de = new DataElement();
            de.setLabel("Configurazione Cache Controllo del Traffico");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("CTCacheStato");
        if (enabled) {
            de.setType(DataElementType.SELECT);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValues(ConfigurazioneCostanti.STATI);
        de.setSelected(cache.isCache() ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
        de.setValue(cache.isCache() ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Dimensione (Elementi)");
        de.setName("CTCacheDimensione");
        if (enabled && cache.isCache()) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (cache.getSize() != null) {
            de.setValue("" + cache.getSize());
        }
        dati.add(de);
        String[] tipoAlgoritmo = new String[]{CacheAlgorithm.LRU.name(), CacheAlgorithm.MRU.name()};
        de = new DataElement();
        de.setLabel("Algoritmo");
        de.setName("CTCacheAlgoritmo");
        if (enabled && cache.isCache()) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoAlgoritmo);
            if (cache.getAlgorithm() != null) {
                de.setSelected(cache.getAlgorithm().name());
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (cache.getAlgorithm() != null) {
            de.setValue(cache.getAlgorithm().name());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Item Life Time (Secondi)");
        de.setName("CTCacheLifeTime");
        if (enabled && cache.isCache()) {
            de.setType(DataElementType.TEXT_EDIT);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (cache.getLifeTime() != null) {
            de.setValue("" + cache.getLifeTime());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Item Idle Time (Secondi)");
        de.setName("CTCacheIdleTime");
        if (enabled && cache.isCache()) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setNote("Non indicare i secondi per avere un tempo infinito");
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (cache.getIdleTime() != null) {
            de.setValue("" + cache.getIdleTime());
        }
        dati.add(de);
    }

    public String readConfigurazioneControlloTrafficoFromHttpParameters(ConfigurazioneControlloTraffico controlloTraffico, boolean first) throws Exception {
        String threshold;
        String statoControlloCongestione;
        String tipoErroreMaxThreads;
        String numRichieste;
        StringBuilder sbParsingError = new StringBuilder();
        String statoMaxThreads = this.getParameter("CTNumMaxReqStato");
        if (statoMaxThreads != null && !"".equals(statoMaxThreads)) {
            controlloTraffico.setControlloMaxThreadsEnabled(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.getValue().equals(statoMaxThreads) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.getValue().equals(statoMaxThreads));
            controlloTraffico.setControlloMaxThreadsWarningOnly(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.getValue().equals(statoMaxThreads));
        }
        if ((numRichieste = this.getParameter("CTNumMaxReqSoglia")) != null && !"".equals(numRichieste)) {
            try {
                long l = Long.parseLong(numRichieste);
                if (l <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                controlloTraffico.setControlloMaxThreadsSoglia(Long.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + numRichieste + ") indicato in 'Max Richieste Simultanee' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (!first) {
            controlloTraffico.setControlloMaxThreadsSoglia(null);
        }
        if ((tipoErroreMaxThreads = this.getParameter("CTNumMaxReqTipoErrore")) != null && !"".equals(tipoErroreMaxThreads)) {
            try {
                TipoErrore tipo = TipoErrore.toEnumConstant((String)tipoErroreMaxThreads, (boolean)true);
                controlloTraffico.setControlloMaxThreadsTipoErrore(tipo.getValue());
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + tipoErroreMaxThreads + ") indicato in 'Tipo Errore per le API SOAP' deve assumere uno dei seguenti valori: Fault,Http 429 (Too Many Requests),Http 503 (Service Unavailable),Http 500 (Internal Server Error)";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (first && controlloTraffico.getControlloMaxThreadsTipoErrore() == null) {
            controlloTraffico.setControlloMaxThreadsTipoErrore(ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_NUM_MASSIMO_RICHIESTE_SIMULTANEE_TIPOLOGIA_ERRORE);
        }
        String tipoErroreIncludiDescrizioneMaxThreads = this.getParameter("CTNumMaxReqTipoErroreDescr");
        if (tipoErroreMaxThreads != null && !"".equals(tipoErroreMaxThreads)) {
            controlloTraffico.setControlloMaxThreadsTipoErroreIncludiDescrizione(ServletUtils.isCheckBoxEnabled((String)tipoErroreIncludiDescrizioneMaxThreads));
        }
        if ((statoControlloCongestione = this.getParameter("CTStatoControlloCongestione")) != null && !"".equals(statoControlloCongestione)) {
            controlloTraffico.setControlloCongestioneEnabled(CostantiConfigurazione.ABILITATO.getValue().equals(statoControlloCongestione));
        }
        if ((threshold = this.getParameter("CTpercentualeCongestioneThreshold")) != null && !"".equals(threshold)) {
            try {
                int t = Integer.parseInt(threshold);
                if (t <= 0 || t > 100) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                controlloTraffico.setControlloCongestioneThreshold(Integer.valueOf(t));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + threshold + ") indicato in 'Soglia di Attivazione (%)' deve essere un numero compreso nell'intervallo [1,100]";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (controlloTraffico.isControlloCongestioneEnabled() && controlloTraffico.getControlloCongestioneThreshold() == null) {
            controlloTraffico.setControlloCongestioneThreshold(Integer.valueOf(80));
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readConfigurazioneRateLimitingFromHttpParameters(ConfigurazioneRateLimiting rateLimiting, boolean first) throws Exception {
        StringBuilder sbParsingError = new StringBuilder();
        String tipoErroreMaxThreads = this.getParameter("CTRateLimitTipoErrore");
        if (tipoErroreMaxThreads != null && !"".equals(tipoErroreMaxThreads)) {
            try {
                TipoErrore tipo = TipoErrore.toEnumConstant((String)tipoErroreMaxThreads, (boolean)true);
                rateLimiting.setTipoErrore(tipo.getValue());
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + tipoErroreMaxThreads + ") indicato in 'Tipo Errore per le API SOAP' deve assumere uno dei seguenti valori: Fault,Http 429 (Too Many Requests),Http 503 (Service Unavailable),Http 500 (Internal Server Error)";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (first && rateLimiting.getTipoErrore() == null) {
            rateLimiting.setTipoErrore(ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_NUM_MASSIMO_RICHIESTE_SIMULTANEE_TIPOLOGIA_ERRORE);
        }
        String tipoErroreIncludiDescrizioneMaxThreads = this.getParameter("CTRateLimitTipoErroreDescr");
        if (tipoErroreMaxThreads != null && !"".equals(tipoErroreMaxThreads)) {
            rateLimiting.setTipoErroreIncludiDescrizione(ServletUtils.isCheckBoxEnabled((String)tipoErroreIncludiDescrizioneMaxThreads));
        }
        String ctModalitaSincronizzazione = this.getParameter("ctSyncMode");
        String ctImplementazione = this.getParameter("ctImpl");
        String ctContatori = this.getParameter("ctCount");
        String ctTipologia = this.getParameter("ctEngineType");
        String ctHeaderHttp = this.getParameter("ctHttpMode");
        String ctHeaderHttp_limit = this.getParameter("ctHttpQuota");
        String ctHeaderHttp_remaining = this.getParameter("ctHttpRemaining");
        String ctHeaderHttp_reset = this.getParameter("ctHttpReset");
        String ctHeaderHttp_retryAfter = this.getParameter("ctHttpRetryAfter");
        String ctHeaderHttp_retryAfterBackoff = this.getParameter("ctHttpRetryAfterBackoff");
        if (ctModalitaSincronizzazione != null && !"".equals(ctModalitaSincronizzazione)) {
            ArrayList oldList = new ArrayList();
            if (rateLimiting.getProprietaList() != null && !rateLimiting.getProprietaList().isEmpty()) {
                for (ConfigurazioneRateLimitingProprieta rt : rateLimiting.getProprietaList()) {
                    Proprieta proprieta = new Proprieta();
                    proprieta.setNome(rt.getNome());
                    proprieta.setValore(rt.getValore());
                }
            }
            PolicyConfiguration oldPolicyConfig = new PolicyConfiguration(oldList, this.core.getControlloTrafficoPolicyRateLimitingTipiGestori(), false);
            boolean changeImpl = false;
            if (oldPolicyConfig.getEngineType() != null) {
                changeImpl = !oldPolicyConfig.getEngineType().equals(ctTipologia);
            } else if (ctContatori != null) {
                changeImpl = true;
            }
            PolicyConfiguration policyConfig = new PolicyConfiguration();
            if (changeImpl) {
                policyConfig.setGestorePolicyConfigDate(Long.valueOf(DateManager.getTimeMillis()));
            } else {
                policyConfig.setGestorePolicyConfigDate(oldPolicyConfig.getGestorePolicyConfigDate());
            }
            policyConfig.setSyncMode(ctModalitaSincronizzazione);
            policyConfig.setImpl(ctImplementazione);
            policyConfig.setCount(ctContatori);
            policyConfig.setEngineType(ctTipologia);
            policyConfig.setHttpMode(ctHeaderHttp);
            policyConfig.setHttpMode_limit(ctHeaderHttp_limit);
            policyConfig.setHttpMode_remaining(ctHeaderHttp_remaining);
            policyConfig.setHttpMode_reset(ctHeaderHttp_reset);
            policyConfig.setHttpMode_retry_after(ctHeaderHttp_retryAfter);
            policyConfig.setHttpMode_retry_after_backoff(ctHeaderHttp_retryAfterBackoff);
            ArrayList list = new ArrayList();
            policyConfig.saveIn(list);
            if (rateLimiting.getProprietaList() != null) {
                rateLimiting.getProprietaList().clear();
            }
            if (list != null && !list.isEmpty()) {
                for (Proprieta proprieta : list) {
                    ConfigurazioneRateLimitingProprieta rtProp = new ConfigurazioneRateLimitingProprieta();
                    rtProp.setNome(proprieta.getNome());
                    rtProp.setValore(proprieta.getValore());
                    rateLimiting.addProprieta(rtProp);
                }
            }
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readTempiRispostaFruizioneFromHttpParameters(TempiRispostaFruizione tempiRispostaFruizione, boolean first) throws Exception {
        String tempoMedioRisposta;
        String readTimeout;
        StringBuilder sbParsingError = new StringBuilder();
        String connectionTimeout = this.getParameter("CTConnectionTimeoutFruizione");
        if (connectionTimeout != null && !"".equals(connectionTimeout)) {
            try {
                int l = Integer.parseInt(connectionTimeout);
                if (l <= 0) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                tempiRispostaFruizione.setConnectionTimeout(Integer.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + connectionTimeout + ") indicato nella sezione 'Tempi Risposta Fruizione' in 'Connection Timeout' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (!first) {
            tempiRispostaFruizione.setConnectionTimeout(null);
        }
        if ((readTimeout = this.getParameter("CTReadTimeoutFruizione")) != null && !"".equals(readTimeout)) {
            try {
                int l = Integer.parseInt(readTimeout);
                if (l <= 0) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                tempiRispostaFruizione.setReadTimeout(Integer.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + readTimeout + ") indicato nella sezione 'Tempi Risposta Fruizione' in 'Read Timeout' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (!first) {
            tempiRispostaFruizione.setReadTimeout(null);
        }
        if ((tempoMedioRisposta = this.getParameter("CTTempoMedioRispostaFruizione")) != null && !"".equals(tempoMedioRisposta)) {
            try {
                int l = Integer.parseInt(tempoMedioRisposta);
                if (l <= 0) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                tempiRispostaFruizione.setTempoMedioRisposta(Integer.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + tempoMedioRisposta + ") indicato nella sezione 'Tempi Risposta Fruizione' in 'Tempo Medio di Risposta' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (!first) {
            tempiRispostaFruizione.setTempoMedioRisposta(null);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readTempiRispostaErogazioneFromHttpParameters(TempiRispostaErogazione tempiRispostaErogazione, boolean first) throws Exception {
        String tempoMedioRisposta;
        String readTimeout;
        StringBuilder sbParsingError = new StringBuilder();
        String connectionTimeout = this.getParameter("CTConnectionTimeoutErogazione");
        if (connectionTimeout != null && !"".equals(connectionTimeout)) {
            try {
                int l = Integer.parseInt(connectionTimeout);
                if (l <= 0) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                tempiRispostaErogazione.setConnectionTimeout(Integer.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + connectionTimeout + ") indicato nella sezione 'Tempi Risposta Erogazione' in 'Connection Timeout' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (!first) {
            tempiRispostaErogazione.setConnectionTimeout(null);
        }
        if ((readTimeout = this.getParameter("CTReadTimeoutErogazione")) != null && !"".equals(readTimeout)) {
            try {
                int l = Integer.parseInt(readTimeout);
                if (l <= 0) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                tempiRispostaErogazione.setReadTimeout(Integer.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + readTimeout + ") indicato nella sezione 'Tempi Risposta Erogazione' in 'Read Timeout' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (!first) {
            tempiRispostaErogazione.setReadTimeout(null);
        }
        if ((tempoMedioRisposta = this.getParameter("CTTempoMedioRispostaErogazione")) != null && !"".equals(tempoMedioRisposta)) {
            try {
                int l = Integer.parseInt(tempoMedioRisposta);
                if (l <= 0) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                tempiRispostaErogazione.setTempoMedioRisposta(Integer.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + tempoMedioRisposta + ") indicato nella sezione 'Tempi Risposta Erogazione' in 'Tempo Medio di Risposta' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (!first) {
            tempiRispostaErogazione.setTempoMedioRisposta(null);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readConfigurazioneCacheFromHttpParameters(Cache cache, boolean first) throws Exception {
        String cacheAlgorithm;
        String cacheItemIdle;
        String cacheItemLife;
        String cacheDimensione;
        StringBuilder sbParsingError = new StringBuilder();
        String cacheStato = this.getParameter("CTCacheStato");
        if (cacheStato != null && !"".equals(cacheStato)) {
            cache.setCache(CostantiConfigurazione.ABILITATO.getValue().equals(cacheStato));
        }
        if ((cacheDimensione = this.getParameter("CTCacheDimensione")) != null && !"".equals(cacheDimensione)) {
            try {
                long l = Long.parseLong(cacheDimensione);
                if (l <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                cache.setSize(Long.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + cacheDimensione + ") indicato in 'Dimensione (Elementi)' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (first) {
            if (cache.getSize() == null) {
                cache.setSize(Long.valueOf(10000L));
            }
        } else {
            cache.setSize(null);
        }
        if ((cacheItemLife = this.getParameter("CTCacheLifeTime")) != null && !"".equals(cacheItemLife)) {
            try {
                long l = Long.parseLong(cacheItemLife);
                if (l <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                cache.setLifeTime(Long.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + cacheItemLife + ") indicato in 'Item Life Time (Secondi)' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (first) {
            if (cache.getLifeTime() == null) {
                // empty if block
            }
        } else {
            cache.setLifeTime(null);
        }
        if ((cacheItemIdle = this.getParameter("CTCacheIdleTime")) != null && !"".equals(cacheItemIdle)) {
            try {
                long l = Long.parseLong(cacheItemIdle);
                if (l <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                cache.setIdleTime(Long.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + cacheItemIdle + ") indicato in 'Item Idle Time (Secondi)' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (first) {
            if (cache.getIdleTime() == null) {
                // empty if block
            }
        } else {
            cache.setIdleTime(null);
        }
        if ((cacheAlgorithm = this.getParameter("CTCacheAlgoritmo")) != null && !"".equals(cacheAlgorithm)) {
            try {
                if (!CacheAlgorithm.LRU.name().equals(cacheAlgorithm) && !CacheAlgorithm.MRU.name().equals(cacheAlgorithm)) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                cache.setAlgorithm(CacheAlgorithm.toEnumConstant((String)cacheAlgorithm));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + cacheAlgorithm + ") indicato in 'Algoritmo' deve assumere uno dei seguenti valori: " + CacheAlgorithm.LRU.name() + "," + CacheAlgorithm.MRU.name();
                ControlStationCore.getLog().error(messaggio, (Throwable)e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else if (first && cache.getAlgorithm() == null) {
            cache.setAlgorithm(ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_CACHE_ALGORITMO);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public void addParsingError(StringBuilder sbParsingError, String parsingError) {
        if (sbParsingError.length() == 0) {
            sbParsingError.append(parsingError);
        } else {
            sbParsingError.append("<br/>").append(parsingError);
        }
    }

    public boolean checkDatiConfigurazioneControlloTraffico(TipoOperazione tipoOperazione, StringBuilder sbParsingError, ConfigurazioneGenerale configurazioneControlloTraffico) throws Exception {
        String ctHeaderHttp_retryAfterBackoff;
        String ctHeaderHttp_retryAfter;
        String ctHeaderHttp_reset;
        String ctHeaderHttp_remaining;
        String ctHeaderHttp_limit;
        String ctHeaderHttp;
        String ctTipologia;
        String ctContatori;
        String ctImplementazione;
        PolicyConfiguration policyConfig;
        String ctModalitaSincronizzazione;
        boolean validitaParametri;
        if (sbParsingError.length() > 0) {
            this.pd.setMessage(sbParsingError.toString());
            return false;
        }
        if (configurazioneControlloTraffico.getControlloTraffico().getControlloMaxThreadsSoglia() == null) {
            String messaggio = "Deve essere indicato un valore in 'Max Richieste Simultanee'";
            this.pd.setMessage(messaggio);
            return false;
        }
        ArrayList<Proprieta> listProprieta = new ArrayList<Proprieta>();
        if (configurazioneControlloTraffico.getRateLimiting().sizeProprietaList() > 0) {
            for (ConfigurazioneRateLimitingProprieta rtProp : configurazioneControlloTraffico.getRateLimiting().getProprietaList()) {
                Proprieta p = new Proprieta();
                p.setNome(rtProp.getNome());
                p.setValore(rtProp.getValore());
                listProprieta.add(p);
            }
        }
        if (!(validitaParametri = this.validaOpzioniAvanzateRateLimiting(null, null, ctModalitaSincronizzazione = (policyConfig = new PolicyConfiguration(listProprieta, this.core.getControlloTrafficoPolicyRateLimitingTipiGestori(), false)).getSyncMode(), ctImplementazione = policyConfig.getImpl(), ctContatori = policyConfig.getCount(), ctTipologia = policyConfig.getEngineType(), ctHeaderHttp = policyConfig.getHttpMode(), ctHeaderHttp_limit = policyConfig.getHttpMode_limit(), ctHeaderHttp_remaining = policyConfig.getHttpMode_remaining(), ctHeaderHttp_reset = policyConfig.getHttpMode_reset(), ctHeaderHttp_retryAfter = policyConfig.getHttpMode_retry_after(), ctHeaderHttp_retryAfterBackoff = policyConfig.getHttpMode_retry_after_backoff()))) {
            return false;
        }
        if (configurazioneControlloTraffico.getTempiRispostaFruizione().getConnectionTimeout() == null) {
            String messaggio = "Deve essere indicato nella sezione 'Tempi Risposta Fruizione' un valore in 'Connection Timeout'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (configurazioneControlloTraffico.getTempiRispostaFruizione().getReadTimeout() == null) {
            String messaggio = "Deve essere indicato nella sezione 'Tempi Risposta Fruizione' un valore in 'Read Timeout'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (configurazioneControlloTraffico.getTempiRispostaFruizione().getTempoMedioRisposta() == null) {
            String messaggio = "Deve essere indicato nella sezione 'Tempi Risposta Fruizione' un valore in 'Tempo Medio di Risposta'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (configurazioneControlloTraffico.getTempiRispostaErogazione().getConnectionTimeout() == null) {
            String messaggio = "Deve essere indicato nella sezione 'Tempi Risposta Erogazione' un valore in 'Connection Timeout'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (configurazioneControlloTraffico.getTempiRispostaErogazione().getReadTimeout() == null) {
            String messaggio = "Deve essere indicato nella sezione 'Tempi Risposta Erogazione' un valore in 'Read Timeout'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (configurazioneControlloTraffico.getTempiRispostaErogazione().getTempoMedioRisposta() == null) {
            String messaggio = "Deve essere indicato nella sezione 'Tempi Risposta Erogazione' un valore in 'Tempo Medio di Risposta'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (configurazioneControlloTraffico.getCache().isCache() && configurazioneControlloTraffico.getCache().getSize() == null) {
            String messaggio = "Deve essere indicato un valore in 'Dimensione (Elementi)'";
            this.pd.setMessage(messaggio);
            return false;
        }
        return true;
    }

    public void prepareConfigurazionePolicyList(ConsoleSearch ricerca, List<ConfigurazionePolicy> lista, int idLista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneControlloTrafficoConfigurazionePolicy", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String filterTipoPolicy = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoPolicy");
            this.addFilterTipoPolicy(filterTipoPolicy, false);
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Controllo del Traffico", "configurazioneControlloTraffico.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Registro Policy", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Policy", (String)search);
            }
            String[] labels = new String[]{"Nome", "Tipo", "Uso"};
            this.pd.setLabels(labels);
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    ConfigurazionePolicy policy = lista.get(i);
                    String nDesr = policy.getDescrizione();
                    org.openspcoop2.web.lib.mvc.Parameter pPolicyId = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId());
                    DataElement de = new DataElement();
                    de.setSize(100);
                    de.setUrl("configurazioneControlloTrafficoConfigurazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId});
                    de.setValue(policy.getIdPolicy());
                    de.setIdToRemove("" + policy.getId());
                    de.setToolTip(policy.getIdPolicy() + "\n" + nDesr);
                    e.add(de);
                    de = new DataElement();
                    if (policy.isBuiltIn()) {
                        de.setValue("Built-in");
                    } else {
                        de.setValue("Utente");
                    }
                    e.add(de);
                    this.addInUsoButtonVisualizzazioneClassica(e, policy.getIdPolicy(), "" + policy.getId(), InUsoType.RATE_LIMITING_POLICY);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ConfigurazioneCostanti.LABEL_CONTROLLO_TRAFFICO_CONFIG_POLICY_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<org.openspcoop2.web.lib.mvc.Parameter> getTitleListAttivazionePolicy(RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding, String nomeOggetto) throws Exception {
        List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
        if (ruoloPorta != null) {
            Object labelPerPorta = null;
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                Integer parentPD = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
                if (parentPD == null) {
                    parentPD = 0;
                }
                IDPortaDelegata idPortaDelegata = new IDPortaDelegata();
                idPortaDelegata.setNome(nomePorta);
                PortaDelegata myPD = this.porteDelegateCore.getPortaDelegata(idPortaDelegata);
                String idporta = myPD.getNome();
                MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(myPD);
                long idSoggetto = myPD.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPD.getIdServizio());
                long idFruizione = this.apsCore.getIdFruizioneAccordoServizioParteSpecifica(mappingPD.getIdFruitore(), mappingPD.getIdServizio());
                PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
                lstParamPorta = porteDelegateHelper.getTitoloPD(parentPD, "" + idSoggetto, "" + idAsps, "" + idFruizione);
                labelPerPorta = parentPD != null && parentPD == 2 ? this.porteDelegateCore.getLabelRegolaMappingFruizionePortaDelegata("Rate Limiting di ", "Rate Limiting", myPD) : "Rate Limiting di " + idporta;
            } else {
                Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
                IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                idPortaApplicativa.setNome(nomePorta);
                PortaApplicativa myPA = this.porteApplicativeCore.getPortaApplicativa(idPortaApplicativa);
                String idporta = myPA.getNome();
                MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(myPA);
                long idSoggetto = myPA.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPA.getIdServizio());
                PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(this.request, this.pd, this.session);
                lstParamPorta = porteApplicativeHelper.getTitoloPA(parentPA, "" + idSoggetto, "" + idAsps);
                labelPerPorta = parentPA != null && parentPA == 2 ? this.porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Rate Limiting di ", "Rate Limiting", myPA) : "Rate Limiting di " + idporta;
            }
            if (nomeOggetto == null) {
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter((String)labelPerPorta, null));
            } else {
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> list = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                list.add(new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyRuoloPorta", ruoloPorta.getValue()));
                list.add(new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyNomePorta", nomePorta));
                if (serviceBinding != null) {
                    list.add(new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyServiceBinding", serviceBinding.name()));
                }
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter((String)labelPerPorta, "configurazioneControlloTrafficoAttivazionePolicyList.do", list));
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter(nomeOggetto, null));
            }
        }
        return lstParamPorta;
    }

    public void impostaComandiMenuContestualeAttivazionePolicy(RuoloPolicy ruoloPorta, String nomePorta) throws Exception {
        if (ruoloPorta != null) {
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                IDPortaDelegata idPortaDelegata = new IDPortaDelegata();
                idPortaDelegata.setNome(nomePorta);
                PortaDelegata myPD = this.porteDelegateCore.getPortaDelegata(idPortaDelegata);
                MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(myPD);
                long idSoggetto = myPD.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPD.getIdServizio());
                long idFruizione = this.apsCore.getIdFruizioneAccordoServizioParteSpecifica(mappingPD.getIdFruitore(), mappingPD.getIdServizio());
                PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
                porteDelegateHelper.impostaComandiMenuContestualePD("" + idSoggetto, "" + idAsps, "" + idFruizione);
            } else {
                IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                idPortaApplicativa.setNome(nomePorta);
                PortaApplicativa myPA = this.porteApplicativeCore.getPortaApplicativa(idPortaApplicativa);
                MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(myPA);
                long idSoggetto = myPA.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPA.getIdServizio());
                PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(this.request, this.pd, this.session);
                porteApplicativeHelper.impostaComandiMenuContestualePA("" + idSoggetto, "" + idAsps);
            }
        }
    }

    public List<TipoRisorsaPolicyAttiva> gestisciCriteriFiltroRisorsaPolicy(ConsoleSearch ricerca, RuoloPolicy ruoloPorta, String nomePorta) throws Exception {
        int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
        List<TipoRisorsaPolicyAttiva> listaTipoRisorsa = this.confCore.attivazionePolicyTipoRisorsaList(ricerca, ruoloPorta, nomePorta);
        String filterTipoRisorsaPolicy = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoRisorsaPolicy");
        if (filterTipoRisorsaPolicy != null && !"".equals(filterTipoRisorsaPolicy)) {
            TipoRisorsaPolicyAttiva filterTipoRisorsaPolicyAsObject = TipoRisorsaPolicyAttiva.toEnumConstant((String)filterTipoRisorsaPolicy, (boolean)false);
            if (filterTipoRisorsaPolicyAsObject == null) {
                filterTipoRisorsaPolicy = null;
            } else if (!listaTipoRisorsa.contains(filterTipoRisorsaPolicyAsObject)) {
                filterTipoRisorsaPolicy = null;
            }
        }
        if (filterTipoRisorsaPolicy == null || "".equals(filterTipoRisorsaPolicy)) {
            TipoRisorsaPolicyAttiva defaultValue = CostantiControlStation.DEFAULT_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_RISORSA_TIPO_VALUE;
            if (listaTipoRisorsa != null && !listaTipoRisorsa.isEmpty() && !listaTipoRisorsa.contains(defaultValue)) {
                defaultValue = listaTipoRisorsa.contains(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE) ? TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE : (listaTipoRisorsa.contains(TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE) ? TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE : (listaTipoRisorsa.contains(TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO) ? TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO : (listaTipoRisorsa.contains(TipoRisorsaPolicyAttiva.OCCUPAZIONE_BANDA) ? TipoRisorsaPolicyAttiva.OCCUPAZIONE_BANDA : listaTipoRisorsa.get(0))));
            }
            ricerca.addFilter(idLista, "filtroTipoRisorsaPolicy", defaultValue.getValue());
        }
        return listaTipoRisorsa;
    }

    public void prepareAttivazionePolicyList(ConsoleSearch ricerca, List<AttivazionePolicy> lista, List<TipoRisorsaPolicyAttiva> listaTipoRisorsa, int idLista, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamSession = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = null;
            if (ruoloPorta != null) {
                parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyRuoloPorta", ruoloPorta.getValue());
                lstParamSession.add(parRuoloPorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parNomePorta = null;
            if (nomePorta != null) {
                parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyNomePorta", nomePorta);
                lstParamSession.add(parNomePorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = null;
            if (serviceBinding != null) {
                parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyServiceBinding", serviceBinding.name());
                lstParamSession.add(parServiceBinding);
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneControlloTrafficoAttivazionePolicy", lstParamSession);
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
            if (ruoloPorta != null) {
                lstParamPorta = this.getTitleListAttivazionePolicy(ruoloPorta, nomePorta, serviceBinding, null);
            }
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String filterTipoRisorsaPolicy = null;
            if (listaTipoRisorsa != null && !listaTipoRisorsa.isEmpty()) {
                filterTipoRisorsaPolicy = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoRisorsaPolicy");
                this.addFilterTipoRisorsaPolicy(listaTipoRisorsa, filterTipoRisorsaPolicy, false);
            } else {
                this.removeFilterTipoRisorsaPolicy();
            }
            if (!search.equals("") || filterTipoRisorsaPolicy != null && !"".equals(filterTipoRisorsaPolicy)) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Policy", (String)search);
            }
            boolean showMetricaColumn = false;
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParam = null;
            if (lstParamPorta != null) {
                lstParam = lstParamPorta;
            } else {
                lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Controllo del Traffico", "configurazioneControlloTraffico.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Policy Globali", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (ruoloPorta != null) {
                this.impostaComandiMenuContestualeAttivazionePolicy(ruoloPorta, nomePorta);
            }
            String labelSogliaColonna = null;
            TipoRisorsaPolicyAttiva tipoRisorsa = null;
            if (filterTipoRisorsaPolicy != null && !"".equals(filterTipoRisorsaPolicy)) {
                tipoRisorsa = TipoRisorsaPolicyAttiva.toEnumConstant((String)filterTipoRisorsaPolicy, (boolean)true);
                switch (tipoRisorsa) {
                    case NUMERO_RICHIESTE: 
                    case NUMERO_RICHIESTE_SIMULTANEE: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                    case NUMERO_RICHIESTE_FALLITE: 
                    case NUMERO_FAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                        labelSogliaColonna = "Soglia";
                        break;
                    }
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        labelSogliaColonna = "Soglia (kb)";
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        labelSogliaColonna = "Soglia (kb)";
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        labelSogliaColonna = "Soglia (ms)";
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        labelSogliaColonna = "Soglia (secondi)";
                    }
                }
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            if (lista != null && lista.size() > 1) {
                lstLabels.add("Ordine");
            }
            lstLabels.add("Stato");
            lstLabels.add("Nome");
            if (labelSogliaColonna != null) {
                lstLabels.add(labelSogliaColonna);
            }
            if (showMetricaColumn && (filterTipoRisorsaPolicy == null || "".equals(filterTipoRisorsaPolicy))) {
                lstLabels.add("Metrica");
            }
            if (!TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                lstLabels.add("Runtime");
            }
            lstLabels.add("Elaborazione");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList dati = new ArrayList();
            if (lista != null) {
                int numeroElementi = lista.size();
                Integer sizeColumn = null;
                for (int i = 0; i < lista.size(); ++i) {
                    DataElement de;
                    AttivazionePolicy policy = lista.get(i);
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    policy.setAlias(PolicyUtilities.getNomeActivePolicy((String)policy.getAlias(), (String)policy.getIdActivePolicy()));
                    String descrizionePolicy = "";
                    try {
                        descrizionePolicy = this.confCore.getInfoPolicy(policy.getIdPolicy()).getDescrizione();
                    }
                    catch (Exception ex) {
                        ControlStationCore.getLog().error(ex.getMessage(), (Throwable)ex);
                    }
                    Object nDescr = "";
                    if (StringUtils.isNotEmpty((CharSequence)policy.getAlias())) {
                        nDescr = policy.getAlias();
                    }
                    nDescr = (String)nDescr + "\nIdentificativo Runtime: " + policy.getIdActivePolicy();
                    nDescr = (String)nDescr + "\nPolicy: " + policy.getIdPolicy();
                    nDescr = (String)nDescr + "\n" + descrizionePolicy;
                    org.openspcoop2.web.lib.mvc.Parameter pPolicyId = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId());
                    org.openspcoop2.web.lib.mvc.Parameter pPolicyRisorsa = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyRisorsa", filterTipoRisorsaPolicy);
                    if (lista.size() > 1) {
                        de = new DataElement();
                        de.setWidthPx(48);
                        de.setType(DataElementType.IMAGE);
                        DataElementImage imageUp = new DataElementImage();
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneSu = new org.openspcoop2.web.lib.mvc.Parameter("CTPolictyActivePos", "su");
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneGiu = new org.openspcoop2.web.lib.mvc.Parameter("CTPolictyActivePos", "giu");
                        if (i > 0) {
                            imageUp.setImage("&#xE316;");
                            imageUp.setToolTip("Sposta su");
                            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> listP = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                            listP.add(pPolicyId);
                            listP.add(pPolicyRisorsa);
                            if (ruoloPorta != null) {
                                listP.add(parRuoloPorta);
                                listP.add(parNomePorta);
                                listP.add(parServiceBinding);
                            }
                            listP.add(pDirezioneSu);
                            imageUp.setUrl("configurazioneControlloTrafficoAttivazionePolicyList.do", listP.toArray(new org.openspcoop2.web.lib.mvc.Parameter[1]));
                        } else {
                            imageUp.setImage("&#160;&#160;&#160;&#160;&#160;");
                        }
                        de.addImage(imageUp);
                        if (i < numeroElementi - 1) {
                            DataElementImage imageDown = new DataElementImage();
                            imageDown.setImage("&#xE313;");
                            imageDown.setToolTip("Sposta gi&ugrave;");
                            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> listP = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                            listP.add(pPolicyId);
                            listP.add(pPolicyRisorsa);
                            if (ruoloPorta != null) {
                                listP.add(parRuoloPorta);
                                listP.add(parNomePorta);
                                listP.add(parServiceBinding);
                            }
                            listP.add(pDirezioneGiu);
                            imageDown.setUrl("configurazioneControlloTrafficoAttivazionePolicyList.do", listP.toArray(new org.openspcoop2.web.lib.mvc.Parameter[1]));
                            de.addImage(imageDown);
                        }
                        de.setValue("" + policy.getPosizione());
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setWidthPx(10);
                    de.setType(DataElementType.CHECKBOX);
                    if (policy.isEnabled()) {
                        if (policy.isWarningOnly()) {
                            de.setToolTip("WarningOnly");
                            de.setValue("WarningOnly");
                            de.setSelected(CheckboxStatusType.CONFIG_WARNING);
                        } else {
                            de.setToolTip("Abilitato");
                            de.setValue("Abilitato");
                            de.setSelected(CheckboxStatusType.CONFIG_ENABLE);
                        }
                    } else {
                        de.setToolTip("Disabilitato");
                        de.setValue("Disabilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_DISABLE);
                    }
                    if (ruoloPorta != null) {
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId, parRuoloPorta, parNomePorta, parServiceBinding});
                    } else {
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId});
                    }
                    e.add(de);
                    de = new DataElement();
                    if (ruoloPorta != null) {
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId, parRuoloPorta, parNomePorta, parServiceBinding});
                    } else {
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId});
                    }
                    if (StringUtils.isNotEmpty((CharSequence)policy.getAlias())) {
                        de.setValue(policy.getAlias());
                    } else {
                        de.setValue(policy.getIdActivePolicy());
                    }
                    de.setIdToRemove("" + policy.getId());
                    de.setToolTip((String)nDescr);
                    e.add(de);
                    ConfigurazionePolicy configPolicy = null;
                    if (labelSogliaColonna != null) {
                        de = new DataElement();
                        Integer maxLength = null;
                        if (TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                            String vReq = null;
                            String vRes = null;
                            if (policy.isRidefinisci()) {
                                vReq = "" + policy.getValore2();
                                vRes = "" + policy.getValore();
                            } else {
                                if (configPolicy == null) {
                                    configPolicy = this.confCore.getConfigurazionePolicy(policy.getIdPolicy());
                                }
                                vReq = "" + configPolicy.getValore2();
                                vRes = "" + configPolicy.getValore();
                            }
                            maxLength = vReq.length() > vRes.length() ? Integer.valueOf(vReq.length()) : Integer.valueOf(vRes.length());
                            String rigaRichiesta = "richiesta: " + vReq;
                            String rigaRisposta = "risposta:  " + vRes;
                            de.setValue(rigaRichiesta + "<BR/>" + rigaRisposta);
                        } else if (policy.isRidefinisci()) {
                            de.setValue("" + policy.getValore());
                        } else {
                            if (configPolicy == null) {
                                configPolicy = this.confCore.getConfigurazionePolicy(policy.getIdPolicy());
                            }
                            de.setValue("" + configPolicy.getValore());
                        }
                        int checkLength = de.getValue().length();
                        int guiPrefix = 0;
                        if (maxLength != null) {
                            checkLength = maxLength;
                            guiPrefix = 50;
                        }
                        if (sizeColumn == null) {
                            de.setWidthPx(guiPrefix + 70);
                            sizeColumn = guiPrefix + 70;
                        }
                        if (checkLength > 12) {
                            if (sizeColumn < guiPrefix + 110) {
                                de.setWidthPx(guiPrefix + 110);
                                sizeColumn = guiPrefix + 110;
                            }
                        } else if (checkLength > 9 && sizeColumn < guiPrefix + 90) {
                            de.setWidthPx(guiPrefix + 90);
                            sizeColumn = guiPrefix + 90;
                        }
                        de.allineaTdAlCentro();
                        e.add(de);
                    }
                    if (showMetricaColumn && (filterTipoRisorsaPolicy == null || "".equals(filterTipoRisorsaPolicy))) {
                        if (configPolicy == null) {
                            configPolicy = this.confCore.getConfigurazionePolicy(policy.getIdPolicy());
                        }
                        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.getTipo((String)configPolicy.getRisorsa(), (boolean)configPolicy.isSimultanee());
                        String labelRisorsaPolicyAttiva = this.getLabelTipoRisorsaPolicyAttiva(tipoRisorsaPolicyAttiva);
                        de = new DataElement();
                        de.setValue(labelRisorsaPolicyAttiva);
                        e.add(de);
                    }
                    if (!TipoRisorsaPolicyAttiva.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                        de = new DataElement();
                        if (policy.isEnabled()) {
                            de.setValue("Visualizza");
                        } else {
                            de.setValue("-");
                        }
                        de.allineaTdAlCentro();
                        de.setWidthPx(60);
                        org.openspcoop2.web.lib.mvc.Parameter pJmx = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true");
                        if (policy.isEnabled()) {
                            if (ruoloPorta != null) {
                                de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId, pJmx, parRuoloPorta, parNomePorta, parServiceBinding});
                            } else {
                                de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId, pJmx});
                            }
                        }
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setWidthPx(24);
                    de.setType(DataElementType.IMAGE);
                    DataElementImage imageUp = new DataElementImage();
                    if (policy.isContinuaValutazione()) {
                        imageUp.setImage("&#xE5DB;");
                        imageUp.setToolTip("Se soddisfatta, il gateway prosegue la valutazione delle successive policy per la stessa metrica");
                    } else {
                        imageUp.setImage("&#xE5CD;");
                        imageUp.setToolTip("Se soddisfatta, il gateway interrompe la valutazione delle successive policy per la stessa metrica");
                    }
                    if (ruoloPorta != null) {
                        imageUp.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId, parRuoloPorta, parNomePorta, parServiceBinding});
                    } else {
                        imageUp.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pPolicyId});
                    }
                    de.addImage(imageUp);
                    de.allineaTdAlCentro();
                    de.setValue("" + policy.getPosizione());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (nomePorta == null || StringUtils.isEmpty((CharSequence)nomePorta)) && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ACTIVE_POLICY, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ConfigurazioneCostanti.LABEL_CONTROLLO_TRAFFICO_ACTIVE_POLICY_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String toStringCompactFilter(AttivazionePolicyFiltro filtro, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding) throws Exception {
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPolicy.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        StringBuilder bf = new StringBuilder("");
        if (filtro.isEnabled()) {
            Properties properties;
            IDSoggetto idSoggetto;
            if (configurazione && filtro.getRuoloPorta() != null && !RuoloPolicy.ENTRAMBI.equals((Object)filtro.getRuoloPorta())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                if (RuoloPolicy.DELEGATA.equals((Object)filtro.getRuoloPorta())) {
                    bf.append("Tipologia").append(": ");
                    bf.append("Fruizione");
                } else if (RuoloPolicy.APPLICATIVA.equals((Object)filtro.getRuoloPorta())) {
                    bf.append("Tipologia").append(": ");
                    bf.append("Erogazione");
                }
            }
            if (configurazione && filtro.getProtocollo() != null && !"".equals(filtro.getProtocollo())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Profilo: ");
                bf.append(this.getLabelProtocollo(filtro.getProtocollo()));
            }
            if (configurazione && filtro.getNomePorta() != null && !"".equals(filtro.getNomePorta())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Porta").append(": ");
                bf.append(filtro.getNomePorta());
            }
            if (configurazione) {
                if (filtro.getRuoloErogatore() != null) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Ruolo Erogatore").append(": ");
                    bf.append(filtro.getRuoloErogatore());
                } else if (filtro.getTipoErogatore() != null && !"".equals(filtro.getTipoErogatore()) && filtro.getNomeErogatore() != null && !"".equals(filtro.getNomeErogatore())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Erogatore").append(": ");
                    idSoggetto = new IDSoggetto(filtro.getTipoErogatore(), filtro.getNomeErogatore());
                    bf.append(this.getLabelNomeSoggetto(idSoggetto));
                }
            }
            if (configurazione && filtro.getTag() != null && !"".equals(filtro.getTag())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Tag").append(": ");
                bf.append(filtro.getTag());
            }
            if (!(!configurazione || filtro.getTipoServizio() == null || "".equals(filtro.getTipoServizio()) || filtro.getNomeServizio() == null || "".equals(filtro.getNomeServizio()) || filtro.getVersioneServizio() == null || filtro.getTipoErogatore() == null || "".equals(filtro.getTipoErogatore()) || filtro.getNomeErogatore() == null || "".equals(filtro.getNomeErogatore()))) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("API").append(": ");
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(filtro.getTipoServizio(), filtro.getNomeServizio(), filtro.getTipoErogatore(), filtro.getNomeErogatore(), filtro.getVersioneServizio().intValue());
                bf.append(this.getLabelIdServizio(idServizio));
            }
            if (filtro.getAzione() != null && !"".equals(filtro.getAzione())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append(this.getLabelAzione(serviceBinding)).append(": ");
                bf.append(filtro.getAzione());
            }
            if (configurazione && filtro.getServizioApplicativoErogatore() != null && !"".equals(filtro.getServizioApplicativoErogatore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Applicativo Erogatore").append(": ");
                bf.append(filtro.getServizioApplicativoErogatore());
            }
            if (configurazione || applicativa) {
                if (filtro.getRuoloFruitore() != null) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Ruolo Fruitore").append(": ");
                    bf.append(filtro.getRuoloFruitore());
                } else if (filtro.getTipoFruitore() != null && !"".equals(filtro.getTipoFruitore()) && filtro.getNomeFruitore() != null && !"".equals(filtro.getNomeFruitore())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Fruitore").append(": ");
                    idSoggetto = new IDSoggetto(filtro.getTipoFruitore(), filtro.getNomeFruitore());
                    bf.append(this.getLabelNomeSoggetto(idSoggetto));
                }
                if (configurazione && filtro.getServizioApplicativoFruitore() != null && !"".equals(filtro.getServizioApplicativoFruitore())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Applicativo").append(": ");
                    bf.append(filtro.getServizioApplicativoFruitore());
                }
            } else if (delegata) {
                if (filtro.getRuoloFruitore() != null) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Ruolo Fruitore").append(": ");
                    bf.append(filtro.getRuoloFruitore());
                } else if (filtro.getServizioApplicativoFruitore() != null && !"".equals(filtro.getServizioApplicativoFruitore())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Applicativo").append(": ");
                    bf.append(filtro.getServizioApplicativoFruitore());
                }
            }
            if (filtro.getTokenClaims() != null && (properties = PropertiesUtilities.convertTextToProperties((String)filtro.getTokenClaims())) != null && properties.size() > 0) {
                for (Object o : properties.keySet()) {
                    if (o == null || !(o instanceof String)) continue;
                    String key = (String)o;
                    String value = properties.getProperty(key);
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Token-").append(key).append(": ");
                    bf.append(value);
                }
            }
            if (filtro.isInformazioneApplicativaEnabled()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Chiave").append(": ");
                bf.append(filtro.getInformazioneApplicativaTipo());
            }
        } else {
            bf.append("Disabilitato");
        }
        if (bf.length() <= 0 && (delegata || applicativa)) {
            bf.append("Disabilitato");
        }
        return bf.toString();
    }

    public String toStringCompactGroupBy(AttivazionePolicyRaggruppamento groupBy, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding) {
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPolicy.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        StringBuilder bf = new StringBuilder("");
        if (groupBy.isEnabled()) {
            String[] tmp;
            if (configurazione && groupBy.isRuoloPorta()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Fruizione / Erogazione");
            }
            if (configurazione && groupBy.isProtocollo()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Profilo");
            }
            if (configurazione && groupBy.isErogatore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Erogatore");
            }
            if (configurazione && groupBy.isServizio()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("API");
            }
            if (groupBy.isAzione()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append(this.getLabelAzione(serviceBinding));
            }
            if (configurazione && groupBy.isServizioApplicativoErogatore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Applicativo Erogatore");
            }
            if (configurazione && groupBy.isFruitore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Fruitore");
            }
            if (configurazione && groupBy.isServizioApplicativoFruitore()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Applicativo");
            }
            if (!configurazione && (groupBy.isServizioApplicativoFruitore() || groupBy.isFruitore() || groupBy.isIdentificativoAutenticato())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Richiedente");
            }
            if (groupBy.getToken() != null && (tmp = groupBy.getToken().split(",")) != null && tmp.length > 0) {
                for (int i = 0; i < tmp.length; ++i) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append(tmp[i]);
                }
            }
            if (groupBy.isInformazioneApplicativaEnabled()) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Chiave:");
                bf.append(groupBy.getInformazioneApplicativaTipo());
            }
        } else {
            bf.append("Disabilitato");
        }
        return bf.toString();
    }

    public String readDatiGeneraliPolicyFromHttpParameters(ConfigurazionePolicy policy, boolean first) throws Exception {
        String valoreDataElementRisorsa;
        StringBuilder sbParsingError = new StringBuilder();
        String id = this.getParameter("CTPolicyId");
        if (id != null && !"".equals(id)) {
            try {
                long l = Long.parseLong(id);
                if (l <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                policy.setId(Long.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + id + ") indicato in 'CTPolicyId' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                this.logError(messaggio, e);
                this.addParsingError(sbParsingError, messaggio);
            }
        }
        if ((valoreDataElementRisorsa = this.getParameter("CTPolicyRisorsa")) != null && !"".equals(valoreDataElementRisorsa)) {
            try {
                TipoRisorsa tipoRisorsa = this.getTipoRisorsa(valoreDataElementRisorsa, this.getParameter("CTPolicyRisorsaEsiti"));
                policy.setRisorsa(tipoRisorsa.getValue());
                policy.setSimultanee(this.isTipoRisorsaNumeroRichiesteSimultanee(valoreDataElementRisorsa));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + valoreDataElementRisorsa + ") indicato in 'Risorsa' non \u00e8 tra i tipi di risorsa gestiti";
                this.logError(messaggio, e);
                this.addParsingError(sbParsingError, messaggio);
            }
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readValoriSogliaPolicyFromHttpParameters(ConfigurazionePolicy policy, boolean first) throws Exception {
        String messaggio;
        String label;
        StringBuilder sbParsingError = new StringBuilder();
        TipoRisorsa tipoRisorsa = null;
        try {
            tipoRisorsa = TipoRisorsa.toEnumConstant((String)policy.getRisorsa(), (boolean)true);
        }
        catch (Exception e) {
            String messaggio2 = "Il valore (" + policy.getRisorsa() + ") indicato in 'Risorsa' non \u00e8 tra le risorse gestite";
            this.logError(messaggio2, e);
            this.addParsingError(sbParsingError, messaggio2);
        }
        if (TipoRisorsa.OCCUPAZIONE_BANDA.equals((Object)tipoRisorsa)) {
            String tipoBanda = null;
            try {
                tipoBanda = this.getParameter("CTPolicySogliaValoreTipoBanda");
                if (tipoBanda != null && !"".equals(tipoBanda)) {
                    policy.setValoreTipoBanda(TipoBanda.toEnumConstant((String)tipoBanda, (boolean)true));
                } else if (policy.getValoreTipoBanda() == null) {
                    policy.setValoreTipoBanda(ConfigurazioneCostanti.TIPO_BANDA_DEFAULT);
                }
            }
            catch (Exception e) {
                label = "Tipo Banda";
                messaggio = "Il valore (" + tipoBanda + ") indicato in '" + label + "' non rientra tra i tipi conosciuti";
                this.logError(messaggio, e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else {
            policy.setValoreTipoBanda(null);
        }
        if (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa) || TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals((Object)tipoRisorsa)) {
            String tipoLatenza = null;
            try {
                tipoLatenza = this.getParameter("CTPolicySogliaValoreTipoLatenza");
                if (tipoLatenza != null && !"".equals(tipoLatenza)) {
                    policy.setValoreTipoLatenza(TipoLatenza.toEnumConstant((String)tipoLatenza, (boolean)true));
                } else if (policy.getValoreTipoLatenza() == null) {
                    policy.setValoreTipoLatenza(ConfigurazioneCostanti.TIPO_LATENZA_DEFAULT);
                }
            }
            catch (Exception e) {
                label = null;
                label = TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa) ? "Tipo Latenza" : "Tipo Latenza";
                messaggio = "Il valore (" + tipoLatenza + ") indicato in '" + label + "' non rientra tra i tipi conosciuti";
                this.logError(messaggio, e);
                this.addParsingError(sbParsingError, messaggio);
            }
        } else {
            policy.setValoreTipoLatenza(null);
        }
        String valore = this.getParameter("CTPolicySogliaValore");
        if (valore != null && !"".equals(valore)) {
            if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                try {
                    int i = Integer.parseInt(valore);
                    if (i <= 0) {
                        throw new DriverControlStationException("Valore non nell'intervallo");
                    }
                    policy.setValore(Long.valueOf(i));
                }
                catch (Exception e) {
                    label = "Dimensione Risposta";
                    messaggio = "Il valore (" + valore + ") indicato in '" + label + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                    this.logError(messaggio, e);
                    this.addParsingError(sbParsingError, messaggio);
                }
            } else {
                try {
                    long l = Long.parseLong(valore);
                    if (l <= 0L) {
                        throw new DriverControlStationException("Valore non nell'intervallo");
                    }
                    policy.setValore(Long.valueOf(l));
                }
                catch (Exception e) {
                    label = null;
                    label = TipoRisorsa.NUMERO_RICHIESTE.equals((Object)tipoRisorsa) ? "Num. Massimo Richieste" : (TipoRisorsa.OCCUPAZIONE_BANDA.equals((Object)tipoRisorsa) ? "Occupazione Massima" : (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa) ? "Tempo Medio di Risposta" : "Tempo Risposta"));
                    messaggio = "Il valore (" + valore + ") indicato in '" + label + "' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                    this.logError(messaggio, e);
                    this.addParsingError(sbParsingError, messaggio);
                }
            }
        } else if (!first) {
            policy.setValore(null);
        } else if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa) && policy.getValore() == null) {
            policy.setValore(Long.valueOf(10240L));
        }
        if (!policy.isSimultanee() && !TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
            if (TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals(policy.getRisorsa())) {
                policy.setModalitaControllo(TipoControlloPeriodo.REALTIME);
            } else {
                String modalitaControllo = null;
                try {
                    modalitaControllo = this.getParameter("CTPolicySogliaValoreTipoControllo");
                    if (modalitaControllo != null && !"".equals(modalitaControllo)) {
                        policy.setModalitaControllo(TipoControlloPeriodo.toEnumConstant((String)modalitaControllo, (boolean)true));
                    }
                }
                catch (Exception e) {
                    messaggio = "Il valore (" + modalitaControllo + ") indicato in 'Modalit\u00e0 di Controllo' non rientra tra le modalit\u00e0 conosciute";
                    this.logError(messaggio, e);
                    this.addParsingError(sbParsingError, messaggio);
                }
            }
            if (policy.getModalitaControllo() != null) {
                String postBackElementName;
                String finestraPeriodo;
                String periodo;
                String tipoControlloPeriodo = this.getParameter("CTPolicySogliaValoreTipoPeriodo");
                if (tipoControlloPeriodo != null && !"".equals(tipoControlloPeriodo)) {
                    if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
                        try {
                            policy.setTipoIntervalloOsservazioneRealtime(TipoPeriodoRealtime.toEnumConstant((String)tipoControlloPeriodo, (boolean)true));
                        }
                        catch (Exception e) {
                            try {
                                if (TipoPeriodoStatistico.toEnumConstant((String)tipoControlloPeriodo, (boolean)true) != null) {
                                    policy.setTipoIntervalloOsservazioneRealtime(ConfigurazioneCostanti.TIPO_PERIODO_REALTIME_DEFAULT);
                                }
                            }
                            catch (Exception eInterno) {
                                messaggio = "Il valore (" + tipoControlloPeriodo + ") indicato in 'Frequenza' non rientra tra gli intervalli conosciuti";
                                this.logError(messaggio, e);
                                this.addParsingError(sbParsingError, messaggio);
                            }
                        }
                    } else {
                        try {
                            policy.setTipoIntervalloOsservazioneStatistico(TipoPeriodoStatistico.toEnumConstant((String)tipoControlloPeriodo, (boolean)true));
                        }
                        catch (Exception e) {
                            try {
                                if (TipoPeriodoRealtime.toEnumConstant((String)tipoControlloPeriodo, (boolean)true) != null) {
                                    policy.setTipoIntervalloOsservazioneStatistico(ConfigurazioneCostanti.TIPO_PERIODO_STATISTICO_DEFAULT);
                                }
                            }
                            catch (Exception eInterno) {
                                messaggio = "Il valore (" + tipoControlloPeriodo + ") indicato in 'Frequenza' non rientra tra gli intervalli conosciuti";
                                this.logError(messaggio, e);
                                this.addParsingError(sbParsingError, messaggio);
                            }
                        }
                    }
                }
                if ((periodo = this.getParameter("CTPolicySogliaValorePeriodo")) != null && !"".equals(periodo)) {
                    try {
                        int i = Integer.parseInt(periodo);
                        if (i <= 0) {
                            throw new DriverControlStationException("Valore non nell'intervallo");
                        }
                        policy.setIntervalloOsservazione(Integer.valueOf(i));
                    }
                    catch (Exception e) {
                        String labelPeriodo = null;
                        labelPeriodo = TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo()) ? this.getLabel(policy.getTipoIntervalloOsservazioneRealtime()) : this.getLabel(policy.getTipoIntervalloOsservazioneStatistico());
                        String messaggio3 = "Il valore (" + periodo + ") indicato in '" + labelPeriodo + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                        this.logError(messaggio3, e);
                        this.addParsingError(sbParsingError, messaggio3);
                    }
                } else if (!first) {
                    policy.setIntervalloOsservazione(null);
                }
                if ((finestraPeriodo = this.getParameter("CTPolicySogliaFinestraPeriodo")) != null && !"".equals(finestraPeriodo)) {
                    boolean found = false;
                    if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
                        for (i = 0; i < ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_REALTIME.length; ++i) {
                            if (!ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_REALTIME[i].equals(finestraPeriodo)) continue;
                            found = true;
                            break;
                        }
                    } else {
                        for (i = 0; i < ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_STATISTICO.length; ++i) {
                            if (!ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_STATISTICO[i].equals(finestraPeriodo)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        try {
                            policy.setFinestraOsservazione(TipoFinestra.toEnumConstant((String)finestraPeriodo, (boolean)true));
                        }
                        catch (Exception e) {
                            String messaggio4 = "Il valore (" + finestraPeriodo + ") indicato in 'Finestra' non rientra tra le finestre conosciute";
                            this.logError(messaggio4, e);
                            this.addParsingError(sbParsingError, messaggio4);
                        }
                    } else {
                        policy.setFinestraOsservazione(null);
                    }
                }
                if (("CTPolicyRisorsa".equals(postBackElementName = this.getPostBackElementName()) || "CTPolicySogliaValoreTipoControllo".equals(postBackElementName)) && policy.getFinestraOsservazione() != null) {
                    policy.setFinestraOsservazione(null);
                }
            } else {
                policy.setModalitaControllo(ConfigurazioneCostanti.TIPO_CONTROLLO_PERIODO_DEFAULT);
                policy.setTipoIntervalloOsservazioneRealtime(ConfigurazioneCostanti.TIPO_PERIODO_REALTIME_DEFAULT);
                policy.setTipoIntervalloOsservazioneStatistico(ConfigurazioneCostanti.TIPO_PERIODO_STATISTICO_DEFAULT);
                policy.setIntervalloOsservazione(null);
                policy.setFinestraOsservazione(null);
            }
        } else if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
            String valore2 = this.getParameter("CTPolicySogliaValore2");
            if (valore2 != null && !"".equals(valore2)) {
                try {
                    int i = Integer.parseInt(valore2);
                    if (i <= 0) {
                        throw new DriverControlStationException("Valore non nell'intervallo");
                    }
                    policy.setValore2(Long.valueOf(i));
                }
                catch (Exception e) {
                    String label2 = "Dimensione Richiesta";
                    String messaggio5 = "Il valore (" + valore2 + ") indicato in '" + label2 + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                    this.logError(messaggio5, e);
                    this.addParsingError(sbParsingError, messaggio5);
                }
            } else if (!first) {
                policy.setValore2(null);
            } else if (policy.getValore2() == null) {
                policy.setValore2(Long.valueOf(10240L));
            }
            policy.setModalitaControllo(ConfigurazioneCostanti.TIPO_CONTROLLO_PERIODO_DEFAULT);
            policy.setTipoIntervalloOsservazioneRealtime(ConfigurazioneCostanti.TIPO_PERIODO_REALTIME_DEFAULT);
            policy.setTipoIntervalloOsservazioneStatistico(ConfigurazioneCostanti.TIPO_PERIODO_STATISTICO_DEFAULT);
            policy.setIntervalloOsservazione(null);
            policy.setFinestraOsservazione(null);
        } else {
            policy.setModalitaControllo(ConfigurazioneCostanti.TIPO_CONTROLLO_PERIODO_DEFAULT);
            policy.setTipoIntervalloOsservazioneRealtime(ConfigurazioneCostanti.TIPO_PERIODO_REALTIME_DEFAULT);
            policy.setTipoIntervalloOsservazioneStatistico(ConfigurazioneCostanti.TIPO_PERIODO_STATISTICO_DEFAULT);
            policy.setIntervalloOsservazione(null);
            policy.setFinestraOsservazione(null);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readApplicabilitaPolicyFromHttpParameters(ConfigurazionePolicy policy, boolean first) throws Exception {
        String messaggioErroreReadApplicabilita;
        String messaggioErroreDegradoPrestazione;
        StringBuilder sbParsingError = new StringBuilder();
        TipoRisorsa tipoRisorsa = TipoRisorsa.toEnumConstant((String)policy.getRisorsa());
        if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
            policy.setTipoApplicabilita(TipoApplicabilita.SEMPRE);
            return null;
        }
        String condizionale = this.getParameter("CTPolicyApplicabilitaTipo");
        if (!first) {
            if (ServletUtils.isCheckBoxEnabled((String)condizionale)) {
                policy.setTipoApplicabilita(TipoApplicabilita.CONDIZIONALE);
            } else {
                policy.setTipoApplicabilita(TipoApplicabilita.SEMPRE);
            }
        } else if (policy.getTipoApplicabilita() == null) {
            policy.setTipoApplicabilita(TipoApplicabilita.SEMPRE);
        }
        String congestioneInCorso = this.getParameter("CTPolicyApplicabilitaConCongestione");
        if (!first) {
            policy.setApplicabilitaConCongestione(ServletUtils.isCheckBoxEnabled((String)congestioneInCorso));
        }
        String degradoPrestazionale = this.getParameter("CTPolicyApplicabilitaConDegradoPrestazionale");
        if (!first) {
            policy.setApplicabilitaDegradoPrestazionale(ServletUtils.isCheckBoxEnabled((String)degradoPrestazionale));
        }
        String statoAllarme = this.getParameter("CTPolicyApplicabilitaStatoAllarme");
        if (!first) {
            policy.setApplicabilitaStatoAllarme(ServletUtils.isCheckBoxEnabled((String)statoAllarme));
        }
        if ((messaggioErroreDegradoPrestazione = this.readApplicabilitaDegradoPrestazionalePolicyFromHttpParameters(policy, first)) != null) {
            this.addParsingError(sbParsingError, messaggioErroreDegradoPrestazione);
        }
        if ((messaggioErroreReadApplicabilita = this.readApplicabilitaStatoAllarmePolicyFromHttpParameters(policy, first)) != null) {
            this.addParsingError(sbParsingError, messaggioErroreReadApplicabilita);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    private String readApplicabilitaDegradoPrestazionalePolicyFromHttpParameters(ConfigurazionePolicy policy, boolean first) throws Exception {
        StringBuilder sbParsingError = new StringBuilder();
        if (policy.isApplicabilitaDegradoPrestazionale()) {
            String postBackElementName;
            String finestraPeriodo;
            String periodo;
            String modalitaControllo = null;
            try {
                modalitaControllo = this.getParameter("CTPolicyApplicabilitaConDegradoPrestazionaleTipoControllo");
                if (modalitaControllo != null && !"".equals(modalitaControllo)) {
                    policy.setDegradoAvgTimeModalitaControllo(TipoControlloPeriodo.toEnumConstant((String)modalitaControllo, (boolean)true));
                } else if (policy.getDegradoAvgTimeModalitaControllo() == null) {
                    policy.setDegradoAvgTimeModalitaControllo(ConfigurazioneCostanti.TIPO_CONTROLLO_PERIODO_DEFAULT);
                }
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + modalitaControllo + ") indicato in 'Modalit\u00e0 di Controllo' non rientra tra le modalit\u00e0 conosciute";
                this.logError(messaggio, e);
                this.addParsingError(sbParsingError, messaggio);
            }
            String tipoLatenza = null;
            try {
                tipoLatenza = this.getParameter("CTPolicyApplicabilitaConDegradoPrestazionaleTipoLatenza");
                if (tipoLatenza != null && !"".equals(tipoLatenza)) {
                    policy.setDegradoAvgTimeTipoLatenza(TipoLatenza.toEnumConstant((String)tipoLatenza, (boolean)true));
                } else if (policy.getDegradoAvgTimeTipoLatenza() == null) {
                    policy.setDegradoAvgTimeTipoLatenza(ConfigurazioneCostanti.TIPO_LATENZA_DEFAULT);
                }
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + tipoLatenza + ") indicato in 'Tempo Medio Risposta' non rientra tra i tipi conosciuti";
                this.logError(messaggio, e);
                this.addParsingError(sbParsingError, messaggio);
            }
            String tipoControlloPeriodo = this.getParameter("CTPolicyApplicabilitaConDegradoPrestazionaleTipoPeriodo");
            if (tipoControlloPeriodo != null && !"".equals(tipoControlloPeriodo)) {
                if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo())) {
                    try {
                        policy.setDegradoAvgTimeTipoIntervalloOsservazioneRealtime(TipoPeriodoRealtime.toEnumConstant((String)tipoControlloPeriodo, (boolean)true));
                    }
                    catch (Exception e) {
                        try {
                            if (TipoPeriodoStatistico.toEnumConstant((String)tipoControlloPeriodo, (boolean)true) != null) {
                                policy.setDegradoAvgTimeTipoIntervalloOsservazioneRealtime(ConfigurazioneCostanti.TIPO_PERIODO_REALTIME_DEFAULT);
                            }
                        }
                        catch (Exception eInterno) {
                            messaggio = "Il valore (" + tipoControlloPeriodo + ") indicato in 'Frequenza' non rientra tra gli intervalli conosciuti";
                            this.logError(messaggio, e);
                            this.addParsingError(sbParsingError, messaggio);
                        }
                    }
                } else {
                    try {
                        policy.setDegradoAvgTimeTipoIntervalloOsservazioneStatistico(TipoPeriodoStatistico.toEnumConstant((String)tipoControlloPeriodo, (boolean)true));
                    }
                    catch (Exception e) {
                        try {
                            if (TipoPeriodoRealtime.toEnumConstant((String)tipoControlloPeriodo, (boolean)true) != null) {
                                policy.setDegradoAvgTimeTipoIntervalloOsservazioneStatistico(ConfigurazioneCostanti.TIPO_PERIODO_STATISTICO_DEFAULT);
                            }
                        }
                        catch (Exception eInterno) {
                            messaggio = "Il valore (" + tipoControlloPeriodo + ") indicato in 'Frequenza' non rientra tra gli intervalli conosciuti";
                            this.logError(messaggio, e);
                            this.addParsingError(sbParsingError, messaggio);
                        }
                    }
                }
            } else if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo())) {
                if (policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime() == null) {
                    policy.setDegradoAvgTimeTipoIntervalloOsservazioneRealtime(ConfigurazioneCostanti.TIPO_PERIODO_REALTIME_DEFAULT);
                }
            } else if (policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico() == null) {
                policy.setDegradoAvgTimeTipoIntervalloOsservazioneStatistico(ConfigurazioneCostanti.TIPO_PERIODO_STATISTICO_DEFAULT);
            }
            if ((periodo = this.getParameter("CTPolicyApplicabilitaConDegradoPrestazionalePeriodo")) != null && !"".equals(periodo)) {
                try {
                    int i = Integer.parseInt(periodo);
                    if (i <= 0) {
                        throw new DriverControlStationException("Valore non nell'intervallo");
                    }
                    policy.setDegradoAvgTimeIntervalloOsservazione(Integer.valueOf(i));
                }
                catch (Exception e) {
                    String labelIntervallo = null;
                    labelIntervallo = TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo()) ? this.getLabel(policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime()) : this.getLabel(policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico());
                    String messaggio = "Il valore (" + periodo + ") indicato in '" + labelIntervallo + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                    this.logError(messaggio, e);
                    this.addParsingError(sbParsingError, messaggio);
                }
            } else if (!first) {
                policy.setDegradoAvgTimeIntervalloOsservazione(null);
            }
            if ((finestraPeriodo = this.getParameter("CTPolicyApplicabilitaConDegradoPrestazionaleFinestraPeriodo")) != null && !"".equals(finestraPeriodo)) {
                boolean found = false;
                if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
                    for (i = 0; i < ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_REALTIME.length; ++i) {
                        if (!ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_REALTIME[i].equals(finestraPeriodo)) continue;
                        found = true;
                        break;
                    }
                } else {
                    for (i = 0; i < ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_STATISTICO.length; ++i) {
                        if (!ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_STATISTICO[i].equals(finestraPeriodo)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    try {
                        policy.setDegradoAvgTimeFinestraOsservazione(TipoFinestra.toEnumConstant((String)finestraPeriodo, (boolean)true));
                    }
                    catch (Exception e) {
                        String messaggio = "Il valore (" + finestraPeriodo + ") indicato in 'Finestra' non rientra tra le finestre conosciute";
                        this.logError(messaggio, e);
                        this.addParsingError(sbParsingError, messaggio);
                    }
                } else {
                    policy.setDegradoAvgTimeFinestraOsservazione(null);
                }
            }
            if ("CTPolicyApplicabilitaConDegradoPrestazionaleTipoControllo".equals(postBackElementName = this.getPostBackElementName()) && policy.getDegradoAvgTimeFinestraOsservazione() != null) {
                policy.setDegradoAvgTimeFinestraOsservazione(null);
            }
        } else {
            policy.setDegradoAvgTimeModalitaControllo(null);
            policy.setDegradoAvgTimeTipoLatenza(null);
            policy.setDegradoAvgTimeTipoIntervalloOsservazioneRealtime(null);
            policy.setDegradoAvgTimeTipoIntervalloOsservazioneStatistico(null);
            policy.setDegradoAvgTimeIntervalloOsservazione(null);
            policy.setDegradoAvgTimeFinestraOsservazione(null);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    private String readApplicabilitaStatoAllarmePolicyFromHttpParameters(ConfigurazionePolicy policy, boolean first) throws Exception {
        StringBuilder sbParsingError = new StringBuilder();
        if (policy.isApplicabilitaStatoAllarme()) {
            String stato;
            String nome = this.getParameter("CTPolicyApplicabilitaStatoAllarmeNome");
            if (nome != null && !"".equals(nome) && !"-".equals(nome)) {
                policy.setAllarmeNome(nome);
            }
            String statoNotAllarme = this.getParameter("CTPolicyApplicabilitaStatoAllarmeNotStato");
            if (!first) {
                policy.setAllarmeNotStato(ServletUtils.isCheckBoxEnabled((String)statoNotAllarme));
            }
            if ((stato = this.getParameter("CTPolicyApplicabilitaStatoAllarmeStato")) != null && !"".equals(stato)) {
                try {
                    int i = Integer.parseInt(stato);
                    if (i < 0) {
                        throw new DriverControlStationException("Valore non nell'intervallo");
                    }
                    policy.setAllarmeStato(Integer.valueOf(i));
                }
                catch (Exception e) {
                    String messaggio = "Lo stato (" + stato + ") selezionato in 'Stato' non risulta tra quelli gestiti";
                    this.logError(messaggio, e);
                    this.addParsingError(sbParsingError, messaggio);
                }
            } else if (policy.getAllarmeStato() == null) {
                policy.setAllarmeStato(ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_DEFAULT);
            }
        } else {
            policy.setAllarmeNome(null);
            policy.setAllarmeNotStato(false);
            policy.setAllarmeStato(null);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String getNomeSuggerito(ConfigurazionePolicy policy) {
        StringBuilder bfSuggerimentoNome = new StringBuilder();
        bfSuggerimentoNome.append(policy.getRisorsa());
        TipoRisorsa risorsa = TipoRisorsa.toEnumConstant((String)policy.getRisorsa());
        if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)risorsa)) {
            return bfSuggerimentoNome.toString();
        }
        if (policy.isSimultanee()) {
            bfSuggerimentoNome.append("-").append("RichiesteSimultanee");
        } else if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
            bfSuggerimentoNome.append("-ControlloRealtime").append(("" + policy.getTipoIntervalloOsservazioneRealtime().getValue().charAt(0)).toUpperCase()).append(policy.getTipoIntervalloOsservazioneRealtime().getValue().substring(1));
        } else {
            bfSuggerimentoNome.append("-ControlloStatistico").append(("" + policy.getTipoIntervalloOsservazioneStatistico().getValue().charAt(0)).toUpperCase()).append(policy.getTipoIntervalloOsservazioneStatistico().getValue().substring(1));
        }
        if (TipoApplicabilita.CONDIZIONALE.equals((Object)policy.getTipoApplicabilita())) {
            StringBuilder bfInterno = new StringBuilder();
            bfInterno.append("-Condizionale");
            if (policy.isApplicabilitaConCongestione()) {
                bfInterno.append("-CongestioneTraffico");
            }
            if (policy.isApplicabilitaDegradoPrestazionale()) {
                bfInterno.append("-DegradoPrestazionale");
                if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo())) {
                    bfInterno.append("Realtime").append(("" + policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime().getValue().charAt(0)).toUpperCase()).append(policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime().getValue().substring(1));
                } else {
                    bfInterno.append("Statistico").append(("" + policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico().getValue().charAt(0)).toUpperCase()).append(policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico().getValue().substring(1));
                }
            }
            if (policy.isApplicabilitaStatoAllarme()) {
                bfInterno.append("-StatoAllarme");
            }
            bfSuggerimentoNome.append(bfInterno.toString());
        }
        return bfSuggerimentoNome.toString();
    }

    public String getDescrizioneSuggerita(ConfigurazionePolicy policy) {
        StringBuilder bfSuggerimentoDescrizione = new StringBuilder();
        TipoRisorsa risorsa = TipoRisorsa.toEnumConstant((String)policy.getRisorsa());
        StringBuilder bfIntervallo = new StringBuilder();
        if (!policy.isSimultanee() && !TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)risorsa)) {
            TipoFinestra finestra;
            bfIntervallo.append(" durante l'intervallo di tempo specificato in ");
            if (policy.getIntervalloOsservazione() != null) {
                bfIntervallo.append(policy.getIntervalloOsservazione()).append(" ");
            }
            if ((finestra = policy.getFinestraOsservazione()) == null) {
                finestra = this.getTipoFinestraDefault(policy.getModalitaControllo(), policy.getRisorsa(), false);
            }
            Object finestraDescrizione = "";
            if (finestra != null) {
                finestraDescrizione = ", finestra " + finestra.getValue();
            }
            Object tipoRisorsa = "";
            if (risorsa != null && TipoRisorsa.OCCUPAZIONE_BANDA.equals((Object)risorsa)) {
                TipoBanda banda = policy.getValoreTipoBanda();
                if (banda == null) {
                    banda = ConfigurazioneCostanti.TIPO_BANDA_DEFAULT;
                }
                if (banda != null) {
                    tipoRisorsa = ", tipo banda " + banda.getValue();
                }
            } else if (risorsa != null && (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)risorsa) || TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals((Object)risorsa))) {
                TipoLatenza latenza = policy.getValoreTipoLatenza();
                if (latenza == null) {
                    latenza = ConfigurazioneCostanti.TIPO_LATENZA_DEFAULT;
                }
                if (latenza != null) {
                    tipoRisorsa = ", tipo latenza " + latenza.getValue();
                }
            }
            if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
                switch (policy.getTipoIntervalloOsservazioneRealtime()) {
                    case SECONDI: {
                        bfIntervallo.append("secondi");
                        break;
                    }
                    case MINUTI: {
                        bfIntervallo.append("minuti");
                        break;
                    }
                    case ORARIO: {
                        bfIntervallo.append("ore");
                        break;
                    }
                    case GIORNALIERO: {
                        bfIntervallo.append("giorni");
                    }
                }
                bfIntervallo.append(" (campionamento real-time").append((String)finestraDescrizione).append((String)tipoRisorsa).append(").");
            } else {
                switch (policy.getTipoIntervalloOsservazioneStatistico()) {
                    case ORARIO: {
                        bfIntervallo.append("ore");
                        break;
                    }
                    case GIORNALIERO: {
                        bfIntervallo.append("giorni");
                        break;
                    }
                    case SETTIMANALE: {
                        bfIntervallo.append("settimane");
                        break;
                    }
                    case MENSILE: {
                        bfIntervallo.append("mesi");
                    }
                }
                bfIntervallo.append(" (campionamento statistico").append((String)finestraDescrizione).append((String)tipoRisorsa).append(").");
            }
        }
        if (risorsa != null) {
            switch (risorsa) {
                case NUMERO_RICHIESTE: {
                    bfSuggerimentoDescrizione.append("La policy limita il numero totale massimo di richieste ");
                    if (policy.isSimultanee()) {
                        bfSuggerimentoDescrizione.append("simultanee ");
                    }
                    bfSuggerimentoDescrizione.append("consentite");
                    if (!policy.isSimultanee()) break;
                    bfSuggerimentoDescrizione.append(".");
                    break;
                }
                case DIMENSIONE_MASSIMA_MESSAGGIO: {
                    bfSuggerimentoDescrizione.append("La policy limita la dimensione massima, in KB, consentita per una richiesta e/o per una risposta");
                    break;
                }
                case OCCUPAZIONE_BANDA: {
                    bfSuggerimentoDescrizione.append("La policy limita il numero totale massimo di KB consentiti");
                    break;
                }
                case TEMPO_MEDIO_RISPOSTA: {
                    bfSuggerimentoDescrizione.append("La policy blocca ogni successiva richiesta se viene rilevato un tempo medio di risposta elevato");
                    break;
                }
                case TEMPO_COMPLESSIVO_RISPOSTA: {
                    bfSuggerimentoDescrizione.append("La policy limita il numero totale massimo di secondi consentiti");
                    break;
                }
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                    bfSuggerimentoDescrizione.append("La policy conteggia il numero di richieste completate con successo; raggiunto il limite, ogni successiva richiesta viene bloccata");
                    break;
                }
                case NUMERO_RICHIESTE_FALLITE: {
                    bfSuggerimentoDescrizione.append("La policy conteggia il numero di richieste fallite; raggiunto il limite, ogni successiva richiesta viene bloccata");
                    break;
                }
                case NUMERO_FAULT_APPLICATIVI: {
                    bfSuggerimentoDescrizione.append("La policy conteggia il numero di richieste che veicolano un fault applicativo; raggiunto il limite, ogni successiva richiesta viene bloccata");
                    break;
                }
                case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                    bfSuggerimentoDescrizione.append("La policy conteggia il numero di richieste fallite o che veicolano un fault applicativo; raggiunto il limite, ogni successiva richiesta viene bloccata");
                    break;
                }
                case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                    bfSuggerimentoDescrizione.append("La policy conteggia il numero di richieste completate con successo o che veicolano un fault applicativo; raggiunto il limite, ogni successiva richiesta viene bloccata");
                }
            }
        }
        if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)risorsa)) {
            return bfSuggerimentoDescrizione.toString();
        }
        bfSuggerimentoDescrizione.append(bfIntervallo.toString());
        if (policy.isApplicabilitaConCongestione() || policy.isApplicabilitaDegradoPrestazionale() || policy.isApplicabilitaStatoAllarme()) {
            bfSuggerimentoDescrizione.append("\nLa policy viene applicata solamente se ");
            StringBuilder bfApplicabilita = new StringBuilder();
            if (policy.isApplicabilitaConCongestione()) {
                bfApplicabilita.append("il Gateway risulta Congestionato dalle richieste");
            }
            if (policy.isApplicabilitaDegradoPrestazionale()) {
                TipoFinestra finestra;
                if (bfApplicabilita.length() > 0) {
                    bfApplicabilita.append(" ed ");
                }
                if ((finestra = policy.getDegradoAvgTimeFinestraOsservazione()) == null) {
                    finestra = this.getTipoFinestraDefault(policy.getDegradoAvgTimeModalitaControllo(), policy.getRisorsa(), true);
                }
                Object finestraDescrizione = "";
                if (finestra != null) {
                    finestraDescrizione = ", finestra " + finestra.getValue();
                }
                Object tipoRisorsa = "";
                TipoLatenza latenza = policy.getDegradoAvgTimeTipoLatenza();
                if (latenza == null) {
                    latenza = ConfigurazioneCostanti.TIPO_LATENZA_DEFAULT;
                }
                if (latenza != null) {
                    tipoRisorsa = ", tipo latenza " + latenza.getValue();
                }
                Object intervalloDescrizione = "";
                if (policy.getDegradoAvgTimeModalitaControllo() != null) {
                    intervalloDescrizione = ", intervallo di tempo specificato in ";
                    if (policy.getDegradoAvgTimeIntervalloOsservazione() != null) {
                        intervalloDescrizione = (String)intervalloDescrizione + policy.getDegradoAvgTimeIntervalloOsservazione();
                        intervalloDescrizione = (String)intervalloDescrizione + " ";
                    }
                    if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo())) {
                        switch (policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime()) {
                            case SECONDI: {
                                intervalloDescrizione = (String)intervalloDescrizione + "secondi";
                                break;
                            }
                            case MINUTI: {
                                intervalloDescrizione = (String)intervalloDescrizione + "minuti";
                                break;
                            }
                            case ORARIO: {
                                intervalloDescrizione = (String)intervalloDescrizione + "ore";
                                break;
                            }
                            case GIORNALIERO: {
                                intervalloDescrizione = (String)intervalloDescrizione + "giorni";
                            }
                        }
                    } else {
                        switch (policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico()) {
                            case ORARIO: {
                                intervalloDescrizione = (String)intervalloDescrizione + "ore";
                                break;
                            }
                            case GIORNALIERO: {
                                intervalloDescrizione = (String)intervalloDescrizione + "giorni";
                                break;
                            }
                            case SETTIMANALE: {
                                intervalloDescrizione = (String)intervalloDescrizione + "settimane";
                                break;
                            }
                            case MENSILE: {
                                intervalloDescrizione = (String)intervalloDescrizione + "mesi";
                            }
                        }
                    }
                }
                String tipoCampionamento = null;
                tipoCampionamento = TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo()) ? "(campionamento realtime" + (String)intervalloDescrizione + (String)finestraDescrizione + (String)tipoRisorsa + ")" : "(campionamento statistico" + (String)intervalloDescrizione + (String)finestraDescrizione + (String)tipoRisorsa + ")";
                bfApplicabilita.append("il tempo medio di risposta del servizio " + tipoCampionamento + " risulta superiore ai livelli di soglia impostati");
            }
            if (policy.isApplicabilitaStatoAllarme()) {
                if (bfApplicabilita.length() > 0) {
                    bfApplicabilita.append(" e ");
                }
                bfApplicabilita.append("l'allarme selezionato soddisfa lo stato indicato");
            }
            bfApplicabilita.append(".");
            bfSuggerimentoDescrizione.append(bfApplicabilita.toString());
        }
        return bfSuggerimentoDescrizione.toString();
    }

    public TipoFinestra getTipoFinestraDefault(TipoControlloPeriodo modalitaControllo, String risorsa, boolean degrado) {
        if (modalitaControllo != null) {
            if (TipoControlloPeriodo.REALTIME.equals((Object)modalitaControllo)) {
                TipoRisorsa tipo;
                if (degrado) {
                    return TipoFinestra.PRECEDENTE;
                }
                if (risorsa != null && (tipo = TipoRisorsa.toEnumConstant((String)risorsa)) != null) {
                    switch (tipo) {
                        case NUMERO_RICHIESTE: 
                        case DIMENSIONE_MASSIMA_MESSAGGIO: 
                        case OCCUPAZIONE_BANDA: 
                        case TEMPO_COMPLESSIVO_RISPOSTA: 
                        case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                        case NUMERO_RICHIESTE_FALLITE: 
                        case NUMERO_FAULT_APPLICATIVI: 
                        case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                        case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                            return TipoFinestra.CORRENTE;
                        }
                        case TEMPO_MEDIO_RISPOSTA: {
                            return TipoFinestra.PRECEDENTE;
                        }
                    }
                }
            } else {
                TipoRisorsa tipo;
                if (degrado) {
                    return TipoFinestra.SCORREVOLE;
                }
                if (risorsa != null && (tipo = TipoRisorsa.toEnumConstant((String)risorsa)) != null) {
                    switch (tipo) {
                        case NUMERO_RICHIESTE: 
                        case DIMENSIONE_MASSIMA_MESSAGGIO: 
                        case OCCUPAZIONE_BANDA: 
                        case TEMPO_COMPLESSIVO_RISPOSTA: 
                        case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: 
                        case NUMERO_RICHIESTE_FALLITE: 
                        case NUMERO_FAULT_APPLICATIVI: 
                        case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: 
                        case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                            return TipoFinestra.CORRENTE;
                        }
                        case TEMPO_MEDIO_RISPOSTA: {
                            return TipoFinestra.SCORREVOLE;
                        }
                    }
                }
            }
        }
        return null;
    }

    public void addConfigurazionePolicyToDati(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazionePolicy policy, boolean editMode, long numeroPolicyIstanziate, String oldNomeSuggeritoPolicy, String oldDDescrizioneSuggeritaPolicy, String oldPolicyId) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Policy");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (policy.getId() != null && policy.getId() > 0L) {
            de = new DataElement();
            de.setName("CTPolicyId");
            de.setValue("" + policy.getId());
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        if (oldNomeSuggeritoPolicy != null) {
            de = new DataElement();
            de.setName("CTPolicyOldNomeSuggerito");
            de.setValue(oldNomeSuggeritoPolicy);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        if (oldDDescrizioneSuggeritaPolicy != null) {
            de = new DataElement();
            de.setName("CTPolicyOldDescrizioneSuggerita");
            de.setValue(oldDDescrizioneSuggeritaPolicy);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        if (oldPolicyId != null) {
            de = new DataElement();
            de.setName("CTPolicyOldId");
            de.setValue(oldPolicyId);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyName");
        de.setLabel("Nome");
        de.setValue(policy.getIdPolicy());
        if (editMode) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setSize(70);
        dati.add(de);
        de = new DataElement();
        de.setName("CTPolicyDescrizione");
        de.setLabel("Descrizione");
        de.setValue(policy.getDescrizione());
        if (editMode) {
            de.setType(DataElementType.TEXT_AREA);
            de.setLabelAffiancata(true);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
        }
        de.setRows(6);
        de.setCols(55);
        dati.add(de);
        this.addDataElementRisorsa(dati, "CTPolicyRisorsa", this.getDataElementValueRisorsa(policy.getRisorsa(), policy.isSimultanee()), "CTPolicyRisorsaEsiti", this.getDataElementValueRisorsaEsiti(policy.getRisorsa()), editMode);
        if (!editMode && numeroPolicyIstanziate > 0L) {
            de = new DataElement();
            de.setLabel("Utilizzo");
            String name = numeroPolicyIstanziate + " istanza";
            if (numeroPolicyIstanziate > 1L) {
                name = numeroPolicyIstanziate + " istanze";
            }
            de.setValue("La policy risulta utilizzata in ISTANZA".replace("ISTANZA", name));
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
    }

    public void addConfigurazionePolicyValoriSoglia(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazionePolicy policy, boolean editMode, boolean editOnlyValueMode) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Valori di Soglia");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (!policy.isSimultanee() && !TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals(policy.getRisorsa())) {
            de = new DataElement();
            de.setName("CTPolicySogliaValoreTipoControllo");
            de.setLabel("Modalit\u00e0 di Controllo");
            if (TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals(policy.getRisorsa())) {
                de.setType(DataElementType.TEXT);
                policy.setModalitaControllo(TipoControlloPeriodo.REALTIME);
                de.setValue(policy.getModalitaControllo().getValue());
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(ConfigurazioneCostanti.TIPI_CONTROLLO);
                de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_CONTROLLO);
                if (policy.getModalitaControllo() != null) {
                    de.setSelected(policy.getModalitaControllo().getValue());
                    de.setValue(policy.getModalitaControllo().getValue());
                }
            }
            de.setPostBack_viaPOST(true);
            if (!editMode) {
                de.setType(DataElementType.HIDDEN);
            }
            dati.add(de);
            if (!editMode) {
                de = new DataElement();
                de.setName("CTPolicySogliaValoreTipoControllo_NoEdit");
                de.setLabel("Modalit\u00e0 di Controllo");
                if (TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals(policy.getRisorsa())) {
                    de.setValue("Realtime");
                } else if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
                    de.setValue("Realtime");
                } else {
                    de.setValue("Statistica");
                }
                de.setType(DataElementType.TEXT);
                dati.add(de);
            }
        }
        this.addToDatiPolicyValue(dati, policy, editMode, editOnlyValueMode);
        if (!policy.isSimultanee() && !TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals(policy.getRisorsa())) {
            de = new DataElement();
            de.setLabel("Intervallo Osservazione");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicySogliaValoreTipoPeriodo");
            de.setLabel("Frequenza");
            if (editMode) {
                de.setType(DataElementType.SELECT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
                de.setValues(ConfigurazioneCostanti.TIPI_INTERVALLO_OSSERVAZIONE_REALTIME);
                de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_INTERVALLO_OSSERVAZIONE_REALTIME);
                if (policy.getTipoIntervalloOsservazioneRealtime() != null) {
                    de.setSelected(policy.getTipoIntervalloOsservazioneRealtime().getValue());
                    de.setValue(policy.getTipoIntervalloOsservazioneRealtime().getValue());
                }
            } else {
                de.setValues(ConfigurazioneCostanti.TIPI_INTERVALLO_OSSERVAZIONE_STATISTICO);
                de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_INTERVALLO_OSSERVAZIONE_STATISTICO);
                if (policy.getTipoIntervalloOsservazioneStatistico() != null) {
                    de.setSelected(policy.getTipoIntervalloOsservazioneStatistico().getValue());
                    de.setValue(policy.getTipoIntervalloOsservazioneStatistico().getValue());
                }
            }
            de.setPostBack_viaPOST(true);
            dati.add(de);
            if (!editMode) {
                de = new DataElement();
                de.setName("CTPolicySogliaValoreTipoPeriodo_NoEdit");
                de.setLabel("Frequenza");
                if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo())) {
                    switch (policy.getTipoIntervalloOsservazioneRealtime()) {
                        case GIORNALIERO: {
                            de.setValue("Giornaliero");
                            break;
                        }
                        case ORARIO: {
                            de.setValue("Orario");
                            break;
                        }
                        case MINUTI: {
                            de.setValue("Minuti");
                            break;
                        }
                        case SECONDI: {
                            de.setValue("Secondi");
                        }
                    }
                } else {
                    switch (policy.getTipoIntervalloOsservazioneStatistico()) {
                        case MENSILE: {
                            de.setValue("Mensile");
                            break;
                        }
                        case SETTIMANALE: {
                            de.setValue("Settimanale");
                            break;
                        }
                        case GIORNALIERO: {
                            de.setValue("Giornaliero");
                            break;
                        }
                        case ORARIO: {
                            de.setValue("Orario");
                        }
                    }
                }
                de.setType(DataElementType.TEXT);
                dati.add(de);
            }
            String labelPeriodo = null;
            labelPeriodo = TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo()) ? this.getLabel(policy.getTipoIntervalloOsservazioneRealtime()) : this.getLabel(policy.getTipoIntervalloOsservazioneStatistico());
            de = new DataElement();
            de.setName("CTPolicySogliaValorePeriodo");
            de.setLabel(labelPeriodo);
            if (editMode) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.TEXT);
            }
            if (policy.getIntervalloOsservazione() != null) {
                de.setValue("" + policy.getIntervalloOsservazione());
            }
            if (editMode) {
                de.setRequired(true);
            }
            dati.add(de);
            DataElement deNoEditMode = null;
            if (!editMode) {
                deNoEditMode = new DataElement();
                deNoEditMode.setName("CTPolicySogliaFinestraPeriodo_NoEdit");
                deNoEditMode.setLabel("Finestra");
                deNoEditMode.setType(DataElementType.TEXT);
            }
            de = new DataElement();
            de.setName("CTPolicySogliaFinestraPeriodo");
            de.setLabel("Finestra");
            if (editMode) {
                de.setType(DataElementType.SELECT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            this.setValueFinestra(de, deNoEditMode, policy.getModalitaControllo(), policy.getFinestraOsservazione(), policy.getRisorsa(), false);
            if (!editMode) {
                de.setRequired(false);
            }
            de.setPostBack_viaPOST(true);
            dati.add(de);
            if (!editMode) {
                dati.add(deNoEditMode);
            }
        }
    }

    private void setValueFinestra(DataElement de, DataElement deNoEditMode, TipoControlloPeriodo modalitaControllo, TipoFinestra finestra, String risorsa, boolean degrado) {
        boolean found = false;
        if (TipoControlloPeriodo.REALTIME.equals((Object)modalitaControllo)) {
            de.setValues(ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_REALTIME);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_FINESTRA_OSSERVAZIONE_REALTIME);
            if (finestra != null) {
                for (i = 0; i < ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_REALTIME.length; ++i) {
                    if (!ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_REALTIME[i].equals(finestra.getValue())) continue;
                    found = true;
                    break;
                }
            }
        } else {
            de.setValues(ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_STATISTICO);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_FINESTRA_OSSERVAZIONE_STATISTICO);
            if (finestra != null) {
                for (i = 0; i < ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_STATISTICO.length; ++i) {
                    if (!ConfigurazioneCostanti.TIPI_FINESTRA_OSSERVAZIONE_STATISTICO[i].equals(finestra.getValue())) continue;
                    found = true;
                    break;
                }
            }
        }
        if (found) {
            de.setSelected(finestra.getValue());
            de.setValue(finestra.getValue());
            if (deNoEditMode != null) {
                switch (finestra) {
                    case CORRENTE: {
                        deNoEditMode.setValue("Corrente");
                        break;
                    }
                    case PRECEDENTE: {
                        deNoEditMode.setValue("Precedente");
                        break;
                    }
                    case SCORREVOLE: {
                        deNoEditMode.setValue("Scorrevole");
                    }
                }
            }
        } else {
            TipoFinestra tipoFinestraDefault = this.getTipoFinestraDefault(modalitaControllo, risorsa, degrado);
            if (tipoFinestraDefault != null) {
                de.setSelected(tipoFinestraDefault.getValue());
                de.setValue(tipoFinestraDefault.getValue());
                if (deNoEditMode != null) {
                    switch (tipoFinestraDefault) {
                        case CORRENTE: {
                            deNoEditMode.setValue("Corrente");
                            break;
                        }
                        case PRECEDENTE: {
                            deNoEditMode.setValue("Precedente");
                            break;
                        }
                        case SCORREVOLE: {
                            deNoEditMode.setValue("Scorrevole");
                        }
                    }
                }
            } else {
                de.setSelectedAsNull();
                de.setValue(null);
            }
        }
    }

    private void addToDatiPolicyValue(List<DataElement> dati, ConfigurazionePolicy policy, boolean editMode, boolean editOnlyValueMode) throws Exception {
        DataElement de;
        TipoRisorsa tipoRisorsa = TipoRisorsa.toEnumConstant((String)policy.getRisorsa(), (boolean)true);
        if (TipoRisorsa.OCCUPAZIONE_BANDA.equals((Object)tipoRisorsa)) {
            de = new DataElement();
            de.setName("CTPolicySogliaValoreTipoBanda");
            de.setLabel("Tipo Banda");
            if (editMode) {
                de.setType(DataElementType.SELECT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValues(ConfigurazioneCostanti.TIPI_BANDA);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_BANDA);
            if (policy.getValoreTipoBanda() != null) {
                de.setSelected(policy.getValoreTipoBanda().getValue());
                de.setValue(policy.getValoreTipoBanda().getValue());
            }
            de.setPostBack_viaPOST(true);
            dati.add(de);
            if (!editMode) {
                de = new DataElement();
                de.setName("CTPolicySogliaValoreTipoBanda_NoEdit");
                de.setLabel("Tipo Banda");
                switch (policy.getValoreTipoBanda()) {
                    case COMPLESSIVA: {
                        de.setValue("Banda Complessiva");
                        break;
                    }
                    case INTERNA: {
                        de.setValue("Banda Interna");
                        break;
                    }
                    case ESTERNA: {
                        de.setValue("Banda Esterna");
                    }
                }
                de.setType(DataElementType.TEXT);
                dati.add(de);
            }
        }
        if (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa) || TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals((Object)tipoRisorsa)) {
            de = new DataElement();
            de.setName("CTPolicySogliaValoreTipoLatenza");
            if (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa)) {
                de.setLabel("Tipo Latenza");
            } else {
                de.setLabel("Tipo Latenza");
            }
            if (editMode) {
                de.setType(DataElementType.SELECT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValues(ConfigurazioneCostanti.TIPI_LATENZA);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_LATENZA);
            if (policy.getValoreTipoLatenza() != null) {
                de.setSelected(policy.getValoreTipoLatenza().getValue());
                de.setValue(policy.getValoreTipoLatenza().getValue());
            }
            de.setPostBack_viaPOST(true);
            dati.add(de);
            if (!editMode) {
                de = new DataElement();
                de.setName("CTPolicySogliaValoreTipoLatenza_NoEdit");
                if (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa)) {
                    de.setLabel("Tipo Latenza");
                } else {
                    de.setLabel("Tipo Latenza");
                }
                switch (policy.getValoreTipoLatenza()) {
                    case TOTALE: {
                        de.setValue("Latenza Totale");
                        break;
                    }
                    case SERVIZIO: {
                        de.setValue("Latenza Servizio");
                        break;
                    }
                }
                de.setType(DataElementType.TEXT);
                dati.add(de);
            }
        }
        if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
            de = new DataElement();
            de.setName("CTPolicySogliaValore2");
            de.setLabel("Dimensione Richiesta");
            if (editMode || editOnlyValueMode) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.TEXT);
            }
            if (policy.getValore2() != null) {
                de.setValue("" + policy.getValore2());
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicySogliaValore");
        switch (tipoRisorsa) {
            case NUMERO_RICHIESTE: {
                de.setLabel("Num. Massimo Richieste");
                break;
            }
            case DIMENSIONE_MASSIMA_MESSAGGIO: {
                de.setLabel("Dimensione Risposta");
                de.setNote("Indicazione della dimensione massima in 'kb' di una richiesta e di una risposta");
                break;
            }
            case OCCUPAZIONE_BANDA: {
                de.setLabel("Occupazione Massima");
                de.setNote("Indicazione della banda occupata in 'kb'");
                break;
            }
            case TEMPO_MEDIO_RISPOSTA: {
                de.setLabel("Tempo Medio di Risposta");
                de.setNote("Indicazione (in millisecondi) sul tempo medio di risposta che deve essere inferiore al valore fornito");
                break;
            }
            case TEMPO_COMPLESSIVO_RISPOSTA: {
                de.setLabel("Tempo Risposta");
                de.setNote("Indicazione (in secondi) sul tempo di risposta complessivo che deve essere inferiore al valore fornito");
                break;
            }
            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                de.setLabel("Num. Massimo Richieste");
                de.setNote("Vengono conteggiate solamente le transazioni completate con successo");
                break;
            }
            case NUMERO_RICHIESTE_FALLITE: {
                de.setLabel("Num. Massimo Richieste");
                de.setNote("Vengono conteggiate solamente le transazioni fallite");
                break;
            }
            case NUMERO_FAULT_APPLICATIVI: {
                de.setLabel("Num. Massimo Richieste");
                de.setNote("Vengono conteggiate solamente le transazioni che veicolano un fault applicativo");
                break;
            }
            case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                de.setLabel("Num. Massimo Richieste");
                de.setNote("Vengono conteggiate solamente le transazioni fallite o che veicolano un fault applicativo");
                break;
            }
            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                de.setLabel("Num. Massimo Richieste");
                de.setNote("Vengono conteggiate solamente le transazioni completate con successo o che veicolano un fault applicativo");
            }
        }
        if (editMode || editOnlyValueMode) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        if (policy.getValore() != null) {
            de.setValue("" + policy.getValore());
        }
        dati.add(de);
        if (!editMode) {
            if (editOnlyValueMode) {
                de = new DataElement();
                de.setName("CTPolicySogliaValoreModificatoConIstanzeAttive");
                de.setType(DataElementType.HIDDEN);
                de.setValue("yes");
                dati.add(de);
            } else {
                de = new DataElement();
                de.setName("CTPolicySogliaValoreRichiestaModificaConIstanzeAttive");
                de.setLabel("Modifica Valore di Soglia");
                de.setValue("Modifica Valore di Soglia");
                de.setUrl("configurazioneControlloTrafficoConfigurazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicySogliaValoreRichiestaModificaConIstanzeAttive", "yes")});
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
        }
    }

    public void addConfigurazionePolicyApplicabilitaToDati(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazionePolicy policy, ConfigurazioneControlloTraffico controlloTraffico, boolean editMode) throws Exception {
        if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals(policy.getRisorsa())) {
            return;
        }
        DataElement de = new DataElement();
        de.setLabel("Applicabilit\u00e0");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaTipo");
        de.setLabel("Condizionale");
        boolean condizionata = TipoApplicabilita.CONDIZIONALE.equals((Object)policy.getTipoApplicabilita());
        if (editMode) {
            de.setType(DataElementType.CHECKBOX);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setSelected(condizionata);
        de.setValue("" + condizionata);
        de.setPostBack_viaPOST(true);
        dati.add(de);
        if (!editMode) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaTipo_NoEdit");
            de.setLabel("Condizionale");
            if (condizionata) {
                de.setValue("Abilitato");
            } else {
                de.setValue("Disabilitato");
            }
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaConCongestione");
        de.setLabelRight("Applicata solo in presenza di Congestione del Traffico");
        if (condizionata) {
            if (editMode) {
                de.setType(DataElementType.CHECKBOX);
                DataElementInfo dInfoDescrizioneCongestione = new DataElementInfo("Congestione del Traffico");
                dInfoDescrizioneCongestione.setHeaderBody(this.replaceToHtmlSeparator(this.getApplicabilitaConCongestione(controlloTraffico)));
                de.setInfo(dInfoDescrizioneCongestione);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setApplicabilitaConCongestione(false);
        }
        de.setSelected(policy.isApplicabilitaConCongestione());
        de.setValue("" + policy.isApplicabilitaConCongestione());
        dati.add(de);
        if (!editMode && condizionata && policy.isApplicabilitaConCongestione()) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaConCongestione_NoEdit");
            de.setValue("Applicata solo in presenza di Congestione del Traffico");
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaConDegradoPrestazionale");
        de.setLabelRight("Applicata solo in presenza di Degrado Prestazionale");
        if (condizionata && !TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals(policy.getRisorsa()) && !TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals(policy.getRisorsa())) {
            if (editMode) {
                de.setType(DataElementType.CHECKBOX);
                DataElementInfo dInfoDescrizioneDegrado = new DataElementInfo("Degrado Prestazionale");
                dInfoDescrizioneDegrado.setHeaderBody(this.replaceToHtmlSeparator(this.getApplicabilitaDegradoPrestazionale()));
                de.setInfo(dInfoDescrizioneDegrado);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setApplicabilitaDegradoPrestazionale(false);
        }
        de.setSelected(policy.isApplicabilitaDegradoPrestazionale());
        de.setValue("" + policy.isApplicabilitaDegradoPrestazionale());
        dati.add(de);
        if (!editMode && condizionata && !TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals(policy.getRisorsa()) && !TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals(policy.getRisorsa()) && policy.isApplicabilitaDegradoPrestazionale()) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaConDegradoPrestazionale_NoEdit");
            de.setValue("Applicata solo in presenza di Degrado Prestazionale");
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaStatoAllarme");
        de.setLabelRight("Applicata solo in presenza di Condizioni di Allarme");
        if (condizionata && this.confCore.isConfigurazioneAllarmiEnabled()) {
            if (editMode) {
                de.setType(DataElementType.CHECKBOX);
                DataElementInfo dInfoDescrizioneAllarmi = new DataElementInfo("Condizioni di Allarme");
                dInfoDescrizioneAllarmi.setHeaderBody(this.replaceToHtmlSeparator(this.getApplicabilitaAllarmi()));
                de.setInfo(dInfoDescrizioneAllarmi);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setApplicabilitaStatoAllarme(false);
        }
        de.setSelected(policy.isApplicabilitaStatoAllarme());
        de.setValue("" + policy.isApplicabilitaStatoAllarme());
        dati.add(de);
        if (!editMode && condizionata && this.confCore.isConfigurazioneAllarmiEnabled() && policy.isApplicabilitaStatoAllarme()) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaStatoAllarme_NoEdit");
            de.setValue("Applicata solo in presenza di Condizioni di Allarme");
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        this.addToApplicabilitaDegradoPrestazionale(dati, tipoOperazione, policy, editMode);
        this.addToApplicabilitaStatoAllarme(dati, tipoOperazione, policy, editMode);
    }

    private void addToApplicabilitaConCongestione(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazionePolicy policy, ConfigurazioneControlloTraffico controlloTraffico, boolean editMode) throws Exception {
        if (policy.isApplicabilitaConCongestione()) {
            DataElement de = new DataElement();
            de.setLabel("Congestione del Traffico");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaConCongestioneNote");
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setRows(4);
            de.setCols(55);
            de.setValue(this.getApplicabilitaConCongestione(controlloTraffico));
            dati.add(de);
        }
    }

    private String getApplicabilitaConCongestione(ConfigurazioneControlloTraffico controlloTraffico) {
        String result = null;
        if (controlloTraffico.isControlloCongestioneEnabled()) {
            Integer soglia = controlloTraffico.getControlloCongestioneThreshold();
            Long numeroThreadCongestionamento = null;
            Long numeroThreadComplessivi = controlloTraffico.getControlloMaxThreadsSoglia();
            double numD = numeroThreadComplessivi.doubleValue();
            double totale = 100.0;
            double sogliaD = soglia.doubleValue();
            Double numeroThreadCongestionamentoD = numD / totale * sogliaD;
            numeroThreadCongestionamento = numeroThreadCongestionamentoD.longValue();
            result = "La policy viene applicata se GovWay \u00e8 congestionato dalle richieste.\nI Livelli di soglia sono indicati nella configurazione di Controllo del Traffico.\nGovWay viene considerato congestionato se vengono superate le _NUMERO_RICHIESTE_PER_CONGESTIONE_ richieste simultanee.".replace("_NUMERO_RICHIESTE_PER_CONGESTIONE_", "" + numeroThreadCongestionamento);
        } else {
            result = "La policy viene applicata se GovWay \u00e8 congestionato dalle richieste.\nI Livelli di soglia sono indicati nella configurazione di Controllo del Traffico.\nAttualmente non risulta attivo il Controllo della Congestione.";
        }
        return result;
    }

    private void addToApplicabilitaDegradoPrestazionale(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazionePolicy policy, boolean editMode) throws Exception {
        DataElement de;
        if (policy.isApplicabilitaDegradoPrestazionale()) {
            de = new DataElement();
            de.setLabel("Degrado Prestazionale");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaConDegradoPrestazionaleTipoControllo");
        de.setLabel("Modalit\u00e0 di Controllo");
        if (policy.isApplicabilitaDegradoPrestazionale()) {
            de.setType(DataElementType.SELECT);
            de.setValues(ConfigurazioneCostanti.TIPI_CONTROLLO);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_CONTROLLO);
            if (policy.getDegradoAvgTimeModalitaControllo() == null) {
                policy.setDegradoAvgTimeModalitaControllo(ConfigurazioneCostanti.TIPO_CONTROLLO_PERIODO_DEFAULT);
            }
            de.setSelected(policy.getDegradoAvgTimeModalitaControllo().getValue());
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setDegradoAvgTimeModalitaControllo(null);
        }
        if (policy.getDegradoAvgTimeModalitaControllo() != null) {
            de.setValue(policy.getDegradoAvgTimeModalitaControllo().getValue());
        } else {
            de.setValue(null);
        }
        if (!editMode) {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
        if (!editMode && policy.isApplicabilitaDegradoPrestazionale()) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaConDegradoPrestazionaleTipoControllo_NoEdit");
            de.setLabel("Modalit\u00e0 di Controllo");
            switch (policy.getDegradoAvgTimeModalitaControllo()) {
                case REALTIME: {
                    de.setValue("Realtime");
                    break;
                }
                case STATISTIC: {
                    de.setValue("Statistica");
                }
            }
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaConDegradoPrestazionaleTipoLatenza");
        de.setLabel("Tempo Medio Risposta");
        if (policy.isApplicabilitaDegradoPrestazionale()) {
            de.setType(DataElementType.SELECT);
            de.setValues(ConfigurazioneCostanti.TIPI_LATENZA);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_LATENZA);
            if (policy.getDegradoAvgTimeTipoLatenza() == null) {
                policy.setDegradoAvgTimeTipoLatenza(ConfigurazioneCostanti.TIPO_LATENZA_DEFAULT);
            }
            de.setSelected(policy.getDegradoAvgTimeTipoLatenza().getValue());
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setDegradoAvgTimeTipoLatenza(null);
        }
        if (policy.getDegradoAvgTimeTipoLatenza() != null) {
            de.setValue(policy.getDegradoAvgTimeTipoLatenza().getValue());
        } else {
            de.setValue(null);
        }
        if (!editMode) {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
        if (!editMode && policy.isApplicabilitaDegradoPrestazionale()) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaConDegradoPrestazionaleTipoLatenza_NoEdit");
            de.setLabel("Tempo Medio Risposta");
            switch (policy.getDegradoAvgTimeTipoLatenza()) {
                case TOTALE: {
                    de.setValue("Latenza Totale");
                    break;
                }
                case SERVIZIO: {
                    de.setValue("Latenza Servizio");
                }
            }
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        if (policy.isApplicabilitaDegradoPrestazionale()) {
            de = new DataElement();
            de.setLabel("Intervallo Osservazione");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaConDegradoPrestazionaleTipoPeriodo");
        de.setLabel("Frequenza");
        if (policy.isApplicabilitaDegradoPrestazionale()) {
            de.setType(DataElementType.SELECT);
            if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo())) {
                de.setValues(ConfigurazioneCostanti.TIPI_INTERVALLO_OSSERVAZIONE_REALTIME);
                de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_INTERVALLO_OSSERVAZIONE_REALTIME);
                if (policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime() == null) {
                    policy.setDegradoAvgTimeTipoIntervalloOsservazioneRealtime(ConfigurazioneCostanti.TIPO_PERIODO_REALTIME_DEFAULT);
                }
                de.setSelected(policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime().getValue());
            } else {
                de.setValues(ConfigurazioneCostanti.TIPI_INTERVALLO_OSSERVAZIONE_STATISTICO);
                de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_TIPI_INTERVALLO_OSSERVAZIONE_STATISTICO);
                if (policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico() == null) {
                    policy.setDegradoAvgTimeTipoIntervalloOsservazioneStatistico(ConfigurazioneCostanti.TIPO_PERIODO_STATISTICO_DEFAULT);
                }
                de.setSelected(policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico().getValue());
            }
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setDegradoAvgTimeTipoIntervalloOsservazioneRealtime(null);
            policy.setDegradoAvgTimeTipoIntervalloOsservazioneStatistico(null);
        }
        if (policy.getDegradoAvgTimeModalitaControllo() != null) {
            if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo())) {
                if (policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime() != null) {
                    de.setValue(policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime().getValue());
                } else {
                    de.setValue(null);
                }
            } else if (policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico() != null) {
                de.setValue(policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico().getValue());
            } else {
                de.setValue(null);
            }
        } else {
            de.setValue(null);
        }
        if (!editMode) {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
        if (!editMode && policy.isApplicabilitaDegradoPrestazionale()) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaConDegradoPrestazionaleTipoPeriodo_NoEdit");
            de.setLabel("Frequenza");
            if (TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo())) {
                switch (policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime()) {
                    case GIORNALIERO: {
                        de.setValue("Giornaliero");
                        break;
                    }
                    case ORARIO: {
                        de.setValue("Orario");
                        break;
                    }
                    case MINUTI: {
                        de.setValue("Minuti");
                        break;
                    }
                    case SECONDI: {
                        de.setValue("Secondi");
                    }
                }
            } else {
                switch (policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico()) {
                    case MENSILE: {
                        de.setValue("Mensile");
                        break;
                    }
                    case SETTIMANALE: {
                        de.setValue("Settimanale");
                        break;
                    }
                    case GIORNALIERO: {
                        de.setValue("Giornaliero");
                        break;
                    }
                    case ORARIO: {
                        de.setValue("Orario");
                    }
                }
            }
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        String labelIntervallo = null;
        labelIntervallo = TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo()) ? this.getLabel(policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime()) : this.getLabel(policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico());
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaConDegradoPrestazionalePeriodo");
        de.setLabel(labelIntervallo);
        if (policy.isApplicabilitaDegradoPrestazionale()) {
            if (editMode) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.TEXT);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setDegradoAvgTimeIntervalloOsservazione(null);
        }
        if (policy.getDegradoAvgTimeIntervalloOsservazione() != null) {
            de.setValue("" + policy.getDegradoAvgTimeIntervalloOsservazione());
        }
        dati.add(de);
        DataElement deNoEditMode = null;
        if (!editMode) {
            deNoEditMode = new DataElement();
            deNoEditMode.setName("CTPolicyApplicabilitaConDegradoPrestazionaleFinestraPeriodo_NoEdit");
            deNoEditMode.setLabel("Finestra");
            deNoEditMode.setType(DataElementType.TEXT);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaConDegradoPrestazionaleFinestraPeriodo");
        de.setLabel("Finestra");
        if (editMode) {
            de.setType(DataElementType.SELECT);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        this.setValueFinestra(de, deNoEditMode, policy.getDegradoAvgTimeModalitaControllo(), policy.getDegradoAvgTimeFinestraOsservazione(), policy.getRisorsa(), true);
        if (!editMode) {
            de.setRequired(false);
        }
        if (!policy.isApplicabilitaDegradoPrestazionale()) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setPostBack_viaPOST(true);
        }
        dati.add(de);
        if (!editMode && policy.isApplicabilitaDegradoPrestazionale()) {
            dati.add(deNoEditMode);
        }
    }

    private String getApplicabilitaDegradoPrestazionale() {
        String result = "La policy viene applicata se il tempo medio di risposta risulta superiore ai livelli di soglia impostati.\nIl tempo medio di risposta atteso di default \u00e8 indicato nella configurazione di Controllo del Traffico.\nPer una API \u00e8 possibile ridefinire il tempo di risposta agendo sullo specifico connettore";
        return result;
    }

    private void addToApplicabilitaStatoAllarme(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazionePolicy policy, boolean editMode) throws Exception {
        DataElement de;
        if (policy.isApplicabilitaStatoAllarme()) {
            DataElement de2 = new DataElement();
            de2.setLabel("Stato Allarme");
            de2.setType(DataElementType.TITLE);
            dati.add(de2);
        }
        ArrayList<String> allarmi_id = null;
        ArrayList<String> allarmi_alias = null;
        if (policy.isApplicabilitaStatoAllarme()) {
            try {
                List<Allarme> listAllarmiGlobali = this.confCore.allarmiSenzaPluginList(new ConsoleSearch(true), null, null);
                if (listAllarmiGlobali != null && !listAllarmiGlobali.isEmpty()) {
                    allarmi_id = new ArrayList();
                    allarmi_alias = new ArrayList<String>();
                    for (Allarme allarme : listAllarmiGlobali) {
                        allarmi_id.add(allarme.getNome());
                        allarmi_alias.add(allarme.getAlias());
                    }
                }
            }
            catch (Exception eError) {
                this.logError(eError.getMessage(), eError);
            }
        }
        if (allarmi_id == null) {
            allarmi_id = new ArrayList<String>();
        }
        if (policy.isApplicabilitaStatoAllarme() && allarmi_id.size() <= 0) {
            de = new DataElement();
            de.setValue("Non risultano attivati allarmi");
            de.setType(DataElementType.NOTE);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaStatoAllarmeNome");
        de.setLabel("Nome");
        if (policy.isApplicabilitaStatoAllarme() && allarmi_id.size() > 0) {
            String[] values = null;
            String[] labels = null;
            int index = 0;
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                values = new String[allarmi_id.size()];
                labels = new String[allarmi_alias.size()];
            } else {
                values = new String[allarmi_id.size() + 1];
                labels = new String[allarmi_alias.size() + 1];
                values[0] = "-";
                labels[0] = "-";
                index = 1;
            }
            for (int i = 0; i < allarmi_id.size(); ++i) {
                values[index] = (String)allarmi_id.get(i);
                labels[index++] = (String)allarmi_alias.get(i);
            }
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(labels);
            if (policy.getAllarmeNome() != null) {
                de.setSelected(policy.getAllarmeNome());
            } else {
                de.setSelected("-");
            }
            de.setRequired(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setAllarmeNome(null);
        }
        de.setValue(policy.getAllarmeNome());
        if (!editMode) {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
        if (!editMode && policy.isApplicabilitaStatoAllarme() && allarmi_id.size() > 0) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaStatoAllarmeNome_NoEdit");
            de.setLabel("Nome");
            de.setValue(policy.getAllarmeNome());
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaStatoAllarmeNotStato");
        de.setLabel("Not");
        if (policy.isApplicabilitaStatoAllarme() && allarmi_id.size() > 0) {
            if (editMode) {
                de.setType(DataElementType.CHECKBOX);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setAllarmeNotStato(false);
        }
        de.setSelected(policy.isAllarmeNotStato());
        de.setValue("" + policy.isAllarmeNotStato());
        dati.add(de);
        if (!editMode && policy.isApplicabilitaStatoAllarme() && allarmi_id.size() > 0) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaStatoAllarmeNotStato_NoEdit");
            de.setLabel("Not");
            if (policy.isAllarmeNotStato()) {
                de.setValue("Abilitato");
            } else {
                de.setValue("Disabilitato");
            }
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("CTPolicyApplicabilitaStatoAllarmeStato");
        de.setLabel("Stato");
        if (policy.isApplicabilitaStatoAllarme() && allarmi_id.size() > 0) {
            de.setType(DataElementType.SELECT);
            de.setValues(ConfigurazioneCostanti.CONFIGURAZIONE_STATI_ALLARMI);
            de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_STATI_ALLARMI);
            if (policy.getAllarmeStato() == null) {
                policy.setAllarmeStato(ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_DEFAULT);
            }
            de.setSelected("" + policy.getAllarmeStato());
        } else {
            de.setType(DataElementType.HIDDEN);
            policy.setAllarmeStato(null);
        }
        if (policy.getAllarmeStato() != null) {
            de.setSelected("" + policy.getAllarmeStato());
        } else {
            de.setValue(null);
        }
        if (!editMode) {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
        if (!editMode && policy.isApplicabilitaStatoAllarme() && allarmi_id.size() > 0) {
            de = new DataElement();
            de.setName("CTPolicyApplicabilitaStatoAllarmeStato_NoEdit");
            de.setLabel("Stato");
            if (policy.getAllarmeStato() != null) {
                if (policy.getAllarmeStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_OK.intValue()) {
                    de.setValue("Ok");
                } else if (policy.getAllarmeStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_WARNING.intValue()) {
                    de.setValue("Warning");
                } else {
                    de.setValue("Error");
                }
            }
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
    }

    private String getApplicabilitaAllarmi() {
        String result = "La policy viene applicata se l'allarme selezionato soddisfa lo stato indicato";
        return result;
    }

    public String getLabel(TipoPeriodoRealtime tipo) {
        if (tipo == null) {
            return "Valore";
        }
        switch (tipo) {
            case SECONDI: {
                return "Secondi";
            }
            case MINUTI: {
                return "Minuti";
            }
            case ORARIO: {
                return "Ore";
            }
            case GIORNALIERO: {
                return "Giorni";
            }
        }
        return "Valore";
    }

    public String getLabel(TipoPeriodoStatistico tipo) {
        if (tipo == null) {
            return "Valore";
        }
        switch (tipo) {
            case ORARIO: {
                return "Ore";
            }
            case GIORNALIERO: {
                return "Giorni";
            }
            case SETTIMANALE: {
                return "Settimane";
            }
            case MENSILE: {
                return "Mesi";
            }
        }
        return "Valore";
    }

    public boolean configurazionePolicyCheckData(StringBuilder sbParsingError, TipoOperazione tipoOperazione, ConfigurazioneGenerale configurazioneControlloTraffico, ConfigurazionePolicy policyToCheck, String oldNomeSuggeritoPolicy, String oldDescrizioneSuggeritaPolicy, String oldPolicyId, List<AttivazionePolicy> listPolicyAttiveConStatoDisabilitato, boolean updateValueInSeguitoModificaSogliaPolicy) throws Exception {
        if (sbParsingError.length() > 0) {
            this.pd.setMessage(sbParsingError.toString());
            return false;
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            long count = 0L;
            String id = null;
            id = oldPolicyId != null ? oldPolicyId : policyToCheck.getIdPolicy();
            count = this.confCore.countInUseAttivazioni(id);
            if (count > 0L) {
                String messaggio = "Non \u00e8 possibile modificare la policy '" + id + "' essendo utilizzata in " + count + " istanze di Rate Limiting";
                boolean modificaVolutaUtente = listPolicyAttiveConStatoDisabilitato != null && !listPolicyAttiveConStatoDisabilitato.isEmpty();
                long countPolicyNonDisabilitate = this.confCore.countInUseAttivazioni(id, true);
                if (countPolicyNonDisabilitate > 0L && !modificaVolutaUtente) {
                    this.pd.setMessage(messaggio);
                    return false;
                }
            }
        }
        ConfigurazionePolicy p = null;
        try {
            p = this.confCore.getConfigurazionePolicy(policyToCheck.getIdPolicy());
        }
        catch (DriverControlStationNotFound driverControlStationNotFound) {
        }
        catch (Exception e) {
            throw e;
        }
        if (p != null && (TipoOperazione.ADD.equals((Object)tipoOperazione) || p.getId() != null && policyToCheck.getId() != null && p.getId().longValue() != policyToCheck.getId().longValue())) {
            String messaggio = "Esiste gi\u00e0 una policy con nome '" + policyToCheck.getIdPolicy() + "'";
            this.pd.setMessage(messaggio);
            return false;
        }
        return this.checkConfigurazionePolicy(configurazioneControlloTraffico, policyToCheck);
    }

    public boolean checkConfigurazionePolicy(ConfigurazioneGenerale c, ConfigurazionePolicy policy) throws Exception {
        if (policy.getIdPolicy() == null || "".equals(policy.getIdPolicy())) {
            String messaggio = "Deve essere indicato un valore in 'Nome'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (!RegularExpressionEngine.isMatch((String)policy.getIdPolicy(), (String)"^[\\-\\._A-Za-z0-9]*$")) {
            String messaggio = "Il nome indicato in 'Nome' puo' contenere solamente caratteri [A-Za-z], numeri [0-9] e i simboli '-','.' e '_'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (!this.checkLength255(policy.getIdPolicy(), "Nome")) {
            return false;
        }
        if (policy.getDescrizione() == null || "".equals(policy.getDescrizione())) {
            String messaggio = "Deve essere indicato un valore in 'Descrizione'";
            this.pd.setMessage(messaggio);
            return false;
        }
        TipoRisorsa tipoRisorsa = null;
        try {
            tipoRisorsa = TipoRisorsa.toEnumConstant((String)policy.getRisorsa(), (boolean)true);
        }
        catch (Exception e) {
            this.pd.setMessage(e.getMessage());
            return false;
        }
        String name = "Num. Massimo Richieste";
        if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
            name = "Dimensione Risposta";
        } else if (TipoRisorsa.OCCUPAZIONE_BANDA.equals((Object)tipoRisorsa)) {
            name = "Occupazione Massima";
        } else if (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa)) {
            name = "Tempo Medio di Risposta";
        } else if (TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals((Object)tipoRisorsa)) {
            name = "Tempo Risposta";
        }
        if (policy.getValore() == null) {
            String messaggio = "Deve essere indicato un valore in '" + name + "'";
            this.pd.setMessage(messaggio);
            return false;
        }
        long l = policy.getValore();
        try {
            if (l < 0L) {
                throw new DriverControlStationException("Valore non nell'intervallo");
            }
        }
        catch (Exception e) {
            String messaggio = "Il valore (" + policy.getValore() + ") indicato in '" + name + "' deve essere un numero intero maggiore o uguale a 0";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (TipoRisorsa.NUMERO_RICHIESTE.equals((Object)tipoRisorsa) && policy.isSimultanee() && c.getControlloTraffico().isControlloMaxThreadsEnabled() && l > c.getControlloTraffico().getControlloMaxThreadsSoglia()) {
            String messaggio = "Deve essere indicato un valore in '" + name + "' minore di quanto indicato nella configurazione generale alla voce 'Max Richieste Simultanee'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (!policy.isSimultanee() && !TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa) && policy.getIntervalloOsservazione() == null) {
            String labelPeriodo = null;
            labelPeriodo = TipoControlloPeriodo.REALTIME.equals((Object)policy.getModalitaControllo()) ? this.getLabel(policy.getTipoIntervalloOsservazioneRealtime()) : this.getLabel(policy.getTipoIntervalloOsservazioneStatistico());
            String messaggio = "Deve essere indicato un valore in '" + labelPeriodo + "'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
            String labelDimensione = "Dimensione Richiesta";
            if (policy.getValore2() == null) {
                String messaggio = "Deve essere indicato un valore in '" + labelDimensione + "'";
                this.pd.setMessage(messaggio);
                return false;
            }
            try {
                long i = policy.getValore2();
                if (i <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + policy.getValore2() + ") indicato in '" + labelDimensione + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                this.pd.setMessage(messaggio);
                return false;
            }
        }
        if (TipoApplicabilita.CONDIZIONALE.equals((Object)policy.getTipoApplicabilita()) && !policy.isApplicabilitaConCongestione() && !policy.isApplicabilitaDegradoPrestazionale() && !policy.isApplicabilitaStatoAllarme()) {
            String messaggio = "Deve essere selezionato almeno un criterio di applicabilit\u00e0 della Policy";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (policy.isApplicabilitaDegradoPrestazionale() && policy.getDegradoAvgTimeIntervalloOsservazione() == null) {
            String labelIntervallo = null;
            labelIntervallo = TipoControlloPeriodo.REALTIME.equals((Object)policy.getDegradoAvgTimeModalitaControllo()) ? this.getLabel(policy.getDegradoAvgTimeTipoIntervalloOsservazioneRealtime()) : this.getLabel(policy.getDegradoAvgTimeTipoIntervalloOsservazioneStatistico());
            String messaggio = "Deve essere indicato un valore in 'Degrado Prestazionale - " + labelIntervallo + "'";
            this.pd.setMessage(messaggio);
            return false;
        }
        if (policy.isApplicabilitaStatoAllarme()) {
            String messaggio;
            ArrayList<String> allarmi = null;
            try {
                List<Allarme> listAllarmiGlobali = this.confCore.allarmiSenzaPluginList(new ConsoleSearch(true), null, null);
                if (listAllarmiGlobali != null && !listAllarmiGlobali.isEmpty()) {
                    allarmi = new ArrayList<String>();
                    for (Allarme allarme : listAllarmiGlobali) {
                        allarmi.add(allarme.getNome());
                    }
                }
            }
            catch (Exception eError) {
                this.logError(eError.getMessage(), eError);
            }
            if (allarmi == null || allarmi.size() <= 0) {
                messaggio = "Non risultano attivi allarmi; disabilitare l'opzione 'Condizioni di Allarme'";
                this.pd.setMessage(messaggio);
                return false;
            }
            if (policy.getAllarmeNome() == null || "".equals(policy.getAllarmeNome()) || "-".equals(policy.getAllarmeNome())) {
                messaggio = "Selezionare uno degli allarmi indicati in 'Stato Allarme - Nome'";
                this.pd.setMessage(messaggio);
                return false;
            }
        }
        return true;
    }

    public String readDatiAttivazionePolicyFromHttpParameters(AttivazionePolicy policy, boolean first, TipoOperazione tipoOperazione, InfoPolicy infoPolicy) throws Exception {
        String alias;
        StringBuilder sbParsingError = new StringBuilder();
        String id = this.getParameter("CTPolicyId");
        if (id != null && !"".equals(id)) {
            try {
                long l = Long.parseLong(id);
                if (l <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
                policy.setId(Long.valueOf(l));
            }
            catch (Exception e) {
                String messaggio = "Il valore (" + id + ") indicato in 'CTPolicyId' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                this.logError(messaggio, e);
                this.addParsingError(sbParsingError, messaggio);
            }
        }
        if ((alias = this.getParameter("CTPolicyActiveAlias")) != null && !"".equals(alias)) {
            policy.setAlias(alias);
        } else if (!first) {
            policy.setAlias(null);
        }
        String stato = this.getParameter("CTPolicyActiveEnabled");
        if (stato != null && !"".equals(stato)) {
            policy.setEnabled("Abilitato".equalsIgnoreCase(stato) || "WarningOnly".equalsIgnoreCase(stato));
            policy.setWarningOnly("WarningOnly".equalsIgnoreCase(stato));
        } else if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            policy.setEnabled(true);
            policy.setWarningOnly(false);
        }
        String continueS = this.getParameter("CTPolictyActiveContinue");
        if (continueS != null && !"".equals(continueS)) {
            policy.setContinuaValutazione(Boolean.valueOf(continueS).booleanValue());
        } else if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            policy.setContinuaValutazione(false);
        }
        String ridefinisci = this.getParameter("CTPolicyActiveRidefinisci");
        if (!first) {
            policy.setRidefinisci(ServletUtils.isCheckBoxEnabled((String)ridefinisci));
        }
        if (infoPolicy != null) {
            TipoRisorsa tipoRisorsa = infoPolicy.getTipoRisorsa();
            String valore = this.getParameter("CTPolicyActiveValore");
            if (valore != null && !"".equals(valore)) {
                if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                    try {
                        Integer i = Integer.parseInt(valore);
                        if (i <= 0) {
                            throw new DriverControlStationException("Valore non nell'intervallo");
                        }
                        policy.setValore(Long.valueOf(i.intValue()));
                    }
                    catch (Exception e) {
                        label = "Dimensione Risposta";
                        messaggio = "Il valore (" + valore + ") indicato in '" + label + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                        this.logError(messaggio, e);
                        this.addParsingError(sbParsingError, messaggio);
                    }
                } else {
                    try {
                        long l = Long.parseLong(valore);
                        if (l <= 0L) {
                            throw new DriverControlStationException("Valore non nell'intervallo");
                        }
                        policy.setValore(Long.valueOf(l));
                    }
                    catch (Exception e) {
                        label = null;
                        label = TipoRisorsa.NUMERO_RICHIESTE.equals((Object)tipoRisorsa) ? "Num. Massimo Richieste" : (TipoRisorsa.OCCUPAZIONE_BANDA.equals((Object)tipoRisorsa) ? "Occupazione Massima" : (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa) ? "Tempo Medio di Risposta" : "Tempo Risposta"));
                        messaggio = "Il valore (" + valore + ") indicato in '" + label + "' deve essere un numero intero maggiore di 0 e minore di 9223372036854775807";
                        this.logError(messaggio, e);
                        this.addParsingError(sbParsingError, messaggio);
                    }
                }
            } else if (!first) {
                policy.setValore(null);
            }
            if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                String valore2 = this.getParameter("CTPolicyActiveValore2");
                if (valore2 != null && !"".equals(valore2)) {
                    try {
                        Integer i = Integer.parseInt(valore2);
                        if (i <= 0) {
                            throw new DriverControlStationException("Valore non nell'intervallo");
                        }
                        policy.setValore2(Long.valueOf(i.intValue()));
                    }
                    catch (Exception e) {
                        String label = "Dimensione Richiesta";
                        String messaggio = "Il valore (" + valore + ") indicato in '" + label + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                        this.logError(messaggio, e);
                        this.addParsingError(sbParsingError, messaggio);
                    }
                } else if (!first) {
                    policy.setValore2(null);
                }
            }
        } else {
            policy.setValore(null);
            policy.setValore2(null);
        }
        String errorMsgDatiAttivazione = this.readDatiAttivazioneFiltroFromHttpParameters(policy, first, infoPolicy);
        if (errorMsgDatiAttivazione != null) {
            this.addParsingError(sbParsingError, errorMsgDatiAttivazione);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readDatiAttivazioneFiltroFromHttpParameters(AttivazionePolicy policy, boolean first, InfoPolicy infoPolicy) throws Exception {
        String erogatore;
        StringBuilder sbParsingError = new StringBuilder();
        String stato = this.getParameter("CTPolicyActiveFiltroEnabled");
        if (stato != null && !"".equals(stato)) {
            policy.getFiltro().setEnabled(ServletUtils.isCheckBoxEnabled((String)stato));
        }
        if (policy.getFiltro().isEnabled()) {
            String protocollo;
            String ruoloPdD = this.getParameter("CTPolicyActiveFiltroRuoloPdd");
            if (ruoloPdD != null && !"".equals(ruoloPdD)) {
                try {
                    policy.getFiltro().setRuoloPorta(RuoloPolicy.toEnumConstant((String)ruoloPdD, (boolean)true));
                }
                catch (Exception e) {
                    String messaggio = "Il valore (" + ruoloPdD + ") indicato in 'Tipologia' non \u00e8 tra i ruoli gestiti";
                    this.logError(messaggio, e);
                    this.addParsingError(sbParsingError, messaggio);
                }
            }
            if ((protocollo = this.getParameter("CTPolicyActiveFiltroRuoloProtocollo")) != null && !"".equals(protocollo) && !"-*-".equals(protocollo)) {
                policy.getFiltro().setProtocollo(protocollo);
            } else if (!first) {
                policy.getFiltro().setProtocollo(null);
            }
            String ruoloErogatore = this.getParameter("CTPolicyActiveFiltroRuoloErogatore");
            if (ruoloErogatore != null && !"".equals(ruoloErogatore) && !"-*-".equals(ruoloErogatore)) {
                policy.getFiltro().setRuoloErogatore(ruoloErogatore);
            } else if (!first) {
                policy.getFiltro().setRuoloErogatore(null);
            }
            erogatore = this.getParameter("CTPolicyActiveFiltroErogatore");
            boolean erogatoreSelected = false;
            if (erogatore != null && !"".equals(erogatore) && !"-*-".equals(erogatore) && erogatore.contains("/")) {
                String[] tmp = erogatore.split("/");
                policy.getFiltro().setTipoErogatore(tmp[0]);
                policy.getFiltro().setNomeErogatore(tmp[1]);
                erogatoreSelected = true;
            } else if (!first) {
                policy.getFiltro().setTipoErogatore(null);
                policy.getFiltro().setNomeErogatore(null);
            }
            String servizioApplicativoErogatore = this.getParameter("CTPolicyActiveFiltroSAErogatore");
            if (servizioApplicativoErogatore != null && !"".equals(servizioApplicativoErogatore) && !"-*-".equals(servizioApplicativoErogatore)) {
                policy.getFiltro().setServizioApplicativoErogatore(servizioApplicativoErogatore);
            } else if (!first) {
                policy.getFiltro().setServizioApplicativoErogatore(null);
            }
            String tag = this.getParameter("CTPolicyActiveFiltroTag");
            if (tag != null && !"".equals(tag) && !"-*-".equals(tag)) {
                policy.getFiltro().setTag(tag);
            } else if (!first) {
                policy.getFiltro().setTag(null);
            }
            String servizio = this.getParameter("CTPolicyActiveFiltroServizio");
            if (servizio != null && !"".equals(servizio) && !"-*-".equals(servizio) && servizio.contains("/")) {
                String[] tmp = servizio.split("/");
                policy.getFiltro().setTipoServizio(tmp[0]);
                policy.getFiltro().setNomeServizio(tmp[1]);
                policy.getFiltro().setVersioneServizio(Integer.valueOf(Integer.parseInt(tmp[2])));
                if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore()) {
                    policy.getFiltro().setTipoErogatore(tmp[3]);
                    policy.getFiltro().setNomeErogatore(tmp[4]);
                }
            } else if (!first) {
                policy.getFiltro().setTipoServizio(null);
                policy.getFiltro().setNomeServizio(null);
                policy.getFiltro().setVersioneServizio(null);
                if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore() && !erogatoreSelected) {
                    policy.getFiltro().setTipoErogatore(null);
                    policy.getFiltro().setNomeErogatore(null);
                }
            }
            String[] azione = this.getParameterValues("CTPolicyActiveFiltroAzione");
            if (azione != null && azione.length > 0) {
                StringBuilder bf = new StringBuilder();
                for (String az : azione) {
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(az);
                }
                policy.getFiltro().setAzione(bf.toString());
            } else if (!first) {
                policy.getFiltro().setAzione(null);
            }
            String ruoloFruitore = this.getParameter("CTPolicyActiveFiltroRuoloFruitore");
            if (ruoloFruitore != null && !"".equals(ruoloFruitore) && !"-*-".equals(ruoloFruitore)) {
                policy.getFiltro().setRuoloFruitore(ruoloFruitore);
            } else if (!first) {
                policy.getFiltro().setRuoloFruitore(null);
            }
            String fruitore = this.getParameter("CTPolicyActiveFiltroFruitore");
            if (fruitore != null && !"".equals(fruitore) && !"-*-".equals(fruitore) && fruitore.contains("/")) {
                String[] tmp = fruitore.split("/");
                policy.getFiltro().setTipoFruitore(tmp[0]);
                policy.getFiltro().setNomeFruitore(tmp[1]);
            } else if (!first) {
                policy.getFiltro().setTipoFruitore(null);
                policy.getFiltro().setNomeFruitore(null);
            }
            String servizioApplicativoFruitore = this.getParameter("CTPolicyActiveFiltroSAFruitore");
            if (servizioApplicativoFruitore != null && !"".equals(servizioApplicativoFruitore) && !"-*-".equals(servizioApplicativoFruitore)) {
                policy.getFiltro().setServizioApplicativoFruitore(servizioApplicativoFruitore);
            } else if (!first) {
                policy.getFiltro().setServizioApplicativoFruitore(null);
            }
            String tokenClaims = this.getParameter("CTPolicyActiveFiltroTokenClaims");
            if (tokenClaims != null && !"".equals(tokenClaims) && !"-*-".equals(tokenClaims)) {
                policy.getFiltro().setTokenClaims(tokenClaims);
            } else if (!first) {
                policy.getFiltro().setTokenClaims(null);
            }
            String perChiave = this.getParameter("CTPolicyActiveFiltroPerChiaveEnabled");
            if (!first) {
                policy.getFiltro().setInformazioneApplicativaEnabled(ServletUtils.isCheckBoxEnabled((String)perChiave));
            }
            if (policy.getFiltro().isInformazioneApplicativaEnabled()) {
                String perChiaveTipo = this.getParameter("CTPolicyActiveFiltroPerChiaveTipo");
                if (perChiaveTipo != null && !"".equals(perChiaveTipo)) {
                    policy.getFiltro().setInformazioneApplicativaTipo(perChiaveTipo);
                } else if (!first) {
                    policy.getFiltro().setInformazioneApplicativaTipo(ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_FILTRO_PER_CHIAVE_TIPO_DEFAULT);
                }
                String perChiaveNome = this.getParameter("CTPolicyActiveFiltroPerChiaveNome");
                if (perChiaveNome != null && !"".equals(perChiaveNome)) {
                    policy.getFiltro().setInformazioneApplicativaNome(perChiaveNome);
                } else if (!first) {
                    policy.getFiltro().setInformazioneApplicativaNome(null);
                }
                String perChiaveValore = this.getParameter("CTPolicyActiveFiltroPerChiaveValore");
                if (perChiaveValore != null && !"".equals(perChiaveValore)) {
                    policy.getFiltro().setInformazioneApplicativaValore(StringEscapeUtils.unescapeHtml4((String)perChiaveValore));
                } else if (!first) {
                    policy.getFiltro().setInformazioneApplicativaValore(null);
                }
            } else {
                policy.getFiltro().setInformazioneApplicativaTipo(null);
                policy.getFiltro().setInformazioneApplicativaNome(null);
                policy.getFiltro().setInformazioneApplicativaValore(null);
            }
        } else {
            policy.getFiltro().setRuoloPorta(RuoloPolicy.ENTRAMBI);
            policy.getFiltro().setTipoFruitore(null);
            policy.getFiltro().setNomeFruitore(null);
            policy.getFiltro().setServizioApplicativoFruitore(null);
            policy.getFiltro().setTipoErogatore(null);
            policy.getFiltro().setNomeErogatore(null);
            policy.getFiltro().setServizioApplicativoErogatore(null);
            policy.getFiltro().setTipoServizio(null);
            policy.getFiltro().setNomeServizio(null);
            policy.getFiltro().setAzione(null);
            policy.getFiltro().setTokenClaims(null);
            policy.getFiltro().setInformazioneApplicativaEnabled(false);
            policy.getFiltro().setInformazioneApplicativaTipo(null);
            policy.getFiltro().setInformazioneApplicativaNome(null);
            policy.getFiltro().setInformazioneApplicativaValore(null);
        }
        String statoGroupBy = this.getParameter("CTPolicyActiveGroupByEnabled");
        if (statoGroupBy != null && !"".equals(statoGroupBy)) {
            policy.getGroupBy().setEnabled("Raggruppamento Per".equals(statoGroupBy) || ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(statoGroupBy));
        }
        if (policy.getGroupBy().isEnabled()) {
            String ruoloPdD = this.getParameter("CTPolicyActiveGroupByRuoloPdd");
            if (!first) {
                policy.getGroupBy().setRuoloPorta(ServletUtils.isCheckBoxEnabled((String)ruoloPdD));
            }
            String protocollo = this.getParameter("CTPolicyActiveGroupByRuoloProtocollo");
            if (!first) {
                policy.getGroupBy().setProtocollo(ServletUtils.isCheckBoxEnabled((String)protocollo));
            }
            erogatore = this.getParameter("CTPolicyActiveGroupByErogatore");
            if (!first) {
                policy.getGroupBy().setErogatore(ServletUtils.isCheckBoxEnabled((String)erogatore));
            }
            String servizioApplicativoErogatore = this.getParameter("CTPolicyActiveGroupBySAErogatore");
            if (!first) {
                policy.getGroupBy().setServizioApplicativoErogatore(ServletUtils.isCheckBoxEnabled((String)servizioApplicativoErogatore));
            }
            String servizio = this.getParameter("CTPolicyActiveGroupByServizio");
            if (!first) {
                policy.getGroupBy().setServizio(ServletUtils.isCheckBoxEnabled((String)servizio));
                policy.getGroupBy().setErogatore(ServletUtils.isCheckBoxEnabled((String)servizio));
            }
            String azione = this.getParameter("CTPolicyActiveGroupByAzione");
            if (!first) {
                policy.getGroupBy().setAzione(ServletUtils.isCheckBoxEnabled((String)azione));
            }
            String fruitore = this.getParameter("CTPolicyActiveGroupByFruitore");
            if (!first) {
                policy.getGroupBy().setFruitore(ServletUtils.isCheckBoxEnabled((String)fruitore));
            }
            String servizioApplicativoFruitore = this.getParameter("CTPolicyActiveGroupBySAFruitore");
            if (!first) {
                policy.getGroupBy().setServizioApplicativoFruitore(ServletUtils.isCheckBoxEnabled((String)servizioApplicativoFruitore));
            }
            String richiedente = this.getParameter("CTPolicyActiveGroupByRichiedente");
            if (!first) {
                policy.getGroupBy().setServizioApplicativoFruitore(ServletUtils.isCheckBoxEnabled((String)richiedente));
                policy.getGroupBy().setFruitore(ServletUtils.isCheckBoxEnabled((String)richiedente));
                policy.getGroupBy().setIdentificativoAutenticato(ServletUtils.isCheckBoxEnabled((String)richiedente));
            }
            String token = this.getParameter("CTPolicyActiveGroupByToken");
            if (!first) {
                if (ServletUtils.isCheckBoxEnabled((String)token)) {
                    String[] tokenSelezionati = this.getParameterValues("CTPolicyActiveGroupByTokenClaims");
                    if (tokenSelezionati != null && tokenSelezionati.length > 0) {
                        StringBuilder bf = new StringBuilder();
                        for (int i = 0; i < tokenSelezionati.length; ++i) {
                            TipoCredenzialeMittente tipo = TipoCredenzialeMittente.toEnumConstant((String)tokenSelezionati[i], (boolean)true);
                            if (TipoCredenzialeMittente.TOKEN_ISSUER.equals((Object)tipo)) continue;
                            if (TipoCredenzialeMittente.TOKEN_SUBJECT.equals((Object)tipo)) {
                                if (!bf.toString().endsWith(",") && bf.length() > 0) {
                                    bf.append(",");
                                }
                                bf.append(TipoCredenzialeMittente.TOKEN_ISSUER.getRawValue());
                                if (i == 0) {
                                    bf.append(",");
                                }
                            }
                            if (i > 0) {
                                bf.append(",");
                            }
                            bf.append(tokenSelezionati[i]);
                        }
                        if (bf.length() > 0) {
                            policy.getGroupBy().setToken(bf.toString());
                        } else {
                            policy.getGroupBy().setToken(null);
                        }
                    } else {
                        policy.getGroupBy().setToken(null);
                    }
                } else {
                    policy.getGroupBy().setToken(null);
                }
            }
            String perChiave = this.getParameter("CTPolicyActiveGroupByPerChiaveEnabled");
            if (!first) {
                policy.getGroupBy().setInformazioneApplicativaEnabled(ServletUtils.isCheckBoxEnabled((String)perChiave));
            }
            if (policy.getGroupBy().isInformazioneApplicativaEnabled()) {
                String perChiaveTipo = this.getParameter("CTPolicyActiveGroupByPerChiaveTipo");
                if (perChiaveTipo != null && !"".equals(perChiaveTipo)) {
                    policy.getGroupBy().setInformazioneApplicativaTipo(perChiaveTipo);
                } else if (!first) {
                    policy.getGroupBy().setInformazioneApplicativaTipo(ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_GROUPBY_PER_CHIAVE_TIPO_DEFAULT);
                }
                String perChiaveNome = this.getParameter("CTPolicyActiveGroupByPerChiaveNome");
                if (perChiaveNome != null && !"".equals(perChiaveNome)) {
                    policy.getGroupBy().setInformazioneApplicativaNome(perChiaveNome);
                } else if (!first) {
                    policy.getGroupBy().setInformazioneApplicativaNome(null);
                }
            } else {
                policy.getGroupBy().setInformazioneApplicativaTipo(null);
                policy.getGroupBy().setInformazioneApplicativaNome(null);
            }
        } else {
            policy.getGroupBy().setRuoloPorta(false);
            policy.getGroupBy().setFruitore(false);
            policy.getGroupBy().setServizioApplicativoFruitore(false);
            policy.getGroupBy().setIdentificativoAutenticato(false);
            policy.getGroupBy().setToken(null);
            policy.getGroupBy().setErogatore(false);
            policy.getGroupBy().setServizioApplicativoErogatore(false);
            policy.getGroupBy().setServizio(false);
            policy.getGroupBy().setAzione(false);
            policy.getGroupBy().setInformazioneApplicativaEnabled(false);
            policy.getGroupBy().setInformazioneApplicativaTipo(null);
            policy.getGroupBy().setInformazioneApplicativaNome(null);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    private void addDataElementRisorsa(List<DataElement> dati, String parametroRisorsaNome, String valoreRisorsa, String parametroEsitiNome, String valoreEsiti, boolean editMode) {
        this.addDataElementRisorsa(dati, parametroRisorsaNome, valoreRisorsa, parametroEsitiNome, valoreEsiti, editMode, null);
    }

    private void addDataElementRisorsa(List<DataElement> dati, String parametroRisorsaNome, String valoreRisorsa, String parametroEsitiNome, String valoreEsiti, boolean editMode, PolicyGroupByActiveThreadsType type) {
        DataElement de = new DataElement();
        de.setName(parametroRisorsaNome);
        de.setLabel("Metrica");
        if (editMode) {
            if (type != null) {
                ArrayList<String> valoriFiltrati = new ArrayList<String>();
                ArrayList<String> labelFiltrate = new ArrayList<String>();
                for (int i = 0; i < CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_VALORI.length; ++i) {
                    String v = CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_VALORI[i];
                    TipoRisorsaPolicyAttiva tipoRisorsa = TipoRisorsaPolicyAttiva.toEnumConstant((String)v);
                    if (!type.isSupportedResource(tipoRisorsa)) continue;
                    valoriFiltrati.add(v);
                    labelFiltrate.add(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_LABELS[i]);
                }
                de.setValues(valoriFiltrati);
                de.setLabels(labelFiltrate);
            } else {
                de.setValues(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_VALORI);
                de.setLabels(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_LABELS);
            }
            de.setSelected(valoreRisorsa);
            de.setType(DataElementType.SELECT);
            de.setPostBack_viaPOST(true);
            de.setValue(valoreRisorsa);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(valoreRisorsa);
            dati.add(de);
            de = new DataElement();
            de.setName(parametroRisorsaNome + "__label");
            de.setLabel("Metrica");
            de.setType(DataElementType.TEXT);
            String labelRisorsaPolicyAttiva = this.getLabelTipoRisorsaPolicyAttiva(valoreRisorsa);
            de.setValue(labelRisorsaPolicyAttiva);
        }
        dati.add(de);
    }

    private TipoRisorsa getTipoRisorsa(String valoreRisorsa, String valoreEsiti) throws DriverControlStationException, NotFoundException {
        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.toEnumConstant((String)valoreRisorsa, (boolean)false);
        if (tipoRisorsaPolicyAttiva == null) {
            throw new DriverControlStationException("Risorsa '" + valoreRisorsa + "' sconosciuta");
        }
        return tipoRisorsaPolicyAttiva.getTipoRisorsa(true);
    }

    public boolean isTipoRisorsaNumeroRichiesteSimultanee(String valoreRisorsa) throws Exception {
        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.toEnumConstant((String)valoreRisorsa, (boolean)false);
        if (tipoRisorsaPolicyAttiva == null) {
            return false;
        }
        return tipoRisorsaPolicyAttiva.isRichiesteSimultanee();
    }

    public String getDataElementValueRisorsa(String tipoRisorsa, boolean simultanee) throws Exception {
        TipoRisorsa tipo = TipoRisorsa.toEnumConstant((String)tipoRisorsa);
        if (tipo == null) {
            return null;
        }
        return this.getDataElementValueRisorsa(tipo, simultanee);
    }

    public String getDataElementValueRisorsa(TipoRisorsa tipoRisorsa, boolean simultanee) throws Exception {
        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.getTipo((TipoRisorsa)tipoRisorsa, (boolean)simultanee);
        return tipoRisorsaPolicyAttiva.getValue();
    }

    public String getDataElementValueRisorsaEsiti(String tipoRisorsa) throws Exception {
        TipoRisorsa tipo = TipoRisorsa.toEnumConstant((String)tipoRisorsa);
        if (tipo == null) {
            return null;
        }
        return this.getDataElementValueRisorsaEsiti(tipo);
    }

    public String getDataElementValueRisorsaEsiti(TipoRisorsa tipoRisorsa) throws DriverControlStationException {
        return null;
    }

    public void findPolicyBuiltIn(List<InfoPolicy> policies, List<InfoPolicy> idPoliciesSoddisfanoCriteri, String modalitaRisorsa, String modalitaEsiti, boolean modalitaSimultaneeEnabled, String modalitaIntervallo, boolean modalitaCongestioneEnabled, boolean modalitaDegradoEnabled, boolean modalitaErrorRateEnabled) throws Exception {
        if (policies != null && policies.size() > 0 && modalitaRisorsa != null) {
            TipoRisorsa tipoRisorsaSelezionata = this.getTipoRisorsa(modalitaRisorsa, modalitaEsiti);
            for (InfoPolicy info : policies) {
                if (!tipoRisorsaSelezionata.equals((Object)info.getTipoRisorsa())) continue;
                if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsaSelezionata)) {
                    idPoliciesSoddisfanoCriteri.add(info);
                    continue;
                }
                if (modalitaSimultaneeEnabled && !info.isCheckRichiesteSimultanee()) continue;
                if (!modalitaSimultaneeEnabled) {
                    if (!info.isIntervalloUtilizzaRisorseRealtime()) continue;
                    if (modalitaIntervallo == null) {
                        throw new DriverControlStationException("Intervallo Temporale non definito");
                    }
                    TipoPeriodoRealtime tipo = TipoPeriodoRealtime.toEnumConstant((String)modalitaIntervallo, (boolean)true);
                    if (!tipo.equals((Object)info.getIntervalloUtilizzaRisorseRealtimeTipoPeriodo())) continue;
                }
                if ((!modalitaCongestioneEnabled ? info.isControlloCongestione() : !info.isControlloCongestione()) || (!modalitaDegradoEnabled ? info.isDegradoPrestazionaleUtilizzaRisorseStatistiche() : !info.isDegradoPrestazionaleUtilizzaRisorseStatistiche()) || (modalitaErrorRateEnabled ? !info.isErrorRate() : info.isErrorRate())) continue;
                idPoliciesSoddisfanoCriteri.add(info);
            }
        }
    }

    public void addAttivazionePolicyToDati(List<DataElement> dati, TipoOperazione tipoOperazione, AttivazionePolicy policy, String nomeSezione, List<InfoPolicy> policies, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding, String modalita, PolicyGroupByActiveThreadsType type) throws Exception {
        boolean addInfoDescrizionePolicy;
        String jmxParam;
        boolean jmx;
        org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = null;
        if (ruoloPorta != null) {
            parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyRuoloPorta", ruoloPorta.getValue());
        }
        org.openspcoop2.web.lib.mvc.Parameter parNomePorta = null;
        if (nomePorta != null) {
            parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyNomePorta", nomePorta);
        }
        org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = null;
        if (serviceBinding != null) {
            parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyServiceBinding", serviceBinding.name());
        }
        DataElement de = new DataElement();
        de.setName("CTIsPolicyAttivazioneGlobale");
        de.setValue("true");
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setName("CTPolicyRuoloPorta");
        de.setValue(ruoloPorta != null ? ruoloPorta.getValue() : null);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setName("CTPolicyNomePorta");
        de.setValue(nomePorta);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        if (serviceBinding != null) {
            de = new DataElement();
            de.setName("CTPolicyServiceBinding");
            de.setValue(serviceBinding.name());
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        boolean bl = jmx = (jmxParam = this.getParameter("CTPolicyActiveViewJmxState")) != null && "true".equals(jmxParam);
        if (!jmx) {
            de = new DataElement();
            de.setLabel(nomeSezione);
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        if (policy != null && policy.getId() != null && policy.getId() > 0L) {
            de = new DataElement();
            de.setName("CTPolicyId");
            de.setValue("" + policy.getId());
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        Object infoPolicy = null;
        ArrayList idPolicies = new ArrayList();
        String modalitaRisorsa = null;
        String modalitaEsiti = null;
        String modalitaIntervallo = null;
        String modalitaCongestione = null;
        String modalitaDegrado = null;
        String modalitaErrorRate = null;
        boolean modalitaSimultaneeEnabled = false;
        boolean modalitaCongestioneEnabled = false;
        boolean modalitaDegradoEnabled = false;
        boolean modalitaErrorRateEnabled = false;
        boolean bl2 = addInfoDescrizionePolicy = !jmx;
        if (TipoOperazione.ADD.equals((Object)tipoOperazione) && modalita == null) {
            modalita = "Scegli criteri";
        }
        if (TipoOperazione.ADD.equals((Object)tipoOperazione) && modalita != null && "Scegli criteri".equals(modalita)) {
            Object idPoliciesSoddisfanoCriteriFiltered;
            modalitaRisorsa = this.getParameter("CTPolicyActiveModeRisorsa");
            modalitaEsiti = this.getParameter("CTPolicyActiveModeEsiti");
            modalitaIntervallo = this.getParameter("CTPolicyActiveModeIntervallo");
            modalitaCongestione = this.getParameter("CTPolicyActiveModeCongestione");
            modalitaDegrado = this.getParameter("CTPolicyActiveModeDegrado");
            modalitaErrorRate = this.getParameter("CTPolicyActiveModeErrorRate");
            if (modalitaRisorsa == null) {
                modalitaRisorsa = CostantiControlStation.DEFAULT_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_RISORSA_TIPO_VALUE.getValue();
            }
            if (modalitaEsiti == null) {
                // empty if block
            }
            if (modalitaIntervallo == null) {
                modalitaIntervallo = ConfigurazioneCostanti.PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_POLICY_MODALITA_RISORSA_INTERVALLO_OSSERVAZIONE_DEFAULT;
            }
            modalitaSimultaneeEnabled = this.isTipoRisorsaNumeroRichiesteSimultanee(modalitaRisorsa);
            modalitaCongestioneEnabled = ServletUtils.isCheckBoxEnabled((String)modalitaCongestione);
            modalitaDegradoEnabled = ServletUtils.isCheckBoxEnabled((String)modalitaDegrado);
            modalitaErrorRateEnabled = ServletUtils.isCheckBoxEnabled((String)modalitaErrorRate);
            ArrayList<String> idPoliciesTmp = new ArrayList<String>();
            Object idPoliciesSoddisfanoCriteri = new ArrayList();
            this.findPolicyBuiltIn(policies, (List<InfoPolicy>)idPoliciesSoddisfanoCriteri, modalitaRisorsa, modalitaEsiti, modalitaSimultaneeEnabled, modalitaIntervallo, modalitaCongestioneEnabled, modalitaDegradoEnabled, modalitaErrorRateEnabled);
            if (type != null) {
                idPoliciesSoddisfanoCriteriFiltered = new ArrayList();
                Iterator iterator = idPoliciesSoddisfanoCriteri.iterator();
                while (iterator.hasNext()) {
                    InfoPolicy infoPolicyCheck = (InfoPolicy)iterator.next();
                    TipoRisorsaPolicyAttiva tipoRisorsa = TipoRisorsaPolicyAttiva.getTipo((TipoRisorsa)infoPolicyCheck.getTipoRisorsa(), (boolean)infoPolicyCheck.isCheckRichiesteSimultanee());
                    if (!type.isSupportedResource(tipoRisorsa)) continue;
                    idPoliciesSoddisfanoCriteriFiltered.add(infoPolicyCheck);
                }
                idPoliciesSoddisfanoCriteri = idPoliciesSoddisfanoCriteriFiltered;
            }
            if (!idPoliciesSoddisfanoCriteri.isEmpty()) {
                idPoliciesSoddisfanoCriteriFiltered = idPoliciesSoddisfanoCriteri.iterator();
                while (idPoliciesSoddisfanoCriteriFiltered.hasNext()) {
                    InfoPolicy infoPolicyCheck = (InfoPolicy)idPoliciesSoddisfanoCriteriFiltered.next();
                    idPoliciesTmp.add(infoPolicyCheck.getIdPolicy());
                    if (policy.getIdPolicy() == null || !policy.getIdPolicy().equals(infoPolicyCheck.getIdPolicy())) continue;
                    infoPolicy = infoPolicyCheck;
                }
            }
            if (idPoliciesTmp.size() <= 0) {
                if (policies == null || policies.size() <= 0) {
                    this.pd.setMessage("Non esistono policy 'Built-in'", MessageType.ERROR);
                } else {
                    this.pd.setMessage("Non esistono policy 'Built-in' che soddisfano i criteri indicati", MessageType.ERROR);
                }
            } else if (idPoliciesTmp.size() > 1) {
                idPoliciesTmp.add("-");
                idPolicies.addAll(idPoliciesTmp);
            } else {
                String idPolicy = (String)idPoliciesTmp.get(0);
                idPolicies.add(idPolicy);
                for (InfoPolicy info : policies) {
                    if (idPolicy == null || !idPolicy.equals(info.getIdPolicy())) continue;
                    infoPolicy = info;
                }
            }
        } else {
            if (type != null) {
                ArrayList<InfoPolicy> idPoliciesSoddisfanoCriteriFiltered = new ArrayList<InfoPolicy>();
                for (InfoPolicy infoPolicyCheck : policies) {
                    TipoRisorsaPolicyAttiva tipoRisorsa = TipoRisorsaPolicyAttiva.getTipo((TipoRisorsa)infoPolicyCheck.getTipoRisorsa(), (boolean)infoPolicyCheck.isCheckRichiesteSimultanee());
                    if (!type.isSupportedResource(tipoRisorsa)) continue;
                    idPoliciesSoddisfanoCriteriFiltered.add(infoPolicyCheck);
                }
                policies = idPoliciesSoddisfanoCriteriFiltered;
            }
            if (policies == null || policies.size() <= 0) {
                this.pd.setMessage("Non esistono policy definite dall'utente nel registro", MessageType.ERROR);
            } else {
                idPolicies.add("-");
                for (InfoPolicy info : policies) {
                    idPolicies.add(info.getIdPolicy());
                    if (policy.getIdPolicy() == null || !policy.getIdPolicy().equals(info.getIdPolicy())) continue;
                    infoPolicy = info;
                }
            }
        }
        if (!jmx) {
            de = new DataElement();
            de.setName("CTPolicyActiveAlias");
            de.setLabel("Nome");
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(policy.getAlias());
            de.setRequired(true);
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyActiveDescrizione");
            de.setLabel("Descrizione");
            if (infoPolicy != null) {
                if (!addInfoDescrizionePolicy) {
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setRows(6);
                    de.setCols(55);
                    de.setLabelAffiancata(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setValue(infoPolicy.getDescrizione());
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(null);
            }
            dati.add(de);
            boolean hidden = false;
            boolean policyWithWarningOnly = true;
            if (infoPolicy != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa())) {
                policyWithWarningOnly = false;
            }
            this.addToDatiDataElementStato_postBackViaPOST(dati, "CTPolicyActiveEnabled", "Stato", policy.isEnabled(), false, policyWithWarningOnly, policy.isWarningOnly(), hidden);
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && addInfoDescrizionePolicy && infoPolicy != null) {
                dInfoDescrizionePolicy = new DataElementInfo("Policy");
                dInfoDescrizionePolicy.setHeaderBody(this.replaceToHtmlSeparator(infoPolicy.getDescrizione()));
                dInfoDescrizionePolicy.setListBody(CostantiControlStation.LABEL_CONFIGURAZIONE_POLICY_STATO_VALORI);
                dati.get(dati.size() - 1).setInfo(dInfoDescrizionePolicy);
            } else {
                dInfoDescrizionePolicy = new DataElementInfo("Stato");
                dInfoDescrizionePolicy.setListBody(CostantiControlStation.LABEL_CONFIGURAZIONE_POLICY_STATO_VALORI);
                dati.get(dati.size() - 1).setInfo(dInfoDescrizionePolicy);
            }
            de = new DataElement();
            de.setName("CTPolictyActiveContinue");
            de.setLabel("Elaborazione");
            if (hidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(ConfigurazioneCostanti.PARAMETRI_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_CONTINUE);
                de.setLabels(ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_CONTINUE);
                de.setPostBack_viaPOST(true);
                de.setSelected("" + policy.isContinuaValutazione());
            }
            de.setValue("" + policy.isContinuaValutazione());
            DataElementInfo dInfoContinuePolicy = new DataElementInfo("Elaborazione");
            dInfoContinuePolicy.setListBody(ConfigurazioneCostanti.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_CONTINUE_ELEM);
            de.setInfo(dInfoContinuePolicy);
            dati.add(de);
        }
        if (!jmx && TipoOperazione.CHANGE.equals((Object)tipoOperazione) && infoPolicy != null) {
            if (infoPolicy.isBuiltIn()) {
                de = new DataElement();
                de.setLabel("Criteri");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
                String modalitaRisorsaConvertValue = this.getDataElementValueRisorsa(infoPolicy.getTipoRisorsa(), infoPolicy.isCheckRichiesteSimultanee());
                String modalitaEsitiConvertValue = this.getDataElementValueRisorsaEsiti(infoPolicy.getTipoRisorsa());
                this.addDataElementRisorsa(dati, "CTPolicyActiveModeRisorsa__label", modalitaRisorsaConvertValue, "CTPolicyActiveModeEsiti__label", modalitaEsitiConvertValue, false);
                if (!TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals(modalitaRisorsaConvertValue)) {
                    if (!infoPolicy.isCheckRichiesteSimultanee()) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveModeIntervallo__label");
                        de.setLabel("Intervallo Osservazione");
                        de.setType(DataElementType.TEXT);
                        if (infoPolicy.getIntervalloUtilizzaRisorseRealtimeTipoPeriodo() != null) {
                            String labelValue = infoPolicy.getIntervalloUtilizzaRisorseRealtimeTipoPeriodo().getValue();
                            for (int i = 0; i < ConfigurazioneCostanti.PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_POLICY_MODALITA_INTERVALLO_OSSERVAZIONE.length; ++i) {
                                if (!labelValue.equals(ConfigurazioneCostanti.PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_POLICY_MODALITA_INTERVALLO_OSSERVAZIONE[i])) continue;
                                labelValue = ConfigurazioneCostanti.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_POLICY_MODALITA_INTERVALLO_OSSERVAZIONE[i];
                                break;
                            }
                            de.setValue(labelValue);
                        }
                        dati.add(de);
                    }
                    if (infoPolicy.isControlloCongestione()) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveModeCongestione__label");
                        de.setValue("Applicata solo in presenza di Congestione del Traffico");
                        de.setType(DataElementType.TEXT);
                        dati.add(de);
                    }
                    if (infoPolicy.isDegradoPrestazione()) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveModeDegrado__label");
                        de.setValue("Applicata solo in presenza di Degrado Prestazionale");
                        de.setType(DataElementType.TEXT);
                        dati.add(de);
                    }
                }
            } else {
                de = new DataElement();
                de.setName("CTPolicyActiveId__label");
                de.setLabel("Policy");
                de.setType(DataElementType.TEXT);
                de.setValue(infoPolicy.getIdPolicy());
                dati.add(de);
            }
        }
        if (!jmx && TipoOperazione.CHANGE.equals((Object)tipoOperazione) && policy != null && policy.isEnabled() && (infoPolicy == null || !TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa()))) {
            de = new DataElement();
            de.setLabel("Runtime");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && policy.getIdActivePolicy() != null && !"".equals(policy.getIdActivePolicy())) {
            de = new DataElement();
            de.setName("CTPolicyActiveIdUnico");
            de.setLabel("Identificativo");
            de.setType(DataElementType.HIDDEN);
            de.setValue(policy.getIdActivePolicy());
            dati.add(de);
        }
        if (!jmx) {
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && policy != null && policy.isEnabled() && (infoPolicy == null || !TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa()))) {
                de = new DataElement();
                de.setName("CTPolicyActiveStateView");
                de.setLabel("Visualizza Informazioni");
                de.setValue("Visualizza Informazioni");
                if (ruoloPorta != null) {
                    de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true"), parRuoloPorta, parNomePorta, parServiceBinding});
                } else {
                    de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true")});
                }
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
                de = new DataElement();
                de.setName("CTPolicyActiveMode");
                de.setLabel("Identificazione Policy");
                de.setValues(ConfigurazioneCostanti.PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_POLICY_MODALITA_VALORI);
                de.setSelected(modalita);
                de.setValue(modalita);
                de.setType(DataElementType.SELECT);
                de.setPostBack_viaPOST(true);
                dati.add(de);
            }
        }
        de = new DataElement();
        de.setName("CTPolicyActiveId");
        de.setLabel("Policy");
        boolean configurazionePerCriteri = false;
        if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            if ("Scegli criteri".equals(modalita) && (idPolicies == null || idPolicies.size() <= 1)) {
                de.setType(DataElementType.HIDDEN);
                configurazionePerCriteri = true;
            } else {
                de.setValues(idPolicies);
                if (policy.getIdPolicy() != null) {
                    de.setSelected(policy.getIdPolicy());
                } else {
                    de.setSelected("-");
                }
                de.setType(DataElementType.SELECT);
                de.setRequired(true);
                de.setPostBack_viaPOST(true);
                if (addInfoDescrizionePolicy && infoPolicy != null) {
                    DataElementInfo dInfoDescrizionePolicy = new DataElementInfo("Policy");
                    dInfoDescrizionePolicy.setHeaderBody(this.replaceToHtmlSeparator(infoPolicy.getDescrizione()));
                    de.setInfo(dInfoDescrizionePolicy);
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (configurazionePerCriteri && idPolicies != null && idPolicies.size() == 1) {
            de.setValue((String)idPolicies.get(0));
        } else if (policy.getIdPolicy() != null) {
            de.setValue(policy.getIdPolicy());
        } else {
            de.setValue("-");
        }
        dati.add(de);
        if (!jmx) {
            if (TipoOperazione.ADD.equals((Object)tipoOperazione) && modalita != null && "Scegli criteri".equals(modalita)) {
                ConfigurazioneGenerale configurazioneControlloTraffico = this.confCore.getConfigurazioneControlloTraffico();
                de = new DataElement();
                de.setLabel("Criteri");
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
                this.addDataElementRisorsa(dati, "CTPolicyActiveModeRisorsa", modalitaRisorsa, "CTPolicyActiveModeEsiti", modalitaEsiti, true, type);
                if (!TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals(modalitaRisorsa)) {
                    if (!modalitaSimultaneeEnabled) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveModeIntervallo");
                        de.setLabel("Intervallo Osservazione");
                        de.setType(DataElementType.SELECT);
                        de.setValues(ConfigurazioneCostanti.PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_POLICY_MODALITA_INTERVALLO_OSSERVAZIONE);
                        de.setLabels(ConfigurazioneCostanti.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_POLICY_MODALITA_INTERVALLO_OSSERVAZIONE);
                        de.setSelected(modalitaIntervallo);
                        de.setValue(modalitaIntervallo);
                        de.setPostBack_viaPOST(true);
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setName("CTPolicyActiveModeCongestione");
                    de.setLabelRight("Applicata solo in presenza di Congestione del Traffico");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(modalitaCongestioneEnabled);
                    de.setValue("" + modalitaCongestioneEnabled);
                    de.setPostBack_viaPOST(true);
                    DataElementInfo dInfoDescrizioneCongestione = new DataElementInfo("Congestione del Traffico");
                    dInfoDescrizioneCongestione.setHeaderBody(this.replaceToHtmlSeparator(this.getApplicabilitaConCongestione(configurazioneControlloTraffico.getControlloTraffico())));
                    de.setInfo(dInfoDescrizioneCongestione);
                    dati.add(de);
                    de = new DataElement();
                    de.setName("CTPolicyActiveModeDegrado");
                    de.setLabelRight("Applicata solo in presenza di Degrado Prestazionale");
                    if (!TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals(modalitaRisorsa) && !TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals(modalitaRisorsa)) {
                        de.setType(DataElementType.CHECKBOX);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setSelected(modalitaDegradoEnabled);
                    de.setValue("" + modalitaDegradoEnabled);
                    de.setPostBack_viaPOST(true);
                    DataElementInfo dInfoDescrizioneDegrado = new DataElementInfo("Degrado Prestazionale");
                    dInfoDescrizioneDegrado.setHeaderBody(this.replaceToHtmlSeparator(this.getApplicabilitaDegradoPrestazionale()));
                    de.setInfo(dInfoDescrizioneDegrado);
                    dati.add(de);
                }
            }
            if (idPolicies != null && idPolicies.size() > 0 && infoPolicy != null) {
                de = new DataElement();
                de.setLabel("Valori di Soglia");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setName("CTPolicyActiveRidefinisci");
            de.setLabel("Ridefinisci Valori di Soglia");
            if (infoPolicy != null) {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(policy.isRidefinisci());
                de.setValue("" + policy.isRidefinisci());
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue("false");
            }
            de.setPostBack_viaPOST(true);
            dati.add(de);
            if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals(modalitaRisorsa) || infoPolicy != null && infoPolicy.getTipoRisorsa() != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa())) {
                de = new DataElement();
                de.setName("CTPolicyActiveValore2");
                if (infoPolicy != null) {
                    de.setLabel("Dimensione Richiesta");
                }
                if (infoPolicy != null) {
                    if (policy.isRidefinisci()) {
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setRequired(true);
                        if (policy.getValore2() != null) {
                            de.setValue("" + policy.getValore2());
                        } else {
                            de.setValue("");
                        }
                    } else {
                        de.setType(DataElementType.TEXT);
                        if (infoPolicy.getValore2() != null) {
                            de.setValue("" + infoPolicy.getValore2());
                        } else {
                            de.setValue("");
                        }
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("");
                }
                dati.add(de);
            }
            de = new DataElement();
            de.setName("CTPolicyActiveValore");
            if (infoPolicy != null) {
                switch (infoPolicy.getTipoRisorsa()) {
                    case NUMERO_RICHIESTE: {
                        de.setLabel("Num. Massimo Richieste");
                        break;
                    }
                    case DIMENSIONE_MASSIMA_MESSAGGIO: {
                        de.setLabel("Dimensione Risposta");
                        de.setNote("Indicazione della dimensione massima in 'kb' di una richiesta e di una risposta");
                        break;
                    }
                    case OCCUPAZIONE_BANDA: {
                        de.setLabel("Occupazione Massima");
                        de.setNote("Indicazione della banda occupata in 'kb'");
                        break;
                    }
                    case TEMPO_MEDIO_RISPOSTA: {
                        de.setLabel("Tempo Medio di Risposta");
                        de.setNote("Indicazione (in millisecondi) sul tempo medio di risposta che deve essere inferiore al valore fornito");
                        break;
                    }
                    case TEMPO_COMPLESSIVO_RISPOSTA: {
                        de.setLabel("Tempo Risposta");
                        de.setNote("Indicazione (in secondi) sul tempo di risposta complessivo che deve essere inferiore al valore fornito");
                        break;
                    }
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                        de.setLabel("Num. Massimo Richieste");
                        de.setNote("Vengono conteggiate solamente le transazioni completate con successo");
                        break;
                    }
                    case NUMERO_RICHIESTE_FALLITE: {
                        de.setLabel("Num. Massimo Richieste");
                        de.setNote("Vengono conteggiate solamente le transazioni fallite");
                        break;
                    }
                    case NUMERO_FAULT_APPLICATIVI: {
                        de.setLabel("Num. Massimo Richieste");
                        de.setNote("Vengono conteggiate solamente le transazioni che veicolano un fault applicativo");
                        break;
                    }
                    case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                        de.setLabel("Num. Massimo Richieste");
                        de.setNote("Vengono conteggiate solamente le transazioni fallite o che veicolano un fault applicativo");
                        break;
                    }
                    case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                        de.setLabel("Num. Massimo Richieste");
                        de.setNote("Vengono conteggiate solamente le transazioni completate con successo o che veicolano un fault applicativo");
                    }
                }
            }
            if (infoPolicy != null) {
                if (policy.isRidefinisci()) {
                    de.setType(DataElementType.TEXT_EDIT);
                    de.setRequired(true);
                    if (policy.getValore() != null) {
                        de.setValue("" + policy.getValore());
                    } else {
                        de.setValue("");
                    }
                } else {
                    de.setType(DataElementType.TEXT);
                    if (infoPolicy.getValore() != null) {
                        de.setValue("" + infoPolicy.getValore());
                    } else {
                        de.setValue("");
                    }
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue("");
            }
            dati.add(de);
            if (infoPolicy != null) {
                boolean delegata = false;
                boolean applicativa = false;
                boolean configurazione = false;
                if (ruoloPorta != null) {
                    if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                        delegata = nomePorta != null;
                    } else if (RuoloPolicy.APPLICATIVA.equals((Object)ruoloPorta)) {
                        applicativa = nomePorta != null;
                    }
                }
                configurazione = !delegata && !applicativa;
                boolean multitenant = this.confCore.isMultitenant();
                boolean tokenAbilitato = true;
                PddTipologia pddTipologiaSoggettoAutenticati = null;
                boolean gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore = false;
                PortaDelegata portaDelegata = null;
                PortaApplicativa portaApplicativa = null;
                CredenzialeTipo tipoAutenticazione = null;
                Boolean appId = null;
                String tokenPolicy = null;
                IDSoggetto idSoggettoProprietario = null;
                if (ruoloPorta != null) {
                    String gestioneTokenPolicy;
                    ApiKeyState apiKeyState;
                    if (applicativa) {
                        if (multitenant && this.confCore.getMultitenantSoggettiErogazioni() != null) {
                            switch (this.confCore.getMultitenantSoggettiErogazioni()) {
                                case SOLO_SOGGETTI_ESTERNI: {
                                    pddTipologiaSoggettoAutenticati = PddTipologia.ESTERNO;
                                    break;
                                }
                                case ESCLUDI_SOGGETTO_EROGATORE: {
                                    gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore = true;
                                    break;
                                }
                            }
                        }
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(nomePorta);
                        portaApplicativa = this.porteApplicativeCore.getPortaApplicativa(idPA);
                        tipoAutenticazione = CredenzialeTipo.toEnumConstant((String)portaApplicativa.getAutenticazione());
                        if (CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione)) {
                            apiKeyState = new ApiKeyState(this.porteApplicativeCore.getParametroAutenticazione(portaApplicativa.getAutenticazione(), portaApplicativa.getProprietaAutenticazioneList()));
                            appId = apiKeyState.appIdSelected;
                        }
                        if (portaApplicativa.getGestioneToken() != null && portaApplicativa.getGestioneToken().getPolicy() != null) {
                            tokenPolicy = portaApplicativa.getGestioneToken().getPolicy();
                        }
                        idSoggettoProprietario = new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario());
                        if (portaApplicativa.getGestioneToken() != null) {
                            gestioneTokenPolicy = portaApplicativa.getGestioneToken().getPolicy();
                            if (gestioneTokenPolicy == null || gestioneTokenPolicy.equals("") || gestioneTokenPolicy.equals("-")) {
                                tokenAbilitato = false;
                            }
                        } else {
                            tokenAbilitato = false;
                        }
                    }
                    if (delegata) {
                        IDPortaDelegata idPD = new IDPortaDelegata();
                        idPD.setNome(nomePorta);
                        portaDelegata = this.porteDelegateCore.getPortaDelegata(idPD);
                        tipoAutenticazione = CredenzialeTipo.toEnumConstant((String)portaDelegata.getAutenticazione());
                        if (CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione)) {
                            apiKeyState = new ApiKeyState(this.porteDelegateCore.getParametroAutenticazione(portaDelegata.getAutenticazione(), portaDelegata.getProprietaAutenticazioneList()));
                            appId = apiKeyState.appIdSelected;
                        }
                        if (portaDelegata.getGestioneToken() != null && portaDelegata.getGestioneToken().getPolicy() != null) {
                            tokenPolicy = portaDelegata.getGestioneToken().getPolicy();
                        }
                        idSoggettoProprietario = new IDSoggetto(portaDelegata.getTipoSoggettoProprietario(), portaDelegata.getNomeSoggettoProprietario());
                        if (portaDelegata.getGestioneToken() != null) {
                            gestioneTokenPolicy = portaDelegata.getGestioneToken().getPolicy();
                            if (gestioneTokenPolicy == null || gestioneTokenPolicy.equals("") || gestioneTokenPolicy.equals("-")) {
                                tokenAbilitato = false;
                            }
                        } else {
                            tokenAbilitato = false;
                        }
                    }
                }
                if (!(TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals(modalitaRisorsa) || infoPolicy != null && infoPolicy.getTipoRisorsa() != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa()))) {
                    this.addToDatiAttivazioneGroupBy(dati, tipoOperazione, policy, nomeSezione, (InfoPolicy)infoPolicy, ruoloPorta, nomePorta, serviceBinding, tokenAbilitato);
                }
                this.addToDatiAttivazioneFiltro(dati, tipoOperazione, policy, nomeSezione, (InfoPolicy)infoPolicy, ruoloPorta, nomePorta, serviceBinding, idSoggettoProprietario, tokenAbilitato, tipoAutenticazione, appId, tokenPolicy, pddTipologiaSoggettoAutenticati, gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore);
            }
        } else {
            List<String> aliases = this.core.getJmxPdDAliases();
            if (aliases == null || aliases.size() <= 0) {
                throw new DriverControlStationException("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
            }
            String jmxResetParam = this.getParameter("CTPolicyActiveViewJmxReset");
            boolean jmxReset = jmxResetParam != null && !"".equals(jmxResetParam);
            String aliasJmxReset = null;
            if (jmxReset && !"*".equals(jmxResetParam)) {
                aliasJmxReset = jmxResetParam;
            }
            boolean showResetCounters = !infoPolicy.isCheckRichiesteSimultanee() && (infoPolicy.isIntervalloUtilizzaRisorseRealtime() || infoPolicy.isDegradoPrestazionaleUtilizzaRisorseRealtime());
            de = new DataElement();
            de.setLabel("Informazioni Runtime");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyActiveStateView");
            de.setLabel("Refresh");
            de.setValue("Refresh");
            if (ruoloPorta != null) {
                de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true"), parRuoloPorta, parNomePorta, parServiceBinding});
            } else {
                de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true")});
            }
            de.setType(DataElementType.LINK);
            dati.add(de);
            if (showResetCounters && aliases.size() > 1) {
                de = new DataElement();
                de.setName("CTPolicyActiveStateViewReset");
                de.setLabel("Reset Contatori su tutti i Nodi");
                de.setValue("Reset Contatori su tutti i Nodi");
                if (ruoloPorta != null) {
                    de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true"), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxReset", "*"), parRuoloPorta, parNomePorta, parServiceBinding});
                } else {
                    de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true"), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxReset", "*")});
                }
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            int i = 0;
            for (String alias : aliases) {
                String errorMessage;
                String uniqueIdMap;
                String descrizioneAlias = this.core.getJmxPdDDescrizione(alias);
                de = new DataElement();
                de.setLabel(descrizioneAlias);
                de.setValue(descrizioneAlias);
                de.setType(DataElementType.TITLE);
                dati.add(de);
                if (jmxReset && (aliasJmxReset == null || aliasJmxReset.equals(alias))) {
                    Object resultReset = null;
                    uniqueIdMap = null;
                    try {
                        uniqueIdMap = UniqueIdentifierUtilities.getUniqueId((AttivazionePolicy)policy);
                        resultReset = this.core.getInvoker().invokeJMXMethod(alias, "type", "ControlloTraffico", "resetPolicyCounters", uniqueIdMap);
                    }
                    catch (Exception e) {
                        errorMessage = "Errore durante l'invocazione dell'operazione [resetPolicyCounters] sulla risorsa [ControlloTraffico] (param:" + uniqueIdMap + "): " + e.getMessage();
                        ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                        resultReset = errorMessage;
                    }
                    de = new DataElement();
                    de.setType(DataElementType.NOTE);
                    de.setValue((String)resultReset);
                    dati.add(de);
                }
                if (showResetCounters) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveStateViewReset_" + i);
                    de.setLabel("Reset Contatori");
                    de.setValue("Reset Contatori");
                    if (ruoloPorta != null) {
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true"), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxReset", alias), parRuoloPorta, parNomePorta, parServiceBinding});
                    } else {
                        de.setUrl("configurazioneControlloTrafficoAttivazionePolicyChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyId", "" + policy.getId()), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxState", "true"), new org.openspcoop2.web.lib.mvc.Parameter("CTPolicyActiveViewJmxReset", alias)});
                    }
                    de.setType(DataElementType.LINK);
                    dati.add(de);
                }
                Object result = null;
                uniqueIdMap = null;
                try {
                    uniqueIdMap = UniqueIdentifierUtilities.getUniqueId((AttivazionePolicy)policy);
                    result = this.core.getInvoker().invokeJMXMethod(alias, "type", "ControlloTraffico", "getPolicy", uniqueIdMap);
                }
                catch (Exception e) {
                    errorMessage = "Errore durante l'invocazione dell'operazione [getPolicy] sulla risorsa [ControlloTraffico] (param:" + uniqueIdMap + "): " + e.getMessage();
                    ControlStationCore.getLog().error(errorMessage, (Throwable)e);
                    result = errorMessage;
                }
                de = new DataElement();
                de.setLabel("Stato Runtime");
                de.setLabelAffiancata(false);
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                de.setRows(20);
                de.setCols(100);
                de.setValue((String)result);
                dati.add(de);
                this.pd.disableEditMode();
                ++i;
            }
        }
    }

    protected void addToDatiDataElementStato_postBackViaGET(List<DataElement> dati, String param, String label, boolean enabled, boolean postBack, boolean withWarningOnly, boolean warningOnly, boolean hidden) {
        this._addToDatiDataElementStato(dati, param, label, enabled, postBack, false, withWarningOnly, warningOnly, hidden);
    }

    protected void addToDatiDataElementStato_postBackViaPOST(List<DataElement> dati, String param, String label, boolean enabled, boolean postBackPOST, boolean withWarningOnly, boolean warningOnly, boolean hidden) {
        this._addToDatiDataElementStato(dati, param, label, enabled, false, postBackPOST, withWarningOnly, warningOnly, hidden);
    }

    private void _addToDatiDataElementStato(List<DataElement> dati, String param, String label, boolean enabled, boolean postBack, boolean postBackPOST, boolean withWarningOnly, boolean warningOnly, boolean hidden) {
        DataElement de = new DataElement();
        de.setName(param);
        de.setLabel(label);
        if (hidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.SELECT);
            if (withWarningOnly) {
                de.setValues(ConfigurazioneCostanti.STATI_CON_WARNING);
            } else {
                de.setValues(ConfigurazioneCostanti.STATI);
            }
            if (postBack) {
                de.setPostBack(postBack);
            }
            if (postBackPOST) {
                de.setPostBack_viaPOST(postBackPOST);
            }
        }
        if (!(!enabled || withWarningOnly && warningOnly)) {
            de.setSelected(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
            de.setValue("Abilitato");
        } else if (warningOnly && withWarningOnly) {
            de.setSelected("warningOnly");
            de.setValue("WarningOnly");
        } else {
            de.setSelected(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
            de.setValue("Disabilitato");
        }
        dati.add(de);
    }

    private void addToDatiDataElementStatoReadOnly(List<DataElement> dati, String param, String label, boolean enabled, boolean postBack, boolean withWarningOnly, boolean warningOnly) {
        DataElement de = new DataElement();
        de.setName(param);
        de.setLabel(label);
        de.setType(DataElementType.HIDDEN);
        if (!(!enabled || withWarningOnly && warningOnly)) {
            de.setSelected(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
            de.setValue("Abilitato");
        } else if (warningOnly && withWarningOnly) {
            de.setSelected("warningOnly");
            de.setValue("WarningOnly");
        } else {
            de.setSelected(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
            de.setValue("Disabilitato");
        }
        dati.add(de);
        de = new DataElement();
        de.setName(param + "___LABEL");
        de.setLabel(label);
        de.setType(DataElementType.TEXT);
        if (!(!enabled || withWarningOnly && warningOnly)) {
            de.setSelected(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
            de.setValue("Abilitato");
        } else if (warningOnly && withWarningOnly) {
            de.setSelected("warningOnly");
            de.setValue("WarningOnly");
        } else {
            de.setSelected(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
            de.setValue("Disabilitato");
        }
        dati.add(de);
    }

    /*
     * WARNING - void declaration
     */
    private void addToDatiAttivazioneFiltro(List<DataElement> dati, TipoOperazione tipoOperazione, AttivazionePolicy policy, String nomeSezione, InfoPolicy infoPolicy, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding, IDSoggetto idSoggettoProprietario, boolean tokenAbilitato, CredenzialeTipo tipoAutenticazione, Boolean appId, String tokenPolicy, PddTipologia pddTipologiaSoggettoAutenticati, boolean gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore) throws Exception {
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPolicy.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        org.openspcoop2.core.config.constants.CredenzialeTipo tipoAutenticazioneConfig = null;
        if (tipoAutenticazione != null) {
            tipoAutenticazioneConfig = org.openspcoop2.core.config.constants.CredenzialeTipo.toEnumConstant((String)tipoAutenticazione.getValue(), (boolean)true);
        }
        boolean tokenPolicyOR = false;
        if (tokenPolicy != null && !"".equals(tokenPolicy)) {
            if (tipoAutenticazione != null && !org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN.equals((Object)tipoAutenticazioneConfig)) {
                tokenPolicyOR = true;
            } else {
                tipoAutenticazioneConfig = org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN;
            }
        }
        boolean multitenant = this.confCore.isMultitenant();
        ArrayList<String> protocolliLabel = null;
        List<String> protocolliValue = null;
        String protocolloSelezionatoLabel = null;
        String protocolloSelezionatoValue = null;
        List<String> ruoliErogatoreLabel = null;
        List<String> ruoliErogatoreValue = null;
        String ruoloErogatoreSelezionatoLabel = null;
        String ruoloErogatoreSelezionatoValue = null;
        List<String> erogatoriLabel = null;
        List<String> erogatoriValue = null;
        String datiIdentificativiErogatoreSelezionatoLabel = null;
        String datiIdentificativiErogatoreSelezionatoValue = null;
        List<String> tagLabel = null;
        List<String> tagValue = null;
        String datiIdentificativiTagSelezionatoLabel = null;
        String datiIdentificativiTagSelezionatoValue = null;
        List<String> serviziLabel = null;
        List<String> serviziValue = null;
        String datiIdentificativiServizioSelezionatoLabel = null;
        String datiIdentificativiServizioSelezionatoValue = null;
        ArrayList<String> azioniLabel = null;
        ArrayList<String> azioniValue = null;
        ArrayList<String> azioniSelezionataLabel = null;
        ArrayList<String> azioniSelezionataValue = null;
        List<String> serviziApplicativiErogatoreLabel = null;
        List<String> serviziApplicativiErogatoreValue = null;
        String servizioApplicativoErogatoreSelezionatoLabel = null;
        String servizioApplicativoErogatoreSelezionatoValue = null;
        List<String> ruoliFruitoreLabel = null;
        List<String> ruoliFruitoreValue = null;
        String ruoloFruitoreSelezionatoLabel = null;
        String ruoloFruitoreSelezionatoValue = null;
        List<String> fruitoriLabel = null;
        List<String> fruitoriValue = null;
        String datiIdentificativiFruitoreSelezionatoLabel = null;
        String datiIdentificativiFruitoreSelezionatoValue = null;
        List<String> serviziApplicativiFruitoreLabel = null;
        List<String> serviziApplicativiFruitoreValue = null;
        String servizioApplicativoFruitoreSelezionatoLabel = null;
        String servizioApplicativoFruitoreSelezionatoValue = null;
        String tokenClaims = null;
        boolean filtroByKey = false;
        FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
        filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
        boolean protocolloAssociatoFiltroNonSelezionatoUtente = false;
        if (policy.getFiltro().isEnabled()) {
            protocolliValue = this.confCore.getProtocolli(this.request, this.session);
            if (policy.getFiltro().getProtocollo() != null && !protocolliValue.contains(policy.getFiltro().getProtocollo())) {
                protocolloAssociatoFiltroNonSelezionatoUtente = true;
            }
        }
        if (policy.getFiltro().isEnabled()) {
            Object aspc;
            IDSoggetto idSoggetto;
            if (configurazione) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    protocolloSelezionatoValue = policy.getFiltro().getProtocollo();
                } else {
                    if (!protocolliValue.contains(policy.getFiltro().getProtocollo())) {
                        policy.getFiltro().setProtocollo(null);
                    }
                    if ((protocolloSelezionatoValue = policy.getFiltro().getProtocollo()) == null || protocolloSelezionatoValue.equals("")) {
                        protocolloSelezionatoValue = protocolliValue.size() == 1 ? protocolliValue.get(0) : this.confCore.getProtocolloDefault(this.request, this.session, protocolliValue);
                    }
                    protocolliLabel = new ArrayList<String>();
                    for (String protocollo : protocolliValue) {
                        protocolliLabel.add(this.getLabelProtocollo(protocollo));
                    }
                }
                protocolloSelezionatoLabel = this.getLabelProtocollo(protocolloSelezionatoValue);
            } else {
                protocolloSelezionatoValue = policy.getFiltro().getProtocollo();
                if (protocolloSelezionatoValue == null) {
                    protocolloSelezionatoValue = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(idSoggettoProprietario.getTipo());
                }
            }
            if (configurazione) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    ruoloErogatoreSelezionatoValue = policy.getFiltro().getRuoloErogatore();
                    ruoloErogatoreSelezionatoLabel = ruoloErogatoreSelezionatoValue != null ? ruoloErogatoreSelezionatoValue : "Qualsiasi";
                } else {
                    List<String> ruoliErogatore = this.core.getAllRuoli(filtroRuoli);
                    if (policy.getFiltro().getRuoloErogatore() != null) {
                        ruoloErogatoreSelezionatoValue = policy.getFiltro().getRuoloErogatore();
                    }
                    if (!ruoliErogatore.contains(ruoloErogatoreSelezionatoValue)) {
                        policy.getFiltro().setRuoloErogatore(null);
                        ruoloErogatoreSelezionatoValue = null;
                    }
                    ruoliErogatoreLabel = this.enrichListConLabelQualsiasi(ruoliErogatore);
                    ruoliErogatoreValue = this.enrichListConValueQualsiasi(ruoliErogatore);
                }
            }
            if (configurazione) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    idSoggetto = null;
                    if (policy.getFiltro().getTipoErogatore() != null && policy.getFiltro().getNomeErogatore() != null) {
                        datiIdentificativiErogatoreSelezionatoValue = policy.getFiltro().getTipoErogatore() + "/" + policy.getFiltro().getNomeErogatore();
                        idSoggetto = new IDSoggetto(policy.getFiltro().getTipoErogatore(), policy.getFiltro().getNomeErogatore());
                    }
                    datiIdentificativiErogatoreSelezionatoLabel = idSoggetto != null ? this.getLabelNomeSoggetto(idSoggetto) : "Qualsiasi";
                } else {
                    ArrayList<IDSoggetto> listErogatori = new ArrayList<IDSoggetto>();
                    List<IDSoggetto> listSoggettiPreFilterMultitenant = this.confCore.getSoggettiErogatori(protocolloSelezionatoValue, protocolliValue);
                    if (policy.getFiltro().getRuoloPorta() != null && !RuoloPolicy.ENTRAMBI.equals((Object)policy.getFiltro().getRuoloPorta())) {
                        for (IDSoggetto iDSoggetto : listSoggettiPreFilterMultitenant) {
                            Soggetto s = this.soggettiCore.getSoggettoRegistro(iDSoggetto);
                            boolean isPddEsterna = this.pddCore.isPddEsterna(s.getPortaDominio());
                            if (RuoloPolicy.DELEGATA.equals((Object)policy.getFiltro().getRuoloPorta())) {
                                if (isPddEsterna) {
                                    listErogatori.add(iDSoggetto);
                                    continue;
                                }
                                if (PddTipologia.ESTERNO.equals((Object)pddTipologiaSoggettoAutenticati)) continue;
                                listErogatori.add(iDSoggetto);
                                continue;
                            }
                            if (isPddEsterna) continue;
                            listErogatori.add(iDSoggetto);
                        }
                    } else {
                        listErogatori.addAll(listSoggettiPreFilterMultitenant);
                    }
                    erogatoriLabel = new ArrayList<String>();
                    erogatoriValue = new ArrayList<String>();
                    for (IDSoggetto iDSoggetto : listErogatori) {
                        erogatoriLabel.add(this.getLabelNomeSoggetto(iDSoggetto));
                        erogatoriValue.add(iDSoggetto.getTipo() + "/" + iDSoggetto.getNome());
                    }
                    if (policy.getFiltro().getTipoErogatore() != null && policy.getFiltro().getNomeErogatore() != null) {
                        datiIdentificativiErogatoreSelezionatoValue = policy.getFiltro().getTipoErogatore() + "/" + policy.getFiltro().getNomeErogatore();
                    }
                    if (!erogatoriValue.contains(datiIdentificativiErogatoreSelezionatoValue)) {
                        policy.getFiltro().setTipoErogatore(null);
                        policy.getFiltro().setNomeErogatore(null);
                        datiIdentificativiErogatoreSelezionatoValue = null;
                    }
                    erogatoriLabel = this.enrichListConLabelQualsiasi(erogatoriLabel);
                    erogatoriValue = this.enrichListConValueQualsiasi(erogatoriValue);
                }
            }
            if (configurazione) {
                FiltroRicercaGruppi filtroRicerca = new FiltroRicercaGruppi();
                List<String> elencoGruppi = this.gruppiCore.getAllGruppi(filtroRicerca);
                tagLabel = this.enrichListConLabelQualsiasi(elencoGruppi);
                tagValue = this.enrichListConValueQualsiasi(elencoGruppi);
                datiIdentificativiTagSelezionatoValue = policy.getFiltro().getTag();
                datiIdentificativiTagSelezionatoLabel = policy.getFiltro().getTag();
            }
            if (configurazione) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    IDServizio idServizio = null;
                    if (policy.getFiltro().getTipoServizio() != null && policy.getFiltro().getNomeServizio() != null && policy.getFiltro().getVersioneServizio() != null && policy.getFiltro().getTipoErogatore() != null && policy.getFiltro().getNomeErogatore() != null) {
                        datiIdentificativiServizioSelezionatoValue = policy.getFiltro().getTipoServizio() + "/" + policy.getFiltro().getNomeServizio() + "/" + policy.getFiltro().getVersioneServizio();
                        if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore()) {
                            datiIdentificativiServizioSelezionatoValue = datiIdentificativiServizioSelezionatoValue + "/" + policy.getFiltro().getTipoErogatore() + "/" + policy.getFiltro().getNomeErogatore();
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(policy.getFiltro().getTipoServizio(), policy.getFiltro().getNomeServizio(), policy.getFiltro().getTipoErogatore(), policy.getFiltro().getNomeErogatore(), policy.getFiltro().getVersioneServizio().intValue());
                        } else {
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(policy.getFiltro().getTipoServizio(), policy.getFiltro().getNomeServizio(), null, null, policy.getFiltro().getVersioneServizio().intValue());
                        }
                    }
                    datiIdentificativiServizioSelezionatoLabel = this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore() ? (idServizio != null ? this.getLabelIdServizio(idServizio) : "Qualsiasi") : (idServizio != null ? this.getLabelIdServizioSenzaErogatore(idServizio) : "Qualsiasi");
                } else {
                    boolean definedApi;
                    List<IDServizio> listServizi = this.confCore.getServizi(protocolloSelezionatoValue, protocolliValue, policy.getFiltro().getTipoErogatore(), policy.getFiltro().getNomeErogatore(), policy.getFiltro().getTag());
                    serviziLabel = new ArrayList<String>();
                    serviziValue = new ArrayList<String>();
                    for (IDServizio idServizio : listServizi) {
                        void var69_95;
                        String string = idServizio.getTipo() + "/" + idServizio.getNome() + "/" + idServizio.getVersione();
                        if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore()) {
                            String string2 = string + "/" + idServizio.getSoggettoErogatore().getTipo() + "/" + idServizio.getSoggettoErogatore().getNome();
                        }
                        if (serviziValue.contains(var69_95)) continue;
                        serviziValue.add((String)var69_95);
                        String labelAPI = null;
                        labelAPI = this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore() ? this.getLabelIdServizio(idServizio) : this.getLabelIdServizioSenzaErogatore(idServizio);
                        serviziLabel.add(labelAPI);
                    }
                    boolean bl = definedApi = policy.getFiltro().getTipoServizio() != null && policy.getFiltro().getNomeServizio() != null && policy.getFiltro().getVersioneServizio() != null;
                    if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore()) {
                        boolean bl2 = definedApi = definedApi && policy.getFiltro().getTipoErogatore() != null && policy.getFiltro().getNomeErogatore() != null;
                    }
                    if (definedApi) {
                        datiIdentificativiServizioSelezionatoValue = policy.getFiltro().getTipoServizio() + "/" + policy.getFiltro().getNomeServizio() + "/" + policy.getFiltro().getVersioneServizio();
                        if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore()) {
                            datiIdentificativiServizioSelezionatoValue = datiIdentificativiServizioSelezionatoValue + "/" + policy.getFiltro().getTipoErogatore() + "/" + policy.getFiltro().getNomeErogatore();
                        }
                    }
                    if (!serviziValue.contains(datiIdentificativiServizioSelezionatoValue)) {
                        policy.getFiltro().setTipoServizio(null);
                        policy.getFiltro().setNomeServizio(null);
                        policy.getFiltro().setVersioneServizio(null);
                        datiIdentificativiServizioSelezionatoValue = null;
                    }
                    serviziLabel = this.enrichListConLabelQualsiasi(serviziLabel);
                    serviziValue = this.enrichListConValueQualsiasi(serviziValue);
                }
            }
            if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                if (policy.getFiltro().getAzione() != null && !"".equals(policy.getFiltro().getAzione())) {
                    azioniSelezionataValue = new ArrayList<String>();
                    if (policy.getFiltro().getAzione().contains(",")) {
                        void var69_97;
                        String[] tmp = policy.getFiltro().getAzione().split(",");
                        String[] definedApi = tmp;
                        int idServizio = definedApi.length;
                        boolean bl = false;
                        while (var69_97 < idServizio) {
                            String az = definedApi[var69_97];
                            azioniSelezionataValue.add(az);
                            ++var69_97;
                        }
                    } else {
                        azioniSelezionataValue.add(policy.getFiltro().getAzione());
                    }
                    if (!azioniSelezionataValue.isEmpty()) {
                        azioniSelezionataLabel = new ArrayList();
                        for (String az : azioniSelezionataValue) {
                            azioniSelezionataLabel.add(az);
                        }
                    }
                }
                if (azioniSelezionataLabel == null) {
                    azioniSelezionataLabel = new ArrayList<String>();
                    azioniSelezionataLabel.add("Qualsiasi");
                }
            } else {
                List<Object> azioni = null;
                Map<String, String> azioniConLabel = null;
                if (configurazione && datiIdentificativiServizioSelezionatoValue != null) {
                    if (StringUtils.isNotEmpty((CharSequence)policy.getFiltro().getTipoServizio()) && StringUtils.isNotEmpty((CharSequence)policy.getFiltro().getNomeServizio()) && policy.getFiltro().getVersioneServizio() != null && policy.getFiltro().getVersioneServizio() > 0) {
                        if (StringUtils.isNotEmpty((CharSequence)policy.getFiltro().getTipoErogatore()) && StringUtils.isNotEmpty((CharSequence)policy.getFiltro().getNomeErogatore())) {
                            IDServizio idServizio;
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(policy.getFiltro().getTipoServizio(), policy.getFiltro().getNomeServizio(), policy.getFiltro().getTipoErogatore(), policy.getFiltro().getNomeErogatore(), policy.getFiltro().getVersioneServizio().intValue());
                            AccordoServizioParteSpecifica accordoServizioParteSpecifica = this.apsCore.getServizio(idServizio, false);
                            AccordoServizioParteComuneSintetico aspc2 = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri(accordoServizioParteSpecifica.getAccordoServizioParteComune()));
                            azioniConLabel = this.porteDelegateCore.getAzioniConLabel(accordoServizioParteSpecifica, aspc2, false, true, null);
                        } else {
                            List<IDServizio> listServizi = this.confCore.getServizi(protocolloSelezionatoValue, protocolliValue, policy.getFiltro().getTipoServizio(), policy.getFiltro().getNomeServizio(), policy.getFiltro().getVersioneServizio(), null);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            AccordoServizioParteSpecifica aspsRiferimento = null;
                            if (listServizi != null && !listServizi.isEmpty()) {
                                for (IDServizio idS : listServizi) {
                                    AccordoServizioParteSpecifica asps = this.apsCore.getServizio(idS, false);
                                    if (!arrayList.contains(asps.getAccordoServizioParteComune())) {
                                        arrayList.add(asps.getAccordoServizioParteComune());
                                        if (aspsRiferimento == null) {
                                            aspsRiferimento = asps;
                                        }
                                    }
                                    if (arrayList.size() <= 1) continue;
                                    break;
                                }
                            }
                            if (arrayList.size() == 1) {
                                AccordoServizioParteComuneSintetico aspc3 = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri((String)arrayList.get(0)));
                                azioniConLabel = this.porteDelegateCore.getAzioniConLabel(aspsRiferimento, aspc3, false, true, null);
                            }
                        }
                    }
                    azioni = this.confCore.getAzioni(protocolloSelezionatoValue, protocolliValue, policy.getFiltro().getTipoErogatore(), policy.getFiltro().getNomeErogatore(), policy.getFiltro().getTipoServizio(), policy.getFiltro().getNomeServizio(), policy.getFiltro().getVersioneServizio());
                } else if (delegata) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(policy.getFiltro().getNomePorta());
                    PortaDelegata portaDelegata = this.porteDelegateCore.getPortaDelegata(idPD);
                    MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(portaDelegata);
                    IDServizio idServizio = mappingPD.getIdServizio();
                    asps = this.apsCore.getServizio(idServizio, false);
                    aspc = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                    if (portaDelegata.getAzione() != null && portaDelegata.getAzione().sizeAzioneDelegataList() > 0) {
                        azioni = portaDelegata.getAzione().getAzioneDelegataList();
                    } else {
                        int i;
                        int listaMappingFruizioneSize;
                        azioniAll = this.confCore.getAzioni(protocolloSelezionatoValue, protocolliValue, portaDelegata.getSoggettoErogatore().getTipo(), portaDelegata.getSoggettoErogatore().getNome(), portaDelegata.getServizio().getTipo(), portaDelegata.getServizio().getNome(), portaDelegata.getServizio().getVersione());
                        IDSoggetto idSoggettoFruitore = mappingPD.getIdFruitore();
                        List<MappingFruizionePortaDelegata> listaMappingFruizione = this.apsCore.serviziFruitoriMappingList(idSoggettoFruitore, idServizio, null);
                        ArrayList azioniOccupate = new ArrayList();
                        int n = listaMappingFruizioneSize = listaMappingFruizione != null ? listaMappingFruizione.size() : 0;
                        if (listaMappingFruizioneSize > 0) {
                            for (i = 0; i < listaMappingFruizione.size(); ++i) {
                                MappingFruizionePortaDelegata mappingFruizionePortaDelegata = listaMappingFruizione.get(i);
                                PortaDelegata portaDelegataTmp = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                                if (portaDelegataTmp.getAzione() == null || portaDelegataTmp.getAzione().getAzioneDelegataList() == null) continue;
                                azioniOccupate.addAll(portaDelegataTmp.getAzione().getAzioneDelegataList());
                            }
                        }
                        azioni = new ArrayList();
                        for (i = 0; i < azioniAll.size(); ++i) {
                            String az = azioniAll.get(i);
                            if (azioniOccupate.contains(az)) continue;
                            azioni.add(az);
                        }
                    }
                    azioniConLabel = this.porteDelegateCore.getAzioniConLabel(asps, (AccordoServizioParteComuneSintetico)aspc, false, true, null);
                } else if (applicativa) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(policy.getFiltro().getNomePorta());
                    PortaApplicativa portaApplicativa = this.porteApplicativeCore.getPortaApplicativa(idPA);
                    MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(portaApplicativa);
                    IDServizio idServizio = mappingPA.getIdServizio();
                    asps = this.apsCore.getServizio(idServizio, false);
                    aspc = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                    if (portaApplicativa.getAzione() != null && portaApplicativa.getAzione().sizeAzioneDelegataList() > 0) {
                        azioni = portaApplicativa.getAzione().getAzioneDelegataList();
                    } else {
                        int i;
                        int listaMappingErogazioneSize;
                        azioniAll = this.confCore.getAzioni(protocolloSelezionatoValue, protocolliValue, portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario(), portaApplicativa.getServizio().getTipo(), portaApplicativa.getServizio().getNome(), portaApplicativa.getServizio().getVersione());
                        List<MappingErogazionePortaApplicativa> listaMappingErogazione = this.apsCore.mappingServiziPorteAppList(idServizio, null);
                        ArrayList azioniOccupate = new ArrayList();
                        int n = listaMappingErogazioneSize = listaMappingErogazione != null ? listaMappingErogazione.size() : 0;
                        if (listaMappingErogazioneSize > 0) {
                            for (i = 0; i < listaMappingErogazione.size(); ++i) {
                                MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = listaMappingErogazione.get(i);
                                PortaApplicativa portaApplicativaTmp = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                                if (portaApplicativaTmp.getAzione() == null || portaApplicativaTmp.getAzione().getAzioneDelegataList() == null) continue;
                                azioniOccupate.addAll(portaApplicativaTmp.getAzione().getAzioneDelegataList());
                            }
                        }
                        azioni = new ArrayList();
                        for (i = 0; i < azioniAll.size(); ++i) {
                            String az = azioniAll.get(i);
                            if (azioniOccupate.contains(az)) continue;
                            azioni.add(az);
                        }
                    }
                    azioniConLabel = this.porteApplicativeCore.getAzioniConLabel(asps, (AccordoServizioParteComuneSintetico)aspc, false, true, null);
                } else {
                    azioni = new ArrayList<String>();
                }
                if (policy.getFiltro().getAzione() != null && !"".equals(policy.getFiltro().getAzione())) {
                    azioniSelezionataValue = new ArrayList();
                    if (policy.getFiltro().getAzione().contains(",")) {
                        String[] tmp;
                        for (String az : tmp = policy.getFiltro().getAzione().split(",")) {
                            if (!azioni.contains(az)) continue;
                            azioniSelezionataValue.add(az);
                        }
                    } else if (azioni.contains(policy.getFiltro().getAzione())) {
                        azioniSelezionataValue.add(policy.getFiltro().getAzione());
                    }
                }
                if (azioniSelezionataValue == null || azioniSelezionataValue.isEmpty()) {
                    azioniSelezionataValue = null;
                }
                if (azioniConLabel != null && azioniConLabel.size() > 0) {
                    azioniLabel = new ArrayList();
                    azioniValue = new ArrayList();
                    for (String string : azioniConLabel.keySet()) {
                        if (!azioni.contains(string)) continue;
                        azioniValue.add(string);
                        azioniLabel.add((String)azioniConLabel.get(string));
                    }
                } else {
                    azioniLabel = azioni;
                    azioniValue = azioni;
                }
            }
            if (configurazione && (policy.getFiltro().getRuoloPorta() == null || RuoloPolicy.ENTRAMBI.equals((Object)policy.getFiltro().getRuoloPorta()) || RuoloPolicy.APPLICATIVA.equals((Object)policy.getFiltro().getRuoloPorta()))) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    if (policy.getFiltro().getServizioApplicativoErogatore() != null) {
                        servizioApplicativoErogatoreSelezionatoValue = policy.getFiltro().getServizioApplicativoErogatore();
                    }
                    servizioApplicativoErogatoreSelezionatoLabel = servizioApplicativoErogatoreSelezionatoValue != null ? servizioApplicativoErogatoreSelezionatoValue : "Qualsiasi";
                } else {
                    serviziApplicativiErogatoreLabel = new ArrayList<String>();
                    serviziApplicativiErogatoreValue = new ArrayList<String>();
                    if (datiIdentificativiErogatoreSelezionatoValue != null) {
                        List<IDServizioApplicativo> listSA = this.confCore.getServiziApplicativiErogatori(protocolloSelezionatoValue, protocolliValue, policy.getFiltro().getTipoErogatore(), policy.getFiltro().getNomeErogatore(), policy.getFiltro().getTipoServizio(), policy.getFiltro().getNomeServizio(), policy.getFiltro().getVersioneServizio(), null);
                        for (IDServizioApplicativo idServizioApplicativo : listSA) {
                            serviziApplicativiErogatoreLabel.add(idServizioApplicativo.getNome());
                            serviziApplicativiErogatoreValue.add(idServizioApplicativo.getNome());
                        }
                    }
                    if (policy.getFiltro().getServizioApplicativoErogatore() != null) {
                        servizioApplicativoErogatoreSelezionatoValue = policy.getFiltro().getServizioApplicativoErogatore();
                    }
                    if (!serviziApplicativiErogatoreValue.contains(servizioApplicativoErogatoreSelezionatoValue)) {
                        policy.getFiltro().setServizioApplicativoErogatore(null);
                        servizioApplicativoErogatoreSelezionatoValue = null;
                    }
                    serviziApplicativiErogatoreLabel = this.enrichListConLabelQualsiasi(serviziApplicativiErogatoreLabel);
                    serviziApplicativiErogatoreValue = this.enrichListConValueQualsiasi(serviziApplicativiErogatoreValue);
                }
            }
            if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                if (policy.getFiltro().getRuoloFruitore() != null) {
                    ruoloFruitoreSelezionatoValue = policy.getFiltro().getRuoloFruitore();
                }
                ruoloFruitoreSelezionatoLabel = ruoloFruitoreSelezionatoValue != null ? ruoloFruitoreSelezionatoValue : "Qualsiasi";
            } else {
                List<String> ruoliFruitore = this.core.getAllRuoli(filtroRuoli);
                if (policy.getFiltro().getRuoloFruitore() != null) {
                    ruoloFruitoreSelezionatoValue = policy.getFiltro().getRuoloFruitore();
                }
                if (!ruoliFruitore.contains(ruoloFruitoreSelezionatoValue)) {
                    policy.getFiltro().setRuoloFruitore(null);
                    ruoloFruitoreSelezionatoValue = null;
                }
                ruoliFruitoreLabel = this.enrichListConLabelQualsiasi(ruoliFruitore);
                ruoliFruitoreValue = this.enrichListConValueQualsiasi(ruoliFruitore);
            }
            if (configurazione || applicativa) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    idSoggetto = null;
                    if (policy.getFiltro().getTipoFruitore() != null && policy.getFiltro().getNomeFruitore() != null) {
                        datiIdentificativiFruitoreSelezionatoValue = policy.getFiltro().getTipoFruitore() + "/" + policy.getFiltro().getNomeFruitore();
                        idSoggetto = new IDSoggetto(policy.getFiltro().getTipoFruitore(), policy.getFiltro().getNomeFruitore());
                    }
                    datiIdentificativiFruitoreSelezionatoLabel = idSoggetto != null ? this.getLabelNomeSoggetto(idSoggetto) : "Qualsiasi";
                } else {
                    ArrayList<IDSoggetto> listSoggetti = new ArrayList<IDSoggetto>();
                    if (configurazione) {
                        List<IDSoggetto> listSoggettiPreFilterMultitenant = this.confCore.getSoggetti(protocolloSelezionatoValue, protocolliValue);
                        if (policy.getFiltro().getRuoloPorta() != null && !RuoloPolicy.ENTRAMBI.equals((Object)policy.getFiltro().getRuoloPorta())) {
                            for (IDSoggetto iDSoggetto : listSoggettiPreFilterMultitenant) {
                                Soggetto s = this.soggettiCore.getSoggettoRegistro(iDSoggetto);
                                boolean isPddEsterna = this.pddCore.isPddEsterna(s.getPortaDominio());
                                if (RuoloPolicy.APPLICATIVA.equals((Object)policy.getFiltro().getRuoloPorta())) {
                                    if (isPddEsterna) {
                                        listSoggetti.add(iDSoggetto);
                                        continue;
                                    }
                                    if (PddTipologia.ESTERNO.equals((Object)pddTipologiaSoggettoAutenticati)) continue;
                                    listSoggetti.add(iDSoggetto);
                                    continue;
                                }
                                if (isPddEsterna) continue;
                                listSoggetti.add(iDSoggetto);
                            }
                        } else {
                            listSoggetti.addAll(listSoggettiPreFilterMultitenant);
                        }
                    } else {
                        User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                        String userLogin = user.getLogin();
                        List<String> list = this.soggettiCore.getTipiSoggettiGestitiProtocollo(protocolloSelezionatoValue);
                        List<IDSoggettoDB> list2 = null;
                        list2 = this.core.isVisioneOggettiGlobale(userLogin) ? this.soggettiCore.getSoggettiFromTipoAutenticazione(list, null, tipoAutenticazione, appId, pddTipologiaSoggettoAutenticati) : this.soggettiCore.getSoggettiFromTipoAutenticazione(list, userLogin, tipoAutenticazione, appId, pddTipologiaSoggettoAutenticati);
                        if (list2 != null && !list2.isEmpty() && gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore) {
                            for (int i = 0; i < list2.size(); ++i) {
                                IDSoggettoDB soggettoCheck = list2.get(i);
                                if (!soggettoCheck.getTipo().equals(idSoggettoProprietario.getTipo()) || !soggettoCheck.getNome().equals(idSoggettoProprietario.getNome())) continue;
                                list2.remove(i);
                                break;
                            }
                        }
                        if (list2 == null) {
                            list2 = new ArrayList<IDSoggettoDB>();
                        }
                        boolean isSupportatoAutenticazioneApplicativiEsterni = false;
                        if (protocolloSelezionatoValue != null && !"".equals(protocolloSelezionatoValue)) {
                            isSupportatoAutenticazioneApplicativiEsterni = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocolloSelezionatoValue);
                        }
                        if (isSupportatoAutenticazioneApplicativiEsterni || multitenant) {
                            List<IDSoggetto> listSoggettiPreFilterMultitenant = this.confCore.getSoggetti(protocolloSelezionatoValue, protocolliValue);
                            aspc = listSoggettiPreFilterMultitenant.iterator();
                            while (aspc.hasNext()) {
                                List<IDServizioApplicativoDB> listServiziApplicativiTmp;
                                IDSoggettoDB idSoggettoDB;
                                List<IDServizioApplicativoDB> listServiziApplicativiTmp2;
                                IDSoggetto idSoggetto4 = (IDSoggetto)aspc.next();
                                Soggetto s = this.soggettiCore.getSoggettoRegistro(idSoggetto4);
                                boolean isPddEsterna = this.pddCore.isPddEsterna(s.getPortaDominio());
                                boolean found = false;
                                if (multitenant && !isPddEsterna || isSupportatoAutenticazioneApplicativiEsterni && isPddEsterna) {
                                    for (IDSoggettoDB sogg : list2) {
                                        if (!sogg.getTipo().equals(s.getTipo()) || !sogg.getNome().equals(s.getNome())) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                boolean bothSslAndToken = false;
                                if (!found && multitenant && !isPddEsterna && (listServiziApplicativiTmp2 = this.saCore.soggettiServizioApplicativoList(idSoggetto4, userLogin, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR)) != null && !listServiziApplicativiTmp2.isEmpty()) {
                                    idSoggettoDB = new IDSoggettoDB();
                                    idSoggettoDB.setTipo(s.getTipo());
                                    idSoggettoDB.setNome(s.getNome());
                                    idSoggettoDB.setCodicePorta(s.getIdentificativoPorta());
                                    idSoggettoDB.setId(s.getId());
                                    list2.add(idSoggettoDB);
                                }
                                if (found || !isSupportatoAutenticazioneApplicativiEsterni || !isPddEsterna || (listServiziApplicativiTmp = this.saCore.soggettiServizioApplicativoList(idSoggetto4, userLogin, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR)) == null || listServiziApplicativiTmp.isEmpty()) continue;
                                idSoggettoDB = new IDSoggettoDB();
                                idSoggettoDB.setTipo(s.getTipo());
                                idSoggettoDB.setNome(s.getNome());
                                idSoggettoDB.setCodicePorta(s.getIdentificativoPorta());
                                idSoggettoDB.setId(s.getId());
                                list2.add(idSoggettoDB);
                            }
                        }
                        if (!list2.isEmpty()) {
                            for (IDSoggettoDB soggetto : list2) {
                                listSoggetti.add(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
                            }
                        }
                    }
                    fruitoriLabel = new ArrayList<String>();
                    fruitoriValue = new ArrayList<String>();
                    for (IDSoggetto idSoggetto5 : listSoggetti) {
                        fruitoriLabel.add(this.getLabelNomeSoggetto(idSoggetto5));
                        fruitoriValue.add(idSoggetto5.getTipo() + "/" + idSoggetto5.getNome());
                    }
                    if (policy.getFiltro().getTipoFruitore() != null && policy.getFiltro().getNomeFruitore() != null) {
                        datiIdentificativiFruitoreSelezionatoValue = policy.getFiltro().getTipoFruitore() + "/" + policy.getFiltro().getNomeFruitore();
                    }
                    if (!fruitoriValue.contains(datiIdentificativiFruitoreSelezionatoValue)) {
                        policy.getFiltro().setTipoFruitore(null);
                        policy.getFiltro().setNomeFruitore(null);
                        datiIdentificativiFruitoreSelezionatoValue = null;
                    }
                    fruitoriLabel = this.enrichListConLabelQualsiasi(fruitoriLabel);
                    fruitoriValue = this.enrichListConValueQualsiasi(fruitoriValue);
                }
            } else if (delegata && policy.getFiltro().getTipoFruitore() != null && policy.getFiltro().getNomeFruitore() != null) {
                datiIdentificativiFruitoreSelezionatoValue = policy.getFiltro().getTipoFruitore() + "/" + policy.getFiltro().getNomeFruitore();
            }
            if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                if (policy.getFiltro().getServizioApplicativoFruitore() != null) {
                    servizioApplicativoFruitoreSelezionatoValue = policy.getFiltro().getServizioApplicativoFruitore();
                }
                servizioApplicativoFruitoreSelezionatoLabel = servizioApplicativoFruitoreSelezionatoValue != null ? servizioApplicativoFruitoreSelezionatoValue : "Qualsiasi";
            } else {
                IDSoggetto soggettoProprietarioServiziApplicativi = null;
                if (datiIdentificativiFruitoreSelezionatoValue != null || !configurazione) {
                    String tipoFruitore = null;
                    String nomeFruitore = null;
                    if (datiIdentificativiFruitoreSelezionatoValue != null) {
                        tipoFruitore = policy.getFiltro().getTipoFruitore();
                        nomeFruitore = policy.getFiltro().getNomeFruitore();
                    } else {
                        tipoFruitore = idSoggettoProprietario.getTipo();
                        nomeFruitore = idSoggettoProprietario.getNome();
                    }
                    soggettoProprietarioServiziApplicativi = new IDSoggetto(tipoFruitore, nomeFruitore);
                }
                if (soggettoProprietarioServiziApplicativi != null) {
                    serviziApplicativiFruitoreLabel = new ArrayList<String>();
                    serviziApplicativiFruitoreValue = new ArrayList<String>();
                    List<Object> listSA = null;
                    if (configurazione) {
                        listSA = this.confCore.getServiziApplicativiFruitore(protocolloSelezionatoValue, protocolliValue, soggettoProprietarioServiziApplicativi.getTipo(), soggettoProprietarioServiziApplicativi.getNome());
                    } else {
                        IDSoggetto idSoggettoSelezionato;
                        Soggetto s;
                        boolean isPddEsterna;
                        listSA = new ArrayList();
                        User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                        String string = user.getLogin();
                        boolean isSupportatoAutenticazioneApplicativiEsterni = false;
                        if (protocolloSelezionatoValue != null && !"".equals(protocolloSelezionatoValue)) {
                            isSupportatoAutenticazioneApplicativiEsterni = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocolloSelezionatoValue);
                        }
                        boolean bothSslAndToken = false;
                        List<IDServizioApplicativoDB> listServiziApplicativiTmp = null;
                        if (delegata || !multitenant) {
                            listServiziApplicativiTmp = this.saCore.soggettiServizioApplicativoList(idSoggettoProprietario, string, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR);
                        } else if (policy.getFiltro().getTipoFruitore() != null && policy.getFiltro().getNomeFruitore() != null && (!(isPddEsterna = this.pddCore.isPddEsterna((s = this.soggettiCore.getSoggettoRegistro(idSoggettoSelezionato = new IDSoggetto(policy.getFiltro().getTipoFruitore(), policy.getFiltro().getNomeFruitore()))).getPortaDominio())) || isSupportatoAutenticazioneApplicativiEsterni)) {
                            listServiziApplicativiTmp = this.saCore.soggettiServizioApplicativoList(idSoggettoSelezionato, string, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR);
                        }
                        if (listServiziApplicativiTmp != null && !listServiziApplicativiTmp.isEmpty()) {
                            for (IDServizioApplicativoDB servizioApplicativo : listServiziApplicativiTmp) {
                                IDServizioApplicativo idSA = new IDServizioApplicativo();
                                idSA.setIdSoggettoProprietario(idSoggettoProprietario);
                                idSA.setNome(servizioApplicativo.getNome());
                                listSA.add(idSA);
                            }
                        }
                    }
                    for (IDServizioApplicativo iDServizioApplicativo : listSA) {
                        serviziApplicativiFruitoreLabel.add(iDServizioApplicativo.getNome());
                        serviziApplicativiFruitoreValue.add(iDServizioApplicativo.getNome());
                    }
                    if (policy.getFiltro().getServizioApplicativoFruitore() != null) {
                        servizioApplicativoFruitoreSelezionatoValue = policy.getFiltro().getServizioApplicativoFruitore();
                    }
                    if (!serviziApplicativiFruitoreValue.contains(servizioApplicativoFruitoreSelezionatoValue)) {
                        policy.getFiltro().setServizioApplicativoFruitore(null);
                        servizioApplicativoFruitoreSelezionatoValue = null;
                    }
                    serviziApplicativiFruitoreLabel = this.enrichListConLabelQualsiasi(serviziApplicativiFruitoreLabel);
                    serviziApplicativiFruitoreValue = this.enrichListConValueQualsiasi(serviziApplicativiFruitoreValue);
                }
            }
            tokenClaims = policy.getFiltro().getTokenClaims();
            if (infoPolicy != null) {
                filtroByKey = true;
            }
        }
        DataElement de = new DataElement();
        de.setLabel("Filtro");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        boolean filtroAbilitatoAPI = false;
        if (ruoloPorta != null) {
            boolean first = this.isFirstTimeFromHttpParameters("CTFirstTime");
            if (first) {
                String string = this.toStringCompactFilter(policy.getFiltro(), ruoloPorta, nomePorta, serviceBinding);
                filtroAbilitatoAPI = string != null && !"".equals(string) && !"Disabilitato".equals(string);
            } else {
                String string = this.getParameter("CTPolicyActiveFiltroEnabledConsoleOnly");
                filtroAbilitatoAPI = ServletUtils.isCheckBoxEnabled((String)string);
            }
        }
        if (protocolloAssociatoFiltroNonSelezionatoUtente) {
            this.addToDatiDataElementStatoReadOnly(dati, "CTPolicyActiveFiltroEnabled", "Stato", policy.getFiltro().isEnabled(), true, false, false);
            if (policy.getFiltro().isEnabled()) {
                de = new DataElement();
                de.setType(DataElementType.NOTE);
                de.setValue("Filtro non modificabile poich\u00e8 definito per un " + "Profilo di Interoperabilit\u00e0".toLowerCase() + " non attivo nella console");
                dati.add(de);
            }
        } else {
            boolean hidden = ruoloPorta != null;
            this.addToDatiDataElementStato_postBackViaPOST(dati, "CTPolicyActiveFiltroEnabled", "Stato", policy.getFiltro().isEnabled(), true, false, false, hidden);
            if (ruoloPorta != null) {
                this.addToDatiDataElementStato_postBackViaPOST(dati, "CTPolicyActiveFiltroEnabledConsoleOnly", "Stato", filtroAbilitatoAPI, true, false, false, false);
            }
        }
        boolean filtroEnabled = policy.getFiltro().isEnabled();
        if (ruoloPorta != null) {
            filtroEnabled = filtroAbilitatoAPI;
        }
        if (!filtroEnabled && ruoloPorta != null) {
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroRuoloProtocollo");
            de.setLabel("Profilo");
            de.setValue(protocolloSelezionatoValue);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        if (filtroEnabled) {
            boolean bl;
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroRuoloPdd");
            de.setLabel("Tipologia");
            if (policy.getFiltro().getRuoloPorta() != null) {
                de.setValue(policy.getFiltro().getRuoloPorta().getValue());
            }
            if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (configurazione) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroRuoloPdd___LABEL");
                    de.setLabel("Tipologia");
                    if (policy.getFiltro().getRuoloPorta() != null) {
                        de.setValue(policy.getFiltro().getRuoloPorta().getValue());
                    } else {
                        de.setValue("Qualsiasi");
                    }
                    de.setType(DataElementType.TEXT);
                }
            } else {
                de.setValues(ConfigurazioneCostanti.TIPI_RUOLO_PDD);
                de.setLabels(ConfigurazioneCostanti.LABEL_TIPI_RUOLO_PDD);
                if (policy.getFiltro().getRuoloPorta() != null) {
                    de.setSelected(policy.getFiltro().getRuoloPorta().getValue());
                }
                de.setType(DataElementType.SELECT);
                de.setPostBack_viaPOST(true);
            }
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroRuoloProtocollo");
            de.setLabel("Profilo");
            de.setValue(protocolloSelezionatoValue);
            if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (configurazione) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroRuoloProtocollo___LABEL");
                    de.setLabel("Profilo");
                    de.setValue(protocolloSelezionatoLabel);
                    de.setType(DataElementType.TEXT);
                }
            } else if (protocolliValue != null && protocolliValue.size() > 1) {
                de.setValues(protocolliValue);
                de.setLabels(protocolliLabel);
                de.setSelected(protocolloSelezionatoValue);
                de.setType(DataElementType.SELECT);
                de.setPostBack_viaPOST(true);
            } else {
                de.setType(DataElementType.HIDDEN);
                if (protocolliValue != null && protocolliValue.size() > 0) {
                    dati.add(de);
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroRuoloProtocollo___LABEL");
                    de.setLabel("Profilo");
                    de.setValue(this.getLabelProtocollo(protocolliValue.get(0)));
                    de.setType(DataElementType.TEXT);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroRuoloErogatore");
            de.setLabel("Ruolo Erogatore");
            if (datiIdentificativiErogatoreSelezionatoValue != null) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setValue(ruoloErogatoreSelezionatoValue);
                if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    if (configurazione) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveFiltroRuoloErogatore___LABEL");
                        de.setLabel("Ruolo Erogatore");
                        de.setValue(ruoloErogatoreSelezionatoLabel);
                        de.setType(DataElementType.TEXT);
                    }
                } else {
                    de.setLabels(ruoliErogatoreLabel);
                    de.setValues(ruoliErogatoreValue);
                    de.setSelected(ruoloErogatoreSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroErogatore");
            de.setLabel("Soggetto Erogatore");
            if (ruoloErogatoreSelezionatoValue != null) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setValue(datiIdentificativiErogatoreSelezionatoValue);
                if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    if (configurazione) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveFiltroErogatore___LABEL");
                        de.setLabel("Soggetto Erogatore");
                        de.setValue(datiIdentificativiErogatoreSelezionatoLabel);
                        de.setType(DataElementType.TEXT);
                    }
                } else {
                    de.setLabels(erogatoriLabel);
                    de.setValues(erogatoriValue);
                    de.setSelected(datiIdentificativiErogatoreSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroTag");
            de.setLabel("Tag");
            de.setValue(datiIdentificativiTagSelezionatoValue);
            if (!configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            } else {
                de.setValue(datiIdentificativiTagSelezionatoValue);
                if (this.core.isControlloTrafficoPolicyGlobaleFiltroApi() && datiIdentificativiServizioSelezionatoValue == null) {
                    de.setLabels(tagLabel);
                    de.setValues(tagValue);
                    de.setSelected(datiIdentificativiTagSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroServizio");
            de.setLabel("API");
            de.setValue(datiIdentificativiServizioSelezionatoValue);
            if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (configurazione) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroServizio___LABEL");
                    de.setLabel("API");
                    de.setValue(datiIdentificativiServizioSelezionatoLabel);
                    if (this.core.isControlloTrafficoPolicyGlobaleFiltroApi()) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                }
            } else {
                de.setValue(datiIdentificativiServizioSelezionatoValue);
                if (this.core.isControlloTrafficoPolicyGlobaleFiltroApi()) {
                    de.setLabels(serviziLabel);
                    de.setValues(serviziValue);
                    de.setSelected(datiIdentificativiServizioSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
            }
            dati.add(de);
            boolean bl3 = true;
            if (configurazione && datiIdentificativiServizioSelezionatoValue == null) {
                bl = false;
            }
            if (bl) {
                boolean azioniAll = false;
                boolean first = this.isFirstTimeFromHttpParameters("CTFirstTime");
                if (first) {
                    azioniAll = azioniSelezionataValue == null || azioniSelezionataValue.isEmpty();
                } else if ("CTPolicyActiveFiltroServizio".equals(this.getPostBackElementName()) || "CTPolicyActiveFiltroEnabledConsoleOnly".equals(this.getPostBackElementName())) {
                    azioniAll = true;
                } else {
                    String azioniAllPart = this.getParameter("CTPolicyActiveFiltroAzionePuntuale");
                    azioniAll = ServletUtils.isCheckBoxEnabled((String)azioniAllPart);
                }
                if (!protocolloAssociatoFiltroNonSelezionatoUtente) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroAzionePuntuale");
                    de.setPostBack_viaPOST(true);
                    de.setValues(ConfigurazioneCostanti.PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_FILTRO_AZIONE_PUNTUALE_ALL_VALUES);
                    if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                        de.setLabels(ConfigurazioneCostanti.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_FILTRO_AZIONE_PUNTUALE_RISORSE_ALL_VALUES);
                    } else {
                        de.setLabels(ConfigurazioneCostanti.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_ACTIVE_FILTRO_AZIONE_PUNTUALE_ALL_VALUES);
                    }
                    if (azioniAll) {
                        de.setSelected("yes");
                    } else {
                        de.setSelected("no");
                    }
                    if (serviceBinding != null) {
                        de.setLabel(this.getLabelAzioni(serviceBinding));
                    } else {
                        de.setLabel("Azioni");
                    }
                    de.setType(DataElementType.SELECT);
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("CTPolicyActiveFiltroAzione");
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    if (serviceBinding != null) {
                        de.setLabel(this.getLabelAzioni(serviceBinding));
                    } else {
                        de.setLabel("Azioni");
                    }
                } else {
                    de.setLabel("");
                }
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    de.setValue(policy.getFiltro().getAzione());
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroAzione___LABEL");
                    if (serviceBinding != null) {
                        de.setLabel(this.getLabelAzioni(serviceBinding));
                    } else {
                        de.setLabel("Azioni");
                    }
                    if (azioniSelezionataLabel != null && !azioniSelezionataLabel.isEmpty()) {
                        if (azioniSelezionataLabel.size() == 1) {
                            de.setValue((String)azioniSelezionataLabel.get(0));
                        } else {
                            de.setValue(((Object)azioniSelezionataLabel).toString());
                        }
                    }
                    de.setType(DataElementType.TEXT);
                } else if (!azioniAll) {
                    de.setLabels(azioniLabel);
                    de.setValues(azioniValue);
                    de.setSelezionati(azioniSelezionataValue);
                    de.setType(DataElementType.MULTI_SELECT);
                    if (azioniValue != null && azioniValue.size() <= 10) {
                        if (azioniValue.size() <= 3) {
                            de.setRows(3);
                        } else {
                            de.setRows(azioniValue.size());
                        }
                    } else {
                        de.setRows(10);
                    }
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                dati.add(de);
            }
            if (serviziApplicativiErogatoreValue != null) {
                de = new DataElement();
                de.setName("CTPolicyActiveFiltroSAErogatore");
                de.setLabel("Applicativo Erogatore");
                de.setValue(servizioApplicativoErogatoreSelezionatoValue);
                if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    if (configurazione) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveFiltroSAErogatore___LABEL");
                        de.setLabel("Applicativo Erogatore");
                        de.setValue(servizioApplicativoErogatoreSelezionatoLabel);
                        de.setType(DataElementType.HIDDEN);
                    }
                } else {
                    de.setLabels(serviziApplicativiErogatoreLabel);
                    de.setValues(serviziApplicativiErogatoreValue);
                    de.setSelected(servizioApplicativoErogatoreSelezionatoValue);
                    de.setValue(servizioApplicativoErogatoreSelezionatoValue);
                    de.setType(DataElementType.HIDDEN);
                    de.setPostBack_viaPOST(true);
                }
                dati.add(de);
            }
            boolean showRuoloRichiedente = false;
            if (configurazione) {
                showRuoloRichiedente = true;
                if (infoPolicy != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa())) {
                    showRuoloRichiedente = false;
                }
            } else if (infoPolicy != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa())) {
                showRuoloRichiedente = false;
            } else if (serviziApplicativiFruitoreValue != null && serviziApplicativiFruitoreValue.size() > 1) {
                showRuoloRichiedente = true;
            } else if (fruitoriValue != null && fruitoriValue.size() > 1) {
                showRuoloRichiedente = true;
            }
            de = new DataElement();
            de.setName("CTPolicyActiveFiltroRuoloFruitore");
            de.setLabel("Ruolo Richiedente");
            if (datiIdentificativiFruitoreSelezionatoValue != null && !delegata || servizioApplicativoFruitoreSelezionatoValue != null || !showRuoloRichiedente) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setValue(ruoloFruitoreSelezionatoValue);
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    if (configurazione) {
                        de = new DataElement();
                        de.setName("CTPolicyActiveFiltroRuoloFruitore___LABEL");
                        de.setLabel("Ruolo Richiedente");
                        de.setValue(ruoloFruitoreSelezionatoLabel);
                        de.setType(DataElementType.TEXT);
                    }
                } else {
                    de.setLabels(ruoliFruitoreLabel);
                    de.setValues(ruoliFruitoreValue);
                    de.setSelected(ruoloFruitoreSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                }
            }
            dati.add(de);
            if (!(fruitoriValue == null || fruitoriValue.size() <= 1 || infoPolicy != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa()))) {
                de = new DataElement();
                de.setName("CTPolicyActiveFiltroFruitore");
                de.setLabel("Soggetto Fruitore");
                if (ruoloFruitoreSelezionatoValue != null) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setValue(datiIdentificativiFruitoreSelezionatoValue);
                    if (protocolloAssociatoFiltroNonSelezionatoUtente || delegata) {
                        de.setType(DataElementType.HIDDEN);
                        dati.add(de);
                        if (configurazione) {
                            de = new DataElement();
                            de.setName("CTPolicyActiveFiltroFruitore___LABEL");
                            de.setLabel("Soggetto Fruitore");
                            de.setValue(datiIdentificativiFruitoreSelezionatoLabel);
                            de.setType(DataElementType.TEXT);
                        }
                    } else {
                        de.setLabels(fruitoriLabel);
                        de.setValues(fruitoriValue);
                        de.setSelected(datiIdentificativiFruitoreSelezionatoValue);
                        de.setType(DataElementType.SELECT);
                        de.setPostBack_viaPOST(true);
                    }
                }
                dati.add(de);
            }
            if (!(serviziApplicativiFruitoreValue == null || serviziApplicativiFruitoreValue.size() <= 1 || infoPolicy != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa()))) {
                de = new DataElement();
                de.setName("CTPolicyActiveFiltroSAFruitore");
                de.setLabel("Applicativo Fruitore");
                if (ruoloFruitoreSelezionatoValue != null) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setValue(servizioApplicativoFruitoreSelezionatoValue);
                    if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                        de.setType(DataElementType.HIDDEN);
                        dati.add(de);
                        if (configurazione) {
                            de = new DataElement();
                            de.setName("CTPolicyActiveFiltroSAFruitore___LABEL");
                            de.setLabel("Applicativo Fruitore");
                            de.setValue(servizioApplicativoFruitoreSelezionatoLabel);
                            de.setType(DataElementType.TEXT);
                        }
                    } else {
                        de.setLabels(serviziApplicativiFruitoreLabel);
                        de.setValues(serviziApplicativiFruitoreValue);
                        de.setSelected(servizioApplicativoFruitoreSelezionatoValue);
                        de.setType(DataElementType.SELECT);
                        de.setPostBack_viaPOST(true);
                    }
                }
                dati.add(de);
            }
            if (tokenAbilitato) {
                de = new DataElement();
                de.setLabel("Token Claims");
                de.setNote("Indicare per riga i claims richiesti (nome=valore)");
                de.setName("CTPolicyActiveFiltroTokenClaims");
                de.setValue(tokenClaims);
                de.setType(DataElementType.TEXT_AREA);
                de.setRows(6);
                de.setCols(55);
                dati.add(de);
            }
            if (filtroByKey) {
                if (policy.getFiltro().isInformazioneApplicativaEnabled()) {
                    de = new DataElement();
                    de.setValue("Filtro per Chiave");
                    de.setType(DataElementType.NOTE);
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("CTPolicyActiveFiltroPerChiaveEnabled");
                if (policy.getFiltro().isInformazioneApplicativaEnabled()) {
                    de.setLabel("Stato");
                } else {
                    de.setLabel("Chiave");
                }
                de.setValue("" + policy.getFiltro().isInformazioneApplicativaEnabled());
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroPerChiaveEnabled___LABEL");
                    if (policy.getFiltro().isInformazioneApplicativaEnabled()) {
                        de.setLabel("Stato");
                    } else {
                        de.setLabel("Filtro per Chiave");
                    }
                    if (policy.getFiltro().isInformazioneApplicativaEnabled()) {
                        de.setValue("Abilitato");
                    } else {
                        de.setValue("Disabilitato");
                    }
                    de.setType(DataElementType.TEXT);
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(policy.getFiltro().isInformazioneApplicativaEnabled());
                    de.setPostBack_viaPOST(true);
                }
                dati.add(de);
                if (policy.getFiltro().isInformazioneApplicativaEnabled()) {
                    TipoFiltroApplicativo tipoFiltro = null;
                    if (policy.getFiltro().getInformazioneApplicativaTipo() != null && !"".equals(policy.getFiltro().getInformazioneApplicativaTipo())) {
                        tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)policy.getFiltro().getInformazioneApplicativaTipo());
                    }
                    if (tipoFiltro == null) {
                        tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_FILTRO_PER_CHIAVE_TIPO_DEFAULT);
                    }
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroPerChiaveTipo");
                    de.setLabel("Tipologia");
                    de.setValue(policy.getFiltro().getInformazioneApplicativaTipo());
                    if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                        de.setType(DataElementType.HIDDEN);
                        dati.add(de);
                        de = new DataElement();
                        de.setName("CTPolicyActiveFiltroPerChiaveTipo___LABEL");
                        de.setLabel("Tipologia");
                        de.setValue(policy.getFiltro().getInformazioneApplicativaTipo());
                        de.setType(DataElementType.TEXT);
                    } else {
                        if (infoPolicy != null && TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)infoPolicy.getTipoRisorsa())) {
                            String[] arr = TipoFiltroApplicativo.toStringArray();
                            ArrayList<String> values = new ArrayList<String>();
                            for (String v : arr) {
                                if (TipoFiltroApplicativo.CONTENT_BASED.equals(v)) continue;
                                values.add(v);
                            }
                            de.setValues(values);
                            de.setLabels(ConfigurazioneCostanti.LABEL_RATE_LIMITING_FILTRO_APPLICATIVO_SENZA_CONTENUTO);
                        } else {
                            de.setValues(TipoFiltroApplicativo.toStringArray());
                            de.setLabels(ConfigurazioneCostanti.LABEL_RATE_LIMITING_FILTRO_APPLICATIVO);
                        }
                        de.setSelected(policy.getFiltro().getInformazioneApplicativaTipo());
                        de.setType(DataElementType.SELECT);
                        de.setPostBack_viaPOST(true);
                    }
                    dati.add(de);
                    if (TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)tipoFiltro)) {
                        this.addCustomField(TipoPlugin.RATE_LIMITING, null, null, "CTPolicyActiveFiltroPerChiaveTipo", "CTPolicyActiveFiltroPerChiaveNome", this.getLabelTipoInformazioneApplicativaFiltro(policy.getFiltro().getInformazioneApplicativaTipo()), policy.getFiltro().getInformazioneApplicativaNome(), false, dati, true);
                    } else {
                        de = new DataElement();
                        de.setName("CTPolicyActiveFiltroPerChiaveNome");
                        de.setLabel(this.getLabelTipoInformazioneApplicativaFiltro(policy.getFiltro().getInformazioneApplicativaTipo()));
                        de.setValue(policy.getFiltro().getInformazioneApplicativaNome());
                        if (tipoFiltro == null || TipoFiltroApplicativo.SOAPACTION_BASED.equals((Object)tipoFiltro) || TipoFiltroApplicativo.INDIRIZZO_IP.equals((Object)tipoFiltro) || TipoFiltroApplicativo.INDIRIZZO_IP_FORWARDED.equals((Object)tipoFiltro)) {
                            de.setType(DataElementType.HIDDEN);
                        } else if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                            de.setType(DataElementType.TEXT);
                        } else {
                            de.setRequired(true);
                            if (TipoFiltroApplicativo.URLBASED.equals((Object)tipoFiltro) || TipoFiltroApplicativo.CONTENT_BASED.equals((Object)tipoFiltro)) {
                                de.setType(DataElementType.TEXT_AREA);
                            } else {
                                de.setType(DataElementType.TEXT_EDIT);
                            }
                        }
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setName("CTPolicyActiveFiltroPerChiaveValore");
                    de.setLabel("Valore");
                    de.setValue(StringEscapeUtils.escapeHtml4((String)policy.getFiltro().getInformazioneApplicativaValore()));
                    if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                        de.setType(DataElementType.HIDDEN);
                        dati.add(de);
                        de = new DataElement();
                        de.setName("CTPolicyActiveFiltroPerChiaveValore___LABEL");
                        de.setLabel("Valore");
                        de.setValue(StringEscapeUtils.escapeHtml4((String)policy.getFiltro().getInformazioneApplicativaValore()));
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setRequired(true);
                        de.setType(DataElementType.TEXT_EDIT);
                    }
                    dati.add(de);
                    if (infoPolicy != null && infoPolicy.isIntervalloUtilizzaRisorseStatistiche()) {
                        de = new DataElement();
                        de.setType(DataElementType.NOTE);
                        de.setBold(true);
                        de.setLabel("Nota");
                        de.setValue("Il filtro per chiave, su campionamento statistico, serve solamente a filtrare l'applicabilit\u00e0 della policy.<BR/>Verranno conteggiate anche le richieste che non hanno un match con il filtro per chiave indicato.");
                        dati.add(de);
                    }
                }
            }
        }
    }

    private void addToDatiAttivazioneGroupBy(List<DataElement> dati, TipoOperazione tipoOperazione, AttivazionePolicy policy, String nomeSezione, InfoPolicy infoPolicy, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding, boolean tokenAbilitato) throws Exception {
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPolicy.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        List<String> protocolli = null;
        boolean groupByKey = false;
        if (policy != null && policy.getGroupBy() != null && policy.getGroupBy().isEnabled()) {
            protocolli = this.confCore.getProtocolli();
            if (infoPolicy != null && !infoPolicy.isIntervalloUtilizzaRisorseStatistiche() && !infoPolicy.isDegradoPrestazionaleUtilizzaRisorseStatistiche()) {
                groupByKey = true;
            }
        }
        DataElement de = new DataElement();
        de.setLabel("Raggruppamento");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setValue("Se abilitato, il calcolo del valore della soglia avviene raggruppando le richieste in funzione dei criteri selezionati");
        de.setType(DataElementType.NOTE);
        dati.add(de);
        boolean policyGropuByEnabled = policy != null && policy.getGroupBy() != null && policy.getGroupBy().isEnabled();
        this.addToDatiDataElementStato_postBackViaPOST(dati, "CTPolicyActiveGroupByEnabled", "Stato", policyGropuByEnabled, true, false, false, false);
        if (policyGropuByEnabled) {
            if (configurazione) {
                boolean showErogatore;
                boolean showRuoloPdD = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getRuoloPorta() == null || RuoloPolicy.ENTRAMBI.equals((Object)policy.getFiltro().getRuoloPorta());
                boolean showProtocollo = protocolli.size() > 1 && (policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getProtocollo() == null);
                boolean bl = showErogatore = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getTipoErogatore() == null || policy.getFiltro().getNomeErogatore() == null;
                if (showRuoloPdD || showProtocollo || showErogatore) {
                    // empty if block
                }
                if (showRuoloPdD) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveGroupByRuoloPdd");
                    de.setLabel("Fruizione / Erogazione");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(policy.getGroupBy().isRuoloPorta());
                    de.setValue("" + policy.getGroupBy().isRuoloPorta());
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("CTPolicyActiveGroupByRuoloProtocollo");
                de.setLabel("Profilo");
                if (showProtocollo) {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(policy.getGroupBy().isProtocollo());
                    de.setValue("" + policy.getGroupBy().isProtocollo());
                } else {
                    de.setType(DataElementType.HIDDEN);
                    if (protocolli.size() == 1) {
                        de.setValue("false");
                    }
                }
                dati.add(de);
                if (showErogatore) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveGroupByErogatore");
                    de.setLabel("Soggetto Erogatore");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(policy.getGroupBy().isErogatore());
                    de.setValue("" + policy.getGroupBy().isErogatore());
                    dati.add(de);
                }
            }
            boolean showServizio = false;
            boolean showAzione = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getAzione() == null || "".equals(policy.getFiltro().getAzione()) || policy.getFiltro().getAzione().contains(",");
            boolean showSAErogatore = false;
            if (configurazione) {
                if (this.core.isControlloTrafficoPolicyGlobaleGroupByApi()) {
                    boolean bl = showServizio = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getTipoServizio() == null || policy.getFiltro().getNomeServizio() == null;
                }
                if (showAzione) {
                    showAzione = showServizio && policy.getGroupBy().isServizio();
                }
                boolean bl = showSAErogatore = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getRuoloPorta() == null || RuoloPolicy.ENTRAMBI.equals((Object)policy.getFiltro().getRuoloPorta()) || RuoloPolicy.APPLICATIVA.equals((Object)policy.getFiltro().getRuoloPorta());
                if (showSAErogatore) {
                    boolean bl2 = showSAErogatore = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getServizioApplicativoErogatore() == null;
                }
                if (!showServizio && !showAzione && !showSAErogatore || configurazione) {
                    // empty if block
                }
                if (showServizio) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveGroupByServizio");
                    de.setLabel("API");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(policy.getGroupBy().isServizio());
                    de.setValue("" + policy.getGroupBy().isServizio());
                    de.setPostBack_viaPOST(true);
                    dati.add(de);
                }
            }
            de = new DataElement();
            de.setName("CTPolicyActiveGroupByAzione");
            if (serviceBinding != null) {
                de.setLabel(this.getLabelAzione(serviceBinding));
            } else {
                de.setLabel("Azione");
            }
            if (showAzione) {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(policy.getGroupBy().isAzione());
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue("" + policy.getGroupBy().isAzione());
            dati.add(de);
            if (configurazione && showSAErogatore) {
                de = new DataElement();
                de.setName("CTPolicyActiveGroupBySAErogatore");
                de.setLabel("Applicativo Erogatore");
                de.setType(DataElementType.HIDDEN);
                de.setSelected(policy.getGroupBy().isServizioApplicativoErogatore());
                de.setValue("" + policy.getGroupBy().isServizioApplicativoErogatore());
                dati.add(de);
            }
            if (configurazione) {
                // empty if block
            }
            if (configurazione) {
                boolean showRichiedenteApplicativo;
                boolean showFruitore;
                boolean bl = showFruitore = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getTipoFruitore() == null || policy.getFiltro().getNomeFruitore() == null;
                if (showFruitore) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveGroupByFruitore");
                    de.setLabel("Soggetto Fruitore");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(policy.getGroupBy().isFruitore());
                    de.setValue("" + policy.getGroupBy().isFruitore());
                    dati.add(de);
                }
                boolean bl3 = showRichiedenteApplicativo = policy.getFiltro() == null || !policy.getFiltro().isEnabled() || policy.getFiltro().getRuoloPorta() == null || policy.getFiltro().getServizioApplicativoFruitore() == null;
                if (showRichiedenteApplicativo) {
                    de = new DataElement();
                    de.setName("CTPolicyActiveGroupBySAFruitore");
                    de.setLabel("Applicativo Fruitore");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(policy.getGroupBy().isServizioApplicativoFruitore());
                    de.setValue("" + policy.getGroupBy().isServizioApplicativoFruitore());
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setName("CTPolicyActiveGroupByRichiedente");
                de.setLabel("Richiedente");
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(policy.getGroupBy().isIdentificativoAutenticato());
                de.setValue("" + policy.getGroupBy().isIdentificativoAutenticato());
                dati.add(de);
            }
            if (tokenAbilitato) {
                boolean first = this.isFirstTimeFromHttpParameters("CTFirstTime");
                String token = this.getParameter("CTPolicyActiveGroupByToken");
                String[] tokenSelezionatiDB = null;
                if (policy.getGroupBy().getToken() != null && !"".equals(policy.getGroupBy().getToken())) {
                    tokenSelezionatiDB = policy.getGroupBy().getToken().split(",");
                }
                String[] tokenSelezionatiSenzaIssuer = null;
                if (tokenSelezionatiDB != null && tokenSelezionatiDB.length > 0) {
                    ArrayList<String> l = new ArrayList<String>();
                    for (int i = 0; i < tokenSelezionatiDB.length; ++i) {
                        TipoCredenzialeMittente tipo = TipoCredenzialeMittente.toEnumConstant((String)tokenSelezionatiDB[i], (boolean)true);
                        if (TipoCredenzialeMittente.TOKEN_ISSUER.equals((Object)tipo)) continue;
                        l.add(tokenSelezionatiDB[i]);
                    }
                    if (!l.isEmpty()) {
                        tokenSelezionatiSenzaIssuer = l.toArray(new String[1]);
                    }
                }
                boolean groupByToken = false;
                groupByToken = first ? tokenSelezionatiDB != null && tokenSelezionatiDB.length > 0 : ServletUtils.isCheckBoxEnabled((String)token);
                de = new DataElement();
                de.setName("CTPolicyActiveGroupByToken");
                de.setLabel("Token");
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(groupByToken);
                de.setValue("" + groupByToken);
                de.setPostBack_viaPOST(true);
                dati.add(de);
                if (groupByToken) {
                    boolean modiPdnd;
                    de = new DataElement();
                    de.setName("CTPolicyActiveGroupByTokenClaims");
                    de.setLabel("Claims");
                    boolean bl = modiPdnd = applicativa && policy.getFiltro() != null && "modipa".equals(policy.getFiltro().getProtocollo());
                    if (modiPdnd) {
                        de.setValues(CostantiControlStation.TOKEN_VALUES_WITHOUT_ISSUER_CON_PDND_INFO);
                        de.setLabels(CostantiControlStation.LABEL_TOKEN_VALUES_WITHOUT_ISSUER_CON_PDND);
                    } else {
                        de.setValues(CostantiControlStation.TOKEN_VALUES_WITHOUT_ISSUER);
                        de.setLabels(CostantiControlStation.LABEL_TOKEN_VALUES_WITHOUT_ISSUER);
                    }
                    de.setSelezionati(tokenSelezionatiSenzaIssuer);
                    de.setType(DataElementType.MULTI_SELECT);
                    if (modiPdnd) {
                        de.setRows(5);
                    } else {
                        de.setRows(4);
                    }
                    de.setRequired(true);
                    dati.add(de);
                }
            }
            if (groupByKey) {
                if (policy.getGroupBy().isInformazioneApplicativaEnabled()) {
                    de = new DataElement();
                    de.setValue("Raggruppamento per Chiave");
                    de.setType(DataElementType.NOTE);
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("CTPolicyActiveGroupByPerChiaveEnabled");
                if (policy.getGroupBy().isInformazioneApplicativaEnabled()) {
                    de.setLabel("Stato");
                } else {
                    de.setLabel("Chiave");
                }
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(policy.getGroupBy().isInformazioneApplicativaEnabled());
                de.setValue("" + policy.getGroupBy().isInformazioneApplicativaEnabled());
                de.setPostBack_viaPOST(true);
                dati.add(de);
                if (policy.getGroupBy().isInformazioneApplicativaEnabled()) {
                    TipoFiltroApplicativo tipoChiaveGroupBy = null;
                    if (policy.getGroupBy().getInformazioneApplicativaTipo() != null && !"".equals(policy.getGroupBy().getInformazioneApplicativaTipo())) {
                        tipoChiaveGroupBy = TipoFiltroApplicativo.toEnumConstant((String)policy.getGroupBy().getInformazioneApplicativaTipo());
                    }
                    if (tipoChiaveGroupBy == null) {
                        tipoChiaveGroupBy = TipoFiltroApplicativo.toEnumConstant((String)ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_GROUPBY_PER_CHIAVE_TIPO_DEFAULT);
                    }
                    de = new DataElement();
                    de.setName("CTPolicyActiveGroupByPerChiaveTipo");
                    de.setLabel("Tipologia");
                    de.setValues(TipoFiltroApplicativo.toStringArray());
                    de.setLabels(ConfigurazioneCostanti.LABEL_RATE_LIMITING_FILTRO_APPLICATIVO);
                    de.setSelected(policy.getGroupBy().getInformazioneApplicativaTipo());
                    de.setValue(policy.getGroupBy().getInformazioneApplicativaTipo());
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                    dati.add(de);
                    if (TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)tipoChiaveGroupBy)) {
                        this.addCustomField(TipoPlugin.RATE_LIMITING, null, null, "CTPolicyActiveGroupByPerChiaveTipo", "CTPolicyActiveGroupByPerChiaveNome", this.getLabelTipoInformazioneApplicativaGroupBy(policy.getGroupBy().getInformazioneApplicativaTipo()), policy.getGroupBy().getInformazioneApplicativaNome(), false, dati, true);
                    } else {
                        de = new DataElement();
                        de.setName("CTPolicyActiveGroupByPerChiaveNome");
                        de.setLabel(this.getLabelTipoInformazioneApplicativaGroupBy(policy.getGroupBy().getInformazioneApplicativaTipo()));
                        de.setValue(policy.getGroupBy().getInformazioneApplicativaNome());
                        if (tipoChiaveGroupBy == null || TipoFiltroApplicativo.SOAPACTION_BASED.equals((Object)tipoChiaveGroupBy) || TipoFiltroApplicativo.INDIRIZZO_IP.equals((Object)tipoChiaveGroupBy) || TipoFiltroApplicativo.INDIRIZZO_IP_FORWARDED.equals((Object)tipoChiaveGroupBy)) {
                            de.setType(DataElementType.HIDDEN);
                        } else if (TipoFiltroApplicativo.URLBASED.equals((Object)tipoChiaveGroupBy) || TipoFiltroApplicativo.CONTENT_BASED.equals((Object)tipoChiaveGroupBy)) {
                            de.setRequired(true);
                            de.setType(DataElementType.TEXT_AREA);
                        } else {
                            de.setRequired(true);
                            de.setType(DataElementType.TEXT_EDIT);
                        }
                        dati.add(de);
                    }
                }
            }
        }
    }

    private List<String> enrichListConLabelQualsiasi(List<String> l) {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add("Qualsiasi");
        if (l != null && l.size() > 0) {
            newList.addAll(l);
        }
        return newList;
    }

    private List<String> enrichListConValueQualsiasi(List<String> l) {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add("-*-");
        if (l != null && l.size() > 0) {
            newList.addAll(l);
        }
        return newList;
    }

    public String getLabelTipoInformazioneApplicativaFiltro(String tipoInformazioneApplicativa) {
        TipoFiltroApplicativo tipo = TipoFiltroApplicativo.toEnumConstant((String)ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_FILTRO_PER_CHIAVE_TIPO_DEFAULT);
        if (tipoInformazioneApplicativa != null) {
            tipo = TipoFiltroApplicativo.toEnumConstant((String)tipoInformazioneApplicativa);
        }
        switch (tipo) {
            case HEADER_BASED: {
                return ModalitaIdentificazione.HEADER_BASED.getLabelParametro();
            }
            case FORM_BASED: {
                return ModalitaIdentificazione.FORM_BASED.getLabelParametro();
            }
            case CONTENT_BASED: {
                return ModalitaIdentificazione.CONTENT_BASED.getLabelParametro();
            }
            case URLBASED: {
                return ModalitaIdentificazione.URL_BASED.getLabelParametro();
            }
            case SOAPACTION_BASED: {
                return ModalitaIdentificazione.SOAP_ACTION_BASED.getLabelParametro();
            }
            case INDIRIZZO_IP: {
                return ModalitaIdentificazione.INDIRIZZO_IP_BASED.getLabelParametro();
            }
            case INDIRIZZO_IP_FORWARDED: {
                return ModalitaIdentificazione.X_FORWARD_FOR_BASED.getLabelParametro();
            }
            case PLUGIN_BASED: {
                return ModalitaIdentificazione.PLUGIN_BASED.getLabelParametro();
            }
        }
        return null;
    }

    public String getLabelTipoInformazioneApplicativaGroupBy(String tipoInformazioneApplicativa) {
        TipoFiltroApplicativo tipo = TipoFiltroApplicativo.toEnumConstant((String)ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_GROUPBY_PER_CHIAVE_TIPO_DEFAULT);
        if (tipoInformazioneApplicativa != null) {
            tipo = TipoFiltroApplicativo.toEnumConstant((String)tipoInformazioneApplicativa);
        }
        switch (tipo) {
            case HEADER_BASED: {
                return ModalitaIdentificazione.HEADER_BASED.getLabelParametro();
            }
            case FORM_BASED: {
                return ModalitaIdentificazione.FORM_BASED.getLabelParametro();
            }
            case CONTENT_BASED: {
                return ModalitaIdentificazione.CONTENT_BASED.getLabelParametro();
            }
            case URLBASED: {
                return ModalitaIdentificazione.URL_BASED.getLabelParametro();
            }
            case SOAPACTION_BASED: {
                return ModalitaIdentificazione.SOAP_ACTION_BASED.getLabelParametro();
            }
            case INDIRIZZO_IP: {
                return ModalitaIdentificazione.INDIRIZZO_IP_BASED.getLabelParametro();
            }
            case INDIRIZZO_IP_FORWARDED: {
                return ModalitaIdentificazione.X_FORWARD_FOR_BASED.getLabelParametro();
            }
            case PLUGIN_BASED: {
                return ModalitaIdentificazione.PLUGIN_BASED.getLabelParametro();
            }
        }
        return null;
    }

    public boolean attivazionePolicyCheckData(StringBuilder sbParsingError, TipoOperazione tipoOperazione, ConfigurazioneGenerale configurazioneControlloTraffico, AttivazionePolicy policy, InfoPolicy infoPolicy, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding, String modalita) throws Exception {
        if (sbParsingError.length() > 0) {
            this.pd.setMessage(sbParsingError.toString());
            return false;
        }
        boolean check = this.checkAttivazionePolicy(configurazioneControlloTraffico, policy, infoPolicy, serviceBinding);
        if (!check) {
            return false;
        }
        StringBuilder existsMessage = new StringBuilder();
        boolean alreadyExists = ConfigurazioneUtilities.alreadyExists(tipoOperazione, this.confCore, this, policy, infoPolicy, ruoloPorta, nomePorta, serviceBinding, existsMessage, "<br/>", modalita);
        if (alreadyExists) {
            this.pd.setMessage(existsMessage.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAttivazionePolicy(ConfigurazioneGenerale c, AttivazionePolicy policy, InfoPolicy infoPolicy, ServiceBinding serviceBinding) throws Exception {
        String messaggio;
        if (policy.getIdPolicy() == null || "".equals(policy.getIdPolicy()) || "-".equals(policy.getIdPolicy())) {
            String messaggio2 = "Deve essere selezionata una policy in 'Policy'";
            this.pd.setMessage(messaggio2);
            return false;
        }
        if (policy.getAlias() != null && !"".equals(policy.getAlias())) {
            if (!this.checkLength255(policy.getAlias(), "Nome")) {
                return false;
            }
            if (!this.checkNCName(policy.getAlias(), "Nome")) {
                return false;
            }
        } else {
            String messaggio3 = "Deve essere indicato un nome";
            this.pd.setMessage(messaggio3);
            return false;
        }
        if (policy.isRidefinisci() && infoPolicy != null) {
            TipoRisorsa tipoRisorsa = infoPolicy.getTipoRisorsa();
            String name = "Num. Massimo Richieste";
            if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                name = "Dimensione Risposta";
            } else if (TipoRisorsa.OCCUPAZIONE_BANDA.equals((Object)tipoRisorsa)) {
                name = "Occupazione Massima";
            } else if (TipoRisorsa.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoRisorsa)) {
                name = "Tempo Medio di Risposta";
            } else if (TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.equals((Object)tipoRisorsa)) {
                name = "Tempo Risposta";
            }
            if (policy.getValore() == null) {
                String messaggio4 = "Deve essere indicato un valore in '" + name + "'";
                this.pd.setMessage(messaggio4);
                return false;
            }
            long l = policy.getValore();
            try {
                if (l <= 0L) {
                    throw new DriverControlStationException("Valore non nell'intervallo");
                }
            }
            catch (Exception e) {
                String max = "9223372036854775807";
                if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                    max = "2147483647";
                }
                String messaggio5 = "Il valore (" + policy.getValore() + ") indicato in '" + name + "' deve essere un numero intero maggiore di 0 e minore di " + max;
                this.pd.setMessage(messaggio5);
                return false;
            }
            if (TipoRisorsa.NUMERO_RICHIESTE.equals((Object)tipoRisorsa) && infoPolicy.isCheckRichiesteSimultanee() && c.getControlloTraffico().isControlloMaxThreadsEnabled() && l > c.getControlloTraffico().getControlloMaxThreadsSoglia()) {
                String messaggio6 = "Deve essere indicato un valore in '" + name + "' minore di quanto indicato nella configurazione generale alla voce 'Max Richieste Simultanee'";
                this.pd.setMessage(messaggio6);
                return false;
            }
            if (TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.equals((Object)tipoRisorsa)) {
                name = "Dimensione Richiesta";
                if (policy.getValore2() == null) {
                    String messaggio7 = "Deve essere indicato un valore in '" + name + "'";
                    this.pd.setMessage(messaggio7);
                    return false;
                }
                l = policy.getValore2();
                try {
                    if (l <= 0L) {
                        throw new DriverControlStationException("Valore non nell'intervallo");
                    }
                }
                catch (Exception e) {
                    String messaggio8 = "Il valore (" + policy.getValore2() + ") indicato in '" + name + "' deve essere un numero intero maggiore di 0 e minore di 2147483647";
                    this.pd.setMessage(messaggio8);
                    return false;
                }
            }
        }
        if (policy.getFiltro().isEnabled()) {
            if ((policy.getFiltro().getRuoloPorta() == null || RuoloPolicy.ENTRAMBI.equals((Object)policy.getFiltro().getRuoloPorta())) && policy.getFiltro().getProtocollo() == null && policy.getFiltro().getRuoloFruitore() == null && policy.getFiltro().getTipoFruitore() == null && policy.getFiltro().getNomeFruitore() == null && policy.getFiltro().getServizioApplicativoFruitore() == null && policy.getFiltro().getRuoloErogatore() == null && policy.getFiltro().getTipoErogatore() == null && policy.getFiltro().getNomeErogatore() == null && policy.getFiltro().getServizioApplicativoErogatore() == null && policy.getFiltro().getTag() == null && policy.getFiltro().getTipoServizio() == null && policy.getFiltro().getNomeServizio() == null && policy.getFiltro().getAzione() == null && policy.getFiltro().getTokenClaims() == null && !policy.getFiltro().isInformazioneApplicativaEnabled()) {
                String messaggio9 = "Se si abilita il filtro deve essere selezionato almeno un criterio";
                this.pd.setMessage(messaggio9);
                return false;
            }
            if (policy.getFiltro().getTokenClaims() != null && !"".equals(policy.getFiltro().getTokenClaims())) {
                try (Scanner scanner = new Scanner(policy.getFiltro().getTokenClaims());){
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (line == null || line.trim().equals("")) continue;
                        if (line.contains("=")) continue;
                        this.pd.setMessage("I claims in ogni riga devono essere indicati come coppia (nome=valore); non \u00e8 stato riscontrato il carattere separatore '='");
                        boolean l = false;
                        return l;
                    }
                }
            }
            if (policy.getFiltro().isInformazioneApplicativaEnabled()) {
                TipoFiltroApplicativo tipo = TipoFiltroApplicativo.toEnumConstant((String)ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_FILTRO_PER_CHIAVE_TIPO_DEFAULT);
                if (policy.getFiltro().getInformazioneApplicativaTipo() != null) {
                    tipo = TipoFiltroApplicativo.toEnumConstant((String)policy.getFiltro().getInformazioneApplicativaTipo());
                }
                if (!(TipoFiltroApplicativo.SOAPACTION_BASED.equals((Object)tipo) || TipoFiltroApplicativo.INDIRIZZO_IP.equals((Object)tipo) || TipoFiltroApplicativo.INDIRIZZO_IP_FORWARDED.equals((Object)tipo))) {
                    String label = "'Filtro per Chiave - " + this.getLabelTipoInformazioneApplicativaFiltro(policy.getFiltro().getInformazioneApplicativaTipo()) + "'";
                    if (policy.getFiltro().getInformazioneApplicativaNome() == null || "--".equals(policy.getFiltro().getInformazioneApplicativaNome())) {
                        Object messaggio10 = null;
                        messaggio10 = TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)tipo) && this.confCore.isConfigurazionePluginsEnabled() ? "Non &egrave; stato selezionato nessun plugin da utilizzare come filtro per chiave" : "Deve essere indicato un valore in " + label;
                        this.pd.setMessage((String)messaggio10);
                        return false;
                    }
                    if (TipoFiltroApplicativo.URLBASED.equals((Object)tipo) && !this.checkRegexp(policy.getFiltro().getInformazioneApplicativaNome(), label)) {
                        return false;
                    }
                    if (TipoFiltroApplicativo.CONTENT_BASED.equals((Object)tipo) && (ServiceBinding.SOAP.equals((Object)serviceBinding) ? !this.checkXPath(policy.getFiltro().getInformazioneApplicativaNome(), label) : !this.checkXPathOrJsonPath(policy.getFiltro().getInformazioneApplicativaNome(), label))) {
                        return false;
                    }
                }
                if (policy.getFiltro().getInformazioneApplicativaValore() == null) {
                    messaggio = "Deve essere indicato un valore in 'Filtro per Chiave - Valore'";
                    this.pd.setMessage(messaggio);
                    return false;
                }
            }
        }
        if (policy.getGroupBy().isEnabled()) {
            String[] tokenSelezionati;
            String token = this.getParameter("CTPolicyActiveGroupByToken");
            if (ServletUtils.isCheckBoxEnabled((String)token) && ((tokenSelezionati = this.getParameterValues("CTPolicyActiveGroupByTokenClaims")) == null || tokenSelezionati.length <= 0)) {
                String messaggio11 = "Se si abilita il raggruppamento per token deve essere selezionato almeno un claim";
                this.pd.setMessage(messaggio11);
                return false;
            }
            if (!(policy.getGroupBy().isRuoloPorta() || policy.getGroupBy().getProtocollo() || policy.getGroupBy().getFruitore() || policy.getGroupBy().getServizioApplicativoFruitore() || policy.getGroupBy().getIdentificativoAutenticato() || policy.getGroupBy().getToken() != null && !"".equals(policy.getGroupBy().getToken()) || policy.getGroupBy().getErogatore() || policy.getGroupBy().getServizioApplicativoErogatore() || policy.getGroupBy().getServizio() || policy.getGroupBy().getAzione() || policy.getGroupBy().isInformazioneApplicativaEnabled())) {
                messaggio = "Se si abilita il collezionamento dei dati deve essere selezionato almeno un criterio di raggruppamento";
                this.pd.setMessage(messaggio);
                return false;
            }
            if (policy.getGroupBy().isInformazioneApplicativaEnabled()) {
                TipoFiltroApplicativo tipo = TipoFiltroApplicativo.toEnumConstant((String)ConfigurazioneCostanti.CONTROLLO_TRAFFICO_POLICY_ACTIVE_GROUPBY_PER_CHIAVE_TIPO_DEFAULT);
                if (policy.getGroupBy().getInformazioneApplicativaTipo() != null) {
                    tipo = TipoFiltroApplicativo.toEnumConstant((String)policy.getGroupBy().getInformazioneApplicativaTipo());
                }
                if (!(TipoFiltroApplicativo.SOAPACTION_BASED.equals((Object)tipo) || TipoFiltroApplicativo.INDIRIZZO_IP.equals((Object)tipo) || TipoFiltroApplicativo.INDIRIZZO_IP_FORWARDED.equals((Object)tipo) || policy.getGroupBy().getInformazioneApplicativaNome() != null && !"--".equals(policy.getGroupBy().getInformazioneApplicativaNome()))) {
                    Object messaggio12 = null;
                    messaggio12 = TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)tipo) ? "Non &egrave; stato selezionato nessun plugin da utilizzare come criterio di raggruppamento per chiave" : "Deve essere indicato un valore in 'Raggruppamento per Chiave - " + this.getLabelTipoInformazioneApplicativaGroupBy(policy.getGroupBy().getInformazioneApplicativaTipo()) + "'";
                    this.pd.setMessage((String)messaggio12);
                    return false;
                }
            }
        }
        return true;
    }

    public String toStringFilter(AttivazionePolicyFiltro filtro, RuoloPolicy ruoloPorta, String nomePorta) throws NotFoundException {
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPolicy.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        StringBuilder bf = new StringBuilder("Filtro");
        if (filtro.isEnabled()) {
            bf.append(" abilitato con le seguenti impostazioni:");
            if (configurazione) {
                bf.append("<br/>");
                if (filtro.getRuoloPorta() == null || RuoloPolicy.ENTRAMBI.equals((Object)filtro.getRuoloPorta())) {
                    bf.append("Tipologia: Qualsiasi");
                } else {
                    bf.append("Tipologia:" + filtro.getRuoloPorta().getValue());
                }
            }
            if (configurazione) {
                bf.append("<br/>");
                if (filtro.getProtocollo() == null || "".equals(filtro.getProtocollo())) {
                    bf.append("Profilo: Qualsiasi");
                } else {
                    bf.append("Profilo: " + filtro.getProtocollo());
                }
            }
            if (configurazione) {
                bf.append("<br/>");
                if (filtro.getRuoloErogatore() != null) {
                    bf.append("Ruolo Erogatore: " + filtro.getRuoloErogatore());
                } else if (filtro.getTipoErogatore() == null || "".equals(filtro.getTipoErogatore()) || filtro.getNomeErogatore() == null || "".equals(filtro.getNomeErogatore())) {
                    bf.append("Soggetto Erogatore: Qualsiasi");
                } else {
                    bf.append("Soggetto Erogatore: " + filtro.getTipoErogatore() + "/" + filtro.getNomeErogatore());
                }
            }
            if (configurazione) {
                bf.append("<br/>");
                if (filtro.getTag() == null || "".equals(filtro.getTag())) {
                    bf.append("Tag: Qualsiasi");
                } else {
                    bf.append("Tag: " + filtro.getTag());
                }
            }
            if (configurazione) {
                bf.append("<br/>");
                if (filtro.getTipoServizio() == null || "".equals(filtro.getTipoServizio()) || filtro.getNomeServizio() == null || "".equals(filtro.getNomeServizio())) {
                    bf.append("API: Qualsiasi");
                } else {
                    bf.append("API: " + filtro.getTipoServizio() + "/" + filtro.getNomeServizio());
                }
            }
            bf.append("<br/>");
            if (filtro.getAzione() == null || "".equals(filtro.getAzione())) {
                bf.append("Azioni: Qualsiasi");
            } else {
                bf.append("Azioni: " + filtro.getAzione());
            }
            if (configurazione) {
                bf.append("<br/>");
                if (filtro.getServizioApplicativoErogatore() == null || "".equals(filtro.getServizioApplicativoErogatore())) {
                    bf.append("Applicativo Erogatore: Qualsiasi");
                } else {
                    bf.append("Applicativo Erogatore: " + filtro.getServizioApplicativoErogatore());
                }
            }
            if (configurazione || applicativa) {
                bf.append("<br/>");
                if (filtro.getRuoloFruitore() != null) {
                    bf.append("Ruolo Fruitore: " + filtro.getRuoloFruitore());
                } else if (filtro.getTipoFruitore() == null || "".equals(filtro.getTipoFruitore()) || filtro.getNomeFruitore() == null || "".equals(filtro.getNomeFruitore())) {
                    bf.append("Soggetto Fruitore: Qualsiasi");
                } else {
                    bf.append("Soggetto Fruitore: " + filtro.getTipoFruitore() + "/" + filtro.getNomeFruitore());
                }
                if (configurazione) {
                    bf.append("<br/>");
                    if (filtro.getServizioApplicativoFruitore() == null || "".equals(filtro.getServizioApplicativoFruitore())) {
                        bf.append("Applicativo Fruitore: Qualsiasi");
                    } else {
                        bf.append("Applicativo Fruitore: " + filtro.getServizioApplicativoFruitore());
                    }
                }
            } else if (delegata) {
                bf.append("<br/>");
                if (filtro.getRuoloFruitore() != null) {
                    bf.append("Ruolo Fruitore: " + filtro.getRuoloFruitore());
                } else if (filtro.getServizioApplicativoFruitore() == null || "".equals(filtro.getServizioApplicativoFruitore())) {
                    bf.append("Applicativo Fruitore: Qualsiasi");
                } else {
                    bf.append("Applicativo Fruitore: " + filtro.getServizioApplicativoFruitore());
                }
            }
            if (filtro.isInformazioneApplicativaEnabled()) {
                bf.append("<br/>");
                bf.append("Filtro per Chiave: Abilitato");
                bf.append("<br/>");
                bf.append("Tipologia: " + filtro.getInformazioneApplicativaTipo());
                bf.append("<br/>");
                bf.append(this.getLabelTipoInformazioneApplicativaFiltro(filtro.getInformazioneApplicativaTipo())).append(": ").append(filtro.getInformazioneApplicativaNome());
                bf.append("<br/>");
                bf.append("Valore: " + filtro.getInformazioneApplicativaValore());
            } else {
                bf.append("<br/>");
                bf.append("Filtro per Chiave: Disabilitato");
            }
        } else {
            bf.append(": Disabilitato");
        }
        return bf.toString();
    }

    public String eseguiResetJmx(TipoOperazione tipoOperazione, RuoloPolicy ruoloPorta, String nomePorta) throws Exception {
        try {
            List<String> aliases = this.core.getJmxPdDAliases();
            if (aliases == null || aliases.size() <= 0) {
                throw new DriverControlStationException("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
            }
            for (String alias : aliases) {
                String errorMessage;
                Object resultReset = null;
                String idAllPolicy = null;
                try {
                    idAllPolicy = nomePorta != null && !"".equals(nomePorta) ? ConfigurazionePdD.getKeyMethodElencoIdPolicyAttiveAPI((TipoPdD)(RuoloPolicy.DELEGATA.equals((Object)ruoloPorta) ? TipoPdD.DELEGATA : TipoPdD.APPLICATIVA), (String)nomePorta) : ConfigurazionePdD.getKeyMethodElencoIdPolicyAttiveGlobali();
                    resultReset = this.core.getInvoker().invokeJMXMethod(alias, "type", "ConfigurazionePdD", "removeObjectCache", idAllPolicy);
                    this.log.debug("reset[" + idAllPolicy + "] " + (String)resultReset);
                }
                catch (Exception e) {
                    errorMessage = "Errore durante l'invocazione dell'operazione [removeObjectCache] sulla risorsa [ConfigurazionePdD] (param:" + idAllPolicy + "): " + e.getMessage();
                    this.logError(errorMessage, e);
                    resultReset = errorMessage;
                }
                try {
                    idAllPolicy = nomePorta != null && !"".equals(nomePorta) ? ConfigurazionePdD.getKeyMethodElencoIdPolicyAttiveAPIDimensioneMessaggio((TipoPdD)(RuoloPolicy.DELEGATA.equals((Object)ruoloPorta) ? TipoPdD.DELEGATA : TipoPdD.APPLICATIVA), (String)nomePorta) : ConfigurazionePdD.getKeyMethodElencoIdPolicyAttiveGlobaliDimensioneMessaggio();
                    resultReset = this.core.getInvoker().invokeJMXMethod(alias, "type", "ConfigurazionePdD", "removeObjectCache", idAllPolicy);
                    this.log.debug("reset[" + idAllPolicy + "] " + (String)resultReset);
                }
                catch (Exception e) {
                    errorMessage = "Errore durante l'invocazione dell'operazione [removeObjectCache] sulla risorsa [ConfigurazionePdD] (param:" + idAllPolicy + "): " + e.getMessage();
                    this.logError(errorMessage, e);
                    resultReset = errorMessage;
                }
                boolean resetSinglePolicy = false;
                if (resetSinglePolicy) {
                    resultReset = null;
                    String idPolicy = null;
                    String tmpIdPolicy = this.getParameter("CTPolicyActiveId");
                    try {
                        idPolicy = ConfigurazionePdD._getKey_AttivazionePolicy((String)tmpIdPolicy);
                        resultReset = this.core.getInvoker().invokeJMXMethod(alias, "type", "ConfigurazionePdD", "removeObjectCache", idPolicy);
                        this.log.debug("reset[" + idPolicy + "] " + (String)resultReset);
                    }
                    catch (Exception e) {
                        String errorMessage2 = "Errore durante l'invocazione dell'operazione [removeObjectCache] sulla risorsa [ConfigurazionePdD] (param:" + idPolicy + "): " + e.getMessage();
                        this.logError(errorMessage2, e);
                        resultReset = errorMessage2;
                    }
                }
                String risorsa = null;
                String methodName = null;
                Object params = null;
                try {
                    TipoPdD tipoPdD = null;
                    risorsa = this.core.getJmxPdDConfigurazioneSistemaNomeRisorsaDatiRichieste(alias);
                    if (nomePorta != null && !"".equals(nomePorta)) {
                        methodName = this.core.getJmxPdDConfigurazioneSistemaNomeMetodoRemoveRateLimitingAPIConfigCache(alias);
                        tipoPdD = RuoloPolicy.DELEGATA.equals((Object)ruoloPorta) ? TipoPdD.DELEGATA : TipoPdD.APPLICATIVA;
                        params = tipoPdD.getTipo() + ", " + nomePorta;
                        resultReset = this.core.getInvoker().invokeJMXMethod(alias, "type", risorsa, methodName, new Object[]{tipoPdD.getTipo(), nomePorta});
                    } else {
                        methodName = this.core.getJmxPdDConfigurazioneSistemaNomeMetodoRemoveRateLimitingGlobalConfigCache(alias);
                        params = "non sono previsti parametri";
                        resultReset = this.core.getInvoker().invokeJMXMethod(alias, "type", risorsa, methodName);
                    }
                    this.log.debug("reset[" + idAllPolicy + "] " + (String)resultReset);
                }
                catch (Exception e) {
                    String errorMessage3 = "Errore durante l'invocazione dell'operazione [" + methodName + "] sulla risorsa [" + risorsa + "] (params:" + params + "): " + e.getMessage();
                    this.logError(errorMessage3, e);
                    resultReset = errorMessage3;
                }
            }
        }
        catch (Exception e) {
            this.logError("ResetCache:" + e.getMessage(), e);
        }
        return "Configurazione Controllo del Traffico modificata con successo";
    }

    public void prepareGestorePolicyTokenList(ConsoleSearch ricerca, List<GenericProperties> lista, int idLista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazionePolicyGestioneToken", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            String infoType = this.getParametroInfoType("_tabKey_infoType");
            if (infoType == null) {
                infoType = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_infoType");
            }
            org.openspcoop2.web.lib.mvc.Parameter pInfoType = new org.openspcoop2.web.lib.mvc.Parameter("_tabKey_infoType", infoType);
            boolean attributeAuthority = ConfigurazioneCostanti.isConfigurazioneAttributeAuthority(infoType);
            if (attributeAuthority) {
                this.pd.setCustomListViewName("attributeAuthority");
            } else {
                this.pd.setCustomListViewName("tokenPolicy");
            }
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            PropertiesSourceConfiguration propertiesSourceConfiguration = attributeAuthority ? this.confCore.getAttributeAuthorityPropertiesSourceConfiguration() : this.confCore.getPolicyGestioneTokenPropertiesSourceConfiguration();
            ConfigManager configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
            configManager.leggiConfigurazioni(propertiesSourceConfiguration, true);
            List nomiConfigurazioniPolicyGestioneToken = configManager.getNomiConfigurazioni(propertiesSourceConfiguration, new String[0]);
            List labelConfigurazioniPolicyGestioneToken = configManager.convertToLabel(propertiesSourceConfiguration, nomiConfigurazioniPolicyGestioneToken);
            if (!attributeAuthority) {
                String filterTipoTokenPolicy = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoTokenPolicy");
                this.addFilterTipoTokenPolicy(filterTipoTokenPolicy, false, nomiConfigurazioniPolicyGestioneToken, labelConfigurazioniPolicyGestioneToken);
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            String label = attributeAuthority ? "Attribute Authority" : "Token Policy";
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter(label, null));
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Nome", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            boolean forceId = attributeAuthority ? this.core.isAttributeAuthorityForceIdEnabled() : this.core.isTokenPolicyForceIdEnabled();
            lstLabels.add(label);
            String[] labels = lstLabels.toArray(new String[lstLabels.size()]);
            this.pd.setLabels(labels);
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    List<DataElement> e = this.creaEntryTokenPolicyCustom(lista, pInfoType, attributeAuthority, nomiConfigurazioniPolicyGestioneToken, labelConfigurazioniPolicyGestioneToken, forceId, i);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport()) {
                ArchiveType archiveType;
                ExporterUtils exporterUtils = new ExporterUtils(this.archiviCore);
                ArchiveType archiveType2 = archiveType = attributeAuthority ? ArchiveType.CONFIGURAZIONE_ATTRIBUTE_AUTHORITY : ArchiveType.CONFIGURAZIONE_TOKEN_POLICY;
                if (exporterUtils.existsAtLeastOneExportMode(archiveType, this.request, this.session)) {
                    ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                    AreaBottoni ab = new AreaBottoni();
                    ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    if (attributeAuthority) {
                        de.setValue("Esporta");
                        de.setOnClick(ConfigurazioneCostanti.LABEL_ATTRIBUTE_AUTHORITY_ESPORTA_SELEZIONATI_ONCLICK);
                    } else {
                        de.setValue("Esporta");
                        de.setOnClick(ConfigurazioneCostanti.LABEL_TOKEN_POLICY_ESPORTA_SELEZIONATI_ONCLICK);
                    }
                    de.setDisabilitaAjaxStatus();
                    otherbott.add(de);
                    ab.setBottoni(otherbott);
                    bottoni.add(ab);
                    this.pd.setAreaBottoni(bottoni);
                }
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> creaEntryTokenPolicy(List<GenericProperties> lista, org.openspcoop2.web.lib.mvc.Parameter pInfoType, boolean attributeAuthority, List<String> nomiConfigurazioniPolicyGestioneToken, List<String> labelConfigurazioniPolicyGestioneToken, boolean forceId, int i) {
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        GenericProperties policy = lista.get(i);
        org.openspcoop2.web.lib.mvc.Parameter pPolicyId = new org.openspcoop2.web.lib.mvc.Parameter("idPolicy", "" + policy.getId());
        DataElement de = new DataElement();
        de.setUrl("configurazionePolicyGestioneTokenChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pInfoType, pPolicyId});
        de.setValue(policy.getNome());
        de.setIdToRemove("" + policy.getId());
        e.add(de);
        de = new DataElement();
        de.setValue(policy.getDescrizione());
        e.add(de);
        if (!forceId) {
            de = new DataElement();
            if (nomiConfigurazioniPolicyGestioneToken != null && nomiConfigurazioniPolicyGestioneToken.contains(policy.getTipo())) {
                boolean found = false;
                for (int j = 0; j < nomiConfigurazioniPolicyGestioneToken.size(); ++j) {
                    String nome = nomiConfigurazioniPolicyGestioneToken.get(j);
                    if (!nome.equals(policy.getTipo())) continue;
                    de.setValue(labelConfigurazioniPolicyGestioneToken.get(j));
                    found = true;
                    break;
                }
                if (!found) {
                    de.setValue(policy.getTipo());
                }
            } else {
                de.setValue(policy.getTipo());
            }
            e.add(de);
        }
        InUsoType inUsoType = attributeAuthority ? InUsoType.ATTRIBUTE_AUTHORITY : InUsoType.TOKEN_POLICY;
        this.addInUsoButtonVisualizzazioneClassica(e, policy.getNome(), "" + policy.getId(), inUsoType);
        return e;
    }

    private List<DataElement> creaEntryTokenPolicyCustom(List<GenericProperties> lista, org.openspcoop2.web.lib.mvc.Parameter pInfoType, boolean attributeAuthority, List<String> nomiConfigurazioniPolicyGestioneToken, List<String> labelConfigurazioniPolicyGestioneToken, boolean forceId, int i) {
        boolean visualizzaValidazioneCertificati;
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        GenericProperties policy = lista.get(i);
        org.openspcoop2.web.lib.mvc.Parameter pPolicyId = new org.openspcoop2.web.lib.mvc.Parameter("idPolicy", "" + policy.getId());
        ArrayList<org.openspcoop2.web.lib.mvc.Parameter> listaParametriChange = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
        listaParametriChange.add(pInfoType);
        listaParametriChange.add(pPolicyId);
        DataElement de = new DataElement();
        de.setValue(policy.getNome());
        de.setUrl("configurazionePolicyGestioneTokenChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pInfoType, pPolicyId});
        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        de.setIdToRemove("" + policy.getId());
        de.setType(DataElementType.TITLE);
        e.add(de);
        boolean visualizzaSecondaRiga = StringUtils.isNotBlank((CharSequence)policy.getDescrizione()) || !forceId || attributeAuthority;
        boolean verificaConnettivita = true;
        if (visualizzaSecondaRiga) {
            de = new DataElement();
            de.setValue(MessageFormat.format("Descrizione: {0}", policy.getDescrizione()));
            if (!forceId) {
                boolean validazione = "gestionePolicyToken".equals(policy.getTipologia());
                boolean negoziazione = "retrievePolicyToken".equals(policy.getTipologia());
                Object labelTipo = policy.getTipo();
                if (nomiConfigurazioniPolicyGestioneToken != null && nomiConfigurazioniPolicyGestioneToken.contains(policy.getTipo())) {
                    boolean found = false;
                    for (int j = 0; j < nomiConfigurazioniPolicyGestioneToken.size(); ++j) {
                        String nome = nomiConfigurazioniPolicyGestioneToken.get(j);
                        if (!nome.equals(policy.getTipo())) continue;
                        labelTipo = labelConfigurazioniPolicyGestioneToken.get(j);
                        found = true;
                        break;
                    }
                    if (!found) {
                        labelTipo = policy.getTipo();
                    }
                } else {
                    labelTipo = policy.getTipo();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(MessageFormat.format("Tipo: {0}", labelTipo));
                if (validazione) {
                    GestioneToken gestioneToken = new GestioneToken();
                    gestioneToken.setIntrospection(StatoFunzionalitaConWarning.ABILITATO);
                    gestioneToken.setUserInfo(StatoFunzionalitaConWarning.ABILITATO);
                    gestioneToken.setValidazione(StatoFunzionalitaConWarning.ABILITATO);
                    gestioneToken.setForward(StatoFunzionalita.ABILITATO);
                    try {
                        PolicyGestioneToken policyGestioneToken = TokenUtilities.convertTo((GenericProperties)policy, (GestioneToken)gestioneToken);
                        String labelToken = policyGestioneToken.getLabelTipoToken();
                        sb.append(", ");
                        sb.append(MessageFormat.format("Token: {0}", labelToken));
                        String labelValidazione = policyGestioneToken.getAzioniGestioneToken();
                        labelValidazione = labelValidazione.replace("JWT", "ValidazioneJWT");
                        labelValidazione = labelValidazione.replace(",", " - ").trim();
                        sb.append(", ");
                        sb.append(MessageFormat.format("Modalit\u00e0: {0}", labelValidazione));
                        String labelForward = policyGestioneToken.getAzioniForwardToken();
                        labelForward = labelForward.replace(",", " - ").trim();
                        sb.append(", ");
                        sb.append(MessageFormat.format("Forward: {0}", labelForward));
                        if (!(policyGestioneToken.isDynamicDiscovery() || policyGestioneToken.isIntrospection() || policyGestioneToken.isUserInfo())) {
                            verificaConnettivita = policyGestioneToken.isValidazioneJWT() ? policyGestioneToken.isValidazioneJWTLocationHttp() : false;
                        }
                    }
                    catch (Exception t) {
                        this.logError(t.getMessage(), t);
                    }
                    if (StringUtils.isNotBlank((CharSequence)policy.getDescrizione())) {
                        sb.append(", ");
                        sb.append(MessageFormat.format("Descrizione: {0}", labelTipo, policy.getDescrizione()));
                    }
                } else if (negoziazione) {
                    try {
                        PolicyNegoziazioneToken policyNegoziazione = TokenUtilities.convertTo((GenericProperties)policy);
                        String labelModalita = policyNegoziazione.getLabelGrant();
                        sb.append(", ");
                        sb.append(MessageFormat.format("Modalit\u00e0: {0}", labelModalita));
                    }
                    catch (Exception t) {
                        this.logError(t.getMessage(), t);
                    }
                    if (StringUtils.isNotBlank((CharSequence)policy.getDescrizione())) {
                        sb.append(", ");
                        sb.append(MessageFormat.format("Descrizione: {0}", labelTipo, policy.getDescrizione()));
                    }
                } else if (StringUtils.isNotBlank((CharSequence)policy.getDescrizione())) {
                    sb.append(", ");
                    sb.append(MessageFormat.format("Descrizione: {0}", labelTipo, policy.getDescrizione()));
                }
                de.setValue(sb.toString());
            } else if (attributeAuthority) {
                String tipoRisposta = null;
                String attributi = null;
                for (Property p : policy.getPropertyList()) {
                    if ("policy.attributeAuthority.response.type".equals(p.getNome())) {
                        tipoRisposta = p.getValore();
                        continue;
                    }
                    if (!"policy.attributeAuthority.response.jwt.attributes".equals(p.getNome())) continue;
                    attributi = p.getValore();
                }
                TipologiaResponseAttributeAuthority tipologiaResponse = null;
                if (tipoRisposta != null) {
                    tipologiaResponse = TipologiaResponseAttributeAuthority.valueOf(tipoRisposta);
                }
                if (!TipologiaResponseAttributeAuthority.custom.equals((Object)tipologiaResponse) && (attributi == null || StringUtils.isBlank(attributi))) {
                    attributi = "qualsiasi";
                }
                if (StringUtils.isNotBlank((CharSequence)policy.getDescrizione()) && StringUtils.isNotBlank((CharSequence)attributi)) {
                    de.setValue(MessageFormat.format("Attributi: {0}, Descrizione: {1}", attributi, policy.getDescrizione()));
                } else if (StringUtils.isNotBlank((CharSequence)attributi)) {
                    de.setValue(MessageFormat.format("Attributi: {0}", attributi));
                } else if (StringUtils.isNotBlank((CharSequence)policy.getDescrizione())) {
                    de.setValue(MessageFormat.format("Descrizione: {0}", policy.getDescrizione()));
                } else {
                    visualizzaSecondaRiga = false;
                }
            }
            if (visualizzaSecondaRiga) {
                de.setType(DataElementType.SUBTITLE);
                e.add(de);
            }
        }
        listaParametriChange.add(new org.openspcoop2.web.lib.mvc.Parameter("certVerFromLista", "true"));
        listaParametriChange.add(new org.openspcoop2.web.lib.mvc.Parameter("resetFromLista", "true"));
        InUsoType inUsoType = attributeAuthority ? InUsoType.ATTRIBUTE_AUTHORITY : InUsoType.TOKEN_POLICY;
        this.addInUsoButton(e, policy.getNome(), "" + policy.getId(), inUsoType);
        boolean bl = visualizzaValidazioneCertificati = attributeAuthority ? this.core.isAttributeAuthorityVerificaCertificati() : this.core.isPolicyGestioneTokenVerificaCertificati();
        if (visualizzaValidazioneCertificati) {
            this.addVerificaCertificatiButton(e, "configurazionePolicyGestioneTokenVerificaCertificati.do", listaParametriChange);
        }
        if (verificaConnettivita) {
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> listaParametriVerificaConnettivitaChange = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            listaParametriVerificaConnettivitaChange.addAll(listaParametriChange);
            listaParametriVerificaConnettivitaChange.add(new org.openspcoop2.web.lib.mvc.Parameter("tokenVerConn", "true"));
            this.addVerificaConnettivitaButton(e, "configurazionePolicyGestioneTokenVerificaCertificati.do", listaParametriVerificaConnettivitaChange);
        }
        if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
            this.addComandoResetCacheButton(e, policy.getNome(), "configurazionePolicyGestioneTokenChange.do", listaParametriChange);
        }
        this.addProprietaOggettoButton(e, policy.getNome(), "" + policy.getId(), inUsoType);
        return e;
    }

    public List<DataElement> addPolicyGestioneTokenToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String id, String nome, String descrizione, String tipo, String[] propConfigPolicyGestioneTokenLabelList, String[] propConfigPolicyGestioneTokenList, boolean attributeAuthority, GenericProperties genericProperties) throws Exception {
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            boolean visualizzaValidazioneCertificati;
            org.openspcoop2.web.lib.mvc.Parameter pPolicyId = new org.openspcoop2.web.lib.mvc.Parameter("idPolicy", id);
            String infoType = this.getParameter("_tabKey_infoType");
            if (infoType == null) {
                infoType = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_infoType");
            }
            org.openspcoop2.web.lib.mvc.Parameter pInfoType = new org.openspcoop2.web.lib.mvc.Parameter("_tabKey_infoType", infoType);
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> listaParametriChange = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            listaParametriChange.add(pInfoType);
            listaParametriChange.add(pPolicyId);
            boolean verificaConnettivita = true;
            boolean validazione = "gestionePolicyToken".equals(genericProperties.getTipologia());
            if (validazione) {
                GestioneToken gestioneToken = new GestioneToken();
                gestioneToken.setIntrospection(StatoFunzionalitaConWarning.ABILITATO);
                gestioneToken.setUserInfo(StatoFunzionalitaConWarning.ABILITATO);
                gestioneToken.setValidazione(StatoFunzionalitaConWarning.ABILITATO);
                gestioneToken.setForward(StatoFunzionalita.ABILITATO);
                try {
                    PolicyGestioneToken policyGestioneToken = TokenUtilities.convertTo((GenericProperties)genericProperties, (GestioneToken)gestioneToken);
                    if (!policyGestioneToken.isIntrospection() && !policyGestioneToken.isUserInfo()) {
                        verificaConnettivita = false;
                    }
                }
                catch (Exception t) {
                    this.logError(t.getMessage(), t);
                }
            }
            InUsoType inUsoType = attributeAuthority ? InUsoType.ATTRIBUTE_AUTHORITY : InUsoType.TOKEN_POLICY;
            this.addComandoInUsoButton(nome, id, inUsoType);
            boolean bl = visualizzaValidazioneCertificati = attributeAuthority ? this.core.isAttributeAuthorityVerificaCertificati() : this.core.isPolicyGestioneTokenVerificaCertificati();
            if (visualizzaValidazioneCertificati) {
                this.pd.addComandoVerificaCertificatiElementoButton("configurazionePolicyGestioneTokenVerificaCertificati.do", listaParametriChange);
            }
            if (verificaConnettivita) {
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> listaParametriVerificaConnettivitaChange = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                listaParametriVerificaConnettivitaChange.addAll(listaParametriChange);
                listaParametriVerificaConnettivitaChange.add(new org.openspcoop2.web.lib.mvc.Parameter("tokenVerConn", "true"));
                this.pd.addComandoVerificaConnettivitaElementoButton("configurazionePolicyGestioneTokenVerificaCertificati.do", listaParametriVerificaConnettivitaChange);
            }
            if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
                listaParametriChange.add(new org.openspcoop2.web.lib.mvc.Parameter("rmElFromCache", "true"));
                this.pd.addComandoResetCacheElementoButton("configurazionePolicyGestioneTokenChange.do", listaParametriChange);
            }
            if (this.existsProprietaOggetto(genericProperties.getProprietaOggetto(), genericProperties.getDescrizione())) {
                this.addComandoProprietaOggettoButton(nome, id, inUsoType);
            }
        }
        boolean forceIdEnabled = attributeAuthority ? this.confCore.isAttributeAuthorityForceIdEnabled() : this.confCore.isTokenPolicyForceIdEnabled();
        DataElement de = new DataElement();
        de.setLabel(attributeAuthority ? "Attribute Authority" : "Token Policy");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("ID");
        de.setName("idPolicy");
        de.setType(DataElementType.HIDDEN);
        de.setValue(id);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setName("tipo");
        if (!forceIdEnabled) {
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                de.setType(DataElementType.SELECT);
                de.setPostBack(true);
                de.setValues(propConfigPolicyGestioneTokenList);
                de.setLabels(propConfigPolicyGestioneTokenLabelList);
                de.setSelected(tipo);
                de.setRequired(true);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipo);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Tipo");
                de.setName("tipo__label");
                de.setType(DataElementType.TEXT);
                if (propConfigPolicyGestioneTokenList != null && propConfigPolicyGestioneTokenList.length > 0) {
                    boolean found = false;
                    for (int j = 0; j < propConfigPolicyGestioneTokenList.length; ++j) {
                        String nomeP = propConfigPolicyGestioneTokenList[j];
                        if (!nomeP.equals(tipo)) continue;
                        de.setValue(propConfigPolicyGestioneTokenLabelList[j]);
                        found = true;
                        break;
                    }
                    if (!found) {
                        de.setValue(tipo);
                    }
                } else {
                    de.setValue(tipo);
                }
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tipo);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setName("nome");
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setValue(nome);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setName("descrizione");
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(2);
        de.setValue(descrizione);
        dati.add(de);
        return dati;
    }

    public boolean policyGestioneTokenCheckData(TipoOperazione tipoOperazione, String nome, String descrizione, String tipo, String tipologia) throws DriverControlStationException {
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            if (StringUtils.isEmpty((CharSequence)nome)) {
                String messaggio = "Deve essere indicato un valore in 'Nome'";
                this.pd.setMessage(messaggio);
                return false;
            }
            if (nome.contains(" ")) {
                String messaggio = "Deve essere indicato un valore in 'Nome' senza spazi";
                this.pd.setMessage(messaggio);
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)tipo) || "-".equals(tipo)) {
                String messaggio = "Deve essere indicato un valore in 'Tipo'";
                this.pd.setMessage(messaggio);
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            try {
                this.confCore.getGenericProperties(nome, tipologia, false);
                String messaggio = "&Egrave; gi&agrave; presente un Policy, del tipo indicato, con nome " + nome;
                this.pd.setMessage(messaggio);
                return false;
            }
            catch (DriverConfigurazioneNotFound messaggio) {
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
        if (descrizione != null && !"".equals(descrizione) && !this.checkLength4000(descrizione, "Descrizione")) {
            return false;
        }
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            // empty if block
        }
        return true;
    }

    public String replaceToHtmlSeparator(String value) {
        return this.replaceSeparator(value, "\n", "<br/>");
    }

    public String replaceSeparator(String value, String originale, String destinazione) {
        if (value != null) {
            while (value.contains(originale)) {
                value = value.replace(originale, destinazione);
            }
        }
        return value;
    }

    public void prepareProxyPassConfigurazioneRegolaList(ISearch ricerca, List<ConfigurazioneUrlInvocazioneRegola> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneProxyPassRegola", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.CONFIGURAZIONE_PROXY_PASS_REGOLA;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Regole di Proxy Pass", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Regole di Proxy Pass", "configurazioneProxyPassRegolaList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Nome", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            if (lista != null && lista.size() > 1) {
                lstLabels.add("Ordine");
            }
            lstLabels.add("Stato");
            lstLabels.add("Nome");
            lstLabels.add("Descrizione");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList dati = new ArrayList();
            if (lista != null) {
                Iterator<ConfigurazioneUrlInvocazioneRegola> it = lista.iterator();
                int numeroElementi = lista.size();
                int i = 0;
                while (it.hasNext()) {
                    DataElement de;
                    ConfigurazioneUrlInvocazioneRegola regola = it.next();
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pIdRegola = new org.openspcoop2.web.lib.mvc.Parameter("ppId", "" + regola.getId());
                    if (lista.size() > 1) {
                        de = new DataElement();
                        de.setWidthPx(48);
                        de.setType(DataElementType.IMAGE);
                        DataElementImage imageUp = new DataElementImage();
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneSu = new org.openspcoop2.web.lib.mvc.Parameter("ppPos", "su");
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneGiu = new org.openspcoop2.web.lib.mvc.Parameter("ppPos", "giu");
                        if (i > 0) {
                            imageUp.setImage("&#xE316;");
                            imageUp.setToolTip("Sposta su");
                            imageUp.setUrl("configurazioneProxyPassRegolaList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdRegola, pDirezioneSu});
                        } else {
                            imageUp.setImage("&#160;&#160;&#160;&#160;&#160;");
                        }
                        de.addImage(imageUp);
                        if (i < numeroElementi - 1) {
                            DataElementImage imageDown = new DataElementImage();
                            imageDown.setImage("&#xE313;");
                            imageDown.setToolTip("Sposta gi&ugrave;");
                            imageDown.setUrl("configurazioneProxyPassRegolaList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdRegola, pDirezioneGiu});
                            de.addImage(imageDown);
                        }
                        de.setValue("" + regola.getPosizione());
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setWidthPx(10);
                    de.setType(DataElementType.CHECKBOX);
                    if (regola.getStato() == null || StatoFunzionalita.ABILITATO.equals((Object)regola.getStato())) {
                        de.setToolTip("Abilitato");
                        de.setValue("Abilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_ENABLE);
                    } else {
                        de.setToolTip("Disabilitato");
                        de.setValue("Disabilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_DISABLE);
                    }
                    de.setUrl("configurazioneProxyPassRegolaChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdRegola});
                    e.add(de);
                    de = new DataElement();
                    de.setIdToRemove("" + regola.getId());
                    de.setValue(regola.getNome());
                    de.setToolTip(regola.getNome());
                    de.setUrl("configurazioneProxyPassRegolaChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdRegola});
                    e.add(de);
                    de = new DataElement();
                    if (regola.getDescrizione() != null && regola.getDescrizione().length() > 100) {
                        de.setValue(regola.getDescrizione().substring(0, 97) + "...");
                        de.setToolTip(regola.getDescrizione());
                    } else {
                        de.setValue(regola.getDescrizione());
                    }
                    e.add(de);
                    dati.add(e);
                    ++i;
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean proxyPassConfigurazioneRegolaCheckData(TipoOperazione tipoOp, String oldNome) throws Exception {
        try {
            boolean giaRegistrato;
            String ruolo;
            String baseUrl;
            String nome = this.getParameter("ppNome");
            if (StringUtils.isEmpty((CharSequence)nome)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Nome"));
                return false;
            }
            if (!this.checkLength(nome, "Nome", 1, 255)) {
                return false;
            }
            String stato = this.getParameter("ppStato");
            if (StringUtils.isEmpty((CharSequence)stato)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Stato"));
                return false;
            }
            if (!stato.equals(StatoFunzionalita.ABILITATO.getValue()) && !stato.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                this.pd.setMessage(MessageFormat.format("Valore del campo {0} non valido.", "Stato"));
                return false;
            }
            String regolaText = this.getParameter("ppRegText");
            if (StringUtils.isEmpty((CharSequence)regolaText)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Regola"));
                return false;
            }
            if (!this.checkLength(regolaText, "Regola", 1, 255)) {
                return false;
            }
            String contestoEsterno = this.getParameter("ppCE");
            if (!StringUtils.isEmpty((CharSequence)contestoEsterno)) {
                if (contestoEsterno.contains(" ")) {
                    this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Contesto"));
                    return false;
                }
                if (!this.checkLength(contestoEsterno, "Contesto", 1, 255)) {
                    return false;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)(baseUrl = this.getParameter("ppBaseUrl")))) {
                if (baseUrl.contains(" ")) {
                    this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Base URL"));
                    return false;
                }
                if (!this.checkLength(baseUrl, "Base URL", 1, 255)) {
                    return false;
                }
                try {
                    RegExpUtilities.validateUrl((String)baseUrl, (boolean)true);
                }
                catch (Exception e) {
                    this.pd.setMessage("Base URL non correttamente formata: " + e.getMessage());
                    return false;
                }
            }
            if (!(StringUtils.isEmpty((CharSequence)(ruolo = this.getParameter("ppRuolo"))) || ruolo.equals("erogazione") || ruolo.equals("fruizione"))) {
                this.pd.setMessage(MessageFormat.format("Valore del campo {0} non valido.", "Ruolo"));
                return false;
            }
            String serviceBinding = this.getParameter("ppServB");
            if (!(StringUtils.isEmpty((CharSequence)serviceBinding) || serviceBinding.equals("SOAP") || serviceBinding.equals("REST"))) {
                this.pd.setMessage(MessageFormat.format("Valore del campo {0} non valido.", "Tipo API"));
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato2 = this.confCore.existsProxyPassConfigurazioneRegola(nome);
                if (giaRegistrato2) {
                    this.pd.setMessage("&Egrave; gi&agrave; presente una Regola di Proxy Pass con questo nome.");
                    return false;
                }
            } else if (!oldNome.equals(nome) && (giaRegistrato = this.confCore.existsProxyPassConfigurazioneRegola(nome))) {
                this.pd.setMessage("&Egrave; gi&agrave; presente una Regola di Proxy Pass con questo nome.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public CanaliConfigurazione getGestioneCanali(boolean canaliEnabled, String canaliDefault, List<CanaleConfigurazione> canaleList, String canaliNome, String canaliDescrizione, List<CanaleConfigurazioneNodo> nodoList) {
        CanaliConfigurazione configurazione = new CanaliConfigurazione();
        if (canaliEnabled) {
            configurazione.setStato(StatoFunzionalita.ABILITATO);
            if (canaleList == null) {
                canaleList = new ArrayList<CanaleConfigurazione>();
            }
            if (canaliDefault != null) {
                for (CanaleConfigurazione canaleConfigurazione : canaleList) {
                    canaleConfigurazione.setCanaleDefault(false);
                }
                for (CanaleConfigurazione canaleConfigurazione : canaleList) {
                    if (!canaleConfigurazione.getNome().equals(canaliDefault)) continue;
                    canaleConfigurazione.setCanaleDefault(true);
                    break;
                }
            } else {
                CanaleConfigurazione canaleConfigurazione = new CanaleConfigurazione();
                canaleConfigurazione.setNome(canaliNome);
                canaleConfigurazione.setDescrizione(canaliDescrizione);
                canaleConfigurazione.setCanaleDefault(true);
                canaleList.add(canaleConfigurazione);
            }
            configurazione.setCanaleList(canaleList);
            if (nodoList == null) {
                nodoList = new ArrayList<CanaleConfigurazioneNodo>();
            }
            configurazione.setNodoList(nodoList);
        } else {
            configurazione.setStato(StatoFunzionalita.DISABILITATO);
        }
        return configurazione;
    }

    public void prepareCanaleConfigurazioneList(ConsoleSearch ricerca, List<CanaleConfigurazione> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneCanali", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.CONFIGURAZIONE_CANALI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Canali", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Canali", "configurazioneCanaliList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Nome", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            lstLabels.add("Nome");
            lstLabels.add("Descrizione");
            lstLabels.add("Default");
            lstLabels.add("Uso");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            if (lista != null) {
                for (CanaleConfigurazione regola : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pIdCanale = new org.openspcoop2.web.lib.mvc.Parameter("canaliID", "" + regola.getId());
                    DataElement de = new DataElement();
                    de.setIdToRemove("" + regola.getId());
                    de.setValue(regola.getNome());
                    de.setToolTip(regola.getNome());
                    de.setUrl("configurazioneCanaliChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdCanale});
                    e.add(de);
                    de = new DataElement();
                    if (regola.getDescrizione() != null && regola.getDescrizione().length() > 100) {
                        de.setValue(regola.getDescrizione().substring(0, 97) + "...");
                        de.setToolTip(regola.getDescrizione());
                    } else {
                        de.setValue(regola.getDescrizione());
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setWidthPx(10);
                    if (regola.isCanaleDefault()) {
                        de.setValue("Si");
                    } else {
                        de.setValue("No");
                    }
                    e.add(de);
                    this.addInUsoButtonVisualizzazioneClassica(e, regola.getNome(), regola.getNome(), InUsoType.CANALE);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addCanaleToDati(TipoOperazione tipoOp, List<DataElement> dati, String idCanaleS, String nome, String descrizione) {
        DataElement de;
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Canale");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            de = new DataElement();
            de.setName("canaliID");
            de.setType(DataElementType.HIDDEN);
            de.setValue(idCanaleS);
            dati.add(de);
        }
        de = new DataElement();
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setName("canaliNome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setName("canaliDescrizione");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public boolean canaleCheckData(TipoOperazione tipoOp, String oldNome) throws Exception {
        try {
            String canaliNome = this.getParameter("canaliNome");
            String canaliDescrizione = this.getParameter("canaliDescrizione");
            if (!this.canaleDatiCheckData(canaliNome, canaliDescrizione)) {
                return false;
            }
            boolean existsCanale = this.confCore.existsCanale(canaliNome);
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (existsCanale) {
                    this.pd.setMessage("&Egrave; gi&agrave; presente un Canale con questo nome.");
                    return false;
                }
            } else if (!oldNome.equals(canaliNome) && existsCanale) {
                this.pd.setMessage("Il nuovo nome scelto &egrave; gi&agrave; utilizzato da un altro Canale.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareCanaleNodoConfigurazioneList(ConsoleSearch ricerca, List<CanaleConfigurazioneNodo> lista) throws Exception {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneCanaliNodi", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.CONFIGURAZIONE_CANALI_NODI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Nodi", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Nodi", "configurazioneCanaliNodiList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Nome", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            lstLabels.add("Nome");
            lstLabels.add("Descrizione");
            lstLabels.add("Canali");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (CanaleConfigurazioneNodo regola : lista) {
                    String labelTooltip;
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pIdCanaleNodo = new org.openspcoop2.web.lib.mvc.Parameter("nodiID", "" + regola.getId());
                    DataElement de = new DataElement();
                    de.setIdToRemove("" + regola.getId());
                    de.setValue(regola.getNome());
                    de.setToolTip(regola.getNome());
                    de.setUrl("configurazioneCanaliNodiChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdCanaleNodo});
                    e.add(de);
                    de = new DataElement();
                    if (regola.getDescrizione() != null && regola.getDescrizione().length() > 100) {
                        de.setValue(regola.getDescrizione().substring(0, 97) + "...");
                        de.setToolTip(regola.getDescrizione());
                    } else {
                        de.setValue(regola.getDescrizione());
                    }
                    e.add(de);
                    de = new DataElement();
                    ArrayList canaleList = regola.getCanaleList();
                    if (canaleList == null) {
                        canaleList = new ArrayList();
                    }
                    if ((labelTooltip = StringUtils.join((Object[])canaleList.toArray(new String[canaleList.size()]), (String)", ")).length() > 100) {
                        de.setValue(labelTooltip.substring(0, 97) + "...");
                        de.setToolTip(labelTooltip);
                    } else {
                        de.setValue(labelTooltip);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addCanaleNodoToDati(TipoOperazione tipoOp, List<DataElement> dati, String idNodoS, String oldNome, String nome, String descrizione, String[] canali, List<CanaleConfigurazione> canaleList, boolean selectListNode, List<String> aliasesNodi) {
        DataElement de;
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Nodo");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
            de = new DataElement();
            de.setName("nodiID");
            de.setType(DataElementType.HIDDEN);
            de.setValue(idNodoS);
            dati.add(de);
            if (selectListNode && aliasesNodi.contains(oldNome) && aliasesNodi.size() > 1 && !oldNome.equals(nome)) {
                de = new DataElement();
                de.setName("nodiOldNome");
                de.setLabel("Nome attuale");
                de.setType(DataElementType.TEXT);
                de.setValue(oldNome);
                dati.add(de);
            }
        }
        if (selectListNode) {
            de = new DataElement();
            de.setLabel("Nome");
            de.setValues(aliasesNodi);
            de.setLabels(aliasesNodi);
            de.setSelected(nome);
            de.setRequired(true);
            de.setType(DataElementType.SELECT);
            de.setName("nodiNome");
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                de.setPostBack(true);
            }
            dati.add(de);
        } else {
            de = new DataElement();
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nome);
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
            de.setName("nodiNome");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setName("nodiDescrizione");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Canali");
        List canaliListValues = canaleList.stream().map(CanaleConfigurazione::getNome).collect(Collectors.toList());
        de.setValues(canaliListValues);
        de.setLabels(canaliListValues);
        de.setSelezionati(canali);
        de.setRequired(true);
        de.setType(DataElementType.MULTI_SELECT);
        de.setName("nodiCanali");
        de.setRows(10);
        dati.add(de);
        return dati;
    }

    public boolean canaleNodoCheckData(TipoOperazione tipoOp, String oldNome) throws Exception {
        try {
            String canaliNome = this.getParameter("nodiNome");
            String canaliDescrizione = this.getParameter("nodiDescrizione");
            String[] canali = this.getParameterValues("nodiCanali");
            if (StringUtils.isEmpty((CharSequence)canaliNome)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Nome"));
                return false;
            }
            if (!this.checkSpazi(canaliNome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(canaliNome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(canaliDescrizione, "Descrizione")) {
                return false;
            }
            if (canali == null || canali.length == 0) {
                this.pd.setMessage(MessageFormat.format("Selezionare almeno un valore nel campo {0}", "Canali"));
                return false;
            }
            boolean existsCanale = this.confCore.existsCanaleNodo(canaliNome);
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (existsCanale) {
                    this.pd.setMessage("&Egrave; gi&agrave; presente un Nodo con questo nome.");
                    return false;
                }
            } else if (!oldNome.equals(canaliNome) && existsCanale) {
                this.pd.setMessage("Il nuovo nome scelto &egrave; gi&agrave; utilizzato da un altro Nodo.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void preparePluginsArchiviList(ISearch ricerca, List<RegistroPlugin> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazionePluginsArchivi", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_ARCHIVI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Registro Archivi", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Registro Archivi", "configurazionePluginsArchiviList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Nome", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            if (lista != null && lista.size() > 1) {
                lstLabels.add("Ordine");
            }
            lstLabels.add("Stato");
            lstLabels.add("Nome");
            lstLabels.add("Ultimo Aggiornamento");
            lstLabels.add("Applicabilit&agrave;");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList dati = new ArrayList();
            if (lista != null) {
                Iterator<RegistroPlugin> it = lista.iterator();
                int numeroElementi = lista.size();
                int i = 0;
                while (it.hasNext()) {
                    DataElement de;
                    RegistroPlugin registro = it.next();
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pNomeRegola = new org.openspcoop2.web.lib.mvc.Parameter("plNome", registro.getNome());
                    org.openspcoop2.web.lib.mvc.Parameter pOldNomePlugin = new org.openspcoop2.web.lib.mvc.Parameter("plOldNome", registro.getNome());
                    if (lista.size() > 1) {
                        de = new DataElement();
                        de.setWidthPx(48);
                        de.setType(DataElementType.IMAGE);
                        DataElementImage imageUp = new DataElementImage();
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneSu = new org.openspcoop2.web.lib.mvc.Parameter("plPos", "su");
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneGiu = new org.openspcoop2.web.lib.mvc.Parameter("plPos", "giu");
                        if (i > 0) {
                            imageUp.setImage("&#xE316;");
                            imageUp.setToolTip("Sposta su");
                            imageUp.setUrl("configurazionePluginsArchiviList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pNomeRegola, pDirezioneSu});
                        } else {
                            imageUp.setImage("&#160;&#160;&#160;&#160;&#160;");
                        }
                        de.addImage(imageUp);
                        if (i < numeroElementi - 1) {
                            DataElementImage imageDown = new DataElementImage();
                            imageDown.setImage("&#xE313;");
                            imageDown.setToolTip("Sposta gi&ugrave;");
                            imageDown.setUrl("configurazionePluginsArchiviList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pNomeRegola, pDirezioneGiu});
                            de.addImage(imageDown);
                        }
                        de.setValue("" + registro.getPosizione());
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setWidthPx(10);
                    de.setType(DataElementType.CHECKBOX);
                    if (registro.getStato() == null || StatoFunzionalita.ABILITATO.equals((Object)registro.getStato())) {
                        de.setToolTip("Abilitato");
                        de.setValue("Abilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_ENABLE);
                    } else {
                        de.setToolTip("Disabilitato");
                        de.setValue("Disabilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_DISABLE);
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setIdToRemove(registro.getNome());
                    de.setValue(registro.getNome());
                    de.setToolTip(registro.getNome());
                    de.setUrl("configurazionePluginsArchiviChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pOldNomePlugin});
                    e.add(de);
                    de = new DataElement();
                    Date dataUltimoAggiornamento = registro.getData();
                    String dataValue = "--";
                    if (dataUltimoAggiornamento != null) {
                        dataValue = DateUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm").format(dataUltimoAggiornamento);
                        de.setToolTip(dataValue);
                    }
                    de.setValue(dataValue);
                    e.add(de);
                    de = new DataElement();
                    if (registro.getCompatibilitaList().size() > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (String appValue : registro.getCompatibilitaList()) {
                            TipoPlugin tipo = TipoPlugin.toEnumConstant((String)appValue, (boolean)true);
                            String label = ConfigurazionePluginsTipoPluginUtils.tipoPluginToLabel(tipo);
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(label);
                        }
                        String compatibilita = sb.toString();
                        if (compatibilita.length() > 100) {
                            de.setValue(compatibilita.substring(0, 97) + "...");
                            de.setToolTip(compatibilita);
                        } else {
                            de.setValue(compatibilita);
                        }
                    } else {
                        de.setValue("Qualsiasi Classe");
                    }
                    e.add(de);
                    dati.add(e);
                    ++i;
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE_PLUGIN_ARCHVIO, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ConfigurazioneCostanti.LABEL_PLUGIN_ARCHIVIO_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addRegistroPluginToDati(TipoOperazione tipoOp, List<DataElement> dati, String oldNome, String idArchivioS, String nome, String descrizione, String stato, String sorgente, BinaryParameter jarArchivio, String dirArchivio, String urlArchivio, String classiPlugin, String[] tipoPlugin, int numeroArchivi) {
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Archivio");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        DataElement de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("plNome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        if (!tipoOp.equals((Object)TipoOperazione.ADD)) {
            de = new DataElement();
            de.setLabel("IdArchivio");
            de.setValue(idArchivioS);
            de.setType(DataElementType.HIDDEN);
            de.setName("plId");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(oldNome);
            de.setType(DataElementType.HIDDEN);
            de.setName("plOldNome");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        String[] labelsStato = new String[]{StatoFunzionalita.ABILITATO.toString(), StatoFunzionalita.DISABILITATO.toString()};
        String[] valuesStato = new String[]{StatoFunzionalita.ABILITATO.toString(), StatoFunzionalita.DISABILITATO.toString()};
        de.setLabels(labelsStato);
        de.setValues(valuesStato);
        de.setType(DataElementType.SELECT);
        de.setName("plStato");
        de.setSelected(stato);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(3);
        de.setName("plDescr");
        de.setSize(this.getSize());
        dati.add(de);
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            dati = this.addRegistroPluginJarToDati(TipoOperazione.ADD, dati, false, nome, sorgente, jarArchivio, dirArchivio, urlArchivio);
        } else {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazionePluginsArchiviJarList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("plNome", oldNome)});
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            if (contaListe != null && contaListe.booleanValue()) {
                de.setValue("Archivi Jar (" + numeroArchivi + ")");
            } else {
                de.setValue("Archivi Jar");
            }
            dati.add(de);
        }
        dataElement = new DataElement();
        dataElement.setLabel("Applicabilit&agrave;");
        dataElement.setType(DataElementType.SUBTITLE);
        dati.add(dataElement);
        de = new DataElement();
        de.setLabel("Classi di Plugin");
        de.setName("plClassi");
        de.setType(DataElementType.SELECT);
        de.setLabels(ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_CLASSI_PLUGIN);
        de.setValues(ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_CLASSI_PLUGIN);
        de.setSelected(classiPlugin);
        de.setPostBack(true);
        dati.add(de);
        if (classiPlugin.equals("selezionate")) {
            de = new DataElement();
            de.setLabel("");
            de.setName("plTipo");
            de.setType(DataElementType.MULTI_SELECT);
            de.setLabels(ConfigurazionePluginsTipoPluginUtils.getLabelsTipoPlugin(this.confCore.isConfigurazioneAllarmiEnabled()));
            de.setValues(ConfigurazionePluginsTipoPluginUtils.getValuesTipoPlugin(this.confCore.isConfigurazioneAllarmiEnabled()));
            de.setSelezionati(tipoPlugin);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addRegistroPluginJarToDati(TipoOperazione tipoOp, List<DataElement> dati, boolean addTitle, String nomePlugin, String sorgente, BinaryParameter jarArchivio, String dirArchivio, String urlArchivio) {
        DataElement de;
        if (addTitle) {
            de = new DataElement();
            de.setLabel("Archivio");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nomePlugin);
            de.setType(DataElementType.HIDDEN);
            de.setName("plNome");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Sorgente");
        de.setName("plSorg");
        de.setType(DataElementType.SELECT);
        de.setLabels(ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_SORGENTE);
        de.setValues(ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_SORGENTE);
        de.setSelected(sorgente);
        de.setPostBack(true);
        dati.add(de);
        if (sorgente.equals(ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_SORGENTE_JAR)) {
            DataElement deJarArchivio = jarArchivio.getFileDataElement("Archivio Jar", "", this.getSize());
            deJarArchivio.setRequired(true);
            dati.add(deJarArchivio);
            dati.addAll(jarArchivio.getFileNameDataElement());
            dati.add(jarArchivio.getFileIdDataElement());
        } else if (sorgente.equals(ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_SORGENTE_DIR)) {
            de = new DataElement();
            de.setLabel("Directory");
            de.setValue(dirArchivio);
            de.setType(DataElementType.TEXT_AREA);
            de.setName("plDir");
            de.setSize(this.getSize());
            de.setRequired(true);
            dati.add(de);
        } else {
            de = new DataElement();
            de.setLabel("URL");
            de.setValue(urlArchivio);
            de.setType(DataElementType.TEXT_AREA);
            de.setName("plUrl");
            de.setSize(this.getSize());
            de.setRequired(true);
            dati.add(de);
        }
        return dati;
    }

    public boolean registroPluginCheckData(TipoOperazione tipoOp, String oldNome, String idArchivioS, String nome, String descrizione, String stato, String sorgente, BinaryParameter jarArchivio, String dirArchivio, String urlArchivio, String classiPlugin, String[] tipoPlugin) throws Exception {
        try {
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Indicare un valore nel campo 'Nome'");
                return false;
            }
            if (nome.contains(" ")) {
                this.pd.setMessage("No indicare spazi nel campo 'Nome'");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            boolean existsArchivio = this.confCore.existsRegistroPlugin(nome);
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (existsArchivio) {
                    this.pd.setMessage("Esiste gi&agrave; un Archivio con questo nome.");
                    return false;
                }
            } else if (!nome.equals(oldNome) && existsArchivio) {
                this.pd.setMessage("Il nuovo nome scelto &egrave; gi&agrave; usato per un altro Archivio.");
                return false;
            }
            if (!this.checkLength255(descrizione, "Descrizione")) {
                return false;
            }
            boolean valArchivio = this.registroPluginArchivioCheckData(tipoOp, sorgente, nome, jarArchivio, dirArchivio, urlArchivio, false);
            if (!valArchivio) {
                return valArchivio;
            }
            if (classiPlugin.equals("selezionate") && (tipoPlugin == null || tipoPlugin.length == 0)) {
                this.pd.setMessage("Indicare almeno un valore nel campo 'Classi di Plugin'");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean registroPluginArchivioCheckData(TipoOperazione tipoOp, String sorgente, String nomePlugin, BinaryParameter jarArchivio, String dirArchivio, String urlArchivio, boolean addJar) throws Exception {
        try {
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (sorgente == null || "".equals(sorgente)) {
                    this.pd.setMessage("Indicare un valore nel campo 'Sorgente'");
                    return false;
                }
                PluginSorgenteArchivio pluginSorgenteArchivio = DriverConfigurazioneDBLib.getEnumPluginSorgenteArchivio((String)sorgente);
                if (pluginSorgenteArchivio == null) {
                    this.pd.setMessage("Il valore indicato nel campo 'Sorgente' non &egrave; valido.");
                    return false;
                }
                switch (pluginSorgenteArchivio) {
                    case JAR: {
                        if (jarArchivio.getValue() == null || jarArchivio.getValue().length == 0) {
                            this.pd.setMessage("Indicare un valore nel campo 'Archivio Jar'");
                            return false;
                        }
                        String nomeFile = jarArchivio.getFilename();
                        if (!addJar || !this.confCore.existsRegistroPluginArchivio(nomePlugin, nomeFile)) break;
                        this.pd.setMessage("Un 'Archivio Jar' con lo stesso nome \u00e8 gi\u00e0 stato assegnato al plugin");
                        return false;
                    }
                    case URL: {
                        if (urlArchivio == null || "".equals(urlArchivio)) {
                            this.pd.setMessage("Indicare un valore nel campo 'URL'");
                            return false;
                        }
                        if (urlArchivio.contains(" ")) {
                            this.pd.setMessage("Non indicare spazi nel campo 'URL'");
                            return false;
                        }
                        if (!this.checkLength4000(urlArchivio, "URL")) {
                            return false;
                        }
                        try {
                            new URI(urlArchivio).toURL();
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il valore indicato nel campo 'URL' non rappresenta una URL valida.");
                            return false;
                        }
                        if (!addJar || !this.confCore.existsRegistroPluginArchivio(nomePlugin, pluginSorgenteArchivio, urlArchivio)) break;
                        this.pd.setMessage("Un 'Archivio Jar', riferito con la stessa URL, \u00e8 gi\u00e0 stato assegnato al plugin");
                        return false;
                    }
                    case DIR: {
                        if (dirArchivio == null || "".equals(dirArchivio)) {
                            this.pd.setMessage("Indicare un valore nel campo 'Directory'");
                            return false;
                        }
                        if (dirArchivio.contains(" ")) {
                            this.pd.setMessage("Non indicare spazi nel campo 'Directory'");
                            return false;
                        }
                        if (!this.checkLength4000(dirArchivio, "Directory")) {
                            return false;
                        }
                        try {
                            Paths.get(dirArchivio, new String[0]);
                        }
                        catch (InvalidPathException ex) {
                            this.pd.setMessage("Il valore indicato nel campo 'Directory' non rappresenta un path valido.");
                            return false;
                        }
                        catch (NullPointerException ex) {
                            this.pd.setMessage("Il valore indicato nel campo 'Directory' non rappresenta un path valido.");
                            return false;
                        }
                        if (!addJar || !this.confCore.existsRegistroPluginArchivio(nomePlugin, pluginSorgenteArchivio, dirArchivio)) break;
                        this.pd.setMessage("Un repository di 'Archivi Jar', riferito con la directory indicata, \u00e8 gi\u00e0 stato assegnato al plugin");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void preparePluginsArchiviJarList(String nome, ISearch ricerca, List<RegistroPluginArchivio> lista) throws Exception {
        try {
            org.openspcoop2.web.lib.mvc.Parameter pNomeRegistro = new org.openspcoop2.web.lib.mvc.Parameter("plNome", nome);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazionePluginsArchiviJar", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[]{pNomeRegistro});
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_ARCHIVI_JAR;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            HashMap<String, String> campiHidden = new HashMap<String, String>();
            campiHidden.put("plNome", nome);
            this.pd.setHidden(campiHidden);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Registro Archivi", "configurazionePluginsArchiviList.do"));
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter(nome, "configurazionePluginsArchiviChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("plOldNome", nome)}));
            this.pd.setSearchLabel("Nome");
            String labelJarDi = "Archivi Jar";
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter(labelJarDi, null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter(labelJarDi, "configurazionePluginsArchiviJarList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pNomeRegistro}));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Nome", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            lstLabels.add("Data Registrazione");
            lstLabels.add("Tipo Sorgente");
            lstLabels.add("Sorgente");
            lstLabels.add("Archivio");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList dati = new ArrayList();
            boolean visualizzaElimina = false;
            if (lista != null) {
                Iterator<RegistroPluginArchivio> it = lista.iterator();
                boolean bl = visualizzaElimina = lista.size() > 1;
                while (it.hasNext()) {
                    RegistroPluginArchivio registro = it.next();
                    PluginSorgenteArchivio sorgente = registro.getSorgente();
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setIdToRemove(registro.getNome());
                    Date dataInserimento = registro.getData();
                    String dataValue = "--";
                    if (dataInserimento != null) {
                        dataValue = DateUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm").format(dataInserimento);
                        de.setToolTip(dataValue);
                    }
                    de.setValue(dataValue);
                    e.add(de);
                    de = new DataElement();
                    switch (sorgente) {
                        case DIR: {
                            de.setValue("Directory");
                            break;
                        }
                        case JAR: {
                            de.setValue("Archivio Jar");
                            break;
                        }
                        case URL: {
                            de.setValue("URL");
                        }
                    }
                    e.add(de);
                    de = new DataElement();
                    switch (sorgente) {
                        case DIR: {
                            de.setValue(registro.getDir());
                            break;
                        }
                        case JAR: {
                            de.setValue(registro.getNome());
                            break;
                        }
                        case URL: {
                            de.setValue(registro.getUrl());
                        }
                    }
                    e.add(de);
                    de = new DataElement();
                    switch (sorgente) {
                        case DIR: {
                            de.setValue("-");
                            break;
                        }
                        case JAR: {
                            de.setValue("Download".toLowerCase());
                            de.setUrl("downloadDocumento", new org.openspcoop2.web.lib.mvc.Parameter[]{new org.openspcoop2.web.lib.mvc.Parameter("tipoDocumentoDaScaricare", "jar"), new org.openspcoop2.web.lib.mvc.Parameter("tipoDocumento", "jar"), new org.openspcoop2.web.lib.mvc.Parameter("nomePlugin", registro.getNomePlugin()), new org.openspcoop2.web.lib.mvc.Parameter("nomeJar", registro.getNome())});
                            de.setDisabilitaAjaxStatus();
                            break;
                        }
                        case URL: {
                            de.setValue("-");
                        }
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            this.pd.setRemoveButton(visualizzaElimina);
            this.pd.setSelect(visualizzaElimina);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void preparePluginsClassiList(ISearch ricerca, List<Plugin> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            DataElement de;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazionePluginsClassi", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_CLASSI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String filterTipo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoPluginClassi");
            this.addFilterTipoPlugin(filterTipo, true);
            if (!filterTipo.equals("")) {
                ConfigurazionePluginsTipoPluginUtils.addFiltriSpecificiTipoPlugin(this.pd, this.log, ricerca, idLista, filterTipo, this.getSize(), this.confCore.isIntegrationManagerEnabled());
            }
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            this.pd.setSearchLabel("Label");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Registro Classi", null));
            } else {
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Registro Classi", "configurazionePluginsClassiList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Label", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            lstLabels.add("Stato");
            lstLabels.add("Tipo Plugin");
            lstLabels.add("Tipo");
            lstLabels.add("Label");
            lstLabels.add("Applicabilit&agrave;");
            lstLabels.add("Uso");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            if (lista != null) {
                for (Plugin registro : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    org.openspcoop2.web.lib.mvc.Parameter pIdRegistro = new org.openspcoop2.web.lib.mvc.Parameter("pcId", "" + registro.getId());
                    de = new DataElement();
                    de.setWidthPx(10);
                    de.setType(DataElementType.CHECKBOX);
                    if (registro.getStato()) {
                        de.setToolTip("Abilitato");
                        de.setValue("Abilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_ENABLE);
                    } else {
                        de.setToolTip("Disabilitato");
                        de.setValue("Disabilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_DISABLE);
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setIdToRemove("" + registro.getId());
                    TipoPlugin tipoPlugin = TipoPlugin.toEnumConstant((String)registro.getTipoPlugin());
                    String tipoPluginLabel = ConfigurazionePluginsTipoPluginUtils.tipoPluginToLabel(tipoPlugin);
                    de.setValue(tipoPluginLabel);
                    if (registro.getDescrizione() != null && !"".equals(registro.getDescrizione())) {
                        de.setToolTip(registro.getDescrizione());
                    } else {
                        de.setToolTip(tipoPluginLabel);
                    }
                    de.setUrl("configurazionePluginsClassiChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdRegistro});
                    e.add(de);
                    de = new DataElement();
                    de.setValue(registro.getTipo());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(registro.getLabel());
                    e.add(de);
                    de = new DataElement();
                    String applicabilita = ConfigurazionePluginsTipoPluginUtils.getApplicabilitaClassePlugin(registro);
                    if (applicabilita != null) {
                        if (applicabilita.length() > 100) {
                            de.setValue(applicabilita.substring(0, 97) + "...");
                            de.setToolTip(applicabilita);
                        } else {
                            de.setValue(applicabilita);
                        }
                    } else {
                        de.setValue("-");
                    }
                    e.add(de);
                    this.addInUsoButtonVisualizzazioneClassica(e, tipoPluginLabel + " - " + registro.getLabel(), "" + registro.getId(), InUsoType.PLUGIN_CLASSE);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE_PLUGIN_CLASSE, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ConfigurazioneCostanti.LABEL_PLUGIN_CLASSE_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addPluginClassiToDati(TipoOperazione tipoOp, List<DataElement> dati, String idPluginS, TipoPlugin tipoPlugin, String tipo, String label, String className, String stato, String descrizione, String ruolo, String shTipo, String mhTipo, String mhRuolo, String applicabilita) {
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Plugin");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        boolean visualizzaAllarmi = this.confCore.isVisualizzaConfigurazioneAllarmiEnabled();
        DataElement de = new DataElement();
        de.setLabel("Tipo Plugin");
        ArrayList<String> labels = new ArrayList<String>();
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            labels.add("-");
        }
        labels.addAll(ConfigurazionePluginsTipoPluginUtils.getLabelsTipoPlugin(visualizzaAllarmi));
        ArrayList<String> values = new ArrayList<String>();
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            values.add("--");
        }
        values.addAll(ConfigurazionePluginsTipoPluginUtils.getValuesTipoPlugin(visualizzaAllarmi));
        de.setLabels(labels);
        de.setValues(values);
        de.setType(DataElementType.SELECT);
        de.setName("pcTipoPlugin");
        if (tipoPlugin != null) {
            de.setSelected(tipoPlugin.toString());
        }
        if (tipoOp.equals((Object)TipoOperazione.ADD)) {
            de.setRequired(true);
        }
        de.setPostBack(true);
        dati.add(de);
        if (!tipoOp.equals((Object)TipoOperazione.ADD)) {
            de = new DataElement();
            de.setLabel("Id");
            de.setValue(idPluginS);
            de.setType(DataElementType.HIDDEN);
            de.setName("pcId");
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (tipoPlugin != null) {
            dati = ConfigurazionePluginsTipoPluginUtils.getSezioneDinamicaClassePlugin(dati, tipoPlugin, ruolo, shTipo, mhTipo, mhRuolo, applicabilita, this.confCore.isIntegrationManagerEnabled());
        }
        de = new DataElement();
        de.setLabel("Tipo");
        de.setValue(tipo);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("pcTipo");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("ClassName");
        de.setValue(className);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(2);
        de.setName("pcClassName");
        de.setSize(this.getSize());
        de.setRequired(true);
        if (tipoPlugin != null) {
            ConfigurazionePluginsTipoPluginUtils.addInfoClassePlugin(de, tipoPlugin, ruolo, shTipo, mhTipo, mhRuolo, this.confCore.isIntegrationManagerEnabled());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Label");
        de.setValue(label);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("pcLabel");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        String[] labelsStato = new String[]{StatoFunzionalita.ABILITATO.toString(), StatoFunzionalita.DISABILITATO.toString()};
        String[] valuesStato = new String[]{StatoFunzionalita.ABILITATO.toString(), StatoFunzionalita.DISABILITATO.toString()};
        de.setLabels(labelsStato);
        de.setValues(valuesStato);
        de.setType(DataElementType.SELECT);
        de.setName("pcStato");
        de.setSelected(stato);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(3);
        de.setName("pcDescr");
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public boolean pluginClassiCheckData(TipoOperazione tipoOp, Plugin oldPlugin, String idPluginS, TipoPlugin tipoPlugin, String tipo, String label, String className, String stato, String descrizione, String ruolo, String shTipo, String mhTipo, String mhRuolo, String applicabilita) throws Exception {
        try {
            int lenghtMax;
            if (tipoPlugin == null) {
                this.pd.setMessage("Indicare un valore nel campo 'Tipo Plugin'");
                return false;
            }
            if (tipo == null || "".equals(tipo)) {
                this.pd.setMessage("Indicare un valore nel campo 'Tipo'");
                return false;
            }
            if (tipo.contains(" ")) {
                this.pd.setMessage("Non indicare spazi nel campo 'Tipo'");
                return false;
            }
            if (!this.checkSimpleName(tipo, "Tipo")) {
                return false;
            }
            if (TipoPlugin.AUTENTICAZIONE.equals((Object)tipoPlugin) ? !this.checkLength(tipo, "Tipo", 1, lenghtMax = 20 - (TipoCredenzialeMittente.TRASPORTO.getRawValue() + "_").length()) : !this.checkLength255(tipo, "Tipo")) {
                return false;
            }
            if (label == null || "".equals(label)) {
                this.pd.setMessage("Indicare un valore nel campo 'Label'");
                return false;
            }
            if (!this.checkLength255(label, "Label")) {
                return false;
            }
            if (className == null || "".equals(className)) {
                this.pd.setMessage("Indicare un valore nel campo 'ClassName'");
                return false;
            }
            if (className.contains(" ")) {
                this.pd.setMessage("Non indicare spazi nel campo 'ClassName'");
                return false;
            }
            if (!this.checkLength255(className, "ClassName")) {
                return false;
            }
            if (!this.checkLength255(descrizione, "Descrizione")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                boolean modificatiElementiRiferiti;
                TipoPlugin oldTipoPlugin = TipoPlugin.toEnumConstant((String)oldPlugin.getTipoPlugin());
                boolean oldStatoEnabled = ServletUtils.isCheckBoxEnabled((String)stato);
                boolean bl = modificatiElementiRiferiti = !tipoPlugin.equals((Object)oldTipoPlugin) || !tipo.equals(oldPlugin.getTipo()) || oldStatoEnabled != oldPlugin.getStato();
                if (modificatiElementiRiferiti) {
                    HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                    boolean normalizeObjectIds = !this.isModalitaCompleta();
                    boolean pluginInUso = this.confCore.isPluginInUso(oldPlugin.getClassName(), oldPlugin.getLabel(), oldPlugin.getTipoPlugin(), oldPlugin.getTipo(), whereIsInUso, normalizeObjectIds);
                    if (pluginInUso) {
                        if (oldStatoEnabled != oldPlugin.getStato()) {
                            this.pd.setMessage("Il plugin risulta essere utilizzato in configurazioni e quindi non \u00e8 consentito modificarne lo stato");
                        } else {
                            this.pd.setMessage("Il plugin risulta essere utilizzato in configurazioni e quindi non \u00e8 consentito modificarne il tipo");
                        }
                        return false;
                    }
                }
            }
            boolean existsPluginConTipo = this.confCore.existsPluginConTipo(tipoPlugin, tipo);
            boolean existsPluginConLabel = this.confCore.existsPluginConLabel(tipoPlugin, label);
            boolean existsPluginConClassName = this.confCore.existsPluginConClassName(tipoPlugin, className);
            boolean errorExists = false;
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                errorExists = existsPluginConTipo || existsPluginConLabel || existsPluginConClassName;
            } else {
                TipoPlugin oldTipoPlugin = TipoPlugin.toEnumConstant((String)oldPlugin.getTipoPlugin());
                if (!tipoPlugin.equals((Object)oldTipoPlugin)) {
                    errorExists = existsPluginConTipo || existsPluginConLabel || existsPluginConClassName;
                } else if (!tipo.equals(oldPlugin.getTipo()) && existsPluginConTipo) {
                    errorExists = true;
                } else if (!label.equals(oldPlugin.getLabel()) && existsPluginConLabel) {
                    errorExists = true;
                } else if (!className.equals(oldPlugin.getClassName()) && existsPluginConClassName) {
                    errorExists = true;
                }
            }
            if (errorExists) {
                String descrizioneTipoPlugin = ConfigurazionePluginsTipoPluginUtils.tipoPluginToLabel(tipoPlugin);
                if (existsPluginConTipo) {
                    this.pd.setMessage(MessageFormat.format("Esiste gi&agrave; un plugin ''{0}'' con lo stesso tipo ''{1}''", descrizioneTipoPlugin, tipo));
                    return false;
                }
                if (existsPluginConLabel) {
                    this.pd.setMessage(MessageFormat.format("Esiste gi&agrave; un plugin {0} con la stessa label ''{1}''", descrizioneTipoPlugin, label));
                    return false;
                }
                if (existsPluginConClassName) {
                    this.pd.setMessage(MessageFormat.format("Esiste gi&agrave; un plugin {0} con la stessa classe ''{1}''", descrizioneTipoPlugin, className));
                    return false;
                }
            }
            return this.checkLength255(descrizione, "Descrizione");
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterTipoPlugin(String tipoPlugin, boolean postBack) throws Exception {
        try {
            boolean visualizzaAllarmi = this.confCore.isVisualizzaConfigurazioneAllarmiEnabled();
            List<String> valuesTipoPlugin = ConfigurazionePluginsTipoPluginUtils.getValuesTipoPlugin(visualizzaAllarmi);
            List<String> labelsTipoPlugin = ConfigurazionePluginsTipoPluginUtils.getLabelsTipoPlugin(visualizzaAllarmi);
            int length = 1;
            if (valuesTipoPlugin != null && valuesTipoPlugin.size() > 0) {
                length += valuesTipoPlugin.size();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (valuesTipoPlugin != null && valuesTipoPlugin.size() > 0) {
                for (int i = 0; i < valuesTipoPlugin.size(); ++i) {
                    labels[i + 1] = labelsTipoPlugin.get(i);
                    values[i + 1] = valuesTipoPlugin.get(i);
                }
            }
            this.pd.addFilter("filtroTipoPluginClassi", "Tipo Plugin", tipoPlugin, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFiltriSpecificiTipoPlugin(String tipoPlugin, boolean postBack) throws Exception {
        try {
            List<String> valuesTipoPlugin = ConfigurazionePluginsTipoPluginUtils.getValuesTipoPlugin(this.confCore.isConfigurazioneAllarmiEnabled());
            List<String> labelsTipoPlugin = ConfigurazionePluginsTipoPluginUtils.getLabelsTipoPlugin(this.confCore.isConfigurazioneAllarmiEnabled());
            int length = 1;
            if (valuesTipoPlugin != null && valuesTipoPlugin.size() > 0) {
                length += valuesTipoPlugin.size();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (valuesTipoPlugin != null && valuesTipoPlugin.size() > 0) {
                for (int i = 0; i < valuesTipoPlugin.size(); ++i) {
                    labels[i + 1] = labelsTipoPlugin.get(i);
                    values[i + 1] = valuesTipoPlugin.get(i);
                }
            }
            this.pd.addFilter("filtroTipoPluginClassi", "Tipo Plugin", tipoPlugin, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareAllarmiList(ConsoleSearch ricerca, List<ConfigurazioneAllarmeBean> lista, RuoloPorta ruoloPorta, String nomePorta, ServiceBinding serviceBinding) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamSession = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = null;
            if (ruoloPorta != null) {
                parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("allRuoloPorta", ruoloPorta.getValue());
                lstParamSession.add(parRuoloPorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parNomePorta = null;
            if (nomePorta != null) {
                parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("allNomePorta", nomePorta);
                lstParamSession.add(parNomePorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = null;
            if (serviceBinding != null) {
                parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("allServiceBinding", serviceBinding.name());
                lstParamSession.add(parServiceBinding);
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneAllarmi", lstParamSession);
            int idLista = Liste.CONFIGURAZIONE_ALLARMI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterStato = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroStato");
            boolean addStatiAllarme = this.confCore.isShowAllarmiSearchStatiAllarmi();
            this.addFilterStato(filterStato, addStatiAllarme, false);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            this.pd.setCustomListViewName("allarmi");
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
            if (ruoloPorta != null) {
                lstParamPorta = this.getTitleListAllarmi(ruoloPorta, nomePorta, serviceBinding, null);
            }
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
            }
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParam = null;
            if (lstParamPorta != null) {
                lstParam = lstParamPorta;
            } else {
                lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Allarmi", null));
            }
            if (!search.equals("")) {
                if (lstParamSession.size() > 0) {
                    lstParam.set(lstParam.size() - 1, new org.openspcoop2.web.lib.mvc.Parameter("Allarmi", "configurazioneAllarmiList.do", lstParamSession.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamSession.size()])));
                } else {
                    lstParam.set(lstParam.size() - 1, new org.openspcoop2.web.lib.mvc.Parameter("Allarmi", "configurazioneAllarmiList.do"));
                }
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (ruoloPorta != null) {
                this.impostaComandiMenuContestualeAllarmi(ruoloPorta, nomePorta);
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Allarmi", (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            lstLabels.add("");
            lstLabels.add("Allarmi");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (lista != null) {
                Iterator<ConfigurazioneAllarmeBean> it = lista.iterator();
                while (it.hasNext()) {
                    List<DataElement> e = this.creaEntryAllarmeCustom(lstParamSession, it);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && lista.size() > 0 && this.core.isShowPulsantiImportExport() && (nomePorta == null || StringUtils.isEmpty((CharSequence)nomePorta)) && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.ALLARME, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ConfigurazioneCostanti.LABEL_ALLARMI_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void impostaComandiMenuContestualeAllarmi(RuoloPorta ruoloPorta, String nomePorta) throws Exception {
        if (ruoloPorta != null) {
            if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                IDPortaDelegata idPortaDelegata = new IDPortaDelegata();
                idPortaDelegata.setNome(nomePorta);
                PortaDelegata myPD = this.porteDelegateCore.getPortaDelegata(idPortaDelegata);
                MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(myPD);
                long idSoggetto = myPD.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPD.getIdServizio());
                long idFruizione = this.apsCore.getIdFruizioneAccordoServizioParteSpecifica(mappingPD.getIdFruitore(), mappingPD.getIdServizio());
                PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
                porteDelegateHelper.impostaComandiMenuContestualePD("" + idSoggetto, "" + idAsps, "" + idFruizione);
            } else {
                IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                idPortaApplicativa.setNome(nomePorta);
                PortaApplicativa myPA = this.porteApplicativeCore.getPortaApplicativa(idPortaApplicativa);
                MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(myPA);
                long idSoggetto = myPA.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPA.getIdServizio());
                PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(this.request, this.pd, this.session);
                porteApplicativeHelper.impostaComandiMenuContestualePA("" + idSoggetto, "" + idAsps);
            }
        }
    }

    public List<DataElement> creaEntryAllarme(List<org.openspcoop2.web.lib.mvc.Parameter> lstParamSession, Iterator<ConfigurazioneAllarmeBean> it) throws UtilsException {
        String mode;
        ConfigurazioneAllarmeBean allarme = it.next();
        org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("allId", "" + allarme.getId());
        ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntry = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
        lstParamEntry.add(pId);
        if (lstParamSession.size() > 0) {
            lstParamEntry.addAll(lstParamSession);
        }
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        de.setWidthPx(10);
        de.setType(DataElementType.CHECKBOX);
        if (allarme.getEnabled() == 1) {
            if (this.confCore.isShowAllarmiElenchiStatiAllarmi().booleanValue()) {
                if (allarme.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_OK.intValue()) {
                    de.setToolTip("Ok");
                    de.setValue("Ok");
                    de.setSelected(CheckboxStatusType.CONFIG_ENABLE);
                } else if (allarme.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_ERROR.intValue()) {
                    de.setToolTip("Error");
                    de.setValue("Error");
                    de.setSelected(CheckboxStatusType.CONFIG_ERROR);
                } else if (allarme.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_WARNING.intValue()) {
                    de.setToolTip("Warning");
                    de.setValue("Warning");
                    de.setSelected(CheckboxStatusType.CONFIG_WARNING);
                }
            } else {
                de.setToolTip("Abilitato");
                de.setValue("Abilitato");
                de.setSelected(CheckboxStatusType.CONFIG_ENABLE);
            }
        } else {
            de.setToolTip("Disabilitato");
            de.setValue("Disabilitato");
            de.setSelected(CheckboxStatusType.CONFIG_DISABLE);
        }
        de.setUrl("configurazioneAllarmiChange.do", lstParamEntry.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntry.size()]));
        e.add(de);
        de = new DataElement();
        de.setWidthPx(24);
        de.setType(DataElementType.IMAGE);
        DataElementImage imageUp = new DataElementImage();
        String string = mode = TipoAllarme.ATTIVO.equals((Object)allarme.getTipoAllarme()) ? "Attiva" : "Passiva";
        if (TipoAllarme.ATTIVO.equals((Object)allarme.getTipoAllarme())) {
            imageUp.setImage("&#xE855;");
            imageUp.setToolTip(mode);
        } else {
            imageUp.setImage("&#xE857;");
            imageUp.setToolTip(mode);
        }
        de.addImage(imageUp);
        de.allineaTdAlCentro();
        de.setValue(mode);
        e.add(de);
        de = new DataElement();
        de.setUrl("configurazioneAllarmiChange.do", lstParamEntry.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntry.size()]));
        de.setValue(allarme.getAlias());
        de.setIdToRemove("" + allarme.getId());
        de.setToolTip(allarme.getAlias());
        e.add(de);
        de = new DataElement();
        de.setValue(allarme.getDescrizioneAbbr());
        de.setToolTip(allarme.getDescrizione());
        e.add(de);
        boolean isActive = allarme.getEnabled() == 1 && TipoAllarme.ATTIVO.equals((Object)allarme.getTipoAllarme());
        de = new DataElement();
        if (isActive) {
            de.setValue("Visualizza");
        } else {
            de.setValue("-");
        }
        de.allineaTdAlCentro();
        de.setWidthPx(60);
        if (isActive) {
            org.openspcoop2.web.lib.mvc.Parameter pState = new org.openspcoop2.web.lib.mvc.Parameter("AlarmViewState", "true");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntryState = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParamEntryState.addAll(lstParamEntry);
            lstParamEntryState.add(pState);
            de.setUrl("configurazioneAllarmiChange.do", lstParamEntryState.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntryState.size()]));
        }
        e.add(de);
        return e;
    }

    private List<DataElement> creaEntryAllarmeCustom(List<org.openspcoop2.web.lib.mvc.Parameter> lstParamSession, Iterator<ConfigurazioneAllarmeBean> it) throws UtilsException {
        ConfigurazioneAllarmeBean allarme = it.next();
        org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("allId", "" + allarme.getId());
        ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntry = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
        lstParamEntry.add(pId);
        if (lstParamSession.size() > 0) {
            lstParamEntry.addAll(lstParamSession);
        }
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        de.setUrl("configurazioneAllarmiChange.do", lstParamEntry.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntry.size()]));
        de.setValue(allarme.getAlias());
        de.setIdToRemove("" + allarme.getId());
        de.setType(DataElementType.TITLE);
        e.add(de);
        de = new DataElement();
        String mode = TipoAllarme.ATTIVO.equals((Object)allarme.getTipoAllarme()) ? "Attiva" : "Passiva";
        String descrAbbr = allarme.getDescrizioneAbbr();
        if (StringUtils.isNotBlank((CharSequence)descrAbbr)) {
            de.setValue(MessageFormat.format("Modalit&agrave;: {0}, Descrizione: {1}", mode, descrAbbr));
        } else {
            de.setValue(MessageFormat.format("Modalit&agrave;: {0}", mode));
        }
        de.setType(DataElementType.SUBTITLE);
        e.add(de);
        de = new DataElement();
        de.setWidthPx(16);
        de.setType(DataElementType.CHECKBOX);
        if (allarme.getEnabled() == 1) {
            if (this.confCore.isShowAllarmiElenchiStatiAllarmi().booleanValue()) {
                if (allarme.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_OK.intValue()) {
                    de.setStatusType(CheckboxStatusType.CONFIG_ENABLE);
                    de.setStatusToolTip("Ok");
                } else if (allarme.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_ERROR.intValue()) {
                    de.setStatusType(CheckboxStatusType.CONFIG_ERROR);
                    de.setStatusToolTip("Error");
                } else if (allarme.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_WARNING.intValue()) {
                    de.setStatusType(CheckboxStatusType.CONFIG_WARNING);
                    de.setStatusToolTip("Warning");
                }
            } else {
                de.setStatusType(CheckboxStatusType.CONFIG_ENABLE);
                de.setStatusToolTip("Abilitato");
            }
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            de.setStatusToolTip("Disabilitato");
        }
        e.add(de);
        boolean isActive = allarme.getEnabled() == 1 && TipoAllarme.ATTIVO.equals((Object)allarme.getTipoAllarme());
        de = new DataElement();
        if (isActive) {
            org.openspcoop2.web.lib.mvc.Parameter pState = new org.openspcoop2.web.lib.mvc.Parameter("AlarmViewState", "true");
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntryState = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            lstParamEntryState.addAll(lstParamEntry);
            lstParamEntryState.add(pState);
            this.addVisualizzaRuntimeButton(e, "configurazioneAllarmiChange.do", lstParamEntryState);
        }
        return e;
    }

    public List<org.openspcoop2.web.lib.mvc.Parameter> getTitleListAllarmi(RuoloPorta ruoloPorta, String nomePorta, ServiceBinding serviceBinding, String nomeOggetto) throws Exception {
        List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
        if (ruoloPorta != null) {
            Object labelPerPorta = null;
            if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                Integer parentPD = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
                if (parentPD == null) {
                    parentPD = 0;
                }
                IDPortaDelegata idPortaDelegata = new IDPortaDelegata();
                idPortaDelegata.setNome(nomePorta);
                PortaDelegata myPD = this.porteDelegateCore.getPortaDelegata(idPortaDelegata);
                String idporta = myPD.getNome();
                MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(myPD);
                long idSoggetto = myPD.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPD.getIdServizio());
                long idFruizione = this.apsCore.getIdFruizioneAccordoServizioParteSpecifica(mappingPD.getIdFruitore(), mappingPD.getIdServizio());
                PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
                lstParamPorta = porteDelegateHelper.getTitoloPD(parentPD, "" + idSoggetto, "" + idAsps, "" + idFruizione);
                labelPerPorta = parentPD != null && parentPD == 2 ? this.porteDelegateCore.getLabelRegolaMappingFruizionePortaDelegata("Allarmi di ", "Allarmi", myPD) : "Allarmi di " + idporta;
            } else {
                Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
                IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                idPortaApplicativa.setNome(nomePorta);
                PortaApplicativa myPA = this.porteApplicativeCore.getPortaApplicativa(idPortaApplicativa);
                String idporta = myPA.getNome();
                MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(myPA);
                long idSoggetto = myPA.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPA.getIdServizio());
                PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(this.request, this.pd, this.session);
                lstParamPorta = porteApplicativeHelper.getTitoloPA(parentPA, "" + idSoggetto, "" + idAsps);
                labelPerPorta = parentPA != null && parentPA == 2 ? this.porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Allarmi di ", "Allarmi", myPA) : "Allarmi di " + idporta;
            }
            if (nomeOggetto == null) {
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter((String)labelPerPorta, null));
            } else {
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> list = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                list.add(new org.openspcoop2.web.lib.mvc.Parameter("allRuoloPorta", ruoloPorta.getValue()));
                list.add(new org.openspcoop2.web.lib.mvc.Parameter("allNomePorta", nomePorta));
                if (serviceBinding != null) {
                    list.add(new org.openspcoop2.web.lib.mvc.Parameter("allServiceBinding", serviceBinding.name()));
                }
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter((String)labelPerPorta, "configurazioneAllarmiList.do", list));
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter(nomeOggetto, null));
            }
        }
        return lstParamPorta;
    }

    public boolean allarmeCheckData(StringBuilder sbParsingError, TipoOperazione tipoOp, ConfigurazioneAllarmeBean oldAllarme, ConfigurazioneAllarmeBean allarme, int numeroPluginRegistrati, List<Parameter<?>> parameters) throws Exception {
        try {
            boolean existsAllarme;
            if (sbParsingError.length() > 0) {
                this.pd.setMessage(sbParsingError.toString());
                return false;
            }
            if (allarme.getPlugin() == null) {
                if (numeroPluginRegistrati > 0) {
                    this.log.debug("Non \u00e8 stato selezionato un plugin");
                    this.pd.setMessage("Indicare un valore nel campo 'Plugin'");
                    return false;
                }
                this.log.debug("Non risultano registrati plugins di allarmi");
                this.pd.setMessage("Non risultano registrati plugins per gli allarmi. Prima di poter creare un allarme personalizzato \u00e8 necessario registrare almeno un plugin tramite la sezione 'Archivi Plugin'");
                return false;
            }
            if (allarme.getTipoAllarme() == null) {
                this.log.debug("Non \u00e8 stato indicato il tipo di allarme (\u00e8 stato selezionato un plugin?)");
                this.pd.setMessage("Non \u00e8 stato indicato il tipo di allarme (\u00e8 stato selezionato un plugin?)");
                return false;
            }
            if (allarme.getNome() == null || "".equals(allarme.getNome())) {
                this.log.debug("Non \u00e8 stato indicato un nome identificativo dell'allarme");
                this.pd.setMessage("Indicare un valore nel campo 'Identificativo Runtime'");
                return false;
            }
            if (!this.checkNCNameAndSerial(allarme.getNome(), "Identificativo Runtime")) {
                return false;
            }
            if (allarme.getAlias() == null || "".equals(allarme.getAlias())) {
                this.log.debug("Non \u00e8 stato indicato un nome per l'allarme");
                this.pd.setMessage("Indicare un valore nel campo 'Nome'");
                return false;
            }
            if (!this.checkNCName(allarme.getAlias(), "Nome")) {
                return false;
            }
            if (allarme.getTipoAllarme().equals((Object)TipoAllarme.ATTIVO)) {
                if (allarme.getPeriodo() == null) {
                    this.log.debug("Non \u00e8 stata indicata la frequenza di attivazione per il controllo dello stato dell'allarme");
                    this.pd.setMessage("Non \u00e8 stata indicata la frequenza di attivazione per il controllo dello stato dell'allarme.");
                    return false;
                }
                if (allarme.getPeriodo() <= 0) {
                    this.log.debug("Indicare una frequenza di attivazione (maggiore di 0) per il controllo dello stato dell'allarme");
                    this.pd.setMessage("Indicare una frequenza di attivazione (maggiore di 0) per il controllo dello stato dell'allarme");
                    return false;
                }
            }
            if (allarme.getFiltro().isEnabled() && (allarme.getFiltro().getRuoloPorta() == null || RuoloPorta.ENTRAMBI.equals((Object)allarme.getFiltro().getRuoloPorta())) && allarme.getFiltro().getProtocollo() == null && allarme.getFiltro().getRuoloFruitore() == null && allarme.getFiltro().getTipoFruitore() == null && allarme.getFiltro().getNomeFruitore() == null && allarme.getFiltro().getServizioApplicativoFruitore() == null && allarme.getFiltro().getRuoloErogatore() == null && allarme.getFiltro().getTipoErogatore() == null && allarme.getFiltro().getNomeErogatore() == null && allarme.getFiltro().getTag() == null && allarme.getFiltro().getTipoServizio() == null && allarme.getFiltro().getNomeServizio() == null && allarme.getFiltro().getAzione() == null) {
                String messaggio = "Se si abilita il filtro deve essere selezionato almeno un criterio";
                this.pd.setMessage(messaggio);
                return false;
            }
            if (!(!allarme.getGroupBy().isEnabled() || allarme.getGroupBy().isRuoloPorta() || allarme.getGroupBy().getProtocollo() || allarme.getGroupBy().getFruitore() || allarme.getGroupBy().getServizioApplicativoFruitore() || allarme.getGroupBy().getIdentificativoAutenticato() || allarme.getGroupBy().getToken() != null && !"".equals(allarme.getGroupBy().getToken()) || allarme.getGroupBy().getErogatore() || allarme.getGroupBy().getServizio() || allarme.getGroupBy().getAzione())) {
                String messaggio = "Se si abilita il collezionamento dei dati deve essere selezionato almeno un criterio di raggruppamento";
                this.pd.setMessage(messaggio);
                return false;
            }
            IDynamicValidator v = DynamicFactory.getInstance().newDynamicValidator(TipoPlugin.ALLARME, allarme.getTipo(), allarme.getPlugin().getClassName(), this.log);
            Context context = this.createAlarmContext(allarme, parameters);
            try {
                v.validate(context);
            }
            catch (ValidationException e) {
                StringBuilder sb = new StringBuilder();
                sb.append(e.getMessage());
                Map errors = e.getErrors();
                if (errors != null) {
                    Set keys = errors.keySet();
                    StringBuilder sbInner = new StringBuilder();
                    for (String key : keys) {
                        if (sbInner.length() > 0) {
                            sbInner.append("\n");
                        }
                        Parameter sp = context.getParameter(key);
                        String errorMsg = (String)errors.get(key);
                        String label = sp != null ? sp.getRendering().getLabel() : key;
                        sbInner.append(label).append(": ").append(errorMsg);
                    }
                    sb.append("\n").append(sbInner.toString());
                }
                this.pd.setMessage(sb.toString());
                return false;
            }
            if (allarme.getMail() != null && allarme.getMail().getInvia() != null && allarme.getMail().getInvia() == 1) {
                if (allarme.getMail().getDestinatari() == null || "".equals(allarme.getMail().getDestinatari())) {
                    this.log.debug("Almeno un indirizzo e-mail \u00e8 obbligatorio");
                    this.pd.setMessage("Almeno un indirizzo e-mail \u00e8 obbligatorio");
                    return false;
                }
                String[] tmp = allarme.getMail().getDestinatari().split(",");
                for (int i = 0; i < tmp.length; ++i) {
                    if (this.checkEmail(tmp[i].trim(), "E-mail")) continue;
                    this.log.debug("L'indirizzo e-mail fornito [" + tmp[i].trim() + "] non risulta valido");
                    return false;
                }
            }
            boolean porta = allarme.getFiltro() != null && allarme.getFiltro().isEnabled() && allarme.getFiltro().getRuoloPorta() != null && allarme.getFiltro().getNomePorta() != null;
            boolean existsAlias = false;
            ConsoleSearch search = new ConsoleSearch(true);
            List<ConfigurazioneAllarmeBean> allarmiConAlias = this.confCore.allarmiList(search, porta ? allarme.getFiltro().getRuoloPorta() : null, porta ? allarme.getFiltro().getNomePorta() : null);
            if (allarmiConAlias != null && !allarmiConAlias.isEmpty()) {
                for (ConfigurazioneAllarmeBean allarmeCheck : allarmiConAlias) {
                    if (!allarmeCheck.getAlias().equals(allarme.getAlias())) continue;
                    if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                        existsAlias = true;
                        continue;
                    }
                    if (allarmeCheck.getId().longValue() == allarme.getId().longValue()) continue;
                    existsAlias = true;
                }
            }
            if (existsAlias) {
                this.pd.setMessage("Il nome indicato \u00e8 gi\u00e0 stato associato ad un altro allarme");
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD) && (existsAllarme = this.confCore.existsAllarme(allarme.getNome()))) {
                ConfigurazioneAllarmeBean existsAllarmeBean = this.confCore.getAllarme(allarme.getNome());
                if (existsAllarmeBean.getFiltro() != null && existsAllarmeBean.getFiltro().isEnabled() && existsAllarmeBean.getFiltro().getRuoloPorta() != null && StringUtils.isNotEmpty((CharSequence)existsAllarmeBean.getFiltro().getNomePorta())) {
                    if (RuoloPorta.APPLICATIVA.equals((Object)existsAllarmeBean.getFiltro().getRuoloPorta())) {
                        Object descrPorta = null;
                        try {
                            IDPortaApplicativa idPA = new IDPortaApplicativa();
                            idPA.setNome(existsAllarmeBean.getFiltro().getNomePorta());
                            PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(idPA);
                            MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(pa);
                            Object suffixGruppo = "";
                            if (!mappingPA.isDefault()) {
                                suffixGruppo = " (Gruppo: " + mappingPA.getDescrizione() + ")";
                            }
                            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(pa.getTipoSoggettoProprietario());
                            descrPorta = "[" + NamingUtils.getLabelProtocollo((String)protocollo) + "] " + NamingUtils.getLabelAccordoServizioParteSpecifica((String)protocollo, (IDServizio)mappingPA.getIdServizio()) + (String)suffixGruppo;
                        }
                        catch (Exception e) {
                            this.logError("Identificazione erogazione che possiede l'allarme '" + allarme.getNome() + "' non riuscita: " + e.getMessage(), e);
                            descrPorta = existsAllarmeBean.getFiltro().getNomePorta();
                        }
                        this.pd.setMessage(MessageFormat.format("Il nome indicato \u00e8 gi\u00e0 stato associato ad un allarme registrato nell''erogazione {0}", descrPorta));
                    } else if (RuoloPorta.DELEGATA.equals((Object)existsAllarmeBean.getFiltro().getRuoloPorta())) {
                        Object descrPorta = null;
                        try {
                            IDPortaDelegata idPD = new IDPortaDelegata();
                            idPD.setNome(existsAllarmeBean.getFiltro().getNomePorta());
                            PortaDelegata pd = this.porteDelegateCore.getPortaDelegata(idPD);
                            MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(pd);
                            Object suffixGruppo = "";
                            if (!mappingPD.isDefault()) {
                                suffixGruppo = " (Gruppo: " + mappingPD.getDescrizione() + ")";
                            }
                            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(pd.getTipoSoggettoProprietario());
                            descrPorta = "[" + NamingUtils.getLabelProtocollo((String)protocollo) + "] " + NamingUtils.getLabelAccordoServizioParteSpecifica((String)protocollo, (IDServizio)mappingPD.getIdServizio()) + " (Fruitore:" + NamingUtils.getLabelSoggetto((String)protocollo, (IDSoggetto)new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario())) + ")" + (String)suffixGruppo;
                        }
                        catch (Exception e) {
                            this.logError("Identificazione fruizione che possiede l'allarme '" + allarme.getNome() + "' non riuscita: " + e.getMessage(), e);
                            descrPorta = existsAllarmeBean.getFiltro().getNomePorta();
                        }
                        this.pd.setMessage(MessageFormat.format("Il nome indicato \u00e8 gi\u00e0 stato associato ad un allarme registrato nella fruizione ${0}", descrPorta));
                    } else {
                        this.pd.setMessage("Il nome indicato \u00e8 gi\u00e0 stato associato ad un allarme registrato nella configurazione generale");
                    }
                } else {
                    this.pd.setMessage("Il nome indicato \u00e8 gi\u00e0 stato associato ad un allarme registrato nella configurazione generale");
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public Context createAlarmContext(ConfigurazioneAllarmeBean allarme, List<Parameter<?>> parameters) throws DAOFactoryException {
        AlarmContext context = new AlarmContext((Allarme)allarme, this.log, (DAOFactory)DAOConsoleFactory.getInstance(this.log), parameters);
        return context;
    }

    public void sendToAllarmi(List<String> urls) throws Exception {
        if (urls != null && urls.size() > 0) {
            for (String url : urls) {
                this.log.debug("Invoke [" + url + "] ...");
                HttpResponse response = HttpUtilities.getHTTPResponse((String)url);
                if (response.getContent() != null) {
                    this.log.debug("Invoked [" + url + "] Status[" + response.getResultHTTPOperation() + "] Message[" + new String(response.getContent()) + "]");
                } else {
                    this.log.debug("Invoked [" + url + "] Status[" + response.getResultHTTPOperation() + "]");
                }
                if (response.getResultHTTPOperation() <= 202) continue;
                throw new DriverControlStationException("Error occurs during invoke url[" + url + "] Status[" + response.getResultHTTPOperation() + "] Message[" + new String(response.getContent()) + "]");
            }
        }
    }

    public String readAllarmeFromRequest(TipoOperazione tipoOp, boolean first, ConfigurazioneAllarmeBean allarme, AlarmEngineConfig alarmEngineConfig, Plugin plugin, List<Parameter<?>> parameters) throws Exception {
        StringBuilder sbParsingError = new StringBuilder();
        if (!first) {
            String string;
            String inviaEmailAlertS;
            String abilitatoS;
            String idAllarmeS = this.getParameter("allId");
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                allarme.setId(null);
            } else {
                allarme.setId(Long.valueOf(Long.parseLong(idAllarmeS)));
            }
            String nome = this.getParameter("allNome");
            allarme.setNome(nome);
            String alias = this.getParameter("allAlias");
            allarme.setAlias(alias);
            String descrizione = this.getParameter("allDescr");
            allarme.setDescrizione(descrizione);
            String tipo = this.getParameter("allTipo");
            allarme.setTipo(tipo);
            String modalitaS = this.getParameter("allModalita");
            TipoAllarme tipoAllarme = null;
            if (StringUtils.isNotBlank((CharSequence)modalitaS)) {
                tipoAllarme = TipoAllarme.toEnumConstant((String)modalitaS);
            }
            allarme.setTipoAllarme(tipoAllarme);
            if (allarme.getTipoAllarme() != null && allarme.getTipoAllarme().equals((Object)TipoAllarme.ATTIVO)) {
                String periodoS = this.getParameter("allPeriodo");
                String tipoPeriodoS = this.getParameter("allTipoPeriodo");
                if (StringUtils.isNotBlank((CharSequence)periodoS)) {
                    try {
                        allarme.setPeriodo(Integer.valueOf(Integer.parseInt(periodoS)));
                    }
                    catch (Throwable throwable) {
                        this.logError("Periodo indicato non \u00e8 un intero [" + periodoS + "]: " + throwable.getMessage(), throwable);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)tipoPeriodoS)) {
                    if (ConfigurazioneCostanti.VALUE_PARAMETRO_CONFIGURAZIONE_ALLARMI_TIPO_PERIODO_MINUTI.equals(tipoPeriodoS)) {
                        allarme.setTipoPeriodo(AllarmiConverterUtils.toValue((TipoPeriodo)TipoPeriodo.M));
                    } else if (ConfigurazioneCostanti.VALUE_PARAMETRO_CONFIGURAZIONE_ALLARMI_TIPO_PERIODO_GIORNI.equals(tipoPeriodoS)) {
                        allarme.setTipoPeriodo(AllarmiConverterUtils.toValue((TipoPeriodo)TipoPeriodo.G));
                    } else {
                        allarme.setTipoPeriodo(AllarmiConverterUtils.toValue((TipoPeriodo)TipoPeriodo.H));
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(abilitatoS = this.getParameter("allAbilitato")))) {
                allarme.setEnabled(Integer.valueOf(Integer.parseInt(abilitatoS)));
            }
            this.readDatiAllarmeFiltroFromHttpParameters(allarme, first);
            if (plugin != null && parameters != null && parameters.size() > 0) {
                for (Parameter parameter : parameters) {
                    String value = this.getParameter(parameter.getId());
                    if (ParameterType.CHECK_BOX.equals((Object)parameter.getType())) {
                        value = "yes".equals(value) || "abilitato".equals(value) || "true".equals(value) ? "true" : "false";
                    }
                    parameter.setValueAsString(value);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(inviaEmailAlertS = this.getParameter("allInviaEmailAlert")))) {
                allarme.getMail().setInvia(Integer.valueOf(Integer.parseInt(inviaEmailAlertS)));
            }
            if (allarme.getMail().getInvia() == 1) {
                String string2 = this.getParameter("allDestinatariEmail");
                allarme.getMail().setDestinatari(string2);
                String notificaWarningEmailS = this.getParameter("allInviaEmailWarning");
                if (StringUtils.isNotBlank((CharSequence)notificaWarningEmailS)) {
                    allarme.getMail().setInviaWarning(Integer.valueOf(Integer.parseInt(notificaWarningEmailS)));
                }
                if (this.confCore.getAllarmiConfig().isMailShowAllOptions()) {
                    String subject = this.getParameter("allSubjectMail");
                    allarme.getMail().setSubject(subject);
                    String body = this.getParameter("allBodyMail");
                    allarme.getMail().setBody(body);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(string = this.getParameter("allInvocaScriptAlert")))) {
                allarme.getScript().setInvoca(Integer.valueOf(Integer.parseInt(string)));
            }
            if (allarme.getScript().getInvoca() == 1) {
                String notificaWarningScriptS = this.getParameter("allInvocaScriptWarning");
                if (StringUtils.isNotBlank((CharSequence)notificaWarningScriptS)) {
                    allarme.getScript().setInvocaWarning(Integer.valueOf(Integer.parseInt(notificaWarningScriptS)));
                }
                if (this.confCore.getAllarmiConfig().isScriptShowAllOptions()) {
                    String path = this.getParameter("allScriptPath");
                    allarme.getScript().setCommand(path);
                    String args = this.getParameter("allScriptArgs");
                    allarme.getScript().setArgs(args);
                }
            }
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String readDatiAllarmeFiltroFromHttpParameters(ConfigurazioneAllarmeBean policy, boolean first) throws Exception {
        String erogatore;
        StringBuilder sbParsingError = new StringBuilder();
        String stato = this.getParameter("allFiltroEnabled");
        if (stato != null && !"".equals(stato)) {
            policy.getFiltro().setEnabled(ServletUtils.isCheckBoxEnabled((String)stato));
        }
        if (policy.getFiltro().isEnabled()) {
            String protocollo;
            String ruoloPdD = this.getParameter("allFiltroRuoloPdd");
            if (ruoloPdD != null && !"".equals(ruoloPdD)) {
                try {
                    policy.getFiltro().setRuoloPorta(RuoloPorta.toEnumConstant((String)ruoloPdD, (boolean)true));
                }
                catch (Exception e) {
                    String messaggio = "Il valore (" + ruoloPdD + ") indicato in 'Tipologia' non \u00e8 tra i ruoli gestiti";
                    this.logError(messaggio, e);
                    this.addParsingError(sbParsingError, messaggio);
                }
            }
            if ((protocollo = this.getParameter("allFiltroRuoloProtocollo")) != null && !"".equals(protocollo) && !"-*-".equals(protocollo)) {
                policy.getFiltro().setProtocollo(protocollo);
            } else if (!first) {
                policy.getFiltro().setProtocollo(null);
            }
            String ruoloErogatore = this.getParameter("allFiltroRuoloErogatore");
            if (ruoloErogatore != null && !"".equals(ruoloErogatore) && !"-*-".equals(ruoloErogatore)) {
                policy.getFiltro().setRuoloErogatore(ruoloErogatore);
            } else if (!first) {
                policy.getFiltro().setRuoloErogatore(null);
            }
            erogatore = this.getParameter("allFiltroErogatore");
            boolean erogatoreSelected = false;
            if (erogatore != null && !"".equals(erogatore) && !"-*-".equals(erogatore) && erogatore.contains("/")) {
                String[] tmp = erogatore.split("/");
                policy.getFiltro().setTipoErogatore(tmp[0]);
                policy.getFiltro().setNomeErogatore(tmp[1]);
                erogatoreSelected = true;
            } else if (!first) {
                policy.getFiltro().setTipoErogatore(null);
                policy.getFiltro().setNomeErogatore(null);
            }
            String tag = this.getParameter("allFiltroTag");
            if (tag != null && !"".equals(tag) && !"-*-".equals(tag)) {
                policy.getFiltro().setTag(tag);
            } else if (!first) {
                policy.getFiltro().setTag(null);
            }
            String servizio = this.getParameter("allFiltroServizio");
            if (servizio != null && !"".equals(servizio) && !"-*-".equals(servizio) && servizio.contains("/")) {
                String[] tmp = servizio.split("/");
                policy.getFiltro().setTipoServizio(tmp[0]);
                policy.getFiltro().setNomeServizio(tmp[1]);
                policy.getFiltro().setVersioneServizio(Integer.valueOf(Integer.parseInt(tmp[2])));
                if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore()) {
                    policy.getFiltro().setTipoErogatore(tmp[3]);
                    policy.getFiltro().setNomeErogatore(tmp[4]);
                }
            } else if (!first) {
                policy.getFiltro().setTipoServizio(null);
                policy.getFiltro().setNomeServizio(null);
                policy.getFiltro().setVersioneServizio(null);
                if (this.core.isControlloTrafficoPolicyGlobaleFiltroApiSoggettoErogatore() && !erogatoreSelected) {
                    policy.getFiltro().setTipoErogatore(null);
                    policy.getFiltro().setNomeErogatore(null);
                }
            }
            String[] azione = this.getParameterValues("allFiltroAzione");
            if (azione != null && azione.length > 0) {
                StringBuilder bf = new StringBuilder();
                for (String az : azione) {
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(az);
                }
                policy.getFiltro().setAzione(bf.toString());
            } else if (!first) {
                policy.getFiltro().setAzione(null);
            }
            String ruoloFruitore = this.getParameter("allFiltroRuoloFruitore");
            if (ruoloFruitore != null && !"".equals(ruoloFruitore) && !"-*-".equals(ruoloFruitore)) {
                policy.getFiltro().setRuoloFruitore(ruoloFruitore);
            } else if (!first) {
                policy.getFiltro().setRuoloFruitore(null);
            }
            String fruitore = this.getParameter("allFiltroFruitore");
            if (fruitore != null && !"".equals(fruitore) && !"-*-".equals(fruitore) && fruitore.contains("/")) {
                String[] tmp = fruitore.split("/");
                policy.getFiltro().setTipoFruitore(tmp[0]);
                policy.getFiltro().setNomeFruitore(tmp[1]);
            } else if (!first) {
                policy.getFiltro().setTipoFruitore(null);
                policy.getFiltro().setNomeFruitore(null);
            }
            String servizioApplicativoFruitore = this.getParameter("allFiltroSAFruitore");
            if (servizioApplicativoFruitore != null && !"".equals(servizioApplicativoFruitore) && !"-*-".equals(servizioApplicativoFruitore)) {
                policy.getFiltro().setServizioApplicativoFruitore(servizioApplicativoFruitore);
            } else if (!first) {
                policy.getFiltro().setServizioApplicativoFruitore(null);
            }
        } else {
            policy.getFiltro().setRuoloPorta(RuoloPorta.ENTRAMBI);
            policy.getFiltro().setTipoFruitore(null);
            policy.getFiltro().setNomeFruitore(null);
            policy.getFiltro().setServizioApplicativoFruitore(null);
            policy.getFiltro().setTipoErogatore(null);
            policy.getFiltro().setNomeErogatore(null);
            policy.getFiltro().setTipoServizio(null);
            policy.getFiltro().setNomeServizio(null);
            policy.getFiltro().setAzione(null);
        }
        String statoGroupBy = this.getParameter("allGroupByEnabled");
        if (statoGroupBy != null && !"".equals(statoGroupBy)) {
            policy.getGroupBy().setEnabled("Raggruppamento Per".equals(statoGroupBy) || ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(statoGroupBy));
        }
        if (policy.getGroupBy().isEnabled()) {
            String ruoloPdD = this.getParameter("allGroupByRuoloPdd");
            if (!first) {
                policy.getGroupBy().setRuoloPorta(ServletUtils.isCheckBoxEnabled((String)ruoloPdD));
            }
            String protocollo = this.getParameter("allGroupByRuoloProtocollo");
            if (!first) {
                policy.getGroupBy().setProtocollo(ServletUtils.isCheckBoxEnabled((String)protocollo));
            }
            erogatore = this.getParameter("allGroupByErogatore");
            if (!first) {
                policy.getGroupBy().setErogatore(ServletUtils.isCheckBoxEnabled((String)erogatore));
            }
            String servizio = this.getParameter("allGroupByServizio");
            if (!first) {
                policy.getGroupBy().setServizio(ServletUtils.isCheckBoxEnabled((String)servizio));
                policy.getGroupBy().setErogatore(ServletUtils.isCheckBoxEnabled((String)servizio));
            }
            String azione = this.getParameter("allGroupByAzione");
            if (!first) {
                policy.getGroupBy().setAzione(ServletUtils.isCheckBoxEnabled((String)azione));
            }
            String fruitore = this.getParameter("allGroupByFruitore");
            if (!first) {
                policy.getGroupBy().setFruitore(ServletUtils.isCheckBoxEnabled((String)fruitore));
            }
            String servizioApplicativoFruitore = this.getParameter("allGroupBySAFruitore");
            if (!first) {
                policy.getGroupBy().setServizioApplicativoFruitore(ServletUtils.isCheckBoxEnabled((String)servizioApplicativoFruitore));
            }
            String richiedente = this.getParameter("allGroupByRichiedente");
            if (!first) {
                policy.getGroupBy().setServizioApplicativoFruitore(ServletUtils.isCheckBoxEnabled((String)richiedente));
                policy.getGroupBy().setFruitore(ServletUtils.isCheckBoxEnabled((String)richiedente));
                policy.getGroupBy().setIdentificativoAutenticato(ServletUtils.isCheckBoxEnabled((String)richiedente));
            }
            String token = this.getParameter("allGroupByToken");
            if (!first) {
                if (ServletUtils.isCheckBoxEnabled((String)token)) {
                    String[] tokenSelezionati = this.getParameterValues("allGroupByTokenClaims");
                    if (tokenSelezionati != null && tokenSelezionati.length > 0) {
                        StringBuilder bf = new StringBuilder();
                        for (int i = 0; i < tokenSelezionati.length; ++i) {
                            TipoCredenzialeMittente tipo = TipoCredenzialeMittente.toEnumConstant((String)tokenSelezionati[i], (boolean)true);
                            if (TipoCredenzialeMittente.TOKEN_ISSUER.equals((Object)tipo)) continue;
                            if (TipoCredenzialeMittente.TOKEN_SUBJECT.equals((Object)tipo)) {
                                if (!bf.toString().endsWith(",") && bf.length() > 0) {
                                    bf.append(",");
                                }
                                bf.append(TipoCredenzialeMittente.TOKEN_ISSUER.name());
                                if (i == 0) {
                                    bf.append(",");
                                }
                            }
                            if (i > 0) {
                                bf.append(",");
                            }
                            bf.append(tokenSelezionati[i]);
                        }
                        if (bf.length() > 0) {
                            policy.getGroupBy().setToken(bf.toString());
                        } else {
                            policy.getGroupBy().setToken(null);
                        }
                    } else {
                        policy.getGroupBy().setToken(null);
                    }
                } else {
                    policy.getGroupBy().setToken(null);
                }
            }
        } else {
            policy.getGroupBy().setRuoloPorta(false);
            policy.getGroupBy().setFruitore(false);
            policy.getGroupBy().setServizioApplicativoFruitore(false);
            policy.getGroupBy().setIdentificativoAutenticato(false);
            policy.getGroupBy().setToken(null);
            policy.getGroupBy().setErogatore(false);
            policy.getGroupBy().setServizio(false);
            policy.getGroupBy().setAzione(false);
        }
        if (sbParsingError.length() > 0) {
            return sbParsingError.toString();
        }
        return null;
    }

    public String getSelectValue(Plugin pluginBean) {
        return pluginBean.getTipo() + "__$$__$$__" + pluginBean.getClassName();
    }

    public void addAllarmeToDati(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazioneAllarmeBean allarme, AlarmEngineConfig alarmEngineConfig, List<Plugin> listaPlugin, List<Parameter<?>> parameters, RuoloPorta ruoloPorta, String nomePorta, ServiceBinding serviceBinding) throws Exception {
        String[] notificaWarinigLabels;
        String[] notificaWarningValues;
        boolean state;
        String stateParam = this.getParameter("AlarmViewState");
        boolean bl = state = stateParam != null && "true".equals(stateParam);
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && !state) {
            boolean isActive;
            boolean bl2 = isActive = allarme.getEnabled() == 1 && TipoAllarme.ATTIVO.equals((Object)allarme.getTipoAllarme());
            if (isActive) {
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamSession = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = null;
                if (ruoloPorta != null) {
                    parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("allRuoloPorta", ruoloPorta.getValue());
                    lstParamSession.add(parRuoloPorta);
                }
                org.openspcoop2.web.lib.mvc.Parameter parNomePorta = null;
                if (nomePorta != null) {
                    parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("allNomePorta", nomePorta);
                    lstParamSession.add(parNomePorta);
                }
                org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = null;
                if (serviceBinding != null) {
                    parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("allServiceBinding", serviceBinding.name());
                    lstParamSession.add(parServiceBinding);
                }
                org.openspcoop2.web.lib.mvc.Parameter pState = new org.openspcoop2.web.lib.mvc.Parameter("AlarmViewState", "true");
                org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("allId", "" + allarme.getId());
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntry = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParamEntry.add(pId);
                if (lstParamSession.size() > 0) {
                    lstParamEntry.addAll(lstParamSession);
                }
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntryState = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParamEntryState.addAll(lstParamEntry);
                lstParamEntryState.add(pState);
                this.pd.addComandoVisualizzaRuntimeElementoButton("configurazioneAllarmiChange.do", lstParamEntryState);
            }
        }
        boolean allarmeAttivo = allarme.getTipoAllarme() != null && allarme.getTipoAllarme().equals((Object)TipoAllarme.ATTIVO);
        boolean first = this.isFirstTimeFromHttpParameters("allFirstTime");
        org.openspcoop2.web.lib.mvc.Parameter pIdAllarme = new org.openspcoop2.web.lib.mvc.Parameter("allId", "" + allarme.getId());
        DataElement de = new DataElement();
        de.setLabel("Id");
        de.setName("allId");
        de.setType(DataElementType.HIDDEN);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            de.setValue("");
        } else {
            de.setValue("" + allarme.getId());
        }
        dati.add(de);
        de = new DataElement();
        de.setName("allRuoloPorta");
        de.setValue(ruoloPorta != null ? ruoloPorta.getValue() : null);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setName("allNomePorta");
        de.setValue(nomePorta);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        if (serviceBinding != null) {
            de = new DataElement();
            de.setName("allServiceBinding");
            de.setValue(serviceBinding.name());
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        if (state) {
            boolean restart;
            String refreshParam = this.getParameter("AlarmRefreshOp");
            boolean refresh = refreshParam != null && "true".equals(refreshParam);
            String stopParam = this.getParameter("AlarmStopOp");
            boolean stop = stopParam != null && "true".equals(stopParam);
            String startParam = this.getParameter("AlarmStartOp");
            boolean start = startParam != null && "true".equals(startParam);
            String restartParam = this.getParameter("AlarmRestartOp");
            boolean bl3 = restart = restartParam != null && "true".equals(restartParam);
            if (refresh || stop || start || restart) {
                try {
                    String label = "";
                    if (refresh) {
                        AllarmiUtils.refreshActiveThreadState((ConfigurazioneAllarmeBean)allarme, (Logger)this.log, (AlarmEngineConfig)alarmEngineConfig);
                        label = "Ricalcola Stato";
                    } else if (stop) {
                        AllarmiUtils.stopActiveThread((ConfigurazioneAllarmeBean)allarme, (Logger)this.log, (AlarmEngineConfig)alarmEngineConfig);
                        label = "Stop allarme";
                    } else if (start) {
                        AllarmiUtils.startActiveThread((ConfigurazioneAllarmeBean)allarme, (Logger)this.log, (AlarmEngineConfig)alarmEngineConfig);
                        label = "Start allarme";
                    } else if (restart) {
                        AllarmiUtils.restartActiveThread((ConfigurazioneAllarmeBean)allarme, (Logger)this.log, (AlarmEngineConfig)alarmEngineConfig);
                        label = "Restart allarme";
                    }
                    Utilities.sleep((long)3000L);
                    if (refresh) {
                        this.pd.setMessage(label + " avviato con successo", MessageType.INFO);
                    } else {
                        this.pd.setMessage(label + " effettuato con successo", MessageType.INFO);
                    }
                }
                catch (Exception e) {
                    String errorMsg = "Richiesta di aggiornamento dello stato dell'allarme '" + allarme.getAlias() + "' fallita: " + e.getMessage();
                    ControlStationCore.getLog().error(errorMsg, (Throwable)e);
                    this.pd.setMessage(errorMsg, MessageType.ERROR);
                }
            }
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntry = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            if (ruoloPorta != null) {
                org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("allRuoloPorta", ruoloPorta.getValue());
                lstParamEntry.add(parRuoloPorta);
            }
            if (nomePorta != null) {
                org.openspcoop2.web.lib.mvc.Parameter parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("allNomePorta", nomePorta);
                lstParamEntry.add(parNomePorta);
            }
            if (serviceBinding != null) {
                org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("allServiceBinding", serviceBinding.name());
                lstParamEntry.add(parServiceBinding);
            }
            org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("allId", "" + allarme.getId());
            lstParamEntry.add(pId);
            org.openspcoop2.web.lib.mvc.Parameter pState = new org.openspcoop2.web.lib.mvc.Parameter("AlarmViewState", "true");
            lstParamEntry.add(pState);
            boolean existsActiveThread = false;
            try {
                existsActiveThread = AllarmiUtils.existsActiveThread((ConfigurazioneAllarmeBean)allarme, (Logger)this.log, (AlarmEngineConfig)alarmEngineConfig);
            }
            catch (Exception e) {
                String errorMsg = "Lettura stato del thread dell'allarme '" + allarme.getAlias() + "' fallita: " + e.getMessage();
                ControlStationCore.getLog().error(errorMsg, (Throwable)e);
            }
            de = new DataElement();
            de.setLabel("Informazioni Runtime");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setName("AlarmStateView");
            de.setLabel("Refresh");
            de.setValue("Refresh");
            de.setUrl("configurazioneAllarmiChange.do", lstParamEntry.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntry.size()]));
            de.setType(DataElementType.LINK);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato Runtime");
            de.setLabelAffiancata(false);
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setRows(20);
            de.setCols(100);
            Object result = null;
            try {
                result = existsActiveThread ? AllarmiUtils.getActiveThreadImage((ConfigurazioneAllarmeBean)allarme, (Logger)this.log, (AlarmEngineConfig)alarmEngineConfig) : "Il thread di gestione dell'allarme non \u00e8 attivo";
            }
            catch (Exception e) {
                String errorMsg = "Lettura stato dell'allarme '" + allarme.getAlias() + "' fallita: " + e.getMessage();
                ControlStationCore.getLog().error(errorMsg, (Throwable)e);
                result = errorMsg;
            }
            de.setValue((String)result);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.SUBTITLE);
            de.setLabel("Gestione Thread");
            dati.add(de);
            if (existsActiveThread) {
                de = new DataElement();
                de.setName("AlarmStateUpdate");
                de.setLabel("Ricalcola Stato");
                de.setValue("Ricalcola Stato");
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntryRecheck = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParamEntryRecheck.addAll(lstParamEntry);
                org.openspcoop2.web.lib.mvc.Parameter pRecheck = new org.openspcoop2.web.lib.mvc.Parameter("AlarmRefreshOp", "true");
                lstParamEntryRecheck.add(pRecheck);
                de.setUrl("configurazioneAllarmiChange.do", lstParamEntryRecheck.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntryRecheck.size()]));
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            if (existsActiveThread) {
                de = new DataElement();
                de.setName("AlarmRestart");
                de.setLabel("Riavvia l'allarme");
                de.setValue("Riavvia l'allarme");
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntryRestart = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParamEntryRestart.addAll(lstParamEntry);
                org.openspcoop2.web.lib.mvc.Parameter pRestart = new org.openspcoop2.web.lib.mvc.Parameter("AlarmRestartOp", "true");
                lstParamEntryRestart.add(pRestart);
                de.setUrl("configurazioneAllarmiChange.do", lstParamEntryRestart.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntryRestart.size()]));
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            if (existsActiveThread) {
                de = new DataElement();
                de.setName("AlarmStop");
                de.setLabel("Ferma l'allarme");
                de.setValue("Ferma l'allarme");
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntryStop = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParamEntryStop.addAll(lstParamEntry);
                org.openspcoop2.web.lib.mvc.Parameter pStop = new org.openspcoop2.web.lib.mvc.Parameter("AlarmStopOp", "true");
                lstParamEntryStop.add(pStop);
                de.setUrl("configurazioneAllarmiChange.do", lstParamEntryStop.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntryStop.size()]));
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            if (!existsActiveThread) {
                de = new DataElement();
                de.setName("AlarmStart");
                de.setLabel("Avvia l'allarme");
                de.setValue("Avvia l'allarme");
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntryStart = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParamEntryStart.addAll(lstParamEntry);
                org.openspcoop2.web.lib.mvc.Parameter pStart = new org.openspcoop2.web.lib.mvc.Parameter("AlarmStartOp", "true");
                lstParamEntryStart.add(pStart);
                de.setUrl("configurazioneAllarmiChange.do", lstParamEntryStart.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntryStart.size()]));
                de.setType(DataElementType.LINK);
                dati.add(de);
            }
            this.pd.disableEditMode();
            return;
        }
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Informazioni Generali");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Plugin");
        de.setName("allPlugin");
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            de.setType(DataElementType.SELECT);
            ArrayList<String> pluginValues = new ArrayList<String>();
            ArrayList<String> pluginLabels = new ArrayList<String>();
            for (Plugin pluginBean : listaPlugin) {
                String key = this.getSelectValue(pluginBean);
                pluginValues.add(key);
                pluginLabels.add(pluginBean.getLabel());
            }
            pluginValues.add(0, "[Nessuno]");
            pluginLabels.add(0, "-");
            de.setValues(pluginValues);
            de.setLabels(pluginLabels);
            if (first) {
                de.setSelected("[Nessuno]");
            } else if (allarme.getPlugin() != null) {
                de.setSelected(this.getSelectValue(allarme.getPlugin()));
            }
            de.setPostBack_viaPOST(true);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
            de.setValue(allarme.getPlugin().getLabel());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Modalit&agrave;");
        de.setName("allTipo");
        de.setValue(allarme.getTipo() != null ? allarme.getTipo() : "");
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Identificativo Runtime");
        de.setName("allNome");
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            if (first || allarme.getPlugin() == null) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("");
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(allarme.getNome());
            }
            de.setRequired(true);
        } else {
            if (!this.isModalitaStandard() && this.confCore.isShowAllarmiIdentificativoRuntime().booleanValue()) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue(allarme.getNome());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setName("allAlias");
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            if (first || allarme.getPlugin() == null) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("");
            } else {
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(allarme.getAlias());
            }
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
            de.setValue(allarme.getAlias());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("allAbilitato");
        de.setType(DataElementType.SELECT);
        String[] abilitatoValues = ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
        String[] abilitatoLabels = ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
        de.setValues(abilitatoValues);
        de.setLabels(abilitatoLabels);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            if (first || allarme.getPlugin() == null) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("1");
            } else {
                de.setSelected("" + allarme.getEnabled());
            }
        } else {
            de.setSelected("" + allarme.getEnabled());
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setName("allDescr");
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            if (first || allarme.getPlugin() == null) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.TEXT_AREA);
                de.setRows(2);
            }
        } else {
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(2);
        }
        de.setValue(allarme.getDescrizione());
        dati.add(de);
        if (allarmeAttivo) {
            de = new DataElement();
            de.setType(DataElementType.SUBTITLE);
            de.setLabel("Frequenza");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Modalit&agrave;");
        de.setName("allModalita");
        de.setValue(allarme.getTipoAllarme() != null ? allarme.getTipoAllarme().getValue() : "");
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Modalit&agrave;");
        de.setName("allModalitaLab");
        if (allarme.getTipoAllarme() != null && (allarme.getTipoAllarme().equals((Object)TipoAllarme.ATTIVO) || allarme.getTipoAllarme().equals((Object)TipoAllarme.PASSIVO))) {
            de.setType(DataElementType.TEXT);
            de.setValue(allarme.getTipoAllarme().equals((Object)TipoAllarme.ATTIVO) ? "Attiva" : "Passiva");
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        dati.add(de);
        if (allarmeAttivo) {
            de = new DataElement();
            de.setLabel("Periodo");
            de.setName("allPeriodo");
            de.setType(DataElementType.NUMBER);
            de.setRequired(true);
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                if (first) {
                    de.setValue("");
                } else {
                    de.setValue("" + allarme.getPeriodo());
                }
            } else {
                de.setValue("" + allarme.getPeriodo());
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo Periodo");
            de.setName("allTipoPeriodo");
            de.setType(DataElementType.SELECT);
            String[] tipoPeriodoValues = ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_ALLARMI_TIPO_PERIODO;
            String[] tipoPeriodoLabels = ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_ALLARMI_TIPO_PERIODO;
            de.setRequired(true);
            de.setValues(tipoPeriodoValues);
            de.setLabels(tipoPeriodoLabels);
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                if (first || allarme.getTipoPeriodo() == null || StringUtils.isEmpty((CharSequence)allarme.getTipoPeriodo())) {
                    de.setSelected(ConfigurazioneCostanti.VALUE_PARAMETRO_CONFIGURAZIONE_ALLARMI_TIPO_PERIODO_ORE);
                } else {
                    de.setSelected(allarme.getTipoPeriodo());
                }
            } else {
                de.setSelected(allarme.getTipoPeriodo());
            }
            dati.add(de);
        }
        if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && this.confCore.isShowAllarmiFormStatoAllarme().booleanValue()) {
            de = new DataElement();
            de.setType(DataElementType.SUBTITLE);
            de.setLabel("Stato Allarme");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato");
            de.setName("allStato");
            de.setType(DataElementType.TEXT);
            if (allarme.getEnabled() == 1) {
                de.setValue(ConfigurazioneCostanti.getLabelStato(AllarmiConverterUtils.toStatoAllarme((Integer)allarme.getStato())));
            }
            if (allarme.getEnabled() == 0) {
                de.setValue("Disabilitato");
            }
            dati.add(de);
            if (this.confCore.getAllarmiConfig().isOptionsAcknowledgedStatusAssociation() || allarme.getMail().getInvia() == 1 && this.confCore.getAllarmiConfig().isMailCheckAcknowledgedStatus() || allarme.getScript().getInvoca() == 1 && this.confCore.getAllarmiConfig().isScriptCheckAcknowledgedStatus()) {
                de = new DataElement();
                de.setLabel("Acknowledge");
                de.setName("allAcknowledged");
                if (allarme.getEnabled() == 1 && (allarme.getStato() == AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.WARNING) || allarme.getStato() == AllarmiConverterUtils.toIntegerValue((StatoAllarme)StatoAllarme.ERROR))) {
                    de.setType(DataElementType.TEXT);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                if (allarme.getAcknowledged() == 1) {
                    de.setValue("Si");
                }
                if (allarme.getAcknowledged() == 0) {
                    de.setValue("No");
                }
                dati.add(de);
            }
            if (this.confCore.isShowAllarmiFormStatoAllarmeHistory().booleanValue() && this.confCore.getAllarmiConfig().isHistoryEnabled()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("configurazioneAllarmiHistoryList.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdAllarme});
                de.setValue("Archivio Stati");
                dati.add(de);
            }
        }
        if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && allarmeAttivo) {
            de = new DataElement();
            de.setType(DataElementType.SUBTITLE);
            de.setLabel("Runtime");
            dati.add(de);
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntry = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            if (ruoloPorta != null) {
                org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("allRuoloPorta", ruoloPorta.getValue());
                lstParamEntry.add(parRuoloPorta);
            }
            if (nomePorta != null) {
                org.openspcoop2.web.lib.mvc.Parameter parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("allNomePorta", nomePorta);
                lstParamEntry.add(parNomePorta);
            }
            if (serviceBinding != null) {
                org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("allServiceBinding", serviceBinding.name());
                lstParamEntry.add(parServiceBinding);
            }
            org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("allId", "" + allarme.getId());
            lstParamEntry.add(pId);
            org.openspcoop2.web.lib.mvc.Parameter pState = new org.openspcoop2.web.lib.mvc.Parameter("AlarmViewState", "true");
            lstParamEntry.add(pState);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl("configurazioneAllarmiChange.do", lstParamEntry.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntry.size()]));
            de.setValue("Visualizza Informazioni");
            dati.add(de);
        }
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPorta.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        boolean multitenant = this.confCore.isMultitenant();
        boolean tokenAbilitato = true;
        PddTipologia pddTipologiaSoggettoAutenticati = null;
        boolean gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore = false;
        PortaDelegata portaDelegata = null;
        PortaApplicativa portaApplicativa = null;
        CredenzialeTipo tipoAutenticazione = null;
        Boolean appId = null;
        String tokenPolicy = null;
        IDSoggetto idSoggettoProprietario = null;
        if (ruoloPorta != null) {
            String gestioneTokenPolicy;
            ApiKeyState apiKeyState;
            if (applicativa) {
                if (multitenant && this.confCore.getMultitenantSoggettiErogazioni() != null) {
                    switch (this.confCore.getMultitenantSoggettiErogazioni()) {
                        case SOLO_SOGGETTI_ESTERNI: {
                            pddTipologiaSoggettoAutenticati = PddTipologia.ESTERNO;
                            break;
                        }
                        case ESCLUDI_SOGGETTO_EROGATORE: {
                            gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore = true;
                            break;
                        }
                    }
                }
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setNome(nomePorta);
                portaApplicativa = this.porteApplicativeCore.getPortaApplicativa(idPA);
                tipoAutenticazione = CredenzialeTipo.toEnumConstant((String)portaApplicativa.getAutenticazione());
                if (CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione)) {
                    apiKeyState = new ApiKeyState(this.porteApplicativeCore.getParametroAutenticazione(portaApplicativa.getAutenticazione(), portaApplicativa.getProprietaAutenticazioneList()));
                    appId = apiKeyState.appIdSelected;
                }
                if (portaApplicativa.getGestioneToken() != null && portaApplicativa.getGestioneToken().getPolicy() != null) {
                    tokenPolicy = portaApplicativa.getGestioneToken().getPolicy();
                }
                idSoggettoProprietario = new IDSoggetto(portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario());
                if (portaApplicativa.getGestioneToken() != null) {
                    gestioneTokenPolicy = portaApplicativa.getGestioneToken().getPolicy();
                    if (gestioneTokenPolicy == null || gestioneTokenPolicy.equals("") || gestioneTokenPolicy.equals("-")) {
                        tokenAbilitato = false;
                    }
                } else {
                    tokenAbilitato = false;
                }
            }
            if (delegata) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(nomePorta);
                portaDelegata = this.porteDelegateCore.getPortaDelegata(idPD);
                tipoAutenticazione = CredenzialeTipo.toEnumConstant((String)portaDelegata.getAutenticazione());
                if (CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione)) {
                    apiKeyState = new ApiKeyState(this.porteDelegateCore.getParametroAutenticazione(portaDelegata.getAutenticazione(), portaDelegata.getProprietaAutenticazioneList()));
                    appId = apiKeyState.appIdSelected;
                }
                if (portaDelegata.getGestioneToken() != null && portaDelegata.getGestioneToken().getPolicy() != null) {
                    tokenPolicy = portaDelegata.getGestioneToken().getPolicy();
                }
                idSoggettoProprietario = new IDSoggetto(portaDelegata.getTipoSoggettoProprietario(), portaDelegata.getNomeSoggettoProprietario());
                if (portaDelegata.getGestioneToken() != null) {
                    gestioneTokenPolicy = portaDelegata.getGestioneToken().getPolicy();
                    if (gestioneTokenPolicy == null || gestioneTokenPolicy.equals("") || gestioneTokenPolicy.equals("-")) {
                        tokenAbilitato = false;
                    }
                } else {
                    tokenAbilitato = false;
                }
            }
        }
        Context context = this.createAlarmContext(allarme, parameters);
        boolean groupByAllarme = this.isShowGroupBy(allarme, context);
        if (parameters != null && parameters.size() > 0 || groupByAllarme) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel(this.getParameterSectionTitle(allarme, groupByAllarme));
            dati.add(de);
        }
        if (parameters != null && parameters.size() > 0) {
            for (Parameter<?> parameter : parameters) {
                BaseComponent component = (BaseComponent)parameter;
                component.updateRendering();
                String postBack = this.getPostBackElementName();
                if (StringUtils.isNotEmpty((CharSequence)postBack) && postBack.equals(parameter.getId())) {
                    component.valueSelectedListener();
                }
                if (component.getRendered()) {
                    dati.add(component.toDataElement());
                    continue;
                }
                Hidden hidden = new Hidden(parameter, component.getLoader());
                dati.add(hidden.toDataElement());
            }
        }
        if (groupByAllarme) {
            this.addToDatiAllarmeGroupBy(dati, tipoOperazione, allarme, context, "Raggruppamento", ruoloPorta, nomePorta, serviceBinding, tokenAbilitato);
        }
        if (this.isShowFilter(allarme, context)) {
            this.addToDatiAllarmeFiltro(dati, tipoOperazione, allarme, context, "Filtro", ruoloPorta, nomePorta, serviceBinding, idSoggettoProprietario, tokenAbilitato, tipoAutenticazione, appId, tokenPolicy, pddTipologiaSoggettoAutenticati, gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore);
        }
        if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Notifica via Email");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("allInviaEmailAlert");
        if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
            de.setType(DataElementType.SELECT);
            String[] inviaEmailAlertValues = ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
            String[] inviaEmailAlertLabels = ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
            de.setValues(inviaEmailAlertValues);
            de.setLabels(inviaEmailAlertLabels);
            de.setSelected("" + allarme.getMail().getInvia());
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + allarme.getMail().getInvia());
        }
        dati.add(de);
        if (allarme.getMail().getInvia() == 1) {
            de = new DataElement();
            de.setLabel("Destinatari Email");
            de.setName("allDestinatariEmail");
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
                de.setType(DataElementType.TEXT_EDIT);
                de.setNote("Indicare una o pi\u00f9 e-mail separandole con la virgola ','");
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue(allarme.getMail().getDestinatari());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Notifica Warning");
            de.setName("allInviaEmailWarning");
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
                de.setType(DataElementType.SELECT);
                notificaWarningValues = ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
                notificaWarinigLabels = ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
                de.setValues(notificaWarningValues);
                de.setLabels(notificaWarinigLabels);
                de.setSelected("" + allarme.getMail().getInviaWarning());
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue("" + allarme.getMail().getInviaWarning());
            }
            dati.add(de);
            if (this.confCore.getAllarmiConfig().isMailShowAllOptions()) {
                de = new DataElement();
                de.setLabel("Subject");
                de.setName("allSubjectMail");
                if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
                    de.setType(DataElementType.TEXT_EDIT);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setValue(allarme.getMail().getSubject());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Body");
                de.setName("allBodyMail");
                if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
                    de.setType(DataElementType.TEXT_AREA);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setValue(allarme.getMail().getBody());
                dati.add(de);
            }
        }
        if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Notifica Monitoraggio Esterno");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("allInvocaScriptAlert");
        if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
            de.setType(DataElementType.SELECT);
            String[] invocaScriptAlertValues = ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
            String[] invocaScriptAlertLabels = ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
            de.setValues(invocaScriptAlertValues);
            de.setLabels(invocaScriptAlertLabels);
            de.setSelected("" + allarme.getScript().getInvoca());
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + allarme.getScript().getInvoca());
        }
        dati.add(de);
        if (allarme.getScript().getInvoca() == 1) {
            de = new DataElement();
            de.setLabel("Notifica Warning");
            de.setName("allInvocaScriptWarning");
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
                de.setType(DataElementType.SELECT);
                notificaWarningValues = ConfigurazioneCostanti.VALUES_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
                notificaWarinigLabels = ConfigurazioneCostanti.LABELS_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO;
                de.setValues(notificaWarningValues);
                de.setLabels(notificaWarinigLabels);
                de.setSelected("" + allarme.getScript().getInvocaWarning());
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue("" + allarme.getScript().getInvocaWarning());
            }
            dati.add(de);
            if (this.confCore.getAllarmiConfig().isScriptShowAllOptions()) {
                de = new DataElement();
                de.setLabel("Script Path");
                de.setName("allScriptPath");
                if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
                    de.setType(DataElementType.TEXT_EDIT);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setValue(allarme.getScript().getCommand());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Script Arguments");
                de.setName("allScriptArgs");
                if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) || !first && allarme.getPlugin() != null) {
                    de.setType(DataElementType.TEXT_EDIT);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setValue(allarme.getScript().getArgs());
                dati.add(de);
            }
        }
    }

    public boolean isShowFilter(ConfigurazioneAllarmeBean allarme, Context context) throws Exception {
        if (allarme == null || allarme.getPlugin() == null) {
            return false;
        }
        return this.confCore.isUsableFilter(allarme, context);
    }

    public FiltersConfiguration getFiltersConfiguration(ConfigurazioneAllarmeBean allarme, Context context) throws Exception {
        if (allarme == null || allarme.getPlugin() == null) {
            return null;
        }
        return this.confCore.getFiltersConfiguration(allarme, context);
    }

    public boolean isShowGroupBy(ConfigurazioneAllarmeBean allarme, Context context) throws Exception {
        if (allarme == null || allarme.getPlugin() == null) {
            return false;
        }
        return this.confCore.isUsableGroupBy(allarme, context);
    }

    public GroupByConfiguration getGroupByConfiguration(ConfigurazioneAllarmeBean allarme, Context context) throws Exception {
        if (allarme == null || allarme.getPlugin() == null) {
            return null;
        }
        return this.confCore.getGroupByConfiguration(allarme, context);
    }

    public String getParameterSectionTitle(ConfigurazioneAllarmeBean allarme, boolean groupByAllarme) throws Exception {
        if (allarme == null || allarme.getPlugin() == null) {
            return "Parametri";
        }
        return this.confCore.getParameterSectionTitle(allarme, groupByAllarme);
    }

    /*
     * WARNING - void declaration
     */
    private void addToDatiAllarmeFiltro(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazioneAllarmeBean allarme, Context context, String nomeSezione, RuoloPorta ruoloPorta, String nomePorta, ServiceBinding serviceBinding, IDSoggetto idSoggettoProprietario, boolean tokenAbilitato, CredenzialeTipo tipoAutenticazione, Boolean appId, String tokenPolicy, PddTipologia pddTipologiaSoggettoAutenticati, boolean gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore) throws Exception {
        boolean filtroEnabled;
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPorta.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        org.openspcoop2.core.config.constants.CredenzialeTipo tipoAutenticazioneConfig = null;
        if (tipoAutenticazione != null) {
            tipoAutenticazioneConfig = org.openspcoop2.core.config.constants.CredenzialeTipo.toEnumConstant((String)tipoAutenticazione.getValue(), (boolean)true);
        }
        boolean tokenPolicyOR = false;
        if (tokenPolicy != null && !"".equals(tokenPolicy)) {
            if (tipoAutenticazione != null && !org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN.equals((Object)tipoAutenticazioneConfig)) {
                tokenPolicyOR = true;
            } else {
                tipoAutenticazioneConfig = org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN;
            }
        }
        boolean multitenant = this.confCore.isMultitenant();
        FiltersConfiguration filterConfig = this.confCore.getFiltersConfiguration(allarme, context);
        RuoloPorta ruoloPortaFiltro = null;
        if (allarme != null && allarme.getFiltro() != null) {
            ruoloPortaFiltro = allarme.getFiltro().getRuoloPorta();
        }
        if (configurazione && filterConfig != null && !filterConfig.isHideGatewayRole() && (filterConfig.isForceInGatewayRole() || filterConfig.isForceOutGatewayRole())) {
            if (filterConfig.isForceInGatewayRole()) {
                ruoloPortaFiltro = RuoloPorta.APPLICATIVA;
            } else if (filterConfig.isForceOutGatewayRole()) {
                ruoloPortaFiltro = RuoloPorta.DELEGATA;
            }
        }
        ArrayList<String> protocolliLabel = null;
        List<String> protocolliValue = null;
        String protocolloSelezionatoLabel = null;
        String protocolloSelezionatoValue = null;
        List<String> ruoliErogatoreLabel = null;
        List<String> ruoliErogatoreValue = null;
        String ruoloErogatoreSelezionatoLabel = null;
        String ruoloErogatoreSelezionatoValue = null;
        List<String> erogatoriLabel = null;
        List<String> erogatoriValue = null;
        String datiIdentificativiErogatoreSelezionatoLabel = null;
        String datiIdentificativiErogatoreSelezionatoValue = null;
        List<String> tagLabel = null;
        List<String> tagValue = null;
        String datiIdentificativiTagSelezionatoLabel = null;
        String datiIdentificativiTagSelezionatoValue = null;
        List<String> serviziLabel = null;
        List<String> serviziValue = null;
        String datiIdentificativiServizioSelezionatoLabel = null;
        String datiIdentificativiServizioSelezionatoValue = null;
        ArrayList<String> azioniLabel = null;
        ArrayList<String> azioniValue = null;
        ArrayList<String> azioniSelezionataLabel = null;
        ArrayList<String> azioniSelezionataValue = null;
        List<String> ruoliFruitoreLabel = null;
        List<String> ruoliFruitoreValue = null;
        String ruoloFruitoreSelezionatoLabel = null;
        String ruoloFruitoreSelezionatoValue = null;
        List<String> fruitoriLabel = null;
        List<String> fruitoriValue = null;
        String datiIdentificativiFruitoreSelezionatoLabel = null;
        String datiIdentificativiFruitoreSelezionatoValue = null;
        List<String> serviziApplicativiFruitoreLabel = null;
        List<String> serviziApplicativiFruitoreValue = null;
        String servizioApplicativoFruitoreSelezionatoLabel = null;
        String servizioApplicativoFruitoreSelezionatoValue = null;
        FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
        filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
        boolean protocolloAssociatoFiltroNonSelezionatoUtente = false;
        if (allarme != null && allarme.getFiltro() != null && allarme.getFiltro().isEnabled()) {
            protocolliValue = this.confCore.getProtocolli(this.request, this.session);
            if (allarme.getFiltro().getProtocollo() != null && !protocolliValue.contains(allarme.getFiltro().getProtocollo())) {
                protocolloAssociatoFiltroNonSelezionatoUtente = true;
            }
        }
        if (allarme != null && allarme.getFiltro() != null && allarme.getFiltro().isEnabled()) {
            Object aspc;
            String[] listServizi;
            List<IDSoggetto> listSoggettiPreFilterMultitenant;
            if (configurazione) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    protocolloSelezionatoValue = allarme.getFiltro().getProtocollo();
                } else {
                    if (!protocolliValue.contains(allarme.getFiltro().getProtocollo())) {
                        allarme.getFiltro().setProtocollo(null);
                    }
                    if ((protocolloSelezionatoValue = allarme.getFiltro().getProtocollo()) == null || protocolloSelezionatoValue.equals("")) {
                        protocolloSelezionatoValue = protocolliValue.size() == 1 ? protocolliValue.get(0) : this.confCore.getProtocolloDefault(this.request, this.session, protocolliValue);
                    }
                    protocolliLabel = new ArrayList<String>();
                    for (String protocollo : protocolliValue) {
                        protocolliLabel.add(this.getLabelProtocollo(protocollo));
                    }
                }
                protocolloSelezionatoLabel = this.getLabelProtocollo(protocolloSelezionatoValue);
            } else {
                protocolloSelezionatoValue = allarme.getFiltro().getProtocollo();
                if (protocolloSelezionatoValue == null) {
                    protocolloSelezionatoValue = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(idSoggettoProprietario.getTipo());
                }
            }
            if (configurazione) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    ruoloErogatoreSelezionatoValue = allarme.getFiltro().getRuoloErogatore();
                    ruoloErogatoreSelezionatoLabel = ruoloErogatoreSelezionatoValue != null ? ruoloErogatoreSelezionatoValue : "Qualsiasi";
                } else {
                    List<String> ruoliErogatore = this.core.getAllRuoli(filtroRuoli);
                    if (allarme.getFiltro().getRuoloErogatore() != null) {
                        ruoloErogatoreSelezionatoValue = allarme.getFiltro().getRuoloErogatore();
                    }
                    if (!ruoliErogatore.contains(ruoloErogatoreSelezionatoValue)) {
                        allarme.getFiltro().setRuoloErogatore(null);
                        ruoloErogatoreSelezionatoValue = null;
                    }
                    ruoliErogatoreLabel = this.enrichListConLabelQualsiasi(ruoliErogatore);
                    ruoliErogatoreValue = this.enrichListConValueQualsiasi(ruoliErogatore);
                }
            }
            if (configurazione) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    IDSoggetto idSoggetto = null;
                    if (allarme.getFiltro().getTipoErogatore() != null && allarme.getFiltro().getNomeErogatore() != null) {
                        datiIdentificativiErogatoreSelezionatoValue = allarme.getFiltro().getTipoErogatore() + "/" + allarme.getFiltro().getNomeErogatore();
                        idSoggetto = new IDSoggetto(allarme.getFiltro().getTipoErogatore(), allarme.getFiltro().getNomeErogatore());
                    }
                    datiIdentificativiErogatoreSelezionatoLabel = idSoggetto != null ? this.getLabelNomeSoggetto(idSoggetto) : "Qualsiasi";
                } else {
                    ArrayList<IDSoggetto> listErogatori = new ArrayList<IDSoggetto>();
                    listSoggettiPreFilterMultitenant = this.confCore.getSoggettiErogatori(protocolloSelezionatoValue, protocolliValue);
                    if (ruoloPortaFiltro != null && !RuoloPorta.ENTRAMBI.equals((Object)ruoloPortaFiltro)) {
                        for (IDSoggetto iDSoggetto : listSoggettiPreFilterMultitenant) {
                            Soggetto s = this.soggettiCore.getSoggettoRegistro(iDSoggetto);
                            boolean isPddEsterna = this.pddCore.isPddEsterna(s.getPortaDominio());
                            if (RuoloPorta.DELEGATA.equals((Object)ruoloPortaFiltro)) {
                                if (isPddEsterna) {
                                    listErogatori.add(iDSoggetto);
                                    continue;
                                }
                                if (PddTipologia.ESTERNO.equals((Object)pddTipologiaSoggettoAutenticati)) continue;
                                listErogatori.add(iDSoggetto);
                                continue;
                            }
                            if (isPddEsterna) continue;
                            listErogatori.add(iDSoggetto);
                        }
                    } else {
                        listErogatori.addAll(listSoggettiPreFilterMultitenant);
                    }
                    erogatoriLabel = new ArrayList<String>();
                    erogatoriValue = new ArrayList<String>();
                    for (IDSoggetto iDSoggetto : listErogatori) {
                        erogatoriLabel.add(this.getLabelNomeSoggetto(iDSoggetto));
                        erogatoriValue.add(iDSoggetto.getTipo() + "/" + iDSoggetto.getNome());
                    }
                    if (allarme.getFiltro().getTipoErogatore() != null && allarme.getFiltro().getNomeErogatore() != null) {
                        datiIdentificativiErogatoreSelezionatoValue = allarme.getFiltro().getTipoErogatore() + "/" + allarme.getFiltro().getNomeErogatore();
                    }
                    if (!erogatoriValue.contains(datiIdentificativiErogatoreSelezionatoValue)) {
                        allarme.getFiltro().setTipoErogatore(null);
                        allarme.getFiltro().setNomeErogatore(null);
                        datiIdentificativiErogatoreSelezionatoValue = null;
                    }
                    erogatoriLabel = this.enrichListConLabelQualsiasi(erogatoriLabel);
                    erogatoriValue = this.enrichListConValueQualsiasi(erogatoriValue);
                }
            }
            if (configurazione) {
                FiltroRicercaGruppi filtroRicerca = new FiltroRicercaGruppi();
                List<String> elencoGruppi = this.gruppiCore.getAllGruppi(filtroRicerca);
                tagLabel = this.enrichListConLabelQualsiasi(elencoGruppi);
                tagValue = this.enrichListConValueQualsiasi(elencoGruppi);
                datiIdentificativiTagSelezionatoValue = allarme.getFiltro().getTag();
                datiIdentificativiTagSelezionatoLabel = allarme.getFiltro().getTag();
            }
            if (configurazione) {
                boolean controlloAllarmiFiltroApiSoggettoErogatore = this.core.getAllarmiConfig().isOptionsFilterApiOrganization();
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    IDServizio idServizio = null;
                    if (allarme.getFiltro().getTipoServizio() != null && allarme.getFiltro().getNomeServizio() != null && allarme.getFiltro().getVersioneServizio() != null && allarme.getFiltro().getTipoErogatore() != null && allarme.getFiltro().getNomeErogatore() != null) {
                        datiIdentificativiServizioSelezionatoValue = allarme.getFiltro().getTipoServizio() + "/" + allarme.getFiltro().getNomeServizio() + "/" + allarme.getFiltro().getVersioneServizio();
                        if (controlloAllarmiFiltroApiSoggettoErogatore) {
                            datiIdentificativiServizioSelezionatoValue = datiIdentificativiServizioSelezionatoValue + "/" + allarme.getFiltro().getTipoErogatore() + "/" + allarme.getFiltro().getNomeErogatore();
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(allarme.getFiltro().getTipoServizio(), allarme.getFiltro().getNomeServizio(), allarme.getFiltro().getTipoErogatore(), allarme.getFiltro().getNomeErogatore(), allarme.getFiltro().getVersioneServizio().intValue());
                        } else {
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(allarme.getFiltro().getTipoServizio(), allarme.getFiltro().getNomeServizio(), null, null, allarme.getFiltro().getVersioneServizio().intValue());
                        }
                    }
                    datiIdentificativiServizioSelezionatoLabel = controlloAllarmiFiltroApiSoggettoErogatore ? (idServizio != null ? this.getLabelIdServizio(idServizio) : "Qualsiasi") : (idServizio != null ? this.getLabelIdServizioSenzaErogatore(idServizio) : "Qualsiasi");
                } else {
                    boolean definedApi;
                    listServizi = this.confCore.getServizi(protocolloSelezionatoValue, protocolliValue, allarme.getFiltro().getTipoErogatore(), allarme.getFiltro().getNomeErogatore(), allarme.getFiltro().getTag());
                    serviziLabel = new ArrayList<String>();
                    serviziValue = new ArrayList<String>();
                    for (IDServizio iDServizio : listServizi) {
                        String valueAPI = iDServizio.getTipo() + "/" + iDServizio.getNome() + "/" + iDServizio.getVersione();
                        if (controlloAllarmiFiltroApiSoggettoErogatore) {
                            valueAPI = valueAPI + "/" + iDServizio.getSoggettoErogatore().getTipo() + "/" + iDServizio.getSoggettoErogatore().getNome();
                        }
                        if (serviziValue.contains(valueAPI)) continue;
                        serviziValue.add(valueAPI);
                        String labelAPI = null;
                        labelAPI = controlloAllarmiFiltroApiSoggettoErogatore ? this.getLabelIdServizio(iDServizio) : this.getLabelIdServizioSenzaErogatore(iDServizio);
                        serviziLabel.add(labelAPI);
                    }
                    boolean bl = definedApi = allarme.getFiltro().getTipoServizio() != null && allarme.getFiltro().getNomeServizio() != null && allarme.getFiltro().getVersioneServizio() != null;
                    if (controlloAllarmiFiltroApiSoggettoErogatore) {
                        boolean bl2 = definedApi = definedApi && allarme.getFiltro().getTipoErogatore() != null && allarme.getFiltro().getNomeErogatore() != null;
                    }
                    if (definedApi) {
                        datiIdentificativiServizioSelezionatoValue = allarme.getFiltro().getTipoServizio() + "/" + allarme.getFiltro().getNomeServizio() + "/" + allarme.getFiltro().getVersioneServizio();
                        if (controlloAllarmiFiltroApiSoggettoErogatore) {
                            datiIdentificativiServizioSelezionatoValue = datiIdentificativiServizioSelezionatoValue + "/" + allarme.getFiltro().getTipoErogatore() + "/" + allarme.getFiltro().getNomeErogatore();
                        }
                    }
                    if (!serviziValue.contains(datiIdentificativiServizioSelezionatoValue)) {
                        allarme.getFiltro().setTipoServizio(null);
                        allarme.getFiltro().setNomeServizio(null);
                        allarme.getFiltro().setVersioneServizio(null);
                        datiIdentificativiServizioSelezionatoValue = null;
                    }
                    serviziLabel = this.enrichListConLabelQualsiasi(serviziLabel);
                    serviziValue = this.enrichListConValueQualsiasi(serviziValue);
                }
            }
            if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                if (allarme.getFiltro().getAzione() != null && !"".equals(allarme.getFiltro().getAzione())) {
                    azioniSelezionataValue = new ArrayList<String>();
                    if (allarme.getFiltro().getAzione().contains(",")) {
                        void var65_98;
                        String[] tmp;
                        listServizi = tmp = allarme.getFiltro().getAzione().split(",");
                        int definedApi = listServizi.length;
                        boolean bl = false;
                        while (var65_98 < definedApi) {
                            String az = listServizi[var65_98];
                            azioniSelezionataValue.add(az);
                            ++var65_98;
                        }
                    } else {
                        azioniSelezionataValue.add(allarme.getFiltro().getAzione());
                    }
                    if (!azioniSelezionataValue.isEmpty()) {
                        azioniSelezionataLabel = new ArrayList();
                        for (String az : azioniSelezionataValue) {
                            azioniSelezionataLabel.add(az);
                        }
                    }
                }
                if (azioniSelezionataLabel == null) {
                    azioniSelezionataLabel = new ArrayList<String>();
                    azioniSelezionataLabel.add("Qualsiasi");
                }
            } else {
                List<Object> azioni = null;
                Map<String, String> azioniConLabel = null;
                if (configurazione && datiIdentificativiServizioSelezionatoValue != null) {
                    if (StringUtils.isNotEmpty((CharSequence)allarme.getFiltro().getTipoServizio()) && StringUtils.isNotEmpty((CharSequence)allarme.getFiltro().getNomeServizio()) && allarme.getFiltro().getVersioneServizio() != null && allarme.getFiltro().getVersioneServizio() > 0) {
                        if (StringUtils.isNotEmpty((CharSequence)allarme.getFiltro().getTipoErogatore()) && StringUtils.isNotEmpty((CharSequence)allarme.getFiltro().getNomeErogatore())) {
                            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(allarme.getFiltro().getTipoServizio(), allarme.getFiltro().getNomeServizio(), allarme.getFiltro().getTipoErogatore(), allarme.getFiltro().getNomeErogatore(), allarme.getFiltro().getVersioneServizio().intValue());
                            AccordoServizioParteSpecifica accordoServizioParteSpecifica = this.apsCore.getServizio(idServizio, false);
                            AccordoServizioParteComuneSintetico aspc2 = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri(accordoServizioParteSpecifica.getAccordoServizioParteComune()));
                            azioniConLabel = this.porteDelegateCore.getAzioniConLabel(accordoServizioParteSpecifica, aspc2, false, true, null);
                        } else {
                            List<IDServizio> listServizi2 = this.confCore.getServizi(protocolloSelezionatoValue, protocolliValue, allarme.getFiltro().getTipoServizio(), allarme.getFiltro().getNomeServizio(), allarme.getFiltro().getVersioneServizio(), null);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            AccordoServizioParteSpecifica aspsRiferimento = null;
                            if (listServizi2 != null && !listServizi2.isEmpty()) {
                                for (IDServizio idS : listServizi2) {
                                    AccordoServizioParteSpecifica asps = this.apsCore.getServizio(idS, false);
                                    if (!arrayList.contains(asps.getAccordoServizioParteComune())) {
                                        arrayList.add(asps.getAccordoServizioParteComune());
                                        if (aspsRiferimento == null) {
                                            aspsRiferimento = asps;
                                        }
                                    }
                                    if (arrayList.size() <= 1) continue;
                                    break;
                                }
                            }
                            if (arrayList.size() == 1) {
                                AccordoServizioParteComuneSintetico aspc3 = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri((String)arrayList.get(0)));
                                azioniConLabel = this.porteDelegateCore.getAzioniConLabel(aspsRiferimento, aspc3, false, true, null);
                            }
                        }
                    }
                    azioni = this.confCore.getAzioni(protocolloSelezionatoValue, protocolliValue, allarme.getFiltro().getTipoErogatore(), allarme.getFiltro().getNomeErogatore(), allarme.getFiltro().getTipoServizio(), allarme.getFiltro().getNomeServizio(), allarme.getFiltro().getVersioneServizio());
                } else if (delegata) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(allarme.getFiltro().getNomePorta());
                    PortaDelegata portaDelegata = this.porteDelegateCore.getPortaDelegata(idPD);
                    MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(portaDelegata);
                    IDServizio idServizio = mappingPD.getIdServizio();
                    asps = this.apsCore.getServizio(idServizio, false);
                    aspc = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                    if (portaDelegata.getAzione() != null && portaDelegata.getAzione().sizeAzioneDelegataList() > 0) {
                        azioni = portaDelegata.getAzione().getAzioneDelegataList();
                    } else {
                        int i;
                        int listaMappingFruizioneSize;
                        azioniAll = this.confCore.getAzioni(protocolloSelezionatoValue, protocolliValue, portaDelegata.getSoggettoErogatore().getTipo(), portaDelegata.getSoggettoErogatore().getNome(), portaDelegata.getServizio().getTipo(), portaDelegata.getServizio().getNome(), portaDelegata.getServizio().getVersione());
                        IDSoggetto idSoggettoFruitore = mappingPD.getIdFruitore();
                        List<MappingFruizionePortaDelegata> listaMappingFruizione = this.apsCore.serviziFruitoriMappingList(idSoggettoFruitore, idServizio, null);
                        ArrayList azioniOccupate = new ArrayList();
                        int n = listaMappingFruizioneSize = listaMappingFruizione != null ? listaMappingFruizione.size() : 0;
                        if (listaMappingFruizioneSize > 0) {
                            for (i = 0; i < listaMappingFruizione.size(); ++i) {
                                MappingFruizionePortaDelegata mappingFruizionePortaDelegata = listaMappingFruizione.get(i);
                                PortaDelegata portaDelegataTmp = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                                if (portaDelegataTmp.getAzione() == null || portaDelegataTmp.getAzione().getAzioneDelegataList() == null) continue;
                                azioniOccupate.addAll(portaDelegataTmp.getAzione().getAzioneDelegataList());
                            }
                        }
                        azioni = new ArrayList();
                        for (i = 0; i < azioniAll.size(); ++i) {
                            String az = azioniAll.get(i);
                            if (azioniOccupate.contains(az)) continue;
                            azioni.add(az);
                        }
                    }
                    azioniConLabel = this.porteDelegateCore.getAzioniConLabel(asps, (AccordoServizioParteComuneSintetico)aspc, false, true, null);
                } else if (applicativa) {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(allarme.getFiltro().getNomePorta());
                    PortaApplicativa portaApplicativa = this.porteApplicativeCore.getPortaApplicativa(idPA);
                    MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(portaApplicativa);
                    IDServizio idServizio = mappingPA.getIdServizio();
                    asps = this.apsCore.getServizio(idServizio, false);
                    aspc = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                    if (portaApplicativa.getAzione() != null && portaApplicativa.getAzione().sizeAzioneDelegataList() > 0) {
                        azioni = portaApplicativa.getAzione().getAzioneDelegataList();
                    } else {
                        int i;
                        int listaMappingErogazioneSize;
                        azioniAll = this.confCore.getAzioni(protocolloSelezionatoValue, protocolliValue, portaApplicativa.getTipoSoggettoProprietario(), portaApplicativa.getNomeSoggettoProprietario(), portaApplicativa.getServizio().getTipo(), portaApplicativa.getServizio().getNome(), portaApplicativa.getServizio().getVersione());
                        List<MappingErogazionePortaApplicativa> listaMappingErogazione = this.apsCore.mappingServiziPorteAppList(idServizio, null);
                        ArrayList azioniOccupate = new ArrayList();
                        int n = listaMappingErogazioneSize = listaMappingErogazione != null ? listaMappingErogazione.size() : 0;
                        if (listaMappingErogazioneSize > 0) {
                            for (i = 0; i < listaMappingErogazione.size(); ++i) {
                                MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = listaMappingErogazione.get(i);
                                PortaApplicativa portaApplicativaTmp = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                                if (portaApplicativaTmp.getAzione() == null || portaApplicativaTmp.getAzione().getAzioneDelegataList() == null) continue;
                                azioniOccupate.addAll(portaApplicativaTmp.getAzione().getAzioneDelegataList());
                            }
                        }
                        azioni = new ArrayList();
                        for (i = 0; i < azioniAll.size(); ++i) {
                            String az = azioniAll.get(i);
                            if (azioniOccupate.contains(az)) continue;
                            azioni.add(az);
                        }
                    }
                    azioniConLabel = this.porteApplicativeCore.getAzioniConLabel(asps, (AccordoServizioParteComuneSintetico)aspc, false, true, null);
                } else {
                    azioni = new ArrayList<String>();
                }
                if (allarme.getFiltro().getAzione() != null && !"".equals(allarme.getFiltro().getAzione())) {
                    azioniSelezionataValue = new ArrayList();
                    if (allarme.getFiltro().getAzione().contains(",")) {
                        String[] tmp;
                        for (String az : tmp = allarme.getFiltro().getAzione().split(",")) {
                            if (!azioni.contains(az)) continue;
                            azioniSelezionataValue.add(az);
                        }
                    } else if (azioni.contains(allarme.getFiltro().getAzione())) {
                        azioniSelezionataValue.add(allarme.getFiltro().getAzione());
                    }
                }
                if (azioniSelezionataValue == null || azioniSelezionataValue.isEmpty()) {
                    azioniSelezionataValue = null;
                }
                if (azioniConLabel != null && azioniConLabel.size() > 0) {
                    azioniLabel = new ArrayList();
                    azioniValue = new ArrayList();
                    for (String string : azioniConLabel.keySet()) {
                        if (!azioni.contains(string)) continue;
                        azioniValue.add(string);
                        azioniLabel.add((String)azioniConLabel.get(string));
                    }
                } else {
                    azioniLabel = azioni;
                    azioniValue = azioni;
                }
            }
            if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                if (allarme.getFiltro().getRuoloFruitore() != null) {
                    ruoloFruitoreSelezionatoValue = allarme.getFiltro().getRuoloFruitore();
                }
                ruoloFruitoreSelezionatoLabel = ruoloFruitoreSelezionatoValue != null ? ruoloFruitoreSelezionatoValue : "Qualsiasi";
            } else {
                List<String> ruoliFruitore = this.core.getAllRuoli(filtroRuoli);
                if (allarme.getFiltro().getRuoloFruitore() != null) {
                    ruoloFruitoreSelezionatoValue = allarme.getFiltro().getRuoloFruitore();
                }
                if (!ruoliFruitore.contains(ruoloFruitoreSelezionatoValue)) {
                    allarme.getFiltro().setRuoloFruitore(null);
                    ruoloFruitoreSelezionatoValue = null;
                }
                ruoliFruitoreLabel = this.enrichListConLabelQualsiasi(ruoliFruitore);
                ruoliFruitoreValue = this.enrichListConValueQualsiasi(ruoliFruitore);
            }
            if (configurazione || applicativa) {
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    IDSoggetto idSoggetto = null;
                    if (allarme.getFiltro().getTipoFruitore() != null && allarme.getFiltro().getNomeFruitore() != null) {
                        datiIdentificativiFruitoreSelezionatoValue = allarme.getFiltro().getTipoFruitore() + "/" + allarme.getFiltro().getNomeFruitore();
                        idSoggetto = new IDSoggetto(allarme.getFiltro().getTipoFruitore(), allarme.getFiltro().getNomeFruitore());
                    }
                    datiIdentificativiFruitoreSelezionatoLabel = idSoggetto != null ? this.getLabelNomeSoggetto(idSoggetto) : "Qualsiasi";
                } else {
                    ArrayList<IDSoggetto> listSoggetti = new ArrayList<IDSoggetto>();
                    if (configurazione) {
                        listSoggettiPreFilterMultitenant = this.confCore.getSoggetti(protocolloSelezionatoValue, protocolliValue);
                        if (ruoloPortaFiltro != null && !RuoloPorta.ENTRAMBI.equals((Object)ruoloPortaFiltro)) {
                            for (IDSoggetto iDSoggetto : listSoggettiPreFilterMultitenant) {
                                Soggetto s = this.soggettiCore.getSoggettoRegistro(iDSoggetto);
                                boolean isPddEsterna = this.pddCore.isPddEsterna(s.getPortaDominio());
                                if (RuoloPorta.APPLICATIVA.equals((Object)ruoloPortaFiltro)) {
                                    if (isPddEsterna) {
                                        listSoggetti.add(iDSoggetto);
                                        continue;
                                    }
                                    if (PddTipologia.ESTERNO.equals((Object)pddTipologiaSoggettoAutenticati)) continue;
                                    listSoggetti.add(iDSoggetto);
                                    continue;
                                }
                                if (isPddEsterna) continue;
                                listSoggetti.add(iDSoggetto);
                            }
                        } else {
                            listSoggetti.addAll(listSoggettiPreFilterMultitenant);
                        }
                    } else {
                        User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                        String userLogin = user.getLogin();
                        List<String> list = this.soggettiCore.getTipiSoggettiGestitiProtocollo(protocolloSelezionatoValue);
                        List<IDSoggettoDB> list2 = null;
                        list2 = this.core.isVisioneOggettiGlobale(userLogin) ? this.soggettiCore.getSoggettiFromTipoAutenticazione(list, null, tipoAutenticazione, appId, pddTipologiaSoggettoAutenticati) : this.soggettiCore.getSoggettiFromTipoAutenticazione(list, userLogin, tipoAutenticazione, appId, pddTipologiaSoggettoAutenticati);
                        if (list2 != null && !list2.isEmpty() && gestioneErogatori_soggettiAutenticati_escludiSoggettoErogatore) {
                            for (int i = 0; i < list2.size(); ++i) {
                                IDSoggettoDB soggettoCheck = list2.get(i);
                                if (!soggettoCheck.getTipo().equals(idSoggettoProprietario.getTipo()) || !soggettoCheck.getNome().equals(idSoggettoProprietario.getNome())) continue;
                                list2.remove(i);
                                break;
                            }
                        }
                        if (list2 == null) {
                            list2 = new ArrayList<IDSoggettoDB>();
                        }
                        boolean isSupportatoAutenticazioneApplicativiEsterni = false;
                        if (protocolloSelezionatoValue != null && !"".equals(protocolloSelezionatoValue)) {
                            isSupportatoAutenticazioneApplicativiEsterni = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocolloSelezionatoValue);
                        }
                        if (isSupportatoAutenticazioneApplicativiEsterni || multitenant) {
                            List<IDSoggetto> listSoggettiPreFilterMultitenant2 = this.confCore.getSoggetti(protocolloSelezionatoValue, protocolliValue);
                            aspc = listSoggettiPreFilterMultitenant2.iterator();
                            while (aspc.hasNext()) {
                                List<IDServizioApplicativoDB> listServiziApplicativiTmp;
                                IDSoggettoDB idSoggettoDB;
                                List<IDServizioApplicativoDB> listServiziApplicativiTmp2;
                                IDSoggetto idSoggetto = (IDSoggetto)aspc.next();
                                Soggetto s = this.soggettiCore.getSoggettoRegistro(idSoggetto);
                                boolean isPddEsterna = this.pddCore.isPddEsterna(s.getPortaDominio());
                                boolean found = false;
                                if (multitenant && !isPddEsterna || isSupportatoAutenticazioneApplicativiEsterni && isPddEsterna) {
                                    for (IDSoggettoDB sogg : list2) {
                                        if (!sogg.getTipo().equals(s.getTipo()) || !sogg.getNome().equals(s.getNome())) continue;
                                        found = true;
                                        break;
                                    }
                                }
                                boolean bothSslAndToken = false;
                                if (!found && multitenant && !isPddEsterna && (listServiziApplicativiTmp2 = this.saCore.soggettiServizioApplicativoList(idSoggetto, userLogin, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR)) != null && !listServiziApplicativiTmp2.isEmpty()) {
                                    idSoggettoDB = new IDSoggettoDB();
                                    idSoggettoDB.setTipo(s.getTipo());
                                    idSoggettoDB.setNome(s.getNome());
                                    idSoggettoDB.setCodicePorta(s.getIdentificativoPorta());
                                    idSoggettoDB.setId(s.getId());
                                    list2.add(idSoggettoDB);
                                }
                                if (found || !isSupportatoAutenticazioneApplicativiEsterni || !isPddEsterna || (listServiziApplicativiTmp = this.saCore.soggettiServizioApplicativoList(idSoggetto, userLogin, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR)) == null || listServiziApplicativiTmp.isEmpty()) continue;
                                idSoggettoDB = new IDSoggettoDB();
                                idSoggettoDB.setTipo(s.getTipo());
                                idSoggettoDB.setNome(s.getNome());
                                idSoggettoDB.setCodicePorta(s.getIdentificativoPorta());
                                idSoggettoDB.setId(s.getId());
                                list2.add(idSoggettoDB);
                            }
                        }
                        if (!list2.isEmpty()) {
                            for (IDSoggettoDB soggetto : list2) {
                                listSoggetti.add(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
                            }
                        }
                    }
                    fruitoriLabel = new ArrayList<String>();
                    fruitoriValue = new ArrayList<String>();
                    for (IDSoggetto idSoggetto : listSoggetti) {
                        fruitoriLabel.add(this.getLabelNomeSoggetto(idSoggetto));
                        fruitoriValue.add(idSoggetto.getTipo() + "/" + idSoggetto.getNome());
                    }
                    if (allarme.getFiltro().getTipoFruitore() != null && allarme.getFiltro().getNomeFruitore() != null) {
                        datiIdentificativiFruitoreSelezionatoValue = allarme.getFiltro().getTipoFruitore() + "/" + allarme.getFiltro().getNomeFruitore();
                    }
                    if (!fruitoriValue.contains(datiIdentificativiFruitoreSelezionatoValue)) {
                        allarme.getFiltro().setTipoFruitore(null);
                        allarme.getFiltro().setNomeFruitore(null);
                        datiIdentificativiFruitoreSelezionatoValue = null;
                    }
                    fruitoriLabel = this.enrichListConLabelQualsiasi(fruitoriLabel);
                    fruitoriValue = this.enrichListConValueQualsiasi(fruitoriValue);
                }
            } else if (delegata && allarme.getFiltro().getTipoFruitore() != null && allarme.getFiltro().getNomeFruitore() != null) {
                datiIdentificativiFruitoreSelezionatoValue = allarme.getFiltro().getTipoFruitore() + "/" + allarme.getFiltro().getNomeFruitore();
            }
            if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                if (allarme.getFiltro().getServizioApplicativoFruitore() != null) {
                    servizioApplicativoFruitoreSelezionatoValue = allarme.getFiltro().getServizioApplicativoFruitore();
                }
                servizioApplicativoFruitoreSelezionatoLabel = servizioApplicativoFruitoreSelezionatoValue != null ? servizioApplicativoFruitoreSelezionatoValue : "Qualsiasi";
            } else {
                IDSoggetto soggettoProprietarioServiziApplicativi = null;
                if (datiIdentificativiFruitoreSelezionatoValue != null || !configurazione) {
                    String tipoFruitore = null;
                    String nomeFruitore = null;
                    if (datiIdentificativiFruitoreSelezionatoValue != null) {
                        tipoFruitore = allarme.getFiltro().getTipoFruitore();
                        nomeFruitore = allarme.getFiltro().getNomeFruitore();
                    } else {
                        tipoFruitore = idSoggettoProprietario.getTipo();
                        nomeFruitore = idSoggettoProprietario.getNome();
                    }
                    soggettoProprietarioServiziApplicativi = new IDSoggetto(tipoFruitore, nomeFruitore);
                }
                if (soggettoProprietarioServiziApplicativi != null) {
                    serviziApplicativiFruitoreLabel = new ArrayList<String>();
                    serviziApplicativiFruitoreValue = new ArrayList<String>();
                    List<Object> listSA = null;
                    if (configurazione) {
                        listSA = this.confCore.getServiziApplicativiFruitore(protocolloSelezionatoValue, protocolliValue, soggettoProprietarioServiziApplicativi.getTipo(), soggettoProprietarioServiziApplicativi.getNome());
                    } else {
                        IDSoggetto idSoggettoSelezionato;
                        Soggetto s;
                        boolean isPddEsterna;
                        listSA = new ArrayList();
                        User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                        String string = user.getLogin();
                        boolean isSupportatoAutenticazioneApplicativiEsterni = false;
                        if (protocolloSelezionatoValue != null && !"".equals(protocolloSelezionatoValue)) {
                            isSupportatoAutenticazioneApplicativiEsterni = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocolloSelezionatoValue);
                        }
                        boolean bothSslAndToken = false;
                        List<IDServizioApplicativoDB> listServiziApplicativiTmp = null;
                        if (delegata || !multitenant) {
                            listServiziApplicativiTmp = this.saCore.soggettiServizioApplicativoList(idSoggettoProprietario, string, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR);
                        } else if (allarme.getFiltro().getTipoFruitore() != null && allarme.getFiltro().getNomeFruitore() != null && (!(isPddEsterna = this.pddCore.isPddEsterna((s = this.soggettiCore.getSoggettoRegistro(idSoggettoSelezionato = new IDSoggetto(allarme.getFiltro().getTipoFruitore(), allarme.getFiltro().getNomeFruitore()))).getPortaDominio())) || isSupportatoAutenticazioneApplicativiEsterni)) {
                            listServiziApplicativiTmp = this.saCore.soggettiServizioApplicativoList(idSoggettoSelezionato, string, tipoAutenticazioneConfig, appId, "client", bothSslAndToken, tokenPolicy, tokenPolicyOR);
                        }
                        if (listServiziApplicativiTmp != null && !listServiziApplicativiTmp.isEmpty()) {
                            for (IDServizioApplicativoDB servizioApplicativo : listServiziApplicativiTmp) {
                                IDServizioApplicativo idSA = new IDServizioApplicativo();
                                idSA.setIdSoggettoProprietario(idSoggettoProprietario);
                                idSA.setNome(servizioApplicativo.getNome());
                                listSA.add(idSA);
                            }
                        }
                    }
                    for (IDServizioApplicativo iDServizioApplicativo : listSA) {
                        serviziApplicativiFruitoreLabel.add(iDServizioApplicativo.getNome());
                        serviziApplicativiFruitoreValue.add(iDServizioApplicativo.getNome());
                    }
                    if (allarme.getFiltro().getServizioApplicativoFruitore() != null) {
                        servizioApplicativoFruitoreSelezionatoValue = allarme.getFiltro().getServizioApplicativoFruitore();
                    }
                    if (!serviziApplicativiFruitoreValue.contains(servizioApplicativoFruitoreSelezionatoValue)) {
                        allarme.getFiltro().setServizioApplicativoFruitore(null);
                        servizioApplicativoFruitoreSelezionatoValue = null;
                    }
                    serviziApplicativiFruitoreLabel = this.enrichListConLabelQualsiasi(serviziApplicativiFruitoreLabel);
                    serviziApplicativiFruitoreValue = this.enrichListConValueQualsiasi(serviziApplicativiFruitoreValue);
                }
            }
        }
        DataElement de = new DataElement();
        de.setLabel("Filtro");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        boolean filtroAbilitatoAPI = false;
        if (ruoloPorta != null) {
            boolean first = this.isFirstTimeFromHttpParameters("allFirstTime");
            if (first) {
                String string = this.toStringCompactAllarmeFilter(allarme.getFiltro(), ruoloPorta, nomePorta, serviceBinding);
                filtroAbilitatoAPI = string != null && !"".equals(string) && !"Disabilitato".equals(string);
            } else {
                String string = this.getParameter("allFiltroEnabledConsoleOnly");
                filtroAbilitatoAPI = ServletUtils.isCheckBoxEnabled((String)string);
            }
        }
        if (protocolloAssociatoFiltroNonSelezionatoUtente) {
            this.addToDatiDataElementStatoReadOnly(dati, "allFiltroEnabled", "Stato", allarme.getFiltro().isEnabled(), true, false, false);
            if (allarme.getFiltro().isEnabled()) {
                de = new DataElement();
                de.setType(DataElementType.NOTE);
                de.setValue("Filtro non modificabile poich\u00e8 definito per un " + "Profilo di Interoperabilit\u00e0".toLowerCase() + " non attivo nella console");
                dati.add(de);
            }
        } else {
            boolean hidden = ruoloPorta != null;
            this.addToDatiDataElementStato_postBackViaPOST(dati, "allFiltroEnabled", "Stato", allarme != null && allarme.getFiltro() != null && allarme.getFiltro().isEnabled(), true, false, false, hidden);
            if (ruoloPorta != null) {
                this.addToDatiDataElementStato_postBackViaPOST(dati, "allFiltroEnabledConsoleOnly", "Stato", filtroAbilitatoAPI, true, false, false, false);
            }
        }
        boolean bl = filtroEnabled = allarme != null && allarme.getFiltro() != null && allarme.getFiltro().isEnabled();
        if (ruoloPorta != null) {
            filtroEnabled = filtroAbilitatoAPI;
        }
        if (!filtroEnabled && ruoloPorta != null) {
            de = new DataElement();
            de.setName("allFiltroRuoloProtocollo");
            de.setLabel("Profilo");
            de.setValue(protocolloSelezionatoValue);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        if (filtroEnabled) {
            de = new DataElement();
            de.setName("allFiltroRuoloPdd");
            de.setLabel("Tipologia");
            if (ruoloPortaFiltro != null) {
                de.setValue(ruoloPortaFiltro.getValue());
            }
            if (filterConfig != null && filterConfig.isHideGatewayRole()) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            } else if (configurazione && filterConfig != null && (filterConfig.isForceInGatewayRole() || filterConfig.isForceOutGatewayRole())) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            } else if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (configurazione) {
                    de = new DataElement();
                    de.setName("allFiltroRuoloPdd___LABEL");
                    de.setLabel("Tipologia");
                    if (ruoloPortaFiltro != null) {
                        de.setValue(ruoloPortaFiltro.getValue());
                    } else {
                        de.setValue("Qualsiasi");
                    }
                    de.setType(DataElementType.TEXT);
                }
            } else {
                de.setValues(ConfigurazioneCostanti.TIPI_RUOLO_PDD);
                de.setLabels(ConfigurazioneCostanti.LABEL_TIPI_RUOLO_PDD);
                if (ruoloPortaFiltro != null) {
                    de.setSelected(ruoloPortaFiltro.getValue());
                }
                de.setType(DataElementType.SELECT);
                de.setPostBack_viaPOST(true);
            }
            dati.add(de);
            de = new DataElement();
            de.setName("allFiltroRuoloProtocollo");
            de.setLabel("Profilo");
            de.setValue(protocolloSelezionatoValue);
            if (filterConfig != null && filterConfig.isHideProtocol()) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            } else if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (configurazione) {
                    de = new DataElement();
                    de.setName("allFiltroRuoloProtocollo___LABEL");
                    de.setLabel("Profilo");
                    de.setValue(protocolloSelezionatoLabel);
                    de.setType(DataElementType.TEXT);
                }
            } else if (protocolliValue != null && protocolliValue.size() > 1) {
                de.setValues(protocolliValue);
                de.setLabels(protocolliLabel);
                de.setSelected(protocolloSelezionatoValue);
                de.setType(DataElementType.SELECT);
                de.setPostBack_viaPOST(true);
            } else {
                de.setType(DataElementType.HIDDEN);
                if (protocolliValue != null && protocolliValue.size() > 0) {
                    dati.add(de);
                    de = new DataElement();
                    de.setName("allFiltroRuoloProtocollo___LABEL");
                    de.setLabel("Profilo");
                    de.setValue(this.getLabelProtocollo(protocolliValue.get(0)));
                    de.setType(DataElementType.TEXT);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("allFiltroRuoloErogatore");
            de.setLabel("Ruolo Erogatore");
            if (filterConfig != null && filterConfig.isHideProviderRole()) {
                de.setType(DataElementType.HIDDEN);
            } else if (datiIdentificativiErogatoreSelezionatoValue != null) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setValue(ruoloErogatoreSelezionatoValue);
                if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    if (configurazione) {
                        de = new DataElement();
                        de.setName("allFiltroRuoloErogatore___LABEL");
                        de.setLabel("Ruolo Erogatore");
                        de.setValue(ruoloErogatoreSelezionatoLabel);
                        de.setType(DataElementType.TEXT);
                    }
                } else {
                    de.setLabels(ruoliErogatoreLabel);
                    de.setValues(ruoliErogatoreValue);
                    de.setSelected(ruoloErogatoreSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("allFiltroErogatore");
            de.setLabel("Soggetto Erogatore");
            if (filterConfig != null && filterConfig.isHideProvider()) {
                de.setType(DataElementType.HIDDEN);
            } else if (ruoloErogatoreSelezionatoValue != null) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setValue(datiIdentificativiErogatoreSelezionatoValue);
                if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    if (configurazione) {
                        de = new DataElement();
                        de.setName("allFiltroErogatore___LABEL");
                        de.setLabel("Soggetto Erogatore");
                        de.setValue(datiIdentificativiErogatoreSelezionatoLabel);
                        de.setType(DataElementType.TEXT);
                    }
                } else {
                    de.setLabels(erogatoriLabel);
                    de.setValues(erogatoriValue);
                    de.setSelected(datiIdentificativiErogatoreSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("allFiltroTag");
            de.setLabel("Tag");
            de.setValue(datiIdentificativiTagSelezionatoValue);
            boolean bl3 = this.core.getAllarmiConfig().isOptionsFilterApi();
            if (filterConfig != null && filterConfig.isHideTag()) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            } else if (!configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            } else {
                de.setValue(datiIdentificativiTagSelezionatoValue);
                if (bl3 && datiIdentificativiServizioSelezionatoValue == null) {
                    de.setLabels(tagLabel);
                    de.setValues(tagValue);
                    de.setSelected(datiIdentificativiTagSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("allFiltroServizio");
            de.setLabel("API");
            de.setValue(datiIdentificativiServizioSelezionatoValue);
            if (filterConfig != null && filterConfig.isHideService()) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            } else if (protocolloAssociatoFiltroNonSelezionatoUtente || !configurazione) {
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                if (configurazione) {
                    de = new DataElement();
                    de.setName("allFiltroServizio___LABEL");
                    de.setLabel("API");
                    de.setValue(datiIdentificativiServizioSelezionatoLabel);
                    if (bl3) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                }
            } else {
                de.setValue(datiIdentificativiServizioSelezionatoValue);
                if (bl3) {
                    de.setLabels(serviziLabel);
                    de.setValues(serviziValue);
                    de.setSelected(datiIdentificativiServizioSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
            }
            dati.add(de);
            boolean showAzione = true;
            if (configurazione) {
                if (filterConfig != null && filterConfig.isHideAction()) {
                    showAzione = false;
                } else if (datiIdentificativiServizioSelezionatoValue == null) {
                    showAzione = false;
                }
            } else if (filterConfig != null && filterConfig.isHideAction()) {
                showAzione = false;
            }
            if (showAzione) {
                boolean azioniAll = false;
                boolean first = this.isFirstTimeFromHttpParameters("allFirstTime");
                if (first) {
                    azioniAll = azioniSelezionataValue == null || azioniSelezionataValue.isEmpty();
                } else if ("allFiltroServizio".equals(this.getPostBackElementName()) || "allFiltroEnabledConsoleOnly".equals(this.getPostBackElementName())) {
                    azioniAll = true;
                } else {
                    String azioniAllPart = this.getParameter("allFiltroAzionePuntuale");
                    azioniAll = ServletUtils.isCheckBoxEnabled((String)azioniAllPart);
                }
                if (!protocolloAssociatoFiltroNonSelezionatoUtente) {
                    de = new DataElement();
                    de.setName("allFiltroAzionePuntuale");
                    de.setPostBack_viaPOST(true);
                    de.setValues(ConfigurazioneCostanti.PARAMETRO_CONFIGURAZIONE_ALLARMI_FILTRO_AZIONE_PUNTUALE_ALL_VALUES);
                    if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                        de.setLabels(ConfigurazioneCostanti.LABEL_PARAMETRO_CONFIGURAZIONE_ALLARMI_FILTRO_AZIONE_PUNTUALE_RISORSE_ALL_VALUES);
                    } else {
                        de.setLabels(ConfigurazioneCostanti.LABEL_PARAMETRO_CONFIGURAZIONE_ALLARMI_FILTRO_AZIONE_PUNTUALE_ALL_VALUES);
                    }
                    if (azioniAll) {
                        de.setSelected("yes");
                    } else {
                        de.setSelected("no");
                    }
                    if (serviceBinding != null) {
                        de.setLabel(this.getLabelAzioni(serviceBinding));
                    } else {
                        de.setLabel("Azioni");
                    }
                    de.setType(DataElementType.SELECT);
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("allFiltroAzione");
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    if (serviceBinding != null) {
                        de.setLabel(this.getLabelAzioni(serviceBinding));
                    } else {
                        de.setLabel("Azioni");
                    }
                } else {
                    de.setLabel("");
                }
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    de.setValue(allarme.getFiltro().getAzione());
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    de = new DataElement();
                    de.setName("allFiltroAzione___LABEL");
                    if (serviceBinding != null) {
                        de.setLabel(this.getLabelAzioni(serviceBinding));
                    } else {
                        de.setLabel("Azioni");
                    }
                    if (azioniSelezionataLabel != null && !azioniSelezionataLabel.isEmpty()) {
                        if (azioniSelezionataLabel.size() == 1) {
                            de.setValue((String)azioniSelezionataLabel.get(0));
                        } else {
                            de.setValue(((Object)azioniSelezionataLabel).toString());
                        }
                    }
                    de.setType(DataElementType.TEXT);
                } else if (!azioniAll) {
                    de.setLabels(azioniLabel);
                    de.setValues(azioniValue);
                    de.setSelezionati(azioniSelezionataValue);
                    de.setType(DataElementType.MULTI_SELECT);
                    if (azioniValue != null && azioniValue.size() <= 10) {
                        if (azioniValue.size() <= 3) {
                            de.setRows(3);
                        } else {
                            de.setRows(azioniValue.size());
                        }
                    } else {
                        de.setRows(10);
                    }
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                dati.add(de);
            }
            boolean showRuoloRichiedente = false;
            if (configurazione) {
                showRuoloRichiedente = true;
            } else if (serviziApplicativiFruitoreValue != null && serviziApplicativiFruitoreValue.size() > 1) {
                showRuoloRichiedente = true;
            } else if (fruitoriValue != null && fruitoriValue.size() > 1) {
                showRuoloRichiedente = true;
            }
            de = new DataElement();
            de.setName("allFiltroRuoloFruitore");
            de.setLabel("Ruolo Richiedente");
            if (filterConfig != null && filterConfig.isHideSubscriberRole()) {
                de.setType(DataElementType.HIDDEN);
            } else if (datiIdentificativiFruitoreSelezionatoValue != null && !delegata || servizioApplicativoFruitoreSelezionatoValue != null || !showRuoloRichiedente) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setValue(ruoloFruitoreSelezionatoValue);
                if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    if (configurazione) {
                        de = new DataElement();
                        de.setName("allFiltroRuoloFruitore___LABEL");
                        de.setLabel("Ruolo Richiedente");
                        de.setValue(ruoloFruitoreSelezionatoLabel);
                        de.setType(DataElementType.TEXT);
                    }
                } else {
                    de.setLabels(ruoliFruitoreLabel);
                    de.setValues(ruoliFruitoreValue);
                    de.setSelected(ruoloFruitoreSelezionatoValue);
                    de.setType(DataElementType.SELECT);
                    de.setPostBack_viaPOST(true);
                }
            }
            dati.add(de);
            if (fruitoriValue != null && fruitoriValue.size() > 1) {
                de = new DataElement();
                de.setName("allFiltroFruitore");
                de.setLabel("Soggetto Fruitore");
                if (filterConfig != null && filterConfig.isHideSubscriber()) {
                    de.setType(DataElementType.HIDDEN);
                } else if (ruoloFruitoreSelezionatoValue != null) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setValue(datiIdentificativiFruitoreSelezionatoValue);
                    if (protocolloAssociatoFiltroNonSelezionatoUtente || delegata) {
                        de.setType(DataElementType.HIDDEN);
                        dati.add(de);
                        if (configurazione) {
                            de = new DataElement();
                            de.setName("allFiltroFruitore___LABEL");
                            de.setLabel("Soggetto Fruitore");
                            de.setValue(datiIdentificativiFruitoreSelezionatoLabel);
                            de.setType(DataElementType.TEXT);
                        }
                    } else {
                        de.setLabels(fruitoriLabel);
                        de.setValues(fruitoriValue);
                        de.setSelected(datiIdentificativiFruitoreSelezionatoValue);
                        de.setType(DataElementType.SELECT);
                        de.setPostBack_viaPOST(true);
                    }
                }
                dati.add(de);
            }
            if (serviziApplicativiFruitoreValue != null && serviziApplicativiFruitoreValue.size() > 1) {
                de = new DataElement();
                de.setName("allFiltroSAFruitore");
                de.setLabel("Applicativo Fruitore");
                if (filterConfig != null && filterConfig.isHideApplication()) {
                    de.setType(DataElementType.HIDDEN);
                } else if (ruoloFruitoreSelezionatoValue != null) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setValue(servizioApplicativoFruitoreSelezionatoValue);
                    if (protocolloAssociatoFiltroNonSelezionatoUtente) {
                        de.setType(DataElementType.HIDDEN);
                        dati.add(de);
                        if (configurazione) {
                            de = new DataElement();
                            de.setName("allFiltroSAFruitore___LABEL");
                            de.setLabel("Applicativo Fruitore");
                            de.setValue(servizioApplicativoFruitoreSelezionatoLabel);
                            de.setType(DataElementType.TEXT);
                        }
                    } else {
                        de.setLabels(serviziApplicativiFruitoreLabel);
                        de.setValues(serviziApplicativiFruitoreValue);
                        de.setSelected(servizioApplicativoFruitoreSelezionatoValue);
                        de.setType(DataElementType.SELECT);
                        de.setPostBack_viaPOST(true);
                    }
                }
                dati.add(de);
            }
        }
    }

    private void addToDatiAllarmeGroupBy(List<DataElement> dati, TipoOperazione tipoOperazione, ConfigurazioneAllarmeBean allarme, Context context, String nomeSezione, RuoloPorta ruoloPorta, String nomePorta, ServiceBinding serviceBinding, boolean tokenAbilitato) throws Exception {
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPorta.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        List<String> protocolli = null;
        if (allarme != null && allarme.getGroupBy() != null && allarme.getGroupBy().isEnabled()) {
            protocolli = this.confCore.getProtocolli();
        }
        DataElement de = new DataElement();
        de.setLabel("Raggruppamento");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setValue("Se abilitato, il calcolo del valore della soglia avviene raggruppando le richieste in funzione dei criteri selezionati");
        de.setType(DataElementType.NOTE);
        dati.add(de);
        boolean allarmeGBEnabled = allarme != null && allarme.getGroupBy() != null ? allarme.getGroupBy().isEnabled() : false;
        this.addToDatiDataElementStato_postBackViaPOST(dati, "allGroupByEnabled", "Stato", allarmeGBEnabled, true, false, false, false);
        if (allarme != null && allarme.getGroupBy() != null && allarme.getGroupBy().isEnabled()) {
            boolean showAzione;
            GroupByConfiguration groupByConfig = this.confCore.getGroupByConfiguration(allarme, context);
            if (configurazione) {
                boolean showErogatore;
                boolean showProtocollo;
                boolean showRuoloPdD;
                FiltersConfiguration filterConfig = this.confCore.getFiltersConfiguration(allarme, context);
                RuoloPorta ruoloPortaFiltro = null;
                if (allarme != null && allarme.getFiltro() != null && allarme.getFiltro().isEnabled()) {
                    ruoloPortaFiltro = allarme.getFiltro().getRuoloPorta();
                }
                if (filterConfig != null && !filterConfig.isHideGatewayRole() && (filterConfig.isForceInGatewayRole() || filterConfig.isForceOutGatewayRole())) {
                    if (filterConfig.isForceInGatewayRole()) {
                        ruoloPortaFiltro = RuoloPorta.APPLICATIVA;
                    } else if (filterConfig.isForceOutGatewayRole()) {
                        ruoloPortaFiltro = RuoloPorta.DELEGATA;
                    }
                }
                boolean bl = showRuoloPdD = ruoloPortaFiltro == null || RuoloPorta.ENTRAMBI.equals(ruoloPortaFiltro);
                if (showRuoloPdD && groupByConfig != null && groupByConfig.isHideGatewayRole()) {
                    showRuoloPdD = false;
                }
                boolean bl2 = showProtocollo = protocolli.size() > 1 && (allarme.getFiltro() == null || !allarme.getFiltro().isEnabled() || allarme.getFiltro().getProtocollo() == null);
                if (showProtocollo && groupByConfig != null && groupByConfig.isHideProtocol()) {
                    showProtocollo = false;
                }
                boolean bl3 = showErogatore = allarme.getFiltro() == null || !allarme.getFiltro().isEnabled() || allarme.getFiltro().getTipoErogatore() == null || allarme.getFiltro().getNomeErogatore() == null;
                if (showErogatore && groupByConfig != null && groupByConfig.isHideProvider()) {
                    showErogatore = false;
                }
                if (showRuoloPdD || showProtocollo || showErogatore) {
                    // empty if block
                }
                if (showRuoloPdD) {
                    de = new DataElement();
                    de.setName("allGroupByRuoloPdd");
                    de.setLabel("Fruizione / Erogazione");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(allarme.getGroupBy().isRuoloPorta());
                    de.setValue("" + allarme.getGroupBy().isRuoloPorta());
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("allGroupByRuoloProtocollo");
                de.setLabel("Profilo");
                if (showProtocollo) {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(allarme.getGroupBy().isProtocollo());
                    de.setValue("" + allarme.getGroupBy().isProtocollo());
                } else {
                    de.setType(DataElementType.HIDDEN);
                    if (protocolli.size() == 1) {
                        de.setValue("false");
                    }
                }
                dati.add(de);
                if (showErogatore) {
                    de = new DataElement();
                    de.setName("allGroupByErogatore");
                    de.setLabel("Soggetto Erogatore");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(allarme.getGroupBy().isErogatore());
                    de.setValue("" + allarme.getGroupBy().isErogatore());
                    dati.add(de);
                }
            }
            boolean showServizio = false;
            boolean bl = showAzione = allarme.getFiltro() == null || !allarme.getFiltro().isEnabled() || allarme.getFiltro().getAzione() == null || "".equals(allarme.getFiltro().getAzione()) || allarme.getFiltro().getAzione().contains(",");
            if (showAzione && groupByConfig != null && groupByConfig.isHideAction()) {
                showAzione = false;
            }
            if (configurazione) {
                if (this.core.getAllarmiConfig().isOptionsGroupByApi()) {
                    boolean bl4 = showServizio = allarme.getFiltro() == null || !allarme.getFiltro().isEnabled() || allarme.getFiltro().getTipoServizio() == null || allarme.getFiltro().getNomeServizio() == null;
                    if (showServizio && groupByConfig != null && groupByConfig.isHideService()) {
                        showServizio = false;
                    }
                }
                if (showAzione) {
                    boolean bl5 = showAzione = showServizio && allarme.getGroupBy().isServizio();
                    if (showAzione && groupByConfig != null && groupByConfig.isHideAction()) {
                        showAzione = false;
                    }
                }
                if (!showServizio && !showAzione || configurazione) {
                    // empty if block
                }
                if (showServizio) {
                    de = new DataElement();
                    de.setName("allGroupByServizio");
                    de.setLabel("API");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(allarme.getGroupBy().isServizio());
                    de.setValue("" + allarme.getGroupBy().isServizio());
                    de.setPostBack_viaPOST(true);
                    dati.add(de);
                }
            }
            de = new DataElement();
            de.setName("allGroupByAzione");
            if (serviceBinding != null) {
                de.setLabel(this.getLabelAzione(serviceBinding));
            } else {
                de.setLabel("Azione");
            }
            if (showAzione) {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(allarme.getGroupBy().isAzione());
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setValue("" + allarme.getGroupBy().isAzione());
            dati.add(de);
            if (configurazione) {
                // empty if block
            }
            if (configurazione) {
                boolean showRichiedenteApplicativo;
                boolean showFruitore;
                boolean bl6 = showFruitore = allarme.getFiltro() == null || !allarme.getFiltro().isEnabled() || allarme.getFiltro().getTipoFruitore() == null || allarme.getFiltro().getNomeFruitore() == null;
                if (showFruitore && groupByConfig != null && groupByConfig.isHideSubscriber()) {
                    showFruitore = false;
                }
                if (showFruitore) {
                    de = new DataElement();
                    de.setName("allGroupByFruitore");
                    de.setLabel("Soggetto Fruitore");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(allarme.getGroupBy().isFruitore());
                    de.setValue("" + allarme.getGroupBy().isFruitore());
                    dati.add(de);
                }
                boolean bl7 = showRichiedenteApplicativo = allarme.getFiltro() == null || !allarme.getFiltro().isEnabled() || allarme.getFiltro().getRuoloPorta() == null || allarme.getFiltro().getServizioApplicativoFruitore() == null;
                if (showRichiedenteApplicativo && groupByConfig != null && groupByConfig.isHideApplication()) {
                    showRichiedenteApplicativo = false;
                }
                if (showRichiedenteApplicativo) {
                    de = new DataElement();
                    de.setName("allGroupBySAFruitore");
                    de.setLabel("Applicativo Fruitore");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(allarme.getGroupBy().isServizioApplicativoFruitore());
                    de.setValue("" + allarme.getGroupBy().isServizioApplicativoFruitore());
                    dati.add(de);
                }
            } else {
                boolean showRichiedente = true;
                if (showRichiedente && groupByConfig != null && groupByConfig.isHideSenderIdentity()) {
                    showRichiedente = false;
                }
                if (showRichiedente) {
                    de = new DataElement();
                    de.setName("allGroupByRichiedente");
                    de.setLabel("Richiedente");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(allarme.getGroupBy().isIdentificativoAutenticato());
                    de.setValue("" + allarme.getGroupBy().isIdentificativoAutenticato());
                    dati.add(de);
                }
            }
            if (tokenAbilitato) {
                boolean first = this.isFirstTimeFromHttpParameters("allFirstTime");
                String token = this.getParameter("allGroupByToken");
                String[] tokenSelezionatiDB = null;
                if (allarme.getGroupBy().getToken() != null && !"".equals(allarme.getGroupBy().getToken())) {
                    tokenSelezionatiDB = allarme.getGroupBy().getToken().split(",");
                }
                String[] tokenSelezionatiSenzaIssuer = null;
                if (tokenSelezionatiDB != null && tokenSelezionatiDB.length > 0) {
                    ArrayList<String> l = new ArrayList<String>();
                    for (int i = 0; i < tokenSelezionatiDB.length; ++i) {
                        TipoCredenzialeMittente tipo = TipoCredenzialeMittente.toEnumConstant((String)tokenSelezionatiDB[i], (boolean)true);
                        if (TipoCredenzialeMittente.TOKEN_ISSUER.equals((Object)tipo)) continue;
                        l.add(tokenSelezionatiDB[i]);
                    }
                    if (!l.isEmpty()) {
                        tokenSelezionatiSenzaIssuer = l.toArray(new String[1]);
                    }
                }
                boolean groupByToken = false;
                groupByToken = first ? tokenSelezionatiDB != null && tokenSelezionatiDB.length > 0 : ServletUtils.isCheckBoxEnabled((String)token);
                boolean showToken = true;
                if (showToken && groupByConfig != null && groupByConfig.isHideToken()) {
                    showToken = false;
                }
                if (showToken) {
                    de = new DataElement();
                    de.setName("allGroupByToken");
                    de.setLabel("Token");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(groupByToken);
                    de.setValue("" + groupByToken);
                    de.setPostBack_viaPOST(true);
                    dati.add(de);
                    boolean showTokenClaims = true;
                    if (showTokenClaims && groupByConfig != null && groupByConfig.isHideTokenClaims()) {
                        showTokenClaims = false;
                    }
                    if (showTokenClaims && groupByToken) {
                        de = new DataElement();
                        de.setName("allGroupByTokenClaims");
                        de.setLabel("Claims");
                        de.setValues(CostantiControlStation.TOKEN_VALUES_WITHOUT_ISSUER);
                        de.setLabels(CostantiControlStation.LABEL_TOKEN_VALUES_WITHOUT_ISSUER);
                        de.setSelezionati(tokenSelezionatiSenzaIssuer);
                        de.setType(DataElementType.MULTI_SELECT);
                        de.setRows(4);
                        de.setRequired(true);
                        dati.add(de);
                    }
                }
            }
        }
    }

    public String toStringCompactAllarmeFilter(AllarmeFiltro filtro, RuoloPorta ruoloPorta, String nomePorta, ServiceBinding serviceBinding) throws Exception {
        boolean delegata = false;
        boolean applicativa = false;
        boolean configurazione = false;
        if (ruoloPorta != null) {
            if (RuoloPorta.DELEGATA.equals((Object)ruoloPorta)) {
                delegata = nomePorta != null;
            } else if (RuoloPorta.APPLICATIVA.equals((Object)ruoloPorta)) {
                applicativa = nomePorta != null;
            }
        }
        configurazione = !delegata && !applicativa;
        StringBuilder bf = new StringBuilder("");
        if (filtro.isEnabled()) {
            IDSoggetto idSoggetto;
            if (configurazione && filtro.getRuoloPorta() != null && !RuoloPorta.ENTRAMBI.equals((Object)filtro.getRuoloPorta())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                if (RuoloPorta.DELEGATA.equals((Object)filtro.getRuoloPorta())) {
                    bf.append("Tipologia").append(": ");
                    bf.append("Fruizione");
                } else if (RuoloPorta.APPLICATIVA.equals((Object)filtro.getRuoloPorta())) {
                    bf.append("Tipologia").append(": ");
                    bf.append("Erogazione");
                }
            }
            if (configurazione && filtro.getProtocollo() != null && !"".equals(filtro.getProtocollo())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Profilo: ");
                bf.append(this.getLabelProtocollo(filtro.getProtocollo()));
            }
            if (configurazione && filtro.getNomePorta() != null && !"".equals(filtro.getNomePorta())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Porta").append(": ");
                bf.append(filtro.getNomePorta());
            }
            if (configurazione) {
                if (filtro.getRuoloErogatore() != null) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Ruolo Erogatore").append(": ");
                    bf.append(filtro.getRuoloErogatore());
                } else if (filtro.getTipoErogatore() != null && !"".equals(filtro.getTipoErogatore()) && filtro.getNomeErogatore() != null && !"".equals(filtro.getNomeErogatore())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Erogatore").append(": ");
                    idSoggetto = new IDSoggetto(filtro.getTipoErogatore(), filtro.getNomeErogatore());
                    bf.append(this.getLabelNomeSoggetto(idSoggetto));
                }
            }
            if (configurazione && filtro.getTag() != null && !"".equals(filtro.getTag())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Tag").append(": ");
                bf.append(filtro.getTag());
            }
            if (!(!configurazione || filtro.getTipoServizio() == null || "".equals(filtro.getTipoServizio()) || filtro.getNomeServizio() == null || "".equals(filtro.getNomeServizio()) || filtro.getVersioneServizio() == null || filtro.getTipoErogatore() == null || "".equals(filtro.getTipoErogatore()) || filtro.getNomeErogatore() == null || "".equals(filtro.getNomeErogatore()))) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("API").append(": ");
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(filtro.getTipoServizio(), filtro.getNomeServizio(), filtro.getTipoErogatore(), filtro.getNomeErogatore(), filtro.getVersioneServizio().intValue());
                bf.append(this.getLabelIdServizio(idServizio));
            }
            if (filtro.getAzione() != null && !"".equals(filtro.getAzione())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append(this.getLabelAzione(serviceBinding)).append(": ");
                bf.append(filtro.getAzione());
            }
            if (configurazione || applicativa) {
                if (filtro.getRuoloFruitore() != null) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Ruolo Fruitore").append(": ");
                    bf.append(filtro.getRuoloFruitore());
                } else if (filtro.getTipoFruitore() != null && !"".equals(filtro.getTipoFruitore()) && filtro.getNomeFruitore() != null && !"".equals(filtro.getNomeFruitore())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Fruitore").append(": ");
                    idSoggetto = new IDSoggetto(filtro.getTipoFruitore(), filtro.getNomeFruitore());
                    bf.append(this.getLabelNomeSoggetto(idSoggetto));
                }
            }
            if ((configurazione || delegata) && filtro.getServizioApplicativoFruitore() != null && !"".equals(filtro.getServizioApplicativoFruitore())) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Applicativo").append(": ");
                bf.append(filtro.getServizioApplicativoFruitore());
            }
        } else {
            bf.append("Disabilitato");
        }
        if (bf.length() <= 0 && (delegata || applicativa)) {
            bf.append("Disabilitato");
        }
        return bf.toString();
    }

    public void savePluginIntoSession(HttpServletRequest request, HttpSession session, Plugin plugin) {
        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)plugin, (String)"_confAllPluginScelto_");
    }

    public void removePluginFromSession(HttpServletRequest request, HttpSession session) {
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"_confAllPluginScelto_");
    }

    public Plugin readPluginFromSession(HttpServletRequest request, HttpSession session) {
        return (Plugin)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, Plugin.class, (String)"_confAllPluginScelto_");
    }

    public void saveParametriIntoSession(HttpServletRequest request, HttpSession session, List<Parameter<?>> parameters) {
        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, parameters, (String)"_confAllParameterPluginScelto_");
    }

    public void removeParametriFromSession(HttpServletRequest request, HttpSession session) {
        ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"_confAllParameterPluginScelto_");
    }

    public List<Parameter<?>> readParametriFromSession(HttpServletRequest request, HttpSession session) {
        Object obj = ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"_confAllParameterPluginScelto_");
        if (obj == null) {
            return null;
        }
        return (List)obj;
    }

    public void prepareAllarmiHistoryList(ConsoleSearch ricerca, List<ConfigurazioneAllarmeHistoryBean> lista, ConfigurazioneAllarmeBean allarme, RuoloPorta ruoloPorta, String nomePorta, ServiceBinding serviceBinding) throws Exception {
        try {
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParAllarme = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = null;
            if (ruoloPorta != null) {
                parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("allRuoloPorta", ruoloPorta.getValue());
                lstParAllarme.add(parRuoloPorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parNomePorta = null;
            if (nomePorta != null) {
                parNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("allNomePorta", nomePorta);
                lstParAllarme.add(parNomePorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = null;
            if (serviceBinding != null) {
                parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("allServiceBinding", serviceBinding.name());
                lstParAllarme.add(parServiceBinding);
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"configurazioneAllarmiHistory", (org.openspcoop2.web.lib.mvc.Parameter[])new org.openspcoop2.web.lib.mvc.Parameter[0]);
            int idLista = Liste.CONFIGURAZIONE_ALLARMI_HISTORY;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("allId", "" + allarme.getId());
            lstParAllarme.add(pId);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ServletUtils.disabledPageDataSearch((PageData)this.pd);
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
            if (ruoloPorta != null) {
                lstParamPorta = this.getTitleListAllarmi(ruoloPorta, nomePorta, serviceBinding, allarme.getNome());
            }
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParam = null;
            if (lstParamPorta != null) {
                lstParam = lstParamPorta;
                lstParam.set(lstParam.size() - 1, new org.openspcoop2.web.lib.mvc.Parameter(allarme.getNome(), "configurazioneAllarmiChange.do", lstParAllarme.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParAllarme.size()])));
            } else {
                lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Allarmi", "configurazioneAllarmiList.do"));
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter(allarme.getNome(), "configurazioneAllarmiChange.do", lstParAllarme.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParAllarme.size()])));
            }
            lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Archivio Stati", null));
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            ArrayList<String> lstLabels = new ArrayList<String>();
            lstLabels.add("Data Aggiornamento");
            lstLabels.add("Stato");
            lstLabels.add("Stato");
            lstLabels.add("Acknowledge");
            lstLabels.add("Dettaglio");
            lstLabels.add("Utente");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (ConfigurazioneAllarmeHistoryBean entry : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    Date timestampUpdate = entry.getTimestampUpdate();
                    String dataValue = DateUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm").format(timestampUpdate);
                    de.setToolTip(dataValue);
                    de.setValue(dataValue);
                    e.add(de);
                    de = new DataElement();
                    de.setWidthPx(10);
                    if (entry.getEnabled() == 1) {
                        de.setValue(ConfigurazioneCostanti.LABEL_VALUE_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO_SI);
                    } else {
                        de.setValue(ConfigurazioneCostanti.LABEL_VALUE_PARAMETRO_CONFIGURAZIONE_ALLARMI_ABILITATO_NO);
                    }
                    e.add(de);
                    de = new DataElement();
                    if (entry.getEnabled() == 1) {
                        if (entry.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_OK.intValue()) {
                            de.setToolTip("Ok");
                            de.setValue("Ok");
                        } else if (entry.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_ERROR.intValue()) {
                            de.setToolTip("Error");
                            de.setValue("Error");
                        } else if (entry.getStato() != null && allarme.getStato().intValue() == ConfigurazioneCostanti.CONFIGURAZIONE_ALLARME_STATO_WARNING.intValue()) {
                            de.setToolTip("Warning");
                            de.setValue("Warning");
                        }
                    } else {
                        de.setToolTip("Disabilitato");
                        de.setValue("Disabilitato");
                    }
                    e.add(de);
                    de = new DataElement();
                    if (entry.getAcknowledged() == 1) {
                        de.setToolTip("Si");
                        de.setValue("Si");
                    } else {
                        de.setToolTip("No");
                        de.setValue("No");
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setValue(entry.getDettaglioStatoAbbr());
                    de.setToolTip(entry.getDettaglioStatoHtmlEscaped());
                    e.add(de);
                    de = new DataElement();
                    de.setValue(entry.getUtente());
                    de.setToolTip(entry.getUtente());
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(false);
            this.pd.setRemoveButton(false);
            this.pd.setSelect(false);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void prepareHandlersRichiestaList(ConsoleSearch ricerca, List<ConfigurazioneHandlerBean> lista, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String tipologia) throws Exception {
        String objectName = "configurazioneHandlersRichiesta";
        String servletListURL = "configurazioneHandlersRichiestaList.do";
        String servletChangeURL = "configurazioneHandlersRichiestaChange.do";
        String labelHandler = this.getLabelTipologiaFromFaseMessageHandler(tipologia, true);
        String labelHandlerDi = labelHandler + " di ";
        int idLista = Liste.CONFIGURAZIONE_HANDLERS_RICHIESTA;
        String searchLabel = "Nome";
        this.prepareHandlersList(ricerca, lista, ruoloPorta, idPortaS, serviceBinding, tipologia, objectName, servletListURL, servletChangeURL, labelHandler, labelHandlerDi, idLista, searchLabel);
    }

    public void prepareHandlersRispostaList(ConsoleSearch ricerca, List<ConfigurazioneHandlerBean> lista, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String tipologia) throws Exception {
        String objectName = "configurazioneHandlersRisposta";
        String servletListURL = "configurazioneHandlersRispostaList.do";
        String servletChangeURL = "configurazioneHandlersRispostaChange.do";
        String labelHandler = this.getLabelTipologiaFromFaseMessageHandler(tipologia, false);
        String labelHandlerDi = labelHandler + " di ";
        int idLista = Liste.CONFIGURAZIONE_HANDLERS_RISPOSTA;
        String searchLabel = "Nome";
        this.prepareHandlersList(ricerca, lista, ruoloPorta, idPortaS, serviceBinding, tipologia, objectName, servletListURL, servletChangeURL, labelHandler, labelHandlerDi, idLista, searchLabel);
    }

    public void prepareHandlersServizioList(ConsoleSearch ricerca, List<ConfigurazioneHandlerBean> lista, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String tipologia) throws Exception {
        String objectName = "configurazioneHandlersServizio";
        String servletListURL = "configurazioneHandlersServizioList.do";
        String servletChangeURL = "configurazioneHandlersServizioChange.do";
        String labelHandler = this.getLabelTipologiaFromFaseServiceHandler(tipologia);
        String labelHandlerDi = labelHandler + " di ";
        int idLista = Liste.CONFIGURAZIONE_HANDLERS_SERVIZIO;
        String searchLabel = "Nome";
        this.prepareHandlersList(ricerca, lista, ruoloPorta, idPortaS, serviceBinding, tipologia, objectName, servletListURL, servletChangeURL, labelHandler, labelHandlerDi, idLista, searchLabel);
    }

    private void prepareHandlersList(ConsoleSearch ricerca, List<ConfigurazioneHandlerBean> lista, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String tipologia, String objectName, String servletListURL, String servletChangeURL, String labelHandler, String labelHandlerDi, int idLista, String searchLabel) throws Exception {
        try {
            ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamSession = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
            org.openspcoop2.web.lib.mvc.Parameter parRuoloPorta = null;
            if (ruoloPorta != null) {
                parRuoloPorta = new org.openspcoop2.web.lib.mvc.Parameter("hRuoloPorta", ruoloPorta.getTipo());
                lstParamSession.add(parRuoloPorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parIdPorta = null;
            if (idPortaS != null) {
                parIdPorta = new org.openspcoop2.web.lib.mvc.Parameter("hIdPorta", idPortaS);
                lstParamSession.add(parIdPorta);
            }
            org.openspcoop2.web.lib.mvc.Parameter parServiceBinding = null;
            if (serviceBinding != null) {
                parServiceBinding = new org.openspcoop2.web.lib.mvc.Parameter("hServiceBinding", serviceBinding.name());
                lstParamSession.add(parServiceBinding);
            }
            org.openspcoop2.web.lib.mvc.Parameter parTipologia = null;
            if (tipologia != null) {
                parTipologia = new org.openspcoop2.web.lib.mvc.Parameter("hFase", tipologia);
                lstParamSession.add(parTipologia);
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)objectName, lstParamSession);
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
            if (ruoloPorta != null) {
                lstParamPorta = this.getTitleListHandler(tipologia, ruoloPorta, idPortaS, serviceBinding, null, servletListURL, labelHandlerDi, labelHandler);
            }
            this.pd.setSearchLabel(searchLabel);
            if (search.equals("")) {
                this.pd.setSearchDescription("");
            }
            List<org.openspcoop2.web.lib.mvc.Parameter> lstParam = null;
            if (lstParamPorta != null) {
                lstParam = lstParamPorta;
            } else {
                lstParam = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter(labelHandler, null));
            }
            if (ruoloPorta == null) {
                lstParam.add(0, new org.openspcoop2.web.lib.mvc.Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            }
            if (!search.equals("")) {
                if (lstParamSession.size() > 0) {
                    lstParam.set(lstParam.size() - 1, new org.openspcoop2.web.lib.mvc.Parameter(labelHandler, servletListURL, lstParamSession.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamSession.size()])));
                } else {
                    lstParam.set(lstParam.size() - 1, new org.openspcoop2.web.lib.mvc.Parameter(labelHandler, servletListURL));
                }
                lstParam.add(new org.openspcoop2.web.lib.mvc.Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParam);
            if (ruoloPorta != null) {
                this.impostaComandiMenuContestualeHandler(ruoloPorta, idPortaS);
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)labelHandler, (String)search);
            }
            ArrayList<String> lstLabels = new ArrayList<String>();
            if (lista != null && lista.size() > 1) {
                lstLabels.add("Posizione");
            }
            lstLabels.add("Stato");
            lstLabels.add("Nome");
            lstLabels.add("Descrizione");
            this.pd.setLabels(lstLabels.toArray(new String[lstLabels.size()]));
            ArrayList dati = new ArrayList();
            if (lista != null) {
                Iterator<ConfigurazioneHandlerBean> it = lista.iterator();
                int numeroElementi = lista.size();
                int i = 0;
                while (it.hasNext()) {
                    DataElement de;
                    ConfigurazioneHandlerBean handler = it.next();
                    org.openspcoop2.web.lib.mvc.Parameter pId = new org.openspcoop2.web.lib.mvc.Parameter("hId", "" + handler.getId());
                    ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamEntry = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                    lstParamEntry.add(pId);
                    if (lstParamSession.size() > 0) {
                        lstParamEntry.addAll(lstParamSession);
                    }
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    if (lista.size() > 1) {
                        de = new DataElement();
                        de.setWidthPx(48);
                        de.setType(DataElementType.IMAGE);
                        DataElementImage imageUp = new DataElementImage();
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneSu = new org.openspcoop2.web.lib.mvc.Parameter("hPos", "su");
                        org.openspcoop2.web.lib.mvc.Parameter pDirezioneGiu = new org.openspcoop2.web.lib.mvc.Parameter("hPos", "giu");
                        ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamDirezioneSu = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                        lstParamDirezioneSu.addAll(lstParamEntry);
                        lstParamDirezioneSu.add(pDirezioneSu);
                        ArrayList<org.openspcoop2.web.lib.mvc.Parameter> lstParamDirezioneGiu = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                        lstParamDirezioneGiu.addAll(lstParamEntry);
                        lstParamDirezioneGiu.add(pDirezioneGiu);
                        if (i > 0) {
                            imageUp.setImage("&#xE316;");
                            imageUp.setToolTip("Sposta su");
                            imageUp.setUrl(servletListURL, lstParamDirezioneSu.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamDirezioneSu.size()]));
                        } else {
                            imageUp.setImage("&#160;&#160;&#160;&#160;&#160;");
                        }
                        de.addImage(imageUp);
                        if (i < numeroElementi - 1) {
                            DataElementImage imageDown = new DataElementImage();
                            imageDown.setImage("&#xE313;");
                            imageDown.setToolTip("Sposta gi&ugrave;");
                            imageDown.setUrl(servletListURL, lstParamDirezioneGiu.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamDirezioneGiu.size()]));
                            de.addImage(imageDown);
                        }
                        de.setValue("" + handler.getPosizione());
                        e.add(de);
                    }
                    de = new DataElement();
                    de.setWidthPx(10);
                    de.setType(DataElementType.CHECKBOX);
                    if (handler.getStato() == null || StatoFunzionalita.ABILITATO.equals((Object)handler.getStato())) {
                        de.setToolTip("Abilitato");
                        de.setValue("Abilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_ENABLE);
                    } else {
                        de.setToolTip("Disabilitato");
                        de.setValue("Disabilitato");
                        de.setSelected(CheckboxStatusType.CONFIG_DISABLE);
                    }
                    e.add(de);
                    de = new DataElement();
                    de.setIdToRemove(handler.getTipo());
                    de.setValue(handler.getNome());
                    de.setToolTip(handler.getNome());
                    de.setUrl(servletChangeURL, lstParamEntry.toArray(new org.openspcoop2.web.lib.mvc.Parameter[lstParamEntry.size()]));
                    e.add(de);
                    de = new DataElement();
                    de.setValue(handler.getDescrizioneAbbr());
                    de.setToolTip(handler.getDescrizione());
                    e.add(de);
                    dati.add(e);
                    ++i;
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<org.openspcoop2.web.lib.mvc.Parameter> getTitleListHandler(String tipologia, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String nomeOggetto, String servletURL, String labelHandlerDi, String labelHandler) throws Exception {
        List<org.openspcoop2.web.lib.mvc.Parameter> lstParamPorta = null;
        if (ruoloPorta != null) {
            Long idPorta = Long.parseLong(idPortaS);
            String labelPerPorta = null;
            if (TipoPdD.DELEGATA.equals((Object)ruoloPorta)) {
                Integer parentPD = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
                if (parentPD == null) {
                    parentPD = 0;
                }
                PortaDelegata myPD = this.porteDelegateCore.getPortaDelegata(idPorta);
                String idporta = myPD.getNome();
                MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(myPD);
                long idSoggetto = myPD.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPD.getIdServizio());
                long idFruizione = this.apsCore.getIdFruizioneAccordoServizioParteSpecifica(mappingPD.getIdFruitore(), mappingPD.getIdServizio());
                PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
                lstParamPorta = porteDelegateHelper.getTitoloPD(parentPD, "" + idSoggetto, "" + idAsps, "" + idFruizione);
                Object labelOpzioniAvanzate = null;
                labelOpzioniAvanzate = parentPD != null && parentPD == 2 ? this.porteDelegateCore.getLabelRegolaMappingFruizionePortaDelegata("Opzioni Avanzate di ", "Opzioni Avanzate", myPD) : "Opzioni Avanzate di " + idporta;
                org.openspcoop2.web.lib.mvc.Parameter pIdPD = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + myPD.getId());
                org.openspcoop2.web.lib.mvc.Parameter pNomePD = new org.openspcoop2.web.lib.mvc.Parameter("nomePorta", myPD.getNome());
                org.openspcoop2.web.lib.mvc.Parameter pIdSoggPD = new org.openspcoop2.web.lib.mvc.Parameter("idsogg", "" + myPD.getIdSoggetto());
                org.openspcoop2.web.lib.mvc.Parameter pConfigurazioneAltroPorta = new org.openspcoop2.web.lib.mvc.Parameter("configurazioneAltroPorta", "true");
                org.openspcoop2.web.lib.mvc.Parameter pIdAsps = new org.openspcoop2.web.lib.mvc.Parameter("idAsps", "" + idAsps);
                org.openspcoop2.web.lib.mvc.Parameter pIdFruitore = new org.openspcoop2.web.lib.mvc.Parameter("myId", "" + idFruizione);
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter((String)labelOpzioniAvanzate, "porteDelegateChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pConfigurazioneAltroPorta}));
                labelPerPorta = labelHandler;
            } else {
                Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
                PortaApplicativa myPA = this.porteApplicativeCore.getPortaApplicativa(idPorta);
                String idporta = myPA.getNome();
                MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(myPA);
                long idSoggetto = myPA.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPA.getIdServizio());
                PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(this.request, this.pd, this.session);
                lstParamPorta = porteApplicativeHelper.getTitoloPA(parentPA, "" + idSoggetto, "" + idAsps);
                Object labelOpzioniAvanzate = null;
                labelOpzioniAvanzate = parentPA != null && parentPA == 2 ? this.porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Opzioni Avanzate di ", "Opzioni Avanzate", myPA) : "Opzioni Avanzate di " + idporta;
                org.openspcoop2.web.lib.mvc.Parameter pNomePorta = new org.openspcoop2.web.lib.mvc.Parameter("nomePorta", myPA.getNome());
                org.openspcoop2.web.lib.mvc.Parameter pIdSogg = new org.openspcoop2.web.lib.mvc.Parameter("idsogg", "" + idSoggetto);
                org.openspcoop2.web.lib.mvc.Parameter pIdPorta = new org.openspcoop2.web.lib.mvc.Parameter("id", "" + idPorta);
                org.openspcoop2.web.lib.mvc.Parameter pIdAsps = new org.openspcoop2.web.lib.mvc.Parameter("idAsps", "" + idAsps);
                org.openspcoop2.web.lib.mvc.Parameter pConfigurazioneAltroPorta = new org.openspcoop2.web.lib.mvc.Parameter("configurazioneAltroPorta", "true");
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter((String)labelOpzioniAvanzate, "porteApplicativeChange.do", new org.openspcoop2.web.lib.mvc.Parameter[]{pIdSogg, pNomePorta, pIdPorta, pIdAsps, pConfigurazioneAltroPorta}));
                labelPerPorta = labelHandler;
            }
            if (nomeOggetto == null) {
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter(labelPerPorta, null));
            } else {
                ArrayList<org.openspcoop2.web.lib.mvc.Parameter> list = new ArrayList<org.openspcoop2.web.lib.mvc.Parameter>();
                list.add(new org.openspcoop2.web.lib.mvc.Parameter("hFase", tipologia));
                list.add(new org.openspcoop2.web.lib.mvc.Parameter("hRuoloPorta", ruoloPorta.getTipo()));
                list.add(new org.openspcoop2.web.lib.mvc.Parameter("hIdPorta", idPortaS));
                if (serviceBinding != null) {
                    list.add(new org.openspcoop2.web.lib.mvc.Parameter("hServiceBinding", serviceBinding.name()));
                }
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter(labelPerPorta, servletURL, list));
                lstParamPorta.add(new org.openspcoop2.web.lib.mvc.Parameter(nomeOggetto, null));
            }
        }
        return lstParamPorta;
    }

    public void impostaComandiMenuContestualeHandler(TipoPdD ruoloPorta, String idPortaS) throws Exception {
        if (ruoloPorta != null) {
            Long idPorta = Long.parseLong(idPortaS);
            if (TipoPdD.DELEGATA.equals((Object)ruoloPorta)) {
                PortaDelegata myPD = this.porteDelegateCore.getPortaDelegata(idPorta);
                MappingFruizionePortaDelegata mappingPD = this.porteDelegateCore.getMappingFruizionePortaDelegata(myPD);
                long idSoggetto = myPD.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPD.getIdServizio());
                long idFruizione = this.apsCore.getIdFruizioneAccordoServizioParteSpecifica(mappingPD.getIdFruitore(), mappingPD.getIdServizio());
                PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
                porteDelegateHelper.impostaComandiMenuContestualePD("" + idSoggetto, "" + idAsps, "" + idFruizione);
            } else {
                PortaApplicativa myPA = this.porteApplicativeCore.getPortaApplicativa(idPorta);
                MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(myPA);
                long idSoggetto = myPA.getIdSoggetto();
                long idAsps = this.apsCore.getIdAccordoServizioParteSpecifica(mappingPA.getIdServizio());
                PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(this.request, this.pd, this.session);
                porteApplicativeHelper.impostaComandiMenuContestualePA("" + idSoggetto, "" + idAsps);
            }
        }
    }

    public String getLabelTipologiaFromFaseMessageHandler(String fase, boolean request) {
        if (fase != null) {
            return this.getLabelTipologiaFromFaseMessageHandler(FaseMessageHandler.toEnumConstant((String)fase), request);
        }
        return null;
    }

    public String getLabelTipologiaFromFaseMessageHandler(FaseMessageHandler fase, boolean request) {
        if (fase != null) {
            String prefix = request ? "Handlers Richiesta [{0}]" : "Handlers Risposta [{0}]";
            switch (fase) {
                case IN: {
                    return MessageFormat.format(prefix, "In");
                }
                case IN_PROTOCOL_INFO: {
                    return MessageFormat.format(prefix, "InProfileInfo");
                }
                case OUT: {
                    return MessageFormat.format(prefix, "Out");
                }
                case POST_OUT: {
                    return MessageFormat.format(prefix, "Post-Out");
                }
                case PRE_IN: {
                    return MessageFormat.format(prefix, "Pre-In");
                }
            }
        }
        return null;
    }

    public String getLabelTipologiaFromFaseServiceHandler(String fase) {
        if (fase != null) {
            return this.getLabelTipologiaFromFaseServiceHandler(FaseServiceHandler.toEnumConstant((String)fase));
        }
        return null;
    }

    public String getLabelTipologiaFromFaseServiceHandler(FaseServiceHandler fase) {
        if (fase != null) {
            String prefix = "Service Handlers [{0}]";
            switch (fase) {
                case EXIT: {
                    return MessageFormat.format(prefix, "Shutdown Gateway");
                }
                case INIT: {
                    return MessageFormat.format(prefix, "Startup Gateway");
                }
                case INTEGRATION_MANAGER_REQUEST: {
                    return MessageFormat.format(prefix, "Richiesta al servizio IntegrationManager/MessageBox");
                }
                case INTEGRATION_MANAGER_RESPONSE: {
                    return MessageFormat.format(prefix, "Risposta dal servizio IntegrationManager/MessageBox");
                }
            }
        }
        return null;
    }

    public void addHandlerRichiestaToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String idHandlerS, String nomePlugin, String stato, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String fase, List<String> tipiPluginGiaUtilizzati, String messaggioValoriNonDisponibili) throws Exception {
        this.addHandlerToDati(dati, tipoOperazione, idHandlerS, nomePlugin, stato, ruoloPorta, idPortaS, serviceBinding, fase, PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RICHIESTA, TipoPlugin.MESSAGE_HANDLER, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
    }

    public void addHandlerRispostaToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String idHandlerS, String nomePlugin, String stato, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String fase, List<String> tipiPluginGiaUtilizzati, String messaggioValoriNonDisponibili) throws Exception {
        this.addHandlerToDati(dati, tipoOperazione, idHandlerS, nomePlugin, stato, ruoloPorta, idPortaS, serviceBinding, fase, PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RISPOSTA, TipoPlugin.MESSAGE_HANDLER, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
    }

    public void addHandlerServizioToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String idHandlerS, String nomePlugin, String stato, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String fase, List<String> tipiPluginGiaUtilizzati, String messaggioValoriNonDisponibili) throws Exception {
        this.addHandlerToDati(dati, tipoOperazione, idHandlerS, nomePlugin, stato, ruoloPorta, idPortaS, serviceBinding, fase, null, TipoPlugin.SERVICE_HANDLER, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
    }

    public void addHandlerToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String idHandlerS, String nomePlugin, String stato, TipoPdD ruoloPorta, String idPortaS, ServiceBinding serviceBinding, String fase, String ruoloHandler, TipoPlugin tipoPlugin, List<String> tipiPluginGiaUtilizzati, String messaggioValoriNonDisponibili) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("Id");
        de.setName("hId");
        de.setType(DataElementType.HIDDEN);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            de.setValue("");
        } else {
            de.setValue(idHandlerS);
        }
        dati.add(de);
        de = new DataElement();
        de.setName("hRuoloPorta");
        de.setValue(ruoloPorta != null ? ruoloPorta.getTipo() : null);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setName("hIdPorta");
        de.setValue(idPortaS);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        if (serviceBinding != null) {
            de = new DataElement();
            de.setName("hServiceBinding");
            de.setValue(serviceBinding.name());
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("hFase");
        de.setValue(fase);
        de.setType(DataElementType.HIDDEN);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Informazioni Generali");
        dati.add(de);
        if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
            this.addCustomFieldConValoriDaEscludere(tipoPlugin, ruoloHandler, fase, "", "hPlugin", GruppoIntegrazione.PLUGIN.getCompactLabel(), nomePlugin, false, dati, false, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
        } else {
            de = new DataElement();
            de.setName("hPlugin");
            de.setValue(nomePlugin);
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
            de = new DataElement();
            de.setName("hPlugintxt");
            de.setValue(nomePlugin);
            de.setType(DataElementType.TEXT);
            de.setLabel(GruppoIntegrazione.PLUGIN.getCompactLabel());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("hStato");
        de.setType(DataElementType.SELECT);
        String[] statoValues = CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA;
        de.setSelected(stato);
        de.setLabels(statoValues);
        de.setValues(statoValues);
        dati.add(de);
    }

    public boolean handlerRichiestaCheckData(TipoOperazione tipoOp, ConfigurazioneHandlerBean oldHandler, String nomePlugin, String stato, TipoPdD ruoloPorta, Long idPorta, String fase, String tipo, String messaggioHandlerRichiestaDuplicato) throws Exception {
        return this.handlerCheckData(tipoOp, oldHandler, nomePlugin, stato, ruoloPorta, idPorta, fase, tipo, messaggioHandlerRichiestaDuplicato);
    }

    public boolean handlerRispostaCheckData(TipoOperazione tipoOp, ConfigurazioneHandlerBean oldHandler, String nomePlugin, String stato, TipoPdD ruoloPorta, Long idPorta, String fase, String tipo, String messaggioHandlerRichiestaDuplicato) throws Exception {
        return this.handlerCheckData(tipoOp, oldHandler, nomePlugin, stato, ruoloPorta, idPorta, fase, tipo, messaggio