/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazionePluginsArchiviChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            Object idArchivioS = confHelper.getParametroLong("plId");
            String nome = confHelper.getParameter("plNome");
            String oldNome = confHelper.getParameter("plOldNome");
            String descrizione = confHelper.getParameter("plDescr");
            String stato = confHelper.getParameter("plStato");
            String sorgente = null;
            BinaryParameter jarArchivio = null;
            String urlArchivio = null;
            String dirArchivio = null;
            String classiPlugin = confHelper.getParameter("plClassi");
            Object tipoPlugin = confHelper.getParameterValues("plTipo");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            int numeroArchivi = confCore.getNumeroArchiviJarRegistroPlugin(oldNome);
            RegistroPlugin oldRegistro = confCore.getDatiRegistroPlugin(oldNome);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Registro Archivi", "configurazionePluginsArchiviList.do"));
            lstParam.add(new Parameter(oldRegistro.getNome(), null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (confHelper.isEditModeInProgress()) {
                if (nome == null) {
                    idArchivioS = "" + oldRegistro.getId();
                    nome = oldRegistro.getNome();
                    descrizione = oldRegistro.getDescrizione();
                    stato = oldRegistro.getStato().toString();
                    sorgente = null;
                    classiPlugin = oldRegistro.getCompatibilitaList() == null || oldRegistro.getCompatibilitaList().isEmpty() ? "qualsiasi" : "selezionate";
                    tipoPlugin = classiPlugin.equals("selezionate") ? oldRegistro.getCompatibilitaList().toArray(new String[oldRegistro.sizeCompatibilitaList()]) : null;
                    dirArchivio = "";
                    urlArchivio = "";
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroPluginToDati(TipoOperazione.CHANGE, dati, oldNome, (String)idArchivioS, nome, descrizione, stato, sorgente, jarArchivio, dirArchivio, urlArchivio, classiPlugin, (String[])tipoPlugin, numeroArchivi);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = confHelper.registroPluginCheckData(TipoOperazione.CHANGE, oldNome, (String)idArchivioS, nome, descrizione, stato, sorgente, jarArchivio, dirArchivio, urlArchivio, classiPlugin, (String[])tipoPlugin);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroPluginToDati(TipoOperazione.CHANGE, dati, oldNome, (String)idArchivioS, nome, descrizione, stato, sorgente, jarArchivio, dirArchivio, urlArchivio, classiPlugin, (String[])tipoPlugin, numeroArchivi);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.CHANGE());
            }
            RegistroPlugin registro = confCore.getDatiRegistroPlugin(oldNome);
            registro.setOldNome(oldNome);
            registro.setNome(nome);
            if (descrizione != null && !"".equals(descrizione)) {
                registro.setDescrizione(descrizione);
            } else {
                registro.setDescrizione(null);
            }
            if (stato.equals(StatoFunzionalita.ABILITATO.getValue())) {
                registro.setStato(StatoFunzionalita.ABILITATO);
            } else {
                registro.setStato(StatoFunzionalita.DISABILITATO);
            }
            registro.setData(new Date());
            registro.getCompatibilitaList().clear();
            if (!classiPlugin.equals("qualsiasi")) {
                for (String tipo : tipoPlugin) {
                    registro.getCompatibilitaList().add(tipo);
                }
            }
            confCore.performUpdateOperation(userLogin, confHelper.smista(), registro);
            confCore.updatePluginClassLoader();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_ARCHIVI;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<RegistroPlugin> lista = confCore.pluginsArchiviList((ISearch)ricerca);
            confHelper.preparePluginsArchiviList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazionePluginsArchivi", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

