/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.PluginProprietaCompatibilita;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazionePluginsTipoPluginUtils;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazionePluginsClassiChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String idPluginS = confHelper.getParametroLong("pcId");
            String descrizione = confHelper.getParameter("pcDescr");
            String stato = confHelper.getParameter("pcStato");
            String tipo = confHelper.getParameter("pcTipo");
            String tipoPluginS = confHelper.getParameter("pcTipoPlugin");
            TipoPlugin tipoPlugin = null;
            if (tipoPluginS != null) {
                tipoPlugin = TipoPlugin.toEnumConstant((String)tipoPluginS);
            }
            String label = confHelper.getParameter("pcLabel");
            String className = confHelper.getParameter("pcClassName");
            String ruolo = confHelper.getParameter("pcFRuolo");
            String shTipo = confHelper.getParameter("pcFSH");
            String mhTipo = confHelper.getParameter("pcFFMH");
            String mhRuolo = confHelper.getParameter("pcFRMH");
            String applicabilita = confHelper.getParameter("pcFAppl");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            long idPlugin = Long.parseLong(idPluginS);
            Plugin oldPlugin = confCore.getPlugin(idPlugin);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Registro Classi", "configurazionePluginsClassiList.do"));
            lstParam.add(new Parameter(oldPlugin.getLabel(), null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (confHelper.isEditModeInProgress()) {
                if (tipoPluginS == null) {
                    tipoPluginS = oldPlugin.getTipoPlugin();
                    tipoPlugin = TipoPlugin.toEnumConstant((String)tipoPluginS);
                    descrizione = oldPlugin.getDescrizione();
                    stato = oldPlugin.isStato() ? StatoFunzionalita.ABILITATO.toString() : StatoFunzionalita.DISABILITATO.toString();
                    tipo = oldPlugin.getTipo();
                    label = oldPlugin.getLabel();
                    className = oldPlugin.getClassName();
                    ruolo = ConfigurazionePluginsTipoPluginUtils.getValoreProprieta(oldPlugin, "Ruolo");
                    shTipo = ConfigurazionePluginsTipoPluginUtils.getValoreProprieta(oldPlugin, "ServiceHandler");
                    mhTipo = ConfigurazionePluginsTipoPluginUtils.getValoreProprieta(oldPlugin, "FaseMessageHandler");
                    mhRuolo = ConfigurazionePluginsTipoPluginUtils.getValoreProprieta(oldPlugin, "RuoloMessageHandler");
                    applicabilita = ConfigurazionePluginsTipoPluginUtils.getValoreProprieta(oldPlugin, "Applicabilita");
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addPluginClassiToDati(TipoOperazione.CHANGE, dati, idPluginS, tipoPlugin, tipo, label, className, stato, descrizione, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = confHelper.pluginClassiCheckData(TipoOperazione.CHANGE, oldPlugin, idPluginS, tipoPlugin, tipo, label, className, stato, descrizione, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addPluginClassiToDati(TipoOperazione.CHANGE, dati, idPluginS, tipoPlugin, tipo, label, className, stato, descrizione, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.CHANGE());
            }
            Plugin plugin = confCore.getPlugin(idPlugin);
            IdPlugin oldIdPlugin = new IdPlugin();
            oldIdPlugin.setClassName(plugin.getClassName());
            oldIdPlugin.setLabel(plugin.getLabel());
            oldIdPlugin.setTipo(plugin.getTipo());
            oldIdPlugin.setTipoPlugin(plugin.getTipoPlugin());
            plugin.setOldIdPlugin(oldIdPlugin);
            plugin.setLabel(label);
            plugin.setTipo(tipo);
            plugin.setTipoPlugin(tipoPluginS);
            plugin.setDescrizione(descrizione);
            plugin.setStato(stato.equals(StatoFunzionalita.ABILITATO.getValue()));
            plugin.setClassName(className);
            plugin.getPluginProprietaCompatibilitaList().clear();
            List<PluginProprietaCompatibilita> listaProprieta = ConfigurazionePluginsTipoPluginUtils.getApplicabilitaClassePlugin(tipoPlugin, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
            if (!listaProprieta.isEmpty()) {
                plugin.getPluginProprietaCompatibilitaList().addAll(listaProprieta);
            }
            confCore.performUpdateOperation(userLogin, confHelper.smista(), plugin);
            if (!className.equals(oldIdPlugin.getClassName()) || !label.equals(oldIdPlugin.getLabel()) || !tipo.equals(oldIdPlugin.getTipo()) || tipoPluginS != null && !tipoPluginS.equals(oldIdPlugin.getTipoPlugin())) {
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.CONFIGURAZIONE_PLUGINS_CLASSI);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_CLASSI;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<Plugin> lista = confCore.pluginsClassiList((ISearch)ricerca);
            confHelper.preparePluginsClassiList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

