/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.utils.ConfigManager;
import org.openspcoop2.core.mvc.properties.utils.PropertiesSourceConfiguration;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.AttributeAuthorityUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.PolicyAttributeAuthority;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.web.ctrlstat.core.CertificateChecker;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.mvc.properties.beans.ConfigBean;
import org.slf4j.Logger;

public class ConfigurazionePolicyGestioneTokenVerificaCertificati
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String id = confHelper.getParametroLong("idPolicy");
            String infoType = confHelper.getParametroInfoType("_tabKey_infoType");
            if (infoType == null) {
                infoType = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_infoType");
            }
            boolean attributeAuthority = ConfigurazioneCostanti.isConfigurazioneAttributeAuthority(infoType);
            String alias = confHelper.getParameter("aliasNodo");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            String verificaCertificatiFromLista = confHelper.getParameter("certVerFromLista");
            boolean arrivoDaLista = "true".equalsIgnoreCase(verificaCertificatiFromLista);
            List<String> aliases = confCore.getJmxPdDAliases();
            if (aliases == null || aliases.isEmpty()) {
                throw new ControlStationCoreException("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
            }
            GenericProperties genericProperties = confCore.getGenericProperties(Long.parseLong(id));
            PropertiesSourceConfiguration propertiesSourceConfiguration = attributeAuthority ? confCore.getAttributeAuthorityPropertiesSourceConfiguration() : confCore.getPolicyGestioneTokenPropertiesSourceConfiguration();
            ConfigManager configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
            configManager.leggiConfigurazioni(propertiesSourceConfiguration, true);
            String verificaConnettivitaS = confHelper.getParameter("tokenVerConn");
            boolean verificaConnettivita = "true".equalsIgnoreCase(verificaConnettivitaS);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            String label = attributeAuthority ? "Attribute Authority" : "Token Policy";
            lstParam.add(new Parameter(label, "configurazionePolicyGestioneTokenList.do"));
            if (arrivoDaLista) {
                String labelVerifica = (verificaConnettivita ? "Verifica Connettivit\u00e0 di " : "Verifica Certificati di ") + genericProperties.getNome();
                lstParam.add(new Parameter(labelVerifica, null));
            } else {
                Parameter pPolicyId = new Parameter("idPolicy", "" + genericProperties.getId());
                Parameter pInfoType = new Parameter("_tabKey_infoType", infoType);
                lstParam.add(new Parameter(genericProperties.getNome(), "configurazionePolicyGestioneTokenChange.do", new Parameter[]{pInfoType, pPolicyId}));
                String labelVerifica = verificaConnettivita ? "Verifica Connettivit\u00e0" : "Verifica Certificati";
                lstParam.add(new Parameter(labelVerifica, null));
            }
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            boolean validazione = false;
            boolean negoziazione = false;
            if (!attributeAuthority) {
                validazione = "gestionePolicyToken".equals(genericProperties.getTipologia());
                negoziazione = "retrievePolicyToken".equals(genericProperties.getTipologia());
            }
            boolean httpsDynamicDiscovery = false;
            boolean httpsValidazioneJWT = false;
            boolean httpsIntrospection = false;
            boolean httpsUserInfo = false;
            boolean validazioneJwt = false;
            boolean forwardToJwt = false;
            boolean https = false;
            boolean signedJwt = false;
            boolean dpopJwt = false;
            boolean jwtRichiesta = false;
            boolean jwtRisposta = false;
            boolean verificaCertificatiPossibile = false;
            boolean riferimentoApplicativoModi = false;
            boolean riferimentoFruizioneModi = false;
            boolean riferimentoApplicativoModiDpop = false;
            boolean riferimentoFruizioneModiDpop = false;
            if (!verificaConnettivita) {
                if (attributeAuthority) {
                    policy = AttributeAuthorityUtilities.convertTo((GenericProperties)genericProperties);
                    https = policy.isEndpointHttps();
                    if (policy.isRequestJws() && (keystoreParams = AttributeAuthorityUtilities.getRequestJwsKeystoreParams((PolicyAttributeAuthority)policy)) != null) {
                        jwtRichiesta = true;
                    }
                    if (policy.isResponseJws() && (keystoreParams = AttributeAuthorityUtilities.getResponseJwsKeystoreParams((PolicyAttributeAuthority)policy)) != null) {
                        jwtRisposta = true;
                    }
                    verificaCertificatiPossibile = https || jwtRichiesta || jwtRisposta;
                } else if (validazione) {
                    KeystoreParams keystoreParams;
                    GestioneToken gestioneToken = new GestioneToken();
                    gestioneToken.setIntrospection(StatoFunzionalitaConWarning.ABILITATO);
                    gestioneToken.setUserInfo(StatoFunzionalitaConWarning.ABILITATO);
                    gestioneToken.setValidazione(StatoFunzionalitaConWarning.ABILITATO);
                    gestioneToken.setForward(StatoFunzionalita.ABILITATO);
                    PolicyGestioneToken policyGestioneToken = TokenUtilities.convertTo((GenericProperties)genericProperties, (GestioneToken)gestioneToken);
                    if (policyGestioneToken.isDynamicDiscovery()) {
                        httpsDynamicDiscovery = policyGestioneToken.isEndpointHttps(false, false);
                    }
                    if (!policyGestioneToken.isDynamicDiscovery()) {
                        if (policyGestioneToken.isValidazioneJWT() && policyGestioneToken.isValidazioneJWTLocationHttp()) {
                            httpsValidazioneJWT = policyGestioneToken.isEndpointHttps(false, false);
                        }
                        if (policyGestioneToken.isIntrospection()) {
                            httpsIntrospection = policyGestioneToken.isEndpointHttps(true, false);
                        }
                        if (policyGestioneToken.isUserInfo()) {
                            httpsUserInfo = policyGestioneToken.isEndpointHttps(false, true);
                        }
                        if (policyGestioneToken.isValidazioneJWT()) {
                            String tokenType = policyGestioneToken.getTipoToken();
                            keystoreParams = null;
                            if ("jws".equals(tokenType) || "jwe".equals(tokenType)) {
                                keystoreParams = TokenUtilities.getValidazioneJwtKeystoreParams((PolicyGestioneToken)policyGestioneToken);
                            }
                            if (keystoreParams != null) {
                                validazioneJwt = true;
                            }
                        }
                    }
                    if (policyGestioneToken.isForwardToken() && policyGestioneToken.isForwardTokenInformazioniRaccolte()) {
                        String forwardInformazioniRaccolteMode = policyGestioneToken.getForwardTokenInformazioniRaccolteMode();
                        keystoreParams = null;
                        if ("op2jws".equals(forwardInformazioniRaccolteMode) || "jws".equals(forwardInformazioniRaccolteMode) || "jwe".equals(forwardInformazioniRaccolteMode)) {
                            keystoreParams = TokenUtilities.getForwardToJwtKeystoreParams((PolicyGestioneToken)policyGestioneToken);
                        }
                        if (keystoreParams != null) {
                            forwardToJwt = true;
                        }
                    }
                    verificaCertificatiPossibile = httpsDynamicDiscovery || httpsValidazioneJWT || httpsIntrospection || httpsUserInfo || validazioneJwt || forwardToJwt;
                } else if (negoziazione) {
                    policy = TokenUtilities.convertTo((GenericProperties)genericProperties);
                    https = policy.isEndpointHttps();
                    if (policy.isRfc7523x509Grant()) {
                        keystoreParams = TokenUtilities.getSignedJwtKeystoreParams((PolicyNegoziazioneToken)policy);
                        riferimentoApplicativoModi = keystoreParams != null && "applicativoModi".equalsIgnoreCase(keystoreParams.getPath());
                        boolean bl = riferimentoFruizioneModi = keystoreParams != null && "fruizioneModi".equalsIgnoreCase(keystoreParams.getPath());
                        if (keystoreParams != null && !riferimentoApplicativoModi && !riferimentoFruizioneModi) {
                            signedJwt = true;
                        }
                    }
                    if (policy.isDpop()) {
                        KeystoreParams keystoreParamsDpop = TokenUtilities.getDpopKeystoreParams((PolicyNegoziazioneToken)policy);
                        riferimentoApplicativoModiDpop = keystoreParamsDpop != null && "applicativoModi".equalsIgnoreCase(keystoreParamsDpop.getPath());
                        boolean bl = riferimentoFruizioneModiDpop = keystoreParamsDpop != null && "fruizioneModi".equalsIgnoreCase(keystoreParamsDpop.getPath());
                        if (keystoreParamsDpop != null && !riferimentoApplicativoModiDpop && !riferimentoFruizioneModiDpop) {
                            dpopJwt = true;
                        }
                    }
                    verificaCertificatiPossibile = https || signedJwt || dpopJwt;
                } else {
                    throw new CoreException("Tipologia '" + genericProperties.getTipologia() + "' non gestita");
                }
            }
            boolean verificaCertificatiEffettuata = false;
            if (!verificaConnettivita && !verificaCertificatiPossibile) {
                if (riferimentoApplicativoModi) {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati: vengono riferiti i certificati definiti nella configurazione dell'applicativo", Costanti.MESSAGE_TYPE_INFO);
                } else if (riferimentoFruizioneModi) {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati: vengono riferiti i certificati definiti nella configurazione della fruizione", Costanti.MESSAGE_TYPE_INFO);
                } else if (riferimentoApplicativoModiDpop) {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati: vengono riferiti i certificati definiti nella configurazione dell'applicativo", Costanti.MESSAGE_TYPE_INFO);
                } else if (riferimentoFruizioneModiDpop) {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati: vengono riferiti i certificati definiti nella configurazione della fruizione", Costanti.MESSAGE_TYPE_INFO);
                } else {
                    pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati", Costanti.MESSAGE_TYPE_INFO);
                }
                pd.disableEditMode();
                verificaCertificatiEffettuata = true;
            } else {
                boolean sceltaClusterId = true;
                if (!verificaConnettivita) {
                    sceltaClusterId = confCore.isVerificaCertificatiSceltaClusterId();
                }
                if (aliases.size() == 1 || alias != null || !sceltaClusterId) {
                    if (alias == null && !sceltaClusterId) {
                        alias = "Verifica su tutti i nodi";
                    }
                    if (verificaConnettivita) {
                        String aliasDescrizione = null;
                        aliasDescrizione = "Verifica su tutti i nodi".equals(alias) ? aliases.get(0) : (alias != null ? alias : aliases.get(0));
                        confHelper.addDescrizioneVerificaConnettivitaToDati(dati, genericProperties, null, false, aliasDescrizione);
                        if (!confHelper.isEditModeInProgress()) {
                            ArrayList<String> aliasesForCheck = new ArrayList<String>();
                            if (aliases.size() == 1) {
                                aliasesForCheck.add(aliases.get(0));
                            } else if ("Verifica su tutti i nodi".equals(alias)) {
                                aliasesForCheck.addAll(aliases);
                            } else {
                                aliasesForCheck.add(alias);
                            }
                            boolean rilevatoErrore = false;
                            StringBuilder sbPerOperazioneEffettuata = new StringBuilder();
                            int index = 0;
                            for (String aliasForVerificaConnettore : aliasesForCheck) {
                                String risorsa = confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(aliasForVerificaConnettore);
                                StringBuilder bfExternal = new StringBuilder();
                                String descrizione = confCore.getJmxPdDDescrizione(aliasForVerificaConnettore);
                                if (aliases.size() > 1) {
                                    if (index > 0) {
                                        bfExternal.append("<br/>");
                                    }
                                    bfExternal.append("ID Cluster").append(" ").append(descrizione).append("<br/>");
                                }
                                try {
                                    String nomeMetodo = null;
                                    if (attributeAuthority) {
                                        nomeMetodo = confCore.getJmxPdDConfigurazioneSistemaNomeMetodoCheckConnettoreAttributeAuthority(aliasForVerificaConnettore);
                                    } else if (validazione) {
                                        nomeMetodo = confCore.getJmxPdDConfigurazioneSistemaNomeMetodoCheckConnettoreTokenPolicyValidazione(aliasForVerificaConnettore);
                                    } else if (negoziazione) {
                                        nomeMetodo = confCore.getJmxPdDConfigurazioneSistemaNomeMetodoCheckConnettoreTokenPolicyNegoziazione(aliasForVerificaConnettore);
                                    }
                                    Boolean slowOperation = true;
                                    String stato = confCore.getInvoker().invokeJMXMethod(aliasForVerificaConnettore, confCore.getJmxPdDConfigurazioneSistemaType(aliasForVerificaConnettore), risorsa, nomeMetodo, slowOperation, genericProperties.getNome());
                                    if ("Operazione effettuata con successo".equals(stato) || stato != null && stato.startsWith("Operazione effettuata con successo; ")) {
                                        bfExternal.append("Test di connettivit\u00e0 effettuato con successo");
                                    } else {
                                        rilevatoErrore = true;
                                        bfExternal.append("Test di connettivit\u00e0 fallito: ");
                                        if (stato != null && stato.startsWith("Operazione non riuscita: ")) {
                                            bfExternal.append(stato.substring("Operazione non riuscita: ".length()));
                                        } else {
                                            bfExternal.append(stato);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    ControlStationCore.logError("Errore durante la verifica del connettore (jmxResource '" + risorsa + "') (node:" + aliasForVerificaConnettore + "): " + e.getMessage(), e);
                                    rilevatoErrore = true;
                                    String stato = e.getMessage();
                                    bfExternal.append("Test di connettivit\u00e0 fallito: ");
                                    if (stato.startsWith("Operazione non riuscita: ")) {
                                        bfExternal.append(stato.substring("Operazione non riuscita: ".length()));
                                    }
                                    bfExternal.append(stato);
                                }
                                if (sbPerOperazioneEffettuata.length() > 0) {
                                    sbPerOperazioneEffettuata.append("<br/>");
                                }
                                sbPerOperazioneEffettuata.append(bfExternal.toString());
                                ++index;
                            }
                            if (sbPerOperazioneEffettuata != null) {
                                if (rilevatoErrore) {
                                    pd.setMessage(sbPerOperazioneEffettuata.toString());
                                } else {
                                    pd.setMessage(sbPerOperazioneEffettuata.toString(), Costanti.MESSAGE_TYPE_INFO);
                                }
                            }
                            pd.disableEditMode();
                        }
                    } else {
                        ArrayList<String> aliasesForCheck = new ArrayList<String>();
                        boolean all = false;
                        if (aliases.size() == 1) {
                            aliasesForCheck.add(aliases.get(0));
                        } else if ("Verifica su tutti i nodi".equals(alias)) {
                            aliasesForCheck.addAll(aliases);
                            all = true;
                        } else {
                            aliasesForCheck.add(alias);
                        }
                        CertificateChecker certificateChecker = null;
                        certificateChecker = all ? confCore.getJmxPdDCertificateChecker() : confCore.newJmxPdDCertificateChecker(aliasesForCheck);
                        StringBuilder sbDetailsError = new StringBuilder();
                        int sogliaWarningGiorni = confCore.getVerificaCertificatiWarningExpirationDays();
                        String labelPolicy = genericProperties.getNome();
                        String posizioneErrore = null;
                        String extraErrore = null;
                        StringBuilder sbDetailsWarningPolicy = new StringBuilder();
                        String posizioneWarningPolicy = null;
                        if (attributeAuthority) {
                            certificateChecker.checkAttributeAuthority(sbDetailsError, sbDetailsWarningPolicy, https, jwtRichiesta, jwtRisposta, genericProperties, sogliaWarningGiorni);
                        } else if (validazione) {
                            certificateChecker.checkTokenPolicyValidazione(sbDetailsError, sbDetailsWarningPolicy, httpsDynamicDiscovery, httpsValidazioneJWT, httpsIntrospection, httpsUserInfo, validazioneJwt, forwardToJwt, genericProperties, sogliaWarningGiorni);
                        } else if (negoziazione) {
                            certificateChecker.checkTokenPolicyNegoziazione(sbDetailsError, sbDetailsWarningPolicy, https, signedJwt, dpopJwt, genericProperties, sogliaWarningGiorni);
                        }
                        if (sbDetailsError.length() > 0) {
                            posizioneErrore = labelPolicy;
                        } else if (sbDetailsWarningPolicy.length() > 0) {
                            posizioneWarningPolicy = labelPolicy;
                        }
                        String warning = null;
                        String posizioneWarning = null;
                        String extraWarning = null;
                        if (sbDetailsError.length() <= 0 && sbDetailsWarningPolicy.length() > 0) {
                            warning = sbDetailsWarningPolicy.toString();
                            posizioneWarning = posizioneWarningPolicy;
                        }
                        ArrayList<String> formatIds = new ArrayList<String>();
                        formatIds.add("Configurazione connettore https");
                        formatIds.add("Configurazione Validazione JWT");
                        formatIds.add("Configurazione ForwardTo JWT");
                        formatIds.add("Configurazione SignedJWT");
                        formatIds.add("Configurazione DPoP");
                        formatIds.add("Configurazione JWS Richiesta");
                        formatIds.add("Configurazione JWS Risposta");
                        confCore.formatVerificaCertificatiEsito(pd, formatIds, sbDetailsError.length() > 0 ? sbDetailsError.toString() : null, extraErrore, posizioneErrore, warning, extraWarning, posizioneWarning, false);
                        pd.disableEditMode();
                        verificaCertificatiEffettuata = true;
                    }
                } else {
                    DataElement deTestConnettivita = new DataElement();
                    deTestConnettivita.setType(DataElementType.TITLE);
                    if (verificaConnettivita) {
                        deTestConnettivita.setLabel("Verifica Connettivit\u00e0");
                    } else {
                        deTestConnettivita.setLabel("Verifica Certificati");
                    }
                    dati.add(deTestConnettivita);
                    confHelper.addVerificaCertificatoSceltaAlias(aliases, dati);
                }
            }
            pd.setLabelBottoneInvia("Verifica");
            dati = confHelper.addTokenPolicyHiddenToDati(dati, id, infoType);
            DataElement de = new DataElement();
            de.setValue("" + arrivoDaLista);
            de.setType(DataElementType.HIDDEN);
            de.setName("certVerFromLista");
            dati.add(de);
            de = new DataElement();
            de.setValue("" + verificaConnettivita);
            de.setType(DataElementType.HIDDEN);
            de.setName("tokenVerConn");
            dati.add(de);
            pd.setDati(dati);
            if (verificaCertificatiEffettuata) {
                if (arrivoDaLista) {
                    Properties mapId;
                    ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                    String infoTypeA = confHelper.getParameter("_tabKey_infoType");
                    String infoTypeSession = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_infoType");
                    if (infoTypeA == null) {
                        infoTypeA = infoTypeSession;
                    } else {
                        ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)infoTypeA, (String)"_tabKey_infoType");
                    }
                    attributeAuthority = ConfigurazioneCostanti.isConfigurazioneAttributeAuthority(infoTypeA);
                    Properties properties = mapId = attributeAuthority ? confCore.getAttributeAuthorityTipologia() : confCore.getTokenPolicyTipologia();
                    if (mapId != null && !mapId.isEmpty()) {
                        propertiesSourceConfiguration = attributeAuthority ? confCore.getAttributeAuthorityPropertiesSourceConfiguration() : confCore.getPolicyGestioneTokenPropertiesSourceConfiguration();
                        configManager.leggiConfigurazioni(propertiesSourceConfiguration, true);
                        for (Object oTipo : mapId.keySet()) {
                            if (!(oTipo instanceof String)) continue;
                            String ti = (String)oTipo;
                            Config config = configManager.getConfigurazione(propertiesSourceConfiguration, ti);
                            ServletUtils.removeConfigurazioneBeanFromSession((HttpServletRequest)request, (HttpSession)session, (String)config.getId());
                        }
                    }
                    int idLista = attributeAuthority ? Liste.CONFIGURAZIONE_GESTIONE_ATTRIBUTE_AUTHORITY : Liste.CONFIGURAZIONE_GESTIONE_POLICY_TOKEN;
                    ricerca = confHelper.checkSearchParameters(idLista, ricerca);
                    ArrayList<String> tipologie = new ArrayList<String>();
                    if (attributeAuthority) {
                        tipologie.add("attributeAuthority");
                    } else {
                        tipologie.add("gestionePolicyToken");
                        tipologie.add("retrievePolicyToken");
                    }
                    List<GenericProperties> lista = confCore.gestorePolicyTokenList((Integer)idLista, tipologie, (ISearch)ricerca);
                    confHelper.prepareGestorePolicyTokenList(ricerca, lista, idLista);
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazionePolicyGestioneTokenVerificaCertificati", (ForwardParams)CostantiControlStation.TIPO_OPERAZIONE_VERIFICA_CERTIFICATI);
                }
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                TipoOperazione tipoOperazione = TipoOperazione.CHANGE;
                String nome = genericProperties.getNome();
                String descrizione = genericProperties.getDescrizione();
                String tipo = genericProperties.getTipo();
                List nomiConfigurazioniPolicyGestioneToken = configManager.getNomiConfigurazioni(propertiesSourceConfiguration, new String[0]);
                List labelConfigurazioniPolicyGestioneToken = configManager.convertToLabel(propertiesSourceConfiguration, nomiConfigurazioniPolicyGestioneToken);
                String[] propConfigPolicyGestioneTokenLabelList = labelConfigurazioniPolicyGestioneToken.toArray(new String[labelConfigurazioniPolicyGestioneToken.size()]);
                String[] propConfigPolicyGestioneTokenList = nomiConfigurazioniPolicyGestioneToken.toArray(new String[nomiConfigurazioniPolicyGestioneToken.size()]);
                Config configurazione = configManager.getConfigurazione(propertiesSourceConfiguration, genericProperties.getTipo());
                Map<String, Properties> mappaDB = confCore.readGestorePolicyTokenPropertiesConfiguration(genericProperties.getId());
                ConfigBean configurazioneBean = confCore.leggiConfigurazione(configurazione, mappaDB);
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addPolicyGestioneTokenToDati(tipoOperazione, dati, id, nome, descrizione, tipo, propConfigPolicyGestioneTokenLabelList, propConfigPolicyGestioneTokenList, attributeAuthority, genericProperties);
                dati = confHelper.addPropertiesConfigToDati(tipoOperazione, dati, tipo, configurazioneBean, false);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazionePolicyGestioneToken", (ForwardParams)ForwardParams.CHANGE());
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazionePolicyGestioneTokenVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazionePolicyGestioneTokenVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }
}

