/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.connettori;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoStatistico;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class ConnettoreStatusParams {
    private boolean parsingErrors = false;
    private String statusResponseType;
    private Boolean testConnectivity;
    private Boolean testStatistics;
    private String period;
    private Integer periodValue;
    private Integer statLifetime;
    private static final String CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_MODI = "ModI";
    private static final String CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_PERSONALIZZATO = "Personalizzato";
    private static final List<String> possibleResponseTypeValues = List.of("ModI", "Personalizzato");
    private static final List<String> possibleResponseTypeLabels = List.of("ModI", "Personalizzata");
    private static final List<String> possiblePersonalizedResponseTypeValues = List.of("vuoto", "xml", "json", "text");
    private static final List<String> possiblePersonalizedResponseTypeLabels = List.of("Empty HTTP Payload", "XML", "JSON", "Text");
    private static final List<String> possiblePeriods = Arrays.asList(TipoPeriodoStatistico.toArray());
    private static final String SEPARATOR_VALORE_NON_CORRETTO = ", valore non corretto, possibli valori: ";

    private void sendError(PageData pd, String msg) {
        if (pd != null) {
            pd.setMessage(msg);
        }
        this.parsingError(true);
    }

    protected void fillFrom(ConsoleHelper helper, Map<String, String> map, ServiceBinding serviceBinding, PageData pd) throws DriverControlStationException {
        String type;
        String responseType = ConnettoreStatusParams.getParameter(helper, map, "statusResponseType");
        String personalizedType = ConnettoreStatusParams.getParameter(helper, map, "statusResponsePersonalized");
        if (responseType != null && !possibleResponseTypeValues.contains(responseType)) {
            this.sendError(pd, "Risposta, valore non corretto, possibli valori: " + String.join((CharSequence)",", possibleResponseTypeValues));
        }
        if (personalizedType != null && !possiblePersonalizedResponseTypeValues.contains(personalizedType)) {
            this.sendError(pd, "Risposta, valore non corretto, possibli valori: " + String.join((CharSequence)",", possiblePersonalizedResponseTypeValues));
        }
        String string = type = responseType == null || responseType.equals(CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_MODI) ? responseType : personalizedType;
        if (serviceBinding != null && serviceBinding.equals((Object)ServiceBinding.SOAP) && type != null && !type.equals(CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_MODI)) {
            this.sendError(pd, "Risposta valore non corretto per binding di tipo " + String.valueOf(serviceBinding));
        }
        String testConnectivityRaw = ConnettoreStatusParams.getParameter(helper, map, "testConnectivity");
        String testStatisticsRaw = ConnettoreStatusParams.getParameter(helper, map, "testStatistics");
        Integer periodValueParsed = null;
        Integer statLifetimeParsed = null;
        String periodRaw = null;
        if (ServletUtils.isCheckBoxEnabled((String)testStatisticsRaw)) {
            periodRaw = ConnettoreStatusParams.getParameter(helper, map, "period");
            if (periodRaw != null && !possiblePeriods.contains(periodRaw)) {
                this.sendError(pd, "Frequenza, valore non corretto, possibli valori: " + String.join((CharSequence)",", possiblePeriods));
            }
            String periodValueRaw = ConnettoreStatusParams.getParameter(helper, map, "periodValue");
            try {
                if (periodValueRaw != null && (periodValueParsed = Integer.valueOf(Integer.parseInt(periodValueRaw))) <= 0) {
                    this.sendError(pd, "Frequenza, accetta solo valori > 0");
                }
            }
            catch (NullPointerException | NumberFormatException e) {
                this.sendError(pd, "Frequenza, accetta solo valore interi");
            }
            String statLifetimeRaw = ConnettoreStatusParams.getParameter(helper, map, "statLifetime");
            statLifetimeParsed = null;
            try {
                if (statLifetimeRaw != null && !statLifetimeRaw.equals("") && (statLifetimeParsed = Integer.valueOf(Integer.parseInt(statLifetimeRaw))) <= 0) {
                    this.sendError(pd, "Cache Life Time (Secondi), accetta solo valori > 0");
                }
            }
            catch (NullPointerException | NumberFormatException e) {
                this.sendError(pd, "Cache Life Time (Secondi), accetta solo valore interi");
            }
        }
        this.statusResponseType(type).testConnectivity(testConnectivityRaw == null ? null : Boolean.valueOf(ServletUtils.isCheckBoxEnabled((String)testConnectivityRaw))).period(periodRaw).periodValue(periodValueParsed).statLifetime(statLifetimeParsed).testStatistics(testStatisticsRaw == null ? null : Boolean.valueOf(ServletUtils.isCheckBoxEnabled((String)testStatisticsRaw)));
    }

    public void updateFromDB(Map<String, String> map) {
        String statLifetimeRaw;
        String periodValueRaw;
        String periodRaw;
        String connectivity;
        if (map == null) {
            return;
        }
        String type = map.get("statusResponseType");
        if (type != null && this.getStatusResponseType() == null) {
            this.statusResponseType(map.get("statusResponseType"));
        }
        if ((connectivity = map.get("testConnectivity")) != null && this.isTestConnectivity() == null) {
            this.testConnectivity(Boolean.valueOf(connectivity));
        }
        if ((periodRaw = map.get("period")) != null && this.getPeriod() == null) {
            this.period(periodRaw);
        }
        if ((periodValueRaw = map.get("periodValue")) != null && this.getPeriodValue() == null) {
            this.periodValue(Integer.valueOf(periodValueRaw));
        }
        if ((statLifetimeRaw = map.get("statLifetime")) != null && this.getStatLifetime() == null) {
            this.statLifetime(Integer.valueOf(statLifetimeRaw));
        }
        if (this.isTestStatistics() == null) {
            this.testStatistics(periodRaw != null);
        }
    }

    protected void fillTo(org.openspcoop2.core.config.Connettore config, Connettore registry) {
        this.setCustom(config, registry, true);
        this.setProperty(config, registry, "statusResponseType", this.getStatusResponseType());
        this.setProperty(config, registry, "testConnectivity", Boolean.toString(Objects.requireNonNullElse(this.isTestConnectivity(), false)));
        if (this.isTestStatistics() == Boolean.TRUE) {
            this.setProperty(config, registry, "period", this.getPeriod());
            this.setProperty(config, registry, "periodValue", this.getPeriodValue().toString());
            if (this.getStatLifetime() != null) {
                this.setProperty(config, registry, "statLifetime", this.getStatLifetime().toString());
            }
        }
    }

    public List<DataElement> getDati(List<DataElement> dati, ServiceBinding serviceBinding, boolean postBackViaPost) {
        DataElement responseTypeSelect = new DataElement();
        responseTypeSelect.setType(DataElementType.SELECT);
        responseTypeSelect.setLabel("Risposta");
        responseTypeSelect.setName("statusResponseType");
        responseTypeSelect.setValues(possibleResponseTypeValues);
        responseTypeSelect.setLabels(possibleResponseTypeLabels);
        DataElementInfo dInfo = new DataElementInfo("Risposta");
        dInfo.setHeaderBody("Formato della risposta fornita dal connettore");
        dInfo.setListBody(ConnettoriCostanti.getLabelConnettoreResponseInputDataElementInfoFormati());
        responseTypeSelect.setInfo(dInfo);
        DataElement personalizedResponseSelect = new DataElement();
        personalizedResponseSelect.setValues(possiblePersonalizedResponseTypeValues);
        personalizedResponseSelect.setLabels(possiblePersonalizedResponseTypeLabels);
        personalizedResponseSelect.setSelected(possiblePersonalizedResponseTypeValues.get(0));
        personalizedResponseSelect.setValue(possiblePersonalizedResponseTypeValues.get(0));
        personalizedResponseSelect.setName("statusResponsePersonalized");
        dInfo = new DataElementInfo("Risposta");
        dInfo.setHeaderBody("Formato della risposta fornita dal connettore");
        dInfo.setListBody(ConnettoriCostanti.getLabelConnettoreResponseInputDataElementInfoFormatiCustom());
        personalizedResponseSelect.setInfo(dInfo);
        if (this.getStatusResponseType() != null && !this.getStatusResponseType().equals(CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_MODI)) {
            personalizedResponseSelect.setType(DataElementType.SELECT);
            personalizedResponseSelect.setSelected(this.getStatusResponseType());
            personalizedResponseSelect.setValue(this.getStatusResponseType());
            responseTypeSelect.setSelected(CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_PERSONALIZZATO);
        } else {
            personalizedResponseSelect.setType(DataElementType.HIDDEN);
            responseTypeSelect.setSelected(CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_MODI);
        }
        if (serviceBinding != null && serviceBinding.equals((Object)ServiceBinding.SOAP)) {
            personalizedResponseSelect.setType(DataElementType.HIDDEN);
            responseTypeSelect.setType(DataElementType.TEXT);
            responseTypeSelect.setSelected(CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_MODI);
            responseTypeSelect.setValue(CONNETTORE_RESPONSE_INPUT_DATA_ELEMENT_INFO_FORMATO_MODI);
        }
        DataElement verificheTitle = new DataElement();
        verificheTitle.setLabel("Verifiche");
        verificheTitle.setType(DataElementType.SUBTITLE);
        DataElement connectivityCheckbox = new DataElement();
        connectivityCheckbox.setLabelRight("Connettivit\u00e0");
        connectivityCheckbox.setName("testConnectivity");
        connectivityCheckbox.setType(DataElementType.CHECKBOX);
        connectivityCheckbox.setValue(Objects.requireNonNullElse(this.isTestConnectivity(), Boolean.FALSE) != false ? "yes" : "no");
        connectivityCheckbox.setSelected(Objects.requireNonNullElse(this.isTestConnectivity(), Boolean.FALSE).booleanValue());
        dInfo = new DataElementInfo("Connettivit\u00e0");
        dInfo.setBody("Attiva la verifica della connettivit\u00e0, che controlla la raggiungibilit\u00e0 di ciascun connettore HTTP(S) configurato.");
        connectivityCheckbox.setInfo(dInfo);
        DataElement statCheckbox = new DataElement();
        statCheckbox.setLabelRight("Osservazione Statistica");
        statCheckbox.setName("testStatistics");
        statCheckbox.setType(DataElementType.CHECKBOX);
        statCheckbox.setValue(this.isTestStatistics() == Boolean.TRUE ? "yes" : "no");
        statCheckbox.setSelected(this.isTestStatistics() == Boolean.TRUE);
        dInfo = new DataElementInfo("Osservazione Statistica");
        dInfo.setBody("Attiva la verifica statistica, che controlla la presenza di almeno una transazione che sia stata completata con successo, qualora ne siano presenti.");
        statCheckbox.setInfo(dInfo);
        if (postBackViaPost) {
            responseTypeSelect.setPostBack_viaPOST(true);
            statCheckbox.setPostBack_viaPOST(true);
        } else {
            responseTypeSelect.setPostBack(true);
            statCheckbox.setPostBack(true);
        }
        DataElement intervalTitle = new DataElement();
        intervalTitle.setLabel("Intervallo Osservazione");
        intervalTitle.setType(DataElementType.SUBTITLE);
        dInfo = new DataElementInfo("Intervallo Osservazione");
        dInfo.setBody("Finestra temporale entro cui effettuare la verifica statistica; saranno considerate unicamente le transazioni eseguite all'interno dell'intervallo specificato.");
        intervalTitle.setInfo(dInfo);
        DataElement periodElement = new DataElement();
        periodElement.setLabel("Frequenza");
        periodElement.setName("period");
        periodElement.setValues(possiblePeriods);
        periodElement.setValue(Objects.requireNonNullElse(this.getPeriod(), TipoPeriodoStatistico.GIORNALIERO.getValue()));
        periodElement.setSelected(this.getPeriod());
        periodElement.setType(DataElementType.SELECT);
        DataElement periodValueElement = new DataElement();
        periodValueElement.setRequired(true);
        periodValueElement.setLabel("Intervallo Osservazione");
        periodValueElement.setName("periodValue");
        periodValueElement.setType(DataElementType.NUMBER);
        periodValueElement.setValue(Objects.requireNonNullElse(this.getPeriodValue(), 1).toString());
        DataElement lifetimeElement = new DataElement();
        lifetimeElement.setType(DataElementType.TEXT_EDIT);
        lifetimeElement.setLabel("Cache Life Time (Secondi)");
        lifetimeElement.setName("statLifetime");
        lifetimeElement.setValue(this.getStatLifetime() == null ? "" : this.getStatLifetime().toString());
        dInfo = new DataElementInfo("Cache Life Time (Secondi)");
        dInfo.setBody("Valore opzionale che specifica la durata del lifetime in cache delle analisi gi\u00e0 effettuate.<BR/><BR/><b>NOTA</b>: il valore deve essere minore o uguale al valore di default della cache 'Controllo Traffico - Dati Statistici'; in caso contrario, verr\u00e0 utilizzato il valore di default.");
        lifetimeElement.setInfo(dInfo);
        if (this.isTestStatistics() != Boolean.TRUE) {
            intervalTitle.setType(DataElementType.HIDDEN);
            periodElement.setType(DataElementType.HIDDEN);
            periodValueElement.setType(DataElementType.HIDDEN);
            lifetimeElement.setType(DataElementType.HIDDEN);
        }
        dati.add(responseTypeSelect);
        dati.add(personalizedResponseSelect);
        dati.add(verificheTitle);
        dati.add(connectivityCheckbox);
        dati.add(statCheckbox);
        dati.add(intervalTitle);
        dati.add(periodElement);
        dati.add(periodValueElement);
        dati.add(lifetimeElement);
        return dati;
    }

    private static String getParameter(ConsoleHelper helper, Map<String, String> map, String key) throws DriverControlStationException {
        return helper == null ? map.get(key) : helper.getParameter(key);
    }

    public static ConnettoreStatusParams fillFrom(ConsoleHelper helper) throws DriverControlStationException {
        ConnettoreStatusParams connettoreStatusParams = new ConnettoreStatusParams();
        if (helper != null) {
            connettoreStatusParams.fillFrom(helper, null, null, null);
        }
        return connettoreStatusParams;
    }

    public static ConnettoreStatusParams check(ConsoleHelper helper, ServiceBinding serviceBinding, PageData pd) throws DriverControlStationException {
        ConnettoreStatusParams connettoreStatusParams = new ConnettoreStatusParams();
        if (helper != null) {
            connettoreStatusParams.fillFrom(helper, null, serviceBinding, pd);
        }
        return connettoreStatusParams;
    }

    public static ConnettoreStatusParams fillFrom(Map<String, String> map) throws DriverControlStationException {
        ConnettoreStatusParams connettoreStatusParams = new ConnettoreStatusParams();
        if (map != null) {
            connettoreStatusParams.fillFrom(null, map, null, null);
        }
        return connettoreStatusParams;
    }

    public static ConnettoreStatusParams check(Map<String, String> map, ServiceBinding serviceBinding, PageData pd) throws DriverControlStationException {
        ConnettoreStatusParams connettoreStatusParams = new ConnettoreStatusParams();
        if (map != null) {
            connettoreStatusParams.fillFrom(null, map, serviceBinding, pd);
        }
        return connettoreStatusParams;
    }

    private void setCustom(org.openspcoop2.core.config.Connettore config, Connettore registry, boolean value) {
        if (config != null) {
            config.setCustom(Boolean.valueOf(value));
        }
        if (registry != null) {
            registry.setCustom(Boolean.valueOf(value));
        }
    }

    private void setProperty(org.openspcoop2.core.config.Connettore config, Connettore registry, String key, String value) {
        org.openspcoop2.core.config.Property prop;
        if (config != null) {
            prop = new org.openspcoop2.core.config.Property();
            prop.setNome(key);
            prop.setValore(value);
            config.addProperty(prop);
        }
        if (registry != null) {
            prop = new Property();
            prop.setNome(key);
            prop.setValore(value);
            registry.addProperty((Property)prop);
        }
    }

    public void fillConnettoreConfig(org.openspcoop2.core.config.Connettore connettore) {
        this.fillTo(connettore, null);
    }

    public void fillConnettoreRegistry(Connettore connettore) {
        this.fillTo(null, connettore);
    }

    public void addDati(List<DataElement> dati, ServiceBinding serviceBinding, boolean postBackViaPost) {
        this.getDati(dati, serviceBinding, postBackViaPost);
    }

    public void addDatiHidden(List<DataElement> dati, ServiceBinding serviceBinding) {
        List<DataElement> newDati = this.getDati(new ArrayList<DataElement>(), serviceBinding, true);
        for (DataElement de : newDati) {
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
        }
    }

    public ConnettoreStatusParams statusResponseType(String statusResponseType) {
        this.statusResponseType = statusResponseType;
        return this;
    }

    public String getStatusResponseType() {
        return this.statusResponseType;
    }

    public ConnettoreStatusParams testConnectivity(Boolean testConnectivity) {
        this.testConnectivity = testConnectivity;
        return this;
    }

    public Boolean isTestConnectivity() {
        return this.testConnectivity;
    }

    public ConnettoreStatusParams testStatistics(Boolean testStatistics) {
        this.testStatistics = testStatistics;
        return this;
    }

    public Boolean isTestStatistics() {
        return this.testStatistics;
    }

    public ConnettoreStatusParams period(String period) {
        this.period = period;
        return this;
    }

    public String getPeriod() {
        return this.period;
    }

    public ConnettoreStatusParams periodValue(Integer periodValue) {
        this.periodValue = periodValue;
        return this;
    }

    public Integer getPeriodValue() {
        return this.periodValue;
    }

    private ConnettoreStatusParams parsingError(boolean parsingErrors) {
        this.parsingErrors = parsingErrors;
        return this;
    }

    public boolean getParsingErrors() {
        return this.parsingErrors;
    }

    public ConnettoreStatusParams statLifetime(Integer statLifetime) {
        this.statLifetime = statLifetime;
        return this;
    }

    public Integer getStatLifetime() {
        return this.statLifetime;
    }
}

