/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.GestoreConsistenzaDati;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginCore;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginSessionUtilities;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginTipologia;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class Login
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        GeneralHelper generalHelper = new GeneralHelper(session);
        PageData pd = generalHelper.initPageData();
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ControlStationCore.clearAuditManager();
            LoginHelper loginHelper = new LoginHelper(request, pd, session);
            String login = loginHelper.getParameter("login");
            if (GestoreConsistenzaDati.gestoreConsistenzaDatiInEsecuzione) {
                pd.setMessage("<b>Attenzione</b>: \u00e8 in esecuzione un controllo sulla consistenza dei dati; attendere il completamento dell'operazione", Costanti.MESSAGE_TYPE_INFO);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"login", (ForwardParams)ForwardParams.LOGIN());
            }
            if (login == null) {
                loginHelper.impostaMessaggioEsitoLoginDaSessione(true);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"login", (ForwardParams)ForwardParams.LOGIN());
            }
            boolean isOk = loginHelper.loginCheckData(LoginTipologia.WITH_PASSWORD);
            if (!isOk) {
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"login", (ForwardParams)ForwardParams.LOGIN());
            }
            session = ServletUtils.sessionFixation((Logger)ControlStationCore.getLog(), (HttpServletRequest)request, (HttpSession)session);
            isOk = loginHelper.loginScadenzaPasswordCheckData();
            if (!isOk) {
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)pd, (String)"PageData");
                return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"utentePassword", (ForwardParams)ForwardParams.CHANGE());
            }
            LoginCore loginCore = new LoginCore();
            LoginSessionUtilities.setLoginParametersSession(request, session, (ControlStationCore)loginCore, login);
            loginCore.performAuditLogin(login);
            loginHelper.makeMenu();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            loginHelper.initializeFilter(ricerca);
            Login.impostaMessaggioEsitoLogin(pd, loginCore);
            gd = generalHelper.initGeneralData(request);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"login", (ForwardParams)ForwardParams.LOGIN());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"login", (ForwardParams)ForwardParams.LOGIN());
        }
    }

    public static void impostaMessaggioEsitoLogin(PageData pd, LoginCore loginCore) {
        StringBuilder verificaConfigurazioneProtocolli = new StringBuilder();
        boolean configurazioneCorretta = loginCore.verificaConfigurazioneProtocolliRispettoSoggettiDefault(verificaConfigurazioneProtocolli);
        if (!configurazioneCorretta) {
            pd.setMessage("Login effettuato con successo<br/><br/><b>Attenzione</b>: il controllo di consistenza tra Profili di Interoperabilit\u00e0 attivati e la configurazione sul Gateway ha rilevato inconsistenze: \n" + verificaConfigurazioneProtocolli.toString(), Costanti.MESSAGE_TYPE_ERROR);
        } else if (GestoreConsistenzaDati.gestoreConsistenzaDatiEseguitoConErrore) {
            pd.setMessage("Login effettuato con successo<br/><br/><b>Attenzione</b>: il controllo sulla consistenza dei dati \u00e8 terminato con errore; esaminare i log per maggiori dettagli", Costanti.MESSAGE_TYPE_INFO);
        } else {
            pd.setMessage("Login effettuato con successo", Costanti.MESSAGE_TYPE_INFO_SINTETICO);
        }
    }
}

