/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.slf4j.Logger;

public final class PorteApplicativeAbilitazione
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(request, pd, session);
            porteApplicativeHelper.makeMenu();
            Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentPA == null) {
                parentPA = 0;
            }
            String changeAbilitato = porteApplicativeHelper.getParametroBoolean("abilita");
            String idPorta = porteApplicativeHelper.getParametroLong("id");
            String idsogg = porteApplicativeHelper.getParametroLong("idsogg");
            String idAsps = porteApplicativeHelper.getParametroLong("idAsps");
            if (idAsps == null) {
                idAsps = "";
            }
            int soggInt = Integer.parseInt(idsogg);
            String idTab = porteApplicativeHelper.getParametroInteger("idTab");
            if (!porteApplicativeHelper.isModalitaCompleta() && StringUtils.isNotEmpty((CharSequence)idTab)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)idTab, (String)"idTab");
            }
            String fromAPIPageInfo = porteApplicativeHelper.getParametroBoolean("fromApiPageInfo");
            boolean fromApi = "true".equalsIgnoreCase(fromAPIPageInfo);
            String actionConferma = porteApplicativeHelper.getParameter("actionConfirm");
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore();
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(porteApplicativeCore);
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(porteApplicativeCore);
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(Integer.parseInt(idPorta));
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idAsps));
            AccordoServizioParteComuneSintetico aspc = apcCore.getAccordoServizioSintetico(IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
            ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(aspc.getServiceBinding());
            if (actionConferma == null) {
                String messaggio = porteApplicativeHelper.getMessaggioConfermaModificaRegolaMappingErogazionePortaApplicativa(fromApi, pa, serviceBinding, ServletUtils.isCheckBoxEnabled((String)changeAbilitato), true, true);
                pd.setMessage(messaggio, MessageType.CONFIRM);
                String[][] bottoni = new String[][]{{"Annulla", "AnnullaConferma()"}, {"Conferma", "EseguiConferma()"}};
                pd.setBottoni(bottoni);
            }
            if (actionConferma != null && actionConferma.equals("ok")) {
                pa = porteApplicativeCore.getPortaApplicativa(Integer.parseInt(idPorta));
                IDPortaApplicativa oldIDPortaApplicativaForUpdate = new IDPortaApplicativa();
                oldIDPortaApplicativaForUpdate.setNome(pa.getNome());
                pa.setOldIDPortaApplicativaForUpdate(oldIDPortaApplicativaForUpdate);
                if (ServletUtils.isCheckBoxEnabled((String)changeAbilitato)) {
                    pa.setStato(StatoFunzionalita.ABILITATO);
                } else {
                    pa.setStato(StatoFunzionalita.DISABILITATO);
                }
                String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
                porteApplicativeCore.performUpdateOperation(userLogin, porteApplicativeHelper.smista(), pa);
                List<String> aliasJmx = porteApplicativeCore.getJmxPdDAliases();
                if (aliasJmx != null && !aliasJmx.isEmpty()) {
                    for (String alias : aliasJmx) {
                        String metodo = StatoFunzionalita.ABILITATO.equals((Object)pa.getStato()) ? porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoEnablePortaApplicativa(alias) : porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoDisablePortaApplicativa(alias);
                        try {
                            String stato = porteApplicativeCore.getInvoker().invokeJMXMethod(alias, porteApplicativeCore.getJmxPdDConfigurazioneSistemaType(alias), porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), metodo, pa.getNome());
                            if (stato == null) {
                                throw new ServletException("Aggiornamento fallito");
                            }
                            if ("Operazione effettuata con successo".equals(stato) || stato != null && stato.startsWith("Operazione effettuata con successo; ")) continue;
                            throw new ServletException(stato);
                        }
                        catch (Exception e) {
                            String msgErrore = "Errore durante l'aggiornamento dello stato della PortaApplicativa '" + pa.getNome() + "' via jmx (jmxMethod '" + metodo + "') (node:" + alias + "): " + e.getMessage();
                            ControlStationCore.logError(msgErrore, e);
                        }
                    }
                }
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<PortaApplicativa> lista = null;
            int idLista = -1;
            switch (parentPA) {
                case 2: {
                    if (fromApi) {
                        ErogazioniHelper apsHelper = new ErogazioniHelper(request, pd, session);
                        apsHelper.prepareErogazioneChange(TipoOperazione.CHANGE, asps, null);
                        break;
                    }
                    boolean datiInvocazione = ServletUtils.isCheckBoxEnabled((String)porteApplicativeHelper.getParametroBoolean("configurazioneDatiInvocazione"));
                    if (datiInvocazione) {
                        idLista = Liste.SERVIZI;
                        ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
                        boolean[] permessi = new boolean[2];
                        PermessiUtente pu = ServletUtils.getUserFromSession((HttpServletRequest)request, (HttpSession)session).getPermessi();
                        permessi[0] = pu.isServizi();
                        permessi[1] = pu.isAccordiCooperazione();
                        List<AccordoServizioParteSpecifica> listaS = null;
                        String superUser = ServletUtils.getUserLoginFromSession((HttpSession)session);
                        listaS = apsCore.isVisioneOggettiGlobale(superUser) ? apsCore.soggettiServizioList(null, (ISearch)ricerca, permessi, session, request) : apsCore.soggettiServizioList(superUser, (ISearch)ricerca, permessi, session, request);
                        AccordiServizioParteSpecificaHelper apsHelper = new AccordiServizioParteSpecificaHelper(request, pd, session);
                        apsHelper.prepareServiziList((ISearch)ricerca, listaS);
                        break;
                    }
                    idLista = Liste.CONFIGURAZIONE_EROGAZIONE;
                    ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
                    IDServizio idServizio2 = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
                    Long idSoggetto = asps.getIdSoggetto() != null ? asps.getIdSoggetto() : -1L;
                    List<MappingErogazionePortaApplicativa> lista2 = apsCore.mappingServiziPorteAppList(idServizio2, asps.getId(), (ISearch)ricerca);
                    AccordiServizioParteSpecificaHelper apsHelper = new AccordiServizioParteSpecificaHelper(request, pd, session);
                    apsHelper.prepareServiziConfigurazioneList(lista2, idAsps, "" + idSoggetto, (ISearch)ricerca);
                    break;
                }
                case 1: {
                    idLista = Liste.PORTE_APPLICATIVE_BY_SOGGETTO;
                    ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
                    lista = porteApplicativeCore.porteAppList(soggInt, (ISearch)ricerca);
                    porteApplicativeHelper.preparePorteAppList((ISearch)ricerca, lista, idLista);
                    break;
                }
                default: {
                    idLista = Liste.PORTE_APPLICATIVE;
                    ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
                    lista = porteApplicativeCore.porteAppList(null, (ISearch)ricerca);
                    porteApplicativeHelper.preparePorteAppList((ISearch)ricerca, lista, idLista);
                }
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            ForwardParams fwP = porteApplicativeHelper.isModalitaCompleta() ? ForwardParams.OTHER((String)"") : PorteApplicativeCostanti.TIPO_OPERAZIONE_CONFIGURAZIONE;
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"porteApplicativeAbilitazione", (ForwardParams)fwP);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteApplicativeAbilitazione", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }
}

