/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class PorteApplicativeGestioneCanale
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TipoOperazione tipoOperazione = TipoOperazione.OTHER;
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(request, pd, session);
            porteApplicativeHelper.makeMenu();
            Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentPA == null) {
                parentPA = 0;
            }
            String id = porteApplicativeHelper.getParametroLong("id");
            int idInt = Integer.parseInt(id);
            String idsogg = porteApplicativeHelper.getParametroLong("idsogg");
            String idAsps = porteApplicativeHelper.getParametroLong("idAsps");
            if (idAsps == null) {
                idAsps = "";
            }
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore();
            ConfigurazioneCore confCore = new ConfigurazioneCore(porteApplicativeCore);
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(porteApplicativeCore);
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(porteApplicativeCore);
            long idServizio = Integer.parseInt(idAsps);
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idServizio);
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            AccordoServizioParteComuneSintetico as = apcCore.getAccordoServizioSintetico(idAccordo);
            String canale = porteApplicativeHelper.getParameter("canale");
            String canaleStato = porteApplicativeHelper.getParameter("canaleStato");
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(idInt);
            String idporta = pa.getNome();
            CanaliConfigurazione gestioneCanali = confCore.getCanaliConfigurazione(false);
            List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
            boolean gestioneCanaliEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            List<Parameter> lstParam = porteApplicativeHelper.getTitoloPA(parentPA, idsogg, idAsps);
            Object labelPerPorta = null;
            if (parentPA != null && parentPA == 2) {
                lstParam.remove(lstParam.size() - 1);
                labelPerPorta = porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Canale di ", "Canale", pa);
            } else {
                labelPerPorta = "Canale di " + idporta;
            }
            if (((String)labelPerPorta).contains(" del gruppo ")) {
                labelPerPorta = ((String)labelPerPorta).substring(0, ((String)labelPerPorta).indexOf(" del gruppo "));
            }
            lstParam.add(new Parameter((String)labelPerPorta, null));
            if (porteApplicativeHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                if (canale == null) {
                    canale = pa.getCanale();
                }
                if (canaleStato == null) {
                    canaleStato = canale == null ? "default" : "ridefinito";
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                porteApplicativeHelper.addCanaleToDati(dati, tipoOperazione, canaleStato, canale, as.getCanale(), canaleList, gestioneCanaliEnabled);
                dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, id, idsogg, null, idAsps, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"porteApplicativeGestioneCanale", (ForwardParams)ForwardParams.OTHER((String)""));
            }
            boolean isOk = porteApplicativeHelper.canaleCheckData(canaleStato, canale, gestioneCanaliEnabled);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                porteApplicativeHelper.addCanaleToDati(dati, TipoOperazione.OTHER, canaleStato, canale, as.getCanale(), canaleList, gestioneCanaliEnabled);
                dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, id, idsogg, null, idAsps, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"porteApplicativeGestioneCanale", (ForwardParams)ForwardParams.OTHER((String)""));
            }
            if ("ridefinito".equals(canaleStato)) {
                pa.setCanale(canale);
            } else {
                pa.setCanale(null);
            }
            porteApplicativeCore.performUpdateOperation(userLogin, porteApplicativeHelper.smista(), pa);
            ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.SERVIZI);
            pd.setMessage("Configurazione Canale modificata con successo", Costanti.MESSAGE_TYPE_INFO);
            pa = porteApplicativeCore.getPortaApplicativa(idInt);
            idporta = pa.getNome();
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            canale = pa.getCanale();
            canaleStato = canale == null ? "default" : "ridefinito";
            porteApplicativeHelper.addCanaleToDati(dati, TipoOperazione.OTHER, canaleStato, canale, as.getCanale(), canaleList, gestioneCanaliEnabled);
            dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, id, idsogg, null, idAsps, dati);
            pd.setDati(dati);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"porteApplicativeGestioneCanale", (ForwardParams)ForwardParams.OTHER((String)""));
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteApplicativeGestioneCanale", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }
}

