/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlow;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class PorteApplicativeMTOM
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)session);
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(request, pd, session);
            porteApplicativeHelper.makeMenu();
            Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentPA == null) {
                parentPA = 0;
            }
            String id = porteApplicativeHelper.getParametroLong("id");
            int idInt = Integer.parseInt(id);
            String idsogg = porteApplicativeHelper.getParametroLong("idsogg");
            String idAsps = porteApplicativeHelper.getParametroLong("idAsps");
            if (idAsps == null) {
                idAsps = "";
            }
            String mtomRichiesta = porteApplicativeHelper.getParameter("mtomReq");
            String mtomRisposta = porteApplicativeHelper.getParameter("mtomRes");
            String applicaModificaS = porteApplicativeHelper.getParametroBoolean("applicaMod");
            boolean applicaModifica = ServletUtils.isCheckBoxEnabled((String)applicaModificaS);
            String idTab = porteApplicativeHelper.getParametroInteger("idTab");
            if (!porteApplicativeHelper.isModalitaCompleta() && StringUtils.isNotEmpty((CharSequence)idTab)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)idTab, (String)"idTab");
            }
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore();
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(idInt);
            String idporta = pa.getNome();
            boolean visualizzazioneCompletaMTOM = porteApplicativeCore.isShowMTOMVisualizzazioneCompleta();
            String[] modeMtomListRichiesta = null;
            String[] modeMtomListRisposta = null;
            if (visualizzazioneCompletaMTOM) {
                modeMtomListRichiesta = new String[]{MTOMProcessorType.DISABLE.getValue(), MTOMProcessorType.PACKAGING.getValue(), MTOMProcessorType.UNPACKAGING.getValue(), MTOMProcessorType.VERIFY.getValue()};
                modeMtomListRisposta = new String[]{MTOMProcessorType.DISABLE.getValue(), MTOMProcessorType.PACKAGING.getValue(), MTOMProcessorType.UNPACKAGING.getValue(), MTOMProcessorType.VERIFY.getValue()};
            } else {
                modeMtomListRichiesta = new String[]{MTOMProcessorType.DISABLE.getValue(), MTOMProcessorType.UNPACKAGING.getValue(), MTOMProcessorType.VERIFY.getValue()};
                modeMtomListRisposta = new String[]{MTOMProcessorType.DISABLE.getValue(), MTOMProcessorType.PACKAGING.getValue(), MTOMProcessorType.VERIFY.getValue()};
            }
            int numMTOMreq = 0;
            int numMTOMres = 0;
            boolean isMTOMAbilitatoReq = false;
            boolean isMTOMAbilitatoRes = false;
            MTOMProcessorType mtomReqTmp = null;
            MTOMProcessorType mtomResTmp = null;
            if (pa.getMtomProcessor() != null) {
                if (pa.getMtomProcessor().getRequestFlow() != null) {
                    numMTOMreq = pa.getMtomProcessor().getRequestFlow().sizeParameterList();
                    mtomReqTmp = pa.getMtomProcessor().getRequestFlow().getMode();
                }
                if (pa.getMtomProcessor().getResponseFlow() != null) {
                    numMTOMres = pa.getMtomProcessor().getResponseFlow().sizeParameterList();
                    mtomResTmp = pa.getMtomProcessor().getResponseFlow().getMode();
                }
            }
            if (mtomRichiesta == null) {
                mtomRichiesta = mtomReqTmp == null ? MTOMProcessorType.DISABLE.getValue() : mtomReqTmp.getValue();
            }
            if (mtomRisposta == null) {
                mtomRisposta = mtomResTmp == null ? MTOMProcessorType.DISABLE.getValue() : mtomResTmp.getValue();
            }
            if (!mtomRichiesta.equals(MTOMProcessorType.DISABLE.getValue()) && !mtomRichiesta.equals(MTOMProcessorType.UNPACKAGING.getValue())) {
                isMTOMAbilitatoReq = true;
            }
            if (!mtomRisposta.equals(MTOMProcessorType.DISABLE.getValue()) && !mtomRisposta.equals(MTOMProcessorType.UNPACKAGING.getValue())) {
                isMTOMAbilitatoRes = true;
            }
            List<Parameter> lstParam = porteApplicativeHelper.getTitoloPA(parentPA, idsogg, idAsps);
            Object labelPerPorta = null;
            labelPerPorta = parentPA != null && parentPA == 2 ? porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Configurazione MTOM di ", "MTOM", pa) : "Configurazione MTOM di " + idporta;
            lstParam.add(new Parameter((String)labelPerPorta, null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            porteApplicativeHelper.impostaComandiMenuContestualePA(idsogg, idAsps);
            Parameter[] urlParms = new Parameter[]{new Parameter("id", id), new Parameter("idsogg", idsogg), new Parameter("idAsps", idAsps)};
            Parameter url1 = new Parameter("", "porteApplicativeMTOMRequestList.do", urlParms);
            Parameter url2 = new Parameter("", "porteApplicativeMTOMResponseList.do", urlParms);
            if (porteApplicativeHelper.isEditModeInProgress() && !applicaModifica) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = porteApplicativeHelper.addMTOMToDati(dati, modeMtomListRichiesta, modeMtomListRisposta, mtomRichiesta, mtomRisposta, isMTOMAbilitatoReq ? url1.getValue() : null, isMTOMAbilitatoRes ? url2.getValue() : null, contaListe, numMTOMreq, numMTOMres);
                dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, id, idsogg, null, idAsps, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"porteApplicativeMTOM", (ForwardParams)ForwardParams.OTHER((String)""));
            }
            boolean isOk = porteApplicativeHelper.MTOMCheckData(TipoOperazione.OTHER);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = porteApplicativeHelper.addMTOMToDati(dati, modeMtomListRichiesta, modeMtomListRisposta, mtomRichiesta, mtomRisposta, isMTOMAbilitatoReq ? url1.getValue() : null, isMTOMAbilitatoRes ? url2.getValue() : null, contaListe, numMTOMreq, numMTOMres);
                dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, id, idsogg, null, idAsps, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"porteApplicativeMTOM", (ForwardParams)ForwardParams.OTHER((String)""));
            }
            MTOMProcessorType nuovoValoreRichiesta = MTOMProcessorType.toEnumConstant((String)mtomRichiesta);
            MTOMProcessorType nuovoValoreRisposta = MTOMProcessorType.toEnumConstant((String)mtomRisposta);
            if (pa.getMtomProcessor() == null) {
                MtomProcessor mtomProcessor = new MtomProcessor();
                pa.setMtomProcessor(mtomProcessor);
            }
            if (pa.getMtomProcessor().getRequestFlow() == null) {
                MtomProcessorFlow requestFlow = new MtomProcessorFlow();
                pa.getMtomProcessor().setRequestFlow(requestFlow);
            }
            if (pa.getMtomProcessor().getResponseFlow() == null) {
                MtomProcessorFlow responseFlow = new MtomProcessorFlow();
                pa.getMtomProcessor().setResponseFlow(responseFlow);
            }
            pa.getMtomProcessor().getRequestFlow().setMode(nuovoValoreRichiesta);
            pa.getMtomProcessor().getResponseFlow().setMode(nuovoValoreRisposta);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            porteApplicativeCore.performUpdateOperation(userLogin, porteApplicativeHelper.smista(), pa);
            List<DataElement> dati = new ArrayList<DataElement>();
            pa = porteApplicativeCore.getPortaApplicativa(idInt);
            numMTOMreq = 0;
            numMTOMres = 0;
            isMTOMAbilitatoReq = false;
            isMTOMAbilitatoRes = false;
            if (pa.getMtomProcessor() != null) {
                if (pa.getMtomProcessor().getRequestFlow() != null) {
                    numMTOMreq = pa.getMtomProcessor().getRequestFlow().sizeParameterList();
                    mtomReqTmp = pa.getMtomProcessor().getRequestFlow().getMode();
                }
                if (pa.getMtomProcessor().getResponseFlow() != null) {
                    numMTOMres = pa.getMtomProcessor().getResponseFlow().sizeParameterList();
                    mtomResTmp = pa.getMtomProcessor().getResponseFlow().getMode();
                }
            }
            mtomRichiesta = mtomReqTmp == null ? MTOMProcessorType.DISABLE.getValue() : mtomReqTmp.getValue();
            mtomRisposta = mtomResTmp == null ? MTOMProcessorType.DISABLE.getValue() : mtomResTmp.getValue();
            if (!mtomRichiesta.equals(MTOMProcessorType.DISABLE.getValue()) && !mtomRichiesta.equals(MTOMProcessorType.UNPACKAGING.getValue())) {
                isMTOMAbilitatoReq = true;
            }
            if (!mtomRisposta.equals(MTOMProcessorType.DISABLE.getValue()) && !mtomRisposta.equals(MTOMProcessorType.UNPACKAGING.getValue())) {
                isMTOMAbilitatoRes = true;
            }
            dati = porteApplicativeHelper.addMTOMToDati(dati, modeMtomListRichiesta, modeMtomListRisposta, mtomRichiesta, mtomRisposta, isMTOMAbilitatoReq ? url1.getValue() : null, isMTOMAbilitatoRes ? url2.getValue() : null, contaListe, numMTOMreq, numMTOMres);
            dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, id, idsogg, null, idAsps, dati);
            pd.setDati(dati);
            pd.setMessage("Aggiornamento effettuato con successo", Costanti.MESSAGE_TYPE_INFO);
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"porteApplicativeMTOM", (ForwardParams)ForwardParams.OTHER((String)""));
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteApplicativeMTOM", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }
}

