/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class PorteApplicativeRuoliAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            String tokenList;
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(request, pd, session);
            porteApplicativeHelper.makeMenu();
            Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentPA == null) {
                parentPA = 0;
            }
            String idPorta = porteApplicativeHelper.getParametroLong("id");
            int idInt = Integer.parseInt(idPorta);
            String idsogg = porteApplicativeHelper.getParametroLong("idsogg");
            String idAsps = porteApplicativeHelper.getParametroLong("idAsps");
            if (idAsps == null) {
                idAsps = "";
            }
            String nome = porteApplicativeHelper.getParameter("ruolo");
            String autorizzazioneModi = porteApplicativeHelper.getParametroBoolean("autorizzazioneModIPA");
            boolean isAutorizzazioneModi = false;
            if (autorizzazioneModi != null && "true".equalsIgnoreCase(autorizzazioneModi)) {
                isAutorizzazioneModi = true;
            }
            boolean isToken = (tokenList = porteApplicativeHelper.getParametroBoolean("tokenAuthz")) != null && !"".equals(tokenList) && Boolean.valueOf(tokenList) != false;
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore();
            SoggettiCore soggettiCore = new SoggettiCore(porteApplicativeCore);
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(idInt);
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(pa.getTipoSoggettoProprietario());
            boolean modi = porteApplicativeCore.isProfiloModIPA(protocollo);
            String nomePorta = pa.getNome();
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.PORTA_APPLICATIVA);
            filtroRuoli.setTipologia(RuoloTipologia.QUALSIASI);
            if (isToken) {
                if (pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getTipologiaRuoli() != null) {
                    RuoloTipologia r = RuoloTipologia.toEnumConstant((String)pa.getAutorizzazioneToken().getTipologiaRuoli().getValue());
                    filtroRuoli.setTipologia(r);
                }
            } else if (TipoAutorizzazione.isInternalRolesRequired((String)pa.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            } else if (TipoAutorizzazione.isExternalRolesRequired((String)pa.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.ESTERNO);
            }
            ArrayList<String> ruoli = new ArrayList<String>();
            if (isToken) {
                if (pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getRuoli() != null && pa.getAutorizzazioneToken().getRuoli().getRuoloList() != null && pa.getAutorizzazioneToken().getRuoli().getRuoloList().size() > 0) {
                    for (Ruolo ruolo : pa.getAutorizzazioneToken().getRuoli().getRuoloList()) {
                        ruoli.add(ruolo.getNome());
                    }
                }
            } else if (pa.getRuoli() != null && pa.getRuoli().getRuoloList() != null && !pa.getRuoli().getRuoloList().isEmpty()) {
                for (Ruolo ruolo : pa.getRuoli().getRuoloList()) {
                    ruoli.add(ruolo.getNome());
                }
            }
            List<Parameter> lstParam = porteApplicativeHelper.getTitoloPA(parentPA, idsogg, idAsps);
            Object labelPerPorta = null;
            labelPerPorta = parentPA != null && parentPA == 2 ? porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Controllo Accessi di ", "Controllo Accessi", pa) : "Controllo Accessi di " + nomePorta;
            lstParam.add(new Parameter((String)labelPerPorta, "porteApplicativeControlloAccessi.do", new Parameter[]{new Parameter("id", idPorta), new Parameter("idsogg", idsogg), new Parameter("idAsps", idAsps)}));
            Object labelPagLista = isToken ? (isAutorizzazioneModi || modi ? "Autorizzazione Messaggio" : "Autorizzazione Token") : (modi ? "Autorizzazione Canale" : "Autorizzazione Trasporto");
            labelPagLista = (String)labelPagLista + " - Ruoli";
            lstParam.add(new Parameter((String)labelPagLista, "porteApplicativeRuoliList.do", new Parameter[]{new Parameter("id", idPorta), new Parameter("idsogg", idsogg), new Parameter("idAsps", idAsps), new Parameter("tokenAuthz", "" + isToken), new Parameter("autorizzazioneModIPA", "" + isAutorizzazioneModi)}));
            lstParam.add(ServletUtils.getParameterAggiungi());
            if (porteApplicativeHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = porteApplicativeHelper.addRuoliToDati(TipoOperazione.ADD, dati, false, filtroRuoli, nome, ruoli, false, true, true, null, isToken);
                dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.ADD, idPorta, idsogg, idPorta, idAsps, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"porteApplicativeRuoli", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = porteApplicativeHelper.ruoloCheckData(TipoOperazione.ADD, nome, ruoli);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = porteApplicativeHelper.addRuoliToDati(TipoOperazione.ADD, dati, false, filtroRuoli, nome, ruoli, false, true, true, null, isToken);
                dati = porteApplicativeHelper.addHiddenFieldsToDati(TipoOperazione.ADD, idPorta, idsogg, idPorta, idAsps, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"porteApplicativeRuoli", (ForwardParams)ForwardParams.ADD());
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(nome);
            if (isToken) {
                if (pa.getAutorizzazioneToken().getRuoli() == null) {
                    pa.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
                }
                pa.getAutorizzazioneToken().getRuoli().addRuolo(ruolo);
            } else {
                if (pa.getRuoli() == null) {
                    pa.setRuoli(new AutorizzazioneRuoli());
                }
                pa.getRuoli().addRuolo(ruolo);
            }
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            porteApplicativeCore.performUpdateOperation(userLogin, porteApplicativeHelper.smista(), pa);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.PORTE_APPLICATIVE_RUOLI;
            if (isToken) {
                idLista = Liste.PORTE_APPLICATIVE_TOKEN_RUOLI;
            }
            ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
            List<String> lista = isToken ? porteApplicativeCore.portaApplicativaRuoliTokenList(idInt, (ISearch)ricerca) : porteApplicativeCore.portaApplicativaRuoliList(idInt, (ISearch)ricerca);
            porteApplicativeHelper.preparePorteApplicativeRuoliList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"porteApplicativeRuoli", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteApplicativeRuoli", (ForwardParams)ForwardParams.ADD());
        }
    }
}

