/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaTracciamento;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletrace;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletraceConnector;
import org.openspcoop2.core.config.Transazioni;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConPersonalizzazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.protocol.utils.EsitiConfigUtils;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;

public class PorteApplicativeUtilities {
    private PorteApplicativeUtilities() {
    }

    public static void deletePortaApplicativaAzioni(PortaApplicativa pa, PorteApplicativeCore porteApplicativeCore, PorteApplicativeHelper porteApplicativeHelper, StringBuilder inUsoMessage, String newLine, List<String> azioni, String userLogin) throws Exception {
        ConfigurazioneCore confCore = new ConfigurazioneCore(porteApplicativeCore);
        StringBuilder bfTrasformazioni = new StringBuilder();
        StringBuilder bfCT = new StringBuilder();
        StringBuilder bfConnettoreMultiplo = new StringBuilder();
        block0: for (int i = 0; i < azioni.size(); ++i) {
            String azione = azioni.get(i);
            boolean usedInTrasformazioni = false;
            if (pa.getTrasformazioni() != null && pa.getTrasformazioni().sizeRegolaList() > 0) {
                for (TrasformazioneRegola trasformazioneRegola : pa.getTrasformazioni().getRegolaList()) {
                    if (trasformazioneRegola.getApplicabilita() == null || trasformazioneRegola.getApplicabilita().getAzioneList() == null || !trasformazioneRegola.getApplicabilita().getAzioneList().contains(azione)) continue;
                    usedInTrasformazioni = true;
                    break;
                }
            }
            if (confCore.usedInConfigurazioneControlloTrafficoAttivazionePolicy(RuoloPolicy.APPLICATIVA, pa.getNome(), azione)) {
                if (bfCT.length() > 0) {
                    bfCT.append(",");
                }
                bfCT.append(azione);
                continue;
            }
            if (usedInTrasformazioni) {
                if (bfTrasformazioni.length() > 0) {
                    bfTrasformazioni.append(",");
                }
                bfTrasformazioni.append(azione);
                continue;
            }
            for (int j = 0; j < pa.getAzione().sizeAzioneDelegataList(); ++j) {
                String azioneDelegata = pa.getAzione().getAzioneDelegata(j);
                if (!azione.equals(azioneDelegata)) continue;
                pa.getAzione().removeAzioneDelegata(j);
                continue block0;
            }
        }
        if (pa.getAzione().sizeAzioneDelegataList() == 0) {
            inUsoMessage.append("Non &egrave; possibile eliminare tutte le azioni associate alla configurazione");
        } else if (bfCT.length() > 0 || bfTrasformazioni.length() > 0 || bfConnettoreMultiplo.length() > 0) {
            if (bfCT.length() > 0) {
                inUsoMessage.append("Non \u00e8 stato possibile procedere con l'eliminazione poich\u00e8 risultano utilizzate in configurazione di Rate Limiting: " + bfCT.toString());
            }
            if (bfTrasformazioni.length() > 0) {
                if (inUsoMessage.length() > 0) {
                    inUsoMessage.append(newLine);
                }
                inUsoMessage.append("Non \u00e8 stato possibile procedere con l'eliminazione poich\u00e8 utilizzate in criteri di applicabilit\u00e0 di una Trasformazione: " + bfTrasformazioni.toString());
            }
            if (bfConnettoreMultiplo.length() > 0) {
                if (inUsoMessage.length() > 0) {
                    inUsoMessage.append(newLine);
                }
                inUsoMessage.append("Non \u00e8 stato possibile procedere con l'eliminazione poich\u00e8 utilizzate nei connettori multipli in consegne condizionali: " + bfConnettoreMultiplo.toString());
            }
        } else {
            porteApplicativeCore.performUpdateOperation(userLogin, porteApplicativeHelper.smista(), pa);
        }
    }

    public static void initTracciamento(PortaApplicativa pde, PorteApplicativeCore porteApplicativeCore, Configurazione config, String tracciamentoStato, String statoDiagnostici, String severita) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        PortaTracciamento portaTracciamento = pde.getTracciamento();
        if (portaTracciamento == null) {
            portaTracciamento = new PortaTracciamento();
            pde.setTracciamento(portaTracciamento);
        }
        portaTracciamento.setStato("ridefinito".equals(tracciamentoStato) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        if ("ridefinito".equals(tracciamentoStato)) {
            if (config == null) {
                config = porteApplicativeCore.getConfigurazioneGenerale();
            }
            if (config.getTracciamento() != null && config.getTracciamento().getPortaApplicativa() != null) {
                portaTracciamento.setDatabase(config.getTracciamento().getPortaApplicativa().getDatabase());
                portaTracciamento.setFiletrace(config.getTracciamento().getPortaApplicativa().getFiletrace());
                if (portaTracciamento.getFiletrace() != null && StatoFunzionalitaConPersonalizzazione.CONFIGURAZIONE_ESTERNA.equals((Object)portaTracciamento.getFiletrace().getStato())) {
                    portaTracciamento.getFiletrace().setStato(StatoFunzionalitaConPersonalizzazione.DISABILITATO);
                }
                portaTracciamento.setFiletraceConfig(config.getTracciamento().getPortaApplicativa().getFiletraceConfig());
                portaTracciamento.setEsiti(config.getTracciamento().getPortaApplicativa().getEsiti());
                portaTracciamento.setTransazioni(config.getTracciamento().getPortaApplicativa().getTransazioni());
            }
        }
        if ("ridefinito".equals(statoDiagnostici)) {
            portaTracciamento.setSeverita(Severita.toEnumConstant((String)severita));
        } else {
            portaTracciamento.setSeverita(null);
        }
    }

    public static void setTracciamentoTransazioni(PortaApplicativa pde, PorteApplicativeCore porteApplicativeCore, String dbStato, String dbStatoReqIn, String dbStatoReqOut, String dbStatoResOut, String dbStatoResOutComplete, boolean dbFiltroEsiti, String fsStato, String fsStatoReqIn, String fsStatoReqOut, String fsStatoResOut, String fsStatoResOutComplete, boolean fsFiltroEsiti, String nuovaConfigurazioneEsiti, String transazioniTempiElaborazione, String transazioniToken, String fileTraceStato, String fileTraceConfigFile, String fileTraceClient, String fileTraceClientHdr, String fileTraceClientBody, String fileTraceServer, String fileTraceServerHdr, String fileTraceServerBody) {
        PortaTracciamento portaTracciamento = pde.getTracciamento();
        if (portaTracciamento == null) {
            portaTracciamento = new PortaTracciamento();
            pde.setTracciamento(portaTracciamento);
        }
        TracciamentoConfigurazione database = porteApplicativeCore.buildTracciamentoConfigurazioneDatabase(dbStato, dbStatoReqIn, dbStatoReqOut, dbStatoResOut, dbStatoResOutComplete, dbFiltroEsiti);
        portaTracciamento.setDatabase(database);
        TracciamentoConfigurazione filetrace = porteApplicativeCore.buildTracciamentoConfigurazioneFiletrace(fsStato, fsStatoReqIn, fsStatoReqOut, fsStatoResOut, fsStatoResOutComplete, fsFiltroEsiti);
        portaTracciamento.setFiletrace(filetrace);
        if (StringUtils.isEmpty((CharSequence)nuovaConfigurazioneEsiti)) {
            portaTracciamento.setEsiti("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI);
        } else {
            portaTracciamento.setEsiti(nuovaConfigurazioneEsiti);
        }
        if (portaTracciamento.getTransazioni() == null) {
            portaTracciamento.setTransazioni(new Transazioni());
        }
        portaTracciamento.getTransazioni().setTempiElaborazione(StatoFunzionalita.toEnumConstant((String)transazioniTempiElaborazione));
        portaTracciamento.getTransazioni().setToken(StatoFunzionalita.toEnumConstant((String)transazioniToken));
        if ("ridefinito".equals(fileTraceStato)) {
            portaTracciamento.setFiletraceConfig(new TracciamentoConfigurazioneFiletrace());
            portaTracciamento.getFiletraceConfig().setConfig(fileTraceConfigFile);
            portaTracciamento.getFiletraceConfig().setDumpIn(new TracciamentoConfigurazioneFiletraceConnector());
            portaTracciamento.getFiletraceConfig().getDumpIn().setStato(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClient) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpIn().setHeader(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClientHdr) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpIn().setPayload(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClientBody) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().setDumpOut(new TracciamentoConfigurazioneFiletraceConnector());
            portaTracciamento.getFiletraceConfig().getDumpOut().setStato(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServer) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpOut().setHeader(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServerHdr) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpOut().setPayload(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServerBody) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        } else {
            portaTracciamento.setFiletraceConfig(null);
        }
    }
}

