/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.protocol_properties;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleInterfaceType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.NumberConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.SubtitleConsoleItem;
import org.openspcoop2.protocol.sdk.properties.TitleConsoleItem;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.Parameter;

public class ProtocolPropertiesUtilities {
    private ProtocolPropertiesUtilities() {
    }

    public static ConsoleInterfaceType getTipoInterfaccia(ConsoleHelper consoleHelper) {
        if (consoleHelper.isModalitaStandard()) {
            return ConsoleInterfaceType.STANDARD;
        }
        if (consoleHelper.isModalitaCompleta()) {
            return ConsoleInterfaceType.COMPLETA;
        }
        return ConsoleInterfaceType.AVANZATA;
    }

    private static String getPrefixErrorItemConClasse(AbstractConsoleItem<?> abItem) {
        return "Item con classe [" + String.valueOf(abItem.getClass()) + "] ";
    }

    private static String getPrefixErrorItemConClasse(BaseConsoleItem item) {
        return "Item con classe [" + String.valueOf(item.getClass()) + "] ";
    }

    public static List<DataElement> itemToDataElement(List<DataElement> dati, ConsoleHelper consoleHelper, BaseConsoleItem item, Object defaultItemValue, ConsoleOperationType consoleOperationType, Properties binaryChangeProperties, org.openspcoop2.core.registry.ProtocolProperty protocolProperty, int size) throws ProtocolException {
        return ProtocolPropertiesUtilities.itemToDataElementEngine(dati, consoleHelper, item, defaultItemValue, consoleOperationType, binaryChangeProperties, protocolProperty != null ? protocolProperty.getId() : null, protocolProperty != null ? protocolProperty.getFile() : null, size, protocolProperty != null && protocolProperty.getByteFile() != null);
    }

    public static List<DataElement> itemToDataElement(List<DataElement> dati, ConsoleHelper consoleHelper, BaseConsoleItem item, Object defaultItemValue, ConsoleOperationType consoleOperationType, Properties binaryChangeProperties, ProtocolProperty protocolProperty, int size) throws ProtocolException {
        return ProtocolPropertiesUtilities.itemToDataElementEngine(dati, consoleHelper, item, defaultItemValue, consoleOperationType, binaryChangeProperties, protocolProperty != null ? protocolProperty.getId() : null, protocolProperty != null ? protocolProperty.getFile() : null, size, protocolProperty != null && protocolProperty.getByteFile() != null);
    }

    private static List<DataElement> itemToDataElementEngine(List<DataElement> dati, ConsoleHelper consoleHelper, BaseConsoleItem item, Object defaultItemValue, ConsoleOperationType consoleOperationType, Properties binaryChangeProperties, Long protocolPropertyId, String protocolPropertyFile, int size, boolean contentSaved) throws ProtocolException {
        if (item == null) {
            return dati;
        }
        if (item instanceof AbstractConsoleItem) {
            AbstractConsoleItem abItem = (AbstractConsoleItem)item;
            switch (abItem.getType()) {
                case CHECKBOX: {
                    ProtocolPropertiesUtilities.getCheckbox(dati, abItem, defaultItemValue, size);
                    break;
                }
                case LOCK: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.LOCK);
                    break;
                }
                case LOCK_HIDDEN: {
                    ProtocolPropertiesUtilities.getHidden(dati, consoleHelper, abItem, size);
                    break;
                }
                case CRYPT: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.CRYPT);
                    break;
                }
                case FILE: {
                    ProtocolPropertiesUtilities.getFile(dati, consoleHelper, abItem, size, consoleOperationType, binaryChangeProperties, protocolPropertyId, protocolPropertyFile, contentSaved);
                    break;
                }
                case HIDDEN: {
                    ProtocolPropertiesUtilities.getHidden(dati, consoleHelper, abItem, size);
                    break;
                }
                case SELECT: {
                    ProtocolPropertiesUtilities.getSelect(dati, abItem, defaultItemValue, size);
                    break;
                }
                case MULTI_SELECT: {
                    ProtocolPropertiesUtilities.getMultiSelect(dati, abItem, defaultItemValue, size);
                    break;
                }
                case TEXT: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.TEXT);
                    break;
                }
                case TEXT_AREA: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.TEXT_AREA);
                    break;
                }
                case TEXT_AREA_NO_EDIT: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.TEXT_AREA_NO_EDIT);
                    break;
                }
                case TEXT_EDIT: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.TEXT_EDIT);
                    break;
                }
                case TAGS: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.TEXT_EDIT);
                    dati.get(dati.size() - 1).enableTags();
                    break;
                }
                case NUMBER: {
                    ProtocolPropertiesUtilities.getText(dati, consoleHelper, abItem, size, DataElementType.NUMBER);
                    break;
                }
                default: {
                    throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixErrorItemConClasse(abItem) + "identificato come tipo AbstractConsoleItem ma con Type: [" + String.valueOf(abItem.getType()) + "] di tipo titolo o note");
                }
            }
        } else {
            switch (item.getType()) {
                case NOTE: {
                    ProtocolPropertiesUtilities.getTitle(dati, item, size, DataElementType.NOTE);
                    break;
                }
                case SUBTITLE: {
                    ProtocolPropertiesUtilities.getTitle(dati, item, size, DataElementType.SUBTITLE);
                    break;
                }
                case TITLE: {
                    ProtocolPropertiesUtilities.getTitle(dati, item, size, DataElementType.TITLE);
                    break;
                }
                case HIDDEN: {
                    ProtocolPropertiesUtilities.getHidden(dati, consoleHelper, item, size);
                    break;
                }
                default: {
                    throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixErrorItemConClasse(item) + "non identificato come tipo AbstractConsoleItem ma con Type: [" + String.valueOf(item.getType()) + "] non di tipo titolo o note");
                }
            }
        }
        return dati;
    }

    public static List<DataElement> itemToDataElementAsHidden(List<DataElement> dati, ConsoleHelper consoleHelper, BaseConsoleItem item, Object defaultItemValue, ConsoleOperationType consoleOperationType, Properties binaryChangeProperties, org.openspcoop2.core.registry.ProtocolProperty protocolProperty, int size) throws ProtocolException {
        if (defaultItemValue != null || consoleOperationType != null || binaryChangeProperties != null || protocolProperty != null) {
            // empty if block
        }
        if (item == null) {
            return dati;
        }
        if (item instanceof AbstractConsoleItem) {
            AbstractConsoleItem abItem = (AbstractConsoleItem)item;
            switch (abItem.getType()) {
                case CHECKBOX: 
                case LOCK: 
                case LOCK_HIDDEN: 
                case CRYPT: 
                case FILE: 
                case HIDDEN: 
                case SELECT: 
                case MULTI_SELECT: 
                case TEXT: 
                case TEXT_AREA: 
                case TEXT_AREA_NO_EDIT: 
                case TEXT_EDIT: 
                case TAGS: 
                case NUMBER: {
                    ProtocolPropertiesUtilities.getHidden(dati, consoleHelper, abItem, size);
                    break;
                }
                default: {
                    throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixErrorItemConClasse(abItem) + "identificato come tipo AbstractConsoleItem ma con Type: [" + String.valueOf(abItem.getType()) + "] di tipo titolo o note");
                }
            }
        } else {
            switch (item.getType()) {
                case HIDDEN: 
                case NOTE: 
                case SUBTITLE: 
                case TITLE: {
                    break;
                }
                default: {
                    throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixErrorItemConClasse(item) + "non identificato come tipo AbstractConsoleItem ma con Type: [" + String.valueOf(item.getType()) + "] non di tipo titolo o note");
                }
            }
        }
        return dati;
    }

    public static List<DataElement> getTitle(List<DataElement> dati, BaseConsoleItem item, int size, DataElementType type) {
        SubtitleConsoleItem subItem;
        DataElement de = new DataElement();
        de.setName(item.getId());
        de.setType(type);
        de.setLabel(item.getLabel());
        de.setSize(size);
        de.setValue("");
        if (ConsoleItemType.TITLE.equals((Object)item.getType()) && item instanceof TitleConsoleItem) {
            TitleConsoleItem titleItem = (TitleConsoleItem)item;
            if (titleItem.isCloseable()) {
                de.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
            }
        } else if (ConsoleItemType.SUBTITLE.equals((Object)item.getType()) && item instanceof SubtitleConsoleItem && (subItem = (SubtitleConsoleItem)item).isCloseable()) {
            de.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
        }
        dati.add(de);
        return dati;
    }

    private static String getPrefixMessageErrorConsoleItemType(ConsoleItemValueType consoleItemValueType) {
        return "Item con consoleItemType [" + String.valueOf(consoleItemValueType) + "] ";
    }

    public static List<DataElement> getText(List<DataElement> dati, ConsoleHelper consoleHelper, AbstractConsoleItem<?> item, int size, DataElementType type) throws ProtocolException {
        DataElement de = new DataElement();
        de.setName(item.getId());
        if (!DataElementType.LOCK.equals((Object)type)) {
            de.setType(type);
        }
        de.setRequired(item.isRequired());
        de.setLabel(item.getLabel());
        de.setLabelRight(item.getLabelRight());
        if (item.isReloadOnChange()) {
            if (item.isReloadOnHttpPost()) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
        }
        de.setNote(item.getNote());
        de.setSize(size);
        ProtocolPropertiesUtilities.addDataElementInfo(item, de);
        ConsoleItemValueType consoleItemValueType = ProtocolPropertiesUtils.getConsoleItemValueType(item);
        ProtocolPropertiesUtilities.setTextValue(consoleItemValueType, consoleHelper, item, de, type);
        if (item.getDefaultValueForCloseableSection() instanceof String) {
            String s = (String)item.getDefaultValueForCloseableSection();
            de.setValoreDefault(s);
        }
        dati.add(de);
        return dati;
    }

    private static void setTextValue(ConsoleItemValueType consoleItemValueType, ConsoleHelper consoleHelper, AbstractConsoleItem<?> item, DataElement de, DataElementType type) throws ProtocolException {
        String value = null;
        switch (consoleItemValueType) {
            case BOOLEAN: {
                BooleanConsoleItem booleanItem = (BooleanConsoleItem)item;
                value = booleanItem.getDefaultValue() != null ? String.valueOf(booleanItem.getDefaultValue()) : "";
                break;
            }
            case NUMBER: {
                NumberConsoleItem numberItem = (NumberConsoleItem)item;
                String string = value = numberItem.getDefaultValue() != null ? String.valueOf(numberItem.getDefaultValue()) : "";
                if (!DataElementType.NUMBER.equals((Object)type)) break;
                de.setMinValue(Integer.valueOf((int)numberItem.getMin()));
                de.setMaxValue(Integer.valueOf((int)numberItem.getMax()));
                break;
            }
            case STRING: {
                StringConsoleItem stringItem = (StringConsoleItem)item;
                String string = value = stringItem.getDefaultValue() != null ? (String)stringItem.getDefaultValue() : "";
                if (stringItem.getRows() == null) break;
                de.setRows(stringItem.getRows().intValue());
                break;
            }
            case BINARY: {
                value = "Prova Binary";
                break;
            }
            default: {
                throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixMessageErrorConsoleItemType(consoleItemValueType) + "non puo' essere visualizzato come un " + String.valueOf(type));
            }
        }
        if (DataElementType.LOCK.equals((Object)type)) {
            try {
                consoleHelper.getCore().getLockUtilities().lock(de, value);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        } else {
            de.setValue(value);
        }
    }

    public static List<DataElement> getFile(List<DataElement> dati, ConsoleHelper consoleHelper, AbstractConsoleItem<?> item, int size, ConsoleOperationType consoleOperationType, Properties binaryChangeProperties, Long protocolPropertyId, String protocolPropertyFile, boolean contentSaved) {
        if (consoleHelper != null) {
            // empty if block
        }
        DataElement de = new DataElement();
        DataElement de2 = null;
        List df = null;
        de.setName(item.getId());
        if (consoleOperationType.equals((Object)ConsoleOperationType.ADD) || !contentSaved) {
            BinaryConsoleItem binaryItem = (BinaryConsoleItem)item;
            BinaryParameter bp = new BinaryParameter();
            bp.setName(binaryItem.getId());
            bp.setFilename(binaryItem.getFileName());
            bp.setId(binaryItem.getFileId());
            de = bp.getFileDataElement(item.getLabel(), "", size);
            de.setRequired(item.isRequired());
            df = bp.getFileNameDataElement();
            de2 = bp.getFileIdDataElement();
        } else {
            de.setType(DataElementType.LINK);
            Object idItem = protocolPropertyId != null ? "" + protocolPropertyId : "";
            String idProprietario = binaryChangeProperties.getProperty("idProprietario");
            String urlChange = binaryChangeProperties.getProperty("urlOrigChange");
            String tipoProprietario = binaryChangeProperties.getProperty("tipoProprietario");
            String nomeProprietario = binaryChangeProperties.getProperty("nomeProprietario");
            String parentProprietario = binaryChangeProperties.getProperty("nomeParentProprietario");
            if (parentProprietario == null) {
                parentProprietario = "";
            }
            String protocollo = binaryChangeProperties.getProperty("protocollo");
            String tipoAccordo = binaryChangeProperties.getProperty("tipoAccordo");
            if (tipoAccordo == null) {
                tipoAccordo = "";
            }
            de.setUrl("protocolPropertyBinaryPropertyChange.do", new Parameter[]{new Parameter("id", (String)idItem), new Parameter("nome", item.getId()), new Parameter("idProprietario", idProprietario), new Parameter("tipoProprietario", tipoProprietario), new Parameter("nomeProprietario", nomeProprietario), new Parameter("nomeParentProprietario", parentProprietario), new Parameter("protocollo", protocollo), new Parameter("tipoAccordo", tipoAccordo), new Parameter("urlOrigChange", urlChange)});
            de.setValue(item.getLabel());
            if (protocolPropertyFile != null) {
                de2 = new DataElement();
                de2.setName("__fn__" + item.getId());
                de2.setValue(protocolPropertyFile);
                de2.setType(DataElementType.HIDDEN);
            }
        }
        dati.add(de);
        if (df != null) {
            dati.addAll(df);
        }
        if (de2 != null) {
            dati.add(de2);
        }
        return dati;
    }

    private static void addDataElementInfo(AbstractConsoleItem<?> item, DataElement de) {
        if (item.getInfo() != null) {
            DataElementInfo dInfo = new DataElementInfo(item.getInfo().getHeaderFinestraModale());
            dInfo.setHeaderBody(StringEscapeUtils.escapeHtml4((String)item.getInfo().getHeaderBody()));
            if (item.getInfo().getListBody() != null && !item.getInfo().getListBody().isEmpty()) {
                ArrayList<String> escapedValues = new ArrayList<String>();
                for (String v : item.getInfo().getListBody()) {
                    escapedValues.add(StringEscapeUtils.escapeHtml4((String)v));
                }
                dInfo.setListBody(escapedValues);
            }
            de.setInfo(dInfo);
        }
    }

    private static Boolean getSelectedValue(BooleanConsoleItem booleanItem, Object defaultItemValue) {
        Boolean selectedBooleanValue = null;
        selectedBooleanValue = booleanItem.getDefaultValue() != null ? (Boolean)booleanItem.getDefaultValue() : (defaultItemValue instanceof Boolean ? (Boolean)defaultItemValue : Boolean.valueOf(false));
        return selectedBooleanValue;
    }

    private static String getSelectedValue(NumberConsoleItem numberItem, Object defaultItemValue) {
        String selectedNumberValue = null;
        selectedNumberValue = numberItem.getDefaultValue() != null ? String.valueOf(numberItem.getDefaultValue()) : (defaultItemValue instanceof Long ? String.valueOf(defaultItemValue) : (defaultItemValue instanceof Integer ? String.valueOf(defaultItemValue) : null));
        return selectedNumberValue;
    }

    private static String getSelectedValue(StringConsoleItem stringItem, Object defaultItemValue) {
        String selectedStringValue = null;
        selectedStringValue = stringItem.getDefaultValue() != null ? (String)stringItem.getDefaultValue() : (defaultItemValue instanceof String ? (String)defaultItemValue : null);
        return selectedStringValue;
    }

    public static List<DataElement> getCheckbox(List<DataElement> dati, AbstractConsoleItem<?> item, Object defaultItemValue, int size) throws ProtocolException {
        DataElement de = new DataElement();
        de.setName(item.getId());
        de.setType(DataElementType.CHECKBOX);
        de.setRequired(item.isRequired());
        de.setLabel(item.getLabel());
        de.setLabelRight(item.getLabelRight());
        if (item.isReloadOnChange()) {
            if (item.isReloadOnHttpPost()) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
        }
        de.setNote(item.getNote());
        de.setSize(size);
        ProtocolPropertiesUtilities.addDataElementInfo(item, de);
        ConsoleItemValueType consoleItemValueType = ProtocolPropertiesUtils.getConsoleItemValueType(item);
        switch (consoleItemValueType) {
            case BOOLEAN: {
                BooleanConsoleItem booleanItem = (BooleanConsoleItem)item;
                Boolean selectedBooleanValue = ProtocolPropertiesUtilities.getSelectedValue(booleanItem, defaultItemValue);
                de.setSelected(selectedBooleanValue.booleanValue());
                break;
            }
            case NUMBER: {
                NumberConsoleItem numberItem = (NumberConsoleItem)item;
                String selectedNumberValue = ProtocolPropertiesUtilities.getSelectedValue(numberItem, defaultItemValue);
                de.setSelected(selectedNumberValue);
                break;
            }
            case STRING: {
                StringConsoleItem stringItem = (StringConsoleItem)item;
                String selectedStringValue = ProtocolPropertiesUtilities.getSelectedValue(stringItem, defaultItemValue);
                de.setSelected(selectedStringValue);
                break;
            }
            default: {
                throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixMessageErrorConsoleItemType(consoleItemValueType) + "non puo' essere visualizzato come una CheckBox");
            }
        }
        if (item.getDefaultValueForCloseableSection() instanceof Boolean) {
            boolean b = (Boolean)item.getDefaultValueForCloseableSection();
            de.setValoreDefaultCheckbox(b);
        }
        dati.add(de);
        return dati;
    }

    public static List<DataElement> getHidden(List<DataElement> dati, ConsoleHelper consoleHelper, AbstractConsoleItem<?> item, int size) throws ProtocolException {
        DataElement de = new DataElement();
        de.setName(item.getId());
        de.setType(DataElementType.HIDDEN);
        de.setRequired(item.isRequired());
        de.setLabel(item.getLabel());
        de.setLabelRight(item.getLabelRight());
        if (item.isReloadOnChange()) {
            if (item.isReloadOnHttpPost()) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
        }
        de.setNote(item.getNote());
        de.setSize(size);
        ConsoleItemValueType consoleItemValueType = ProtocolPropertiesUtils.getConsoleItemValueType(item);
        ProtocolPropertiesUtilities.setHiddenValue(consoleItemValueType, consoleHelper, item, de);
        dati.add(de);
        return dati;
    }

    private static void setHiddenValue(ConsoleItemValueType consoleItemValueType, ConsoleHelper consoleHelper, AbstractConsoleItem<?> item, DataElement de) throws ProtocolException {
        String value = null;
        switch (consoleItemValueType) {
            case BOOLEAN: {
                BooleanConsoleItem booleanItem = (BooleanConsoleItem)item;
                value = booleanItem.getDefaultValue() != null ? String.valueOf(booleanItem.getDefaultValue()) : "";
                break;
            }
            case NUMBER: {
                NumberConsoleItem numberItem = (NumberConsoleItem)item;
                value = numberItem.getDefaultValue() != null ? String.valueOf(numberItem.getDefaultValue()) : "";
                break;
            }
            case STRING: {
                StringConsoleItem stringItem = (StringConsoleItem)item;
                value = stringItem.getDefaultValue() != null ? (String)stringItem.getDefaultValue() : "";
                break;
            }
            case BINARY: {
                value = "";
                break;
            }
            default: {
                throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixMessageErrorConsoleItemType(consoleItemValueType) + "non puo' essere visualizzato come una Hidden");
            }
        }
        if (item.isLockedType()) {
            try {
                consoleHelper.getCore().getLockUtilities().lockHidden(de, value);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        } else {
            de.setValue(value);
        }
    }

    public static List<DataElement> getHidden(List<DataElement> dati, ConsoleHelper consoleHelper, BaseConsoleItem item, int size) {
        DataElement de = new DataElement();
        de.setName(item.getId());
        de.setType(DataElementType.HIDDEN);
        de.setLabel(item.getLabel());
        de.setSize(size);
        dati.add(de);
        return dati;
    }

    public static List<DataElement> getSelect(List<DataElement> dati, AbstractConsoleItem<?> item, Object defaultItemValue, int size) throws ProtocolException {
        DataElement de = new DataElement();
        de.setName(item.getId());
        de.setType(DataElementType.SELECT);
        de.setRequired(item.isRequired());
        de.setLabel(item.getLabel());
        de.setLabelRight(item.getLabelRight());
        if (item.isReloadOnChange()) {
            if (item.isReloadOnHttpPost()) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
        }
        de.setNote(item.getNote());
        de.setSize(size);
        ProtocolPropertiesUtilities.addDataElementInfo(item, de);
        ConsoleItemValueType consoleItemValueType = ProtocolPropertiesUtils.getConsoleItemValueType(item);
        ArrayList<CallSite> values = new ArrayList<CallSite>();
        ArrayList<String> labels = new ArrayList<String>();
        switch (consoleItemValueType) {
            case BOOLEAN: {
                BooleanConsoleItem booleanItem = (BooleanConsoleItem)item;
                Boolean selectedBooleanValue = ProtocolPropertiesUtilities.getSelectedValue(booleanItem, defaultItemValue);
                de.setSelected(selectedBooleanValue.booleanValue());
                SortedMap booleanMapLabelValues = booleanItem.getMapLabelValues();
                for (String key : booleanMapLabelValues.keys()) {
                    labels.add(key);
                    values.add((CallSite)((Object)String.valueOf(booleanMapLabelValues.get(key))));
                }
                break;
            }
            case NUMBER: {
                NumberConsoleItem numberItem = (NumberConsoleItem)item;
                String selectedNumberValue = ProtocolPropertiesUtilities.getSelectedValue(numberItem, defaultItemValue);
                de.setSelected(selectedNumberValue);
                SortedMap numberMapLabelValues = numberItem.getMapLabelValues();
                for (String key : numberMapLabelValues.keys()) {
                    labels.add(key);
                    values.add((CallSite)((Object)String.valueOf(numberMapLabelValues.get(key))));
                }
                break;
            }
            case STRING: {
                StringConsoleItem stringItem = (StringConsoleItem)item;
                String selectedStringValue = ProtocolPropertiesUtilities.getSelectedValue(stringItem, defaultItemValue);
                de.setSelected(selectedStringValue);
                SortedMap stringMapLabelValues = stringItem.getMapLabelValues();
                for (String key : stringMapLabelValues.keys()) {
                    labels.add(key);
                    values.add((CallSite)((Object)((String)stringMapLabelValues.get(key))));
                }
                break;
            }
            default: {
                throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixMessageErrorConsoleItemType(consoleItemValueType) + "non puo' essere visualizzato come una Select List");
            }
        }
        de.setValues(values);
        de.setLabels(labels);
        if (item.getDefaultValueForCloseableSection() instanceof String) {
            String s = (String)item.getDefaultValueForCloseableSection();
            de.setValoreDefaultSelect(s);
        }
        dati.add(de);
        return dati;
    }

    public static List<DataElement> getMultiSelect(List<DataElement> dati, AbstractConsoleItem<?> item, Object defaultItemValue, int size) throws ProtocolException {
        DataElement de = new DataElement();
        de.setName(item.getId());
        de.setType(DataElementType.MULTI_SELECT);
        de.setRequired(item.isRequired());
        de.setLabel(item.getLabel());
        de.setLabelRight(item.getLabelRight());
        if (item.isReloadOnChange()) {
            if (item.isReloadOnHttpPost()) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
        }
        de.setNote(item.getNote());
        de.setSize(size);
        ProtocolPropertiesUtilities.addDataElementInfo(item, de);
        ConsoleItemValueType consoleItemValueType = ProtocolPropertiesUtils.getConsoleItemValueType(item);
        ProtocolPropertiesUtilities.setValuesLabelsMultiSelect(consoleItemValueType, item, defaultItemValue, de);
        if (item.getDefaultValueForCloseableSection() instanceof String) {
            String s = (String)item.getDefaultValueForCloseableSection();
            de.setValoreDefaultMultiSelect(new String[]{s});
        }
        dati.add(de);
        return dati;
    }

    private static void setValuesLabelsMultiSelect(ConsoleItemValueType consoleItemValueType, AbstractConsoleItem<?> item, Object defaultItemValue, DataElement de) throws ProtocolException {
        ArrayList<CallSite> values = new ArrayList<CallSite>();
        ArrayList<String> labels = new ArrayList<String>();
        switch (consoleItemValueType) {
            case STRING: {
                StringConsoleItem stringItem = (StringConsoleItem)item;
                String selectedStringValue = ProtocolPropertiesUtilities.getSelectedValue(stringItem, defaultItemValue);
                if (selectedStringValue != null) {
                    if (selectedStringValue.contains(",")) {
                        de.setSelezionati(selectedStringValue.split(","));
                    } else {
                        de.setSelezionati(new String[]{selectedStringValue});
                    }
                }
                if (stringItem.getRows() != null) {
                    de.setRows(stringItem.getRows().intValue());
                }
                SortedMap stringMapLabelValues = stringItem.getMapLabelValues();
                for (String key : stringMapLabelValues.keys()) {
                    labels.add(key);
                    values.add((CallSite)((Object)((String)stringMapLabelValues.get(key))));
                }
                break;
            }
            default: {
                throw new ProtocolException(ProtocolPropertiesUtilities.getPrefixMessageErrorConsoleItemType(consoleItemValueType) + "non puo' essere visualizzato come una Multi-Select List");
            }
        }
        de.setValues(values);
        de.setLabels(labels);
    }

    public static String getLabelTipoProprietario(ProprietariProtocolProperty tipoProprietario, String tipoAccordo) {
        if (tipoProprietario != null) {
            switch (tipoProprietario) {
                case ACCORDO_COOPERAZIONE: {
                    return "Accordo Cooperazione";
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    return AccordiServizioParteComuneUtilities.getTerminologiaAccordoServizio(tipoAccordo);
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    return "Accordo Parte Specifica";
                }
                case AZIONE_ACCORDO: {
                    return "Azione Accordo";
                }
                case FRUITORE: {
                    return "Fruitore";
                }
                case OPERATION: {
                    return "Operazione";
                }
                case PORT_TYPE: {
                    return "Port Type";
                }
                case RESOURCE: {
                    return "Risorsa";
                }
                case SOGGETTO: {
                    return "Soggetto";
                }
                case SERVIZIO_APPLICATIVO: {
                    return "Applicativo";
                }
            }
        }
        return null;
    }

    public static String getValueParametroTipoProprietarioAccordoServizio(String tipo) {
        if ("apc".equals(tipo)) {
            return "ACCORDO_SERVIZIO_PARTE_COMUNE";
        }
        return "ACCORDO_SERVIZIO_COMPOSTO";
    }
}

