/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.remote_stores;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.pdd.core.keystore.KeystoreException;
import org.openspcoop2.pdd.core.keystore.KeystoreNotFoundException;
import org.openspcoop2.pdd.core.keystore.RemoteStore;
import org.openspcoop2.pdd.core.keystore.RemoteStoreKeyEntry;
import org.openspcoop2.pdd.core.keystore.RemoteStoreProviderDriverUtils;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.slf4j.Logger;

public class RemoteStoresCore
extends ControlStationCore {
    public RemoteStoresCore() throws DriverControlStationException {
    }

    public RemoteStoresCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public List<RemoteStoreKeyEntry> remoteStoreKeysList(ConsoleSearch ricerca, long idRemoteStore) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "remoteStoreKeysList";
        DriverConfigurazioneDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverConfigurazioneDB(con, null, this.tipoDB);
            List list = RemoteStoreProviderDriverUtils.getRemoteStoreKeyEntries((DriverConfigurazioneDB)driver, (ISearch)ricerca, (long)idRemoteStore);
            return list;
        }
        catch (DriverConfigurazioneException | KeystoreException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, (Exception)e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<RemoteStore> remoteStoresList() throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "remoteStoresList";
        DriverConfigurazioneDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverConfigurazioneDB(con, null, this.tipoDB);
            List list = RemoteStoreProviderDriverUtils.getRemoteStores((DriverConfigurazioneDB)driver);
            return list;
        }
        catch (DriverConfigurazioneException | KeystoreException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, (Exception)e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public RemoteStoreKeyEntry getRemoteStoreKeyEntry(long idRemoteStoreKey) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "getRemoteStoreKeyEntry";
        DriverConfigurazioneDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverConfigurazioneDB(con, null, this.tipoDB);
            RemoteStoreKeyEntry remoteStoreKeyEntry = RemoteStoreProviderDriverUtils.getRemoteStoreKeyEntry((Logger)log, (DriverConfigurazioneDB)driver, (long)idRemoteStoreKey);
            return remoteStoreKeyEntry;
        }
        catch (DriverConfigurazioneException | KeystoreException | KeystoreNotFoundException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, (Exception)e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getLastEventIdRemoteStore(long idRemoteStore) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "getLastEventIdRemoteStore";
        try {
            con = ControlStationCore.dbM.getConnection();
            String string = RemoteStoreProviderDriverUtils.getLastEventIdRemoteStore((Connection)con, (String)this.tipoDB, (long)idRemoteStore);
            return string;
        }
        catch (KeystoreException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void resetLastEventIdRemoteStore(long idRemoteStore) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "restLastEventIdRemoteStore";
        try {
            con = ControlStationCore.dbM.getConnection();
            RemoteStoreProviderDriverUtils.resetLastEventIdRemoteStore((Connection)con, (String)this.tipoDB, (long)idRemoteStore);
        }
        catch (KeystoreException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

