/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.remote_stores;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.pdd.core.keystore.RemoteStore;
import org.openspcoop2.pdd.core.keystore.RemoteStoreKeyEntry;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.remote_stores.RemoteStoresCore;
import org.openspcoop2.web.ctrlstat.servlet.remote_stores.RemoteStoresHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public class RemoteStoresKeysList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            boolean isResetLastEventId;
            RemoteStoresHelper remoteStoresHelper = new RemoteStoresHelper(request, pd, session);
            RemoteStoresCore remoteStoresCore = new RemoteStoresCore();
            remoteStoresHelper.makeMenu();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<RemoteStore> remoteStoresList = remoteStoresCore.remoteStoresList();
            if (remoteStoresList == null || remoteStoresList.isEmpty()) {
                pd.setMessage("Nessun Remote Store disponibile", Costanti.MESSAGE_TYPE_INFO);
                pd.disableEditMode();
                ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"remoteStoresKeys", (ForwardParams)ForwardParams.LIST());
            }
            int idLista = Liste.REMOTE_STORE_KEY;
            List<RemoteStoreKeyEntry> lista = null;
            if (!ServletUtils.isSearchDone((IConsoleHelper)remoteStoresHelper)) {
                lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, RemoteStoreKeyEntry.class);
            }
            ricerca = remoteStoresHelper.checkSearchParameters(idLista, ricerca);
            String filterRemoteStoreId = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRemoteStoreId");
            long remoteStoreId = -1L;
            remoteStoreId = StringUtils.isEmpty((CharSequence)filterRemoteStoreId) ? remoteStoresList.get(0).getId() : Long.parseLong(filterRemoteStoreId);
            String resetLastEventId = remoteStoresHelper.getParameter("remoteStoreKeyResetLastEventId");
            boolean bl = isResetLastEventId = resetLastEventId != null && StringUtils.isNotEmpty((CharSequence)resetLastEventId);
            if (lista == null && !isResetLastEventId) {
                lista = remoteStoresCore.remoteStoreKeysList(ricerca, remoteStoreId);
            }
            String lastEventiId = remoteStoresCore.getLastEventIdRemoteStore(remoteStoreId);
            if (isResetLastEventId) {
                boolean resetEffettuato = this.resetLastEventId(remoteStoresCore, remoteStoreId);
                lastEventiId = resetEffettuato ? "Reset completato: in attesa del primo evento" : "!! Reset failed; see error logs !!";
            }
            if (!remoteStoresHelper.isPostBackFilterElement()) {
                ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, lista);
            }
            remoteStoresHelper.prepareRemoteStoreKeysList(ricerca, lista, remoteStoreId, lastEventiId);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"remoteStoresKeys", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"remoteStoresKeys", (ForwardParams)ForwardParams.LIST());
        }
    }

    private boolean resetLastEventId(RemoteStoresCore remoteStoresCore, long remoteStoreId) {
        try {
            remoteStoresCore.resetLastEventIdRemoteStore(remoteStoreId);
            return true;
        }
        catch (Exception e) {
            ControlStationCore.getLog().error("Reset failed: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

