/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;

public class ServiziApplicativiUpdateUtilities {
    private List<Object> oggettiDaAggiornare = new ArrayList<Object>();
    private ServiziApplicativiCore saCore;
    private ConfigurazioneCore confCore;
    private IDServizioApplicativo oldIdServizioApplicativo;
    private ServizioApplicativo sa;
    private boolean check = false;

    public ServiziApplicativiUpdateUtilities(ServiziApplicativiCore saCore, IDServizioApplicativo oldIdServizioApplicativo, ServizioApplicativo sa) throws Exception {
        this.saCore = saCore;
        this.confCore = new ConfigurazioneCore(this.saCore);
        this.oldIdServizioApplicativo = oldIdServizioApplicativo;
        this.sa = sa;
        this.check = !this.sa.getNome().equals(oldIdServizioApplicativo.getNome());
    }

    public List<Object> getOggettiDaAggiornare() {
        return this.oggettiDaAggiornare;
    }

    public void addServizioApplicativo() {
        this.oggettiDaAggiornare.add(this.sa);
    }

    public void checkRateLimiting() throws DriverControlStationException {
        if (!this.check) {
            return;
        }
        List<AttivazionePolicy> list = null;
        try {
            list = this.confCore.getPolicyByServizioApplicativo(this.oldIdServizioApplicativo);
        }
        catch (DriverControlStationNotFound driverControlStationNotFound) {
            // empty catch block
        }
        if (list != null && !list.isEmpty()) {
            for (AttivazionePolicy attivazionePolicy : list) {
                boolean matchErogatore;
                AttivazionePolicyFiltro filtro = attivazionePolicy.getFiltro();
                if (filtro == null) continue;
                boolean matchFruitore = this.oldIdServizioApplicativo.getNome().equals(filtro.getServizioApplicativoFruitore()) && this.oldIdServizioApplicativo.getIdSoggettoProprietario().getTipo().equals(filtro.getTipoFruitore()) && this.oldIdServizioApplicativo.getIdSoggettoProprietario().getNome().equals(filtro.getNomeFruitore());
                boolean bl = matchErogatore = this.oldIdServizioApplicativo.getNome().equals(filtro.getServizioApplicativoErogatore()) && this.oldIdServizioApplicativo.getIdSoggettoProprietario().getTipo().equals(filtro.getTipoErogatore()) && this.oldIdServizioApplicativo.getIdSoggettoProprietario().getNome().equals(filtro.getNomeErogatore());
                if (matchFruitore) {
                    filtro.setServizioApplicativoFruitore(this.sa.getNome());
                }
                if (matchErogatore) {
                    filtro.setServizioApplicativoErogatore(this.sa.getNome());
                }
                if (!matchFruitore && !matchErogatore) continue;
                this.oggettiDaAggiornare.add(attivazionePolicy);
            }
        }
    }
}

