/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.scope;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCore;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCostanti;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ScopeAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ScopeHelper scopeHelper = new ScopeHelper(request, pd, session);
            scopeHelper.makeMenu();
            String nome = scopeHelper.getParameter("scopeNome");
            String descrizione = scopeHelper.getParameter("scopeDescrizione");
            String tipologia = scopeHelper.getParameter("scopeTipologia");
            if (tipologia == null) {
                tipologia = "";
            }
            String nomeEsterno = scopeHelper.getParameter("scopeNomeEsterno");
            String contesto = scopeHelper.getParameter("scopeContesto");
            if (contesto == null) {
                contesto = ScopeCostanti.DEFAULT_VALUE_PARAMETRO_SCOPE_CONTESTO_UTILIZZO;
            }
            ScopeCore scopeCore = new ScopeCore();
            if (scopeHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Scope", (String)"scopeList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = scopeHelper.addScopeToDati(TipoOperazione.ADD, null, nome != null ? nome : "", descrizione != null ? descrizione : "", tipologia, nomeEsterno, contesto, dati, null);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = scopeHelper.scopeCheckData(TipoOperazione.ADD, null);
            if (!isOk) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Scope", (String)"scopeList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = scopeHelper.addScopeToDati(TipoOperazione.ADD, null, nome, descrizione, tipologia, nomeEsterno, contesto, dati, null);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.ADD());
            }
            Scope scope = new Scope();
            scope.setNome(nome);
            scope.setDescrizione(descrizione);
            scope.setTipologia(tipologia);
            String n = nomeEsterno;
            if (n != null) {
                n = n.trim();
            }
            scope.setNomeEsterno(n);
            scope.setContestoUtilizzo(ScopeContesto.toEnumConstant((String)contesto, (boolean)true));
            scope.setSuperUser(userLogin);
            scopeCore.performCreateOperation(userLogin, scopeHelper.smista(), scope);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            if (scopeCore.isSetSearchAfterAdd()) {
                scopeCore.setSearchAfterAdd(Liste.SCOPE, scope.getNome(), request, session, (ISearch)ricerca);
            }
            List<Scope> lista = null;
            lista = scopeCore.isVisioneOggettiGlobale(userLogin) ? scopeCore.scopeList(null, (ISearch)ricerca) : scopeCore.scopeList(userLogin, (ISearch)ricerca);
            scopeHelper.prepareScopeList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"scope", (ForwardParams)ForwardParams.ADD());
        }
    }
}

