/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.protocol.engine.ConfigurazioneFiltroServiziApplicativi;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class SoggettiHelper
extends ConnettoriHelper {
    public SoggettiHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public SoggettiHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public List<DataElement> addSoggettiToDati(TipoOperazione tipoOp, List<DataElement> dati, String nomeprov, String tipoprov, String portadom, String descr, boolean isRouter, List<String> tipiSoggetti, String profilo, boolean privato, String codiceIpa, List<String> versioni, boolean isSupportatoCodiceIPA, boolean isSupportatoIdentificativoPorta, String[] pddList, String[] pddEsterneList, String nomePddGestioneLocale, String pdd, List<String> listaTipiProtocollo, String protocollo, boolean isSupportatoAutenticazioneSoggetti, String utente, String password, String subject, String principal, String tipoauth, boolean isPddEsterna, String tipologia, String dominio, String tipoCredenzialiSSLSorgente, ArchiveType tipoCredenzialiSSLTipoArchivio, BinaryParameter tipoCredenzialiSSLFileCertificato, String tipoCredenzialiSSLFileCertificatoPassword, List<String> listaAliasEstrattiCertificato, String tipoCredenzialiSSLAliasCertificato, String tipoCredenzialiSSLAliasCertificatoSubject, String tipoCredenzialiSSLAliasCertificatoIssuer, String tipoCredenzialiSSLAliasCertificatoType, String tipoCredenzialiSSLAliasCertificatoVersion, String tipoCredenzialiSSLAliasCertificatoSerialNumber, String tipoCredenzialiSSLAliasCertificatoSelfSigned, String tipoCredenzialiSSLAliasCertificatoNotBefore, String tipoCredenzialiSSLAliasCertificatoNotAfter, String tipoCredenzialiSSLVerificaTuttiICampi, String tipoCredenzialiSSLConfigurazioneManualeSelfSigned, String issuer, String tipoCredenzialiSSLStatoElaborazioneCertificato, String changepwd, String multipleApiKey, String appId, String apiKey, boolean visualizzaModificaCertificato, boolean visualizzaAddCertificato, String servletCredenzialiList, List<Parameter> parametersServletCredenzialiList, Integer numeroCertificati, String servletCredenzialiAdd) throws Exception {
        return this.addSoggettiToDati(tipoOp, dati, nomeprov, tipoprov, portadom, descr, isRouter, tipiSoggetti, profilo, privato, codiceIpa, versioni, isSupportatoCodiceIPA, isSupportatoIdentificativoPorta, pddList, pddEsterneList, nomePddGestioneLocale, pdd, null, null, null, null, -1L, null, -1L, null, listaTipiProtocollo, protocollo, isSupportatoAutenticazioneSoggetti, utente, password, subject, principal, tipoauth, isPddEsterna, tipologia, dominio, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, tipoCredenzialiSSLAliasCertificatoVersion, tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuer, tipoCredenzialiSSLStatoElaborazioneCertificato, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, 0);
    }

    public List<DataElement> addSoggettiToDati(TipoOperazione tipoOp, List<DataElement> dati, String nomeprov, String tipoprov, String portadom, String descr, boolean isRouter, List<String> tipiSoggetti, String profilo, boolean privato, String codiceIpa, List<String> versioni, boolean isSupportatoCodiceIPA, boolean isSupportatoIdentificativoPorta, String[] pddList, String[] pddEsterneList, String nomePddGestioneLocale, String pdd, String id, String oldnomeprov, String oldtipoprov, Connettore connettore, long numPD, String pdUrlPrefixRewriter, long numPA, String paUrlPrefixRewriter, List<String> listaTipiProtocollo, String protocollo, boolean isSupportatoAutenticazioneSoggetti, String utente, String password, String subject, String principal, String tipoauth, boolean isPddEsterna, String tipologia, String dominio, String tipoCredenzialiSSLSorgente, ArchiveType tipoCredenzialiSSLTipoArchivio, BinaryParameter tipoCredenzialiSSLFileCertificato, String tipoCredenzialiSSLFileCertificatoPassword, List<String> listaAliasEstrattiCertificato, String tipoCredenzialiSSLAliasCertificato, String tipoCredenzialiSSLAliasCertificatoSubject, String tipoCredenzialiSSLAliasCertificatoIssuer, String tipoCredenzialiSSLAliasCertificatoType, String tipoCredenzialiSSLAliasCertificatoVersion, String tipoCredenzialiSSLAliasCertificatoSerialNumber, String tipoCredenzialiSSLAliasCertificatoSelfSigned, String tipoCredenzialiSSLAliasCertificatoNotBefore, String tipoCredenzialiSSLAliasCertificatoNotAfter, String tipoCredenzialiSSLVerificaTuttiICampi, String tipoCredenzialiSSLConfigurazioneManualeSelfSigned, String issuer, String tipoCredenzialiSSLStatoElaborazioneCertificato, String changepwd, String multipleApiKey, String appId, String apiKey, boolean visualizzaModificaCertificato, boolean visualizzaAddCertificato, String servletCredenzialiList, List<Parameter> parametersServletCredenzialiList, Integer numeroCertificati, String servletCredenzialiAdd, int numeroProprieta) throws Exception {
        boolean showVersioneProtocollo;
        DataElement de;
        Soggetto soggetto = null;
        if (TipoOperazione.CHANGE.equals((Object)tipoOp) && oldtipoprov != null && !"".equals(oldtipoprov) && oldnomeprov != null && !"".equals(oldnomeprov)) {
            IDSoggetto idSoggetto = new IDSoggetto(oldtipoprov, oldnomeprov);
            soggetto = this.soggettiCore.getSoggettoRegistro(idSoggetto);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOp)) {
            String labelSoggetto = this.getLabelNomeSoggetto(protocollo, tipoprov, nomeprov);
            ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
            listaParametriChange.add(new Parameter("id", id));
            listaParametriChange.add(new Parameter("nomeprov", nomeprov));
            listaParametriChange.add(new Parameter("tipoprov", tipoprov));
            this.addComandoInUsoButton(labelSoggetto, id, InUsoType.SOGGETTO);
            if (this.core.isSoggettiVerificaCertificati()) {
                boolean ssl = false;
                if (CredenzialeTipo.SSL.equals(tipoauth)) {
                    ssl = true;
                }
                if (ssl) {
                    this.pd.addComandoVerificaCertificatiElementoButton("soggettiVerificaCertificati.do", listaParametriChange);
                }
            }
            if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
                listaParametriChange.add(new Parameter("rmElFromCache", "true"));
                this.pd.addComandoResetCacheElementoButton("soggettiChange.do", listaParametriChange);
            }
            if (this.existsProprietaOggetto(soggetto.getProprietaOggetto(), soggetto.getDescrizione())) {
                this.addComandoProprietaOggettoButton(labelSoggetto, id, InUsoType.SOGGETTO);
            }
        }
        Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
        if (TipoOperazione.CHANGE.equals((Object)tipoOp)) {
            de = new DataElement();
            de.setLabel("id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Soggetto");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        boolean gestionePdd = true;
        if (this.core.isSinglePdD() && !this.core.isGestionePddAbilitata(this)) {
            gestionePdd = false;
        }
        boolean multiTenant = this.core.isMultitenant();
        boolean hiddenDatiDominioInterno = false;
        if (!multiTenant && !gestionePdd) {
            hiddenDatiDominioInterno = SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE.equals(dominio);
        }
        if (gestionePdd) {
            if (TipoOperazione.ADD.equals((Object)tipoOp)) {
                if (this.core.isRegistroServiziLocale()) {
                    de = new DataElement();
                    de.setLabel("Porta di Dominio");
                    de.setType(DataElementType.SELECT);
                    de.setName("pdd");
                    if (this.soggettiCore.isMultitenant()) {
                        de.setValues(pddList);
                    } else {
                        de.setValues(pddEsterneList);
                    }
                    de.setSelected(pdd);
                    de.setPostBack(isSupportatoAutenticazioneSoggetti);
                    if (this.core.isSinglePdD()) {
                        if ((pdd == null || "".equals(pdd)) && nomePddGestioneLocale != null) {
                            de.setSelected(nomePddGestioneLocale);
                        }
                    } else {
                        de.setRequired(true);
                    }
                    dati.add(de);
                }
            } else if (this.core.isSinglePdD()) {
                if (this.core.isRegistroServiziLocale()) {
                    de = new DataElement();
                    de.setLabel("Porta di Dominio");
                    de.setType(DataElementType.SELECT);
                    de.setName("pdd");
                    if (this.soggettiCore.isMultitenant()) {
                        de.setValues(pddList);
                    } else {
                        de.setValues(pddEsterneList);
                    }
                    de.setSelected(pdd);
                    de.setPostBack(isSupportatoAutenticazioneSoggetti);
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setLabel("Porta di Dominio");
                de.setType(DataElementType.TEXT);
                de.setName("pdd");
                de.setValue(pdd);
                dati.add(de);
            }
        } else {
            boolean listOperativoSolamente = false;
            if (pddList != null && pddList.length == 1 && pddList[0].equals(nomePddGestioneLocale)) {
                listOperativoSolamente = true;
            }
            de = new DataElement();
            de.setLabel("Dominio");
            de.setName("dominio");
            if (!multiTenant) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(dominio);
            } else if (TipoOperazione.CHANGE.equals((Object)tipoOp) && listOperativoSolamente) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(dominio);
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setLabel("Dominio");
                de.setName("dominio__label");
                String valueDom = dominio;
                String[] sdValues = SoggettiCostanti.getSoggettiDominiValue();
                String[] sdLabels = SoggettiCostanti.getSoggettiDominiLabel();
                for (int i = 0; i < sdValues.length; ++i) {
                    if (!sdValues[i].equals(dominio)) continue;
                    valueDom = sdLabels[i];
                    break;
                }
                de.setValue(valueDom);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(SoggettiCostanti.getSoggettiDominiValue());
                de.setLabels(SoggettiCostanti.getSoggettiDominiLabel());
                de.setSelected(dominio);
                de.setPostBack(isSupportatoAutenticazioneSoggetti);
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Profilo Interoperabilit\u00e0");
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            if (listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
                de.setLabel("Profilo Interoperabilit\u00e0");
                de.setValues(listaTipiProtocollo);
                de.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
                de.setSelected(protocollo);
                de.setType(DataElementType.SELECT);
                de.setName("protocollo");
                de.setPostBack(true);
            } else {
                de.setValue(protocollo);
                de.setType(DataElementType.HIDDEN);
                de.setName("protocollo");
            }
        } else if (listaTipiProtocollo != null && listaTipiProtocollo.size() > 1) {
            DataElement deLABEL = new DataElement();
            deLABEL.setLabel("Profilo Interoperabilit\u00e0");
            deLABEL.setType(DataElementType.TEXT);
            deLABEL.setName("protocollo__label");
            deLABEL.setValue(this.getLabelProtocollo(protocollo));
            dati.add(deLABEL);
            de.setValue(protocollo);
            de.setType(DataElementType.HIDDEN);
            de.setName("protocollo");
        } else {
            de.setValue(protocollo);
            de.setType(DataElementType.HIDDEN);
            de.setName("protocollo");
        }
        de.setSize(this.getSize());
        dati.add(de);
        String[] tipiLabel = new String[tipiSoggetti.size()];
        for (int i = 0; i < tipiSoggetti.size(); ++i) {
            String nomeTipo;
            tipiLabel[i] = nomeTipo = tipiSoggetti.get(i);
        }
        String[] versioniLabel = new String[versioni.size()];
        for (int i = 0; i < versioni.size(); ++i) {
            String versione;
            versioniLabel[i] = versione = versioni.get(i);
        }
        de = new DataElement();
        de.setLabel("Tipo");
        de.setName("tipoprov");
        if (tipiLabel != null && tipiLabel.length > 1) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipiLabel);
            de.setSelected(tipoprov);
        } else {
            de.setType(DataElementType.HIDDEN);
            if ((tipoprov == null || "".equals(tipoprov)) && tipiLabel != null && tipiLabel.length > 0 || tipoprov != null && tipiLabel != null && tipiLabel.length > 0 && !tipoprov.equals(tipiLabel[0])) {
                tipoprov = tipiLabel[0];
            }
            de.setValue(tipoprov);
        }
        de.setSize(this.getSize());
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nomeprov);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("nomeprov");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            de = new DataElement();
            de.setLabel("Tipologia");
            de.setName("tipologia");
            if (isPddEsterna && isSupportatoAutenticazioneSoggetti) {
                de.setValue(tipologia);
                de.setSelected(tipologia);
                de.setType(DataElementType.SELECT);
                de.setValues(SoggettiCostanti.getSoggettiRuoli());
                de.setPostBack(true);
            } else {
                de.setValue("");
                de.setType(DataElementType.HIDDEN);
            }
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Identificativo Porta");
        de.setValue(portadom);
        if (!isSupportatoIdentificativoPorta) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.TEXT_EDIT);
        }
        de.setName("portadom");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Codice IPA");
        de.setValue(codiceIpa);
        if (!isSupportatoCodiceIPA) {
            de.setType(DataElementType.HIDDEN);
        } else if (this.core.isRegistroServiziLocale()) {
            de.setType(DataElementType.TEXT_EDIT);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("codice_ipa");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descr);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(2);
        de.setName("descr");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Versione Protocollo");
        de.setName("profilo");
        boolean bl = showVersioneProtocollo = this.core.isRegistroServiziLocale() && this.apsCore.getVersioniProtocollo(protocollo).size() > 1;
        if (showVersioneProtocollo) {
            de.setValues(versioniLabel);
            de.setSelected(profilo);
            de.setType(DataElementType.SELECT);
        } else {
            de.setValue(profilo);
            de.setType(DataElementType.HIDDEN);
        }
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Privato");
        if (this.core.isShowFlagPrivato() && this.isModalitaAvanzata() && this.core.isRegistroServiziLocale()) {
            de.setType(DataElementType.CHECKBOX);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("privato");
        de.setSelected(privato ? "yes" : "");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Router");
        de.setName("is_router");
        if (this.isModalitaAvanzata() && this.core.isShowGestioneSoggettiRouter()) {
            de.setType(DataElementType.CHECKBOX);
            if (isRouter) {
                de.setSelected(true);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("no");
        }
        dati.add(de);
        if (TipoOperazione.CHANGE.equals((Object)tipoOp)) {
            boolean showConnettore;
            boolean bl2 = showConnettore = this.core.isRegistroServiziLocale() && this.isModalitaCompleta();
            if (showConnettore) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl(SoggettiCostanti.SERVLET_NAME_SOGGETTI_ENDPOINT, new Parameter[]{new Parameter("id", id)});
                Utilities.setDataElementLabelTipoConnettore(de, connettore);
                dati.add(de);
            }
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOp)) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            ArrayList<Parameter> parametersServletSoggettoChange = new ArrayList<Parameter>();
            Parameter pIdSoggetto = new Parameter("id", id);
            parametersServletSoggettoChange.add(pIdSoggetto);
            de.setUrl("soggettiProprietaList.do", parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()]));
            if (contaListe != null && contaListe.booleanValue()) {
                de.setValue("Propriet&agrave;(" + numeroProprieta + ")");
            } else {
                de.setValue("Propriet&agrave;");
            }
            dati.add(de);
        }
        if (isSupportatoAutenticazioneSoggetti) {
            if (utente == null) {
                utente = "";
            }
            if (password == null) {
                password = "";
            }
            if (subject == null) {
                subject = "";
            }
            if (principal == null) {
                principal = "";
            }
            String servlet = null;
            servlet = TipoOperazione.ADD.equals((Object)tipoOp) ? "soggettiAdd.do" : "soggettiChange.do";
            boolean autenticazioneNessunaAbilitata = true;
            boolean showCredenziali = true;
            if (this.pddCore.isPddEsterna(pdd)) {
                if ("Fruitore".equals(tipologia) || "Fruitore/Erogatore".equals(tipologia)) {
                    autenticazioneNessunaAbilitata = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocollo);
                }
                if ("Erogatore".equals(tipologia)) {
                    showCredenziali = false;
                }
            } else if (hiddenDatiDominioInterno) {
                showCredenziali = false;
            } else if (TipoOperazione.ADD.equals((Object)tipoOp)) {
                showCredenziali = this.isModalitaAvanzata();
            }
            if (showCredenziali) {
                String oldtipoauth = null;
                if (isSupportatoAutenticazioneSoggetti && TipoOperazione.CHANGE.equals((Object)tipoOp) && soggetto != null) {
                    CredenzialeTipo tipo = null;
                    if (soggetto.sizeCredenzialiList() > 0) {
                        tipo = soggetto.getCredenziali(0).getTipo();
                    }
                    oldtipoauth = tipo != null ? tipo.getValue() : "nessuna";
                }
                boolean postBackViaPost = false;
                dati = this.addCredenzialiToDati(tipoOp, dati, tipoauth, oldtipoauth, utente, password, subject, principal, servlet, true, null, false, true, null, autenticazioneNessunaAbilitata, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, tipoCredenzialiSSLAliasCertificatoVersion, tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuer, tipoCredenzialiSSLStatoElaborazioneCertificato, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, false, null, null, false, SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE.equals(dominio), protocollo, postBackViaPost);
            }
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOp)) {
            de = new DataElement();
            de.setLabel("Ruoli");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            if (this.isModalitaCompleta()) {
                de.setUrl("soggettiRuoliList.do", new Parameter[]{new Parameter("id", id)});
            } else {
                de.setUrl("soggettiRuoliList.do", new Parameter[]{new Parameter("id", id), new Parameter("accessoDaChange", "yes")});
            }
            if (contaListe.booleanValue()) {
                ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                this.soggettiCore.soggettiRuoliList(Long.parseLong(id), (ISearch)searchForCount);
                int numRuoli = searchForCount.getNumEntries(Liste.SOGGETTI_RUOLI);
                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Ruoli", (Long)Long.valueOf(numRuoli));
            } else {
                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Ruoli");
            }
            dati.add(de);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOp) && !this.pddCore.isPddEsterna(pdd)) {
            if (this.isModalitaCompleta()) {
                de = new DataElement();
                de.setLabel("Porte Delegate");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("UrlPrefix rewriter");
            if (this.isModalitaCompleta()) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("pd_url_prefix_rewriter");
            de.setValue(pdUrlPrefixRewriter);
            de.setSize(this.getSize());
            dati.add(de);
            if (this.isModalitaCompleta()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("porteDelegateList.do", new Parameter[]{new Parameter("idsogg", id)});
                if (contaListe.booleanValue()) {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)numPD);
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                dati.add(de);
            }
            if (this.isModalitaCompleta()) {
                de = new DataElement();
                de.setLabel("Porte Applicative");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("UrlPrefix rewriter");
            if (this.isModalitaCompleta()) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("pa_url_prefix_rewriter");
            de.setValue(paUrlPrefixRewriter);
            de.setSize(this.getSize());
            dati.add(de);
            if (this.isModalitaCompleta()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl("porteApplicativeList.do", new Parameter[]{new Parameter("idsogg", id)});
                if (contaListe.booleanValue()) {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)numPA);
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                dati.add(de);
            }
        }
        return dati;
    }

    public boolean soggettiCheckData(TipoOperazione tipoOp, String id, String tipoprov, String nomeprov, String codiceIpa, String pdUrlPrefixRewriter, String paUrlPrefixRewriter, Soggetto soggettoOld, boolean isSupportatoAutenticazioneSoggetti, String descrizione, String portadom) throws Exception {
        try {
            boolean encryptEnabled;
            int idInt = 0;
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                idInt = Integer.parseInt(id);
            }
            if (nomeprov.equals("") || tipoprov.equals("")) {
                Object tmpElenco = "";
                if (nomeprov.equals("")) {
                    tmpElenco = "Nome";
                }
                if (tipoprov.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Tipo" : (String)tmpElenco + ", Tipo";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                return false;
            }
            if (nomeprov.indexOf(" ") != -1 || tipoprov.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkSimpleName(tipoprov, "Tipo")) {
                return false;
            }
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoprov);
            boolean dominioEsternoModI = false;
            if (portadom != null) {
                boolean bl = dominioEsternoModI = this.isProfiloModIPA(protocollo) && this.pddCore.isPddEsterna(portadom);
            }
            if (this.soggettiCore.isSupportatoTrattinoNomeSoggetto(protocollo) ? !this.checkSimpleNamePath(nomeprov, "Nome") : !this.checkSimpleName(nomeprov, "Nome")) {
                return false;
            }
            int maxLength = 235;
            if (this.soggettiCore.getSoggettiNomeMaxLength() != null && this.soggettiCore.getSoggettiNomeMaxLength() > 0) {
                maxLength = this.soggettiCore.getSoggettiNomeMaxLength();
            }
            if (!this.checkLength(nomeprov, "Nome", -1, maxLength)) {
                return false;
            }
            if (descrizione != null && !"".equals(descrizione) && !this.checkLength4000(descrizione, "Descrizione")) {
                return false;
            }
            if (pdUrlPrefixRewriter != null && !"".equals(pdUrlPrefixRewriter) && !RegularExpressionEngine.isMatch((String)pdUrlPrefixRewriter, (String)"[A-Za-z]+:\\/\\/(.*)")) {
                this.pd.setMessage("Il campo UrlPrefix rewriter del profilo client contiene un valore errato. Il valore atteso deve seguire la sintassi: " + StringEscapeUtils.escapeHtml4((String)"protocol://hostname[:port][/*]"));
                return false;
            }
            if (paUrlPrefixRewriter != null && !"".equals(paUrlPrefixRewriter) && !RegularExpressionEngine.isMatch((String)paUrlPrefixRewriter, (String)"[A-Za-z]+:\\/\\/(.*)")) {
                this.pd.setMessage("Il campo UrlPrefix rewriter del profilo server contiene un valore errato. Il valore atteso deve seguire la sintassi: " + StringEscapeUtils.escapeHtml4((String)"protocol://hostname[:port][/*]"));
                return false;
            }
            IDSoggetto ids = new IDSoggetto(tipoprov, nomeprov);
            String labelSoggetto = this.getLabelNomeSoggetto(ids);
            if (tipoOp.equals((Object)TipoOperazione.ADD) || tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                Soggetto mySogg;
                int idSogg = 0;
                boolean existsSogg = this.soggettiCore.existsSoggetto(ids);
                if (existsSogg) {
                    if (this.core.isRegistroServiziLocale()) {
                        mySogg = this.soggettiCore.getSoggettoRegistro(ids);
                        idSogg = mySogg.getId().intValue();
                    } else {
                        mySogg = this.soggettiCore.getSoggetto(ids);
                        idSogg = mySogg.getId().intValue();
                    }
                }
                if (idSogg != 0 && (tipoOp.equals((Object)TipoOperazione.ADD) || tipoOp.equals((Object)TipoOperazione.CHANGE) && idInt != idSogg)) {
                    this.pd.setMessage("Esiste gi&agrave; un soggetto " + labelSoggetto);
                    return false;
                }
                if (this.core.isRegistroServiziLocale() && codiceIpa != null && !"".equals(codiceIpa)) {
                    if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                        if (this.soggettiCore.existsSoggetto(codiceIpa)) {
                            this.pd.setMessage("Esiste gi&agrave; un soggetto con Codice IPA: " + codiceIpa);
                            return false;
                        }
                    } else {
                        mySogg = null;
                        try {
                            mySogg = this.soggettiCore.getSoggettoByCodiceIPA(codiceIpa);
                        }
                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                            // empty catch block
                        }
                        if (mySogg != null && mySogg.getId() != (long)idInt) {
                            this.pd.setMessage("Esiste gi&agrave; un soggetto con Codice IPA: " + codiceIpa);
                            return false;
                        }
                    }
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                String oldTipoAuth = null;
                if (isSupportatoAutenticazioneSoggetti && soggettoOld != null) {
                    CredenzialeTipo tipo = null;
                    if (soggettoOld.sizeCredenzialiList() > 0) {
                        tipo = soggettoOld.getCredenziali(0).getTipo();
                    }
                    oldTipoAuth = tipo != null ? tipo.getValue() : "nessuna";
                }
                String tipoauth = this.getParameter("tipoauthCredenziali");
                if (oldTipoAuth != null && !oldTipoAuth.equals(tipoauth)) {
                    FiltroRicercaPorteApplicative filtro = new FiltroRicercaPorteApplicative();
                    filtro.setIdSoggettoAutorizzato(ids);
                    List<IDPortaApplicativa> list = this.porteApplicativeCore.getAllIdPorteApplicative(filtro);
                    if ("spcoop".equals(protocollo)) {
                        int count = 0;
                        if (list != null && !list.isEmpty()) {
                            for (IDPortaApplicativa idPortaApplicativa : list) {
                                PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(idPortaApplicativa);
                                if ("none".equalsIgnoreCase(pa.getAutenticazione()) || CostantiConfigurazione.DISABILITATO.toString().equalsIgnoreCase(pa.getAutenticazione())) continue;
                                ++count;
                            }
                        }
                        if (count > 0) {
                            this.pd.setMessage("Non &egrave; possibile modificare il tipo di credenziali poich&egrave; il soggetto viene utilizzato all'interno del controllo degli accessi di " + list.size() + " configurazioni di erogazione di servizio con autenticazione trasporto abilitata");
                            return false;
                        }
                    } else if (list != null && !list.isEmpty()) {
                        this.pd.setMessage("Non &egrave; possibile modificare il tipo di credenziali poich&egrave; il soggetto viene utilizzato all'interno del controllo degli accessi di " + list.size() + " configurazioni di erogazione di servizio");
                        return false;
                    }
                }
            }
            boolean oldPasswordCifrata = false;
            if (soggettoOld != null && soggettoOld.sizeCredenzialiList() > 0 && soggettoOld.getCredenziali(0).isCertificateStrictVerification()) {
                oldPasswordCifrata = true;
            }
            if (!this.credenzialiCheckData(tipoOp, oldPasswordCifrata, encryptEnabled = this.saCore.isSoggettiPasswordEncryptEnabled(), this.soggettiCore.getSoggettiPasswordVerifier())) {
                return false;
            }
            String tipoauth = this.getParameter("tipoauthCredenziali");
            if (tipoauth == null) {
                tipoauth = "nessuna";
            }
            String utente = this.getParameter("utenteCredenziali");
            String password = this.getParameter("passwordCredenziali");
            String subject = this.getParameter("subjectCredenziali");
            String issuer = this.getParameter("subjectIssuer");
            if ("".equals(issuer)) {
                issuer = null;
            }
            String principal = this.getParameter("principalCredenziali");
            if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC)) {
                boolean checkPasswordSA;
                List<ServizioApplicativo> saList;
                int i;
                boolean checkPassword = this.soggettiCore.isSoggettiCredenzialiBasicCheckUniqueUsePassword();
                Soggetto soggettoAutenticato = this.soggettiCore.soggettoWithCredenzialiBasic(utente, password, checkPassword);
                if (soggettoAutenticato != null && tipoOp.equals((Object)TipoOperazione.CHANGE) && (long)idInt == soggettoAutenticato.getId()) {
                    soggettoAutenticato = null;
                }
                if (soggettoAutenticato != null) {
                    String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                    this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 l'utente (http-basic) indicato");
                    return false;
                }
                if (!this.soggettiCore.isSoggettiApplicativiCredenzialiBasicPermitSameCredentials() && (i = 0) < (saList = this.saCore.servizioApplicativoWithCredenzialiBasicList(utente, password, checkPasswordSA = this.saCore.isApplicativiCredenzialiBasicCheckUniqueUsePassword())).size()) {
                    ServizioApplicativo sa = saList.get(i);
                    String labelSoggettoGiaEsistente = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    if (sa.getTipo() != null && StringUtils.isNotEmpty((CharSequence)sa.getTipo())) {
                        this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggettoGiaEsistente + ") possiede gi\u00e0 l'utente (http-basic) indicato");
                    } else {
                        this.pd.setMessage("L'erogazione " + sa.getNome() + " possiede gi\u00e0 l'utente (http-basic) indicato per il servizio 'Servizio IntegrationManager/MessageBox'");
                    }
                    return false;
                }
            } else if (!tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY)) {
                if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL)) {
                    String tipoCredenzialiSSLConfigurazioneManualeSelfSigned;
                    String tipoCredenzialiSSLSorgente = this.getParameter("confSSLCredenziali");
                    if (tipoCredenzialiSSLSorgente == null) {
                        tipoCredenzialiSSLSorgente = "confMan";
                    }
                    if ((tipoCredenzialiSSLConfigurazioneManualeSelfSigned = this.getParameter("confSSLManSS")) == null) {
                        tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "yes";
                    }
                    String details = "";
                    Soggetto soggettoAutenticato = null;
                    String tipoSsl = null;
                    Certificate cSelezionato = null;
                    boolean strictVerifier = false;
                    if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                        soggettoAutenticato = this.soggettiCore.getSoggettoRegistroAutenticatoSsl(subject, issuer);
                        tipoSsl = "subject/issuer";
                    } else {
                        List<Soggetto> soggettiAutenticati;
                        BinaryParameter tipoCredenzialiSSLFileCertificato = this.getBinaryParameter("confSSLCredFileCert");
                        String tipoCredenzialiSSLVerificaTuttiICampi = this.getParameter("confSSLCredVerifTutti");
                        strictVerifier = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                        String tipoCredenzialiSSLTipoArchivioS = this.getParameter("confSSLCredTipoArch");
                        String tipoCredenzialiSSLFileCertificatoPassword = this.getParameter("confSSLCredFileCertPwd");
                        String tipoCredenzialiSSLAliasCertificato = this.getParameter("confSSLCredAliasCert");
                        if (tipoCredenzialiSSLAliasCertificato == null) {
                            tipoCredenzialiSSLAliasCertificato = "";
                        }
                        ArchiveType tipoCredenzialiSSLTipoArchivio = null;
                        tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
                        byte[] archivio = tipoCredenzialiSSLFileCertificato.getValue();
                        if (TipoOperazione.CHANGE.equals((Object)tipoOp) && archivio == null) {
                            archivio = soggettoOld.getCredenziali(0).getCertificate();
                        }
                        if ((soggettiAutenticati = this.soggettiCore.soggettoWithCredenzialiSslList((cSelezionato = tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER) ? ArchiveLoader.load((byte[])archivio) : ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])archivio, (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword)).getCertificate(), strictVerifier)) != null && soggettiAutenticati.size() > 0) {
                            List<Soggetto> soggettiAutenticatiCheck;
                            soggettoAutenticato = soggettiAutenticati.get(0);
                            if (!strictVerifier && ((soggettiAutenticatiCheck = this.soggettiCore.soggettoWithCredenzialiSslList(cSelezionato.getCertificate(), true)) == null || soggettiAutenticatiCheck.isEmpty())) {
                                details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                            }
                        }
                        tipoSsl = "certificato";
                    }
                    if (soggettoAutenticato != null && tipoOp.equals((Object)TipoOperazione.CHANGE) && (long)idInt == soggettoAutenticato.getId()) {
                        soggettoAutenticato = null;
                    }
                    if (soggettoAutenticato != null) {
                        String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                        this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                        return false;
                    }
                    if (!this.soggettiCore.isSoggettiApplicativiCredenzialiSslPermitSameCredentials()) {
                        details = "";
                        List<ServizioApplicativo> saList = null;
                        tipoSsl = null;
                        if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                            saList = this.saCore.servizioApplicativoWithCredenzialiSslList(subject, issuer, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                            tipoSsl = "subject/issuer";
                        } else {
                            List<ServizioApplicativo> saListCheck;
                            saList = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), strictVerifier, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                            if (!(strictVerifier || saList == null || saList.isEmpty() || (saListCheck = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), true, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps())) != null && !saListCheck.isEmpty())) {
                                details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                            }
                            tipoSsl = "certificato";
                        }
                        if (saList != null) {
                            for (int i = 0; i < saList.size(); ++i) {
                                Credenziali c;
                                ServizioApplicativo sa = saList.get(i);
                                boolean tokenWithHttpsEnabledByConfigSA = false;
                                if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0 && (c = sa.getInvocazionePorta().getCredenziali(0)) != null && c.getTokenPolicy() != null && StringUtils.isNotEmpty((CharSequence)c.getTokenPolicy())) {
                                    tokenWithHttpsEnabledByConfigSA = true;
                                }
                                if (tokenWithHttpsEnabledByConfigSA) continue;
                                String labelSoggettoApplicativo = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                                this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggettoApplicativo + ") possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                                return false;
                            }
                        }
                    }
                } else if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL)) {
                    List<ServizioApplicativo> saList;
                    int i;
                    Soggetto soggettoAutenticato = this.soggettiCore.getSoggettoRegistroAutenticatoPrincipal(principal);
                    if (soggettoAutenticato != null && tipoOp.equals((Object)TipoOperazione.CHANGE) && (long)idInt == soggettoAutenticato.getId()) {
                        soggettoAutenticato = null;
                    }
                    if (soggettoAutenticato != null) {
                        String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                        this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 il principal indicato");
                        return false;
                    }
                    if (!this.soggettiCore.isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials() && (i = 0) < (saList = this.saCore.servizioApplicativoWithCredenzialiPrincipalList(principal)).size()) {
                        ServizioApplicativo sa = saList.get(i);
                        String labelSoggettoApplicativo = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                        this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggettoApplicativo + ") possiede gi\u00e0 il principal indicato");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void prepareSoggettiList(List<Soggetto> lista, ISearch ricerca) throws Exception {
        try {
            ExporterUtils exporterUtils;
            List<String> nomiProprieta;
            List<String> protocolli;
            boolean modalitaCompleta = this.isModalitaCompleta();
            if (!modalitaCompleta) {
                this.pd.setCustomListViewName("soggetti");
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"soggetti", (Parameter[])new Parameter[0]);
            boolean multiTenant = this.core.isMultitenant();
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            int idLista = Liste.SOGGETTI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterProtocollo = this.addFilterProtocol(ricerca, idLista, true);
            boolean profiloSelezionato = false;
            String protocolloSel = filterProtocollo;
            if (protocolloSel == null && (protocolli = this.core.getProtocolli(this.request, this.session)) != null && protocolli.size() == 1) {
                protocolloSel = protocolli.get(0);
            }
            if (filterProtocollo != null && !"".equals(filterProtocollo) || filterProtocollo == null && protocolloSel != null) {
                profiloSelezionato = true;
            }
            if (!this.core.isGestionePddAbilitata(this) && multiTenant) {
                String filterDominio = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroDominio");
                this.addFilterDominio(filterDominio, false);
            }
            String filterTipoSoggetto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoSoggetto");
            this.addFilterTipoSoggetto(filterTipoSoggetto, false);
            String filterTipoCredenziali = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoCredenziali");
            this.addFilterTipoCredenziali(filterTipoCredenziali, true, false);
            String filterCredenziale = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroCredenziale");
            this.addFilterCredenziale(filterTipoCredenziali, filterCredenziale);
            String filterCredenzialeIssuer = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroCredenzialeIssuer");
            this.addFilterCredenzialeIssuer(filterTipoCredenziali, filterCredenzialeIssuer);
            String filterRuolo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRuolo");
            this.addFilterRuolo(filterRuolo, false);
            String filterGruppo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
            this.addFilterGruppo(filterProtocollo, filterGruppo, true);
            String filterApiContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiContesto");
            this.addFilterApiContesto(filterApiContesto, true);
            if (!(!profiloSelezionato || filterApiContesto == null || "".equals(filterApiContesto) || "Erogatore".equals(filterTipoSoggetto) || "Fruitore".equals(filterTipoSoggetto) && TipoPdD.DELEGATA.getTipo().equals(filterApiContesto))) {
                String filterApiImplementazione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
                this.addFilterApiImplementazione(filterProtocollo, null, filterGruppo, filterApiContesto, filterApiImplementazione, false);
            } else {
                SearchUtils.clearFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
            }
            String protocolloPerFiltroProprieta = protocolloSel;
            if (protocolloPerFiltroProprieta == null) {
                protocolloPerFiltroProprieta = "".equals(filterProtocollo) ? null : filterProtocollo;
            }
            if ((nomiProprieta = this.nomiProprietaSoggetti(protocolloPerFiltroProprieta)) != null && !nomiProprieta.isEmpty()) {
                this.addFilterSubtitle("subtDatiProp", "Dati Propriet&agrave;", false);
                this.addFilterProprietaNome(ricerca, idLista, nomiProprieta);
                this.addFilterProprietaValore(ricerca, idLista, nomiProprieta);
                this.impostaAperturaSubtitle("subtDatiProp");
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Soggetti", "soggettiList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Soggetti", "soggettiList.do"), new Parameter("Risultati ricerca", null)});
            }
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            this.setLabelColonne(modalitaCompleta, multiTenant, showProtocolli);
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Soggetti", (String)search);
            }
            if (lista != null) {
                ListIterator<Soggetto> it = lista.listIterator();
                while (it.hasNext()) {
                    List<DataElement> e = modalitaCompleta ? this.creaEntry(modalitaCompleta, multiTenant, contaListe, showProtocolli, it) : this.creaEntryCustom(multiTenant, showProtocolli, it);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(org.openspcoop2.protocol.sdk.constants.ArchiveType.SOGGETTO, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(SoggettiCostanti.LABEL_SOGGETTI_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    private List<DataElement> creaEntry(boolean modalitaCompleta, boolean multiTenant, Boolean contaListe, boolean showProtocolli, Iterator<Soggetto> it) throws DriverControlStationException, DriverControlStationNotFound, DriverRegistroServiziNotFound, DriverRegistroServiziException, Exception, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Soggetto elem = it.next();
        PdDControlStation pdd = null;
        String nomePdD = elem.getPortaDominio();
        if (nomePdD != null && !nomePdD.equals("-")) {
            pdd = this.pddCore.getPdDControlStation(nomePdD);
        }
        boolean pddEsterna = this.pddCore.isPddEsterna(nomePdD);
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(elem.getTipo());
        DataElement de = new DataElement();
        de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + elem.getId())});
        de.setValue(this.getLabelNomeSoggetto(protocollo, elem.getTipo(), elem.getNome()));
        de.setIdToRemove(elem.getId().toString());
        de.setToolTip(de.getValue());
        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        e.add(de);
        if (showProtocolli) {
            de = new DataElement();
            de.setValue(this.getLabelProtocollo(protocollo));
            e.add(de);
        }
        if (this.core.isGestionePddAbilitata(this)) {
            de = new DataElement();
            if (pdd != null && !nomePdD.equals("-")) {
                if (!nomePdD.equals("-")) {
                    de.setUrl("pddSinglePdDChange.do", new Parameter[]{new Parameter("id", "" + pdd.getId()), new Parameter("nome", pdd.getNome())});
                }
                de.setValue(nomePdD);
            } else {
                de.setValue("-");
            }
            e.add(de);
        } else if (multiTenant) {
            de = new DataElement();
            if (pddEsterna) {
                de.setValue("Esterno");
            } else {
                de.setValue("Interno");
            }
            e.add(de);
        }
        if (modalitaCompleta) {
            boolean showConnettore = this.core.isRegistroServiziLocale() && (this.pddCore.isPddEsterna(nomePdD) || multiTenant);
            de = new DataElement();
            if (showConnettore) {
                de.setUrl(SoggettiCostanti.SERVLET_NAME_SOGGETTI_ENDPOINT, new Parameter[]{new Parameter("id", "" + elem.getId())});
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            } else {
                de.setType(DataElementType.TEXT);
                de.setValue("-");
            }
            e.add(de);
        }
        de = new DataElement();
        de.setUrl("soggettiRuoliList.do", new Parameter[]{new Parameter("id", "" + elem.getId())});
        if (contaListe.booleanValue()) {
            ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
            this.soggettiCore.soggettiRuoliList(elem.getId(), (ISearch)searchForCount);
            int numRuoli = searchForCount.getNumEntries(Liste.SOGGETTI_RUOLI);
            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numRuoli));
        } else {
            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
        }
        e.add(de);
        if (modalitaCompleta) {
            de = new DataElement();
            if (pddEsterna) {
                de.setType(DataElementType.TEXT);
                de.setValue("-");
            } else {
                de.setUrl("serviziApplicativiList.do", new Parameter[]{new Parameter("provider", "" + elem.getId())});
                if (contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.setFilterRuoloServizioApplicativo((ISearch)searchForCount, Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO);
                    this.saCore.soggettiServizioApplicativoList((ISearch)searchForCount, elem.getId());
                    int numSA = searchForCount.getNumEntries(Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numSA));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
            }
            e.add(de);
        }
        if (modalitaCompleta) {
            de = new DataElement();
            if (pddEsterna) {
                de.setType(DataElementType.TEXT);
                de.setValue("-");
            } else {
                de.setUrl("porteApplicativeList.do", new Parameter[]{new Parameter("idsogg", "" + elem.getId())});
                if (contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.porteApplicativeCore.porteAppList(elem.getId().intValue(), (ISearch)searchForCount);
                    int numPA = searchForCount.getNumEntries(Liste.PORTE_APPLICATIVE_BY_SOGGETTO);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numPA));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
            }
            e.add(de);
            de = new DataElement();
            if (pddEsterna) {
                de.setType(DataElementType.TEXT);
                de.setValue("-");
            } else {
                de.setUrl("porteDelegateList.do", new Parameter[]{new Parameter("idsogg", "" + elem.getId())});
                if (contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.porteDelegateCore.porteDelegateList(elem.getId().intValue(), (ISearch)searchForCount);
                    int numPD = searchForCount.getNumEntries(Liste.PORTE_DELEGATE_BY_SOGGETTO);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numPD));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
            }
            e.add(de);
        }
        return e;
    }

    private void setLabelColonne(boolean modalitaCompleta, boolean multiTenant, boolean showProtocolli) {
        if (!modalitaCompleta) {
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("Soggetti");
            this.pd.setLabels(labels.toArray(new String[1]));
        } else {
            int totEl = 4;
            if (showProtocolli) {
                ++totEl;
            }
            if (multiTenant || this.pddCore.isGestionePddAbilitata(this)) {
                ++totEl;
            }
            if (modalitaCompleta) {
                ++totEl;
            }
            if (modalitaCompleta) {
                ++totEl;
            }
            String[] labels = new String[totEl];
            int i = 0;
            labels[i++] = "Nome";
            if (showProtocolli) {
                labels[i++] = "Profilo";
            }
            if (this.pddCore.isGestionePddAbilitata(this)) {
                labels[i++] = "Porta di Dominio";
            } else if (multiTenant) {
                labels[i++] = "Dominio";
            }
            if (modalitaCompleta) {
                labels[i++] = "Connettore";
            }
            labels[i++] = "Ruoli";
            if (modalitaCompleta) {
                labels[i++] = "Servizi Applicativi";
            }
            if (modalitaCompleta) {
                labels[i++] = "Porte Applicative";
                labels[i++] = "Porte Delegate";
            }
            this.pd.setLabels(labels);
        }
    }

    private List<DataElement> creaEntryCustom(boolean multiTenant, boolean showProtocolli, Iterator<Soggetto> it) throws DriverRegistroServiziException, DriverControlStationException, DriverControlStationNotFound, DriverConfigurazioneException {
        Soggetto elem = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(elem.getTipo());
        ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
        listaParametriChange.add(new Parameter("id", "" + elem.getId()));
        DataElement de = new DataElement();
        de.setUrl("soggettiChange.do", listaParametriChange.toArray(new Parameter[listaParametriChange.size()]));
        de.setValue(this.getLabelNomeSoggetto(protocollo, elem.getTipo(), elem.getNome()));
        de.setIdToRemove(elem.getId().toString());
        de.setToolTip(de.getValue());
        de.setType(DataElementType.TITLE);
        e.add(de);
        String nomePdD = elem.getPortaDominio();
        boolean pddEsterna = this.pddCore.isPddEsterna(nomePdD);
        if (showProtocolli || multiTenant) {
            boolean addMetadati = true;
            de = new DataElement();
            if (multiTenant) {
                String dominioLabel = "";
                dominioLabel = pddEsterna ? "Esterno" : "Interno";
                if (showProtocolli) {
                    String labelProtocollo = this.getLabelProtocollo(protocollo);
                    de.setValue(MessageFormat.format("Profilo Interoperabilit&agrave;: {0}, Dominio: {1}", labelProtocollo, dominioLabel));
                } else {
                    de.setValue(MessageFormat.format("Dominio: {0}", dominioLabel));
                }
            } else {
                String labelProtocollo = this.getLabelProtocollo(protocollo);
                de.setValue(MessageFormat.format("Profilo Interoperabilit&agrave;: {0}", labelProtocollo));
            }
            de.setType(DataElementType.SUBTITLE);
            if (addMetadati) {
                e.add(de);
            }
        }
        List<String> listaRuoli = this.soggettiCore.soggettiRuoliList(elem.getId(), (ISearch)new ConsoleSearch(true));
        for (int j = 0; j < listaRuoli.size(); ++j) {
            String ruolo = listaRuoli.get(j);
            de = new DataElement();
            de.setName("ruolo_" + j);
            de.setType(DataElementType.BUTTON);
            de.setLabel(ruolo);
            de.setStyleClass("ruolo-label-info-0");
            de.setUrl("soggettiRuoliList.do", new Parameter[]{new Parameter("id", "" + elem.getId())});
            de.setToolTip("Ruoli");
            e.add(de);
        }
        listaParametriChange.add(new Parameter("certVerFromLista", "true"));
        listaParametriChange.add(new Parameter("resetFromLista", "true"));
        String labelSoggetto = this.getLabelNomeSoggetto(protocollo, elem.getTipo(), elem.getNome());
        this.addInUsoButton(e, labelSoggetto, "" + elem.getId(), InUsoType.SOGGETTO);
        if (this.core.isSoggettiVerificaCertificati()) {
            boolean ssl = false;
            for (int i = 0; i < elem.sizeCredenzialiList(); ++i) {
                CredenzialiSoggetto c = elem.getCredenziali(i);
                if (!CredenzialeTipo.SSL.equals((Object)c.getTipo())) continue;
                ssl = true;
            }
            if (ssl) {
                this.addVerificaCertificatiButton(e, "soggettiVerificaCertificati.do", listaParametriChange);
            }
        }
        if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
            this.addComandoResetCacheButton(e, this.getLabelNomeSoggetto(protocollo, elem.getTipo(), elem.getNome()), "soggettiChange.do", listaParametriChange);
        }
        this.addProprietaOggettoButton(e, labelSoggetto, "" + elem.getId(), InUsoType.SOGGETTO);
        return e;
    }

    public void prepareSoggettiConfigList(List<org.openspcoop2.core.config.Soggetto> lista, ISearch ricerca) throws Exception {
        try {
            ExporterUtils exporterUtils;
            int totEl;
            List<String> nomiProprieta;
            String protocolloPerFiltroProprieta;
            List<String> protocolli;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"soggetti", (Parameter[])new Parameter[0]);
            Boolean contaListeObject = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            boolean contaListe = false;
            if (contaListeObject != null) {
                contaListe = contaListeObject;
            }
            int idLista = Liste.SOGGETTI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterProtocollo = this.addFilterProtocol(ricerca, idLista, true);
            String protocolloSel = filterProtocollo;
            if (protocolloSel == null && (protocolli = this.core.getProtocolli(this.request, this.session)) != null && protocolli.size() == 1) {
                protocolloSel = protocolli.get(0);
            }
            if ((protocolloPerFiltroProprieta = protocolloSel) == null) {
                protocolloPerFiltroProprieta = "".equals(filterProtocollo) ? null : filterProtocollo;
            }
            if ((nomiProprieta = this.nomiProprietaSoggetti(protocolloPerFiltroProprieta)) != null && !nomiProprieta.isEmpty()) {
                this.addFilterSubtitle("subtDatiProp", "Dati Propriet&agrave;", false);
                this.addFilterProprietaNome(ricerca, idLista, nomiProprieta);
                this.addFilterProprietaValore(ricerca, idLista, nomiProprieta);
                this.impostaAperturaSubtitle("subtDatiProp");
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Soggetti", "soggettiList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Soggetti", "soggettiList.do"), new Parameter("Risultati ricerca", null)});
            }
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            int n = totEl = this.isModalitaCompleta() ? 3 : 1;
            if (showProtocolli) {
                ++totEl;
            }
            if (this.isModalitaCompleta()) {
                ++totEl;
            }
            String[] labels = new String[totEl];
            int i = 0;
            labels[i++] = "Nome";
            if (showProtocolli) {
                labels[i++] = "Profilo";
            }
            if (this.isModalitaCompleta()) {
                labels[i++] = "Servizi Applicativi";
            }
            if (this.isModalitaCompleta()) {
                labels[i++] = "Porte Applicative";
                labels[i] = "Porte Delegate";
            }
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Soggetti", (String)search);
            }
            if (lista != null) {
                ListIterator<org.openspcoop2.core.config.Soggetto> it = lista.listIterator();
                while (it.hasNext()) {
                    ConsoleSearch searchForCount;
                    org.openspcoop2.core.config.Soggetto elem = (org.openspcoop2.core.config.Soggetto)it.next();
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + elem.getId())});
                    de.setValue(elem.getTipo() + "/" + elem.getNome());
                    de.setIdToRemove(elem.getId().toString());
                    de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
                    e.add(de);
                    if (showProtocolli) {
                        de = new DataElement();
                        de.setValue(this.getLabelProtocollo(this.soggettiCore.getProtocolloAssociatoTipoSoggetto(elem.getTipo())));
                        e.add(de);
                    }
                    if (this.isModalitaCompleta()) {
                        de = new DataElement();
                        de.setUrl("serviziApplicativiList.do", new Parameter[]{new Parameter("provider", "" + elem.getId())});
                        if (contaListe) {
                            searchForCount = new ConsoleSearch(true, 1);
                            this.setFilterRuoloServizioApplicativo((ISearch)searchForCount, Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO);
                            this.saCore.soggettiServizioApplicativoList((ISearch)searchForCount, elem.getId());
                            int numSA = searchForCount.getNumEntries(Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO);
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numSA));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        e.add(de);
                    }
                    if (this.isModalitaCompleta()) {
                        de = new DataElement();
                        de.setUrl("porteApplicativeList.do", new Parameter[]{new Parameter("idsogg", "" + elem.getId())});
                        if (contaListe) {
                            searchForCount = new ConsoleSearch(true, 1);
                            this.porteApplicativeCore.porteAppList(elem.getId().intValue(), (ISearch)searchForCount);
                            int numPA = searchForCount.getNumEntries(Liste.PORTE_APPLICATIVE_BY_SOGGETTO);
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numPA));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        e.add(de);
                        de = new DataElement();
                        de.setUrl("porteDelegateList.do", new Parameter[]{new Parameter("idsogg", "" + elem.getId())});
                        if (contaListe) {
                            searchForCount = new ConsoleSearch(true, 1);
                            this.porteDelegateCore.porteDelegateList(elem.getId().intValue(), (ISearch)searchForCount);
                            int numPD = searchForCount.getNumEntries(Liste.PORTE_DELEGATE_BY_SOGGETTO);
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numPD));
                        } else {
                            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                        }
                        e.add(de);
                    }
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(org.openspcoop2.protocol.sdk.constants.ArchiveType.SOGGETTO, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(SoggettiCostanti.LABEL_SOGGETTI_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception prepareSoggetti(Config)List: " + e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public boolean soggettiEndPointCheckData(TipoOperazione tipoOp, List<ExtendedConnettore> listExtendedConnettore, String tipoSoggetto, String nomeSoggetto) throws Exception {
        try {
            String id = this.getParameter("id");
            int idInt = 0;
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                idInt = Integer.parseInt(id);
            }
            String endpointtype = this.readEndPointType();
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoSoggetto);
            if (!this.endPointCheckData(null, protocollo, false, listExtendedConnettore)) {
                return false;
            }
            if (endpointtype.equals(TipiConnettore.DISABILITATO.toString())) {
                Soggetto soggetto = this.soggettiCore.getSoggettoRegistro(new IDSoggetto(tipoSoggetto, nomeSoggetto));
                if (this.pddCore.isPddEsterna(soggetto.getPortaDominio())) {
                    boolean trovatoServ = this.soggettiCore.existsSoggettoServiziWithoutConnettore(idInt);
                    if (trovatoServ) {
                        this.pd.setMessage("Il connettore deve essere specificato poich\u00e8 alcuni servizi del soggetto non hanno un connettore definito");
                        return false;
                    }
                } else {
                    boolean escludiSoggettiEsterni = true;
                    boolean trovatoServ = this.soggettiCore.existFruizioniServiziSoggettoWithoutConnettore(idInt, escludiSoggettiEsterni);
                    if (trovatoServ) {
                        this.pd.setMessage("Il connettore deve essere specificato poich\u00e8 alcune fruizioni dei servizi erogati dal soggetto non hanno un connettore definito");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void prepareRuoliList(ISearch ricerca, List<String> lista) throws Exception {
        try {
            String id = this.getParameter("id");
            String accessDaChangeTmp = this.getParameter("accessoDaChange");
            boolean accessDaChange = ServletUtils.isCheckBoxEnabled((String)accessDaChangeTmp);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"soggettiRuoli", (Parameter[])new Parameter[]{new Parameter("id", id), new Parameter("accessoDaChange", accessDaChangeTmp)});
            int idLista = Liste.SOGGETTI_RUOLI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            Soggetto soggettoRegistry = this.soggettiCore.getSoggettoRegistro(Long.parseLong(id));
            String tmpTitle = this.getLabelNomeSoggetto(new IDSoggetto(soggettoRegistry.getTipo(), soggettoRegistry.getNome()));
            if (accessDaChange) {
                ServletUtils.setPageDataTitleServletFirst((PageData)this.pd, (String)"Soggetti", (String)"soggettiList.do");
                ServletUtils.appendPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(tmpTitle, "soggettiChange.do", new Parameter[]{new Parameter("id", "" + soggettoRegistry.getId())})});
                ServletUtils.appendPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Ruoli", null)});
            } else {
                ServletUtils.setPageDataTitleServletChange((PageData)this.pd, (String)"Soggetti", (String)"soggettiList.do", (String)("Ruoli di " + tmpTitle));
            }
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Ruoli", (String)search);
            }
            String[] labels = new String[]{"Nome"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (String ruolo : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setValue(ruolo);
                    de.setIdToRemove(ruolo);
                    if (!this.isModalitaCompleta()) {
                        Ruolo ruoloObj = this.ruoliCore.getRuolo(ruolo);
                        Parameter pIdRuolo = new Parameter("ruoloId", "" + ruoloObj.getId());
                        String url = new Parameter("", "ruoliChange.do", new Parameter[]{pIdRuolo}).getValue();
                        String tooltip = ruolo;
                        this.newDataElementVisualizzaInNuovoTab(de, url, tooltip);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    private void addFilterTipoSoggetto(String tipoSoggetto, boolean postBack) throws Exception {
        try {
            String[] tmpLabels = SoggettiCostanti.getLabelsSoggettoRuoloTipo();
            String[] tmpValues = SoggettiCostanti.getValuesSoggettoRuoloTipo();
            String[] values = new String[tmpValues.length + 1];
            String[] labels = new String[tmpLabels.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < tmpLabels.length; ++i) {
                labels[i + 1] = tmpLabels[i];
                values[i + 1] = tmpValues[i];
            }
            String selectedValue = tipoSoggetto != null ? tipoSoggetto : "";
            String label = "Tipo";
            this.pd.addFilter("filtroTipoSoggetto", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void prepareSoggettiCredenzialiList(Soggetto soggettoRegistry, String id) throws Exception {
        try {
            ArrayList<Parameter> parametersServletSoggettoChange = new ArrayList<Parameter>();
            Parameter pIdSoggetto = new Parameter("id", id);
            parametersServletSoggettoChange.add(pIdSoggetto);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"soggettiCredenziali", (Parameter[])parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()]));
            this.pd.setIndex(0);
            this.pd.setPageSize(soggettoRegistry.sizeCredenzialiList());
            this.pd.setNumEntries(soggettoRegistry.sizeCredenzialiList());
            ServletUtils.disabledPageDataSearch((PageData)this.pd);
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggettoRegistry.getTipo());
            ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Soggetti", "soggettiList.do"), new Parameter(this.getLabelNomeSoggetto(protocollo, soggettoRegistry.getTipo(), soggettoRegistry.getNome()), "soggettiChange.do", parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()])), new Parameter("Certificati", null)});
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("Principale");
            labels.add("Subject");
            labels.add("Issuer");
            labels.add("Verifica");
            labels.add("Not Before");
            labels.add("Not After");
            this.pd.setLabels(labels.toArray(new String[1]));
            ArrayList dati = new ArrayList();
            List lista = soggettoRegistry.getCredenzialiList();
            ListIterator it = lista.listIterator();
            int i = 0;
            while (it.hasNext()) {
                ArrayList<DataElement> e = new ArrayList<DataElement>();
                CredenzialiSoggetto credenziali = (CredenzialiSoggetto)it.next();
                Certificate cSelezionato = ArchiveLoader.load((byte[])credenziali.getCertificate());
                String tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                String tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                boolean verificaTuttiCampi = credenziali.getCertificateStrictVerification();
                Date notBefore = cSelezionato.getCertificate().getNotBefore();
                String tipoCredenzialiSSLAliasCertificatoNotBefore = this.getSdfCredenziali().format(notBefore);
                Date notAfter = cSelezionato.getCertificate().getNotAfter();
                String tipoCredenzialiSSLAliasCertificatoNotAfter = this.getSdfCredenziali().format(notAfter);
                Parameter pIdCredenziale = new Parameter("idCred", "" + i);
                ArrayList<Parameter> parametersServletCredenzialeChange = new ArrayList<Parameter>();
                parametersServletCredenzialeChange.add(pIdCredenziale);
                parametersServletCredenzialeChange.addAll(parametersServletSoggettoChange);
                parametersServletCredenzialeChange.add(new Parameter("confSSLCredFileCertUpdate", "yes"));
                DataElement de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setValue(i == 0 ? "Si" : "No");
                de.allineaTdAlCentro();
                de.setWidthPx(60);
                e.add(de);
                de = new DataElement();
                de.setUrl("soggettiCredenzialiChange.do", parametersServletCredenzialeChange.toArray(new Parameter[parametersServletCredenzialeChange.size()]));
                de.setSize(60);
                de.setValue(StringEscapeUtils.escapeHtml4((String)tipoCredenzialiSSLAliasCertificatoSubject));
                de.setToolTip(StringEscapeUtils.escapeHtml4((String)tipoCredenzialiSSLAliasCertificatoSubject));
                de.setIdToRemove("" + i);
                e.add(de);
                de = new DataElement();
                Object issuerValue = StringEscapeUtils.escapeHtml4((String)tipoCredenzialiSSLAliasCertificatoIssuer);
                if (((String)issuerValue).length() > 60) {
                    issuerValue = ((String)issuerValue).substring(0, 57) + "...";
                }
                de.setValue((String)issuerValue);
                de.setToolTip(StringEscapeUtils.escapeHtml4((String)tipoCredenzialiSSLAliasCertificatoIssuer));
                e.add(de);
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setValue(verificaTuttiCampi ? "Certificato" : "Subject/Issuer");
                de.allineaTdAlCentro();
                de.setWidthPx(70);
                e.add(de);
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                if (verificaTuttiCampi) {
                    de.setValue(tipoCredenzialiSSLAliasCertificatoNotBefore);
                } else {
                    de.setValue("-");
                }
                de.allineaTdAlCentro();
                de.setWidthPx(140);
                if (notBefore.after(new Date())) {
                    de.setLabelStyleClass("spanNoEdit-bold");
                    de.setWidthPx(150);
                }
                e.add(de);
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                if (verificaTuttiCampi) {
                    de.setValue(tipoCredenzialiSSLAliasCertificatoNotAfter);
                } else {
                    de.setValue("-");
                }
                de.allineaTdAlCentro();
                de.setWidthPx(140);
                if (notAfter.before(new Date())) {
                    de.setLabelStyleClass("spanNoEdit-bold-red");
                    de.setWidthPx(150);
                }
                e.add(de);
                dati.add(e);
                ++i;
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public List<DataElement> addSoggettoHiddenToDati(List<DataElement> dati, String id, String nome, String tipo) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("id");
        de.setValue(id);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        if (nome != null) {
            de = new DataElement();
            de.setLabel("nomeprov");
            de.setValue(nome);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomeprov");
            dati.add(de);
        }
        if (tipo != null) {
            de = new DataElement();
            de.setLabel("tipoprov");
            de.setValue(tipo);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoprov");
            dati.add(de);
        }
        return dati;
    }

    public boolean soggettiCredenzialiCertificatiCheckData(TipoOperazione tipoOp, String id, Soggetto soggettoOld, int idxCertificato, String protocollo) throws Exception {
        try {
            Soggetto soggettoCheck;
            String tipoCredenzialiSSLConfigurazioneManualeSelfSigned;
            String tipoCredenzialiSSLSorgente;
            String tipoauth;
            int idInt = 0;
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                idInt = Integer.parseInt(id);
            }
            if ((tipoauth = this.getParameter("tipoauthCredenziali")) == null) {
                tipoauth = "nessuna";
            }
            String subject = this.getParameter("subjectCredenziali");
            String issuer = this.getParameter("subjectIssuer");
            if ("".equals(issuer)) {
                issuer = null;
            }
            if ((tipoCredenzialiSSLSorgente = this.getParameter("confSSLCredenziali")) == null) {
                tipoCredenzialiSSLSorgente = "confMan";
            }
            if ((tipoCredenzialiSSLConfigurazioneManualeSelfSigned = this.getParameter("confSSLManSS")) == null) {
                tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "yes";
            }
            boolean dominioEsternoModI = false;
            if (soggettoOld != null) {
                dominioEsternoModI = this.isProfiloModIPA(protocollo) && this.pddCore.isPddEsterna(soggettoOld.getPortaDominio());
            }
            String details = "";
            Soggetto soggettoAutenticato = null;
            String tipoSsl = null;
            Certificate cSelezionato = null;
            boolean strictVerifier = false;
            List<Soggetto> soggettiAutenticati = null;
            if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                soggettoAutenticato = this.soggettiCore.getSoggettoRegistroAutenticatoSsl(subject, issuer);
                tipoSsl = "subject/issuer";
            } else {
                BinaryParameter tipoCredenzialiSSLFileCertificato = this.getBinaryParameter("confSSLCredFileCert");
                String tipoCredenzialiSSLVerificaTuttiICampi = this.getParameter("confSSLCredVerifTutti");
                strictVerifier = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                String tipoCredenzialiSSLTipoArchivioS = this.getParameter("confSSLCredTipoArch");
                String tipoCredenzialiSSLFileCertificatoPassword = this.getParameter("confSSLCredFileCertPwd");
                String tipoCredenzialiSSLAliasCertificato = this.getParameter("confSSLCredAliasCert");
                if (tipoCredenzialiSSLAliasCertificato == null) {
                    tipoCredenzialiSSLAliasCertificato = "";
                }
                ArchiveType tipoCredenzialiSSLTipoArchivio = null;
                tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
                byte[] archivio = tipoCredenzialiSSLFileCertificato.getValue();
                if (TipoOperazione.CHANGE.equals((Object)tipoOp) && archivio == null) {
                    archivio = soggettoOld.getCredenziali(idxCertificato).getCertificate();
                }
                if ((soggettiAutenticati = this.soggettiCore.soggettoWithCredenzialiSslList((cSelezionato = tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER) ? ArchiveLoader.load((byte[])archivio) : ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])archivio, (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword)).getCertificate(), strictVerifier)) != null && !soggettiAutenticati.isEmpty()) {
                    List<Soggetto> soggettiAutenticatiCheck;
                    soggettoAutenticato = soggettiAutenticati.get(0);
                    if (!strictVerifier && ((soggettiAutenticatiCheck = this.soggettiCore.soggettoWithCredenzialiSslList(cSelezionato.getCertificate(), true)) == null || soggettiAutenticatiCheck.isEmpty())) {
                        details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                    }
                }
                tipoSsl = "certificato";
            }
            if (soggettoAutenticato != null && tipoOp.equals((Object)TipoOperazione.CHANGE) && (long)idInt == soggettoAutenticato.getId()) {
                soggettoAutenticato = null;
            }
            if (soggettoAutenticato != null) {
                String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                return false;
            }
            if (!this.soggettiCore.isSoggettiApplicativiCredenzialiSslPermitSameCredentials()) {
                details = "";
                List<ServizioApplicativo> saList = null;
                if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                    saList = this.saCore.servizioApplicativoWithCredenzialiSslList(subject, issuer, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                    tipoSsl = "subject/issuer";
                } else {
                    List<ServizioApplicativo> saListCheck;
                    saList = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), strictVerifier, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                    if (!(strictVerifier || saList == null || saList.isEmpty() || (saListCheck = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), true, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps())) != null && !saListCheck.isEmpty())) {
                        details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                    }
                    tipoSsl = "certificato";
                }
                if (saList != null) {
                    for (int i = 0; i < saList.size(); ++i) {
                        Credenziali c;
                        ServizioApplicativo sa = saList.get(i);
                        boolean tokenWithHttpsEnabledByConfigSA = false;
                        if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0 && (c = sa.getInvocazionePorta().getCredenziali(0)) != null && c.getTokenPolicy() != null && StringUtils.isNotEmpty((CharSequence)c.getTokenPolicy())) {
                            tokenWithHttpsEnabledByConfigSA = true;
                        }
                        if (tokenWithHttpsEnabledByConfigSA) continue;
                        String labelSoggetto = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                        this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto + ") possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                        return false;
                    }
                }
            }
            String actionConfirm = this.getParameter("actionConfirm");
            boolean promuoviInCorso = false;
            if (actionConfirm != null && actionConfirm.equals("ok")) {
                promuoviInCorso = true;
            }
            String aggiornatoCertificatoPrecaricatoTmp = this.getParameter("confSSLCredFileCertUpdate");
            boolean aggiornatoCertificatoPrecaricato = ServletUtils.isCheckBoxEnabled((String)aggiornatoCertificatoPrecaricatoTmp);
            if (!promuoviInCorso && !aggiornatoCertificatoPrecaricato && cSelezionato != null && soggettoOld != null && (soggettoCheck = soggettoOld).sizeCredenzialiList() > 0) {
                int i = 0;
                for (CredenzialiSoggetto c : soggettoCheck.getCredenzialiList()) {
                    Certificate check = ArchiveLoader.load((byte[])c.getCertificate());
                    if (check.getCertificate().equals((Object)cSelezionato.getCertificate()) && i != idxCertificato) {
                        this.pd.setMessage("Il certificato selezionato risulta gi\u00e0 associato al soggetto");
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void prepareSoggettiProprietaList(Soggetto soggettoRegistry, String id, ConsoleSearch ricerca, List<Proprieta> lista) throws DriverControlStationException {
        try {
            ArrayList<Parameter> parametersServletSoggettoChange = new ArrayList<Parameter>();
            Parameter pIdSoggetto = new Parameter("id", id);
            parametersServletSoggettoChange.add(pIdSoggetto);
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"soggettiProprieta", (Parameter[])parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()]));
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggettoRegistry.getTipo());
            int idLista = Liste.SOGGETTI_PROP;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
            lstParam.add(new Parameter(this.getLabelNomeSoggetto(protocollo, soggettoRegistry.getTipo(), soggettoRegistry.getNome()), "soggettiChange.do", parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()])));
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("Propriet&agrave;", null));
            } else {
                lstParam.add(new Parameter("Propriet&agrave;", "soggettiProprietaList.do", parametersServletSoggettoChange.toArray(new Parameter[parametersServletSoggettoChange.size()])));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])lstParam.toArray(new Parameter[lstParam.size()]));
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Propriet&agrave;", (String)search);
            }
            String valueLabel = "Valore";
            String[] labels = new String[]{"Nome", valueLabel};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Proprieta ssp : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Parameter pNomeProprieta = new Parameter("propNome", ssp.getNome());
                    ArrayList<Parameter> parametersServletProprietaChange = new ArrayList<Parameter>();
                    parametersServletProprietaChange.add(pNomeProprieta);
                    parametersServletProprietaChange.addAll(parametersServletSoggettoChange);
                    DataElement de = new DataElement();
                    de.setUrl("soggettiProprietaChange.do", parametersServletProprietaChange.toArray(new Parameter[parametersServletProprietaChange.size()]));
                    de.setValue(ssp.getNome());
                    de.setIdToRemove(ssp.getNome());
                    e.add(de);
                    de = new DataElement();
                    if (ssp.getValore() != null) {
                        if (StringUtils.isNotEmpty((CharSequence)ssp.getValore()) && BYOKManager.isEnabledBYOK() && this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(ssp.getValore())) {
                            de.setValue("******");
                        } else {
                            de.setValue(ssp.getValore());
                        }
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public List<DataElement> addProprietaToDati(TipoOperazione tipoOp, int size, String nome, String valore, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Propriet&agrave;");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("propNome");
        de.setSize(size);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("propValore");
        this.core.getLockUtilities().lockProperty(de, valore);
        de.setRequired(true);
        de.setSize(size);
        dati.add(de);
        return dati;
    }

    public boolean soggettiProprietaCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String id = this.getParameter("id");
            int idSogg = Integer.parseInt(id);
            String nome = this.getParameter("propNome");
            String valore = this.getLockedParameter("propValore", false);
            if (nome.equals("") || valore.equals("")) {
                Object tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                if (valore.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Valore" : (String)tmpElenco + ", Valore";
                }
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", tmpElenco));
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (!this.core.getDriverBYOKUtilities().isEnabledBYOK() || !this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(valore)) {
                if (valore.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (!this.checkLength4000(valore, "Valore")) {
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato = false;
                Soggetto soggettoRegistry = this.soggettiCore.getSoggettoRegistro(idSogg);
                String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(soggettoRegistry.getTipo());
                String nomeporta = this.getLabelNomeSoggetto(protocollo, soggettoRegistry.getTipo(), soggettoRegistry.getNome());
                for (int i = 0; i < soggettoRegistry.sizeProprietaList(); ++i) {
                    Proprieta tmpProp = soggettoRegistry.getProprieta(i);
                    if (!nome.equals(tmpProp.getNome())) continue;
                    giaRegistrato = true;
                    break;
                }
                if (giaRegistrato) {
                    this.pd.setMessage(MessageFormat.format("La propriet&agrave; {0} &egrave; gi&agrave; stata associata all''applicativo {1}", nome, nomeporta));
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }
}

