/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utenti;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class UtentiSoggettiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            UtentiHelper utentiHelper = new UtentiHelper(request, pd, session);
            utentiHelper.makeMenu();
            String nomesu = utentiHelper.getParameter("nomesu");
            String soggetto = utentiHelper.getParameter("soggetto");
            String protocollo = utentiHelper.getParameter("protocollo");
            UtentiCore utentiCore = new UtentiCore();
            SoggettiCore soggettiCore = new SoggettiCore(utentiCore);
            User user = utentiCore.getUser(nomesu);
            ConsoleSearch searchSoggetti = new ConsoleSearch(true);
            List protocolli = user.getProtocolliSupportati();
            if (protocollo == null && protocolli != null && !protocolli.isEmpty()) {
                protocollo = utentiCore.getProtocolloDefault(request, null, protocolli);
            }
            searchSoggetti.addFilter(Liste.SOGGETTI, "filtroProtocollo", protocollo);
            searchSoggetti.addFilter(Liste.SOGGETTI, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
            List<Soggetto> listaSoggettiRegistro = soggettiCore.soggettiRegistroList(null, (ISearch)searchSoggetti);
            ArrayList<Soggetto> listaSoggettiNonUtilizzati = new ArrayList<Soggetto>();
            for (Soggetto sog : listaSoggettiRegistro) {
                boolean found = false;
                for (IDSoggetto idSog : user.getSoggetti()) {
                    if (!sog.getTipo().equals(idSog.getTipo()) || !sog.getNome().equals(idSog.getNome()) || !sog.getIdentificativoPorta().equals(idSog.getCodicePorta())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                listaSoggettiNonUtilizzati.add(sog);
            }
            String[] soggettiLabels = new String[listaSoggettiNonUtilizzati.size() + 1];
            String[] soggettiValues = new String[listaSoggettiNonUtilizzati.size() + 1];
            soggettiLabels[0] = "--";
            soggettiValues[0] = "-";
            for (int i = 0; i < listaSoggettiNonUtilizzati.size(); ++i) {
                Soggetto soggetto2 = (Soggetto)listaSoggettiNonUtilizzati.get(i);
                String protocolloTmp = soggettiCore.getProtocolloAssociatoTipoSoggetto(soggetto2.getTipo());
                soggettiLabels[i + 1] = utentiHelper.getLabelNomeSoggetto(protocolloTmp, soggetto2.getTipo(), soggetto2.getNome());
                soggettiValues[i + 1] = "" + soggetto2.getId();
            }
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Utenti", "utentiList.do"));
            lstParam.add(new Parameter(nomesu, "utentiChange.do", new Parameter[]{new Parameter("nomesu", nomesu)}));
            lstParam.add(new Parameter("Soggetti", "utentiSoggettiList.do", new Parameter[]{new Parameter("nomesu", nomesu)}));
            lstParam.add(ServletUtils.getParameterAggiungi());
            if (utentiHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (soggetto == null) {
                    soggetto = "";
                }
                if (listaSoggettiNonUtilizzati.isEmpty()) {
                    if (protocolli.size() == 1) {
                        pd.setMessage("Non esistono altri soggetti associabili all'utente", MessageType.INFO);
                        pd.disableEditMode();
                        pd.setDati(dati);
                        ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                        return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"utentiSoggetti", (ForwardParams)ForwardParams.ADD());
                    }
                    String msf = MessageFormat.format(UtentiCostanti.LABEL_UTENTI_SOGGETTI_DISPONIBILI_ESAURITI_PER_LA_MODALITA_XX, utentiHelper.getLabelProtocollo(protocollo));
                    pd.setMessage(msf, MessageType.INFO);
                    pd.disableOnlyButton();
                }
                utentiHelper.addUtentiSoggettiToDati(dati, TipoOperazione.ADD, nomesu, soggetto, soggettiValues, soggettiLabels, protocolli, protocollo);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"utentiSoggetti", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = utentiHelper.utentiSoggettiCheckData(TipoOperazione.ADD, nomesu, soggetto);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                utentiHelper.addUtentiSoggettiToDati(dati, TipoOperazione.ADD, nomesu, soggetto, soggettiValues, soggettiLabels, protocolli, protocollo);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"utentiSoggetti", (ForwardParams)ForwardParams.ADD());
            }
            Long newId = Long.parseLong(soggetto);
            IDSoggetto idSoggetto = soggettiCore.getIdSoggettoRegistro(newId);
            user.getSoggetti().add(idSoggetto);
            utentiCore.performUpdateOperation(userLogin, utentiHelper.smista(), user);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.UTENTI_SOGGETTI;
            ricerca = utentiHelper.checkSearchParameters(idLista, ricerca);
            List<IDSoggetto> lista = utentiCore.utentiSoggettiList(nomesu, (ISearch)ricerca);
            utentiHelper.prepareUtentiSoggettiList(ricerca, lista, user);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"utentiSoggetti", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"utentiSoggetti", (ForwardParams)ForwardParams.ADD());
        }
    }
}

