/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utils;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.ProprietaOggettoSintetico;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.utils.UtilsHelper;
import org.openspcoop2.web.lib.mvc.PageData;

public class ProprietaOggettoRegistro
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)baos);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la ricerca delle informazioni oggetto: " + e.getMessage(), e);
            return;
        }
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        block33: {
            try (ByteArrayOutputStream baosPayload = new ByteArrayOutputStream();){
                HttpRequestMethod httpRequestMethod = HttpRequestMethod.valueOf((String)request.getMethod().toUpperCase());
                if (httpRequestMethod.equals((Object)HttpRequestMethod.POST)) {
                    IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)baosPayload);
                }
                HttpSession session = request.getSession(true);
                PageData pd = new PageData();
                UtilsHelper registroHelper = new UtilsHelper(request, pd, session);
                ArchiviCore archiviCore = new ArchiviCore();
                AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(archiviCore);
                AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(archiviCore);
                SoggettiCore soggettiCore = new SoggettiCore(archiviCore);
                ServiziApplicativiCore saCore = new ServiziApplicativiCore(archiviCore);
                RuoliCore ruoliCore = new RuoliCore(archiviCore);
                ScopeCore scopeCore = new ScopeCore(archiviCore);
                ConfigurazioneCore confCore = new ConfigurazioneCore(archiviCore);
                GruppiCore gruppiCore = new GruppiCore(archiviCore);
                PorteApplicativeCore paCore = new PorteApplicativeCore(archiviCore);
                PorteDelegateCore pdCore = new PorteDelegateCore(archiviCore);
                String identificativoOggetto = registroHelper.getParameter("idOggetto");
                String tipoOggetto = registroHelper.getParameter("tipoOggetto");
                String tipoRisposta = registroHelper.getParameter("tipoRisposta");
                InUsoType inUsoType = InUsoType.valueOf(tipoOggetto);
                ExporterUtils exporterUtils = new ExporterUtils(archiviCore);
                List<IDAccordo> identificativi = null;
                ArrayList<String> risultatiRicerca = new ArrayList<String>();
                block3 : switch (inUsoType) {
                    case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                        identificativi = exporterUtils.getIdsAccordiServizioParteComune(identificativoOggetto);
                        Iterator<IDAccordo> iterator = identificativi.iterator();
                        while (iterator.hasNext()) {
                            IDAccordo object;
                            IDAccordo idAccordo = object = iterator.next();
                            AccordoServizioParteComuneSintetico as = apcCore.getAccordoServizioSintetico(idAccordo);
                            risultatiRicerca.add(this.getProprieta(as.getProprietaOggetto(), as.getDescrizione()));
                        }
                        break;
                    }
                    case SERVIZIO_APPLICATIVO: {
                        identificativi = exporterUtils.getIdsServiziApplicativi(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDServizioApplicativo idServizioApplicativo = (IDServizioApplicativo)object;
                            ServizioApplicativo sa = saCore.getServizioApplicativo(idServizioApplicativo);
                            risultatiRicerca.add(this.getProprieta(sa.getProprietaOggetto(), sa.getDescrizione()));
                        }
                        break;
                    }
                    case SOGGETTO: {
                        identificativi = exporterUtils.getIdsSoggetti(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDSoggetto idSoggetto = (IDSoggetto)object;
                            Soggetto soggetto = soggettiCore.getSoggettoRegistro(idSoggetto);
                            risultatiRicerca.add(this.getProprieta(soggetto.getProprietaOggetto(), soggetto.getDescrizione()));
                        }
                        break;
                    }
                    case RUOLO: {
                        identificativi = exporterUtils.getIdsRuoli(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDRuolo idRuolo = (IDRuolo)object;
                            Ruolo ruolo = ruoliCore.getRuolo(idRuolo.getNome());
                            risultatiRicerca.add(this.getProprieta(ruolo.getProprietaOggetto(), ruolo.getDescrizione()));
                        }
                        break;
                    }
                    case SCOPE: {
                        identificativi = exporterUtils.getIdsScope(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDScope idScope = (IDScope)object;
                            Scope scope = scopeCore.getScope(idScope.getNome());
                            risultatiRicerca.add(this.getProprieta(scope.getProprietaOggetto(), scope.getDescrizione()));
                        }
                        break;
                    }
                    case GRUPPO: {
                        identificativi = exporterUtils.getIdsGruppi(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            IDGruppo idGruppo = (IDGruppo)object;
                            Gruppo gruppo = gruppiCore.getGruppo(idGruppo.getNome());
                            risultatiRicerca.add(this.getProprieta(gruppo.getProprietaOggetto(), gruppo.getDescrizione()));
                        }
                        break;
                    }
                    case TOKEN_POLICY: {
                        IDGenericProperties idGP;
                        identificativi = exporterUtils.getIdsTokenPolicy(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            idGP = (IDGenericProperties)object;
                            GenericProperties gp = confCore.getGenericProperties(idGP.getNome(), idGP.getTipologia(), false);
                            risultatiRicerca.add(this.getProprieta(gp.getProprietaOggetto(), gp.getDescrizione()));
                        }
                        break;
                    }
                    case ATTRIBUTE_AUTHORITY: {
                        IDGenericProperties idGP;
                        identificativi = exporterUtils.getIdsAttributeAuthority(identificativoOggetto);
                        for (IDAccordo object : identificativi) {
                            idGP = (IDGenericProperties)object;
                            GenericProperties gp = confCore.getGenericProperties(idGP.getNome(), idGP.getTipologia(), false);
                            risultatiRicerca.add(this.getProprieta(gp.getProprietaOggetto(), gp.getDescrizione()));
                        }
                        break;
                    }
                    case EROGAZIONE: {
                        String uriAPSerogata = identificativoOggetto;
                        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromUri(uriAPSerogata);
                        AccordoServizioParteSpecifica as = apsCore.getAccordoServizioParteSpecifica(idServizio);
                        org.openspcoop2.core.registry.ProprietaOggetto p = as.getProprietaOggetto();
                        p = ProprietaOggettoRegistro.mergeProprietaOggetto(p, idServizio, paCore, saCore, (ConsoleHelper)registroHelper);
                        risultatiRicerca.add(this.getProprieta(p, as.getDescrizione()));
                        break;
                    }
                    case FRUIZIONE: {
                        String uriAPSfruita = identificativoOggetto;
                        if (uriAPSfruita.contains("@")) {
                            String tipoNomeFruitore = uriAPSfruita.split("@")[1];
                            uriAPSfruita = uriAPSfruita.split("@")[0];
                            IDSoggetto idSoggettoFruitore = new IDSoggetto(tipoNomeFruitore.split("/")[0], tipoNomeFruitore.split("/")[1]);
                            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromUri(uriAPSfruita);
                            AccordoServizioParteSpecifica as = apsCore.getAccordoServizioParteSpecifica(idServizio);
                            for (Fruitore fruitore : as.getFruitoreList()) {
                                if (!idSoggettoFruitore.getTipo().equals(fruitore.getTipo()) || !idSoggettoFruitore.getNome().equals(fruitore.getNome())) continue;
                                org.openspcoop2.core.registry.ProprietaOggetto p = fruitore.getProprietaOggetto();
                                p = ProprietaOggettoRegistro.mergeProprietaOggetto(p, idServizio, idSoggettoFruitore, pdCore, (ConsoleHelper)registroHelper);
                                risultatiRicerca.add(this.getProprieta(p, fruitore.getDescrizione()));
                                break block3;
                            }
                            break;
                        }
                        risultatiRicerca.add("Internal Error: informazione fruitore non presente");
                        break;
                    }
                    case RISORSA: 
                    case PORT_TYPE: 
                    case OPERAZIONE: 
                    case CANALE: 
                    case ACCORDO_COOPERAZIONE: 
                    case ACCORDO_SERVIZIO_COMPOSTO: 
                    case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                    case EROGAZIONE_INFO: 
                    case FRUITORE: 
                    case FRUIZIONE_INFO: 
                    case PDD: 
                    case PORTA_APPLICATIVA: 
                    case PORTA_DELEGATA: 
                    case RATE_LIMITING_POLICY: 
                    case PLUGIN_CLASSE: {
                        throw new CoreException("TipoOggetto non gestito.");
                    }
                }
                ServletOutputStream outputStream = response.getOutputStream();
                if (tipoRisposta.equalsIgnoreCase("json")) {
                    response.setContentType("application/json");
                    JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                    HashMap<String, ArrayList<String>> mapResult = new HashMap<String, ArrayList<String>>();
                    mapResult.put("uso", risultatiRicerca);
                    jsonUtils.writeTo(mapResult, (OutputStream)outputStream);
                    break block33;
                }
                if (tipoRisposta.equalsIgnoreCase("text")) {
                    response.setContentType("text/plain");
                    outputStream.write(StringUtils.join((Object[])risultatiRicerca.toArray(new String[1])).getBytes());
                    break block33;
                }
                throw new CoreException("TipoRiposta non gestito.");
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la ricerca delle informazioni oggetto: " + e.getMessage(), e);
            }
        }
    }

    public static org.openspcoop2.core.registry.ProprietaOggetto mergeProprietaOggetto(org.openspcoop2.core.registry.ProprietaOggetto p, IDServizio idServizio, PorteApplicativeCore paCore, ServiziApplicativiCore saCore, ConsoleHelper consoleHelper) {
        List<IDPortaApplicativa> listPA = ProprietaOggettoRegistro.getIDPorteApplicativeAssociateSafe(paCore, idServizio);
        if (listPA != null && !listPA.isEmpty()) {
            for (IDPortaApplicativa idPA : listPA) {
                PortaApplicativa pa;
                if (idPA == null || (pa = ProprietaOggettoRegistro.getPASafe(paCore, idPA)) == null) continue;
                p = ProprietaOggettoRegistro.mergeProprietaOggetto(p, idServizio, pa, saCore, consoleHelper);
            }
        }
        return p;
    }

    private static org.openspcoop2.core.registry.ProprietaOggetto mergeProprietaOggetto(org.openspcoop2.core.registry.ProprietaOggetto p, IDServizio idServizio, PortaApplicativa pa, ServiziApplicativiCore saCore, ConsoleHelper consoleHelper) {
        if (pa != null) {
            boolean consideraDataCreazioneComeDataModifica = true;
            p = consoleHelper.mergeProprietaOggetto(p, pa.getProprietaOggetto(), consideraDataCreazioneComeDataModifica);
            if (pa.sizeServizioApplicativoList() > 0) {
                for (PortaApplicativaServizioApplicativo pasa : pa.getServizioApplicativoList()) {
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setIdSoggettoProprietario(idServizio.getSoggettoErogatore());
                    idSA.setNome(pasa.getNome());
                    ServizioApplicativo sa = ProprietaOggettoRegistro.getSASafe(saCore, idSA);
                    if (sa == null || "server".equals(sa.getTipo())) continue;
                    p = consoleHelper.mergeProprietaOggetto(p, sa.getProprietaOggetto(), !consideraDataCreazioneComeDataModifica);
                }
            }
        }
        return p;
    }

    public static org.openspcoop2.core.registry.ProprietaOggetto mergeProprietaOggetto(org.openspcoop2.core.registry.ProprietaOggetto p, IDServizio idServizio, IDSoggetto idSoggettoFruitore, PorteDelegateCore pdCore, ConsoleHelper consoleHelper) {
        List<IDPortaDelegata> listPD = ProprietaOggettoRegistro.getIDPorteDelegateAssociateSafe(pdCore, idServizio, idSoggettoFruitore);
        if (listPD != null && !listPD.isEmpty()) {
            for (IDPortaDelegata idPD : listPD) {
                PortaDelegata pd;
                if (idPD == null || (pd = ProprietaOggettoRegistro.getPDSafe(pdCore, idPD)) == null) continue;
                p = ProprietaOggettoRegistro.mergeProprietaOggetto(p, idServizio, idSoggettoFruitore, pd, consoleHelper);
            }
        }
        return p;
    }

    private static org.openspcoop2.core.registry.ProprietaOggetto mergeProprietaOggetto(org.openspcoop2.core.registry.ProprietaOggetto p, IDServizio idServizio, IDSoggetto idSoggettoFruitore, PortaDelegata pd, ConsoleHelper consoleHelper) {
        if (idServizio == null || idSoggettoFruitore != null) {
            // empty if block
        }
        if (pd != null) {
            boolean consideraDataCreazioneComeDataModifica = true;
            p = consoleHelper.mergeProprietaOggetto(p, pd.getProprietaOggetto(), consideraDataCreazioneComeDataModifica);
        }
        return p;
    }

    private static List<IDPortaApplicativa> getIDPorteApplicativeAssociateSafe(PorteApplicativeCore paCore, IDServizio idServizio) {
        List<IDPortaApplicativa> l = null;
        try {
            l = paCore.getIDPorteApplicativeAssociate(idServizio);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero delle porte applicative associate al servizio '" + String.valueOf(idServizio) + "': " + e.getMessage(), e);
        }
        return l;
    }

    private static List<IDPortaDelegata> getIDPorteDelegateAssociateSafe(PorteDelegateCore pdCore, IDServizio idServizio, IDSoggetto idFruitore) {
        List<IDPortaDelegata> l = null;
        try {
            l = pdCore.getIDPorteDelegateAssociate(idServizio, idFruitore);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero delle porte delegate associate al servizio '" + String.valueOf(idServizio) + "': " + e.getMessage(), e);
        }
        return l;
    }

    private static PortaApplicativa getPASafe(PorteApplicativeCore paCore, IDPortaApplicativa idPA) {
        try {
            return paCore.getPortaApplicativa(idPA);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero della porta applicativa '" + String.valueOf(idPA) + "': " + e.getMessage(), e);
            return null;
        }
    }

    private static PortaDelegata getPDSafe(PorteDelegateCore pdCore, IDPortaDelegata idPD) {
        try {
            return pdCore.getPortaDelegata(idPD);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero della porta delegata '" + String.valueOf(idPD) + "': " + e.getMessage(), e);
            return null;
        }
    }

    private static ServizioApplicativo getSASafe(ServiziApplicativiCore saCore, IDServizioApplicativo idSA) {
        try {
            return saCore.getServizioApplicativo(idSA);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero dell'applicativo '" + String.valueOf(idSA) + "': " + e.getMessage(), e);
            return null;
        }
    }

    public static ProprietaOggetto getProprietaOggettoSafe(PorteApplicativeCore paCore, IDPortaApplicativa idPA) {
        try {
            return paCore.getProprietaOggetto(idPA);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero della porta applicativa '" + String.valueOf(idPA) + "': " + e.getMessage(), e);
            return null;
        }
    }

    public static ProprietaOggetto getProprietaOggettoSafe(PorteDelegateCore pdCore, IDPortaDelegata idPD) {
        try {
            return pdCore.getProprietaOggetto(idPD);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero della porta delegata '" + String.valueOf(idPD) + "': " + e.getMessage(), e);
            return null;
        }
    }

    public static ProprietaOggetto getProprietaOggettoSafe(ServiziApplicativiCore saCore, IDServizioApplicativo idSA) {
        try {
            return saCore.getProprietaOggetto(idSA);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il recupero dell'applicativo '" + String.valueOf(idSA) + "': " + e.getMessage(), e);
            return null;
        }
    }

    private String getProprieta(ProprietaOggettoSintetico p, String descrizione) {
        return this.getProprieta(p != null ? p.getUtenteRichiedente() : null, p != null ? p.getDataCreazione() : null, p != null ? p.getUtenteUltimaModifica() : null, p != null ? p.getDataUltimaModifica() : null, descrizione);
    }

    private String getProprieta(org.openspcoop2.core.registry.ProprietaOggetto p, String descrizione) {
        return this.getProprieta(p != null ? p.getUtenteRichiedente() : null, p != null ? p.getDataCreazione() : null, p != null ? p.getUtenteUltimaModifica() : null, p != null ? p.getDataUltimaModifica() : null, descrizione);
    }

    private String getProprieta(ProprietaOggetto p, String descrizione) {
        return this.getProprieta(p != null ? p.getUtenteRichiedente() : null, p != null ? p.getDataCreazione() : null, p != null ? p.getUtenteUltimaModifica() : null, p != null ? p.getDataUltimaModifica() : null, descrizione);
    }

    private String getProprieta(String utenteRichiedente, Date dataCreazione, String utenteUtimaModifica, Date dataUtimaModifica, String descrizione) {
        String dataMs;
        StringBuilder sb = new StringBuilder();
        if (dataCreazione != null) {
            dataMs = CostantiControlStation.formatDateMs(dataCreazione);
            sb.append("Data Creazione").append(": ").append(dataMs);
        }
        if (utenteRichiedente != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Utente Richiedente").append(": ").append(utenteRichiedente);
        }
        if (dataUtimaModifica != null) {
            dataMs = CostantiControlStation.formatDateMs(dataUtimaModifica);
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append("Data Ultima Modifica").append(": ").append(dataMs);
        }
        if (utenteUtimaModifica != null) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Utente Ultima Modifica").append(": ").append(utenteUtimaModifica);
        }
        if (descrizione != null && StringUtils.isNotEmpty((CharSequence)descrizione)) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append("Descrizione").append(": \n");
            sb.append(descrizione);
        }
        if (sb.length() <= 0) {
            sb.append("Nessuna propriet\u00e0 disponibile");
        }
        return sb.toString();
    }
}

