/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.allarmi.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.AllarmeNotifica;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeNotificaServiceSearchImpl;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCAllarmeServiceSearch;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.beans.UpdateModel;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceCRUDWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.NullByteTextColumnSanitizer;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCAllarmeNotificaServiceImpl
extends JDBCAllarmeNotificaServiceSearchImpl
implements IJDBCServiceCRUDWithoutId<AllarmeNotifica, JDBCServiceManager> {
    private static void sanitizeTextColumns(TipiDatabase dbType, AllarmeNotifica allarmeNotifica) {
        allarmeNotifica.setOldDettaglioStato(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)allarmeNotifica.getOldDettaglioStato()));
        allarmeNotifica.setNuovoDettaglioStato(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)allarmeNotifica.getNuovoDettaglioStato()));
        allarmeNotifica.setHistoryEntry(NullByteTextColumnSanitizer.sanitize((TipiDatabase)dbType, (String)allarmeNotifica.getHistoryEntry()));
    }

    public void create(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeNotifica allarmeNotifica, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (NullByteTextColumnSanitizer.needsSanitization((TipiDatabase)jdbcProperties.getDatabase())) {
            JDBCAllarmeNotificaServiceImpl.sanitizeTextColumns(jdbcProperties.getDatabase(), allarmeNotifica);
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        Long idAllarme = null;
        IdAllarme idLogicAllarme = null;
        idLogicAllarme = allarmeNotifica.getIdAllarme();
        if (idLogicAllarme != null) {
            if (idMappingResolutionBehaviour == null || IDMappingBehaviour.ENABLED.equals((Object)idMappingResolutionBehaviour)) {
                idAllarme = ((JDBCAllarmeServiceSearch)this.getServiceManager().getAllarmeServiceSearch()).findTableId(idLogicAllarme, false);
            } else if (IDMappingBehaviour.USE_TABLE_ID.equals((Object)idMappingResolutionBehaviour) && ((idAllarme = idLogicAllarme.getId()) == null || idAllarme <= 0L)) {
                throw new Exception("Logic id not contains table id");
            }
        } else {
            throw new ServiceException("IdAllarme not defined");
        }
        sqlQueryObjectInsert.addInsertTable(this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()));
        sqlQueryObjectInsert.addInsertField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().DATA_NOTIFICA, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().OLD_STATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().OLD_DETTAGLIO_STATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().NUOVO_STATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().NUOVO_DETTAGLIO_STATO, false), "?");
        sqlQueryObjectInsert.addInsertField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().HISTORY_ENTRY, false), "?");
        sqlQueryObjectInsert.addInsertField("id_allarme", "?");
        IKeyGeneratorObject keyGenerator = this.getAllarmeNotificaFetch().getKeyGeneratorObject((IModel<?>)AllarmeNotifica.model());
        long id = jdbcUtilities.insertAndReturnGeneratedKey(sqlQueryObjectInsert, keyGenerator, jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)allarmeNotifica.getDataNotifica(), AllarmeNotifica.model().DATA_NOTIFICA.getFieldType()), new JDBCObject((Object)allarmeNotifica.getOldStato(), AllarmeNotifica.model().OLD_STATO.getFieldType()), new JDBCObject((Object)allarmeNotifica.getOldDettaglioStato(), AllarmeNotifica.model().OLD_DETTAGLIO_STATO.getFieldType()), new JDBCObject((Object)allarmeNotifica.getNuovoStato(), AllarmeNotifica.model().NUOVO_STATO.getFieldType()), new JDBCObject((Object)allarmeNotifica.getNuovoDettaglioStato(), AllarmeNotifica.model().NUOVO_DETTAGLIO_STATO.getFieldType()), new JDBCObject((Object)allarmeNotifica.getHistoryEntry(), AllarmeNotifica.model().HISTORY_ENTRY.getFieldType()), new JDBCObject((Object)idAllarme, Long.class)});
        allarmeNotifica.setId(id);
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeNotifica allarmeNotifica, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long tableId = allarmeNotifica.getId();
        if (tableId == null || tableId <= 0L) {
            throw new Exception("Retrieve tableId failed");
        }
        this.update(jdbcProperties, log, connection, sqlQueryObject, (long)tableId, allarmeNotifica, idMappingResolutionBehaviour);
    }

    public void update(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, AllarmeNotifica allarmeNotifica, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (NullByteTextColumnSanitizer.needsSanitization((TipiDatabase)jdbcProperties.getDatabase())) {
            JDBCAllarmeNotificaServiceImpl.sanitizeTextColumns(jdbcProperties.getDatabase(), allarmeNotifica);
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectInsert = sqlQueryObject.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObjectInsert.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObjectDelete.newSQLQueryObject();
        ISQLQueryObject sqlQueryObjectUpdate = sqlQueryObjectGet.newSQLQueryObject();
        boolean setIdMappingResolutionBehaviour = idMappingResolutionBehaviour == null || IDMappingBehaviour.ENABLED.equals((Object)idMappingResolutionBehaviour) || IDMappingBehaviour.USE_TABLE_ID.equals((Object)idMappingResolutionBehaviour);
        Long idAllarme = null;
        IdAllarme idLogicAllarme = null;
        idLogicAllarme = allarmeNotifica.getIdAllarme();
        if (idLogicAllarme != null) {
            if (idMappingResolutionBehaviour == null || IDMappingBehaviour.ENABLED.equals((Object)idMappingResolutionBehaviour)) {
                idAllarme = ((JDBCAllarmeServiceSearch)this.getServiceManager().getAllarmeServiceSearch()).findTableId(idLogicAllarme, false);
            } else if (IDMappingBehaviour.USE_TABLE_ID.equals((Object)idMappingResolutionBehaviour) && ((idAllarme = idLogicAllarme.getId()) == null || idAllarme <= 0L)) {
                throw new Exception("Logic id not contains table id");
            }
        } else {
            throw new ServiceException("IdAllarme not defined");
        }
        sqlQueryObjectUpdate.setANDLogicOperator(true);
        sqlQueryObjectUpdate.addUpdateTable(this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()));
        boolean isUpdate = true;
        ArrayList<JDBCObject> lstObjects = new ArrayList<JDBCObject>();
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().DATA_NOTIFICA, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeNotifica.getDataNotifica(), AllarmeNotifica.model().DATA_NOTIFICA.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().OLD_STATO, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeNotifica.getOldStato(), AllarmeNotifica.model().OLD_STATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().OLD_DETTAGLIO_STATO, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeNotifica.getOldDettaglioStato(), AllarmeNotifica.model().OLD_DETTAGLIO_STATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().NUOVO_STATO, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeNotifica.getNuovoStato(), AllarmeNotifica.model().NUOVO_STATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().NUOVO_DETTAGLIO_STATO, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeNotifica.getNuovoDettaglioStato(), AllarmeNotifica.model().NUOVO_DETTAGLIO_STATO.getFieldType()));
        sqlQueryObjectUpdate.addUpdateField(this.getAllarmeNotificaFieldConverter().toColumn(AllarmeNotifica.model().HISTORY_ENTRY, false), "?");
        lstObjects.add(new JDBCObject((Object)allarmeNotifica.getHistoryEntry(), AllarmeNotifica.model().HISTORY_ENTRY.getFieldType()));
        if (setIdMappingResolutionBehaviour) {
            sqlQueryObjectUpdate.addUpdateField("id_allarme", "?");
        }
        if (setIdMappingResolutionBehaviour) {
            lstObjects.add(new JDBCObject((Object)idAllarme, Long.class));
        }
        sqlQueryObjectUpdate.addWhereCondition("id=?");
        lstObjects.add(new JDBCObject((Object)tableId, Long.class));
        if (isUpdate) {
            jdbcUtilities.executeUpdate(sqlQueryObjectUpdate.createSQLUpdate(), jdbcProperties.isShowSql(), lstObjects.toArray(new JDBCObject[0]));
        }
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeNotifica allarmeNotifica, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, allarmeNotifica), (ISQLFieldConverter)this.getAllarmeNotificaFieldConverter(), (IJDBCServiceSearchWithoutId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeNotifica allarmeNotifica, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, allarmeNotifica), (ISQLFieldConverter)this.getAllarmeNotificaFieldConverter(), (IJDBCServiceSearchWithoutId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeNotifica allarmeNotifica, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()), this.getMapTableToPKColumnEngine(), this.getRootTablePrimaryKeyValuesEngine(jdbcProperties, log, connection, sqlQueryObject, allarmeNotifica), (ISQLFieldConverter)this.getAllarmeNotificaFieldConverter(), (IJDBCServiceSearchWithoutId)this, (UpdateModel[])updateModels);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getAllarmeNotificaFieldConverter(), (IJDBCServiceSearchWithoutId)this, null, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IExpression condition, UpdateField ... updateFields) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getAllarmeNotificaFieldConverter(), (IJDBCServiceSearchWithoutId)this, (IExpression)condition, (UpdateField[])updateFields);
    }

    public void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, UpdateModel ... updateModels) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(tableId);
        GenericJDBCUtilities.updateFields((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()), this.getMapTableToPKColumnEngine(), ids, (ISQLFieldConverter)this.getAllarmeNotificaFieldConverter(), (IJDBCServiceSearchWithoutId)this, (UpdateModel[])updateModels);
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeNotifica allarmeNotifica, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        Long id = allarmeNotifica.getId();
        if (id != null && this.exists(jdbcProperties, log, connection, sqlQueryObject, id)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, allarmeNotifica, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, allarmeNotifica, idMappingResolutionBehaviour);
        }
    }

    public void updateOrCreate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, AllarmeNotifica allarmeNotifica, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        if (this.exists(jdbcProperties, log, connection, sqlQueryObject, tableId)) {
            this.update(jdbcProperties, log, connection, sqlQueryObject, tableId, allarmeNotifica, idMappingResolutionBehaviour);
        } else {
            this.create(jdbcProperties, log, connection, sqlQueryObject, allarmeNotifica, idMappingResolutionBehaviour);
        }
    }

    public void delete(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, AllarmeNotifica allarmeNotifica) throws NotImplementedException, ServiceException, Exception {
        Long longId = null;
        if (allarmeNotifica.getId() == null) {
            throw new Exception("Parameter " + allarmeNotifica.getClass().getName() + ".id is null");
        }
        if (allarmeNotifica.getId() <= 0L) {
            throw new Exception("Parameter " + allarmeNotifica.getClass().getName() + ".id is less equals 0");
        }
        longId = allarmeNotifica.getId();
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, longId);
    }

    private void deleteEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long id) throws NotImplementedException, ServiceException, Exception {
        if (id != null && id <= 0L) {
            throw new ServiceException("Id is less equals 0");
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectDelete = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectDelete.setANDLogicOperator(true);
        sqlQueryObjectDelete.addDeleteTable(this.getAllarmeNotificaFieldConverter().toTable((IModel)AllarmeNotifica.model()));
        if (id != null) {
            sqlQueryObjectDelete.addWhereCondition("id=?");
        }
        jdbcUtilities.execute(sqlQueryObjectDelete.createSQLDelete(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)id, Long.class)});
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        return this.deleteAll(jdbcProperties, log, connection, sqlQueryObject, new JDBCExpression((ISQLFieldConverter)this.getAllarmeNotificaFieldConverter()));
    }

    public NonNegativeNumber deleteAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List<Long> lst = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, new JDBCPaginatedExpression(expression));
        for (Long id : lst) {
            this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, id);
        }
        return new NonNegativeNumber((long)lst.size());
    }

    public void deleteById(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotImplementedException, Exception {
        this.deleteEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    public int nativeUpdate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlObject, String sql, Object ... param) throws ServiceException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeUpdate((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlObject, (String)sql, (Object[])param);
    }
}

