/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.allarmi.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.allarmi.dao.jdbc.converter.AllarmeFieldConverter;
import org.openspcoop2.core.allarmi.dao.jdbc.fetch.AllarmeFetch;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.Utilities;
import org.openspcoop2.generic_project.utils.UtilsTemplate;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCAllarmeServiceSearchImpl
implements IJDBCServiceSearchWithId<Allarme, IdAllarme, JDBCServiceManager> {
    private AllarmeFieldConverter _allarmeFieldConverter = null;
    private AllarmeFetch allarmeFetch = new AllarmeFetch();
    private JDBCServiceManager jdbcServiceManager = null;

    public AllarmeFieldConverter getAllarmeFieldConverter() {
        if (this._allarmeFieldConverter == null) {
            this._allarmeFieldConverter = new AllarmeFieldConverter(this.jdbcServiceManager.getJdbcProperties().getDatabaseType());
        }
        return this._allarmeFieldConverter;
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.getAllarmeFieldConverter();
    }

    public AllarmeFetch getAllarmeFetch() {
        return this.allarmeFetch;
    }

    public IJDBCFetch getFetch() {
        return this.getAllarmeFetch();
    }

    public void setServiceManager(JDBCServiceManager serviceManager) throws ServiceException {
        this.jdbcServiceManager = serviceManager;
    }

    public JDBCServiceManager getServiceManager() throws ServiceException {
        return this.jdbcServiceManager;
    }

    public IdAllarme convertToId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Allarme allarme) throws NotImplementedException, ServiceException, Exception {
        IdAllarme idAllarme = new IdAllarme();
        idAllarme.setNome(allarme.getNome());
        idAllarme.setTipo(allarme.getTipo());
        idAllarme.setEnabled(allarme.getEnabled());
        idAllarme.setAlias(allarme.getAlias());
        if (allarme.getFiltro() != null) {
            idAllarme.setFiltroRuoloPorta(allarme.getFiltro().getRuoloPorta());
            idAllarme.setFiltroNomePorta(allarme.getFiltro().getNomePorta());
        }
        return idAllarme;
    }

    public Allarme get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdAllarme id, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long idAllarme = id != null && id.getId() != null && id.getId() > 0L ? id.getId() : this.findIdAllarme(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, idAllarme, idMappingResolutionBehaviour);
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdAllarme id) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long idAllarme = this.findIdAllarme(jdbcProperties, log, connection, sqlQueryObject, id, false);
        return idAllarme != null && idAllarme > 0L;
    }

    public List<IdAllarme> findAllIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<IdAllarme> list = new ArrayList<IdAllarme>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            Allarme allarme = this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
            IdAllarme idAllarme = this.convertToId(jdbcProperties, log, connection, sqlQueryObject, allarme);
            list.add(idAllarme);
        }
        return list;
    }

    public List<Allarme> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<Allarme> list = new ArrayList<Allarme>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            list.add(this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour));
        }
        return list;
    }

    public Allarme find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        long id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        if (id > 0L) {
            return this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    public NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List listaQuery = GenericJDBCUtilities.prepareCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model());
        sqlQueryObject.addSelectCountField(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model()) + ".id", "tot", true);
        this.joinEngine((IExpression)expression, sqlQueryObject);
        return GenericJDBCUtilities.count((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), (List)listaQuery);
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdAllarme id) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long idAllarme = this.findIdAllarme(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, idAllarme);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List<Map<String, Object>> map = this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, distinct, new IField[]{field});
        return GenericJDBCUtilities.selectSingleObject(map);
    }

    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        try {
            ISQLQueryObject sqlQueryObjectDistinct = GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((boolean)distinct, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (Logger)log, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IField[])field);
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression, sqlQueryObjectDistinct);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        }
    }

    public Object aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        Map<String, Object> map = this.aggregate(jdbcProperties, log, connection, sqlQueryObject, expression, new FunctionField[]{functionField});
        return GenericJDBCUtilities.selectAggregateObject(map, (FunctionField)functionField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (expression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (paginatedExpression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        }
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, expression, null);
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLQueryObject sqlQueryObjectDistinct) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        ArrayList listaQuery = new ArrayList();
        ArrayList listaParams = new ArrayList();
        List returnField = GenericJDBCUtilities.prepareSelect((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), listaQuery, listaParams);
        this.joinEngine(expression, sqlQueryObject);
        List list = GenericJDBCUtilities.select((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((ISQLQueryObject)sqlQueryObject, (ISQLQueryObject)sqlQueryObjectDistinct), (IExpression)expression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), listaQuery, listaParams, (List)returnField);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List list;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnion((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((list = GenericJDBCUtilities.union((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        NonNegativeNumber number;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((number = GenericJDBCUtilities.unionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && number.longValue() >= 0L) {
            return number;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public JDBCExpression newExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression((ISQLFieldConverter)this.getAllarmeFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression newPaginatedExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression((ISQLFieldConverter)this.getAllarmeFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCExpression toExpression(JDBCPaginatedExpression paginatedExpression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression(paginatedExpression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression toPaginatedExpression(JDBCExpression expression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression(expression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdAllarme id, Allarme obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, id, null));
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Allarme obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, tableId, (IDMappingBehaviour)null));
    }

    private void _mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Allarme obj, Allarme imgSaved) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (imgSaved == null) {
            return;
        }
        obj.setId(imgSaved.getId());
        if (obj.getMail() != null && imgSaved.getMail() != null) {
            obj.getMail().setId(imgSaved.getMail().getId());
        }
        if (obj.getScript() != null && imgSaved.getScript() != null) {
            obj.getScript().setId(imgSaved.getScript().getId());
        }
        if (obj.getFiltro() != null && imgSaved.getFiltro() != null) {
            obj.getFiltro().setId(imgSaved.getFiltro().getId());
        }
        if (obj.getGroupBy() != null && imgSaved.getGroupBy() != null) {
            obj.getGroupBy().setId(imgSaved.getGroupBy().getId());
        }
        if (obj.getAllarmeParametroList() != null) {
            List<AllarmeParametro> listObj_ = obj.getAllarmeParametroList();
            for (AllarmeParametro itemObj_ : listObj_) {
                AllarmeParametro itemAlreadySaved_ = null;
                if (imgSaved.getAllarmeParametroList() != null) {
                    List<AllarmeParametro> listImgSaved_ = imgSaved.getAllarmeParametroList();
                    for (AllarmeParametro itemImgSaved_ : listImgSaved_) {
                        boolean objEqualsToImgSaved_ = false;
                        objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getIdParametro(), (Object)itemImgSaved_.getIdParametro());
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
            }
        }
    }

    public Allarme get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
    }

    private Allarme getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        Allarme allarme = new Allarme();
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addFromTable(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model()));
        sqlQueryObjectGet.addSelectField("id");
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().NOME, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().ALIAS, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().DESCRIZIONE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().TIPO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().TIPO_ALLARME, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().MAIL.INVIA, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().MAIL.INVIA_WARNING, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().MAIL.DESTINATARI, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().MAIL.SUBJECT, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().MAIL.BODY, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().SCRIPT.INVOCA, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().SCRIPT.INVOCA_WARNING, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().SCRIPT.COMMAND, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().SCRIPT.ARGS, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().STATO_PRECEDENTE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().STATO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().DETTAGLIO_STATO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().LASTTIMESTAMP_CREATE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().LASTTIMESTAMP_UPDATE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().ENABLED, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().ACKNOWLEDGED, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().DETTAGLIO_ACKNOWLEDGED, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().TIPO_PERIODO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().PERIODO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.ENABLED, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.PROTOCOLLO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.RUOLO_PORTA, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.NOME_PORTA, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.TIPO_FRUITORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.NOME_FRUITORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.RUOLO_FRUITORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.SERVIZIO_APPLICATIVO_FRUITORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.TIPO_EROGATORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.NOME_EROGATORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.RUOLO_EROGATORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.TAG, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.TIPO_SERVIZIO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.NOME_SERVIZIO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.VERSIONE_SERVIZIO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.AZIONE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.ENABLED, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.RUOLO_PORTA, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.PROTOCOLLO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.FRUITORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.SERVIZIO_APPLICATIVO_FRUITORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.IDENTIFICATIVO_AUTENTICATO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.TOKEN, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.EROGATORE, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.SERVIZIO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().GROUP_BY.AZIONE, true));
        sqlQueryObjectGet.addWhereCondition("id=?");
        allarme = (Allarme)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Allarme.model(), (IJDBCFetch)this.getAllarmeFetch(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        ISQLQueryObject sqlQueryObjectGetAllarmeParametro = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGetAllarmeParametro.setANDLogicOperator(true);
        sqlQueryObjectGetAllarmeParametro.addFromTable(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model().ALLARME_PARAMETRO));
        sqlQueryObjectGetAllarmeParametro.addSelectField("chk_param_id");
        sqlQueryObjectGetAllarmeParametro.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().ALLARME_PARAMETRO.ID_PARAMETRO, true));
        sqlQueryObjectGetAllarmeParametro.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().ALLARME_PARAMETRO.VALORE, true));
        sqlQueryObjectGetAllarmeParametro.addWhereCondition("id_allarme=?");
        List allarme_allarmeParametro_list = jdbcUtilities.executeQuery(sqlQueryObjectGetAllarmeParametro.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Allarme.model().ALLARME_PARAMETRO, (IJDBCFetch)this.getAllarmeFetch(), new JDBCObject[]{new JDBCObject((Object)allarme.getId(), Long.class)});
        if (allarme_allarmeParametro_list != null) {
            for (Object allarme_allarmeParametro_object : allarme_allarmeParametro_list) {
                AllarmeParametro allarme_allarmeParametro = (AllarmeParametro)allarme_allarmeParametro_object;
                allarme.addAllarmeParametro(allarme_allarmeParametro);
            }
        }
        return allarme;
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this._exists(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private boolean _exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        boolean existsAllarme = false;
        sqlQueryObject = sqlQueryObject.newSQLQueryObject();
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model()));
        sqlQueryObject.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().NOME, true));
        sqlQueryObject.addWhereCondition("id=?");
        existsAllarme = jdbcUtilities.exists(sqlQueryObject.createSQLQuery(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        return existsAllarme;
    }

    private void joinEngine(IExpression expression, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        if (expression.inUseModel((IModel)Allarme.model().ALLARME_PARAMETRO, false)) {
            String tableName1 = this.getAllarmeFieldConverter().toTable((IModel)Allarme.model().ALLARME_PARAMETRO);
            String tableName2 = this.getAllarmeFieldConverter().toTable((IModel)Allarme.model());
            sqlQueryObject.addWhereCondition(tableName1 + ".id_allarme=" + tableName2 + ".id");
        }
    }

    protected List<Object> getRootTablePrimaryKeyValuesEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdAllarme id) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        ArrayList<Object> rootTableIdValues = new ArrayList<Object>();
        Long longId = this.findIdAllarme(jdbcProperties, log, connection, sqlQueryObject.newSQLQueryObject(), id, true);
        rootTableIdValues.add(longId);
        return rootTableIdValues;
    }

    protected Map<String, List<IField>> getMapTableToPKColumnEngine() throws NotImplementedException, Exception {
        AllarmeFieldConverter converter = this.getAllarmeFieldConverter();
        HashMap<String, List<IField>> mapTableToPKColumn = new HashMap<String, List<IField>>();
        UtilsTemplate utilities = new UtilsTemplate();
        mapTableToPKColumn.put(converter.toTable((IModel)Allarme.model()), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Allarme.model()))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Allarme.model().MAIL), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Allarme.model().MAIL))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Allarme.model().SCRIPT), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Allarme.model().SCRIPT))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Allarme.model().FILTRO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Allarme.model().FILTRO))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Allarme.model().GROUP_BY), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Allarme.model().GROUP_BY))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Allarme.model().ALLARME_PARAMETRO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Allarme.model().ALLARME_PARAMETRO))}));
        return mapTableToPKColumn;
    }

    public List<Long> findAllTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException, Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFindAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model());
        this.joinEngine((IExpression)paginatedExpression, sqlQueryObject);
        List listObjects = GenericJDBCUtilities.findAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), objectIdClass, (List)listaQuery);
        for (Object object : listObjects) {
            list.add((Long)object);
        }
        return list;
    }

    public long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, Exception {
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFind((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model());
        this.joinEngine((IExpression)expression, sqlQueryObject);
        Object res = GenericJDBCUtilities.find((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getAllarmeFieldConverter(), (IModel)Allarme.model(), objectIdClass, (List)listaQuery);
        if (res != null && (Long)res > 0L) {
            return (Long)res;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private InUse inUseEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        InUse inUse = new InUse();
        inUse.setInUse(false);
        boolean throwNotImplemented = true;
        if (throwNotImplemented) {
            throw new NotImplementedException("NotImplemented");
        }
        return inUse;
    }

    public IdAllarme findId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        if (tableId <= 0L) {
            throw new ServiceException("Id undefined");
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGet.addFromTable(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model()));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().NOME, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().TIPO, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().ENABLED, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().ALIAS, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.RUOLO_PORTA, true));
        sqlQueryObjectGet.addSelectField(this.getAllarmeFieldConverter().toColumn(Allarme.model().FILTRO.NOME_PORTA, true));
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addWhereCondition("id=?");
        JDBCObject[] searchParams_allarme = new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)};
        ArrayList<Class> listaFieldIdReturnType_allarme = new ArrayList<Class>();
        listaFieldIdReturnType_allarme.add(Allarme.model().NOME.getFieldType());
        listaFieldIdReturnType_allarme.add(Allarme.model().TIPO.getFieldType());
        listaFieldIdReturnType_allarme.add(Allarme.model().ENABLED.getFieldType());
        listaFieldIdReturnType_allarme.add(Allarme.model().ALIAS.getFieldType());
        listaFieldIdReturnType_allarme.add(Allarme.model().FILTRO.RUOLO_PORTA.getFieldType());
        listaFieldIdReturnType_allarme.add(Allarme.model().FILTRO.NOME_PORTA.getFieldType());
        IdAllarme idAllarme = null;
        List listaFieldId_allarme = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_allarme, searchParams_allarme);
        if (listaFieldId_allarme == null || listaFieldId_allarme.size() <= 0) {
            if (throwNotFound) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        } else {
            Object nomePorta;
            idAllarme = new IdAllarme();
            idAllarme.setNome((String)listaFieldId_allarme.get(0));
            idAllarme.setTipo((String)listaFieldId_allarme.get(1));
            idAllarme.setEnabled((Integer)listaFieldId_allarme.get(2));
            idAllarme.setAlias((String)listaFieldId_allarme.get(3));
            Object ruoloPorta = listaFieldId_allarme.get(4);
            if (ruoloPorta != null) {
                if (ruoloPorta instanceof RuoloPorta) {
                    idAllarme.setFiltroRuoloPorta((RuoloPorta)ruoloPorta);
                } else if (ruoloPorta instanceof String) {
                    idAllarme.setFiltroRuoloPorta(RuoloPorta.toEnumConstant((String)ruoloPorta));
                }
            }
            if ((nomePorta = listaFieldId_allarme.get(5)) != null && nomePorta instanceof String) {
                idAllarme.setFiltroNomePorta((String)nomePorta);
            }
        }
        return idAllarme;
    }

    public Long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdAllarme id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        return this.findIdAllarme(jdbcProperties, log, connection, sqlQueryObject, id, throwNotFound);
    }

    public List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeQuery((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)sql, returnClassTypes, (Object[])param);
    }

    protected Long findIdAllarme(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdAllarme id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        Long idAllarme;
        block4: {
            if (id == null || id.getNome() == null) {
                throw new ServiceException("Id undefined");
            }
            JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
            ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
            sqlQueryObjectGet.addFromTable(this.getAllarmeFieldConverter().toTable((IModel)Allarme.model()));
            sqlQueryObjectGet.addSelectField("id");
            sqlQueryObjectGet.setANDLogicOperator(true);
            sqlQueryObjectGet.setSelectDistinct(true);
            sqlQueryObjectGet.addWhereCondition(this.getAllarmeFieldConverter().toColumn(Allarme.model().NOME, true) + "=?");
            JDBCObject[] searchParams_allarme = new JDBCObject[]{new JDBCObject((Object)id.getNome(), String.class)};
            idAllarme = null;
            try {
                idAllarme = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParams_allarme);
            }
            catch (NotFoundException notFound) {
                if (!throwNotFound) break block4;
                throw new NotFoundException((Throwable)notFound);
            }
        }
        if ((idAllarme == null || idAllarme <= 0L) && throwNotFound) {
            throw GenericJDBCUtilities.newNotFoundException();
        }
        return idAllarme;
    }
}

