/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.transport.http.SSLConfig;

public class ConnettoreHTTPSProperties
extends SSLConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String VALORE_DEFINITO_PER_PROPRIETA = "Valore definito per la propriet\u00e0 '";
    private static final String VALORE_NON_DEFINITO_PER_PROPRIETA = "Valore non definito per la propriet\u00e0 '";
    private static final String NON_VALIDO_TRUE_FALSE = "' non valido, valori accettati true/false";
    private static final String DEFINITO_TRAMITE_PROPRIETA = "' nonostante sia stato definito un trustStore attraverso la propriet\u00e0 '";

    public static ConnettoreHTTPSProperties readProperties(Map<String, String> properties) throws CoreException {
        String tmp;
        ConnettoreHTTPSProperties propertiesHTTPS = new ConnettoreHTTPSProperties();
        if (properties.get("trustAllCerts") != null) {
            tmp = properties.get("trustAllCerts").trim();
            try {
                propertiesHTTPS.setTrustAllCerts(Boolean.parseBoolean(tmp));
            }
            catch (Exception e) {
                throw new CoreException("Valore definito per la propriet\u00e0 'trustAllCerts' non valido, valori accettati true/false");
            }
        }
        if (!propertiesHTTPS.isTrustAllCerts() && properties.get("trustStoreLocation") != null) {
            ConnettoreHTTPSProperties.readTrustStoreConfig(properties, propertiesHTTPS);
        } else if (propertiesHTTPS.isTrustAllCerts()) {
            ConnettoreHTTPSProperties.readTrustStoreAllConfig(properties, propertiesHTTPS);
        }
        if (properties.get("keyStoreLocation") != null) {
            ConnettoreHTTPSProperties.readKeyStoreConfig(properties, propertiesHTTPS);
        }
        if (properties.get("hostnameVerifier") != null) {
            tmp = properties.get("hostnameVerifier").trim();
            try {
                propertiesHTTPS.setHostnameVerifier(Boolean.parseBoolean(tmp));
            }
            catch (Exception e) {
                throw new CoreException("Valore definito per la propriet\u00e0 'hostnameVerifier' non valido, valori accettati true/false");
            }
        }
        if (properties.get("classNameHostnameVerifier") != null) {
            tmp = properties.get("classNameHostnameVerifier").trim();
            propertiesHTTPS.setClassNameHostnameVerifier(tmp);
        }
        if (properties.get("sslType") != null) {
            tmp = properties.get("sslType").trim();
            propertiesHTTPS.setSslType(tmp);
        } else {
            propertiesHTTPS.setSslType(CostantiConnettori.CONNETTORE_HTTPS_SSL_TYPE_DEFAULT_VALUE);
        }
        if (properties.get("secureRandom") != null) {
            ConnettoreHTTPSProperties.readSecureRandomConfig(properties, propertiesHTTPS);
        }
        return propertiesHTTPS;
    }

    private static void readTrustStoreConfig(Map<String, String> properties, ConnettoreHTTPSProperties propertiesHTTPS) throws CoreException {
        String tmp = properties.get("trustStoreLocation").trim();
        propertiesHTTPS.setTrustStoreLocation(tmp);
        if (properties.get("trustStoreType") != null) {
            tmp = properties.get("trustStoreType").trim();
            propertiesHTTPS.setTrustStoreType(tmp);
        } else {
            propertiesHTTPS.setTrustStoreType(KeyStore.getDefaultType());
        }
        if (properties.get("trustStorePassword") != null) {
            tmp = properties.get("trustStorePassword").trim();
            propertiesHTTPS.setTrustStorePassword(tmp);
        } else {
            boolean throwException = true;
            if (KeystoreType.JKS.isType(propertiesHTTPS.getTrustStoreType()) && !DBUtils.isTruststoreJksPasswordRequired() || KeystoreType.PKCS12.isType(propertiesHTTPS.getTrustStoreType()) && !DBUtils.isTruststorePkcs12PasswordRequired()) {
                throwException = false;
            }
            if (throwException) {
                throw new CoreException("Valore non definito per la propriet\u00e0 'trustStorePassword' nonostante sia stato definito un trustStore attraverso la propriet\u00e0 'trustStoreLocation'");
            }
        }
        if (properties.get("trustManagementAlgorithm") != null) {
            tmp = properties.get("trustManagementAlgorithm").trim();
            propertiesHTTPS.setTrustManagementAlgorithm(tmp);
        } else {
            propertiesHTTPS.setTrustManagementAlgorithm(TrustManagerFactory.getDefaultAlgorithm());
        }
        if (properties.get("trustStoreCRLs") != null) {
            tmp = properties.get("trustStoreCRLs").trim();
            propertiesHTTPS.setTrustStoreCRLsLocation(tmp);
        }
        if (properties.get("trustStoreOCSPPolicy") != null) {
            tmp = properties.get("trustStoreOCSPPolicy").trim();
            propertiesHTTPS.setTrustStoreOCSPPolicy(tmp);
        }
    }

    private static void readTrustStoreAllConfig(Map<String, String> properties, ConnettoreHTTPSProperties propertiesHTTPS) {
        if (properties.get("trustStoreOCSPPolicy") != null) {
            String tmp = properties.get("trustStoreOCSPPolicy").trim();
            propertiesHTTPS.setTrustStoreOCSPPolicy(tmp);
            if (properties.get("trustStoreCRLs") != null) {
                tmp = properties.get("trustStoreCRLs").trim();
                propertiesHTTPS.setTrustStoreCRLsLocation(tmp);
            }
        }
    }

    private static void readKeyStoreConfig(Map<String, String> properties, ConnettoreHTTPSProperties propertiesHTTPS) throws CoreException {
        String tmp = properties.get("keyStoreLocation").trim();
        propertiesHTTPS.setKeyStoreLocation(tmp);
        if (properties.get("keyStoreType") != null) {
            tmp = properties.get("keyStoreType").trim();
            propertiesHTTPS.setKeyStoreType(tmp);
        } else {
            propertiesHTTPS.setKeyStoreType(KeyStore.getDefaultType());
        }
        ConnettoreHTTPSProperties.readKeyStorePasswordConfig(properties, propertiesHTTPS);
        if (properties.get("keyAlias") != null) {
            tmp = properties.get("keyAlias").trim();
            propertiesHTTPS.setKeyAlias(tmp);
        }
        if (properties.get("keyManagementAlgorithm") != null) {
            tmp = properties.get("keyManagementAlgorithm").trim();
            propertiesHTTPS.setKeyManagementAlgorithm(tmp);
        } else {
            propertiesHTTPS.setKeyManagementAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
        }
        if (properties.get("keyStoreBYOKPolicy") != null) {
            tmp = properties.get("keyStoreBYOKPolicy").trim();
            propertiesHTTPS.setKeyStoreBYOKPolicy(tmp);
        }
    }

    private static void readKeyStorePasswordConfig(Map<String, String> properties, ConnettoreHTTPSProperties propertiesHTTPS) throws CoreException {
        boolean throwException;
        String tmp = null;
        if (properties.get("keyStorePassword") != null) {
            tmp = properties.get("keyStorePassword").trim();
            propertiesHTTPS.setKeyStorePassword(tmp);
        } else {
            throwException = true;
            if (KeystoreType.JKS.isType(propertiesHTTPS.getKeyStoreType()) && !DBUtils.isKeystoreJksPasswordRequired() || KeystoreType.PKCS12.isType(propertiesHTTPS.getKeyStoreType()) && !DBUtils.isKeystorePkcs12PasswordRequired()) {
                throwException = false;
            }
            if (throwException) {
                throw new CoreException("Valore non definito per la propriet\u00e0 'keyStorePassword' nonostante sia stato definito un trustStore attraverso la propriet\u00e0 'keyStoreLocation'");
            }
        }
        if (properties.get("keyPassword") != null) {
            tmp = properties.get("keyPassword").trim();
            propertiesHTTPS.setKeyPassword(tmp);
        } else {
            throwException = true;
            if (KeystoreType.JKS.isType(propertiesHTTPS.getKeyStoreType()) && !DBUtils.isKeystoreJksKeyPasswordRequired() || KeystoreType.PKCS12.isType(propertiesHTTPS.getKeyStoreType()) && !DBUtils.isKeystorePkcs12KeyPasswordRequired()) {
                throwException = false;
            }
            if (throwException) {
                throw new CoreException("Valore non definito per la propriet\u00e0 'keyPassword' nonostante sia stato definito un trustStore attraverso la propriet\u00e0 'keyStoreLocation'");
            }
        }
    }

    private static void readSecureRandomConfig(Map<String, String> properties, ConnettoreHTTPSProperties propertiesHTTPS) throws CoreException {
        String tmp = properties.get("secureRandom").trim();
        try {
            propertiesHTTPS.setSecureRandom(Boolean.parseBoolean(tmp));
        }
        catch (Exception e) {
            throw new CoreException("Valore definito per la propriet\u00e0 'secureRandom' non valido, valori accettati true/false");
        }
        if (propertiesHTTPS.isSecureRandom() && properties.get("secureRandomAlgorithm") != null) {
            propertiesHTTPS.setSecureRandomAlgorithm(properties.get("secureRandomAlgorithm").trim());
        }
    }

    public static ConnettoreHTTPSProperties readPropertyFile(String file, boolean sslConfigRequired) throws CoreException {
        return ConnettoreHTTPSProperties.readPropertyFile(new File(file), sslConfigRequired);
    }

    public static ConnettoreHTTPSProperties readPropertyFile(File file, boolean sslConfigRequired) throws CoreException {
        String prefix = "Config file [" + file.getAbsolutePath() + "] ";
        if (!file.exists()) {
            if (sslConfigRequired) {
                throw new CoreException(prefix + "not exists");
            }
            return null;
        }
        if (file.isDirectory()) {
            throw new CoreException(prefix + "is directory");
        }
        if (!file.canRead()) {
            throw new CoreException(prefix + "cannot read");
        }
        Properties p = new Properties();
        try (FileInputStream fin = new FileInputStream(file);){
            p.load(fin);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
        HashMap<String, String> pMap = new HashMap<String, String>();
        Enumeration<Object> enP = p.keys();
        while (enP.hasMoreElements()) {
            String key = (String)enP.nextElement();
            pMap.put(key, p.getProperty(key));
        }
        return ConnettoreHTTPSProperties.readProperties(pMap);
    }
}

