/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCParameterUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCSqlLogger;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class DBUtils {
    private static final String WHERE_ID_CONDITION = "id = ?";
    private static boolean keystoreJksPasswordRequired = true;
    private static boolean keystoreJksKeyPasswordRequired = true;
    private static boolean keystorePkcs12PasswordRequired = true;
    private static boolean keystorePkcs12KeyPasswordRequired = true;
    private static boolean truststoreJksPasswordRequired = true;
    private static boolean truststorePkcs12PasswordRequired = true;

    private DBUtils() {
    }

    public static boolean isKeystoreJksPasswordRequired() {
        return keystoreJksPasswordRequired;
    }

    public static void setKeystoreJksPasswordRequired(boolean isKeystoreJksPasswordRequired) {
        keystoreJksPasswordRequired = isKeystoreJksPasswordRequired;
    }

    public static boolean isKeystoreJksKeyPasswordRequired() {
        return keystoreJksKeyPasswordRequired;
    }

    public static void setKeystoreJksKeyPasswordRequired(boolean isKeystoreJksKeyPasswordRequired) {
        keystoreJksKeyPasswordRequired = isKeystoreJksKeyPasswordRequired;
    }

    public static boolean isKeystorePkcs12PasswordRequired() {
        return keystorePkcs12PasswordRequired;
    }

    public static void setKeystorePkcs12PasswordRequired(boolean isKeystorePkcs12PasswordRequired) {
        keystorePkcs12PasswordRequired = isKeystorePkcs12PasswordRequired;
    }

    public static boolean isKeystorePkcs12KeyPasswordRequired() {
        return keystorePkcs12KeyPasswordRequired;
    }

    public static void setKeystorePkcs12KeyPasswordRequired(boolean isKeystorePkcs12KeyPasswordRequired) {
        keystorePkcs12KeyPasswordRequired = isKeystorePkcs12KeyPasswordRequired;
    }

    public static boolean isTruststoreJksPasswordRequired() {
        return truststoreJksPasswordRequired;
    }

    public static void setTruststoreJksPasswordRequired(boolean isTruststoreJksPasswordRequired) {
        truststoreJksPasswordRequired = isTruststoreJksPasswordRequired;
    }

    public static boolean isTruststorePkcs12PasswordRequired() {
        return truststorePkcs12PasswordRequired;
    }

    public static void setTruststorePkcs12PasswordRequired(boolean isTruststorePkcs12PasswordRequired) {
        truststorePkcs12PasswordRequired = isTruststorePkcs12PasswordRequired;
    }

    public static String estraiTipoDatabaseFromLocation(String location) throws CoreException {
        if (location == null) {
            throw new CoreException("Location del db is null");
        }
        if (location.indexOf("@") == -1) {
            throw new CoreException("Tipo di database non indicato nella location, sintassi corretta e' tipoDatabase@datasource");
        }
        String tipoDatabase = location.split("@")[0].trim();
        if (!TipiDatabase.isAMember((String)tipoDatabase)) {
            throw new CoreException("Tipo di database indicato nella location [" + tipoDatabase + "] non supportato");
        }
        return tipoDatabase;
    }

    public static List<List<Object>> readCustom(Logger log, Connection connection, String tipoDB, ISQLQueryObject sqlQueryObject, List<Class<?>> returnTypes, List<JDBCObject> paramTypes) throws CoreException {
        ArrayList<List<Object>> arrayList;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            if (returnTypes == null || returnTypes.isEmpty()) {
                throw new CoreException("Non sono stati definiti tipi da ritornare");
            }
            ArrayList<List<Object>> lista = new ArrayList<List<Object>>();
            String sql = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sql);
            GenericJDBCParameterUtilities jdbcParameterUtilities = new GenericJDBCParameterUtilities(TipiDatabase.toEnumConstant((String)tipoDB));
            JDBCObject[] paramsArray = null;
            if (paramTypes != null && !paramTypes.isEmpty()) {
                paramsArray = paramTypes.toArray(new JDBCObject[1]);
            }
            jdbcParameterUtilities.setParameters(stm, paramsArray);
            JDBCSqlLogger sqlLogger = new JDBCSqlLogger(log);
            sqlLogger.infoSql(sql, paramsArray);
            rs = stm.executeQuery();
            while (rs.next()) {
                ArrayList<Object> listaInterna = new ArrayList<Object>();
                for (int i = 0; i < returnTypes.size(); ++i) {
                    listaInterna.add(jdbcParameterUtilities.readParameter(rs, i + 1, returnTypes.get(i)));
                }
                lista.add(listaInterna);
            }
            arrayList = lista;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return arrayList;
    }

    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB, "soggetti");
    }

    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idSoggetto = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoSoggetto);
            stm.setString(2, nomeSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = rs.getLong("id");
            }
            l = idSoggetto;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static IDSoggetto getIdSoggetto(long id, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdSoggetto(id, con, tipoDB, "soggetti");
    }

    public static IDSoggetto getIdSoggetto(long id, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        IDSoggetto iDSoggetto;
        PreparedStatement stm = null;
        ResultSet rs = null;
        IDSoggetto idSoggetto = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition(WHERE_ID_CONDITION);
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, id);
            rs = stm.executeQuery();
            if (rs.next()) {
                String tipSoggetto = rs.getString("tipo_soggetto");
                String nomeSoggetto = rs.getString("nome_soggetto");
                idSoggetto = new IDSoggetto(tipSoggetto, nomeSoggetto);
            }
            iDSoggetto = idSoggetto;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return iDSoggetto;
    }

    public static long getIdConnettore(String nomeConnettore, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_connettore = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nomeConnettore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id");
            }
            l = idConnettore;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeSoggettoErogatore, String tipoSoggettoErogatore, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, false, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeSoggettoErogatore, String tipoSoggettoErogatore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, false, tipoDB, tabellaSoggetti);
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, long idSoggetto, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, idSoggetto, con, false, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, long idSoggetto, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, idSoggetto, con, false, tipoDB, tabellaSoggetti);
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeSoggettoErogatore, String tipoSoggettoErogatore, Connection con, boolean testServizioNonCorrelato, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, testServizioNonCorrelato, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeSoggettoErogatore, String tipoSoggettoErogatore, Connection con, boolean testServizioNonCorrelato, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idSoggetto = DBUtils.getIdSoggetto(nomeSoggettoErogatore, tipoSoggettoErogatore, con, tipoDB, tabellaSoggetti);
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, idSoggetto, con, testServizioNonCorrelato, tipoDB, tabellaSoggetti);
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, long idSoggetto, Connection con, boolean testServizioNonCorrelato, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, idSoggetto, con, testServizioNonCorrelato, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, Integer versioneServizio, long idSoggetto, Connection con, boolean testServizioNonCorrelato, String tipoDB, String tabellaSoggetti) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("versione_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            Object query = sqlQueryObject.createSQLQuery();
            if (testServizioNonCorrelato) {
                query = (String)query + " AND servizio_correlato=?";
            }
            stm = con.prepareStatement((String)query);
            int index = 1;
            stm.setLong(index++, idSoggetto);
            stm.setString(index++, tipoServizio);
            stm.setString(index++, nomeServizio);
            stm.setInt(index++, versioneServizio);
            if (testServizioNonCorrelato) {
                stm.setString(index++, "disabilitato");
            }
            if ((rs = stm.executeQuery()).next()) {
                idServizio = rs.getLong("id");
            }
            l = idServizio;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static String getSuperUserSoggettoSafe(Logger log, String method, long idSoggetto, Connection con, String tipoDB) {
        return DBUtils.getSuperUserSoggettoSafe(log, method, idSoggetto, con, tipoDB, "soggetti");
    }

    public static String getSuperUserSoggettoSafe(Logger log, String method, long idSoggetto, Connection con, String tipoDB, String tabellaSoggetti) {
        try {
            return DBUtils.getSuperUserSoggetto(idSoggetto, con, tipoDB, tabellaSoggetti);
        }
        catch (Exception e) {
            if (log != null) {
                String msgError = "[" + method + "] getSuperUserSoggetto failed: " + e.getMessage();
                log.error(msgError, (Throwable)e);
            }
            return null;
        }
    }

    public static String getSuperUserSoggetto(long idSoggetto, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getSuperUserSoggetto(idSoggetto, con, tipoDB, "soggetti");
    }

    public static String getSuperUserSoggetto(long idSoggetto, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        String string;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String superuser = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabellaSoggetti);
            sqlQueryObject.addSelectField("superuser");
            sqlQueryObject.addWhereCondition(WHERE_ID_CONDITION);
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                superuser = rs.getString("superuser");
            }
            string = superuser;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return string;
    }

    public static String getSuperUserServizioSafe(Logger log, String method, long idServizio, Connection con, String tipoDB) {
        try {
            return DBUtils.getSuperUserServizio(idServizio, con, tipoDB);
        }
        catch (Exception e) {
            if (log != null) {
                String msgError = "[" + method + "] getSuperUserServizio failed: " + e.getMessage();
                log.error(msgError, (Throwable)e);
            }
            return null;
        }
    }

    public static String getSuperUserServizio(long idServizio, Connection con, String tipoDB) throws CoreException {
        String string;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String superuser = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("superuser");
            sqlQueryObject.addWhereCondition(WHERE_ID_CONDITION);
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                superuser = rs.getString("superuser");
            }
            string = superuser;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return string;
    }

    public static long getIdPortaApplicativa(String nomePorta, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idPortaApplicativa = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaApplicativa = rs.getLong("id");
            }
            l = idPortaApplicativa;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdPortaDelegata(String nomePorta, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idPortaDelegata = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaDelegata = rs.getLong("id");
            }
            l = idPortaDelegata;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdServizioApplicativo(nomeServizioApplicativo, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idServizioApplicativo = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomeServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizioApplicativo = rs.getLong("id");
            }
            l = idServizioApplicativo;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdPortaDominio(String nome, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idPdD = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPdD = rs.getLong("id");
            }
            l = idPdD;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdGruppo(IDGruppo idGruppo, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idGruppoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("gruppi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idGruppo.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                idGruppoLong = rs.getLong("id");
            }
            l = idGruppoLong;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdRuolo(IDRuolo idRuolo, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idRuoloLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idRuolo.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                idRuoloLong = rs.getLong("id");
            }
            l = idRuoloLong;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdScope(IDScope idScope, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idScopeLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("scope");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idScope.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                idScopeLong = rs.getLong("id");
            }
            l = idScopeLong;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdAccordoServizioParteComune(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeSoggettoErogatore, String tipoSoggettoErogatore, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdAccordoServizioParteComune(nomeServizio, tipoServizio, versioneServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, tipoDB, "soggetti");
    }

    public static long getIdAccordoServizioParteComune(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeSoggettoErogatore, String tipoSoggettoErogatore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idAccordo = -1L;
        try {
            long idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition(WHERE_ID_CONDITION);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordo = rs.getLong("id_accordo");
            }
            l = idAccordo;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdPortType(Long idAccordo, String nomePortType, Connection con) throws CoreException {
        long l;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        long id = -1L;
        try {
            String selectQuery = "SELECT id FROM port_type WHERE id_accordo = ? AND nome=?";
            selectStmt = con.prepareStatement(selectQuery);
            selectStmt.setLong(1, idAccordo);
            selectStmt.setString(2, nomePortType);
            selectRS = selectStmt.executeQuery();
            if (selectRS.next()) {
                id = selectRS.getLong("id");
            }
            selectRS.close();
            selectStmt.close();
            l = id;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        return l;
    }

    public static long getIdResource(Long idAccordo, String nomeRisorsa, Connection con) throws CoreException {
        long l;
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        long id = -1L;
        try {
            String selectQuery = "SELECT id FROM api_resources WHERE id_accordo = ? AND nome=?";
            selectStmt = con.prepareStatement(selectQuery);
            selectStmt.setLong(1, idAccordo);
            selectStmt.setString(2, nomeRisorsa);
            selectRS = selectStmt.executeQuery();
            if (selectRS.next()) {
                id = selectRS.getLong("id");
            }
            selectRS.close();
            selectStmt.close();
            l = id;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        return l;
    }

    public static long getIdAccordoServizioParteComune(IDAccordo idAccordo, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            sqlQueryObject.addWhereCondition("versione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            long idSoggettoReferente = 0L;
            if (idAccordo.getSoggettoReferente() != null && (idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB)) <= 0L) {
                throw new CoreException("[getIdAccordoServizioParteComune] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
            }
            stm.setLong(2, idSoggettoReferente);
            stm.setInt(3, idAccordo.getVersione());
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            l = idAccordoLong;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static int getAccordoServizioParteComuneNextVersion(IDAccordo idAccordo, Connection con, String tipoDB) throws CoreException {
        int n;
        ResultSet rs;
        PreparedStatement stm;
        block6: {
            int versione;
            stm = null;
            rs = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            sqlQueryObject.addOrderBy("versione");
            sqlQueryObject.setSortType(false);
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            long idSoggettoReferente = 0L;
            if (idAccordo.getSoggettoReferente() != null && (idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB)) <= 0L) {
                throw new CoreException("[getIdAccordoServizioParteComune] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
            }
            stm.setLong(2, idSoggettoReferente);
            rs = stm.executeQuery();
            if (!rs.next() || (versione = rs.getInt("versione")) <= 0) break block6;
            int n2 = versione + 1;
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            return n2;
        }
        try {
            n = 1;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return n;
    }

    public static long getIdAccordoCooperazione(IDAccordoCooperazione idAccordo, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            sqlQueryObject.addWhereCondition("versione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            long idSoggettoReferente = 0L;
            if (idAccordo.getSoggettoReferente() != null && (idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB)) <= 0L) {
                throw new CoreException("[getIdAccordoCooperazione] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
            }
            stm.setLong(2, idSoggettoReferente);
            stm.setInt(3, idAccordo.getVersione());
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            l = idAccordoLong;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdAccordoServizioParteSpecifica(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("versione_servizio = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idServizio.getSoggettoErogatore().getTipo());
            stm.setString(2, idServizio.getSoggettoErogatore().getNome());
            stm.setString(3, idServizio.getTipo());
            stm.setString(4, idServizio.getNome());
            stm.setInt(5, idServizio.getVersione());
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            l = idAccordoLong;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdFruizioneServizio(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static long getIdFruizioneServizio(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBUtils._getIdFruizioneServizio(DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB), idFruitore, con, tipoDB, tabellaSoggetti);
    }

    private static long _getIdFruizioneServizio(long idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idFruizione = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            stm.setLong(2, DBUtils.getIdSoggetto(idFruitore.getNome(), idFruitore.getTipo(), con, tipoDB, tabellaSoggetti));
            rs = stm.executeQuery();
            if (rs.next()) {
                idFruizione = rs.getLong("id");
            }
            l = idFruizione;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdDocumento(String nome, String tipo, String ruolo, long idProprietario, Connection con, String tipoDB, String tipoProprietario) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idDoc = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            if (tipo != null) {
                sqlQueryObject.addWhereCondition("tipo = ?");
            }
            if (ruolo != null) {
                sqlQueryObject.addWhereCondition("ruolo = ?");
            }
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idProprietario);
            stm.setString(index++, nome);
            if (tipo != null) {
                stm.setString(index++, tipo);
            }
            if (ruolo != null) {
                stm.setString(index++, ruolo);
            }
            stm.setString(index++, tipoProprietario);
            rs = stm.executeQuery();
            if (rs.next()) {
                idDoc = rs.getLong("id");
            }
            rs.close();
            stm.close();
            l = idDoc;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdProtocolProperty(String tipoProprietario, long idProprietario, String nome, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idPP = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("protocol_properties");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("name = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipoProprietario);
            stm.setLong(2, idProprietario);
            stm.setString(3, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPP = rs.getLong("id");
            }
            rs.close();
            stm.close();
            l = idPP;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdRegistroPlugin(String nome, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idRP = -1L;
        try {
            if (nome == null) {
                throw new CoreException("Nome non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("registro_plugins");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                idRP = rs.getLong("id");
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            l = idRP;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getIdPlugin(String className, String label, String tipoPlugin, String tipo, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idRP = -1L;
        try {
            if (className == null) {
                throw new CoreException("ClassName non fornito");
            }
            if (label == null) {
                throw new CoreException("Label non fornito");
            }
            if (tipoPlugin == null) {
                throw new CoreException("TipoPlugin non fornito");
            }
            if (tipo == null) {
                throw new CoreException("Tipo non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("plugins");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("class_name=?");
            sqlQueryObject.addWhereCondition("label=?");
            sqlQueryObject.addWhereCondition("tipo_plugin=?");
            sqlQueryObject.addWhereCondition("tipo=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, className);
            stm.setString(2, label);
            stm.setString(3, tipoPlugin);
            stm.setString(4, tipo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idRP = rs.getLong("id");
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            l = idRP;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static long getUrlInvocazioneRegola(String nome, Connection con, String tipoDB) throws CoreException {
        long l;
        PreparedStatement stm = null;
        ResultSet rs = null;
        long idRP = -1L;
        try {
            if (nome == null) {
                throw new CoreException("Nome non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("config_url_regole");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                idRP = rs.getLong("id");
            }
            rs.close();
            stm.close();
            rs = null;
            stm = null;
            l = idRP;
        }
        catch (Exception e) {
            try {
                throw new CoreException(e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return l;
    }

    public static void setPropertiesForSearch(ISQLQueryObject sqlQueryObject, Map<String, String> properties, String tabellaPadre, String tabellaProprieta, String columnName, String columnValue, String columnFK) throws SQLQueryObjectException {
        if (properties != null && properties.size() > 0) {
            String[] conditions = new String[properties.size()];
            int i = 0;
            for (String nome : properties.keySet()) {
                String aliasTabella = "pp" + i + tabellaPadre;
                sqlQueryObject.addFromTable(tabellaProprieta, aliasTabella);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(aliasTabella + "." + columnFK + "=" + tabellaPadre + ".id");
                String valore = properties.get(nome);
                conditions[i] = conditions[i] != null ? conditions[i] + " AND " : "";
                conditions[i] = conditions[i] + " " + aliasTabella + "." + columnName + "=?";
                if (valore != null) {
                    conditions[i] = conditions[i] != null ? conditions[i] + " AND " : "";
                    conditions[i] = conditions[i] + " " + aliasTabella + "." + columnValue + "=?";
                } else {
                    conditions[i] = conditions[i] != null ? conditions[i] + " AND " : "";
                    conditions[i] = conditions[i] + " " + aliasTabella + "." + columnValue + " is null";
                }
                ISQLQueryObject sqlQueryObjectPropertyNotExists = null;
                if (valore == null) {
                    ISQLQueryObject sqlQueryObjectPropertyNotExistsInternal = sqlQueryObject.newSQLQueryObject();
                    String aliasTabellaNotExists = "not_exists_" + aliasTabella;
                    sqlQueryObjectPropertyNotExistsInternal.addFromTable(tabellaProprieta, aliasTabellaNotExists);
                    sqlQueryObjectPropertyNotExistsInternal.addSelectField(aliasTabellaNotExists, "id");
                    sqlQueryObjectPropertyNotExistsInternal.addWhereCondition(aliasTabellaNotExists + "." + columnFK + "=" + aliasTabella + "." + columnFK);
                    sqlQueryObjectPropertyNotExistsInternal.addWhereCondition(aliasTabellaNotExists + "." + columnName + "=?");
                    sqlQueryObjectPropertyNotExistsInternal.setANDLogicOperator(true);
                    sqlQueryObjectPropertyNotExists = sqlQueryObject.newSQLQueryObject();
                    sqlQueryObjectPropertyNotExists.addWhereExistsCondition(true, sqlQueryObjectPropertyNotExistsInternal);
                    conditions[i] = "( " + conditions[i] + " ) OR ( " + sqlQueryObjectPropertyNotExists.createSQLConditions() + " )";
                }
                ++i;
            }
            sqlQueryObject.addWhereCondition(true, conditions);
        }
    }

    public static void setPropertiesForSearch(PreparedStatement stmt, int index, Map<String, String> properties, String tipoDatabase, Logger log) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        GenericJDBCParameterUtilities jdbcParameterUtilities = new GenericJDBCParameterUtilities(TipiDatabase.toEnumConstant((String)tipoDatabase));
        if (properties != null && properties.size() > 0) {
            int i = 0;
            for (String nome : properties.keySet()) {
                String valore = properties.get(nome);
                log.debug("Proprieta[" + i + "] nome stmt.setString(" + nome + ")");
                stmt.setString(index++, nome);
                if (valore != null) {
                    log.debug("Proprieta[" + i + "] valore stmt.setString(" + valore + ")");
                    jdbcParameterUtilities.setParameter(stmt, index++, (Object)valore, String.class);
                }
                if (valore == null) {
                    log.debug("Proprieta[" + i + "] nome stmt.setString(" + nome + ")");
                    stmt.setString(index++, nome);
                }
                ++i;
            }
        }
    }

    public static void setFiltriConnettoreApplicativo(ISQLQueryObject sqlQueryObject, String tipoDB, TipiConnettore tipoConnettore, String endpointType, boolean tipoConnettoreIntegrationManager, String filtroConnettoreTokenPolicy, String filtroConnettoreEndpoint, String filtroConnettoreKeystore, String filtroConnettoreDebug) throws Exception {
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addFromTable("connettori");
        sql.setANDLogicOperator(true);
        sql.addWhereCondition("servizi_applicativi.id_connettore_inv=connettori.id");
        DBUtils.setFiltriConnettore(sql, tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug, "servizi_applicativi");
        sqlQueryObject.addWhereExistsCondition(false, sql);
    }

    public static void setFiltriConnettoreErogazione(ISQLQueryObject sqlQueryObject, String tipoDB, TipiConnettore tipoConnettore, String endpointType, boolean tipoConnettoreIntegrationManager, String filtroConnettoreTokenPolicy, String filtroConnettoreEndpoint, String filtroConnettoreKeystore, String filtroConnettoreDebug) throws Exception {
        String aliasMAPPING_EROGAZIONE_PA = "c_map";
        String aliasPORTE_APPLICATIVE = "c_pa";
        String aliasPORTE_APPLICATIVE_SA = "c_pasa";
        String aliasSERVIZI_APPLICATIVI = "c_sa";
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addFromTable("mapping_erogazione_pa", aliasMAPPING_EROGAZIONE_PA);
        sql.addFromTable("porte_applicative", aliasPORTE_APPLICATIVE);
        sql.addFromTable("porte_applicative_sa", aliasPORTE_APPLICATIVE_SA);
        sql.addFromTable("servizi_applicativi", aliasSERVIZI_APPLICATIVI);
        sql.addFromTable("connettori");
        sql.setANDLogicOperator(true);
        sql.addWhereCondition(aliasMAPPING_EROGAZIONE_PA + ".id_erogazione=servizi.id");
        sql.addWhereCondition(aliasMAPPING_EROGAZIONE_PA + ".id_porta=" + aliasPORTE_APPLICATIVE + ".id");
        sql.addWhereCondition(aliasPORTE_APPLICATIVE_SA + ".id_porta=" + aliasPORTE_APPLICATIVE + ".id");
        sql.addWhereCondition(aliasPORTE_APPLICATIVE_SA + ".id_servizio_applicativo=" + aliasSERVIZI_APPLICATIVI + ".id");
        sql.addWhereCondition(aliasSERVIZI_APPLICATIVI + ".id_connettore_inv=connettori.id");
        DBUtils.setFiltriConnettore(sql, tipoDB, tipoConnettore, endpointType, tipoConnettoreIntegrationManager, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug, aliasSERVIZI_APPLICATIVI);
        sqlQueryObject.addWhereExistsCondition(false, sql);
    }

    public static void setFiltriConnettoreFruizione(ISQLQueryObject sqlQueryObject, String tipoDB, TipiConnettore tipoConnettore, String endpointType, boolean tipoConnettoreIntegrationManager, String filtroConnettoreTokenPolicy, String filtroConnettoreEndpoint, String filtroConnettoreKeystore, String filtroConnettoreDebug) throws Exception {
        ISQLQueryObject sqlConnettoreDefault = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlConnettoreDefault.addFromTable("connettori");
        sqlConnettoreDefault.setANDLogicOperator(true);
        sqlConnettoreDefault.addWhereCondition("servizi_fruitori.id_connettore=connettori.id");
        DBUtils.setFiltriConnettore(sqlConnettoreDefault, tipoDB, tipoConnettore, endpointType, false, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug, null);
        ISQLQueryObject sqlGruppiConnettoreRidefinito = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlGruppiConnettoreRidefinito.addFromTable("servizi_fruitori_azioni");
        sqlGruppiConnettoreRidefinito.addFromTable("connettori");
        sqlGruppiConnettoreRidefinito.setANDLogicOperator(true);
        sqlGruppiConnettoreRidefinito.addWhereCondition("servizi_fruitori_azioni.id_fruizione=servizi_fruitori.id");
        sqlGruppiConnettoreRidefinito.addWhereCondition("servizi_fruitori_azioni.id_connettore=connettori.id");
        DBUtils.setFiltriConnettore(sqlGruppiConnettoreRidefinito, tipoDB, tipoConnettore, endpointType, false, filtroConnettoreTokenPolicy, filtroConnettoreEndpoint, filtroConnettoreKeystore, filtroConnettoreDebug, null);
        sqlQueryObject.addWhereCondition(false, new String[]{sqlConnettoreDefault.getWhereExistsCondition(false, sqlConnettoreDefault), sqlConnettoreDefault.getWhereExistsCondition(false, sqlGruppiConnettoreRidefinito)});
    }

    private static void setFiltriConnettore(ISQLQueryObject sqlQueryObject, String tipoDB, TipiConnettore tipoConnettore, String endpointType, boolean tipoConnettoreIntegrationManager, String filtroConnettoreTokenPolicy, String filtroConnettoreEndpoint, String filtroConnettoreKeystore, String filtroConnettoreDebug, String aliasTabellaServiziApplicativi) throws Exception {
        boolean setEndpointtype = false;
        if (endpointType != null) {
            sqlQueryObject.addWhereLikeCondition("connettori.endpointtype", endpointType, false, false, false);
            setEndpointtype = true;
        } else if (tipoConnettore != null && TipiConnettore.CUSTOM.equals((Object)tipoConnettore)) {
            TipiConnettore[] tipi;
            ArrayList<String> tipiConosciuti = new ArrayList<String>();
            for (TipiConnettore tipiConnettore : tipi = TipiConnettore.values()) {
                tipiConosciuti.add(tipiConnettore.getNome());
            }
            ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sql.addFromTable("connettori");
            sql.setANDLogicOperator(true);
            sql.setNOTBeforeConditions(true);
            sql.addWhereINCondition("connettori.endpointtype", true, tipiConosciuti.toArray(new String[1]));
            setEndpointtype = true;
            sqlQueryObject.addWhereCondition(sql.createSQLConditions());
        }
        if (tipoConnettoreIntegrationManager) {
            sqlQueryObject.addWhereLikeCondition(aliasTabellaServiziApplicativi + ".getmsginv", "abilitato", false, false, false);
        }
        if (filtroConnettoreTokenPolicy != null) {
            sqlQueryObject.addWhereLikeCondition("connettori.token_policy", filtroConnettoreTokenPolicy, false, false, false);
        }
        if (filtroConnettoreEndpoint != null) {
            ArrayList<String> query = new ArrayList<String>();
            if (tipoConnettore == null || TipiConnettore.HTTP.equals((Object)tipoConnettore)) {
                query.add(sqlQueryObject.getWhereLikeCondition("connettori.url", filtroConnettoreEndpoint, LikeConfig.contains((boolean)true)));
            }
            if (tipoConnettore == null || TipiConnettore.HTTPS.equals((Object)tipoConnettore)) {
                ISQLQueryObject exists = DBUtils.buildSQLQueryObjectConnettoreCustomPropertyContains(tipoDB, "location", filtroConnettoreEndpoint);
                query.add(sqlQueryObject.getWhereExistsCondition(false, exists));
            }
            if (tipoConnettore != null && TipiConnettore.FILE.equals((Object)tipoConnettore)) {
                ISQLQueryObject existsRequest = DBUtils.buildSQLQueryObjectConnettoreCustomPropertyContains(tipoDB, "outputFile", filtroConnettoreEndpoint);
                query.add(sqlQueryObject.getWhereExistsCondition(false, existsRequest));
                ISQLQueryObject existsRequestHeader = DBUtils.buildSQLQueryObjectConnettoreCustomPropertyContains(tipoDB, "outputFileHeaders", filtroConnettoreEndpoint);
                query.add(sqlQueryObject.getWhereExistsCondition(false, existsRequestHeader));
                ISQLQueryObject existsResponse = DBUtils.buildSQLQueryObjectConnettoreCustomPropertyContains(tipoDB, "inputFile", filtroConnettoreEndpoint);
                query.add(sqlQueryObject.getWhereExistsCondition(false, existsResponse));
                ISQLQueryObject existsResponseHeader = DBUtils.buildSQLQueryObjectConnettoreCustomPropertyContains(tipoDB, "inputFileHeaders", filtroConnettoreEndpoint);
                query.add(sqlQueryObject.getWhereExistsCondition(false, existsResponseHeader));
            }
            if (tipoConnettore != null && TipiConnettore.JMS.equals((Object)tipoConnettore)) {
                query.add(sqlQueryObject.getWhereLikeCondition("connettori.nome", filtroConnettoreEndpoint, LikeConfig.contains((boolean)true)));
                query.add(sqlQueryObject.getWhereLikeCondition("connettori.provurl", filtroConnettoreEndpoint, LikeConfig.contains((boolean)true)));
                query.add(sqlQueryObject.getWhereLikeCondition("connettori.connection_factory", filtroConnettoreEndpoint, LikeConfig.contains((boolean)true)));
                query.add(sqlQueryObject.getWhereLikeCondition("connettori.initcont", filtroConnettoreEndpoint, LikeConfig.contains((boolean)true)));
                query.add(sqlQueryObject.getWhereLikeCondition("connettori.urlpkg", filtroConnettoreEndpoint, LikeConfig.contains((boolean)true)));
            }
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
                if (!setEndpointtype) {
                    sqlQueryObject.addWhereCondition("connettori.endpointtype <> '" + TipiConnettore.DISABILITATO.getNome() + "'");
                }
            }
        }
        if (filtroConnettoreKeystore != null && (tipoConnettore == null || TipiConnettore.HTTPS.equals((Object)tipoConnettore))) {
            ISQLQueryObject existsKeystore = DBUtils.buildSQLQueryObjectConnettoreCustomPropertyContains(tipoDB, "keyStoreLocation", filtroConnettoreKeystore);
            ISQLQueryObject existsTruststore = DBUtils.buildSQLQueryObjectConnettoreCustomPropertyContains(tipoDB, "trustStoreLocation", filtroConnettoreKeystore);
            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereExistsCondition(false, existsKeystore), sqlQueryObject.getWhereExistsCondition(false, existsTruststore)});
        }
        if (filtroConnettoreDebug != null) {
            if ("Abilitato".equals(filtroConnettoreDebug)) {
                sqlQueryObject.addWhereCondition("connettori.debug=1");
            } else if ("Disabilitato".equals(filtroConnettoreDebug)) {
                sqlQueryObject.addWhereCondition("connettori.debug=0");
            }
        }
    }

    private static ISQLQueryObject buildSQLQueryObjectConnettoreCustomPropertyContains(String tipoDB, String nomeProprieta, String valoreProprieta) throws Exception {
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addFromTable("connettori_custom");
        sql.setANDLogicOperator(true);
        sql.addWhereCondition("connettori_custom.id_connettore=connettori.id");
        sql.addWhereLikeCondition("connettori_custom.name", nomeProprieta, false, false, false);
        sql.addWhereLikeCondition("connettori_custom.value", valoreProprieta, LikeConfig.contains((boolean)true));
        return sql;
    }

    public static void setFiltriModIApplicativi(ISQLQueryObject sqlQueryObject, String tipoDB, Boolean filtroModISicurezzaMessaggio, String filtroModIKeystorePath, String filtroModIKeystoreSubject, String filtroModIKeystoreIssuer, Boolean filtroModISicurezzaToken, String filtroModITokenPolicy, String filtroModITokenClientId, String filtroModIAudience, boolean checkCredenzialiBase) throws Exception {
        ISQLQueryObject sql;
        ProprietariProtocolProperty proprietario = ProprietariProtocolProperty.SERVIZIO_APPLICATIVO;
        String tabellaDB = "servizi_applicativi";
        ArrayList<ISQLQueryObject> listSqlQueryProtocolProperties = new ArrayList<ISQLQueryObject>();
        if (filtroModISicurezzaMessaggio != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaSecurityMessage", null, null, filtroModISicurezzaMessaggio);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (filtroModIKeystorePath != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaKeystorePath", null, filtroModIKeystorePath, null);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (filtroModIKeystoreSubject != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaKeyCNSubject", null, filtroModIKeystoreSubject, null);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (filtroModIKeystoreIssuer != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaKeyCNIssuer", null, filtroModIKeystoreIssuer, null);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (filtroModISicurezzaToken != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaSecurityToken", null, null, filtroModISicurezzaToken);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (filtroModITokenPolicy != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaSecurityTokenPolicy", null, filtroModITokenPolicy, null);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (filtroModITokenClientId != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaSecurityTokenClientId", null, filtroModITokenClientId, null);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (filtroModIAudience != null) {
            sql = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaSecurityMessageResponseAud", null, filtroModIAudience, null);
            listSqlQueryProtocolProperties.add(sql);
        }
        if (checkCredenzialiBase && (filtroModIKeystoreSubject != null || filtroModIKeystoreIssuer != null || filtroModITokenClientId != null)) {
            ISQLQueryObject sqlOr = sqlQueryObject.newSQLQueryObject();
            sqlOr.addFromTable("servizi_applicativi");
            sqlOr.setANDLogicOperator(false);
            ISQLQueryObject sqlModi = sqlQueryObject.newSQLQueryObject();
            sqlModi.setANDLogicOperator(true);
            for (ISQLQueryObject sql2 : listSqlQueryProtocolProperties) {
                sqlModi.addWhereExistsCondition(false, sql2);
            }
            sqlOr.addWhereCondition(sqlModi.createSQLConditions());
            ISQLQueryObject sqlCredenzialiBase = sqlQueryObject.newSQLQueryObject();
            sqlCredenzialiBase.setANDLogicOperator(true);
            String ssl = "ssl";
            String token = "token";
            if (filtroModITokenClientId != null) {
                sqlCredenzialiBase.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = '" + token + "'", "servizi_applicativi.tipoauth = '" + ssl + "' AND servizi_applicativi.token_policy IS NOT NULL"});
            } else {
                sqlCredenzialiBase.addWhereCondition("servizi_applicativi.tipoauth = '" + ssl + "'");
            }
            if (filtroModITokenClientId != null) {
                sqlCredenzialiBase.addWhereLikeCondition("servizi_applicativi.utente", filtroModITokenClientId, LikeConfig.contains((boolean)true, (boolean)true));
            }
            if (filtroModIKeystoreSubject != null) {
                sqlCredenzialiBase.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_subject", filtroModIKeystoreSubject, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.subject", filtroModIKeystoreSubject, LikeConfig.contains((boolean)true, (boolean)true))});
            }
            if (filtroModIKeystoreIssuer != null) {
                sqlCredenzialiBase.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("servizi_applicativi.cn_issuer", filtroModIKeystoreIssuer, LikeConfig.contains((boolean)true, (boolean)true)), sqlQueryObject.getWhereLikeCondition("servizi_applicativi.issuer", filtroModIKeystoreIssuer, LikeConfig.contains((boolean)true, (boolean)true))});
            }
            sqlOr.addWhereCondition(sqlCredenzialiBase.createSQLConditions());
            sqlQueryObject.addWhereCondition(sqlOr.createSQLConditions());
        } else if (!listSqlQueryProtocolProperties.isEmpty()) {
            for (ISQLQueryObject sql3 : listSqlQueryProtocolProperties) {
                sqlQueryObject.addWhereExistsCondition(false, sql3);
            }
        }
    }

    public static void setFiltriModIErogazione(ISQLQueryObject sqlQueryObject, String tipoDB, FiltroModIErogazioneFruizione modiFilter) throws Exception {
        DBUtils.setFiltriModIErogazioneFruizione(sqlQueryObject, tipoDB, modiFilter, true);
        ProprietariProtocolProperty proprietario = ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA;
        String tabellaDB = "servizi";
        if (modiFilter.getSignalHub() != null) {
            ISQLQueryObject sqlSignalHubTrue = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaInfoGenSignalHub", null, null, true);
            sqlQueryObject.addWhereExistsCondition(modiFilter.getSignalHub() == false, sqlSignalHubTrue);
        }
        if (modiFilter.getServiceId() != null) {
            DBUtils.addWhereExistConditionPropertyCSV(proprietario, tabellaDB, sqlQueryObject, tipoDB, "modipaInfoGenEserviceId", modiFilter.getServiceId());
        }
        if (modiFilter.getDescriptorId() != null) {
            DBUtils.addWhereExistConditionPropertyCSV(proprietario, tabellaDB, sqlQueryObject, tipoDB, "modipaInfoGenDescriptorId", modiFilter.getDescriptorId());
        }
    }

    private static void addWhereExistConditionPropertyCSV(ProprietariProtocolProperty proprietario, String tabellaDB, ISQLQueryObject sqlQueryObject, String tipoDB, String id, String value) throws Exception {
        ISQLQueryObject sqlServiceIdEquals = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, id, value, null, null);
        ISQLQueryObject sqlServiceIdStart = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, id, null, null, null);
        sqlServiceIdStart.addWhereLikeCondition("protocol_properties.value_string", value + ",", LikeConfig.startsWith((boolean)true));
        ISQLQueryObject sqlServiceIdEnd = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, id, null, null, null);
        sqlServiceIdEnd.addWhereLikeCondition("protocol_properties.value_string", "," + value, LikeConfig.endsWith((boolean)true));
        ISQLQueryObject sqlServiceIdContains = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, id, null, null, null);
        sqlServiceIdContains.addWhereLikeCondition("protocol_properties.value_string", "," + value + ",", LikeConfig.contains((boolean)true));
        sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereExistsCondition(false, sqlServiceIdEquals), sqlQueryObject.getWhereExistsCondition(false, sqlServiceIdStart), sqlQueryObject.getWhereExistsCondition(false, sqlServiceIdEnd), sqlQueryObject.getWhereExistsCondition(false, sqlServiceIdContains)});
    }

    public static void setFiltriModIFruizione(ISQLQueryObject sqlQueryObject, String tipoDB, String filtroModISicurezzaCanale, String filtroModISicurezzaMessaggio, String filtroModISorgenteToken, Boolean filtroModIDigestRichiesta, String filtroModIInfoUtente, String filtroModIKeystore, String filtroModIAudience) throws Exception {
        FiltroModIErogazioneFruizione modiFilter = new FiltroModIErogazioneFruizione();
        modiFilter.setSicurezzaCanale(filtroModISicurezzaCanale);
        modiFilter.setSicurezzaMessaggio(filtroModISicurezzaMessaggio);
        modiFilter.setSorgenteToken(filtroModISorgenteToken);
        modiFilter.setDigestRichiesta(filtroModIDigestRichiesta);
        modiFilter.setInfoUtente(filtroModIInfoUtente);
        modiFilter.setKeystore(filtroModIKeystore);
        modiFilter.setAudience(filtroModIAudience);
        DBUtils.setFiltriModIErogazioneFruizione(sqlQueryObject, tipoDB, modiFilter, false);
    }

    public static void setFiltriModIFruizione(ISQLQueryObject sqlQueryObject, String tipoDB, FiltroModIErogazioneFruizione modiFilter) throws Exception {
        DBUtils.setFiltriModIErogazioneFruizione(sqlQueryObject, tipoDB, modiFilter, false);
    }

    private static void setFiltriModIErogazioneFruizione(ISQLQueryObject sqlQueryObject, String tipoDB, FiltroModIErogazioneFruizione modiFilter, boolean erogazione) throws Exception {
        String tabellaDB;
        DBUtils.setFiltriModI(sqlQueryObject, tipoDB, modiFilter);
        ProprietariProtocolProperty proprietario = erogazione ? ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA : ProprietariProtocolProperty.FRUITORE;
        String string = tabellaDB = erogazione ? "servizi" : "servizi_fruitori";
        if (modiFilter.getKeystore() != null) {
            ArrayList<String> query = new ArrayList<String>();
            ISQLQueryObject sqlAccordoKeystore = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaKeystorePath", null, modiFilter.getKeystore(), null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoKeystore));
            ISQLQueryObject sqlAccordoKeystorePathPublicKey = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaKeystorePathPublicKey", null, modiFilter.getKeystore(), null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoKeystorePathPublicKey));
            ISQLQueryObject sqlAccordoTruststore = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaTruststorePath", null, modiFilter.getKeystore(), null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoTruststore));
            ISQLQueryObject sqlAccordoTruststoreCrl = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaTruststoreCRLs", null, modiFilter.getKeystore(), null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoTruststoreCrl));
            ISQLQueryObject sqlAccordoTruststoreSsl = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaSslTruststorePath", null, modiFilter.getKeystore(), null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoTruststoreSsl));
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
            }
        }
        if (modiFilter.getAudience() != null) {
            ISQLQueryObject sqlAudience = DBUtils.buildSQLQueryObjectProtocolProperties(proprietario, tabellaDB, tipoDB, "modipaSecurityMessageRequestAud", null, modiFilter.getAudience(), null);
            sqlQueryObject.addWhereExistsCondition(false, sqlAudience);
        }
    }

    public static void setFiltriModI(ISQLQueryObject sqlQueryObject, String tipoDB, String filtroModISicurezzaCanale, String filtroModISicurezzaMessaggio, String filtroModISorgenteToken, Boolean filtroModIDigestRichiesta, Boolean filtroModIDPoP, String filtroModIInfoUtente) throws Exception {
        FiltroModIErogazioneFruizione modiFilter = new FiltroModIErogazioneFruizione();
        modiFilter.setSicurezzaMessaggio(filtroModISicurezzaMessaggio);
        modiFilter.setSicurezzaCanale(filtroModISicurezzaCanale);
        modiFilter.setSorgenteToken(filtroModISorgenteToken);
        modiFilter.setDigestRichiesta(filtroModIDigestRichiesta);
        modiFilter.setDpop(filtroModIDPoP);
        modiFilter.setInfoUtente(filtroModIInfoUtente);
        DBUtils.setFiltriModI(sqlQueryObject, tipoDB, modiFilter);
    }

    public static void setFiltriModI(ISQLQueryObject sqlQueryObject, String tipoDB, FiltroModIErogazioneFruizione modiFilter) throws Exception {
        ISQLQueryObject sqlAccordoSec;
        ArrayList<String> query;
        if (modiFilter.getSicurezzaCanale() != null) {
            ISQLQueryObject sql = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, "accordi", tipoDB, "modipaSecurityChannelProfile", modiFilter.getSicurezzaCanale(), null, null);
            sqlQueryObject.addWhereExistsCondition(false, sql);
        }
        if (modiFilter.getSicurezzaMessaggio() != null) {
            query = new ArrayList<String>();
            sqlAccordoSec = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, "accordi", tipoDB, "modipaSecurityMessageProfile", modiFilter.getSicurezzaMessaggio(), null, null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoSec));
            DBUtils.addRestCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageProfile", modiFilter.getSicurezzaMessaggio(), null);
            DBUtils.addSoapCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageProfile", modiFilter.getSicurezzaMessaggio(), null);
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
            }
        }
        if (modiFilter.getSorgenteToken() != null) {
            query = new ArrayList();
            sqlAccordoSec = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, "accordi", tipoDB, "modipaSecurityMessageSorgenteToken", modiFilter.getSorgenteToken(), null, null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoSec));
            DBUtils.addRestCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageSorgenteToken", modiFilter.getSorgenteToken(), null);
            DBUtils.addSoapCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageSorgenteToken", modiFilter.getSorgenteToken(), null);
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
            }
        }
        if (modiFilter.getDigestRichiesta() != null) {
            query = new ArrayList();
            sqlAccordoSec = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, "accordi", tipoDB, "modipaSecurityMessageRequestDigest", null, null, true);
            query.add(sqlQueryObject.getWhereExistsCondition(modiFilter.getDigestRichiesta() == false, sqlAccordoSec));
            DBUtils.addRestCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageRequestDigest", null, modiFilter.getDigestRichiesta());
            DBUtils.addSoapCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageRequestDigest", null, modiFilter.getDigestRichiesta());
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
            }
        }
        if (modiFilter.getDpop() != null) {
            query = new ArrayList();
            sqlAccordoSec = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, "accordi", tipoDB, "modipaProfiloSicurezzaMessaggioDPoP", null, null, true);
            query.add(sqlQueryObject.getWhereExistsCondition(modiFilter.getDpop() == false, sqlAccordoSec));
            DBUtils.addRestCondition(query, sqlQueryObject, tipoDB, "modipaProfiloSicurezzaMessaggioDPoP", null, modiFilter.getDpop());
            DBUtils.addSoapCondition(query, sqlQueryObject, tipoDB, "modipaProfiloSicurezzaMessaggioDPoP", null, modiFilter.getDpop());
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
            }
        }
        if (modiFilter.getInfoUtente() != null) {
            query = new ArrayList();
            boolean enabled = true;
            ISQLQueryObject sqlAccordoSec2 = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, "accordi", tipoDB, "modipaSecurityMessageCorniceSicurezza", null, null, enabled);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoSec2));
            DBUtils.addRestCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageCorniceSicurezza", null, enabled);
            DBUtils.addSoapCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageCorniceSicurezza", null, enabled);
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
            }
            query = new ArrayList();
            ISQLQueryObject sqlAccordoSecPattern = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, "accordi", tipoDB, "modipaSecurityMessageCorniceSicurezzaPattern", modiFilter.getInfoUtente(), null, null);
            query.add(sqlQueryObject.getWhereExistsCondition(false, sqlAccordoSecPattern));
            DBUtils.addRestCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageCorniceSicurezzaPattern", modiFilter.getInfoUtente(), null);
            DBUtils.addSoapCondition(query, sqlQueryObject, tipoDB, "modipaSecurityMessageCorniceSicurezzaPattern", modiFilter.getInfoUtente(), null);
            if (!query.isEmpty()) {
                sqlQueryObject.addWhereCondition(false, query.toArray(new String[1]));
            }
        }
    }

    private static void addRestCondition(List<String> query, ISQLQueryObject sqlQueryObject, String tipoDB, String nomeProprieta, String valoreProprieta, Boolean valoreProprietaBoolean) throws Exception {
        String aliasRISORSE = "m_res";
        ISQLQueryObject sqlREST = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlREST.addFromTable("api_resources", aliasRISORSE);
        sqlREST.setANDLogicOperator(true);
        sqlREST.addWhereCondition(aliasRISORSE + ".id_accordo=accordi.id");
        ISQLQueryObject sqlRestSec = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.RESOURCE, aliasRISORSE, tipoDB, nomeProprieta, valoreProprieta, null, valoreProprietaBoolean);
        sqlREST.addWhereExistsCondition(false, sqlRestSec);
        query.add(sqlQueryObject.getWhereExistsCondition(false, sqlREST));
    }

    private static void addSoapCondition(List<String> query, ISQLQueryObject sqlQueryObject, String tipoDB, String nomeProprieta, String valoreProprieta, Boolean valoreProprietaBoolean) throws Exception {
        String aliasPORTTYPES = "m_pt";
        String aliasOPERATIONS = "m_op";
        ISQLQueryObject sqlSOAP = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlSOAP.addFromTable("port_type", aliasPORTTYPES);
        sqlSOAP.addFromTable("port_type_azioni", aliasOPERATIONS);
        sqlSOAP.setANDLogicOperator(true);
        sqlSOAP.addWhereCondition(aliasPORTTYPES + ".id_accordo=accordi.id");
        sqlSOAP.addWhereCondition(aliasOPERATIONS + ".id_port_type=" + aliasPORTTYPES + ".id");
        ISQLQueryObject sqlSoapSec = DBUtils.buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty.OPERATION, aliasOPERATIONS, tipoDB, nomeProprieta, valoreProprieta, null, valoreProprietaBoolean);
        sqlSOAP.addWhereExistsCondition(false, sqlSoapSec);
        query.add(sqlQueryObject.getWhereExistsCondition(false, sqlSOAP));
    }

    private static ISQLQueryObject buildSQLQueryObjectProtocolProperties(ProprietariProtocolProperty tipoProprietario, String tabellaProprietario, String tipoDB, String nomeProprieta, String valoreProprietaEquals, String valoreProprietaContains, Boolean valoreProprietaBoolean) throws Exception {
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addFromTable("protocol_properties");
        sql.setANDLogicOperator(true);
        sql.addWhereCondition("protocol_properties.id_proprietario=" + tabellaProprietario + ".id");
        sql.addWhereLikeCondition("protocol_properties.tipo_proprietario", tipoProprietario.name(), false, false, false);
        sql.addWhereLikeCondition("protocol_properties.name", nomeProprieta, false, false, false);
        if (valoreProprietaContains != null) {
            sql.addWhereLikeCondition("protocol_properties.value_string", valoreProprietaContains, LikeConfig.contains((boolean)true));
        } else if (valoreProprietaEquals != null) {
            sql.addWhereLikeCondition("protocol_properties.value_string", valoreProprietaEquals, false, false, false);
        }
        if (valoreProprietaBoolean != null) {
            if (valoreProprietaBoolean.booleanValue()) {
                sql.addWhereCondition("protocol_properties.value_boolean=1");
            } else {
                sql.addWhereCondition("protocol_properties.value_boolean=0");
            }
        }
        return sql;
    }

    public static void setFiltriProprietaApplicativo(ISQLQueryObject sqlQueryObject, String tipoDB, String nomeProprieta, String valoreProprieta) throws Exception {
        DBUtils.setFiltriProprieta(sqlQueryObject, tipoDB, ProprietariProtocolProperty.SERVIZIO_APPLICATIVO, null, nomeProprieta, valoreProprieta);
    }

    public static void setFiltriProprietaSoggetto(ISQLQueryObject sqlQueryObject, String tipoDB, String nomeProprieta, String valoreProprieta) throws Exception {
        DBUtils.setFiltriProprieta(sqlQueryObject, tipoDB, ProprietariProtocolProperty.SOGGETTO, null, nomeProprieta, valoreProprieta);
    }

    public static void setFiltriProprietaErogazione(ISQLQueryObject sqlQueryObject, String tipoDB, String nomeProprieta, String valoreProprieta) throws Exception {
        String aliasMAPPING_EROGAZIONE_PA = "c_map";
        String aliasPORTE_APPLICATIVE = "c_pa";
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addFromTable("mapping_erogazione_pa", aliasMAPPING_EROGAZIONE_PA);
        sql.addFromTable("porte_applicative", aliasPORTE_APPLICATIVE);
        sql.setANDLogicOperator(true);
        sql.addWhereCondition(aliasMAPPING_EROGAZIONE_PA + ".id_erogazione=servizi.id");
        sql.addWhereCondition(aliasMAPPING_EROGAZIONE_PA + ".id_porta=" + aliasPORTE_APPLICATIVE + ".id");
        DBUtils.setFiltriProprieta(sql, tipoDB, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA, aliasPORTE_APPLICATIVE, nomeProprieta, valoreProprieta);
        sqlQueryObject.addWhereExistsCondition(false, sql);
    }

    public static void setFiltriProprietaFruizione(ISQLQueryObject sqlQueryObject, String tipoDB, String nomeProprieta, String valoreProprieta) throws Exception {
        String aliasMAPPING_FRUIZIONE_PD = "c_map";
        String aliasPORTE_DELEGATE = "c_pd";
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addFromTable("mapping_fruizione_pd", aliasMAPPING_FRUIZIONE_PD);
        sql.addFromTable("porte_delegate", aliasPORTE_DELEGATE);
        sql.setANDLogicOperator(true);
        sql.addWhereCondition(aliasMAPPING_FRUIZIONE_PD + ".id_fruizione=servizi_fruitori.id");
        sql.addWhereCondition(aliasMAPPING_FRUIZIONE_PD + ".id_porta=" + aliasPORTE_DELEGATE + ".id");
        DBUtils.setFiltriProprieta(sql, tipoDB, ProprietariProtocolProperty.FRUITORE, aliasPORTE_DELEGATE, nomeProprieta, valoreProprieta);
        sqlQueryObject.addWhereExistsCondition(false, sql);
    }

    private static void setFiltriProprieta(ISQLQueryObject sqlQueryObject, String tipoDB, ProprietariProtocolProperty tipoProprietario, String tabellaAlias, String nomeProprieta, String valoreProprieta) throws Exception {
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        String nomeTabellaPrincipale = null;
        String nomeTabellaProprieta = null;
        String colonnaJoin = null;
        if (ProprietariProtocolProperty.SERVIZIO_APPLICATIVO.equals((Object)tipoProprietario)) {
            nomeTabellaPrincipale = "servizi_applicativi";
            nomeTabellaProprieta = "sa_properties";
            colonnaJoin = "id_servizio_applicativo";
        } else if (ProprietariProtocolProperty.SOGGETTO.equals((Object)tipoProprietario)) {
            nomeTabellaPrincipale = "soggetti";
            nomeTabellaProprieta = "soggetti_properties";
            colonnaJoin = "id_soggetto";
        } else if (ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA.equals((Object)tipoProprietario)) {
            nomeTabellaPrincipale = tabellaAlias;
            nomeTabellaProprieta = "pa_properties";
            colonnaJoin = "id_porta";
        } else if (ProprietariProtocolProperty.FRUITORE.equals((Object)tipoProprietario)) {
            nomeTabellaPrincipale = tabellaAlias;
            nomeTabellaProprieta = "pd_properties";
            colonnaJoin = "id_porta";
        } else {
            throw new Exception("Tipo proprietario '" + String.valueOf((Object)tipoProprietario) + "' non gestito");
        }
        sql.addFromTable(nomeTabellaProprieta);
        sql.setANDLogicOperator(true);
        sql.addWhereCondition(nomeTabellaProprieta + "." + colonnaJoin + "=" + nomeTabellaPrincipale + ".id");
        if (nomeProprieta != null) {
            sql.addWhereLikeCondition(nomeTabellaProprieta + ".nome", nomeProprieta, false, false, false);
        }
        if (valoreProprieta != null) {
            sql.addWhereLikeCondition(nomeTabellaProprieta + ".valore", valoreProprieta, LikeConfig.contains((boolean)true));
        }
        sqlQueryObject.addWhereExistsCondition(false, sql);
    }

    public static void setFiltriConfigurazioneErogazione(ISQLQueryObject sqlQueryObject, String tipoDB, String filtroStatoAPIImpl, String filtroAutenticazioneTokenPolicy, String filtroAutenticazioneTrasporto, String filtroRateLimitingStato, String filtroValidazioneStato, String filtroCacheRispostaStato, String filtroMessageSecurityStato, String filtroMTOMStato, String filtroTrasformazione, String filtroConfigurazioneTransazioni, String filtroCorrelazioneApplicativa, String filtroConfigurazioneDumpTipo, String filtroCORS, String filtroCORSOrigin) throws Exception {
        DBUtils._setFiltriConfigurazione(sqlQueryObject, tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSOrigin, true);
    }

    public static void setFiltriConfigurazioneFruizione(ISQLQueryObject sqlQueryObject, String tipoDB, String filtroStatoAPIImpl, String filtroAutenticazioneTokenPolicy, String filtroAutenticazioneTrasporto, String filtroRateLimitingStato, String filtroValidazioneStato, String filtroCacheRispostaStato, String filtroMessageSecurityStato, String filtroMTOMStato, String filtroTrasformazione, String filtroConfigurazioneTransazioni, String filtroCorrelazioneApplicativa, String filtroConfigurazioneDumpTipo, String filtroCORS, String filtroCORSOrigin) throws Exception {
        DBUtils._setFiltriConfigurazione(sqlQueryObject, tipoDB, filtroStatoAPIImpl, filtroAutenticazioneTokenPolicy, filtroAutenticazioneTrasporto, filtroRateLimitingStato, filtroValidazioneStato, filtroCacheRispostaStato, filtroMessageSecurityStato, filtroMTOMStato, filtroTrasformazione, filtroConfigurazioneTransazioni, filtroCorrelazioneApplicativa, filtroConfigurazioneDumpTipo, filtroCORS, filtroCORSOrigin, false);
    }

    public static void _setFiltriConfigurazione(ISQLQueryObject sqlQueryObject, String tipoDB, String filtroStatoAPIImpl, String filtroAutenticazioneTokenPolicy, String filtroAutenticazioneTrasporto, String filtroRateLimitingStato, String filtroValidazioneStato, String filtroCacheRispostaStato, String filtroMessageSecurityStato, String filtroMTOMStato, String filtroTrasformazione, String filtroConfigurazioneTransazioni, String filtroCorrelazioneApplicativa, String filtroConfigurazioneDumpTipo, String filtroCORS, String filtroCORSOrigin, boolean erogazioni) throws Exception {
        ISQLQueryObject sqlStato;
        String aliasCONFIGPORTA = "conf_p";
        String aliasCONFIGMAPPING = "conf_m";
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        if (erogazioni) {
            sql.addFromTable("porte_applicative", aliasCONFIGPORTA);
            sql.addFromTable("mapping_erogazione_pa", aliasCONFIGMAPPING);
        } else {
            sql.addFromTable("porte_delegate", aliasCONFIGPORTA);
            sql.addFromTable("mapping_fruizione_pd", aliasCONFIGMAPPING);
        }
        sql.setANDLogicOperator(true);
        if (erogazioni) {
            sql.addWhereCondition(aliasCONFIGMAPPING + ".id_erogazione=servizi.id");
            sql.addWhereCondition(aliasCONFIGMAPPING + ".id_porta=" + aliasCONFIGPORTA + ".id");
        } else {
            sql.addWhereCondition(aliasCONFIGMAPPING + ".id_fruizione=servizi_fruitori.id");
            sql.addWhereCondition(aliasCONFIGMAPPING + ".id_porta=" + aliasCONFIGPORTA + ".id");
        }
        if (filtroStatoAPIImpl != null && !"".equals(filtroStatoAPIImpl)) {
            if ("Abilitato".equals(filtroStatoAPIImpl)) {
                sqlStato = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                if (erogazioni) {
                    sqlStato.addFromTable("porte_applicative");
                } else {
                    sqlStato.addFromTable("porte_delegate");
                }
                sqlStato.setANDLogicOperator(false);
                sqlStato.addWhereLikeCondition(aliasCONFIGPORTA + ".stato", "abilitato", false, false, false);
                sqlStato.addWhereIsNullCondition(aliasCONFIGPORTA + ".stato");
                sql.addWhereCondition(sqlStato.createSQLConditions());
            } else if ("Disabilitato".equals(filtroStatoAPIImpl)) {
                sql.addWhereLikeCondition(aliasCONFIGPORTA + ".stato", "disabilitato", false, false, false);
            }
        }
        if (filtroAutenticazioneTokenPolicy != null && !"".equals(filtroAutenticazioneTokenPolicy)) {
            sql.addWhereLikeCondition(aliasCONFIGPORTA + ".token_policy", filtroAutenticazioneTokenPolicy, false, false, false);
        }
        if (filtroAutenticazioneTrasporto != null && !"".equals(filtroAutenticazioneTrasporto)) {
            sql.addWhereLikeCondition(aliasCONFIGPORTA + ".autenticazione", filtroAutenticazioneTrasporto, false, false, false);
        }
        if (filtroRateLimitingStato != null && !"".equals(filtroRateLimitingStato)) {
            String aliasRT = "rt_c";
            ISQLQueryObject sqlRT = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlRT.addFromTable("ct_active_policy", aliasRT);
            sqlRT.addSelectField(aliasRT, "id");
            sqlRT.setANDLogicOperator(true);
            sqlRT.addWhereCondition(aliasCONFIGPORTA + ".nome_porta=" + aliasRT + ".filtro_porta");
            String ruolo = erogazioni ? "applicativa" : "delegata";
            sqlRT.addWhereLikeCondition(aliasRT + ".filtro_ruolo", ruolo, false, false, false);
            if ("Abilitato".equals(filtroRateLimitingStato)) {
                sql.addWhereExistsCondition(false, sqlRT);
            } else if ("Disabilitato".equals(filtroRateLimitingStato)) {
                sql.addWhereExistsCondition(true, sqlRT);
            }
        }
        if (filtroValidazioneStato != null && !"".equals(filtroValidazioneStato)) {
            if ("Abilitato".equals(filtroValidazioneStato)) {
                sql.addWhereIsNotNullCondition(aliasCONFIGPORTA + ".validazione_contenuti_stato");
            } else if ("Disabilitato".equals(filtroValidazioneStato)) {
                sql.addWhereIsNullCondition(aliasCONFIGPORTA + ".validazione_contenuti_stato");
            }
        }
        if (filtroCacheRispostaStato != null && !"".equals(filtroCacheRispostaStato)) {
            if ("Disabilitato".equals(filtroCacheRispostaStato)) {
                sqlStato = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                if (erogazioni) {
                    sqlStato.addFromTable("porte_applicative");
                } else {
                    sqlStato.addFromTable("porte_delegate");
                }
                sqlStato.setANDLogicOperator(false);
                sqlStato.addWhereLikeCondition(aliasCONFIGPORTA + ".response_cache_stato", "disabilitato", false, false, false);
                sqlStato.addWhereIsNullCondition(aliasCONFIGPORTA + ".response_cache_stato");
                sql.addWhereCondition(sqlStato.createSQLConditions());
            } else if ("Abilitato".equals(filtroCacheRispostaStato)) {
                sql.addWhereLikeCondition(aliasCONFIGPORTA + ".response_cache_stato", "abilitato", false, false, false);
            }
        }
        if (filtroMessageSecurityStato != null && !"".equals(filtroMessageSecurityStato)) {
            if ("Abilitato".equals(filtroMessageSecurityStato) || "Disabilitato".equals(filtroMessageSecurityStato)) {
                sqlStato = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                if (erogazioni) {
                    sqlStato.addFromTable("porte_applicative");
                } else {
                    sqlStato.addFromTable("porte_delegate");
                }
                if ("Abilitato".equals(filtroMessageSecurityStato)) {
                    sqlStato.setANDLogicOperator(false);
                    sqlStato.addWhereIsNotNullCondition(aliasCONFIGPORTA + ".security_request_mode");
                    sqlStato.addWhereIsNotNullCondition(aliasCONFIGPORTA + ".security_response_mode");
                } else {
                    sqlStato.setANDLogicOperator(true);
                    sqlStato.addWhereIsNullCondition(aliasCONFIGPORTA + ".security_request_mode");
                    sqlStato.addWhereIsNullCondition(aliasCONFIGPORTA + ".security_response_mode");
                }
                sql.addWhereCondition(sqlStato.createSQLConditions());
            } else if ("Abilitato sulla richiesta".equals(filtroMessageSecurityStato)) {
                sql.addWhereIsNotNullCondition(aliasCONFIGPORTA + ".security_request_mode");
            } else if ("Abilitato sulla risposta".equals(filtroMessageSecurityStato)) {
                sql.addWhereIsNotNullCondition(aliasCONFIGPORTA + ".security_response_mode");
            }
        }
        if (filtroMTOMStato != null && !"".equals(filtroMTOMStato)) {
            if ("Abilitato".equals(filtroMTOMStato) || "Disabilitato".equals(filtroMTOMStato)) {
                sqlStato = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                if (erogazioni) {
                    sqlStato.addFromTable("porte_applicative");
                } else {
                    sqlStato.addFromTable("porte_delegate");
                }
                if ("Abilitato".equals(filtroMTOMStato)) {
                    sqlStato.setANDLogicOperator(false);
                    sqlStato.addWhereCondition(true, new String[]{aliasCONFIGPORTA + ".mtom_request_mode is not null", aliasCONFIGPORTA + ".mtom_request_mode <> 'disable'"});
                    sqlStato.addWhereCondition(true, new String[]{aliasCONFIGPORTA + ".mtom_response_mode is not null", aliasCONFIGPORTA + ".mtom_response_mode <> 'disable'"});
                } else {
                    sqlStato.setANDLogicOperator(true);
                    sqlStato.addWhereCondition(false, new String[]{aliasCONFIGPORTA + ".mtom_request_mode is null", aliasCONFIGPORTA + ".mtom_request_mode = 'disable'"});
                    sqlStato.addWhereCondition(false, new String[]{aliasCONFIGPORTA + ".mtom_response_mode is null", aliasCONFIGPORTA + ".mtom_response_mode = 'disable'"});
                }
                sql.addWhereCondition(sqlStato.createSQLConditions());
            } else if ("Abilitato sulla richiesta".equals(filtroMTOMStato)) {
                sql.addWhereCondition(true, new String[]{aliasCONFIGPORTA + ".mtom_request_mode is not null", aliasCONFIGPORTA + ".mtom_request_mode <> 'disable'"});
            } else if ("Abilitato sulla risposta".equals(filtroMTOMStato)) {
                sql.addWhereCondition(true, new String[]{aliasCONFIGPORTA + ".mtom_response_mode is not null", aliasCONFIGPORTA + ".mtom_response_mode <> 'disable'"});
            }
        }
        if (filtroTrasformazione != null && !"".equals(filtroTrasformazione)) {
            String aliasTRANSFORM = "tra_c";
            ISQLQueryObject sqlTrasformazione = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            if (erogazioni) {
                sqlTrasformazione.addFromTable("pa_transform", aliasTRANSFORM);
            } else {
                sqlTrasformazione.addFromTable("pd_transform", aliasTRANSFORM);
            }
            sqlTrasformazione.addSelectField(aliasTRANSFORM, "id");
            sqlTrasformazione.setANDLogicOperator(true);
            sqlTrasformazione.addWhereCondition(aliasCONFIGPORTA + ".id=" + aliasTRANSFORM + ".id_porta");
            sqlTrasformazione.addWhereLikeCondition(aliasTRANSFORM + ".stato", "abilitato", false, false, false);
            sql.addWhereExistsCondition(!"Abilitato".equals(filtroTrasformazione), sqlTrasformazione);
        }
        if (filtroConfigurazioneTransazioni != null && !"".equals(filtroConfigurazioneTransazioni)) {
            DBUtils.addFiltroConfigurazioneTransazioni(tipoDB, aliasCONFIGPORTA, filtroConfigurazioneTransazioni, erogazioni, sql);
        }
        if (filtroCorrelazioneApplicativa != null && !"".equals(filtroCorrelazioneApplicativa)) {
            String aliasCorrelazioneRichiesta = erogazioni ? "pa_correlazione" : "pd_correlazione";
            ISQLQueryObject sqlCorrelazioneRichiesta = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlCorrelazioneRichiesta.addFromTable(aliasCorrelazioneRichiesta);
            sqlCorrelazioneRichiesta.setANDLogicOperator(true);
            sqlCorrelazioneRichiesta.addWhereCondition(aliasCONFIGPORTA + ".id=" + aliasCorrelazioneRichiesta + ".id_porta");
            String aliasCorrelazioneRisposta = erogazioni ? "pa_correlazione_risposta" : "pd_correlazione_risposta";
            ISQLQueryObject sqlCorrelazioneRisposta = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlCorrelazioneRisposta.addFromTable(aliasCorrelazioneRisposta);
            sqlCorrelazioneRisposta.setANDLogicOperator(true);
            sqlCorrelazioneRisposta.addWhereCondition(aliasCONFIGPORTA + ".id=" + aliasCorrelazioneRisposta + ".id_porta");
            if ("Abilitato".equals(filtroCorrelazioneApplicativa) || "Disabilitato".equals(filtroCorrelazioneApplicativa)) {
                ISQLQueryObject sqlStato2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                if (erogazioni) {
                    sqlStato2.addFromTable("porte_applicative");
                } else {
                    sqlStato2.addFromTable("porte_delegate");
                }
                if ("Abilitato".equals(filtroCorrelazioneApplicativa)) {
                    sqlStato2.setANDLogicOperator(false);
                    sqlStato2.addWhereExistsCondition(false, sqlCorrelazioneRichiesta);
                    sqlStato2.addWhereExistsCondition(false, sqlCorrelazioneRisposta);
                } else {
                    sqlStato2.setANDLogicOperator(true);
                    sqlStato2.addWhereExistsCondition(true, sqlCorrelazioneRichiesta);
                    sqlStato2.addWhereExistsCondition(true, sqlCorrelazioneRisposta);
                }
                sql.addWhereCondition(sqlStato2.createSQLConditions());
            } else if ("Abilitato sulla richiesta".equals(filtroCorrelazioneApplicativa)) {
                sql.addWhereExistsCondition(false, sqlCorrelazioneRichiesta);
            } else if ("Abilitato sulla risposta".equals(filtroCorrelazioneApplicativa)) {
                sql.addWhereExistsCondition(false, sqlCorrelazioneRisposta);
            }
        }
        if (filtroConfigurazioneDumpTipo != null && !"".equals(filtroConfigurazioneDumpTipo)) {
            DBUtils.addFiltroConfigurazioneDump(tipoDB, aliasCONFIGPORTA, filtroConfigurazioneDumpTipo, erogazioni, sql);
        }
        if (filtroCORS != null && !"".equals(filtroCORS)) {
            if ("Default".equals(filtroCORS)) {
                sql.addWhereIsNullCondition(aliasCONFIGPORTA + ".cors_stato");
            } else if ("Ridefinito (abilitato)".equals(filtroCORS)) {
                sql.addWhereLikeCondition(aliasCONFIGPORTA + ".cors_stato", "abilitato", false, false, false);
                if (filtroCORSOrigin != null && !"".equals(filtroCORSOrigin)) {
                    sql.addWhereLikeCondition(aliasCONFIGPORTA + ".cors_allow_origins", filtroCORSOrigin, LikeConfig.contains((boolean)true));
                }
            } else if ("Ridefinito (disabilitato)".equals(filtroCORS)) {
                sql.addWhereLikeCondition(aliasCONFIGPORTA + ".cors_stato", "disabilitato", false, false, false);
            }
        }
        sqlQueryObject.addWhereExistsCondition(false, sql);
    }

    public static void addFiltroConfigurazioneTransazioni(String tipoDB, String aliasCONFIGPORTA, String filtroConfigurazioneTransazioni, boolean erogazioni, ISQLQueryObject sqlQueryQuery) throws SQLQueryObjectException {
        if ("Default".equals(filtroConfigurazioneTransazioni)) {
            sqlQueryQuery.addWhereCondition(aliasCONFIGPORTA + ".tracciamento_stato is NULL OR " + aliasCONFIGPORTA + ".tracciamento_stato='disabilitato'");
        } else {
            sqlQueryQuery.addWhereCondition(aliasCONFIGPORTA + ".tracciamento_stato='abilitato'");
            String aliasTRANSAZIONICONFIGDB = "trans_cdb";
            ISQLQueryObject sqlDB = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlDB.addFromTable("tracce_config", aliasTRANSAZIONICONFIGDB);
            sqlDB.addSelectField(aliasTRANSAZIONICONFIGDB, "id_proprietario");
            sqlDB.setANDLogicOperator(true);
            sqlDB.addWhereCondition(aliasCONFIGPORTA + ".id=" + aliasTRANSAZIONICONFIGDB + ".id_proprietario");
            sqlDB.addWhereCondition(aliasTRANSAZIONICONFIGDB + ".proprietario='" + (erogazioni ? "pa" : "pd") + "'");
            sqlDB.addWhereCondition(aliasTRANSAZIONICONFIGDB + ".tipo='db'");
            String aliasTRANSAZIONICONFIGFILETRACE = "trans_cft";
            ISQLQueryObject sqlFileTrace = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlFileTrace.addFromTable("tracce_config", aliasTRANSAZIONICONFIGFILETRACE);
            sqlFileTrace.addSelectField(aliasTRANSAZIONICONFIGFILETRACE, "id_proprietario");
            sqlFileTrace.setANDLogicOperator(true);
            sqlFileTrace.addWhereCondition(aliasCONFIGPORTA + ".id=" + aliasTRANSAZIONICONFIGFILETRACE + ".id_proprietario");
            sqlFileTrace.addWhereCondition(aliasTRANSAZIONICONFIGFILETRACE + ".proprietario='" + (erogazioni ? "pa" : "pd") + "'");
            sqlFileTrace.addWhereCondition(aliasTRANSAZIONICONFIGFILETRACE + ".tipo='filetrace'");
            if ("Ridefinito (abilitato database o filetrace)".equals(filtroConfigurazioneTransazioni) || "Ridefinito (abilitato solo database)".equals(filtroConfigurazioneTransazioni) || "Ridefinito (abilitato sia database che filetrace)".equals(filtroConfigurazioneTransazioni)) {
                sqlDB.addWhereCondition(aliasTRANSAZIONICONFIGDB + ".stato<>'disabilitato'");
            } else {
                sqlDB.addWhereCondition(aliasTRANSAZIONICONFIGDB + ".stato='disabilitato'");
            }
            if ("Ridefinito (abilitato database o filetrace)".equals(filtroConfigurazioneTransazioni) || "Ridefinito (abilitato solo filetrace)".equals(filtroConfigurazioneTransazioni) || "Ridefinito (abilitato sia database che filetrace)".equals(filtroConfigurazioneTransazioni)) {
                sqlFileTrace.addWhereCondition(aliasTRANSAZIONICONFIGFILETRACE + ".stato<>'disabilitato'");
            } else {
                sqlFileTrace.addWhereCondition(aliasTRANSAZIONICONFIGFILETRACE + ".stato='disabilitato'");
            }
            if ("Ridefinito (abilitato database o filetrace)".equals(filtroConfigurazioneTransazioni)) {
                ISQLQueryObject sqlUtilsDB = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                ISQLQueryObject sqlUtilsFileTrace = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryQuery.addWhereCondition(false, new String[]{sqlUtilsDB.getWhereExistsCondition(false, sqlDB), sqlUtilsFileTrace.getWhereExistsCondition(false, sqlFileTrace)});
            } else if ("Ridefinito (abilitato solo database)".equals(filtroConfigurazioneTransazioni) || "Ridefinito (abilitato solo filetrace)".equals(filtroConfigurazioneTransazioni) || "Ridefinito (abilitato sia database che filetrace)".equals(filtroConfigurazioneTransazioni) || "Ridefinito (disabilitato)".equals(filtroConfigurazioneTransazioni)) {
                sqlQueryQuery.addWhereExistsCondition(false, sqlDB);
                sqlQueryQuery.addWhereExistsCondition(false, sqlFileTrace);
            }
        }
    }

    public static void addFiltroConfigurazioneDump(String tipoDB, String aliasCONFIGPORTA, String filtroConfigurazioneDumpTipo, boolean erogazioni, ISQLQueryObject sqlQueryQuery) throws SQLQueryObjectException {
        String aliasDUMPCONFIG = "dump_c";
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addFromTable("dump_config", aliasDUMPCONFIG);
        sql.addSelectField(aliasDUMPCONFIG, "id_proprietario");
        sql.setANDLogicOperator(true);
        if (erogazioni) {
            sql.addWhereCondition(aliasCONFIGPORTA + ".id=" + aliasDUMPCONFIG + ".id_proprietario");
            sql.addWhereLikeCondition(aliasDUMPCONFIG + ".proprietario", "pa", false, false, false);
        } else {
            sql.addWhereCondition(aliasCONFIGPORTA + ".id=" + aliasDUMPCONFIG + ".id_proprietario");
            sql.addWhereLikeCondition(aliasDUMPCONFIG + ".proprietario", "pd", false, false, false);
        }
        boolean and = true;
        boolean or = false;
        boolean notExists = true;
        boolean exists = false;
        if ("Default".equals(filtroConfigurazioneDumpTipo)) {
            sqlQueryQuery.addWhereExistsCondition(notExists, sql);
        } else if ("Ridefinito (abilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla richiesta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla richiesta in uscita)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta in uscita)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla risposta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla risposta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla risposta in uscita)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta in uscita)".equals(filtroConfigurazioneDumpTipo)) {
            boolean soloHeader = "Ridefinito (solo header)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta in uscita)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta in uscita)".equals(filtroConfigurazioneDumpTipo);
            BooleanNullable payload = soloHeader ? BooleanNullable.FALSE() : BooleanNullable.TRUE();
            BooleanNullable headers = BooleanNullable.TRUE();
            boolean condizionePayloadHeaders = soloHeader ? and : or;
            ArrayList<ISQLQueryObject> sqlMessages = new ArrayList<ISQLQueryObject>();
            if ("Ridefinito (abilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla richiesta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta in ingresso)".equals(filtroConfigurazioneDumpTipo)) {
                ISQLQueryObject sqlRichiestaIngresso = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_richiesta_ingresso", payload, headers, condizionePayloadHeaders, sqlRichiestaIngresso, exists);
                sqlMessages.add(sqlRichiestaIngresso);
            }
            if ("Ridefinito (abilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla richiesta in uscita)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della richiesta in uscita)".equals(filtroConfigurazioneDumpTipo)) {
                ISQLQueryObject sqlRichiestaUscita = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_richiesta_uscita", payload, headers, condizionePayloadHeaders, sqlRichiestaUscita, exists);
                sqlMessages.add(sqlRichiestaUscita);
            }
            if ("Ridefinito (abilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla risposta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla risposta in ingresso)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta in ingresso)".equals(filtroConfigurazioneDumpTipo)) {
                ISQLQueryObject sqlRispostaIngresso = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_risposta_ingresso", payload, headers, condizionePayloadHeaders, sqlRispostaIngresso, exists);
                sqlMessages.add(sqlRispostaIngresso);
            }
            if ("Ridefinito (abilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla risposta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (abilitato sulla risposta in uscita)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (solo header della risposta in uscita)".equals(filtroConfigurazioneDumpTipo)) {
                ISQLQueryObject sqlRispostaUscita = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_risposta_uscita", payload, headers, condizionePayloadHeaders, sqlRispostaUscita, exists);
                sqlMessages.add(sqlRispostaUscita);
            }
            DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, sql, or, sqlMessages.toArray(new ISQLQueryObject[1]));
            sqlQueryQuery.addWhereExistsCondition(exists, sql);
        } else if ("Ridefinito (disabilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (disabilitato sulla richiesta)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (disabilitato sulla risposta)".equals(filtroConfigurazioneDumpTipo)) {
            BooleanNullable payload = BooleanNullable.FALSE();
            BooleanNullable headers = BooleanNullable.FALSE();
            boolean condizionePayloadHeaders = and;
            ArrayList<ISQLQueryObject> sqlMessages = new ArrayList<ISQLQueryObject>();
            if ("Ridefinito (disabilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (disabilitato sulla richiesta)".equals(filtroConfigurazioneDumpTipo)) {
                ISQLQueryObject sqlRichiestaIngresso = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_richiesta_ingresso", payload, headers, condizionePayloadHeaders, sqlRichiestaIngresso, exists);
                sqlMessages.add(sqlRichiestaIngresso);
                ISQLQueryObject sqlRichiestaUscita = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_richiesta_uscita", payload, headers, condizionePayloadHeaders, sqlRichiestaUscita, exists);
                sqlMessages.add(sqlRichiestaUscita);
            }
            if ("Ridefinito (disabilitato)".equals(filtroConfigurazioneDumpTipo) || "Ridefinito (disabilitato sulla risposta)".equals(filtroConfigurazioneDumpTipo)) {
                ISQLQueryObject sqlRispostaIngresso = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_risposta_ingresso", payload, headers, condizionePayloadHeaders, sqlRispostaIngresso, exists);
                sqlMessages.add(sqlRispostaIngresso);
                ISQLQueryObject sqlRispostaUscita = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, aliasDUMPCONFIG, "id_risposta_uscita", payload, headers, condizionePayloadHeaders, sqlRispostaUscita, exists);
                sqlMessages.add(sqlRispostaUscita);
            }
            DBUtils.setFiltriDumpRegolaConfigurazioneDumpEngine(tipoDB, sql, and, sqlMessages.toArray(new ISQLQueryObject[1]));
            sqlQueryQuery.addWhereExistsCondition(exists, sql);
        }
    }

    private static void setFiltriDumpRegolaConfigurazioneDumpEngine(String tipoDB, ISQLQueryObject sqlQueryObjectConditions, boolean and, ISQLQueryObject ... sqlQueryObjectMessage) throws SQLQueryObjectException {
        ArrayList<String> conditions = new ArrayList<String>();
        if (tipoDB != null) {
            // empty if block
        }
        if (sqlQueryObjectMessage != null && sqlQueryObjectMessage.length > 0) {
            for (ISQLQueryObject sql : sqlQueryObjectMessage) {
                conditions.add(sql.createSQLConditions());
            }
        }
        if (conditions.isEmpty()) {
            throw new SQLQueryObjectException("Usage error");
        }
        sqlQueryObjectConditions.addWhereCondition(and, conditions.toArray(new String[1]));
    }

    private static void setFiltriDumpRegolaConfigurazioneDumpEngine(String tipoDB, String aliasDUMPCONFIG, String colonna, BooleanNullable payload, BooleanNullable headers, boolean and, ISQLQueryObject sqlQueryObjectConditions, boolean notExists) throws SQLQueryObjectException {
        if (tipoDB != null) {
            // empty if block
        }
        String aliasDUMPCONFIGREGOLE = "dump_cr";
        ISQLQueryObject sql = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sql.addSelectField("id");
        sql.addFromTable("dump_config_regola", aliasDUMPCONFIGREGOLE);
        sql.setANDLogicOperator(true);
        sql.addWhereCondition(aliasDUMPCONFIG + "." + colonna + "=" + aliasDUMPCONFIGREGOLE + ".id");
        if (payload != null && payload.getValue() != null && headers != null && headers.getValue() != null) {
            sql.addWhereCondition(and, new String[]{sql.getWhereLikeCondition("payload", payload.getValue() != null && payload.getValue() != false ? "abilitato" : "disabilitato", false, false, false), sql.getWhereLikeCondition("headers", headers.getValue() != null && headers.getValue() != false ? "abilitato" : "disabilitato", false, false, false)});
        } else if (payload != null && payload.getValue() != null) {
            sql.addWhereLikeCondition("payload", payload.getValue() != null && payload.getValue() != false ? "abilitato" : "disabilitato", false, false, false);
        } else if (headers != null && headers.getValue() != null) {
            sql.addWhereLikeCondition("headers", headers.getValue() != null && headers.getValue() != false ? "abilitato" : "disabilitato", false, false, false);
        } else {
            throw new SQLQueryObjectException("Usage error");
        }
        sqlQueryObjectConditions.addWhereExistsCondition(notExists, sql);
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }

    public static List<String> convertToList(String v) {
        ArrayList<String> l = new ArrayList<String>();
        if (v != null && !"".equals(v)) {
            if (v.contains(",")) {
                String[] tmp = v.split(",");
                for (int i = 0; i < tmp.length; ++i) {
                    l.add(tmp[i].trim());
                }
            } else {
                l.add(v.trim());
            }
        }
        return l;
    }

    public static class FiltroModIErogazioneFruizione {
        private String sicurezzaCanale;
        private String sicurezzaMessaggio;
        private String sorgenteToken;
        private Boolean digestRichiesta;
        private Boolean dpop;
        private String infoUtente;
        private String keystore;
        private String audience;
        private Boolean signalHub;
        private String serviceId;
        private String descriptorId;

        public String getSicurezzaCanale() {
            return this.sicurezzaCanale;
        }

        public void setSicurezzaCanale(String sicurezzaCanale) {
            this.sicurezzaCanale = sicurezzaCanale;
        }

        public String getSicurezzaMessaggio() {
            return this.sicurezzaMessaggio;
        }

        public void setSicurezzaMessaggio(String sicurezzaMessaggio) {
            this.sicurezzaMessaggio = sicurezzaMessaggio;
        }

        public String getSorgenteToken() {
            return this.sorgenteToken;
        }

        public void setSorgenteToken(String sorgenteToken) {
            this.sorgenteToken = sorgenteToken;
        }

        public Boolean getDigestRichiesta() {
            return this.digestRichiesta;
        }

        public void setDigestRichiesta(Boolean digestRichiesta) {
            this.digestRichiesta = digestRichiesta;
        }

        public Boolean getDpop() {
            return this.dpop;
        }

        public void setDpop(Boolean dpop) {
            this.dpop = dpop;
        }

        public String getInfoUtente() {
            return this.infoUtente;
        }

        public void setInfoUtente(String infoUtente) {
            this.infoUtente = infoUtente;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public void setKeystore(String keystore) {
            this.keystore = keystore;
        }

        public String getAudience() {
            return this.audience;
        }

        public void setAudience(String audience) {
            this.audience = audience;
        }

        public Boolean getSignalHub() {
            return this.signalHub;
        }

        public void setSignalHub(Boolean signalHub) {
            this.signalHub = signalHub;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public String getDescriptorId() {
            return this.descriptorId;
        }

        public void setDescriptorId(String descriptorId) {
            this.descriptorId = descriptorId;
        }

        public boolean isFilterEnabled() {
            return this.sicurezzaCanale != null || this.sicurezzaMessaggio != null || this.sorgenteToken != null || this.digestRichiesta != null || this.dpop != null || this.infoUtente != null || this.keystore != null || this.audience != null || this.signalHub != null || this.serviceId != null || this.descriptorId != null;
        }
    }
}

