/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.commons.search.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.search.IdOperation;
import org.openspcoop2.core.commons.search.IdPortType;
import org.openspcoop2.core.commons.search.Operation;
import org.openspcoop2.core.commons.search.PortType;
import org.openspcoop2.core.commons.search.dao.IDBPortTypeServiceSearch;
import org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.commons.search.dao.jdbc.converter.OperationFieldConverter;
import org.openspcoop2.core.commons.search.dao.jdbc.fetch.OperationFetch;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.UtilsTemplate;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCOperationServiceSearchImpl
implements IJDBCServiceSearchWithId<Operation, IdOperation, JDBCServiceManager> {
    private OperationFieldConverter _operationFieldConverter = null;
    private OperationFetch operationFetch = new OperationFetch();
    private JDBCServiceManager jdbcServiceManager = null;

    public OperationFieldConverter getOperationFieldConverter() {
        if (this._operationFieldConverter == null) {
            this._operationFieldConverter = new OperationFieldConverter(this.jdbcServiceManager.getJdbcProperties().getDatabaseType());
        }
        return this._operationFieldConverter;
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.getOperationFieldConverter();
    }

    public OperationFetch getOperationFetch() {
        return this.operationFetch;
    }

    public IJDBCFetch getFetch() {
        return this.getOperationFetch();
    }

    public void setServiceManager(JDBCServiceManager serviceManager) throws ServiceException {
        this.jdbcServiceManager = serviceManager;
    }

    public JDBCServiceManager getServiceManager() throws ServiceException {
        return this.jdbcServiceManager;
    }

    public JDBCServiceManager getServiceManager(Connection connection, JDBCServiceManagerProperties jdbcProperties, Logger log) throws ServiceException {
        return new JDBCServiceManager(connection, jdbcProperties, log);
    }

    public IdOperation convertToId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Operation operation) throws NotImplementedException, ServiceException, Exception {
        IdOperation idOperation = new IdOperation();
        idOperation.setNome(operation.getNome());
        idOperation.setIdPortType(operation.getIdPortType());
        return idOperation;
    }

    public Operation get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdOperation id, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_operation = id != null && id.getId() != null && id.getId() > 0L ? id.getId() : this.findIdOperation(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, id_operation, idMappingResolutionBehaviour);
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdOperation id) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_operation = this.findIdOperation(jdbcProperties, log, connection, sqlQueryObject, id, false);
        return id_operation != null && id_operation > 0L;
    }

    public List<IdOperation> findAllIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<IdOperation> list = new ArrayList<IdOperation>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            Operation operation = this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
            IdOperation idOperation = this.convertToId(jdbcProperties, log, connection, sqlQueryObject, operation);
            list.add(idOperation);
        }
        return list;
    }

    public List<Operation> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<Operation> list = new ArrayList<Operation>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            list.add(this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour));
        }
        return list;
    }

    public Operation find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        long id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        if (id > 0L) {
            return this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    public NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List listaQuery = GenericJDBCUtilities.prepareCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model());
        sqlQueryObject.addSelectCountField(this.getOperationFieldConverter().toTable((IModel)Operation.model()) + ".id", "tot", true);
        this.joinEngine((IExpression)expression, sqlQueryObject);
        return GenericJDBCUtilities.count((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), (List)listaQuery);
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdOperation id) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long id_operation = this.findIdOperation(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, id_operation);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List<Map<String, Object>> map = this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, distinct, new IField[]{field});
        return GenericJDBCUtilities.selectSingleObject(map);
    }

    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        try {
            ISQLQueryObject sqlQueryObjectDistinct = GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((boolean)distinct, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (Logger)log, (ISQLFieldConverter)this.getOperationFieldConverter(), (IField[])field);
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression, sqlQueryObjectDistinct);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        }
    }

    public Object aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        Map<String, Object> map = this.aggregate(jdbcProperties, log, connection, sqlQueryObject, expression, new FunctionField[]{functionField});
        return GenericJDBCUtilities.selectAggregateObject(map, (FunctionField)functionField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (expression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (paginatedExpression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        }
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, expression, null);
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLQueryObject sqlQueryObjectDistinct) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        ArrayList listaQuery = new ArrayList();
        ArrayList listaParams = new ArrayList();
        List returnField = GenericJDBCUtilities.prepareSelect((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), listaQuery, listaParams);
        this.joinEngine(expression, sqlQueryObject);
        List list = GenericJDBCUtilities.select((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((ISQLQueryObject)sqlQueryObject, (ISQLQueryObject)sqlQueryObjectDistinct), (IExpression)expression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), listaQuery, listaParams, (List)returnField);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List list;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnion((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((list = GenericJDBCUtilities.union((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        NonNegativeNumber number;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((number = GenericJDBCUtilities.unionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && number.longValue() >= 0L) {
            return number;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public JDBCExpression newExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression((ISQLFieldConverter)this.getOperationFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression newPaginatedExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression((ISQLFieldConverter)this.getOperationFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCExpression toExpression(JDBCPaginatedExpression paginatedExpression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression(paginatedExpression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression toPaginatedExpression(JDBCExpression expression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression(expression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdOperation id, Operation obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, id, null));
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Operation obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, tableId, (IDMappingBehaviour)null));
    }

    private void _mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Operation obj, Operation imgSaved) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        if (imgSaved == null) {
            return;
        }
        obj.setId(imgSaved.getId());
        if (obj.getIdPortType() != null && imgSaved.getIdPortType() != null) {
            obj.getIdPortType().setId(imgSaved.getIdPortType().getId());
            if (obj.getIdPortType().getIdAccordoServizioParteComune() != null && imgSaved.getIdPortType().getIdAccordoServizioParteComune() != null) {
                obj.getIdPortType().getIdAccordoServizioParteComune().setId(imgSaved.getIdPortType().getIdAccordoServizioParteComune().getId());
                if (obj.getIdPortType().getIdAccordoServizioParteComune().getIdSoggetto() != null && imgSaved.getIdPortType().getIdAccordoServizioParteComune().getIdSoggetto() != null) {
                    obj.getIdPortType().getIdAccordoServizioParteComune().getIdSoggetto().setId(imgSaved.getIdPortType().getIdAccordoServizioParteComune().getIdSoggetto().getId());
                }
            }
        }
    }

    public Operation get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
    }

    private Operation getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        Operation operation = new Operation();
        ISQLQueryObject sqlQueryObjectGet_operation = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_operation.setANDLogicOperator(true);
        sqlQueryObjectGet_operation.addFromTable(this.getOperationFieldConverter().toTable((IModel)Operation.model()));
        sqlQueryObjectGet_operation.addSelectField("id");
        sqlQueryObjectGet_operation.addSelectField(this.getOperationFieldConverter().toColumn(Operation.model().NOME, true));
        sqlQueryObjectGet_operation.addWhereCondition("id=?");
        operation = (Operation)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_operation.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Operation.model(), (IJDBCFetch)this.getOperationFetch(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        ISQLQueryObject sqlQueryObjectGet_accordoServizioParteComune_pt = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_accordoServizioParteComune_pt.addFromTable(this.getOperationFieldConverter().toTable((IModel)Operation.model()));
        sqlQueryObjectGet_accordoServizioParteComune_pt.addSelectField("id_port_type");
        sqlQueryObjectGet_accordoServizioParteComune_pt.setANDLogicOperator(true);
        sqlQueryObjectGet_accordoServizioParteComune_pt.addWhereCondition("id=?");
        JDBCObject[] searchParams_accordoServizioParteComune_pt = new JDBCObject[]{new JDBCObject((Object)operation.getId(), Long.class)};
        Long id_accordoServizioParteComune_pt = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_accordoServizioParteComune_pt.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParams_accordoServizioParteComune_pt);
        IDBPortTypeServiceSearch search = (IDBPortTypeServiceSearch)this.getServiceManager(connection, jdbcProperties, log).getPortTypeServiceSearch();
        PortType pt = (PortType)search.get(id_accordoServizioParteComune_pt);
        IdPortType idPt = (IdPortType)search.convertToId(pt);
        operation.setIdPortType(idPt);
        return operation;
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this._exists(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private boolean _exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        boolean existsOperation = false;
        sqlQueryObject = sqlQueryObject.newSQLQueryObject();
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable(this.getOperationFieldConverter().toTable((IModel)Operation.model()));
        sqlQueryObject.addSelectField(this.getOperationFieldConverter().toColumn(Operation.model().NOME, true));
        sqlQueryObject.addWhereCondition("id=?");
        existsOperation = jdbcUtilities.exists(sqlQueryObject.createSQLQuery(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        return existsOperation;
    }

    private void joinEngine(IExpression expression, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        String tableName2;
        String tableName1;
        if (expression.inUseModel((IModel)Operation.model().ID_PORT_TYPE, false)) {
            tableName1 = this.getOperationFieldConverter().toTable((IModel)Operation.model());
            tableName2 = this.getOperationFieldConverter().toTable((IModel)Operation.model().ID_PORT_TYPE);
            sqlQueryObject.addWhereCondition(tableName1 + ".id_port_type=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE, false)) {
            tableName1 = this.getOperationFieldConverter().toTable((IModel)Operation.model().ID_PORT_TYPE);
            tableName2 = this.getOperationFieldConverter().toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE);
            sqlQueryObject.addWhereCondition(tableName1 + ".id_accordo=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO, false)) {
            tableName1 = this.getOperationFieldConverter().toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE);
            tableName2 = this.getOperationFieldConverter().toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO);
            sqlQueryObject.addWhereCondition(tableName1 + ".id_referente=" + tableName2 + ".id");
        }
        if (expression.inUseModel((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE, false) && !expression.inUseModel((IModel)Operation.model().ID_PORT_TYPE, false)) {
            sqlQueryObject.addFromTable(this.getOperationFieldConverter().toTable((IModel)Operation.model().ID_PORT_TYPE));
        }
        if (expression.inUseModel((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO, false) && !expression.inUseModel((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE, false)) {
            sqlQueryObject.addFromTable(this.getOperationFieldConverter().toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE));
        }
    }

    protected List<Object> getRootTablePrimaryKeyValuesEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdOperation id) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        ArrayList<Object> rootTableIdValues = new ArrayList<Object>();
        Long longId = this.findIdOperation(jdbcProperties, log, connection, sqlQueryObject.newSQLQueryObject(), id, true);
        rootTableIdValues.add(longId);
        return rootTableIdValues;
    }

    protected Map<String, List<IField>> getMapTableToPKColumnEngine() throws NotImplementedException, Exception {
        OperationFieldConverter converter = this.getOperationFieldConverter();
        HashMap<String, List<IField>> mapTableToPKColumn = new HashMap<String, List<IField>>();
        UtilsTemplate utilities = new UtilsTemplate();
        mapTableToPKColumn.put(converter.toTable((IModel)Operation.model()), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Operation.model()))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Operation.model().ID_PORT_TYPE), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Operation.model().ID_PORT_TYPE))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO))}));
        return mapTableToPKColumn;
    }

    public List<Long> findAllTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException, Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getOperationFieldConverter().toTable((IModel)Operation.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFindAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model());
        this.joinEngine((IExpression)paginatedExpression, sqlQueryObject);
        List listObjects = GenericJDBCUtilities.findAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), objectIdClass, (List)listaQuery);
        for (Object object : listObjects) {
            list.add((Long)object);
        }
        return list;
    }

    public long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, Exception {
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getOperationFieldConverter().toTable((IModel)Operation.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFind((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model());
        this.joinEngine((IExpression)expression, sqlQueryObject);
        Object res = GenericJDBCUtilities.find((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getOperationFieldConverter(), (IModel)Operation.model(), objectIdClass, (List)listaQuery);
        if (res != null && (Long)res > 0L) {
            return (Long)res;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private InUse inUseEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        InUse inUse = new InUse();
        inUse.setInUse(false);
        boolean throwNotImplemented = true;
        if (throwNotImplemented) {
            throw new NotImplementedException("NotImplemented");
        }
        return inUse;
    }

    public IdOperation findId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGet.addFromTable(this.getOperationFieldConverter().toTable((IModel)Operation.model()));
        sqlQueryObjectGet.addSelectField(this.getOperationFieldConverter().toColumn(Operation.model().NOME, true));
        sqlQueryObjectGet.addSelectField("id_port_type");
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addWhereCondition("id=?");
        JDBCObject[] searchParams_operation = new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)};
        ArrayList<Class> listaFieldIdReturnType_operation = new ArrayList<Class>();
        listaFieldIdReturnType_operation.add(String.class);
        listaFieldIdReturnType_operation.add(Long.class);
        IdOperation id_operation = null;
        List listaFieldId_operation = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_operation, searchParams_operation);
        if (listaFieldId_operation == null || listaFieldId_operation.size() <= 0) {
            if (throwNotFound) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        } else {
            id_operation = new IdOperation();
            id_operation.setNome((String)listaFieldId_operation.get(0));
            Long idPortTypeFK = (Long)listaFieldId_operation.get(1);
            id_operation.setIdPortType((IdPortType)((IDBPortTypeServiceSearch)this.getServiceManager(connection, jdbcProperties, log).getPortTypeServiceSearch()).findId(idPortTypeFK, true));
        }
        return id_operation;
    }

    public Long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdOperation id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        return this.findIdOperation(jdbcProperties, log, connection, sqlQueryObject, id, throwNotFound);
    }

    public List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeQuery((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)sql, returnClassTypes, (Object[])param);
    }

    protected Long findIdOperation(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdOperation id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        Long id_operation;
        block9: {
            if (jdbcProperties == null) {
                throw new ServiceException("Param jdbcProperties is null");
            }
            if (sqlQueryObject == null) {
                throw new ServiceException("Param sqlQueryObject is null");
            }
            if (id == null) {
                throw new ServiceException("Param id is null");
            }
            JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
            ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
            if (id.getIdPortType() == null) {
                throw new ServiceException("IdPortType non definito");
            }
            if (id.getIdPortType().getIdAccordoServizioParteComune() == null) {
                throw new ServiceException("IdPortType.getIdAccordoServizioParteComune non definito");
            }
            if (id.getIdPortType().getIdAccordoServizioParteComune().getIdSoggetto() == null) {
                throw new ServiceException("IdPortType.getIdAccordoServizioParteComune.getIdSoggetto non definito");
            }
            PortType pt = (PortType)this.getServiceManager(connection, jdbcProperties, log).getPortTypeServiceSearch().get(id.getIdPortType());
            sqlQueryObjectGet.addFromTable(this.getOperationFieldConverter().toTable((IModel)Operation.model()));
            sqlQueryObjectGet.addSelectField("id");
            sqlQueryObjectGet.setANDLogicOperator(true);
            sqlQueryObjectGet.setSelectDistinct(true);
            sqlQueryObjectGet.addWhereCondition(this.getOperationFieldConverter().toColumn(Operation.model().NOME, true) + "=?");
            sqlQueryObjectGet.addWhereCondition("id_port_type=?");
            JDBCObject[] searchParams_operation = new JDBCObject[]{new JDBCObject((Object)id.getNome(), String.class), new JDBCObject((Object)pt.getId(), Long.class)};
            id_operation = null;
            try {
                id_operation = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParams_operation);
            }
            catch (NotFoundException notFound) {
                if (!throwNotFound) break block9;
                throw new NotFoundException((Throwable)notFound);
            }
        }
        if ((id_operation == null || id_operation <= 0L) && throwNotFound) {
            throw GenericJDBCUtilities.newNotFoundException();
        }
        return id_operation;
    }
}

