/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver;

import java.util.ArrayList;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoDatiAttributeAuthority;
import org.openspcoop2.core.config.AccessoDatiAutenticazione;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoDatiConsegnaApplicativi;
import org.openspcoop2.core.config.AccessoDatiGestioneToken;
import org.openspcoop2.core.config.AccessoDatiKeystore;
import org.openspcoop2.core.config.AccessoDatiRichieste;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.utils.UpdateProprietaOggetto;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.serialization.IOException;

public class IDBuilder
implements org.openspcoop2.utils.serialization.IDBuilder {
    protected boolean prefix = false;

    public IDBuilder(boolean insertClassNamePrefix) {
        this.prefix = insertClassNamePrefix;
    }

    public IDBuilder() {
        this.prefix = false;
    }

    public static IDBuilder getIDBuilder() {
        return new IDBuilder();
    }

    public String toID(Object o) throws IOException {
        if (o == null) {
            throw new IOException("Oggetto is null");
        }
        try {
            if (o instanceof Soggetto) {
                Soggetto s = (Soggetto)o;
                String id = s.getTipo() + "/" + s.getNome();
                if (this.prefix) {
                    return "[Soggetto] " + id;
                }
                return id;
            }
            if (o instanceof ServizioApplicativo) {
                ServizioApplicativo s = (ServizioApplicativo)o;
                String id = s.getTipoSoggettoProprietario() + "/" + s.getNomeSoggettoProprietario() + "_" + s.getNome();
                if (this.prefix) {
                    return "[ServizioApplicativo] " + id;
                }
                return id;
            }
            if (o instanceof PortaDelegata) {
                PortaDelegata pd = (PortaDelegata)o;
                String id = pd.getTipoSoggettoProprietario() + "/" + pd.getNomeSoggettoProprietario() + "_" + pd.getNome();
                if (this.prefix) {
                    return "[PortaDelegata] " + id;
                }
                return id;
            }
            if (o instanceof PortaApplicativa) {
                PortaApplicativa pa = (PortaApplicativa)o;
                String id = pa.getTipoSoggettoProprietario() + "/" + pa.getNomeSoggettoProprietario() + "_" + pa.getNome();
                if (this.prefix) {
                    return "[PortaApplicativa] " + id;
                }
                return id;
            }
            if (o instanceof RoutingTable) {
                return "RoutingTable";
            }
            if (o instanceof GestioneErrore) {
                return "GestioneErrore";
            }
            if (o instanceof Configurazione) {
                return "Configurazione";
            }
            if (o instanceof AccessoRegistro) {
                return "ConfigurazioneRegistroServizi";
            }
            if (o instanceof AccessoRegistroRegistro) {
                AccessoRegistroRegistro registro = (AccessoRegistroRegistro)o;
                String id = registro.getNome();
                if (this.prefix) {
                    return "[ConfigurazioneRegistroServizi] " + id;
                }
                return id;
            }
            if (o instanceof AccessoConfigurazione) {
                return "ConfigurazioneAccessoDati";
            }
            if (o instanceof AccessoDatiAutenticazione) {
                return "ConfigurazioneAccessoDatiAutenticazione";
            }
            if (o instanceof AccessoDatiAutorizzazione) {
                return "ConfigurazioneAccessoDatiAutorizzazione";
            }
            if (o instanceof AccessoDatiGestioneToken) {
                return "ConfigurazioneAccessoDatiGestioneToken";
            }
            if (o instanceof AccessoDatiAttributeAuthority) {
                return "ConfigurazioneAccessoDatiAttributeAuthority";
            }
            if (o instanceof AccessoDatiKeystore) {
                return "ConfigurazioneAccessoDatiKeystore";
            }
            if (o instanceof AccessoDatiConsegnaApplicativi) {
                return "ConfigurazioneAccessoDatiConsegnaApplicativi";
            }
            if (o instanceof AccessoDatiRichieste) {
                return "ConfigurazioneAccessoDatiRichieste";
            }
            if (o instanceof SystemProperties) {
                return "Propriet\u00e0DiSistema";
            }
            if (o instanceof RegistroPlugin) {
                RegistroPlugin plugin = (RegistroPlugin)o;
                String id = plugin.getNome();
                if (this.prefix) {
                    return "[RegistroPlugin] " + id;
                }
                return id;
            }
            if (o instanceof RegistroPluginArchivio) {
                RegistroPluginArchivio plugin = (RegistroPluginArchivio)o;
                String id = plugin.getNome();
                if (this.prefix) {
                    return "[RegistroPluginArchivio] " + plugin.getNomePlugin() + "-" + id;
                }
                return id;
            }
            if (o instanceof ConfigurazioneUrlInvocazioneRegola) {
                ConfigurazioneUrlInvocazioneRegola regola = (ConfigurazioneUrlInvocazioneRegola)o;
                String id = regola.getNome();
                if (this.prefix) {
                    return "[UrlInvocazioneRegola] " + id;
                }
                return id;
            }
            if (o instanceof ConfigurazioneUrlInvocazione) {
                return "Configurazione UrlInvocazione";
            }
            if (o instanceof UpdateProprietaOggetto) {
                UpdateProprietaOggetto up = (UpdateProprietaOggetto)o;
                if (up.getIdPortaApplicativa() != null) {
                    if (this.prefix) {
                        return "[UpdateProprietaOggettoPortaApplicativa] " + up.getIdPortaApplicativa().getNome();
                    }
                    return "PA-" + up.getIdPortaApplicativa().getNome();
                }
                if (up.getIdPortaDelegata() != null) {
                    if (this.prefix) {
                        return "[UpdateProprietaOggettoPortaDelegata] " + up.getIdPortaDelegata().getNome();
                    }
                    return "PD-" + up.getIdPortaDelegata().getNome();
                }
                if (up.getIdServizioApplicativo() != null) {
                    IDSoggetto idSog = up.getIdServizioApplicativo().getIdSoggettoProprietario();
                    String idSA = idSog.getTipo() + "/" + idSog.getNome() + "_" + up.getIdServizioApplicativo().getNome();
                    if (this.prefix) {
                        return "[UpdateProprietaOggettoServizioApplicativo] " + idSA;
                    }
                    return "SA-" + idSA;
                }
                throw new IOException("Tipo di Oggetto gestito [" + o.getClass().getName() + "] senza id");
            }
        }
        catch (Exception e) {
            throw new IOException("Trasformazione non riuscita: " + e.getMessage(), (Throwable)e);
        }
        throw new IOException("Tipo di Oggetto non gestito [" + o.getClass().getName() + "]");
    }

    public String toID(Object o, String field) throws IOException {
        return this.toID(o) + "." + field;
    }

    public String toOldID(Object o) throws IOException {
        if (o == null) {
            throw new IOException("Oggetto is null");
        }
        try {
            if (o instanceof Soggetto) {
                Soggetto s = (Soggetto)o;
                if (s.getOldIDSoggettoForUpdate() == null) {
                    return null;
                }
                String id = s.getOldIDSoggettoForUpdate().getTipo() + "/" + s.getOldIDSoggettoForUpdate().getNome();
                if (this.prefix) {
                    return "[Soggetto] " + id;
                }
                return id;
            }
            if (o instanceof ServizioApplicativo) {
                ServizioApplicativo s = (ServizioApplicativo)o;
                if (s.getOldIDServizioApplicativoForUpdate() == null) {
                    return null;
                }
                if ((s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario() == null || s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getTipo() == null || s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getNome() == null) && s.getOldIDServizioApplicativoForUpdate().getNome() == null) {
                    return null;
                }
                String id = null;
                if (s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario() != null && s.getOldIDServizioApplicativoForUpdate().getNome() != null) {
                    id = s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getTipo() + "/" + s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getNome() + "_" + s.getOldIDServizioApplicativoForUpdate().getNome();
                } else if (s.getOldIDServizioApplicativoForUpdate().getNome() != null) {
                    id = s.getTipoSoggettoProprietario() + "/" + s.getNomeSoggettoProprietario() + "_" + s.getOldIDServizioApplicativoForUpdate().getNome();
                } else {
                    if (s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario() == null) {
                        throw new DriverConfigurazioneException("Oggetto in modifica non correttamente valorizzato");
                    }
                    id = s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getTipo() + "/" + s.getOldIDServizioApplicativoForUpdate().getIdSoggettoProprietario().getNome() + "__" + s.getNome();
                }
                if (this.prefix) {
                    return "[ServizioApplicativo] " + id;
                }
                return id;
            }
            if (o instanceof PortaDelegata) {
                PortaDelegata pd = (PortaDelegata)o;
                if (pd.getOldIDPortaDelegataForUpdate() == null || pd.getOldIDPortaDelegataForUpdate().getNome() == null) {
                    return null;
                }
                String id = pd.getOldIDPortaDelegataForUpdate().getNome();
                if (this.prefix) {
                    return "[PortaDelegata] " + id;
                }
                return id;
            }
            if (o instanceof PortaApplicativa) {
                PortaApplicativa pa = (PortaApplicativa)o;
                if (pa.getOldIDPortaApplicativaForUpdate() == null || pa.getOldIDPortaApplicativaForUpdate().getNome() == null) {
                    return null;
                }
                String id = pa.getOldIDPortaApplicativaForUpdate().getNome();
                if (this.prefix) {
                    return "[PortaApplicativa] " + id;
                }
                return id;
            }
            if (o instanceof RoutingTable) {
                return null;
            }
            if (o instanceof GestioneErrore) {
                return null;
            }
            if (o instanceof Configurazione) {
                return null;
            }
            if (o instanceof AccessoRegistro) {
                return null;
            }
            if (o instanceof AccessoRegistroRegistro) {
                return null;
            }
            if (o instanceof AccessoConfigurazione) {
                return null;
            }
            if (o instanceof AccessoDatiAutenticazione) {
                return null;
            }
            if (o instanceof AccessoDatiAutorizzazione) {
                return null;
            }
            if (o instanceof AccessoDatiGestioneToken) {
                return null;
            }
            if (o instanceof AccessoDatiAttributeAuthority) {
                return null;
            }
            if (o instanceof AccessoDatiKeystore) {
                return null;
            }
            if (o instanceof AccessoDatiConsegnaApplicativi) {
                return null;
            }
            if (o instanceof AccessoDatiRichieste) {
                return null;
            }
            if (o instanceof SystemProperties) {
                return null;
            }
            if (o instanceof RegistroPlugin) {
                RegistroPlugin plugin = (RegistroPlugin)o;
                if (plugin.getOldNome() == null) {
                    return null;
                }
                String id = plugin.getOldNome();
                if (this.prefix) {
                    return "[RegistroPlugin] " + id;
                }
                return id;
            }
            if (o instanceof RegistroPluginArchivio) {
                return null;
            }
            if (o instanceof ConfigurazioneUrlInvocazioneRegola) {
                ConfigurazioneUrlInvocazioneRegola regola = (ConfigurazioneUrlInvocazioneRegola)o;
                if (regola.getOldNome() == null) {
                    return null;
                }
                String id = regola.getOldNome();
                if (this.prefix) {
                    return "[UrlInvocazioneRegola] " + id;
                }
                return id;
            }
            if (o instanceof ConfigurazioneUrlInvocazione) {
                return null;
            }
            if (o instanceof UpdateProprietaOggetto) {
                return null;
            }
        }
        catch (Exception e) {
            throw new IOException("Trasformazione non riuscita: " + e.getMessage(), (Throwable)e);
        }
        throw new IOException("Tipo di Oggetto non gestito [" + o.getClass().getName() + "]");
    }

    public String[] getManagedObjects(boolean simpleName) throws IOException {
        ArrayList<String> oggetti = new ArrayList<String>();
        if (simpleName) {
            oggetti.add(Soggetto.class.getSimpleName());
            oggetti.add(ServizioApplicativo.class.getSimpleName());
            oggetti.add(PortaDelegata.class.getSimpleName());
            oggetti.add(PortaApplicativa.class.getSimpleName());
            oggetti.add(RoutingTable.class.getSimpleName());
            oggetti.add(GestioneErrore.class.getSimpleName());
            oggetti.add(Configurazione.class.getSimpleName());
            oggetti.add(AccessoRegistro.class.getSimpleName());
            oggetti.add(AccessoConfigurazione.class.getSimpleName());
            oggetti.add(AccessoDatiAutenticazione.class.getSimpleName());
            oggetti.add(AccessoDatiAutorizzazione.class.getSimpleName());
            oggetti.add(AccessoDatiGestioneToken.class.getSimpleName());
            oggetti.add(AccessoDatiAttributeAuthority.class.getSimpleName());
            oggetti.add(AccessoDatiKeystore.class.getSimpleName());
            oggetti.add(AccessoDatiConsegnaApplicativi.class.getSimpleName());
            oggetti.add(AccessoDatiRichieste.class.getSimpleName());
            oggetti.add(SystemProperties.class.getSimpleName());
            oggetti.add(RegistroPlugin.class.getSimpleName());
            oggetti.add(RegistroPluginArchivio.class.getSimpleName());
            oggetti.add(ConfigurazioneUrlInvocazioneRegola.class.getSimpleName());
            oggetti.add(ConfigurazioneUrlInvocazione.class.getSimpleName());
            oggetti.add(UpdateProprietaOggetto.class.getSimpleName());
        } else {
            oggetti.add(Soggetto.class.getName());
            oggetti.add(ServizioApplicativo.class.getName());
            oggetti.add(PortaDelegata.class.getName());
            oggetti.add(PortaApplicativa.class.getName());
            oggetti.add(RoutingTable.class.getName());
            oggetti.add(GestioneErrore.class.getName());
            oggetti.add(Configurazione.class.getName());
            oggetti.add(AccessoRegistro.class.getName());
            oggetti.add(AccessoRegistroRegistro.class.getName());
            oggetti.add(AccessoConfigurazione.class.getName());
            oggetti.add(AccessoDatiAutenticazione.class.getName());
            oggetti.add(AccessoDatiAutorizzazione.class.getName());
            oggetti.add(AccessoDatiGestioneToken.class.getName());
            oggetti.add(AccessoDatiAttributeAuthority.class.getName());
            oggetti.add(AccessoDatiKeystore.class.getName());
            oggetti.add(AccessoDatiConsegnaApplicativi.class.getName());
            oggetti.add(AccessoDatiRichieste.class.getName());
            oggetti.add(SystemProperties.class.getName());
            oggetti.add(RegistroPlugin.class.getName());
            oggetti.add(RegistroPluginArchivio.class.getName());
            oggetti.add(ConfigurazioneUrlInvocazioneRegola.class.getName());
            oggetti.add(ConfigurazioneUrlInvocazione.class.getName());
            oggetti.add(UpdateProprietaOggetto.class.getName());
        }
        String[] tmp = new String[1];
        return oggetti.toArray(tmp);
    }

    public String getSimpleName(Object o) throws IOException {
        if (o instanceof AccessoRegistroRegistro) {
            return AccessoRegistro.class.getSimpleName();
        }
        return o.getClass().getSimpleName();
    }
}

