/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Attachments;
import org.openspcoop2.core.config.Cache;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.Dump;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.GestioneErroreCodiceTrasporto;
import org.openspcoop2.core.config.GestioneErroreSoapFault;
import org.openspcoop2.core.config.IndirizzoRisposta;
import org.openspcoop2.core.config.InoltroBusteNonRiscontrate;
import org.openspcoop2.core.config.IntegrationManager;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazionePortaGestioneErrore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MessageSecurityFlow;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.MessaggiDiagnostici;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlow;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizio;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaSoggettoVirtuale;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.PortaDelegataServizio;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegataSoggettoErogatore;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.Risposte;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RouteGateway;
import org.openspcoop2.core.config.RouteRegistro;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDefault;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.StatoServiziPddIntegrationManager;
import org.openspcoop2.core.config.StatoServiziPddPortaApplicativa;
import org.openspcoop2.core.config.StatoServiziPddPortaDelegata;
import org.openspcoop2.core.config.TipoFiltroAbilitazioneServizi;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.config.ValidazioneBuste;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.AlgoritmoCache;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaGestioneIdentificazioneFallita;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaRichiestaIdentificazione;
import org.openspcoop2.core.config.constants.CorrelazioneApplicativaRispostaIdentificazione;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.FaultIntegrazioneTipo;
import org.openspcoop2.core.config.constants.GestioneErroreComportamento;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.RegistroTipo;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoConnessioneRisposte;
import org.openspcoop2.core.config.constants.ValidazioneBusteTipoControllo;
import org.openspcoop2.core.config.constants.ValidazioneContenutiApplicativiTipo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class ValidazioneSemantica {
    private Openspcoop2 configurazione = null;
    private List<String> errori = new ArrayList<String>();
    private Logger log = null;
    private boolean validazioneConfigurazione = false;
    private List<String> tipoConnettori = new ArrayList<String>();
    private List<String> tipoSoggetti = new ArrayList<String>();
    private List<String> tipoServiziSoap = new ArrayList<String>();
    private List<String> tipoServiziRest = new ArrayList<String>();
    private List<String> tipoMsgDiagnosticiAppender = new ArrayList<String>();
    private List<String> tipoTracciamentoAppender = new ArrayList<String>();
    private List<String> tipoDumpAppender = new ArrayList<String>();
    private List<String> tipoAutenticazionePortaDelegata = new ArrayList<String>();
    private List<String> tipoAutenticazionePortaApplicativa = new ArrayList<String>();
    private List<String> tipoAutorizzazionePortaDelegata = new ArrayList<String>();
    private List<String> tipoAutorizzazionePortaApplicativa = new ArrayList<String>();
    private List<String> tipoAutorizzazioneContenutoPortaDelegata = new ArrayList<String>();
    private List<String> tipoAutorizzazioneContenutoPortaApplicativa = new ArrayList<String>();
    private List<String> tipoIntegrazionePD = new ArrayList<String>();
    private List<String> tipoIntegrazionePA = new ArrayList<String>();

    private String getTipoConnettori() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoConnettori.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoConnettori.get(i));
        }
        return bf.toString();
    }

    private String getTipoSoggetti() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoSoggetti.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoSoggetti.get(i));
        }
        return bf.toString();
    }

    private String getTipoServiziSoap() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoServiziSoap.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServiziSoap.get(i));
        }
        return bf.toString();
    }

    private String getTipoServiziRest() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoServiziRest.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServiziRest.get(i));
        }
        return bf.toString();
    }

    private String getTipoServizi() {
        String rest;
        StringBuilder bf = new StringBuilder();
        String soap = this.getTipoServiziSoap();
        if (soap != null && !"".equals(soap)) {
            bf.append(soap);
        }
        if ((rest = this.getTipoServiziRest()) != null && !"".equals(rest)) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(rest);
        }
        return bf.toString();
    }

    private String getTipoMsgDiagnosticiAppender() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoMsgDiagnosticiAppender.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoMsgDiagnosticiAppender.get(i));
        }
        return bf.toString();
    }

    private String getTipoTracciamentoAppender() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoTracciamentoAppender.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoTracciamentoAppender.get(i));
        }
        return bf.toString();
    }

    private String getTipoDumpAppender() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoDumpAppender.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoDumpAppender.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutenticazionePortaDelegata() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoAutenticazionePortaDelegata.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutenticazionePortaDelegata.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutenticazionePortaApplicativa() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoAutenticazionePortaApplicativa.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutenticazionePortaApplicativa.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazionePortaDelegata() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoAutorizzazionePortaDelegata.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazionePortaDelegata.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazionePortaApplicativa() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoAutorizzazionePortaApplicativa.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazionePortaApplicativa.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazioneContenutoPortaDelegata() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoAutorizzazioneContenutoPortaDelegata.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazioneContenutoPortaDelegata.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazioneContenutoPortaApplicativa() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoAutorizzazioneContenutoPortaApplicativa.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazioneContenutoPortaApplicativa.get(i));
        }
        return bf.toString();
    }

    private String getTipoIntegrazionePD() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoIntegrazionePD.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoIntegrazionePD.get(i));
        }
        return bf.toString();
    }

    private String getTipoIntegrazionePA() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoIntegrazionePA.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoIntegrazionePA.get(i));
        }
        return bf.toString();
    }

    public ValidazioneSemantica(Openspcoop2 configurazione, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServiziSoap, String[] tipoServiziRest, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoDumpAppender, String[] tipoAutenticazionePortaDelegata, String[] tipoAutenticazionePortaApplicativa, String[] tipoAutorizzazionePortaDelegata, String[] tipoAutorizzazionePortaApplicativa, String[] tipoAutorizzazioneContenutoPortaDelegata, String[] tipoAutorizzazioneContenutoPortaApplicativa, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA, boolean validazioneConfigurazione, Logger log) throws DriverConfigurazioneException {
        int i;
        int i2;
        this.configurazione = configurazione;
        this.log = log;
        this.validazioneConfigurazione = validazioneConfigurazione;
        if (tipoConnettori != null && tipoConnettori.length > 0) {
            for (i2 = 0; i2 < tipoConnettori.length; ++i2) {
                this.tipoConnettori.add(tipoConnettori[i2]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di connettori ammissibili non definiti");
        }
        if (tipoSoggetti != null && tipoSoggetti.length > 0) {
            for (i2 = 0; i2 < tipoSoggetti.length; ++i2) {
                this.tipoSoggetti.add(tipoSoggetti[i2]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di soggetti ammissibili non definiti");
        }
        boolean tipiSoapNonEsistenti = false;
        if (tipoServiziSoap != null && tipoServiziSoap.length > 0) {
            for (int i3 = 0; i3 < tipoServiziSoap.length; ++i3) {
                this.tipoServiziSoap.add(tipoServiziSoap[i3]);
            }
        } else {
            tipiSoapNonEsistenti = true;
        }
        boolean tipiRestNonEsistenti = false;
        if (tipoServiziRest != null && tipoServiziRest.length > 0) {
            for (i = 0; i < tipoServiziRest.length; ++i) {
                this.tipoServiziRest.add(tipoServiziRest[i]);
            }
        } else {
            tipiRestNonEsistenti = true;
        }
        if (tipiSoapNonEsistenti && tipiRestNonEsistenti) {
            throw new DriverConfigurazioneException("Non sono stati configurati tipo di servizi ne per il service binding Soap ne per Rest");
        }
        if (tipoMsgDiagnosticiAppender != null && tipoMsgDiagnosticiAppender.length > 0) {
            for (i = 0; i < tipoMsgDiagnosticiAppender.length; ++i) {
                this.tipoMsgDiagnosticiAppender.add(tipoMsgDiagnosticiAppender[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di appender ammissibili per i msg diagnostici non definiti");
        }
        if (tipoTracciamentoAppender != null && tipoTracciamentoAppender.length > 0) {
            for (i = 0; i < tipoTracciamentoAppender.length; ++i) {
                this.tipoTracciamentoAppender.add(tipoTracciamentoAppender[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di appender ammissibili per le traccie non definiti");
        }
        if (tipoDumpAppender != null && tipoDumpAppender.length > 0) {
            for (i = 0; i < tipoDumpAppender.length; ++i) {
                this.tipoDumpAppender.add(tipoDumpAppender[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di appender ammissibili per il dump non definiti");
        }
        if (tipoAutenticazionePortaDelegata != null && tipoAutenticazionePortaDelegata.length > 0) {
            for (i = 0; i < tipoAutenticazionePortaDelegata.length; ++i) {
                this.tipoAutenticazionePortaDelegata.add(tipoAutenticazionePortaDelegata[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autenticazione porta delegata ammissibili non definiti");
        }
        if (tipoAutenticazionePortaApplicativa != null && tipoAutenticazionePortaApplicativa.length > 0) {
            for (i = 0; i < tipoAutenticazionePortaApplicativa.length; ++i) {
                this.tipoAutenticazionePortaApplicativa.add(tipoAutenticazionePortaApplicativa[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autenticazione porta applicativa ammissibili non definiti");
        }
        if (tipoAutorizzazionePortaDelegata != null && tipoAutorizzazionePortaDelegata.length > 0) {
            for (i = 0; i < tipoAutorizzazionePortaDelegata.length; ++i) {
                this.tipoAutorizzazionePortaDelegata.add(tipoAutorizzazionePortaDelegata[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione porta delegata ammissibili non definiti");
        }
        if (tipoAutorizzazionePortaApplicativa != null && tipoAutorizzazionePortaApplicativa.length > 0) {
            for (i = 0; i < tipoAutorizzazionePortaApplicativa.length; ++i) {
                this.tipoAutorizzazionePortaApplicativa.add(tipoAutorizzazionePortaApplicativa[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione porta applicativa ammissibili non definiti");
        }
        if (tipoAutorizzazioneContenutoPortaDelegata != null && tipoAutorizzazioneContenutoPortaDelegata.length > 0) {
            for (i = 0; i < tipoAutorizzazioneContenutoPortaDelegata.length; ++i) {
                this.tipoAutorizzazioneContenutoPortaDelegata.add(tipoAutorizzazioneContenutoPortaDelegata[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione contenuto porta delegata ammissibili non definiti");
        }
        if (tipoAutorizzazioneContenutoPortaApplicativa != null && tipoAutorizzazioneContenutoPortaApplicativa.length > 0) {
            for (i = 0; i < tipoAutorizzazioneContenutoPortaApplicativa.length; ++i) {
                this.tipoAutorizzazioneContenutoPortaApplicativa.add(tipoAutorizzazioneContenutoPortaApplicativa[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione contenuto porta applicativa ammissibili non definiti");
        }
        if (tipoIntegrazionePD != null && tipoIntegrazionePD.length > 0) {
            for (i = 0; i < tipoIntegrazionePD.length; ++i) {
                this.tipoIntegrazionePD.add(tipoIntegrazionePD[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di integrazione lato PortaDelegata ammissibili non definiti");
        }
        if (tipoIntegrazionePA != null && tipoIntegrazionePA.length > 0) {
            for (i = 0; i < tipoIntegrazionePA.length; ++i) {
                this.tipoIntegrazionePA.add(tipoIntegrazionePA[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di integrazione lato PortaApplicativa ammissibili non definiti");
        }
    }

    public ValidazioneSemantica(Openspcoop2 configurazione, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServiziSoap, String[] tipoServiziRest, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoDumpAppender, String[] tipoAutenticazionePortaDelegata, String[] tipoAutenticazionePortaApplicativa, String[] tipoAutorizzazionePortaDelegata, String[] tipoAutorizzazionePortaApplicativa, String[] tipoAutorizzazioneContenutoPortaDelegata, String[] tipoAutorizzazioneContenutoPortaApplicativa, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA, boolean validazioneConfigurazione) throws DriverConfigurazioneException {
        this(configurazione, tipoConnettori, tipoSoggetti, tipoServiziSoap, tipoServiziRest, tipoMsgDiagnosticiAppender, tipoTracciamentoAppender, tipoDumpAppender, tipoAutenticazionePortaDelegata, tipoAutenticazionePortaApplicativa, tipoAutorizzazionePortaDelegata, tipoAutorizzazionePortaApplicativa, tipoAutorizzazioneContenutoPortaDelegata, tipoAutorizzazioneContenutoPortaApplicativa, tipoIntegrazionePD, tipoIntegrazionePA, validazioneConfigurazione, null);
    }

    private void printMsg(String msg) {
        if (this.log == null) {
            this.printMsg(msg);
        } else {
            this.log.debug(msg);
        }
    }

    public void validazioneSemantica(boolean showIDOggettiAnalizzati) throws DriverConfigurazioneException {
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Soggetti(" + this.configurazione.sizeSoggettoList() + ")-----------------------------------------------------");
        }
        for (int i = 0; i < this.configurazione.sizeSoggettoList(); ++i) {
            Soggetto sogg = this.configurazione.getSoggetto(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Soggetto: " + sogg.getTipo() + "/" + sogg.getNome());
            }
            this.validaSoggetto(sogg, showIDOggettiAnalizzati);
        }
        if (this.validazioneConfigurazione) {
            if (showIDOggettiAnalizzati) {
                this.printMsg("\n\n------------------------------------Configurazione-----------------------------------------------------");
            }
            this.validaConfigurazione(this.configurazione.getConfigurazione());
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n-----------------------------------------------------------------------------------------");
        }
        if (!this.errori.isEmpty()) {
            StringBuilder stringB = new StringBuilder().append("\n");
            Iterator<String> itE = this.errori.iterator();
            while (itE.hasNext()) {
                stringB.append(itE.next()).append("\n");
            }
            throw new DriverConfigurazioneException(stringB.toString());
        }
    }

    private void validaSoggetto(Soggetto sogg, boolean showIDOggettiAnalizzati) throws DriverConfigurazioneException {
        int j;
        if (sogg.getNome() == null) {
            this.errori.add("Esiste un soggetto senza nome");
            return;
        }
        if (sogg.getTipo() == null) {
            this.errori.add("Esiste un soggetto senza tipo");
            return;
        }
        for (j = 0; j < sogg.sizePortaDelegataList(); ++j) {
            PortaDelegata pd = sogg.getPortaDelegata(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tPorta Delegata: " + pd.getNome());
            }
            this.validaPortaDelegata(pd, sogg);
        }
        for (j = 0; j < sogg.sizePortaApplicativaList(); ++j) {
            PortaApplicativa pa = sogg.getPortaApplicativa(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tPortaApplicativa: " + pa.getNome());
            }
            this.validaPortaApplicativa(pa, sogg);
        }
        for (j = 0; j < sogg.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = sogg.getServizioApplicativo(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tServizioApplicativo: " + sa.getNome());
            }
            this.validaServizioApplicativo(sa, sogg);
        }
        for (j = 0; j < sogg.sizeConnettoreList(); ++j) {
            Connettore connettore = sogg.getConnettore(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tConnettore definito nella root del soggetto: " + connettore.getNome());
            }
            this.validaConnettore(connettore, null, sogg);
        }
        if (!this.tipoSoggetti.contains(sogg.getTipo())) {
            this.errori.add("Il tipo del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)sogg.getNome(), (String)"^[0-9A-Za-z]+$")) {
                this.errori.add("Il nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo caratteri e cifre");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + ": " + e.getMessage(), e);
        }
        int numS = 0;
        for (int j2 = 0; j2 < this.configurazione.sizeSoggettoList(); ++j2) {
            Soggetto tmpSogg = this.configurazione.getSoggetto(j2);
            if (!sogg.getNome().equals(tmpSogg.getNome()) || !sogg.getTipo().equals(tmpSogg.getTipo())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto con nome " + sogg.getNome() + " e tipo " + sogg.getTipo());
        }
        if (sogg.getRouter()) {
            int numR = 0;
            for (int j3 = 0; j3 < this.configurazione.sizeSoggettoList(); ++j3) {
                Soggetto tmpS = this.configurazione.getSoggetto(j3);
                if (!tmpS.getRouter()) continue;
                ++numR;
            }
            if (numR > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto abilitato alla funzione di Router");
            }
        }
        try {
            if (sogg.getPdUrlPrefixRewriter() != null && !RegularExpressionEngine.isMatch((String)sogg.getPdUrlPrefixRewriter(), (String)"[A-Za-z]+:\\/\\/(.*)")) {
                this.errori.add("La funzione PdUrlPrefixRewriter contiene un valore errato che non rispetta l'espressione [A-Za-z]+:\\/\\/(.*)");
            }
            if (sogg.getPaUrlPrefixRewriter() != null && !RegularExpressionEngine.isMatch((String)sogg.getPaUrlPrefixRewriter(), (String)"[A-Za-z]+:\\/\\/(.*)")) {
                this.errori.add("La funzione PaUrlPrefixRewriter contiene un valore errato che non rispetta l'espressione [A-Za-z]+:\\/\\/(.*)");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e);
        }
    }

    private void validaPortaDelegata(PortaDelegata pd, Soggetto sogg) throws DriverConfigurazioneException {
        StatoFunzionalita stateless;
        StatoFunzionalita gestMan;
        StatoFunzionalita scartaBody;
        StatoFunzionalita allegaBody;
        String integrazione;
        StatoFunzionalita ricAsiAsim;
        ValidazioneContenutiApplicativi vca;
        MtomProcessor mtom;
        if (pd.getNome() == null) {
            this.errori.add("Il soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] posside una porta delegata che non contiene la definizione del nome");
            return;
        }
        String nomePorta = pd.getNome();
        String idPortaDelegata = "(" + sogg.getTipo() + "/" + sogg.getNome() + ") " + nomePorta;
        int numPD = 0;
        ArrayList<CallSite> pdTrovate = new ArrayList<CallSite>();
        for (int j = 0; j < this.configurazione.sizeSoggettoList(); ++j) {
            Soggetto s = this.configurazione.getSoggetto(j);
            for (int k = 0; k < s.sizePortaDelegataList(); ++k) {
                PortaDelegata tmpPd = s.getPortaDelegata(k);
                String tmpNomePorta = tmpPd.getNome();
                if (!nomePorta.equals(tmpNomePorta)) continue;
                ++numPD;
                pdTrovate.add((CallSite)((Object)("(" + s.getTipo() + "/" + s.getNome() + ") " + tmpPd.getNome())));
            }
        }
        if (numPD > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta delegata con nome " + nomePorta + ". Sono state identificate le seguenti porte delegate: " + String.valueOf(pdTrovate));
        }
        if (pd.getSoggettoErogatore() == null) {
            this.errori.add("La porta delegata " + idPortaDelegata + " non contiene la definizione del soggetto erogatore");
        } else {
            PortaDelegataSoggettoErogatore pdsse = pd.getSoggettoErogatore();
            if (pdsse.getTipo() == null) {
                this.errori.add("Il soggetto erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del tipo.");
            } else if (!this.tipoSoggetti.contains(pdsse.getTipo())) {
                this.errori.add("Il tipo del soggetto erogatore della porta delegata " + idPortaDelegata + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
            }
            if (pdsse.getNome() == null) {
                this.errori.add("Il soggetto erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del nome");
            }
        }
        if (pd.getServizio() == null) {
            this.errori.add("La porta delegata " + idPortaDelegata + " non contiene la definizione del servizio");
        } else {
            PortaDelegataServizio pds = pd.getServizio();
            if (pds.getTipo() == null) {
                this.errori.add("Il servizio della porta delegata " + idPortaDelegata + " non contiene la definizione del tipo.");
            } else if (!this.tipoServiziSoap.contains(pds.getTipo()) && !this.tipoServiziRest.contains(pds.getTipo())) {
                this.errori.add("Il tipo del servizio della porta delegata " + idPortaDelegata + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoServizi() + ")");
            }
            if (pds.getNome() == null) {
                this.errori.add("Il servizio della porta delegata " + idPortaDelegata + " non contiene la definizione del nome");
            }
        }
        if (pd.getAzione() != null) {
            PortaDelegataAzione pda = pd.getAzione();
            PortaDelegataAzioneIdentificazione identificazione = pda.getIdentificazione();
            if (!(identificazione == null || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC) || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_HEADER_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_INPUT_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_SOAP_ACTION_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_WSDL_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_DELEGATED_BY))) {
                this.errori.add("La modalita d'identificazione dell'azione della porta delegata " + idPortaDelegata + " deve assumere uno dei seguente valori: " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC) + ", " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED) + ", " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED) + ", " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_HEADER_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_INPUT_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_SOAP_ACTION_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_WSDL_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_DELEGATED_BY));
            }
            if (identificazione == null) {
                identificazione = CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC;
            }
            if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC.equals(identificazione)) {
                if (pda.getNome() == null) {
                    this.errori.add("L'azione della porta delegata " + idPortaDelegata + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
                }
            } else if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED.equals(identificazione) || CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED.equals(identificazione) || CostantiConfigurazione.PORTA_DELEGATA_AZIONE_HEADER_BASED.equals(identificazione)) {
                if (pda.getPattern() == null) {
                    this.errori.add("L'azione della porta delegata " + idPortaDelegata + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
                }
            } else if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_DELEGATED_BY.equals(identificazione) && pda.getNomePortaDelegante() == null) {
                this.errori.add("L'azione della porta delegata " + idPortaDelegata + " non contiene la definizione del nome della porta delegante, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
            }
        }
        String autenticazione = CredenzialeTipo.SSL.toString();
        if (pd.getAutenticazione() != null) {
            autenticazione = pd.getAutenticazione();
            if (!this.tipoAutenticazionePortaDelegata.contains(pd.getAutenticazione())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autenticazione [" + pd.getAutenticazione() + "] non valido; tipi conosciuti: " + this.getTipoAutenticazionePortaDelegata());
            }
        }
        String autorizzazione = "authenticated";
        if (pd.getAutorizzazione() != null) {
            autorizzazione = pd.getAutorizzazione();
            if (!this.tipoAutorizzazionePortaDelegata.contains(pd.getAutorizzazione())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autorizzazione [" + pd.getAutorizzazione() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazionePortaDelegata());
            }
        }
        if (autorizzazione != null) {
            if (autorizzazione.toLowerCase().contains("authenticated") && autorizzazione.toLowerCase().contains("roles") && !StatoFunzionalita.ABILITATO.equals(pd.getAutenticazioneOpzionale())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione dei servizi applicativi opzionali");
            }
            if (autorizzazione.toLowerCase().contains("internal") || "authenticated".equals(autorizzazione)) {
                if ("none".equals(autenticazione)) {
                    this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei servizi applicativi, autenticazione non impostata nella porta delegata");
                }
                if (StatoFunzionalita.ABILITATO.equals(pd.getAutenticazioneOpzionale()) && !autorizzazione.toLowerCase().contains("or")) {
                    this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei servizi applicativi, autenticazione impostata come opzionale nella porta delegata");
                }
            }
        }
        if (pd.getAutorizzazioneContenuto() != null && !this.tipoAutorizzazioneContenutoPortaDelegata.contains(pd.getAutorizzazioneContenuto())) {
            this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autorizzazione contenuto [" + pd.getAutorizzazioneContenuto() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazioneContenutoPortaDelegata());
        }
        for (int i = 0; i < pd.sizeServizioApplicativoList(); ++i) {
            PortaDelegataServizioApplicativo pdSa = pd.getServizioApplicativo(i);
            ServizioApplicativo sa = null;
            if (pdSa.getNome() == null) {
                this.errori.add("La porta delegata " + idPortaDelegata + " ha associato un servizio applicativo per cui non e' stato definito il nome");
                continue;
            }
            if (!this.existsServizioApplicativo(pdSa.getNome(), sogg)) {
                this.errori.add("La porta delegata " + idPortaDelegata + " ha associato un riferimento ad un servizio applicativo [" + pdSa.getNome() + "] che non risulta registrato nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
                continue;
            }
            sa = this.getServizioApplicativo(pdSa.getNome(), sogg);
            if (sa == null) {
                this.errori.add("La porta delegata " + idPortaDelegata + " ha associato un riferimento ad un servizio applicativo [" + pdSa.getNome() + "] che non risulta registrato nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
                continue;
            }
            if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.equals(autenticazione)) continue;
            if (sa.getInvocazionePorta() == null) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione dell'elemento invocazione porta");
                continue;
            }
            if (sa.getInvocazionePorta().sizeCredenzialiList() <= 0) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione di credenziali di accesso");
                continue;
            }
            if (!CostantiConfigurazione.CREDENZIALE_BASIC.equals(autenticazione) && !CostantiConfigurazione.CREDENZIALE_APIKEY.equals(autenticazione) && !CostantiConfigurazione.CREDENZIALE_SSL.equals(autenticazione) && !CostantiConfigurazione.CREDENZIALE_PRINCIPAL.equals(autenticazione)) continue;
            boolean trovato = false;
            for (int k = 0; k < sa.getInvocazionePorta().sizeCredenzialiList(); ++k) {
                if (!autenticazione.equals(sa.getInvocazionePorta().getCredenziali(k).getTipo().getValue())) continue;
                trovato = true;
                break;
            }
            if (trovato) continue;
            this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione di credenziali di accesso compatibili");
        }
        for (int j = 0; j < pd.sizeProprietaList(); ++j) {
            Proprieta ssp = pd.getProprieta(j);
            this.validaProtocolProperty(ssp, "PortaDelegata_" + idPortaDelegata);
        }
        MessageSecurity messageSecurity = pd.getMessageSecurity();
        if (messageSecurity != null) {
            this.validaMessageSecurity(messageSecurity, "PortaDelegata_" + idPortaDelegata);
        }
        if ((mtom = pd.getMtomProcessor()) != null) {
            this.validaMTOM(mtom, "PortaDelegata_" + idPortaDelegata);
        }
        if ((vca = pd.getValidazioneContenutiApplicativi()) != null) {
            this.validazioneValidazioneContenutiApplicativi(vca, "PortaDelegata_" + idPortaDelegata);
        }
        String idRisorsa = "Porta delegata " + idPortaDelegata;
        this.validaCorrelazioneApplicativaRichiesta(idRisorsa, pd.getCorrelazioneApplicativa(), true);
        this.validaCorrelazioneApplicativaRisposta(idRisorsa, pd.getCorrelazioneApplicativaRisposta(), true);
        StatoFunzionalita ricAsiSim = pd.getRicevutaAsincronaSimmetrica();
        if (ricAsiSim != null && !ricAsiSim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiSim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona simmetrica della porta delegata " + idPortaDelegata + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((ricAsiAsim = pd.getRicevutaAsincronaAsimmetrica()) != null && !ricAsiAsim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiAsim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona asimmetrica della porta delegata " + idPortaDelegata + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((integrazione = pd.getIntegrazione()) != null) {
            String[] tipiIntegrazione = integrazione.split(",");
            if (tipiIntegrazione == null || tipiIntegrazione.length <= 0) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un valore nel campo 'integrazione' non valido: " + integrazione);
            } else {
                for (int p = 0; p < tipiIntegrazione.length; ++p) {
                    String tipoI = tipiIntegrazione[p].trim();
                    if (this.tipoIntegrazionePD.contains(tipoI)) continue;
                    this.errori.add("La porta delegata " + idPortaDelegata + " possiede un tipo di integrazione [" + tipoI + "] non valido: valori utilizzabili sono: " + this.getTipoIntegrazionePD());
                }
            }
        }
        if ((allegaBody = pd.getAllegaBody()) != null && !allegaBody.equals(CostantiConfigurazione.ABILITATO) && !allegaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di allega-boxy della porta delegata " + idPortaDelegata + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((scartaBody = pd.getScartaBody()) != null && !scartaBody.equals(CostantiConfigurazione.ABILITATO) && !scartaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di scarta-boxy della porta delegata " + idPortaDelegata + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((gestMan = pd.getGestioneManifest()) != null && !gestMan.equals(CostantiConfigurazione.ABILITATO) && !gestMan.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di gestioneManifest della porta delegata " + idPortaDelegata + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((stateless = pd.getStateless()) != null && !stateless.equals(CostantiConfigurazione.ABILITATO) && !stateless.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' 'stateless' della porta delegata " + idPortaDelegata + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        StatoFunzionalita localForward = null;
        if (pd.getLocalForward() != null) {
            localForward = pd.getLocalForward().getStato();
        }
        if (localForward != null && !localForward.equals(CostantiConfigurazione.ABILITATO) && !localForward.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' 'local-forward' della porta delegata " + idPortaDelegata + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if (pd.getRuoli() != null) {
            int i;
            for (i = 0; i < pd.getRuoli().sizeRuoloList(); ++i) {
                String nomeRuolo = pd.getRuoli().getRuolo(i).getNome();
                try {
                    if (RegularExpressionEngine.isMatch((String)nomeRuolo, (String)"^[0-9A-Za-z_]+$")) continue;
                    this.errori.add("Il ruolo [" + nomeRuolo + "] della porta delegata " + idPortaDelegata + " dev'essere formato solo da caratteri, cifre e '_'");
                    continue;
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " della porta delegata " + idPortaDelegata + " :" + e.getMessage(), e);
                }
            }
            for (i = 0; i < pd.getRuoli().sizeRuoloList(); ++i) {
                int numRuolo = 0;
                String tmpRuolo = pd.getRuoli().getRuolo(i).getNome();
                for (int j = 0; j < pd.getRuoli().sizeRuoloList(); ++j) {
                    String checkRuolo = pd.getRuoli().getRuolo(j).getNome();
                    if (!checkRuolo.equals(tmpRuolo)) continue;
                    ++numRuolo;
                }
                if (numRuolo <= true) continue;
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nella porta delegata " + idPortaDelegata);
            }
        }
    }

    private void validaPortaApplicativa(PortaApplicativa pa, Soggetto sogg) throws DriverConfigurazioneException {
        StatoFunzionalita stateless;
        StatoFunzionalita gestMan;
        StatoFunzionalita scartaBody;
        StatoFunzionalita allegaBody;
        String integrazione;
        StatoFunzionalita ricAsiAsim;
        StatoFunzionalita ricAsiSim;
        ValidazioneContenutiApplicativi vca;
        MtomProcessor mtom;
        if (pa.getNome() == null) {
            this.errori.add("Il soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] posside una porta applicativa che non contiene la definizione del nome");
            return;
        }
        String nomePorta = pa.getNome();
        String idPortaApplicativa = "(" + sogg.getTipo() + "/" + sogg.getNome() + ") " + nomePorta;
        int numPD = 0;
        ArrayList<CallSite> paTrovate = new ArrayList<CallSite>();
        for (int j = 0; j < this.configurazione.sizeSoggettoList(); ++j) {
            Soggetto s = this.configurazione.getSoggetto(j);
            for (int k = 0; k < s.sizePortaApplicativaList(); ++k) {
                PortaApplicativa tmpPa = s.getPortaApplicativa(k);
                String tmpNomePorta = tmpPa.getNome();
                if (!nomePorta.equals(tmpNomePorta)) continue;
                ++numPD;
                paTrovate.add((CallSite)((Object)("(" + s.getTipo() + "/" + s.getNome() + ") " + tmpPa.getNome())));
            }
        }
        if (numPD > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa con nome " + nomePorta + ". Sono state identificate le seguenti porte applicative: " + String.valueOf(paTrovate));
        }
        boolean checkIDPA = true;
        if (pa.getSoggettoVirtuale() != null) {
            PortaApplicativaSoggettoVirtuale sv = pa.getSoggettoVirtuale();
            if (sv.getTipo() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui non e' stato definito il tipo");
                checkIDPA = false;
            } else if (!this.tipoSoggetti.contains(sv.getTipo())) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui e' stato definito un tipo non valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
            }
            if (sv.getNome() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui non e' stato definito il nome");
                checkIDPA = false;
            }
        }
        if (pa.getServizio() != null) {
            PortaApplicativaServizio serv = pa.getServizio();
            if (serv.getTipo() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio erogato per cui non e' stato definito il tipo");
                checkIDPA = false;
            } else if (!this.tipoServiziSoap.contains(serv.getTipo()) && !this.tipoServiziRest.contains(serv.getTipo())) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio erogato per cui e' stato definito un tipo non valido (Tipi utilizzabili: " + this.getTipoServizi() + ")");
            }
            if (serv.getNome() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio erogato per cui non e' stato definito il nome");
                checkIDPA = false;
            }
        } else {
            this.errori.add("La porta applicativa [" + idPortaApplicativa + "] non possiede la definizione del servizio erogato");
        }
        if (pa.getAzione() != null) {
            PortaApplicativaAzione pda = pa.getAzione();
            PortaApplicativaAzioneIdentificazione identificazione = pda.getIdentificazione();
            if (!(identificazione == null || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_STATIC) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_URL_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_CONTENT_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_HEADER_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_PROTOCOL_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_INPUT_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_SOAP_ACTION_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_WSDL_BASED) || identificazione.equals(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_DELEGATED_BY))) {
                this.errori.add("La modalita d'identificazione dell'azione della porta applicativa " + idPortaApplicativa + " deve assumere uno dei seguente valori: " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_STATIC) + ", " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_URL_BASED) + ", " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_CONTENT_BASED) + ", " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_HEADER_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_PROTOCOL_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_INPUT_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_SOAP_ACTION_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_WSDL_BASED) + " o " + String.valueOf(CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_DELEGATED_BY));
            }
            if (identificazione == null) {
                identificazione = CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_STATIC;
            }
            if (CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_STATIC.equals(identificazione)) {
                if (pda.getNome() == null) {
                    this.errori.add("L'azione della porta applicativa " + idPortaApplicativa + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
                    checkIDPA = false;
                }
            } else if (CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_URL_BASED.equals(identificazione) || CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_CONTENT_BASED.equals(identificazione) || CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_HEADER_BASED.equals(identificazione)) {
                if (pda.getPattern() == null) {
                    this.errori.add("L'azione della porta applicativa " + idPortaApplicativa + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
                    checkIDPA = false;
                }
            } else if (CostantiConfigurazione.PORTA_APPLICATIVA_AZIONE_DELEGATED_BY.equals(identificazione) && pda.getNomePortaDelegante() == null) {
                this.errori.add("L'azione della porta delegata " + idPortaApplicativa + " non contiene la definizione del nome della porta delegante, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
                checkIDPA = false;
            }
        }
        if (pa.sizeServizioApplicativoList() < 1) {
            this.errori.add("Alla porta applicativa [" + idPortaApplicativa + "] non sono stati associati servizi applicativi");
        } else {
            for (int i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
                PortaApplicativaServizioApplicativo paSa = pa.getServizioApplicativo(i);
                ServizioApplicativo sa = null;
                if (paSa.getNome() == null) {
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo per cui non e' stato definito il nome");
                    continue;
                }
                if (!this.existsServizioApplicativo(paSa.getNome(), sogg)) {
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un riferimento ad un servizio applicativo [" + paSa.getNome() + "] che non risulta registrato nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
                    continue;
                }
                sa = this.getServizioApplicativo(paSa.getNome(), sogg);
                if (sa.getInvocazioneServizio() == null) {
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo [" + sa.getNome() + "] per cui non e' stato definito l'elemento invocazione servizio");
                    continue;
                }
                boolean connettore = false;
                boolean get = false;
                if (sa.getInvocazioneServizio().getConnettore() != null && !CostantiConfigurazione.DISABILITATO.equals(sa.getInvocazioneServizio().getConnettore().getTipo())) {
                    connettore = true;
                }
                if (sa.getInvocazioneServizio().getGetMessage() != null && CostantiConfigurazione.ABILITATO.equals(sa.getInvocazioneServizio().getGetMessage())) {
                    get = true;
                }
                if (connettore || get) continue;
                this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo [" + sa.getNome() + "] per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
        }
        String autenticazione = CredenzialeTipo.SSL.toString();
        if (pa.getAutenticazione() != null) {
            autenticazione = pa.getAutenticazione();
            if (!this.tipoAutenticazionePortaApplicativa.contains(pa.getAutenticazione())) {
                this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associato un processo di autenticazione [" + pa.getAutenticazione() + "] non valido; tipi conosciuti: " + this.getTipoAutenticazionePortaApplicativa());
            }
        }
        String autorizzazione = "authenticated";
        if (pa.getAutorizzazione() != null) {
            autorizzazione = pa.getAutorizzazione();
            if (!this.tipoAutorizzazionePortaApplicativa.contains(pa.getAutorizzazione())) {
                this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associato un processo di autorizzazione [" + pa.getAutorizzazione() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazionePortaApplicativa());
            }
        }
        if (autorizzazione != null && "gw".equals(sogg.getTipo())) {
            if (autorizzazione.toLowerCase().contains("authenticated") && autorizzazione.toLowerCase().contains("roles") && !StatoFunzionalita.ABILITATO.equals(pa.getAutenticazioneOpzionale())) {
                this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione dei soggetti opzionali");
            }
            if (autorizzazione.toLowerCase().contains("internal") || "authenticated".equals(autorizzazione)) {
                if ("none".equals(autenticazione)) {
                    this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei soggetti, autenticazione non impostata nella porta applicativa");
                }
                if (StatoFunzionalita.ABILITATO.equals(pa.getAutenticazioneOpzionale()) && !autorizzazione.toLowerCase().contains("or")) {
                    this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei soggetti, autenticazione impostata come opzionale nella porta applicativa");
                }
            }
        }
        if (pa.getAutorizzazioneContenuto() != null && !this.tipoAutorizzazioneContenutoPortaApplicativa.contains(pa.getAutorizzazioneContenuto())) {
            this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associato un processo di autorizzazione contenuto [" + pa.getAutorizzazioneContenuto() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazioneContenutoPortaApplicativa());
        }
        for (int j = 0; j < pa.sizeProprietaList(); ++j) {
            Proprieta ssp = pa.getProprieta(j);
            this.validaProtocolProperty(ssp, "PortaApplicativa_" + idPortaApplicativa);
        }
        MessageSecurity messageSecurity = pa.getMessageSecurity();
        if (messageSecurity != null) {
            this.validaMessageSecurity(messageSecurity, "PortaApplicativa_" + idPortaApplicativa);
        }
        if ((mtom = pa.getMtomProcessor()) != null) {
            this.validaMTOM(mtom, "PortaApplicativa_" + idPortaApplicativa);
        }
        if ((vca = pa.getValidazioneContenutiApplicativi()) != null) {
            this.validazioneValidazioneContenutiApplicativi(vca, "PortaApplicativa_" + idPortaApplicativa);
        }
        String idRisorsa = "Porta applicativa " + idPortaApplicativa;
        this.validaCorrelazioneApplicativaRichiesta(idRisorsa, pa.getCorrelazioneApplicativa(), false);
        this.validaCorrelazioneApplicativaRisposta(idRisorsa, pa.getCorrelazioneApplicativaRisposta(), false);
        int numPA = 0;
        for (int j = 0; j < sogg.sizePortaApplicativaList(); ++j) {
            PortaApplicativa tmpPa = sogg.getPortaApplicativa(j);
            if (!pa.getNome().equals(tmpPa.getNome())) continue;
            ++numPA;
        }
        if (numPA > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " con nome " + pa.getNome());
        }
        if ((ricAsiSim = pa.getRicevutaAsincronaSimmetrica()) != null && !ricAsiSim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiSim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona simmetrica della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((ricAsiAsim = pa.getRicevutaAsincronaAsimmetrica()) != null && !ricAsiAsim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiAsim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona asimmetrica della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((integrazione = pa.getIntegrazione()) != null) {
            String[] tipiIntegrazione = integrazione.split(",");
            if (tipiIntegrazione == null || tipiIntegrazione.length <= 0) {
                this.errori.add("La porta applicativa " + idPortaApplicativa + " possiede un valore nel campo 'integrazione' non valido: " + integrazione);
            } else {
                for (int p = 0; p < tipiIntegrazione.length; ++p) {
                    String tipoI = tipiIntegrazione[p].trim();
                    if (this.tipoIntegrazionePA.contains(tipoI)) continue;
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " possiede un tipo di integrazione [" + tipoI + "] non valido: valori utilizzabili sono: " + this.getTipoIntegrazionePA());
                }
            }
        }
        if ((allegaBody = pa.getAllegaBody()) != null && !allegaBody.equals(CostantiConfigurazione.ABILITATO) && !allegaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di allega-boxy della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((scartaBody = pa.getScartaBody()) != null && !scartaBody.equals(CostantiConfigurazione.ABILITATO) && !scartaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di scarta-boxy della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((gestMan = pa.getGestioneManifest()) != null && !gestMan.equals(CostantiConfigurazione.ABILITATO) && !gestMan.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di gestioneManifest della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((stateless = pa.getStateless()) != null && !stateless.equals(CostantiConfigurazione.ABILITATO) && !stateless.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' 'stateless' della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if (pa.getRuoli() != null) {
            int i;
            for (i = 0; i < pa.getRuoli().sizeRuoloList(); ++i) {
                String nomeRuolo = pa.getRuoli().getRuolo(i).getNome();
                try {
                    if (RegularExpressionEngine.isMatch((String)nomeRuolo, (String)"^[0-9A-Za-z_]+$")) continue;
                    this.errori.add("Il ruolo [" + nomeRuolo + "] della porta applicativa " + idPortaApplicativa + " dev'essere formato solo da caratteri, cifre e '_'");
                    continue;
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " della porta applicativa " + idPortaApplicativa + " :" + e.getMessage(), e);
                }
            }
            for (i = 0; i < pa.getRuoli().sizeRuoloList(); ++i) {
                int numRuolo = 0;
                String tmpRuolo = pa.getRuoli().getRuolo(i).getNome();
                for (int j = 0; j < pa.getRuoli().sizeRuoloList(); ++j) {
                    String checkRuolo = pa.getRuoli().getRuolo(j).getNome();
                    if (!checkRuolo.equals(tmpRuolo)) continue;
                    ++numRuolo;
                }
                if (numRuolo <= true) continue;
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nella porta applicativa " + idPortaApplicativa);
            }
        }
    }

    private void validaServizioApplicativo(ServizioApplicativo sa, Soggetto sogg) throws DriverConfigurazioneException {
        StatoFunzionalita sbustamentoInfoProtocollo;
        StatoFunzionalita sbustamentoSOAP;
        StatoFunzionalita rispRif;
        StatoFunzionalita invRif;
        StatoFunzionalita getMsg;
        boolean get;
        GestioneErrore ge;
        Connettore conn;
        InvocazioneServizioTipoAutenticazione auth;
        BaseBeanWithId c;
        if (sa.getNome() == null) {
            this.errori.add("Esiste un ServizioApplicativo del soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] per cui non e' stato definito il nome");
            return;
        }
        String idServizioApplicativo = sogg.getTipo() + "/" + sogg.getNome() + "_" + sa.getNome();
        if (sa.getInvocazionePorta() == null && sa.getRispostaAsincrona() == null && sa.getInvocazioneServizio() == null) {
            this.errori.add("Il ServizioApplicativo [" + idServizioApplicativo + "] non contiene ne la definizione dell'elemento invocazione porta, ne la definizione della risposta asincrona, ne la definizione dell'elemento invocazione servizio");
            return;
        }
        InvocazionePorta ip = sa.getInvocazionePorta();
        if (ip != null) {
            InvocazionePortaGestioneErrore ipge;
            StatoFunzionalita sbustamentoInfoProtocollo2;
            if (ip.sizeCredenzialiList() < 1) {
                this.errori.add("Il ServizioApplicativo [" + idServizioApplicativo + "] non contiene credenziali di accesso, nonostante abbia definito l'elemento invocazione porta");
            }
            for (int j = 0; j < ip.sizeCredenzialiList(); ++j) {
                c = ip.getCredenziali(j);
                this.validaCredenziale((Credenziali)c, "servizio applicativo [" + idServizioApplicativo + "] (invocazione porta)");
            }
            StatoFunzionalita invRif2 = ip.getInvioPerRiferimento();
            if (invRif2 != null && !invRif2.equals(CostantiConfigurazione.ABILITATO) && !invRif2.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'invio per riferimento dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((sbustamentoInfoProtocollo2 = ip.getSbustamentoInformazioniProtocollo()) != null && !sbustamentoInfoProtocollo2.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoInfoProtocollo2.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento informazioni di protcollo dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((ipge = ip.getGestioneErrore()) != null) {
                StatoFunzionalita genFault;
                FaultIntegrazioneTipo fault = ipge.getFault();
                if (fault != null && !fault.equals(FaultIntegrazioneTipo.SOAP) && !fault.equals(FaultIntegrazioneTipo.XML)) {
                    this.errori.add("Il fault della gestione errore dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP) + " o " + String.valueOf(CostantiConfigurazione.ERRORE_APPLICATIVO_XML));
                }
                if ((genFault = ipge.getGenericFaultCode()) != null && !genFault.equals(CostantiConfigurazione.ABILITATO) && !genFault.equals(CostantiConfigurazione.DISABILITATO)) {
                    this.errori.add("Il generic-fault-code della gestione errore dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
                }
            }
            if (ip.getRuoli() != null) {
                int i;
                for (i = 0; i < ip.getRuoli().sizeRuoloList(); ++i) {
                    String nomeRuolo = ip.getRuoli().getRuolo(i).getNome();
                    try {
                        if (RegularExpressionEngine.isMatch((String)nomeRuolo, (String)"^[0-9A-Za-z_]+$")) continue;
                        this.errori.add("Il ruolo [" + nomeRuolo + "] dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] dev'essere formato solo da caratteri, cifre e '_'");
                        continue;
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] :" + e.getMessage(), e);
                    }
                }
                for (i = 0; i < ip.getRuoli().sizeRuoloList(); ++i) {
                    int numRuolo = 0;
                    String tmpRuolo = ip.getRuoli().getRuolo(i).getNome();
                    for (int j = 0; j < ip.getRuoli().sizeRuoloList(); ++j) {
                        String checkRuolo = ip.getRuoli().getRuolo(j).getNome();
                        if (!checkRuolo.equals(tmpRuolo)) continue;
                        ++numRuolo;
                    }
                    if (numRuolo <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "]");
                }
            }
        }
        if (sa.getInvocazioneServizio() != null) {
            InvocazioneServizio is = sa.getInvocazioneServizio();
            c = is.getCredenziali();
            if (c != null) {
                this.validaCredenziale((InvocazioneCredenziali)c, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)");
            }
            if ((auth = is.getAutenticazione()) != null && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC) && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE)) {
                this.errori.add("L'autenticazione dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere uno dei seguenti valori: " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString() + " o " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString());
            }
            if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.equals(auth) && c == null) {
                this.errori.add("L'autenticazione " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString() + " dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali");
            }
            if ((conn = is.getConnettore()) != null) {
                this.validaConnettore(conn, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)", sogg);
            }
            if ((ge = is.getGestioneErrore()) != null) {
                this.validaGestioneErrore(ge, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)");
            }
            boolean connettore = false;
            get = false;
            if (is.getConnettore() != null && !CostantiConfigurazione.DISABILITATO.equals(is.getConnettore().getTipo())) {
                connettore = true;
            }
            if (is.getGetMessage() != null && CostantiConfigurazione.ABILITATO.equals(is.getGetMessage())) {
                get = true;
            }
            if (!connettore && !get) {
                this.errori.add("Il servizio Applicativo " + idServizioApplicativo + " possiede un elemento invocazione servizio per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
            if ((getMsg = is.getGetMessage()) != null && !getMsg.equals(CostantiConfigurazione.ABILITATO) && !getMsg.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il get-message dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((invRif = is.getInvioPerRiferimento()) != null && !invRif.equals(CostantiConfigurazione.ABILITATO) && !invRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di invio per riferimento dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((rispRif = is.getRispostaPerRiferimento()) != null && !rispRif.equals(CostantiConfigurazione.ABILITATO) && !rispRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di risposta per riferimento dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((sbustamentoSOAP = is.getSbustamentoSoap()) != null && !sbustamentoSOAP.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoSOAP.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento SOAP dell'invocazione servizio del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((sbustamentoInfoProtocollo = is.getSbustamentoInformazioniProtocollo()) != null && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento informazioni di protcollo dell'invocazione servizio del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
        }
        if (sa.getRispostaAsincrona() != null) {
            RispostaAsincrona ra = sa.getRispostaAsincrona();
            c = ra.getCredenziali();
            if (c != null) {
                this.validaCredenziale((InvocazioneCredenziali)c, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)");
            }
            if ((auth = ra.getAutenticazione()) != null && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC) && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE)) {
                this.errori.add("L'autenticazione della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere uno dei seguenti valori: " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString() + " o " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString());
            }
            if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.equals(auth) && c == null) {
                this.errori.add("L'autenticazione " + String.valueOf(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC) + " della risposta asincrona del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali");
            }
            if ((conn = ra.getConnettore()) != null) {
                this.validaConnettore(conn, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)", sogg);
            }
            if ((ge = ra.getGestioneErrore()) != null) {
                this.validaGestioneErrore(ge, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)");
            }
            boolean connettore = false;
            get = false;
            if (ra.getConnettore() != null && !CostantiConfigurazione.DISABILITATO.equals(ra.getConnettore().getTipo())) {
                connettore = true;
            }
            if (ra.getGetMessage() != null && CostantiConfigurazione.ABILITATO.equals(ra.getGetMessage())) {
                get = true;
            }
            if (!connettore && !get) {
                this.errori.add("Il servizio Applicativo " + idServizioApplicativo + " possiede un elemento risposta asincrona per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
            if ((getMsg = ra.getGetMessage()) != null && !getMsg.equals(CostantiConfigurazione.ABILITATO) && !getMsg.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il get-message della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((invRif = ra.getInvioPerRiferimento()) != null && !invRif.equals(CostantiConfigurazione.ABILITATO) && !invRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di invio per riferimento della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((rispRif = ra.getRispostaPerRiferimento()) != null && !rispRif.equals(CostantiConfigurazione.ABILITATO) && !rispRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di risposta per riferimento della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((sbustamentoSOAP = ra.getSbustamentoSoap()) != null && !sbustamentoSOAP.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoSOAP.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento SOAP della risposta asincrona del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((sbustamentoInfoProtocollo = ra.getSbustamentoInformazioniProtocollo()) != null && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento informazioni di protcollo della risposta asincrona del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
        }
        int numSA = 0;
        for (int j = 0; j < sogg.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo tmpSA = sogg.getServizioApplicativo(j);
            if (!sa.getNome().equals(tmpSA.getNome())) continue;
            ++numSA;
        }
        if (numSA > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un servizio applicativo con nome " + sa.getNome() + " associato al soggetto " + sogg.getTipo() + "/" + sogg.getNome());
        }
    }

    private void validaConnettore(Connettore conn, String identificativoElementoInternoSoggetto, Soggetto soggetto) throws DriverConfigurazioneException {
        block118: {
            String nomeConn = conn.getNome();
            String tipoConn = conn.getTipo();
            String idSoggetto = soggetto.getTipo() + "/" + soggetto.getNome();
            if (nomeConn == null) {
                if (identificativoElementoInternoSoggetto == null) {
                    this.errori.add("Esiste un connettore nella radice del soggetto[" + idSoggetto + "] per cui non \u00e8 definito il nome");
                } else {
                    this.errori.add("Esiste un connettore del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") per cui non \u00e8 definito il nome");
                }
                return;
            }
            if (identificativoElementoInternoSoggetto == null) {
                int numC = 0;
                for (int j = 0; j < soggetto.sizeConnettoreList(); ++j) {
                    Connettore tmpC = soggetto.getConnettore(j);
                    if (!nomeConn.equals(tmpC.getNome())) continue;
                    ++numC;
                }
                if (numC > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un connettore con nome " + nomeConn + " definito come elemento radice del soggetto[" + idSoggetto + "]");
                }
            } else {
                if (tipoConn == null) {
                    conn = null;
                    for (int j = 0; j < soggetto.sizeConnettoreList(); ++j) {
                        Connettore connettore = soggetto.getConnettore(j);
                        if (!nomeConn.equals(connettore.getNome())) continue;
                        conn = connettore;
                        break;
                    }
                }
                if (conn == null) {
                    this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") non corrisponde a nessuno dei connettori registrati");
                } else {
                    tipoConn = conn.getTipo();
                }
            }
            if (!this.tipoConnettori.contains(tipoConn)) {
                if (identificativoElementoInternoSoggetto == null) {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                } else {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                }
            } else {
                List<Property> cps = conn.getPropertyList();
                Property[] cpArray = null;
                if (cps.size() > 0) {
                    cpArray = cps.toArray(new Property[cps.size()]);
                }
                if (cpArray != null) {
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (cp.getNome() == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            }
                            return;
                        }
                        if (cp.getValore() != null) continue;
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        }
                        return;
                    }
                }
                if (tipoConn.equals(TipiConnettore.HTTP.getNome())) {
                    String urlConn = null;
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (!cp.getNome().equals("location")) continue;
                        urlConn = cp.getValore();
                        break;
                    }
                    if (urlConn == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            RegExpUtilities.validateUrl(urlConn, (boolean)true);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                                break block118;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.JMS.getNome())) {
                    String jmsNome = null;
                    String jmsTipo = null;
                    String jmsConnFact = null;
                    String jmsSendAs = null;
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (cp.getNome().equals("location")) {
                            jmsNome = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("tipo")) {
                            jmsTipo = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("connection-factory")) {
                            jmsConnFact = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("send-as")) continue;
                        jmsSendAs = cp.getValore();
                    }
                    if (jmsNome == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        }
                    }
                    if (jmsTipo == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        }
                    } else if (!jmsTipo.equals("queue") && !jmsTipo.equals("topic")) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        }
                    }
                    if (jmsConnFact == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha una connection factory definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha una connection factory definita");
                        }
                    }
                    if (jmsSendAs == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        }
                    } else if (!jmsSendAs.equals("TextMessage") && !jmsSendAs.equals("BytesMessage")) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.HTTPS.getNome())) {
                    String urlConn = null;
                    String trustStoreLocation = null;
                    String trustStorePassword = null;
                    String keyStoreLocation = null;
                    String keyStorePassword = null;
                    String keyPassword = null;
                    String hostNameVerifier = null;
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (cp.getNome().equals("location")) {
                            urlConn = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStoreLocation")) {
                            trustStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStorePassword")) {
                            trustStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStoreLocation")) {
                            keyStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStorePassword")) {
                            keyStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyPassword")) {
                            keyPassword = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("hostnameVerifier")) continue;
                        hostNameVerifier = cp.getValore();
                    }
                    if (urlConn == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            RegExpUtilities.validateUrl(urlConn, (boolean)true);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                    if (trustStoreLocation != null) {
                        File f = new File(trustStoreLocation);
                        if (!f.exists()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (trustStorePassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            }
                        }
                    }
                    if (keyStoreLocation != null) {
                        File f = new File(keyStoreLocation);
                        if (!f.exists()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (keyStorePassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            }
                        } else if (keyPassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            }
                        }
                    }
                    if (hostNameVerifier != null) {
                        try {
                            Boolean.parseBoolean(hostNameVerifier);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                                break block118;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.DISABILITATO.getNome()) && cpArray != null) {
                    if (identificativoElementoInternoSoggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    }
                }
            }
        }
    }

    private void validaCorrelazioneApplicativaRichiesta(String identificativoRisorsa, CorrelazioneApplicativa ca, boolean portaDelegata) throws DriverConfigurazioneException {
        if (ca != null) {
            CorrelazioneApplicativaElemento cae;
            int j;
            if (ca.getScadenza() != null) {
                try {
                    Long.parseLong(ca.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza della correlazione applicativa inserita nella " + identificativoRisorsa + " dev'essere un numero intero");
                }
            }
            if (ca.sizeElementoList() < 1) {
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa senza elementi?");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                cae = ca.getElemento(j);
                if (cae.getNome() != null || j == ca.sizeElementoList() - 1) continue;
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa (" + (j + 1) + ") con un elemento '*' (match qualsiasi contenuto) definito non come ultima regola di correlazione");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                StatoFunzionalita riusoIdentificatore;
                CorrelazioneApplicativaGestioneIdentificazioneFallita identificazioneFallita;
                CorrelazioneApplicativaRichiestaIdentificazione identificazione;
                cae = ca.getElemento(j);
                int numE = 0;
                for (int k = 0; k < ca.sizeElementoList(); ++k) {
                    CorrelazioneApplicativaElemento tmpCae = ca.getElemento(k);
                    if (cae.getNome() == null) {
                        if (tmpCae.getNome() != null) continue;
                        ++numE;
                        continue;
                    }
                    if (!cae.getNome().equals(tmpCae.getNome())) continue;
                    ++numE;
                }
                if (numE > 1) {
                    String nome = "*";
                    if (cae.getNome() != null) {
                        nome = cae.getNome();
                    }
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento di correlazione applicativa con nome " + nome + " (" + identificativoRisorsa + ")");
                }
                if (!((identificazione = cae.getIdentificazione()) == null || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_DISABILITATO) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_INPUT_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_HEADER_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_TEMPLATE) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_FREEMARKER_TEMPLATE) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_VELOCITY_TEMPLATE))) {
                    this.errori.add("La modalita d'identificazione della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_DISABILITATO) + "," + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED) + "," + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_INPUT_BASED) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_HEADER_BASED) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_TEMPLATE) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_FREEMARKER_TEMPLATE) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_VELOCITY_TEMPLATE));
                }
                if (identificazione == null) {
                    identificazione = CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED;
                }
                if ((CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED.equals(identificazione) || CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED.equals(identificazione)) && cae.getPattern() == null) {
                    this.errori.add("La correlazione applicativa (" + (j + 1) + ") della " + identificativoRisorsa + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
                }
                if ((identificazioneFallita = cae.getIdentificazioneFallita()) != null && !identificazioneFallita.equals(CostantiConfigurazione.BLOCCA) && !identificazioneFallita.equals(CostantiConfigurazione.ACCETTA)) {
                    this.errori.add("Il comportamento in caso di identificazione fallita della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + String.valueOf(CostantiConfigurazione.BLOCCA) + " o " + String.valueOf(CostantiConfigurazione.ACCETTA));
                }
                if ((riusoIdentificatore = cae.getRiusoIdentificativo()) == null || riusoIdentificatore.equals(CostantiConfigurazione.ABILITATO) || riusoIdentificatore.equals(CostantiConfigurazione.DISABILITATO)) continue;
                this.errori.add("Il comportamento per il riuso dell'id della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
        }
    }

    private void validaCorrelazioneApplicativaRisposta(String identificativoRisorsa, CorrelazioneApplicativaRisposta ca, boolean portaDelegata) throws DriverConfigurazioneException {
        if (ca != null) {
            CorrelazioneApplicativaRispostaElemento cae;
            int j;
            if (ca.sizeElementoList() < 1) {
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa senza elementi?");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                cae = ca.getElemento(j);
                if (cae.getNome() != null || j == ca.sizeElementoList() - 1) continue;
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa (" + (j + 1) + ") con un elemento '*' (match qualsiasi contenuto) definito non come ultima regola di correlazione");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                CorrelazioneApplicativaGestioneIdentificazioneFallita identificazioneFallita;
                CorrelazioneApplicativaRispostaIdentificazione identificazione;
                cae = ca.getElemento(j);
                int numE = 0;
                for (int k = 0; k < ca.sizeElementoList(); ++k) {
                    CorrelazioneApplicativaRispostaElemento tmpCae = ca.getElemento(k);
                    if (cae.getNome() == null) {
                        if (tmpCae.getNome() != null) continue;
                        ++numE;
                        continue;
                    }
                    if (!cae.getNome().equals(tmpCae.getNome())) continue;
                    ++numE;
                }
                if (numE > 1) {
                    String nome = "*";
                    if (cae.getNome() != null) {
                        nome = cae.getNome();
                    }
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento di correlazione applicativa con nome " + nome + " (" + identificativoRisorsa + ")");
                }
                if (!((identificazione = cae.getIdentificazione()) == null || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_DISABILITATO) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_INPUT_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_HEADER_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_TEMPLATE) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_FREEMARKER_TEMPLATE) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_VELOCITY_TEMPLATE))) {
                    this.errori.add("La modalita d'identificazione della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_DISABILITATO) + "," + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_INPUT_BASED) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_HEADER_BASED) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_TEMPLATE) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_FREEMARKER_TEMPLATE) + " o " + String.valueOf(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_VELOCITY_TEMPLATE));
                }
                if (identificazione == null) {
                    identificazione = CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED;
                }
                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED.equals(identificazione) && cae.getPattern() == null) {
                    this.errori.add("La correlazione applicativa (" + (j + 1) + ") della " + identificativoRisorsa + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + String.valueOf(identificazione));
                }
                if ((identificazioneFallita = cae.getIdentificazioneFallita()) == null || identificazioneFallita.equals(CostantiConfigurazione.BLOCCA) || identificazioneFallita.equals(CostantiConfigurazione.ACCETTA)) continue;
                this.errori.add("Il comportamento in caso di identificazione fallita della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + String.valueOf(CostantiConfigurazione.BLOCCA) + " o " + String.valueOf(CostantiConfigurazione.ACCETTA));
            }
        }
    }

    private void validaConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        StatoServiziPdd s;
        String[] v;
        IntegrationManager im;
        Dump d;
        TipoConnessioneRisposte connessione;
        Risposte rs;
        StatoFunzionalita gestione;
        Attachments attachments;
        StatoFunzionalita utilizzo;
        IndirizzoRisposta it;
        ValidazioneBuste vbe;
        AccessoRegistro ar = null;
        if (configurazione.getAccessoRegistro() == null) {
            this.errori.add("Non \u00e8 stato configurato un accesso ad un registro dei servizi");
        } else {
            ar = configurazione.getAccessoRegistro();
            if (ar.sizeRegistroList() <= 0) {
                this.errori.add("Non \u00e8 stato configurato un accesso ad un registro dei servizi");
                ar = null;
            } else {
                for (int j = 0; j < ar.sizeRegistroList(); ++j) {
                    AccessoRegistroRegistro arr = ar.getRegistro(j);
                    String nomeArr = arr.getNome();
                    if (nomeArr == null) {
                        this.errori.add("E' presente la configurazione di accesso ad un registro dei servizi anonimo; deve obbligatoriamente essere associato un nome ad un registro dei servizi");
                    } else {
                        int numAR = 0;
                        for (int k = 0; k < ar.sizeRegistroList(); ++k) {
                            AccessoRegistroRegistro tmpArr = ar.getRegistro(k);
                            if (!nomeArr.equals(tmpArr.getNome())) continue;
                            ++numAR;
                        }
                        if (numAR > 1) {
                            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un registro dei servizi con nome " + nomeArr);
                        }
                    }
                    RegistroTipo tipo = arr.getTipo();
                    if (tipo != null && !tipo.equals(CostantiConfigurazione.REGISTRO_XML) && !tipo.equals(CostantiConfigurazione.REGISTRO_DB)) {
                        this.errori.add("Il tipo del registro " + nomeArr + " non \u00e8 valido; deve assumere uno dei seguenti tipi: " + CostantiConfigurazione.REGISTRO_XML.toString() + "," + CostantiConfigurazione.REGISTRO_DB.toString());
                    }
                    if (arr.getLocation() == null) {
                        this.errori.add("Per la configurazione di accesso al registro dei servizi [" + nomeArr + "] non \u00e8 stata fornita la location");
                    }
                    if (arr.getPassword() == null || arr.getUser() != null) continue;
                    this.errori.add("Per la configurazione di accesso al registro dei servizi [" + nomeArr + "] non \u00e8 stata fornito un username, ma \u00e8 stato specificata una password?");
                }
                Cache arc = ar.getCache();
                if (arc != null) {
                    this.validaCache(arc, "Registro dei Servizi");
                }
            }
        }
        RoutingTable rt = configurazione.getRoutingTable();
        if (rt != null) {
            if (rt.getDefault() == null) {
                this.errori.add("(RoutingTable abilitata) Non \u00e8 stata definita una rotta di default");
            } else if (rt.getDefault().sizeRouteList() == 0) {
                this.errori.add("(RoutingTable abilitata) Non \u00e8 stata definita una rotta tra quelle di default");
            } else {
                RoutingTableDefault rtDefault = rt.getDefault();
                for (int i = 0; i < rtDefault.sizeRouteList(); ++i) {
                    Route r = rtDefault.getRoute(i);
                    this.validaRotta(r, "[RottaDefault]", ar);
                    if (r.getRegistro() != null) {
                        int numRR = 0;
                        for (int h = 0; h < rtDefault.sizeRouteList(); ++h) {
                            Route tmpR = rtDefault.getRoute(h);
                            if (tmpR.getRegistro() == null) continue;
                            RouteRegistro tmpRR = tmpR.getRegistro();
                            if (r.getRegistro().getNome() == null) {
                                if (tmpRR.getNome() != null) continue;
                                ++numRR;
                                continue;
                            }
                            if (!r.getRegistro().getNome().equals(tmpRR.getNome())) continue;
                            ++numRR;
                        }
                        if (numRR > 1) {
                            String nome = "TuttiRegistri";
                            if (r.getRegistro().getNome() != null) {
                                nome = r.getRegistro().getNome();
                            }
                            this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta di default, che utilizzi il registro " + nome);
                        }
                    }
                    if (r.getGateway() == null || r.getGateway().getTipo() == null || r.getGateway().getNome() == null) continue;
                    RouteGateway rg = r.getGateway();
                    String idRG = rg.getTipo() + "/" + rg.getNome();
                    int numRG = 0;
                    for (int h = 0; h < rtDefault.sizeRouteList(); ++h) {
                        RouteGateway tmpRG;
                        String tmpIdRG;
                        Route tmpR = rtDefault.getRoute(h);
                        if (tmpR.getGateway() == null || tmpR.getGateway().getTipo() == null || tmpR.getGateway().getNome() == null || !idRG.equals(tmpIdRG = (tmpRG = tmpR.getGateway()).getTipo() + "/" + tmpRG.getNome())) continue;
                        ++numRG;
                    }
                    if (numRG <= true) continue;
                    this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta di default di tipo gateway con identificativo soggetto " + idRG);
                }
            }
            for (int j = 0; j < rt.sizeDestinazioneList(); ++j) {
                int k;
                RoutingTableDestinazione rtd = rt.getDestinazione(j);
                if (rtd.getTipo() == null) {
                    this.errori.add("(RoutingTable abilitata) E' stata definita una rotta di destinazone statica, senza aver specificato il tipo");
                    continue;
                }
                if (rtd.getNome() == null) {
                    this.errori.add("(RoutingTable abilitata) E' stata definita una rotta di destinazone statica, senza aver specificato il nome");
                    continue;
                }
                String idDest = rtd.getTipo() + "/" + rtd.getNome();
                int numD = 0;
                for (k = 0; k < rt.sizeDestinazioneList(); ++k) {
                    RoutingTableDestinazione tmpRtd = rt.getDestinazione(k);
                    String tmpIdDest = tmpRtd.getTipo() + "/" + tmpRtd.getNome();
                    if (!idDest.equals(tmpIdDest)) continue;
                    ++numD;
                }
                if (numD > 1) {
                    this.errori.add("(RoutingTable abilitata)  Non pu\u00f2 esistere pi\u00f9 di una rotta di destinazione statico con identificativo soggetto" + idDest);
                }
                for (k = 0; k < rtd.sizeRouteList(); ++k) {
                    Route r = rtd.getRoute(k);
                    this.validaRotta(r, "[RottaDestinazioneStatica(" + idDest + ")]", ar);
                    if (r.getRegistro() != null) {
                        int numRR = 0;
                        for (int h = 0; h < rtd.sizeRouteList(); ++h) {
                            Route tmpR = rtd.getRoute(h);
                            if (tmpR.getRegistro() == null) continue;
                            RouteRegistro tmpRR = tmpR.getRegistro();
                            if (r.getRegistro().getNome() == null) {
                                if (tmpRR.getNome() != null) continue;
                                ++numRR;
                                continue;
                            }
                            if (!r.getRegistro().getNome().equals(tmpRR.getNome())) continue;
                            ++numRR;
                        }
                        if (numRR > 1) {
                            String nome = "TuttiRegistri";
                            if (r.getRegistro().getNome() != null) {
                                nome = r.getRegistro().getNome();
                            }
                            this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta per la destinazione statica [" + idDest + "], che utilizzi il registro " + nome);
                        }
                    }
                    if (r.getGateway() == null || r.getGateway().getTipo() == null || r.getGateway().getNome() == null) continue;
                    RouteGateway rg = r.getGateway();
                    String idRG = rg.getTipo() + "/" + rg.getNome();
                    int numRG = 0;
                    for (int h = 0; h < rtd.sizeRouteList(); ++h) {
                        RouteGateway tmpRG;
                        String tmpIdRG;
                        Route tmpR = rtd.getRoute(h);
                        if (tmpR.getGateway() == null || tmpR.getGateway().getTipo() == null || tmpR.getGateway().getNome() == null || !idRG.equals(tmpIdRG = (tmpRG = tmpR.getGateway()).getTipo() + "/" + tmpRG.getNome())) continue;
                        ++numRG;
                    }
                    if (numRG <= true) continue;
                    this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta per la destinazione statica [" + idDest + "] di tipo gateway con identificativo soggetto " + idRG);
                }
            }
        }
        if (configurazione.getAccessoConfigurazione() != null && configurazione.getAccessoConfigurazione().getCache() != null) {
            this.validaCache(configurazione.getAccessoConfigurazione().getCache(), "ConfigurazionePdD");
        }
        if (configurazione.getAccessoDatiAutorizzazione() != null && configurazione.getAccessoDatiAutorizzazione().getCache() != null) {
            this.validaCache(configurazione.getAccessoDatiAutorizzazione().getCache(), "DatiAutorizzazione");
        }
        if ((vbe = configurazione.getValidazioneBuste()) != null) {
            StatoFunzionalita manifest;
            StatoFunzionalita profColl;
            ValidazioneBusteTipoControllo controllo;
            StatoFunzionalitaConWarning statoBuste = vbe.getStato();
            if (!(statoBuste == null || statoBuste.equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO) || statoBuste.equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) || statoBuste.equals(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY))) {
                this.errori.add("Lo stato della validazione buste deve possedere uno dei seguenti valori: " + String.valueOf(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO) + ", " + String.valueOf(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) + " o " + String.valueOf(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY));
            }
            if ((controllo = vbe.getControllo()) != null && !controllo.equals(CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE) && !controllo.equals(CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO)) {
                this.errori.add("Il controllo della validazione buste deve possedere uno dei seguenti valori: " + String.valueOf(CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE) + " o " + String.valueOf(CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO));
            }
            if ((profColl = vbe.getProfiloCollaborazione()) != null && !profColl.equals(CostantiConfigurazione.ABILITATO) && !profColl.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il profilo di collaborazione della validazione buste deve possedere i valori " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
            if ((manifest = vbe.getManifestAttachments()) != null && !manifest.equals("abilitato") && !manifest.equals("disabilitato")) {
                this.errori.add("Il manifest-attachments della validazione buste deve possedere i valori " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
        }
        if (configurazione.getValidazioneContenutiApplicativi() != null) {
            this.validazioneValidazioneContenutiApplicativi(configurazione.getValidazioneContenutiApplicativi(), "ConfigurazioneGeneralePdD");
        }
        if ((it = configurazione.getIndirizzoRisposta()) != null && (utilizzo = it.getUtilizzo()) != null && !utilizzo.equals(CostantiConfigurazione.ABILITATO) && !utilizzo.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("L'utilizzo dell'indirizzo per la risposta nella configurazione generale della PdD deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((attachments = configurazione.getAttachments()) != null && (gestione = attachments.getGestioneManifest()) != null && !gestione.equals(CostantiConfigurazione.ABILITATO) && !gestione.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La gestione dei manifest degli attachments nella configurazione generale della PdD deve assumere i valori: " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
        }
        if ((rs = configurazione.getRisposte()) != null && (connessione = rs.getConnessione()) != null && !connessione.equals(CostantiConfigurazione.NEW_CONNECTION) && !connessione.equals(CostantiConfigurazione.CONNECTION_REPLY)) {
            this.errori.add("La connessione delle risposte nella configurazione generale della PdD deve assumere i valori:" + String.valueOf(CostantiConfigurazione.CONNECTION_REPLY) + " o " + String.valueOf(CostantiConfigurazione.NEW_CONNECTION));
        }
        if (configurazione.getInoltroBusteNonRiscontrate() == null) {
            this.errori.add("Definizione della cadenza delle buste non riscontrate non presente nella configurazione generale della PdD");
        } else {
            InoltroBusteNonRiscontrate inoltro = configurazione.getInoltroBusteNonRiscontrate();
            if (inoltro.getCadenza() == null) {
                this.errori.add("Definizione della cadenza delle buste non riscontrate non presente nella configurazione generale della PdD");
            } else {
                try {
                    Long.parseLong(inoltro.getCadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla cadenza delle buste non riscontrate, presente nella configurazione generale della PdD, dev'essere un numero intero");
                }
            }
        }
        MessaggiDiagnostici md = configurazione.getMessaggiDiagnostici();
        if (md != null) {
            Severita severitaLog4j;
            for (int j = 0; j < md.sizeOpenspcoopAppenderList(); ++j) {
                OpenspcoopAppender oa = md.getOpenspcoopAppender(j);
                if (oa.getTipo() == null) {
                    this.errori.add("E' stato definito un appender dei msg diagnostici per cui non e' stato definito il tipo");
                    continue;
                }
                if (!this.tipoMsgDiagnosticiAppender.contains(oa.getTipo())) {
                    this.errori.add("E' stato definito un appender dei msg diagnostici per cui e' stato definito un tipo[" + oa.getTipo() + "] non valido, valori ammessi sono: " + this.getTipoMsgDiagnosticiAppender());
                }
                for (int k = 0; k < oa.sizePropertyList(); ++k) {
                    Property oap = oa.getProperty(k);
                    if (oap.getNome() == null) continue;
                    if (oap.getValore() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] dei msg diagnostici per cui esiste una proprieta' senza un valore?");
                        continue;
                    }
                    String nomeOap = oap.getNome();
                    int numOap = 0;
                    for (int h = 0; h < oa.sizePropertyList(); ++h) {
                        Property tmpOap = oa.getProperty(h);
                        if (!nomeOap.equals(tmpOap.getNome())) continue;
                        ++numOap;
                    }
                    if (numOap <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una propriet\u00e0 con nome " + nomeOap + " per lo stesso appender[" + oa.getTipo() + "] dei msg diagnostici");
                }
            }
            Severita severita = md.getSeverita();
            if (!(severita == null || severita.equals(Severita.OFF) || severita.equals(Severita.FATAL) || severita.equals(Severita.ERROR_PROTOCOL) || severita.equals(Severita.ERROR_INTEGRATION) || severita.equals(Severita.INFO_PROTOCOL) || severita.equals(Severita.INFO_INTEGRATION) || severita.equals(Severita.DEBUG_LOW) || severita.equals(Severita.DEBUG_MEDIUM) || severita.equals(Severita.DEBUG_HIGH) || severita.equals(Severita.ALL))) {
                this.errori.add("L'opzione 'severita' della configurazione dei messaggi diagnostici nella configurazione generale della PdD deve assumere uno dei seguenti valori: off, fatal, errorProtocol, errorIntegration, infoProtocol, infoIntegration, debugLow, debugMedium, debugHigh, all");
            }
            if (!((severitaLog4j = md.getSeveritaLog4j()) == null || severitaLog4j.equals(Severita.OFF) || severitaLog4j.equals(Severita.FATAL) || severitaLog4j.equals(Severita.ERROR_PROTOCOL) || severitaLog4j.equals(Severita.ERROR_INTEGRATION) || severitaLog4j.equals(Severita.INFO_PROTOCOL) || severitaLog4j.equals(Severita.INFO_INTEGRATION) || severitaLog4j.equals(Severita.DEBUG_LOW) || severitaLog4j.equals(Severita.DEBUG_MEDIUM) || severitaLog4j.equals(Severita.DEBUG_HIGH) || severitaLog4j.equals(Severita.ALL))) {
                this.errori.add("L'opzione 'severita-log4j' della configurazione dei messaggi diagnostici nella configurazione generale della PdD deve assumere uno dei seguenti valori: off, fatal, errorProtocol, errorIntegration, infoProtocol, infoIntegration, debugLow, debugMedium, debugHigh, all");
            }
        } else {
            this.errori.add("Non e' stata definita la configurazione dei messaggi diagnostici nella configurazione generale della PdD");
        }
        Tracciamento t = configurazione.getTracciamento();
        if (t != null) {
            for (int j = 0; j < t.sizeOpenspcoopAppenderList(); ++j) {
                OpenspcoopAppender oa = t.getOpenspcoopAppender(j);
                if (oa.getTipo() == null) {
                    this.errori.add("E' stato definito un appender delle tracce per cui non e' stato definito il tipo");
                    continue;
                }
                if (!this.tipoTracciamentoAppender.contains(oa.getTipo())) {
                    this.errori.add("E' stato definito un appender delle tracce per cui e' stato definito un tipo[" + oa.getTipo() + "] non valido, valori ammessi sono: " + this.getTipoTracciamentoAppender());
                }
                for (int k = 0; k < oa.sizePropertyList(); ++k) {
                    Property oap = oa.getProperty(k);
                    if (oap.getNome() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] delle tracce per cui esiste una proprieta' senza un nome?");
                        continue;
                    }
                    if (oap.getValore() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] delle tracce per cui esiste una proprieta' senza un valore?");
                        continue;
                    }
                    String nomeOap = oap.getNome();
                    int numOap = 0;
                    for (int h = 0; h < oa.sizePropertyList(); ++h) {
                        Property tmpOap = oa.getProperty(h);
                        if (!nomeOap.equals(tmpOap.getNome())) continue;
                        ++numOap;
                    }
                    if (numOap <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una propriet\u00e0 con nome " + nomeOap + " per lo stesso appender[" + oa.getTipo() + "] delle tracce");
                }
            }
            StatoFunzionalita tracciamentoBuste = t.getStato();
            if (tracciamentoBuste != null && !tracciamentoBuste.equals(CostantiConfigurazione.ABILITATO) && !tracciamentoBuste.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il valore 'buste' della configurazione per il tracciamento delle buste deve assumere i valori " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
        }
        if ((d = configurazione.getDump()) != null) {
            for (int j = 0; j < d.sizeOpenspcoopAppenderList(); ++j) {
                OpenspcoopAppender oa = d.getOpenspcoopAppender(j);
                if (oa.getTipo() == null) {
                    this.errori.add("E' stato definito un appender del dump per cui non e' stato definito il tipo");
                    continue;
                }
                if (!this.tipoDumpAppender.contains(oa.getTipo())) {
                    this.errori.add("E' stato definito un appender del dump per cui e' stato definito un tipo[" + oa.getTipo() + "] non valido, valori ammessi sono: " + this.getTipoDumpAppender());
                }
                for (int k = 0; k < oa.sizePropertyList(); ++k) {
                    Property oap = oa.getProperty(k);
                    if (oap.getNome() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] del dump per cui esiste una proprieta' senza un nome?");
                        continue;
                    }
                    if (oap.getValore() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] del dump per cui esiste una proprieta' senza un valore?");
                        continue;
                    }
                    String nomeOap = oap.getNome();
                    int numOap = 0;
                    for (int h = 0; h < oa.sizePropertyList(); ++h) {
                        Property tmpOap = oa.getProperty(h);
                        if (!nomeOap.equals(tmpOap.getNome())) continue;
                        ++numOap;
                    }
                    if (numOap <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una propriet\u00e0 con nome " + nomeOap + " per lo stesso appender[" + oa.getTipo() + "] delle tracce");
                }
            }
            StatoFunzionalita statoDump = d.getStato();
            if (statoDump != null && !statoDump.equals(CostantiConfigurazione.ABILITATO) && !statoDump.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il valore 'buste' della configurazione per il tracciamento delle buste deve assumere i valori " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
        }
        if (configurazione.getGestioneErrore() != null) {
            if (configurazione.getGestioneErrore().getComponenteCooperazione() != null) {
                this.validaGestioneErrore(configurazione.getGestioneErrore().getComponenteCooperazione(), "ConfigurazioneGenerale-GestioneErroreComponenteCooperazione");
            }
            if (configurazione.getGestioneErrore().getComponenteIntegrazione() != null) {
                this.validaGestioneErrore(configurazione.getGestioneErrore().getComponenteIntegrazione(), "ConfigurazioneGenerale-GestioneErroreComponenteIntegrazione");
            }
        }
        if ((im = configurazione.getIntegrationManager()) != null && im.getAutenticazione() != null && (v = im.getAutenticazione().split(",")) != null && v.length > 0) {
            for (int l = 0; l < v.length; ++l) {
                if (this.tipoAutenticazionePortaDelegata.contains(v[l].trim())) continue;
                this.errori.add("Processo di autenticazione[" + v[l].trim() + "] associato al servizio di IntegrationManager non conosciuto, valori ammessi: " + this.getTipoAutenticazionePortaDelegata());
            }
        }
        if ((s = configurazione.getStatoServiziPdd()) != null) {
            StatoServiziPddIntegrationManager sIM;
            StatoFunzionalita integrationManager;
            if (s.getPortaDelegata() != null) {
                StatoServiziPddPortaDelegata sPD = s.getPortaDelegata();
                StatoFunzionalita portaDelegata = sPD.getStato();
                if (portaDelegata != null && !portaDelegata.equals(CostantiConfigurazione.ABILITATO) && !portaDelegata.equals(CostantiConfigurazione.DISABILITATO)) {
                    this.errori.add("Il valore 'stato' della configurazione per quanto concerne i servizi attivi sulla porta (PD) deve assumere i valori " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
                }
                this.validaFiltriStatoServiziPdD("FiltroAbilitazione", sPD.getFiltroAbilitazioneList());
                this.validaFiltriStatoServiziPdD("FiltroDisabilitazione", sPD.getFiltroDisabilitazioneList());
            }
            if (s.getPortaApplicativa() != null) {
                StatoServiziPddPortaApplicativa sPA = s.getPortaApplicativa();
                StatoFunzionalita portaApplicativa = sPA.getStato();
                if (portaApplicativa != null && !portaApplicativa.equals(CostantiConfigurazione.ABILITATO) && !portaApplicativa.equals(CostantiConfigurazione.DISABILITATO)) {
                    this.errori.add("Il valore 'porta_applicativa' della configurazione per quanto concerne i servizi attivi sulla porta (PA) deve assumere i valori " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
                }
                this.validaFiltriStatoServiziPdD("FiltroAbilitazione", sPA.getFiltroAbilitazioneList());
                this.validaFiltriStatoServiziPdD("FiltroDisabilitazione", sPA.getFiltroDisabilitazioneList());
            }
            if (s.getIntegrationManager() != null && (integrationManager = (sIM = s.getIntegrationManager()).getStato()) != null && !integrationManager.equals(CostantiConfigurazione.ABILITATO) && !integrationManager.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il valore 'integration_manager' della configurazione per quanto concerne i servizi attivi sulla porta (IM) assumere i valori " + String.valueOf(CostantiConfigurazione.ABILITATO) + " o " + String.valueOf(CostantiConfigurazione.DISABILITATO));
            }
        }
    }

    private void validaCache(Cache cache, String posizione) {
        AlgoritmoCache algoritmo;
        if (cache.getDimensione() != null) {
            try {
                Integer.parseInt(cache.getDimensione());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla dimensione della cache [" + posizione + "] dev'essere un numero intero");
            }
        }
        if ((algoritmo = cache.getAlgoritmo()) != null && !algoritmo.equals(CostantiConfigurazione.CACHE_LRU) && !algoritmo.equals(CostantiConfigurazione.CACHE_MRU)) {
            this.errori.add("L'algoritmo dell'accesso alla cache [" + posizione + "] dev'essere " + String.valueOf(CostantiConfigurazione.CACHE_LRU) + " o " + String.valueOf(CostantiConfigurazione.CACHE_MRU));
        }
        if (cache.getItemIdleTime() != null) {
            try {
                Long.parseLong(cache.getItemIdleTime());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato all'item-idle-time della cache  [" + posizione + "] dev'essere un numero intero");
            }
        }
        if (cache.getItemLifeSecond() != null) {
            try {
                Long.parseLong(cache.getItemLifeSecond());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato all'item-life-seconds della cache [" + posizione + "] dev'essere un numero intero");
            }
        }
    }

    private void validaFiltriStatoServiziPdD(String tipologiaFiltri, List<TipoFiltroAbilitazioneServizi> lista) {
        if (lista != null) {
            for (int j = 0; j < lista.size(); ++j) {
                TipoFiltroAbilitazioneServizi tipoFiltroAbilitazioneServizi = lista.get(j);
            }
        }
    }

    private void validaRotta(Route route, String tipo, AccessoRegistro ar) throws DriverConfigurazioneException {
        if (route.getGateway() == null && route.getRegistro() == null) {
            this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato ne un Gateway ne un Registro");
        } else if (route.getGateway() != null && route.getRegistro() != null) {
            this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " che possiede sia un Gateway che un Registro (Solo un tipo deve essere selezionato)");
        } else if (route.getGateway() != null) {
            if (route.getGateway().getNome() == null) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato il nome del soggetto Gateway");
            }
            if (route.getGateway().getTipo() == null) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato il tipo del soggetto Gateway");
            }
        } else if (route.getRegistro().getNome() != null && ar != null) {
            boolean trovato = false;
            for (int i = 0; i < ar.sizeRegistroList(); ++i) {
                if (!ar.getRegistro(i).getNome().equals(route.getRegistro().getNome())) continue;
                trovato = true;
                break;
            }
            if (!trovato) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " per cui \u00e8 stata specificato un registro [" + route.getRegistro().getNome() + "] non esistente neella configurazione");
            }
        }
    }

    private void validaMessageSecurity(MessageSecurity messageSecurity, String idOggetto) throws DriverConfigurazioneException {
        MessageSecurityFlowParameter tmpSecurityParameter;
        int k;
        int numRF;
        MessageSecurityFlowParameter securityParameter;
        int j;
        MessageSecurityFlow messageSecurityFlow;
        if (messageSecurity.getRequestFlow() != null) {
            messageSecurityFlow = messageSecurity.getRequestFlow();
            for (j = 0; j < messageSecurityFlow.sizeParameterList(); ++j) {
                securityParameter = messageSecurityFlow.getParameter(j);
                if (securityParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella request-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (securityParameter.getValore() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella request-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < messageSecurityFlow.sizeParameterList(); ++k) {
                    tmpSecurityParameter = messageSecurityFlow.getParameter(k);
                    if (!securityParameter.getNome().equals(tmpSecurityParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MessageSecurity) Nella request-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + securityParameter.getNome());
            }
        }
        if (messageSecurity.getResponseFlow() != null) {
            messageSecurityFlow = messageSecurity.getResponseFlow();
            for (j = 0; j < messageSecurityFlow.sizeParameterList(); ++j) {
                securityParameter = messageSecurityFlow.getParameter(j);
                if (securityParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella response-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (securityParameter.getValore() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella response-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < messageSecurityFlow.sizeParameterList(); ++k) {
                    tmpSecurityParameter = messageSecurityFlow.getParameter(k);
                    if (!securityParameter.getNome().equals(tmpSecurityParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MessageSecurity) Nella response-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + securityParameter.getNome());
            }
        }
    }

    private void validaMTOM(MtomProcessor mtomProcessor, String idOggetto) throws DriverConfigurazioneException {
        MtomProcessorFlowParameter tmpMtomtFlowParameter;
        int k;
        int numRF;
        MtomProcessorFlowParameter mtomtFlowParameter;
        int j;
        if (mtomProcessor.getRequestFlow() != null) {
            MtomProcessorFlow mtomtFlow = mtomProcessor.getRequestFlow();
            for (j = 0; j < mtomtFlow.sizeParameterList(); ++j) {
                mtomtFlowParameter = mtomtFlow.getParameter(j);
                if (mtomtFlowParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella request-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (mtomtFlowParameter.getPattern() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella request-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < mtomtFlow.sizeParameterList(); ++k) {
                    tmpMtomtFlowParameter = mtomtFlow.getParameter(k);
                    if (!mtomtFlowParameter.getNome().equals(tmpMtomtFlowParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MTOM-Processor) Nella request-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + mtomtFlowParameter.getNome());
            }
        }
        if (mtomProcessor.getResponseFlow() != null) {
            MtomProcessorFlow mtomFlow = mtomProcessor.getResponseFlow();
            for (j = 0; j < mtomFlow.sizeParameterList(); ++j) {
                mtomtFlowParameter = mtomFlow.getParameter(j);
                if (mtomtFlowParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella response-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (mtomtFlowParameter.getPattern() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella response-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < mtomFlow.sizeParameterList(); ++k) {
                    tmpMtomtFlowParameter = mtomFlow.getParameter(k);
                    if (!mtomtFlowParameter.getNome().equals(tmpMtomtFlowParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MTOM-Processor) Nella response-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + mtomtFlowParameter.getNome());
            }
        }
    }

    private void validazioneValidazioneContenutiApplicativi(ValidazioneContenutiApplicativi vca, String tipo) throws DriverConfigurazioneException {
        ValidazioneContenutiApplicativiTipo tipoV;
        StatoFunzionalitaConWarning stato = vca.getStato();
        if (!(stato == null || stato.equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO) || stato.equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) || stato.equals(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY))) {
            this.errori.add("Lo stato della validazione contenuti applicativi (" + tipo + ") deve possedere uno dei seguenti valori: " + String.valueOf(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO) + ", " + String.valueOf(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) + " o " + String.valueOf(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY));
        }
        if (!((tipoV = vca.getTipo()) == null || tipoV.equals(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP) || tipoV.equals(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE) || tipoV.equals(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD))) {
            this.errori.add("Il tipo di validazione contenuti applicativi da attuare (" + tipo + ") deve possedere uno dei seguenti valori: " + String.valueOf(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD) + ", " + String.valueOf(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE) + " o " + String.valueOf(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP));
        }
    }

    private void validaProtocolProperty(Proprieta ssp, String oggetto) throws DriverConfigurazioneException {
        String valore;
        if (ssp.getNome() == null) {
            this.errori.add("Esiste una ProprietaProtocollo della porta " + oggetto + " che non contiene la definizione del nome");
        }
        if (ssp.getValore() == null) {
            this.errori.add("Esiste una ProprietaProtocollo della porta " + oggetto + " che non contiene la definizione del valore");
        }
        if ((valore = ssp.getValore()) == null) {
            this.errori.add("Il valore della ProprietaProtocollo " + ssp.getNome() + " della porta applicativa " + oggetto + " non e' valorizzato");
        }
    }

    private void validaCredenziale(Credenziali c, String oggetto) throws DriverConfigurazioneException {
        CredenzialeTipo tipo = CostantiConfigurazione.CREDENZIALE_SSL;
        if (c.getTipo() != null) {
            tipo = c.getTipo();
        }
        if (!(tipo.equals(CostantiConfigurazione.CREDENZIALE_BASIC) || tipo.equals(CostantiConfigurazione.CREDENZIALE_APIKEY) || tipo.equals(CostantiConfigurazione.CREDENZIALE_SSL) || tipo.equals(CostantiConfigurazione.CREDENZIALE_PRINCIPAL) || tipo.equals(CostantiConfigurazione.CREDENZIALE_TOKEN))) {
            this.errori.add("Il tipo delle credenziali del " + oggetto + " deve possedere i valori: " + CostantiConfigurazione.CREDENZIALE_BASIC.toString() + " o " + CostantiConfigurazione.CREDENZIALE_APIKEY.toString() + " o " + CostantiConfigurazione.CREDENZIALE_SSL.toString() + " o " + CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString() + " o " + CostantiConfigurazione.CREDENZIALE_TOKEN.toString());
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_BASIC) && (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals(""))) {
            this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_APIKEY) && (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals(""))) {
            this.errori.add("Le credenziali di tipo apikey del " + oggetto + " devono avere username e password valorizzati");
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_SSL)) {
            if ((c.getSubject() == null || c.getSubject().equals("")) && c.getCertificate() == null) {
                this.errori.add("Le credenziali di tipo ssl del " + oggetto + " devono avere subject o certificate valorizzato");
            } else {
                if (c.getSubject() != null && !"".equals(c.getSubject())) {
                    try {
                        CertificateUtils.validaPrincipal((String)c.getSubject(), (PrincipalType)PrincipalType.SUBJECT);
                    }
                    catch (Exception e) {
                        this.errori.add("Le credenziali di tipo ssl del " + oggetto + " possiedono un subject non valido: " + e.getMessage());
                    }
                }
                if (c.getIssuer() != null && !"".equals(c.getIssuer())) {
                    try {
                        CertificateUtils.validaPrincipal((String)c.getIssuer(), (PrincipalType)PrincipalType.ISSUER);
                    }
                    catch (Exception e) {
                        this.errori.add("Le credenziali di tipo ssl del " + oggetto + " possiedono un issuer non valido: " + e.getMessage());
                    }
                }
            }
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_PRINCIPAL) && (c.getUser() == null || c.getUser().equals(""))) {
            this.errori.add("Le credenziali di tipo principal del " + oggetto + " devono avere user valorizzato");
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_TOKEN)) {
            if (c.getUser() == null || c.getUser().equals("")) {
                this.errori.add("Le credenziali di tipo token del " + oggetto + " devono avere user valorizzato");
            }
            if (c.getTokenPolicy() == null || c.getTokenPolicy().equals("")) {
                this.errori.add("Le credenziali di tipo token del " + oggetto + " devono avere token-policy valorizzato");
            }
        }
    }

    private void validaCredenziale(InvocazioneCredenziali c, String oggetto) throws DriverConfigurazioneException {
        if (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals("")) {
            this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
        }
    }

    private void validaGestioneErrore(GestioneErrore ge, String tipo) throws DriverConfigurazioneException {
        int j;
        for (j = 0; j < ge.sizeCodiceTrasportoList(); ++j) {
            GestioneErroreComportamento comportamento;
            GestioneErroreCodiceTrasporto gect = ge.getCodiceTrasporto(j);
            if (gect.getValoreMinimo() == null || gect.getValoreMassimo() == null) {
                this.errori.add("Gli elementi codice-trasporto devono possedere almeno un valore minimo o un valore massimo");
            }
            if (gect.getValoreMinimo() != null && gect.getValoreMinimo().longValue() < 0L) {
                this.errori.add("Il valore minimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero >= 0 (Attualemente:" + gect.getValoreMinimo().longValue() + ")");
            }
            if (gect.getValoreMassimo() != null && gect.getValoreMassimo().longValue() <= 0L) {
                this.errori.add("Il valore massimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero > 0 (Attualemente:" + gect.getValoreMassimo().longValue() + ")");
            }
            if (gect.getValoreMassimo() != null && gect.getValoreMinimo().longValue() >= 0L && gect.getValoreMinimo() != null && gect.getValoreMassimo().longValue() > 0L && gect.getValoreMassimo().longValue() < gect.getValoreMinimo().longValue()) {
                this.errori.add("Il valore massimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero maggiore del valore associate al valore minimo (Attualemente max:" + gect.getValoreMassimo().longValue() + " min:" + gect.getValoreMinimo().longValue() + ")");
            }
            if ((comportamento = gect.getComportamento()) == null) {
                this.errori.add("Non e' stato definito il comportamento di adottato per la gestione errore (" + tipo + ") per un codice-trasporto");
            } else if (!comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) && !comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG)) {
                this.errori.add("Il comportamento associato alla gestione errore (" + tipo + "-CodiceTrasporto) deve assumere uno dei seguenti valori: " + String.valueOf(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) + " o " + String.valueOf(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG));
            }
            if (gect.getCadenzaRispedizione() == null) continue;
            try {
                Long.parseLong(gect.getCadenzaRispedizione());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione associato alla gestione errore (" + tipo + ") per un codice-trasporto, dev'essere un numero intero");
            }
        }
        for (j = 0; j < ge.sizeSoapFaultList(); ++j) {
            GestioneErroreComportamento comportamento;
            GestioneErroreSoapFault gesf = ge.getSoapFault(j);
            Object identificativo = "";
            identificativo = gesf.getFaultActor() == null ? "NULL-" : gesf.getFaultActor() + "-";
            identificativo = gesf.getFaultCode() == null ? (String)identificativo + "NULL-" : (String)identificativo + gesf.getFaultCode() + "-";
            identificativo = gesf.getFaultString() == null ? (String)identificativo + "NULL" : (String)identificativo + gesf.getFaultString();
            int numSF = 0;
            for (int k = 0; k < ge.sizeSoapFaultList(); ++k) {
                GestioneErroreSoapFault tmpGesf = ge.getSoapFault(k);
                Object tmpId = "";
                tmpId = tmpGesf.getFaultActor() == null ? "NULL-" : tmpGesf.getFaultActor() + "-";
                tmpId = tmpGesf.getFaultCode() == null ? (String)tmpId + "NULL-" : (String)tmpId + tmpGesf.getFaultCode() + "-";
                tmpId = tmpGesf.getFaultString() == null ? (String)tmpId + "NULL" : (String)tmpId + tmpGesf.getFaultString();
                if (!((String)identificativo).equals(tmpId)) continue;
                ++numSF;
            }
            if (numSF > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento soap-fault con identificativo " + (String)identificativo + " associato alla gestione errore (" + tipo + ")");
            }
            if ((comportamento = gesf.getComportamento()) == null) {
                this.errori.add("Non e' stato definito il comportamento di adottato per la gestione errore (" + tipo + ") per un soap-fault");
            } else if (!comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) && !comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG)) {
                this.errori.add("Il comportamento associato alla gestione errore (" + tipo + "-SoapFault) deve assumere uno dei seguenti valori: " + String.valueOf(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) + " o " + String.valueOf(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG));
            }
            if (gesf.getCadenzaRispedizione() == null) continue;
            try {
                Long.parseLong(gesf.getCadenzaRispedizione());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione associato alla gestione errore (" + tipo + ") per un soap-fault, dev'essere un numero intero");
            }
        }
        GestioneErroreComportamento comportamento = ge.getComportamento();
        if (comportamento == null) {
            this.errori.add("Non e' stato definito il comportamento di default adottato per la gestione errore (" + tipo + ")");
        } else if (!comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) && !comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG)) {
            this.errori.add("Il comportamento di default associato alla gestione errore (" + tipo + ") deve assumere uno dei seguenti valori: " + String.valueOf(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) + " o " + String.valueOf(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG));
        }
        if (ge.getCadenzaRispedizione() != null) {
            try {
                Long.parseLong(ge.getCadenzaRispedizione());
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione di default associato alla gestione errore (" + tipo + "), dev'essere un numero intero");
            }
        }
    }

    private boolean existsServizioApplicativo(String nome, Soggetto soggetto) {
        return this.getServizioApplicativo(nome, soggetto) != null;
    }

    private ServizioApplicativo getServizioApplicativo(String nome, Soggetto soggetto) {
        for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggetto.getServizioApplicativo(j);
            if (!nome.equals(sa.getNome())) continue;
            return sa;
        }
        return null;
    }
}

