/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.driver.ConnettorePropertiesUtilities;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_connettoriLIB;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_connettoriDriver {
    private DriverConfigurazioneDB driver = null;

    protected DriverConfigurazioneDB_connettoriDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
    }

    protected void createConnettore(Connettore connettore) throws DriverConfigurazioneException {
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConnettore type = 1");
            DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(1, connettore, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateConnettore(Connettore connettore) throws DriverConfigurazioneException {
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConnettore type = 2");
            DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(2, connettore, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteConnettore(Connettore connettore) throws DriverConfigurazioneException {
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDConnettore type = 3");
            DriverConfigurazioneDB_connettoriLIB.CRUDConnettore(3, connettore, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected List<String> connettoriList() throws DriverConfigurazioneException {
        ArrayList<String> arrayList;
        String nomeMetodo = "connettoriList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("nome_connettore");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                lista.add(risultato.getString("nome_connettore"));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected Property[] getPropertiesConnettore(String nomeConnettore) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getPropertiesConnettore");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverDB::getPropertiesConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        return this.getPropertiesConnettore(nomeConnettore, con);
    }

    protected Property[] getPropertiesConnettore(String nomeConnettore, Connection connection) throws DriverConfigurazioneException {
        try {
            List<Property> cList = ConnettorePropertiesUtilities.getPropertiesConnettore(nomeConnettore, connection, this.driver.tipoDB);
            return cList.toArray(new Property[cList.size()]);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[DriverDB::getPropertiesConnettore] DriverConfigurazioneException : " + e.getMessage(), e);
        }
    }

    protected boolean isPolicyNegoziazioneTokenUsedInConnettore(String nome) throws DriverConfigurazioneException {
        boolean bl;
        String nomeMetodo = "isPolicyNegoziazioneTokenUsedInConnettore";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("token_policy=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nome);
            risultato = stmt.executeQuery();
            bl = risultato.next();
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected Connettore getConnettore(long idConnettore) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String nomeMetodo = "getConnettore(id)";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            Connettore connettore = DriverConfigurazioneDB_connettoriLIB.getConnettore(idConnettore, con, this.driver.getDriverUnwrapBYOK());
            if (connettore == null) {
                throw new DriverConfigurazioneNotFound("Connettore con id '" + idConnettore + "' non esistente");
            }
            this.readCredenzialiBasicConnettore(connettore, idConnettore, con);
            Connettore connettore2 = connettore;
            return connettore2;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    protected Connettore getConnettore(String nomeConnettore) throws DriverConfigurazioneException {
        Connettore connettore;
        String nomeMetodo = "getConnettore(nome)";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("nome_connettore=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomeConnettore);
            risultato = stmt.executeQuery();
            Long idConnettore = null;
            if (!risultato.next()) {
                throw new DriverConfigurazioneNotFound("Connettore con nome '" + nomeConnettore + "' non esistente");
            }
            idConnettore = risultato.getLong("id");
            Connettore connettore2 = DriverConfigurazioneDB_connettoriLIB.getConnettore(idConnettore, con, this.driver.getDriverUnwrapBYOK());
            if (connettore2 == null) {
                throw new DriverConfigurazioneNotFound("Connettore con id '" + idConnettore + "' non esistente");
            }
            risultato.close();
            stmt.close();
            this.readCredenzialiBasicConnettore(connettore2, idConnettore, con);
            connettore = connettore2;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return connettore;
    }

    private void readCredenzialiBasicConnettore(Connettore connettore, long idConnettore, Connection con) throws DriverConfigurazioneException {
        String nomeMetodo = "getConnettore(nome)";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            if (!connettore.getProperties().containsKey("user")) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("utenteinv");
                sqlQueryObject.addSelectField("passwordinv");
                sqlQueryObject.addSelectField("enc_passwordinv");
                sqlQueryObject.addWhereCondition("id_connettore_inv=?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idConnettore);
                risultato = stmt.executeQuery();
                String user = null;
                String encPassword = null;
                String plainPassword = null;
                if (risultato.next()) {
                    user = risultato.getString("utenteinv");
                    plainPassword = risultato.getString("passwordinv");
                    encPassword = risultato.getString("enc_passwordinv");
                } else {
                    risultato.close();
                    stmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("utenterisp");
                    sqlQueryObject.addSelectField("passwordrisp");
                    sqlQueryObject.addSelectField("enc_passwordrisp");
                    sqlQueryObject.addWhereCondition("id_connettore_risp=?");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idConnettore);
                    risultato = stmt.executeQuery();
                    if (risultato.next()) {
                        user = risultato.getString("utenterisp");
                        plainPassword = risultato.getString("passwordrisp");
                        encPassword = risultato.getString("enc_passwordrisp");
                    }
                }
                this.setUsernameProperty(user, connettore);
                this.setPasswordProperty(plainPassword, encPassword, connettore);
            }
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            JDBCUtilities.closeResources(risultato, stmt);
        }
    }

    private void setUsernameProperty(String user, Connettore connettore) {
        if (user != null) {
            Property property = new Property();
            property.setNome("user");
            property.setValore(user);
            connettore.addProperty(property);
        }
    }

    private void setPasswordProperty(String plainPassword, String encPassword, Connettore connettore) throws UtilsException {
        if (plainPassword != null || encPassword != null) {
            Property property = new Property();
            property.setNome("password");
            if (encPassword != null && StringUtils.isNotEmpty((CharSequence)encPassword)) {
                IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
                if (driverBYOK != null) {
                    property.setValore(driverBYOK.unwrapAsString(encPassword));
                } else {
                    property.setValore(encPassword);
                }
            } else {
                property.setValore(plainPassword);
            }
            connettore.addProperty(property);
        }
    }
}

