/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.utils;

import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaBloccante;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConPersonalizzazione;

public class TracciamentoCompatibilitaFiltroEsiti {
    private TracciamentoConfigurazione database;
    private TracciamentoConfigurazione filetrace;

    public TracciamentoCompatibilitaFiltroEsiti(TracciamentoConfigurazione database, TracciamentoConfigurazione filetrace) {
        this.database = database;
        this.filetrace = filetrace;
    }

    public boolean isTracciamentoDBEnabled() {
        if (this.database == null || this.database.getStato() == null) {
            return true;
        }
        return !StatoFunzionalitaConPersonalizzazione.DISABILITATO.equals(this.database.getStato());
    }

    public boolean isTracciamentoDBRequestInEnabledBloccante() {
        return this.database != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.database.getStato()) && this.database.getRequestIn() != null && StatoFunzionalitaBloccante.ABILITATO.equals(this.database.getRequestIn());
    }

    public boolean isTracciamentoDBRequestInEnabledNonBloccante() {
        return this.database != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.database.getStato()) && this.database.getRequestIn() != null && StatoFunzionalitaBloccante.NON_BLOCCANTE.equals(this.database.getRequestIn());
    }

    public boolean isTracciamentoDBRequestOutEnabledBloccante() {
        return this.database != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.database.getStato()) && this.database.getRequestOut() != null && StatoFunzionalitaBloccante.ABILITATO.equals(this.database.getRequestOut());
    }

    public boolean isTracciamentoDBRequestOutEnabledNonBloccante() {
        return this.database != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.database.getStato()) && this.database.getRequestOut() != null && StatoFunzionalitaBloccante.NON_BLOCCANTE.equals(this.database.getRequestOut());
    }

    public boolean isTracciamentoDBResponseOutEnabledBloccante() {
        return this.database != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.database.getStato()) && this.database.getResponseOut() != null && StatoFunzionalitaBloccante.ABILITATO.equals(this.database.getResponseOut());
    }

    public boolean isTracciamentoDBResponseOutEnabledNonBloccante() {
        return this.database != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.database.getStato()) && this.database.getResponseOut() != null && StatoFunzionalitaBloccante.NON_BLOCCANTE.equals(this.database.getResponseOut());
    }

    public boolean isTracciamentoDBResponseOutCompleteEnabled() {
        if (this.database == null || this.database.getStato() == null) {
            return true;
        }
        switch (this.database.getStato()) {
            case ABILITATO: 
            case CONFIGURAZIONE_ESTERNA: {
                return true;
            }
            case DISABILITATO: {
                return false;
            }
            case PERSONALIZZATO: {
                return this.database.getResponseOutComplete() == null || StatoFunzionalita.ABILITATO.equals(this.database.getResponseOutComplete());
            }
        }
        return true;
    }

    public boolean isFilterDBEnabled() {
        if (!this.isTracciamentoDBEnabled()) {
            return false;
        }
        if (this.database == null) {
            return true;
        }
        if (this.database.getFiltroEsiti() == null) {
            return true;
        }
        if (StatoFunzionalita.DISABILITATO.equals(this.database.getFiltroEsiti())) {
            return false;
        }
        return !this.isTracciamentoDBRequestInEnabledBloccante() && !this.isTracciamentoDBRequestInEnabledNonBloccante();
    }

    public boolean isTracciamentoFileTraceEnabled() {
        if (this.filetrace == null || this.filetrace.getStato() == null) {
            return true;
        }
        return !StatoFunzionalitaConPersonalizzazione.DISABILITATO.equals(this.filetrace.getStato());
    }

    public boolean isTracciamentoFileTraceEnabledByExternalProperties() {
        if (this.filetrace == null || this.filetrace.getStato() == null) {
            return true;
        }
        return StatoFunzionalitaConPersonalizzazione.CONFIGURAZIONE_ESTERNA.equals(this.filetrace.getStato());
    }

    public boolean isTracciamentoFileTraceRequestInEnabledBloccante() {
        return this.filetrace != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.filetrace.getStato()) && this.filetrace.getRequestIn() != null && StatoFunzionalitaBloccante.ABILITATO.equals(this.filetrace.getRequestIn());
    }

    public boolean isTracciamentoFileTraceRequestInEnabledNonBloccante() {
        return this.filetrace != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.filetrace.getStato()) && this.filetrace.getRequestIn() != null && StatoFunzionalitaBloccante.NON_BLOCCANTE.equals(this.filetrace.getRequestIn());
    }

    public boolean isTracciamentoFileTraceRequestOutEnabledBloccante() {
        return this.filetrace != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.filetrace.getStato()) && this.filetrace.getRequestOut() != null && StatoFunzionalitaBloccante.ABILITATO.equals(this.filetrace.getRequestOut());
    }

    public boolean isTracciamentoFileTraceRequestOutEnabledNonBloccante() {
        return this.filetrace != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.filetrace.getStato()) && this.filetrace.getRequestOut() != null && StatoFunzionalitaBloccante.NON_BLOCCANTE.equals(this.filetrace.getRequestOut());
    }

    public boolean isTracciamentoFileTraceResponseOutEnabledBloccante() {
        return this.filetrace != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.filetrace.getStato()) && this.filetrace.getResponseOut() != null && StatoFunzionalitaBloccante.ABILITATO.equals(this.filetrace.getResponseOut());
    }

    public boolean isTracciamentoFileTraceResponseOutEnabledNonBloccante() {
        return this.filetrace != null && StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.equals(this.filetrace.getStato()) && this.filetrace.getResponseOut() != null && StatoFunzionalitaBloccante.NON_BLOCCANTE.equals(this.filetrace.getResponseOut());
    }

    public boolean isTracciamentoFileTraceResponseOutCompleteEnabled() {
        if (this.filetrace == null || this.filetrace.getStato() == null) {
            return false;
        }
        switch (this.filetrace.getStato()) {
            case ABILITATO: 
            case CONFIGURAZIONE_ESTERNA: {
                return true;
            }
            case DISABILITATO: {
                return false;
            }
            case PERSONALIZZATO: {
                return this.filetrace.getResponseOutComplete() == null || StatoFunzionalita.ABILITATO.equals(this.filetrace.getResponseOutComplete());
            }
        }
        return true;
    }

    public boolean isFilterFileTraceEnabled() {
        if (!this.isTracciamentoFileTraceEnabled()) {
            return false;
        }
        if (this.filetrace == null) {
            return false;
        }
        if (this.filetrace.getFiltroEsiti() == null) {
            return false;
        }
        if (StatoFunzionalita.DISABILITATO.equals(this.filetrace.getFiltroEsiti())) {
            return false;
        }
        return !this.isTracciamentoFileTraceRequestInEnabledBloccante() && !this.isTracciamentoFileTraceRequestInEnabledNonBloccante();
    }

    public boolean isTracciamentoEnabled() {
        return this.isTracciamentoDBEnabled() || this.isTracciamentoFileTraceEnabled();
    }

    public boolean isTracciamentoRequestInEnabledBloccante() {
        return this.isTracciamentoDBRequestInEnabledBloccante() || this.isTracciamentoFileTraceRequestInEnabledBloccante();
    }

    public boolean isTracciamentoRequestInEnabledNonBloccante() {
        return this.isTracciamentoDBRequestInEnabledNonBloccante() || this.isTracciamentoFileTraceRequestInEnabledNonBloccante();
    }

    private boolean isTracciamentoRequestInEnabled() {
        return this.isTracciamentoRequestInEnabledBloccante() || this.isTracciamentoRequestInEnabledNonBloccante();
    }

    public boolean isTracciamentoRequestOutEnabledBloccante() {
        return this.isTracciamentoDBRequestOutEnabledBloccante() || this.isTracciamentoFileTraceRequestOutEnabledBloccante();
    }

    public boolean isTracciamentoRequestOutEnabledNonBloccante() {
        return this.isTracciamentoDBRequestOutEnabledNonBloccante() || this.isTracciamentoFileTraceRequestOutEnabledNonBloccante();
    }

    private boolean isTracciamentoRequestOutEnabled() {
        return this.isTracciamentoRequestOutEnabledBloccante() || this.isTracciamentoRequestOutEnabledNonBloccante();
    }

    public boolean isTracciamentoResponseOutEnabledBloccante() {
        return this.isTracciamentoDBResponseOutEnabledBloccante() || this.isTracciamentoFileTraceResponseOutEnabledBloccante();
    }

    public boolean isTracciamentoResponseOutEnabledNonBloccante() {
        return this.isTracciamentoDBResponseOutEnabledNonBloccante() || this.isTracciamentoFileTraceResponseOutEnabledNonBloccante();
    }

    private boolean isTracciamentoResponseOutEnabled() {
        return this.isTracciamentoResponseOutEnabledBloccante() || this.isTracciamentoResponseOutEnabledNonBloccante();
    }

    public boolean isTracciamentoResponseOutCompleteEnabled() {
        return this.isTracciamentoDBResponseOutCompleteEnabled() || this.isTracciamentoFileTraceResponseOutCompleteEnabled();
    }

    public boolean isFilterEnabled() {
        return this.isFilterDBEnabled() || this.isFilterFileTraceEnabled();
    }

    public String getWarningMessageFilter() {
        boolean dbCase = false;
        boolean filetraceCase = false;
        if (this.isFilterDBEnabled() && (this.isTracciamentoDBRequestOutEnabledBloccante() || this.isTracciamentoDBRequestOutEnabledNonBloccante() || this.isTracciamentoDBResponseOutEnabledBloccante() || this.isTracciamentoDBResponseOutEnabledNonBloccante())) {
            dbCase = true;
        }
        if (this.isFilterFileTraceEnabled() && (this.isTracciamentoFileTraceRequestOutEnabledBloccante() || this.isTracciamentoFileTraceRequestOutEnabledNonBloccante() || this.isTracciamentoFileTraceResponseOutEnabledBloccante() || this.isTracciamentoFileTraceResponseOutEnabledNonBloccante())) {
            filetraceCase = true;
        }
        String posizione = null;
        if (dbCase && !filetraceCase) {
            posizione = " su database";
        } else if (!dbCase && filetraceCase) {
            posizione = " tramite filetrace";
        } else if (dbCase) {
            posizione = "";
        }
        if (posizione != null) {
            return "La registrazione" + posizione + ", attiva per la fase di consegna di una richiesta e/o di una risposta,<br/>non consente di filtrare esiti relativi ad errori di consegna o di processamento della risposta.";
        }
        return null;
    }
}

