/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.constants;

import java.io.Serializable;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.generic_project.beans.IEnumeration;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.utils.UtilsRuntimeException;

public enum TipoRisorsaPolicyAttiva implements IEnumeration,
Serializable,
Cloneable
{
    NUMERO_RICHIESTE_SIMULTANEE("NumeroRichiesteSimultanee"),
    NUMERO_RICHIESTE(TipoRisorsa.NUMERO_RICHIESTE.getValue()),
    DIMENSIONE_MASSIMA_MESSAGGIO(TipoRisorsa.DIMENSIONE_MASSIMA_MESSAGGIO.getValue()),
    OCCUPAZIONE_BANDA(TipoRisorsa.OCCUPAZIONE_BANDA.getValue()),
    TEMPO_COMPLESSIVO_RISPOSTA(TipoRisorsa.TEMPO_COMPLESSIVO_RISPOSTA.getValue()),
    TEMPO_MEDIO_RISPOSTA(TipoRisorsa.TEMPO_MEDIO_RISPOSTA.getValue()),
    NUMERO_RICHIESTE_FALLITE(TipoRisorsa.NUMERO_RICHIESTE_FALLITE.getValue()),
    NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO(TipoRisorsa.NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO.getValue()),
    NUMERO_FAULT_APPLICATIVI(TipoRisorsa.NUMERO_FAULT_APPLICATIVI.getValue()),
    NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI(TipoRisorsa.NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI.getValue()),
    NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI(TipoRisorsa.NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI.getValue());

    private String value;

    public String getValue() {
        return this.value;
    }

    private TipoRisorsaPolicyAttiva(String value) {
        this.value = value;
    }

    public static TipoRisorsaPolicyAttiva getTipo(String tipo, boolean richiesteSimultanee) throws NotFoundException {
        return TipoRisorsaPolicyAttiva.getTipo(TipoRisorsa.toEnumConstant(tipo, true), richiesteSimultanee);
    }

    public static TipoRisorsaPolicyAttiva getTipo(TipoRisorsa tipo, boolean richiesteSimultanee) throws NotFoundException {
        if (richiesteSimultanee) {
            return NUMERO_RICHIESTE_SIMULTANEE;
        }
        return TipoRisorsaPolicyAttiva.toEnumConstant(tipo.getValue(), true);
    }

    public TipoRisorsa getTipoRisorsa(boolean throwNotFoundException) throws NotFoundException {
        if (NUMERO_RICHIESTE_SIMULTANEE.equals(this)) {
            return TipoRisorsa.NUMERO_RICHIESTE;
        }
        return TipoRisorsa.toEnumConstant(this.value, throwNotFoundException);
    }

    public boolean isRichiesteSimultanee() {
        return NUMERO_RICHIESTE_SIMULTANEE.equals(this);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(String object) {
        if (object == null) {
            return false;
        }
        return object.equals(this.getValue());
    }

    public boolean equals(Object object, List<String> fieldsNotCheck) {
        if (fieldsNotCheck != null) {
            // empty if block
        }
        if (!(object instanceof TipoRisorsaPolicyAttiva)) {
            throw new UtilsRuntimeException("Wrong type: " + object.getClass().getName());
        }
        return this.equals(object);
    }

    public String toString(boolean reportHTML) {
        if (reportHTML) {
            // empty if block
        }
        return this.toString();
    }

    public String toString(boolean reportHTML, List<String> fieldsNotIncluded) {
        if (reportHTML || fieldsNotIncluded != null) {
            // empty if block
        }
        return this.toString();
    }

    public String diff(Object object, StringBuilder bf, boolean reportHTML) {
        if (reportHTML || object != null) {
            // empty if block
        }
        return bf.toString();
    }

    public String diff(Object object, StringBuilder bf, boolean reportHTML, List<String> fieldsNotIncluded) {
        if (reportHTML || object != null || fieldsNotIncluded != null) {
            // empty if block
        }
        return bf.toString();
    }

    public static String[] toArray() {
        String[] res = new String[TipoRisorsaPolicyAttiva.values().length];
        int i = 0;
        for (TipoRisorsaPolicyAttiva tmp : TipoRisorsaPolicyAttiva.values()) {
            res[i] = tmp.getValue();
            ++i;
        }
        return res;
    }

    public static String[] toStringArray() {
        String[] res = new String[TipoRisorsaPolicyAttiva.values().length];
        int i = 0;
        for (TipoRisorsaPolicyAttiva tmp : TipoRisorsaPolicyAttiva.values()) {
            res[i] = tmp.toString();
            ++i;
        }
        return res;
    }

    public static String[] toEnumNameArray() {
        String[] res = new String[TipoRisorsaPolicyAttiva.values().length];
        int i = 0;
        for (TipoRisorsaPolicyAttiva tmp : TipoRisorsaPolicyAttiva.values()) {
            res[i] = tmp.name();
            ++i;
        }
        return res;
    }

    public static boolean contains(String value) {
        return TipoRisorsaPolicyAttiva.toEnumConstant(value) != null;
    }

    public static TipoRisorsaPolicyAttiva toEnumConstant(String value) {
        try {
            return TipoRisorsaPolicyAttiva.toEnumConstant(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static TipoRisorsaPolicyAttiva toEnumConstant(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoRisorsaPolicyAttiva res = null;
        for (TipoRisorsaPolicyAttiva tmp : TipoRisorsaPolicyAttiva.values()) {
            if (!tmp.getValue().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }

    public static IEnumeration toEnumConstantFromString(String value) {
        try {
            return TipoRisorsaPolicyAttiva.toEnumConstantFromString(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static IEnumeration toEnumConstantFromString(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoRisorsaPolicyAttiva res = null;
        for (TipoRisorsaPolicyAttiva tmp : TipoRisorsaPolicyAttiva.values()) {
            if (!tmp.toString().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }
}

