/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.integrazione.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.core.integrazione.EsitoRichiesta;
import org.openspcoop2.core.integrazione.utils.XMLUtilsException;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.openspcoop2.utils.xml.XSDResourceResolver;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;

public class EsitoRichiestaXMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    private static synchronized void initValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            XSDResourceResolver xsdResourceResolver = new XSDResourceResolver();
            xsdResourceResolver.addResource("soapEnvelope.xsd", EsitoRichiestaXMLUtils.class.getResourceAsStream("/soapEnvelope.xsd"));
            validatoreXSD = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), log, (LSResourceResolver)xsdResourceResolver, EsitoRichiestaXMLUtils.class.getResourceAsStream("/openspcoopPresaInCarico.xsd"));
        }
    }

    public static ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            EsitoRichiestaXMLUtils.initValidatoreXSD(log);
        }
        return validatoreXSD;
    }

    public static boolean validate(EsitoRichiesta esito, StringBuilder motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (esito.getMessageId() == null) {
            motivoErroreValidazione.append("Identificativo Messaggio non definito\n");
        }
        if (esito.getState() == null) {
            motivoErroreValidazione.append("Stato non definito\n");
        }
        return motivoErroreValidazione.length() == size;
    }

    public static EsitoRichiesta getEsitoRichiesta(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            EsitoRichiesta esitoRichiesta = EsitoRichiestaXMLUtils.getEsitoRichiesta(log, bin);
            return esitoRichiesta;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static EsitoRichiesta getEsitoRichiesta(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            EsitoRichiesta esitoRichiesta = EsitoRichiestaXMLUtils.getEsitoRichiesta(log, fin);
            return esitoRichiesta;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static EsitoRichiesta getEsitoRichiesta(Logger log, String m) throws XMLUtilsException {
        return EsitoRichiestaXMLUtils.getEsitoRichiesta(log, m.getBytes());
    }

    public static EsitoRichiesta getEsitoRichiesta(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = EsitoRichiestaXMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (EsitoRichiesta)JaxbUtils.xmlToObj((InputStream)binTrasformazione, EsitoRichiesta.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateEsitoRichiesta(EsitoRichiesta esitoRichiesta, File out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!EsitoRichiestaXMLUtils.validate(esitoRichiesta, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])EsitoRichiestaXMLUtils.generateEsitoRichiesta_engine(esitoRichiesta));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateEsitoRichiesta(EsitoRichiesta esitoRichiesta, String fileName) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!EsitoRichiestaXMLUtils.validate(esitoRichiesta, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])EsitoRichiestaXMLUtils.generateEsitoRichiesta_engine(esitoRichiesta));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateEsitoRichiesta(EsitoRichiesta esitoRichiesta) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!EsitoRichiestaXMLUtils.validate(esitoRichiesta, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return EsitoRichiestaXMLUtils.generateEsitoRichiesta_engine(esitoRichiesta);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateEsitoRichiesta(EsitoRichiesta esitoRichiesta, OutputStream out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!EsitoRichiestaXMLUtils.validate(esitoRichiesta, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(EsitoRichiestaXMLUtils.generateEsitoRichiesta_engine(esitoRichiesta));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static String generateEsitoRichiestaAsJson(EsitoRichiesta esitoRichiesta) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!EsitoRichiestaXMLUtils.validate(esitoRichiesta, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return EsitoRichiestaXMLUtils.generateEsitoRichiestaAsJson_engine(esitoRichiesta);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateEsitoRichiesta_engine(EsitoRichiesta esitoRichiesta) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, EsitoRichiesta.class, (Object)esitoRichiesta);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static String generateEsitoRichiestaAsJson_engine(EsitoRichiesta esitoRichiesta) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            esitoRichiesta.writeTo(bout, WriteToSerializerType.JSON_JACKSON);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isEsitoRichiesta(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return EsitoRichiestaXMLUtils.isEsitoRichiesta_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEsitoRichiesta(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return EsitoRichiestaXMLUtils.isEsitoRichiesta_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEsitoRichiesta(Element elemXML) {
        return EsitoRichiestaXMLUtils.isEsitoRichiesta_engine(elemXML);
    }

    public static boolean isEsitoRichiesta(Node nodeXml) {
        return EsitoRichiestaXMLUtils.isEsitoRichiesta_engine(nodeXml);
    }

    private static boolean isEsitoRichiesta_engine(Node nodeXml) {
        try {
            return "result".equals(nodeXml.getLocalName()) && "http://govway.org/integration".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

