/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.mapping.FiltroRicercaProtocolProperty;
import org.openspcoop2.core.mapping.ProtocolProperty;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCParameterUtilities;
import org.openspcoop2.utils.jdbc.NullByteTextColumnSanitizer;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class DBProtocolPropertiesUtils {
    private static List<String> protocolPropertiesConfidentials = new ArrayList<String>();
    private static final String AND_SEPARATOR = " AND ";
    private static final String IS_NULL_CONDITION = "is null";

    private DBProtocolPropertiesUtils() {
    }

    private static void logDebug(Logger log, String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    public static List<String> getProtocolPropertiesConfidentials() {
        return protocolPropertiesConfidentials;
    }

    public static void addConfidentialProtocolProperty(String nome) {
        if (!protocolPropertiesConfidentials.contains(nome)) {
            protocolPropertiesConfidentials.add(nome);
        }
    }

    public static boolean isConfidentialProtocolProperty(String nome) {
        return protocolPropertiesConfidentials.contains(nome);
    }

    public static void crudRegistryProtocolProperty(Logger log, int type, List<org.openspcoop2.core.registry.ProtocolProperty> listPP, long idProprietario, ProprietariProtocolProperty tipologiaProprietarioProtocolProperty, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException {
        ArrayList<ProtocolProperty> list = null;
        if (listPP != null) {
            list = new ArrayList<ProtocolProperty>();
            if (!listPP.isEmpty()) {
                for (org.openspcoop2.core.registry.ProtocolProperty pp : listPP) {
                    list.add(new ProtocolProperty(pp));
                }
            }
        }
        DBProtocolPropertiesUtils.crudProtocolProperty(log, type, list, idProprietario, tipologiaProprietarioProtocolProperty, connection, tipoDatabase, driverBYOK);
    }

    public static void crudConfigProtocolProperty(Logger log, int type, List<org.openspcoop2.core.config.ProtocolProperty> listPP, long idProprietario, ProprietariProtocolProperty tipologiaProprietarioProtocolProperty, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException {
        ArrayList<ProtocolProperty> list = null;
        if (listPP != null) {
            list = new ArrayList<ProtocolProperty>();
            if (!listPP.isEmpty()) {
                for (org.openspcoop2.core.config.ProtocolProperty pp : listPP) {
                    list.add(new ProtocolProperty(pp));
                }
            }
        }
        DBProtocolPropertiesUtils.crudProtocolProperty(log, type, list, idProprietario, tipologiaProprietarioProtocolProperty, connection, tipoDatabase, driverBYOK);
    }

    /*
     * Unable to fully structure code
     */
    private static void crudProtocolProperty(Logger log, int type, List<ProtocolProperty> listPP, long idProprietario, ProprietariProtocolProperty tipologiaProprietarioProtocolProperty, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException {
        stm = null;
        rs = null;
        if (listPP == null && type != 3) {
            throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] L'oggetto listPP non puo essere null");
        }
        if (idProprietario <= 0L) {
            throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] id proprietario non definito");
        }
        jdbcAdapter = null;
        try {
            jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            switch (type) {
                case 1: {
                    if (listPP == null) ** break;
                    for (i = 0; i < listPP.size(); ++i) {
                        protocolProperty = listPP.get(i);
                        if (protocolProperty.getName() == null || "".equals(protocolProperty.getName())) {
                            throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] Nome non definito per protocolProperty [" + i + "]");
                        }
                        protocolProperty.setIdProprietario(idProprietario);
                        protocolProperty.setTipoProprietario(tipologiaProprietarioProtocolProperty.name());
                        contenutiDefiniti = 0;
                        stringValue = protocolProperty.getValue() != null && "".equals(protocolProperty.getValue()) == false;
                        plainContenutoString = null;
                        encContenutoString = null;
                        if (stringValue) {
                            ++contenutiDefiniti;
                            plainContenutoString = protocolProperty.getValue();
                            if (driverBYOK != null && DBProtocolPropertiesUtils.isConfidentialProtocolProperty(protocolProperty.getName()) && (byokValue = driverBYOK.wrap(protocolProperty.getValue())) != null) {
                                encContenutoString = byokValue.getWrappedValue();
                                plainContenutoString = byokValue.getWrappedPlainValue();
                            }
                            if (NullByteTextColumnSanitizer.needsSanitization((String)tipoDatabase)) {
                                plainContenutoString = NullByteTextColumnSanitizer.sanitize((String)tipoDatabase, (String)plainContenutoString);
                            }
                        }
                        numberValue = protocolProperty.getNumberValue() != null;
                        contenutoNumber = null;
                        if (numberValue) {
                            ++contenutiDefiniti;
                            contenutoNumber = protocolProperty.getNumberValue();
                        }
                        booleanValue = protocolProperty.getBooleanValue() != null;
                        contenutoBoolean = null;
                        if (booleanValue) {
                            ++contenutiDefiniti;
                            contenutoBoolean = protocolProperty.getBooleanValue();
                        }
                        binaryValue = protocolProperty.getByteFile() != null && protocolProperty.getByteFile().length > 0;
                        contenutoBinario = null;
                        contenutoBinarioFileName = null;
                        if (binaryValue) {
                            ++contenutiDefiniti;
                            contenutoBinario = protocolProperty.getByteFile();
                            if (contenutoBinario.length < 3 && "".equals((test = new String(contenutoBinario)).trim().replace("\n", ""))) {
                                contenutoBinario = null;
                                binaryValue = false;
                                --contenutiDefiniti;
                            }
                            if (binaryValue) {
                                contenutoBinarioFileName = protocolProperty.getFile();
                                if (driverBYOK != null && DBProtocolPropertiesUtils.isConfidentialProtocolProperty(protocolProperty.getName()) && (byokValue = driverBYOK.wrap(contenutoBinario)) != null) {
                                    contenutoBinario = byokValue.getWrappedValue().getBytes();
                                }
                            }
                        }
                        if (contenutiDefiniti > 1) {
                            throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] Contenuto definito con pi\u00f9 tipologie per protocolProperty [" + protocolProperty.getName() + "] (string:" + stringValue + " number:" + numberValue + " binary:" + binaryValue + ")");
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                        sqlQueryObject.addInsertTable("protocol_properties");
                        sqlQueryObject.addInsertField("tipo_proprietario", "?");
                        sqlQueryObject.addInsertField("id_proprietario", "?");
                        sqlQueryObject.addInsertField("name", "?");
                        if (stringValue) {
                            sqlQueryObject.addInsertField("value_string", "?");
                            sqlQueryObject.addInsertField("enc_value_string", "?");
                        }
                        if (numberValue) {
                            sqlQueryObject.addInsertField("value_number", "?");
                        }
                        if (booleanValue) {
                            sqlQueryObject.addInsertField("value_boolean", "?");
                        }
                        if (binaryValue) {
                            sqlQueryObject.addInsertField("value_binary", "?");
                            sqlQueryObject.addInsertField("file_name", "?");
                        }
                        sqlQuery = sqlQueryObject.createSQLInsert();
                        stm = connection.prepareStatement(sqlQuery);
                        index = 1;
                        stm.setString(index++, tipologiaProprietarioProtocolProperty.name());
                        stm.setLong(index++, idProprietario);
                        stm.setString(index++, protocolProperty.getName());
                        debug = null;
                        if (stringValue) {
                            stm.setString(index++, plainContenutoString);
                            debug = plainContenutoString;
                            stm.setString(index++, encContenutoString);
                        }
                        if (numberValue) {
                            stm.setLong(index++, contenutoNumber);
                            debug = "" + contenutoNumber;
                        }
                        if (booleanValue) {
                            if (contenutoBoolean != null && contenutoBoolean.booleanValue()) {
                                stm.setInt(index++, 1);
                                debug = "1";
                            } else {
                                stm.setInt(index++, 0);
                                debug = "0";
                            }
                        }
                        if (binaryValue) {
                            jdbcAdapter.setBinaryData((PreparedStatement)stm, index++, contenutoBinario);
                            debug = "BinaryData";
                            stm.setString(index++, contenutoBinarioFileName);
                            debug = (String)debug + "," + contenutoBinarioFileName;
                        }
                        DBProtocolPropertiesUtils.logDebug(log, "CRUDProtocolProperty CREATE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{tipologiaProprietarioProtocolProperty.name(), idProprietario, protocolProperty.getName(), debug}));
                        n = stm.executeUpdate();
                        stm.close();
                        DBProtocolPropertiesUtils.logDebug(log, "Inserted " + n + " row(s)");
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                        sqlQueryObject.addFromTable("protocol_properties");
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                        sqlQueryObject.addWhereCondition("id_proprietario = ?");
                        sqlQueryObject.addWhereCondition("name = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = connection.prepareStatement(sqlQuery);
                        index = 1;
                        stm.setString(index++, tipologiaProprietarioProtocolProperty.name());
                        stm.setLong(index++, idProprietario);
                        stm.setString(index++, protocolProperty.getName());
                        DBProtocolPropertiesUtils.logDebug(log, "Recupero id inserito : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{tipologiaProprietarioProtocolProperty.name(), idProprietario, protocolProperty.getName()}));
                        rs = stm.executeQuery();
                        if (!rs.next()) {
                            throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] Errore avvenuto durante il recupero dell'id dopo una create");
                        }
                        listPP.get(i).setId(rs.getLong("id"));
                        rs.close();
                        stm.close();
                    }
                    break;
                }
                case 2: {
                    oldLista = DBProtocolPropertiesUtils.getListaProtocolPropertySafe(idProprietario, tipologiaProprietarioProtocolProperty, connection, tipoDatabase, null);
                    if (listPP != null) {
                        for (i = 0; i < listPP.size(); ++i) {
                            protocolProperty = listPP.get(i);
                            if (protocolProperty.getName() == null || "".equals(protocolProperty.getName())) {
                                throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] Nome non definito per protocolProperty [" + i + "]");
                            }
                            protocolProperty.setIdProprietario(idProprietario);
                            protocolProperty.setTipoProprietario(tipologiaProprietarioProtocolProperty.name());
                            contenutiDefiniti = 0;
                            stringValue = protocolProperty.getValue() != null && "".equals(protocolProperty.getValue()) == false;
                            plainContenutoString = null;
                            encContenutoString = null;
                            if (stringValue) {
                                ++contenutiDefiniti;
                                plainContenutoString = protocolProperty.getValue();
                                if (driverBYOK != null && DBProtocolPropertiesUtils.isConfidentialProtocolProperty(protocolProperty.getName()) && (byokValue = driverBYOK.wrap(protocolProperty.getValue())) != null) {
                                    encContenutoString = byokValue.getWrappedValue();
                                    plainContenutoString = byokValue.getWrappedPlainValue();
                                }
                                if (NullByteTextColumnSanitizer.needsSanitization((String)tipoDatabase)) {
                                    plainContenutoString = NullByteTextColumnSanitizer.sanitize((String)tipoDatabase, (String)plainContenutoString);
                                }
                            }
                            numberValue = protocolProperty.getNumberValue() != null;
                            contenutoNumber = null;
                            if (numberValue) {
                                ++contenutiDefiniti;
                                contenutoNumber = protocolProperty.getNumberValue();
                            }
                            booleanValue = protocolProperty.getBooleanValue() != null;
                            contenutoBoolean = null;
                            if (booleanValue) {
                                ++contenutiDefiniti;
                                contenutoBoolean = protocolProperty.getBooleanValue();
                            }
                            binaryValue = protocolProperty.getByteFile() != null && protocolProperty.getByteFile().length > 0;
                            contenutoBinario = null;
                            contenutoBinarioFileName = null;
                            if (binaryValue) {
                                ++contenutiDefiniti;
                                contenutoBinario = protocolProperty.getByteFile();
                                if (contenutoBinario.length < 3 && "".equals((test = new String(contenutoBinario)).trim().replace("\n", ""))) {
                                    contenutoBinario = null;
                                    binaryValue = false;
                                    --contenutiDefiniti;
                                }
                                if (binaryValue) {
                                    contenutoBinarioFileName = protocolProperty.getFile();
                                    if (driverBYOK != null && DBProtocolPropertiesUtils.isConfidentialProtocolProperty(protocolProperty.getName()) && (byokValue = driverBYOK.wrap(contenutoBinario)) != null) {
                                        contenutoBinario = byokValue.getWrappedValue().getBytes();
                                    }
                                }
                            }
                            if (contenutiDefiniti > 1) {
                                throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] Contenuto definito con pi\u00f9 tipologie per protocolProperty [" + protocolProperty.getName() + "] (string:" + stringValue + " number:" + numberValue + " binary:" + binaryValue + ")");
                            }
                            protocolProperty.setId(DBUtils.getIdProtocolProperty(protocolProperty.getTipoProprietario(), idProprietario, protocolProperty.getName(), connection, tipoDatabase));
                            ppGiaPresente = false;
                            ppDaAggiornare = false;
                            if (protocolProperty.getId() > 0L) {
                                for (j = 0; j < oldLista.size(); ++j) {
                                    old = oldLista.get(j);
                                    if (protocolProperty.getId().longValue() != old.getId().longValue()) continue;
                                    ppGiaPresente = true;
                                    oldLista.remove(j);
                                    ppDaAggiornare = true;
                                    break;
                                }
                            }
                            if (ppGiaPresente) {
                                if (!ppDaAggiornare) continue;
                                idPP = protocolProperty.getId();
                                if (idPP <= 0L) {
                                    throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] ID non definito per documento da aggiorare [" + protocolProperty.getName() + "]");
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                                sqlQueryObject.addUpdateTable("protocol_properties");
                                sqlQueryObject.addUpdateField("value_string", "?");
                                sqlQueryObject.addUpdateField("enc_value_string", "?");
                                sqlQueryObject.addUpdateField("value_number", "?");
                                sqlQueryObject.addUpdateField("value_boolean", "?");
                                sqlQueryObject.addUpdateField("value_binary", "?");
                                sqlQueryObject.addUpdateField("file_name", "?");
                                sqlQueryObject.addWhereCondition("id=?");
                                sqlQuery = sqlQueryObject.createSQLUpdate();
                                stm = connection.prepareStatement(sqlQuery);
                                index = 1;
                                stm.setString(index++, plainContenutoString);
                                stm.setString(index++, encContenutoString);
                                if (numberValue) {
                                    stm.setLong(index++, contenutoNumber);
                                } else {
                                    stm.setNull(index++, -5);
                                }
                                if (booleanValue) {
                                    if (contenutoBoolean != null && contenutoBoolean.booleanValue()) {
                                        stm.setInt(index++, 1);
                                    } else {
                                        stm.setInt(index++, 0);
                                    }
                                } else {
                                    stm.setNull(index++, 4);
                                }
                                jdbcAdapter.setBinaryData((PreparedStatement)stm, index++, contenutoBinario);
                                stm.setString(index++, contenutoBinarioFileName);
                                stm.setLong(index++, idPP);
                                stm.executeUpdate();
                                stm.close();
                                continue;
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                            sqlQueryObject.addInsertTable("protocol_properties");
                            sqlQueryObject.addInsertField("tipo_proprietario", "?");
                            sqlQueryObject.addInsertField("id_proprietario", "?");
                            sqlQueryObject.addInsertField("name", "?");
                            if (stringValue) {
                                sqlQueryObject.addInsertField("value_string", "?");
                                sqlQueryObject.addInsertField("enc_value_string", "?");
                            }
                            if (numberValue) {
                                sqlQueryObject.addInsertField("value_number", "?");
                            }
                            if (booleanValue) {
                                sqlQueryObject.addInsertField("value_boolean", "?");
                            }
                            if (binaryValue) {
                                sqlQueryObject.addInsertField("value_binary", "?");
                                sqlQueryObject.addInsertField("file_name", "?");
                            }
                            sqlQuery = sqlQueryObject.createSQLInsert();
                            stm = connection.prepareStatement(sqlQuery);
                            index = 1;
                            stm.setString(index++, tipologiaProprietarioProtocolProperty.name());
                            stm.setLong(index++, idProprietario);
                            stm.setString(index++, protocolProperty.getName());
                            debug = null;
                            if (stringValue) {
                                stm.setString(index++, plainContenutoString);
                                debug = plainContenutoString;
                                stm.setString(index++, encContenutoString);
                            }
                            if (numberValue) {
                                stm.setLong(index++, contenutoNumber);
                                debug = "" + contenutoNumber;
                            }
                            if (booleanValue) {
                                if (contenutoBoolean != null && contenutoBoolean.booleanValue()) {
                                    stm.setInt(index++, 1);
                                    debug = "1";
                                } else {
                                    stm.setInt(index++, 0);
                                    debug = "0";
                                }
                            }
                            if (binaryValue) {
                                jdbcAdapter.setBinaryData((PreparedStatement)stm, index++, contenutoBinario);
                                debug = "BinaryData";
                                stm.setString(index++, contenutoBinarioFileName);
                                debug = (String)debug + "," + contenutoBinarioFileName;
                            }
                            DBProtocolPropertiesUtils.logDebug(log, "CRUDProtocolProperty CREATE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{tipologiaProprietarioProtocolProperty.name(), idProprietario, protocolProperty.getName(), debug}));
                            n = stm.executeUpdate();
                            stm.close();
                            DBProtocolPropertiesUtils.logDebug(log, "Inserted " + n + " row(s)");
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                            sqlQueryObject.addFromTable("protocol_properties");
                            sqlQueryObject.addSelectField("id");
                            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                            sqlQueryObject.addWhereCondition("id_proprietario = ?");
                            sqlQueryObject.addWhereCondition("name = ?");
                            sqlQueryObject.setANDLogicOperator(true);
                            sqlQuery = sqlQueryObject.createSQLQuery();
                            stm = connection.prepareStatement(sqlQuery);
                            index = 1;
                            stm.setString(index++, tipologiaProprietarioProtocolProperty.name());
                            stm.setLong(index++, idProprietario);
                            stm.setString(index++, protocolProperty.getName());
                            DBProtocolPropertiesUtils.logDebug(log, "Recupero id inserito : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{tipologiaProprietarioProtocolProperty.name(), idProprietario, protocolProperty.getName()}));
                            rs = stm.executeQuery();
                            if (!rs.next()) {
                                throw new CoreException("[DBProtocolProperties::CRUDProtocolProperty] Errore avvenuto durante il recupero dell'id dopo una create");
                            }
                            listPP.get(i).setId(rs.getLong("id"));
                            rs.close();
                            stm.close();
                        }
                    }
                    if (oldLista.isEmpty()) ** break;
                    for (j = 0; j < oldLista.size(); ++j) {
                        old = oldLista.get(j);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                        sqlQueryObject.addDeleteTable("protocol_properties");
                        sqlQueryObject.addWhereCondition("id=?");
                        sqlQuery = sqlQueryObject.createSQLDelete();
                        stm = connection.prepareStatement(sqlQuery);
                        stm.setLong(1, old.getId());
                        stm.executeUpdate();
                        stm.close();
                    }
                    break;
                }
                case 3: {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
                    sqlQueryObject.addDeleteTable("protocol_properties");
                    sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                    sqlQueryObject.addWhereCondition("id_proprietario=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setString(1, tipologiaProprietarioProtocolProperty.name());
                    stm.setLong(2, idProprietario);
                    stm.executeUpdate();
                    stm.close();
                    DBProtocolPropertiesUtils.logDebug(log, "CRUDDocumento DELETE : \n" + DBUtils.formatSQLString(sqlQuery, new Object[]{tipologiaProprietarioProtocolProperty.name(), idProprietario}));
                    ** break;
lbl358:
                    // 1 sources

                    break;
                }
                ** default:
lbl360:
                // 1 sources

                break;
            }
        }
        catch (SQLException se) {
            throw new CoreException("[DBProtocolProperties::CRUDDocumento] SQLException : " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new CoreException("[DBProtocolProperties::CRUDDocumento] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception var34_67) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception var34_68) {}
        }
    }

    public static List<org.openspcoop2.core.registry.ProtocolProperty> getListaProtocolPropertyRegistry(long idProprietario, ProprietariProtocolProperty tipologiaProprietario, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException, NotFoundException {
        List<ProtocolProperty> l = DBProtocolPropertiesUtils.getListaProtocolProperty(idProprietario, tipologiaProprietario, connection, tipoDatabase, driverBYOK);
        ArrayList<org.openspcoop2.core.registry.ProtocolProperty> lPP = null;
        if (l == null) {
            return lPP;
        }
        lPP = new ArrayList<org.openspcoop2.core.registry.ProtocolProperty>();
        if (!l.isEmpty()) {
            for (ProtocolProperty protocolProperty : l) {
                lPP.add(protocolProperty.toRegistry());
            }
        }
        return lPP;
    }

    public static List<org.openspcoop2.core.config.ProtocolProperty> getListaProtocolPropertyConfig(long idProprietario, ProprietariProtocolProperty tipologiaProprietario, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException, NotFoundException {
        List<ProtocolProperty> l = DBProtocolPropertiesUtils.getListaProtocolProperty(idProprietario, tipologiaProprietario, connection, tipoDatabase, driverBYOK);
        ArrayList<org.openspcoop2.core.config.ProtocolProperty> lPP = null;
        if (l == null) {
            return lPP;
        }
        lPP = new ArrayList<org.openspcoop2.core.config.ProtocolProperty>();
        if (!l.isEmpty()) {
            for (ProtocolProperty protocolProperty : l) {
                lPP.add(protocolProperty.toConfig());
            }
        }
        return lPP;
    }

    public static List<ProtocolProperty> getListaProtocolPropertySafe(long idProprietario, ProprietariProtocolProperty tipologiaProprietario, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException {
        ArrayList<ProtocolProperty> l = null;
        try {
            l = DBProtocolPropertiesUtils.getListaProtocolProperty(idProprietario, tipologiaProprietario, connection, tipoDatabase, driverBYOK);
        }
        catch (NotFoundException dNotFound) {
            l = new ArrayList();
        }
        return l;
    }

    public static List<ProtocolProperty> getListaProtocolProperty(long idProprietario, ProprietariProtocolProperty tipologiaProprietario, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException, NotFoundException {
        Statement stm = null;
        ResultSet rs = null;
        if (idProprietario <= 0L) {
            throw new CoreException("[DBProtocolProperties::getListaProtocolProperty] id proprietario non definito");
        }
        try {
            ArrayList<ProtocolProperty> listPP = new ArrayList<ProtocolProperty>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("protocol_properties");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, tipologiaProprietario.name());
            stm.setLong(2, idProprietario);
            rs = stm.executeQuery();
            while (rs.next()) {
                ProtocolProperty pp = DBProtocolPropertiesUtils.getProtocolProperty(rs.getLong("id"), connection, tipoDatabase, driverBYOK);
                listPP.add(pp);
            }
            if (listPP.isEmpty()) {
                throw new NotFoundException("ProtocolProperty con tipologiaProprietario[" + tipologiaProprietario.name() + "] e idProprietario[" + idProprietario + "] non trovati");
            }
            ArrayList<ProtocolProperty> arrayList = listPP;
            return arrayList;
        }
        catch (SQLException se) {
            throw new CoreException("[DBProtocolProperties::getListaProtocolProperty] SQLException : " + se.getMessage(), se);
        }
        catch (NotFoundException dnf) {
            throw dnf;
        }
        catch (Exception se) {
            throw new CoreException("[DBProtocolProperties::getListaProtocolProperty] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static org.openspcoop2.core.registry.ProtocolProperty getProtocolPropertyRegistry(long id, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException, NotFoundException {
        ProtocolProperty pp = DBProtocolPropertiesUtils.getProtocolProperty(id, connection, tipoDatabase, driverBYOK);
        if (pp == null) {
            return null;
        }
        return pp.toRegistry();
    }

    public static org.openspcoop2.core.config.ProtocolProperty getProtocolPropertyConfig(long id, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException, NotFoundException {
        ProtocolProperty pp = DBProtocolPropertiesUtils.getProtocolProperty(id, connection, tipoDatabase, driverBYOK);
        if (pp == null) {
            return null;
        }
        return pp.toConfig();
    }

    public static ProtocolProperty getProtocolProperty(long id, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException, NotFoundException {
        Statement stm = null;
        ResultSet rs = null;
        if (id <= 0L) {
            throw new CoreException("[DBProtocolProperties::getProtocolProperty] id non definito");
        }
        try {
            IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)tipoDatabase);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("protocol_properties");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("name");
            sqlQueryObject.addSelectField("value_string");
            sqlQueryObject.addSelectField("enc_value_string");
            sqlQueryObject.addSelectField("value_number");
            sqlQueryObject.addSelectField("value_boolean");
            sqlQueryObject.addSelectField("value_binary");
            sqlQueryObject.addSelectField("file_name");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            rs = stm.executeQuery();
            ProtocolProperty pp = null;
            if (rs.next()) {
                byte[] binaryValue;
                int value;
                pp = new ProtocolProperty();
                pp.setTipoProprietario(rs.getString("tipo_proprietario"));
                pp.setIdProprietario(rs.getLong("id_proprietario"));
                String ppName = rs.getString("name");
                pp.setName(ppName);
                String plainStringValue = rs.getString("value_string");
                String encStringValue = rs.getString("enc_value_string");
                if (encStringValue != null && StringUtils.isNotEmpty((CharSequence)encStringValue)) {
                    if (driverBYOK != null) {
                        pp.setValue(driverBYOK.unwrapAsString(encStringValue));
                    } else {
                        pp.setValue(encStringValue);
                    }
                } else {
                    pp.setValue(plainStringValue);
                }
                pp.setNumberValue(rs.getLong("value_number"));
                if (rs.wasNull()) {
                    pp.setNumberValue(null);
                }
                pp.setBooleanValue((value = rs.getInt("value_boolean")) == 1);
                if (rs.wasNull()) {
                    pp.setBooleanValue(null);
                }
                if ((binaryValue = jdbcAdapter.getBinaryData(rs, "value_binary")) != null && binaryValue.length > 0 && driverBYOK != null && DBProtocolPropertiesUtils.isConfidentialProtocolProperty(ppName)) {
                    binaryValue = driverBYOK.unwrap(binaryValue);
                }
                pp.setByteFile(binaryValue);
                pp.setFile(rs.getString("file_name"));
                pp.setId(rs.getLong("id"));
            }
            if (pp == null) {
                throw new NotFoundException("ProtocolProperty con id[" + id + "] non trovato");
            }
            ProtocolProperty protocolProperty = pp;
            return protocolProperty;
        }
        catch (SQLException se) {
            throw new CoreException("[DBProtocolProperties::getProtocolProperty] SQLException : " + se.getMessage(), se);
        }
        catch (NotFoundException dnf) {
            throw dnf;
        }
        catch (Exception se) {
            throw new CoreException("[DBProtocolProperties::getProtocolProperty] Exception : " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome, Connection connection, String tipoDatabase) throws CoreException {
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDatabase);
            sqlQueryObject.addFromTable("protocol_properties");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("name = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, proprietarioProtocolProperty.name());
            stm.setLong(2, idProprietario);
            stm.setString(3, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new CoreException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
        return exist;
    }

    public static org.openspcoop2.core.registry.ProtocolProperty getProtocolPropertyRegistry(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException {
        ProtocolProperty pp = DBProtocolPropertiesUtils.getProtocolProperty(proprietarioProtocolProperty, idProprietario, nome, connection, tipoDatabase, driverBYOK);
        if (pp == null) {
            return null;
        }
        return pp.toRegistry();
    }

    public static org.openspcoop2.core.config.ProtocolProperty getProtocolPropertyConfig(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException {
        ProtocolProperty pp = DBProtocolPropertiesUtils.getProtocolProperty(proprietarioProtocolProperty, idProprietario, nome, connection, tipoDatabase, driverBYOK);
        if (pp == null) {
            return null;
        }
        return pp.toConfig();
    }

    public static ProtocolProperty getProtocolProperty(ProprietariProtocolProperty proprietarioProtocolProperty, long idProprietario, String nome, Connection connection, String tipoDatabase, IDriverBYOK driverBYOK) throws CoreException {
        String nomeMetodo = "getProtocolProperty";
        try {
            long idPP = DBUtils.getIdProtocolProperty(proprietarioProtocolProperty.name(), idProprietario, nome, connection, tipoDatabase);
            return DBProtocolPropertiesUtils.getProtocolProperty(idPP, connection, tipoDatabase, driverBYOK);
        }
        catch (Exception se) {
            throw new CoreException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage());
        }
    }

    public static void setProtocolPropertiesForSearch(ISQLQueryObject sqlQueryObject, List<FiltroRicercaProtocolProperty> list, String tabella) throws SQLQueryObjectException {
        if (list != null && !list.isEmpty()) {
            String[] conditions = new String[list.size()];
            for (int i = 0; i < conditions.length; ++i) {
                String aliasTabella = "pp" + i + tabella;
                sqlQueryObject.addFromTable("protocol_properties", aliasTabella);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(aliasTabella + ".tipo_proprietario=?");
                sqlQueryObject.addWhereCondition(aliasTabella + ".id_proprietario=" + tabella + ".id");
                FiltroRicercaProtocolProperty f = list.get(i);
                if (f.getName() != null) {
                    conditions[i] = conditions[i] != null ? conditions[i] + AND_SEPARATOR : "";
                    conditions[i] = conditions[i] + " " + aliasTabella + ".name=?";
                }
                if (f.getValueAsString() != null) {
                    conditions[i] = conditions[i] != null ? conditions[i] + AND_SEPARATOR : "";
                    conditions[i] = conditions[i] + " ";
                    String nomeColonna = aliasTabella + ".value_string";
                    conditions[i] = f.getSearchWithLike() != null ? conditions[i] + sqlQueryObject.getWhereLikeCondition(nomeColonna, f.getValueAsString(), f.getSearchWithLike()) : conditions[i] + nomeColonna + "=?";
                } else if (f.getValueAsLong() != null) {
                    conditions[i] = conditions[i] != null ? conditions[i] + AND_SEPARATOR : "";
                    conditions[i] = conditions[i] + " " + aliasTabella + ".value_number=?";
                } else if (f.getValueAsBoolean() != null) {
                    conditions[i] = conditions[i] != null ? conditions[i] + AND_SEPARATOR : "";
                    conditions[i] = conditions[i] + " " + aliasTabella + ".value_boolean=?";
                } else {
                    conditions[i] = conditions[i] != null ? conditions[i] + AND_SEPARATOR : "";
                    conditions[i] = conditions[i] + " " + aliasTabella + ".value_string is null";
                    conditions[i] = conditions[i] + AND_SEPARATOR;
                    conditions[i] = conditions[i] + " " + aliasTabella + ".value_number is null";
                    conditions[i] = conditions[i] + AND_SEPARATOR;
                    conditions[i] = conditions[i] + " " + aliasTabella + ".value_boolean is null";
                }
                ISQLQueryObject sqlQueryObjectPropertyNotExists = null;
                if (f.getValueAsString() != null || f.getValueAsLong() != null || f.getValueAsBoolean() != null) continue;
                ISQLQueryObject sqlQueryObjectPropertyNotExistsInternal = sqlQueryObject.newSQLQueryObject();
                String aliasTabellaNotExists = "not_exists_" + aliasTabella;
                sqlQueryObjectPropertyNotExistsInternal.addFromTable("protocol_properties", aliasTabellaNotExists);
                sqlQueryObjectPropertyNotExistsInternal.addSelectField(aliasTabellaNotExists, "id");
                sqlQueryObjectPropertyNotExistsInternal.addWhereCondition(aliasTabellaNotExists + ".id_proprietario=" + aliasTabella + ".id_proprietario");
                sqlQueryObjectPropertyNotExistsInternal.addWhereCondition(aliasTabellaNotExists + ".tipo_proprietario=" + aliasTabella + ".tipo_proprietario");
                sqlQueryObjectPropertyNotExistsInternal.addWhereCondition(aliasTabellaNotExists + ".name=?");
                sqlQueryObjectPropertyNotExistsInternal.setANDLogicOperator(true);
                sqlQueryObjectPropertyNotExists = sqlQueryObject.newSQLQueryObject();
                sqlQueryObjectPropertyNotExists.addWhereExistsCondition(true, sqlQueryObjectPropertyNotExistsInternal);
                conditions[i] = "( " + conditions[i] + " ) OR ( " + sqlQueryObjectPropertyNotExists.createSQLConditions() + " )";
            }
            sqlQueryObject.addWhereCondition(true, conditions);
        }
    }

    public static void setProtocolPropertiesForSearch(PreparedStatement stmt, int index, List<FiltroRicercaProtocolProperty> list, ProprietariProtocolProperty proprietario, String tipoDatabase, Logger log) throws SQLException, JDBCAdapterException, UtilsException {
        JDBCParameterUtilities jdbcParameterUtilities = new JDBCParameterUtilities(TipiDatabase.toEnumConstant((String)tipoDatabase));
        if (list != null && !list.isEmpty()) {
            int i;
            for (i = 0; i < list.size(); ++i) {
                DBProtocolPropertiesUtils.logDebug(log, "FiltroRicercaProtocolProperty size:" + list.size() + " [" + i + "] Proprietario stmt.setString(" + proprietario.name() + ")");
                stmt.setString(index++, proprietario.name());
            }
            for (i = 0; i < list.size(); ++i) {
                String prefix = "FiltroRicercaProtocolProperty[" + i + "] ";
                FiltroRicercaProtocolProperty f = list.get(i);
                if (f.getName() != null) {
                    DBProtocolPropertiesUtils.logDebug(log, prefix + "Name stmt.setString(" + f.getName() + ")");
                    stmt.setString(index++, f.getName());
                }
                if (f.getValueAsString() != null) {
                    if (f.getSearchWithLike() == null) {
                        DBProtocolPropertiesUtils.logDebug(log, prefix + "ValueAsString stmt.setString(" + f.getValueAsString() + ")");
                        jdbcParameterUtilities.setParameter(stmt, index++, (Object)f.getValueAsString(), String.class);
                    }
                } else if (f.getValueAsLong() != null) {
                    DBProtocolPropertiesUtils.logDebug(log, prefix + "ValueAsLong stmt.setLong(" + f.getValueAsLong() + ")");
                    jdbcParameterUtilities.setParameter(stmt, index++, (Object)f.getValueAsLong(), Long.class);
                } else if (f.getValueAsBoolean() != null) {
                    int value = f.getValueAsBoolean() != null && f.getValueAsBoolean() != false ? 1 : 0;
                    DBProtocolPropertiesUtils.logDebug(log, prefix + "ValueAsBoolean stmt.setInt(" + value + ")");
                    jdbcParameterUtilities.setParameter(stmt, index++, (Object)value, Integer.class);
                }
                if (f.getValueAsString() != null || f.getValueAsLong() != null || f.getValueAsBoolean() != null) continue;
                DBProtocolPropertiesUtils.logDebug(log, prefix + "Name stmt.setString(" + f.getName() + ")");
                stmt.setString(index++, f.getName());
            }
        }
    }
}

