/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.mvc.properties.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.mvc.properties.Compatibility;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.Tags;
import org.openspcoop2.core.mvc.properties.utils.PropertiesSourceConfiguration;
import org.openspcoop2.core.mvc.properties.utils.XSDValidator;
import org.openspcoop2.core.mvc.properties.utils.serializer.JaxbDeserializer;
import org.openspcoop2.generic_project.exception.DeserializerException;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.slf4j.Logger;

public class ConfigManager {
    private static ConfigManager instance = null;
    private Logger log = null;
    private Map<String, Map<String, Config>> mapConfigBuildIn = null;
    private Map<String, Map<String, Config>> mapConfigFileSystem = null;
    private Map<String, Map<String, Config>> mapConfig = null;
    private AbstractValidatoreXSD validator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigManager getinstance(Logger log) throws CoreException {
        if (instance != null) return instance;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            ConfigManager.init(log);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static synchronized void init(Logger log) throws CoreException {
        instance = new ConfigManager(log);
    }

    private ConfigManager(Logger log) throws CoreException {
        this.log = log;
        this.mapConfigBuildIn = new HashMap<String, Map<String, Config>>();
        this.mapConfigFileSystem = new HashMap<String, Map<String, Config>>();
        this.mapConfig = new HashMap<String, Map<String, Config>>();
        try {
            this.validator = XSDValidator.getXSDValidator(log);
        }
        catch (Exception e) {
            this.doError("Errore durante la init del ManagerConfigurazioni", e);
        }
    }

    private void doError(String msg, Exception e) throws CoreException {
        String msgError = msg + ": " + e.getMessage();
        this.log.error(msgError, (Throwable)e);
        throw new CoreException(e.getMessage(), e);
    }

    public void leggiConfigurazioni(PropertiesSourceConfiguration propertiesSourceConfiguration, boolean validazioneXSD) throws CoreException, DeserializerException {
        HashMap<String, Config> mapConfigFromDir;
        if (!this.mapConfigBuildIn.containsKey(propertiesSourceConfiguration.getId()) || propertiesSourceConfiguration.isUpdateBuiltIn()) {
            if (this.mapConfigBuildIn.containsKey(propertiesSourceConfiguration.getId())) {
                this.mapConfigBuildIn.remove(propertiesSourceConfiguration.getId());
            }
            mapConfigFromDir = null;
            List<byte[]> builtIn = propertiesSourceConfiguration.getBuiltIn();
            if (builtIn != null && !builtIn.isEmpty()) {
                mapConfigFromDir = new HashMap<String, Config>();
                JaxbDeserializer xmlReader = new JaxbDeserializer();
                for (int i = 0; i < builtIn.size(); ++i) {
                    Config configDaFile;
                    String id;
                    byte[] f = builtIn.get(i);
                    if (validazioneXSD) {
                        try {
                            this.validator.valida((InputStream)new ByteArrayInputStream(f));
                        }
                        catch (Exception e) {
                            this.doError("La configurazione builtIn numero [" + (i + 1) + "] non e' valida", e);
                        }
                    }
                    if (mapConfigFromDir.containsKey(id = (configDaFile = xmlReader.readConfig(f)).getId())) {
                        throw new CoreException("La configurazione builtIn con id '" + id + "' risulta duplicata all'interno di quelle precaricate nel sistema.");
                    }
                    mapConfigFromDir.put(id, configDaFile);
                }
                this.mapConfigBuildIn.put(propertiesSourceConfiguration.getId(), mapConfigFromDir);
            }
        }
        if (propertiesSourceConfiguration.getDirectory() != null && (!this.mapConfigFileSystem.containsKey(propertiesSourceConfiguration.getId()) || propertiesSourceConfiguration.isUpdate())) {
            if (this.mapConfigFileSystem.containsKey(propertiesSourceConfiguration.getId())) {
                this.mapConfigFileSystem.remove(propertiesSourceConfiguration.getId());
            }
            mapConfigFromDir = null;
            File dir = new File(propertiesSourceConfiguration.getDirectory());
            if (!dir.exists()) {
                throw new CoreException("Il path indicato [" + propertiesSourceConfiguration.getDirectory() + "] non esiste, impossibile leggere le configurazioni");
            }
            if (!dir.isDirectory()) {
                throw new CoreException("Il path indicato [" + propertiesSourceConfiguration.getDirectory() + "] non e' una directory");
            }
            String[] fileList = dir.list();
            if (fileList != null && fileList.length > 0) {
                mapConfigFromDir = new HashMap();
                JaxbDeserializer xmlReader = new JaxbDeserializer();
                for (Object object : fileList) {
                    Config configDaFile;
                    String id;
                    File fileConfig = new File(dir.getPath() + File.separator + (String)object);
                    if (fileConfig.isDirectory()) continue;
                    if (validazioneXSD) {
                        try {
                            this.validator.valida(fileConfig);
                        }
                        catch (Exception e) {
                            this.doError("La configurazione [" + fileConfig.getName() + "] non e' valida", e);
                        }
                    }
                    if (mapConfigFromDir.containsKey(id = (configDaFile = xmlReader.readConfig(fileConfig)).getId())) {
                        throw new CoreException("La configurazione con id '" + id + "' risulta duplicata all'interno del path indicato [" + propertiesSourceConfiguration.getDirectory() + "].");
                    }
                    mapConfigFromDir.put(id, configDaFile);
                }
                this.mapConfigFileSystem.put(propertiesSourceConfiguration.getId(), mapConfigFromDir);
            }
        }
        if (!this.mapConfig.containsKey(propertiesSourceConfiguration.getId()) || propertiesSourceConfiguration.isUpdateBuiltIn() || propertiesSourceConfiguration.isUpdate()) {
            if (this.mapConfig.containsKey(propertiesSourceConfiguration.getId())) {
                this.mapConfig.remove(propertiesSourceConfiguration.getId());
            }
            Map<String, Config> mapBuiltIn = this.mapConfigBuildIn.get(propertiesSourceConfiguration.getId());
            Map<String, Config> mapFileSystem = this.mapConfigFileSystem.get(propertiesSourceConfiguration.getId());
            if (mapBuiltIn != null && mapBuiltIn.size() > 0 && mapFileSystem != null && mapFileSystem.size() > 0) {
                for (String keyBuiltIn : mapBuiltIn.keySet()) {
                    if (!mapFileSystem.keySet().contains(keyBuiltIn)) continue;
                    throw new CoreException("La configurazione con id '" + keyBuiltIn + "' risulta duplicata, e' presente sia come configurazione builtIn che come configurazione esterna, eliminare una delle due.");
                }
            }
            HashMap<String, Config> map = new HashMap<String, Config>();
            if (mapBuiltIn != null && mapBuiltIn.size() > 0) {
                map.putAll(mapBuiltIn);
            }
            if (mapFileSystem != null && mapFileSystem.size() > 0) {
                map.putAll(mapFileSystem);
            }
            this.mapConfig.put(propertiesSourceConfiguration.getId(), map);
        }
    }

    public List<String> getNomiConfigurazioni(PropertiesSourceConfiguration propertiesSourceConfiguration, String ... tags) {
        List<String> l;
        ArrayList<String> mapSortedKeys = new ArrayList<String>();
        HashMap mapSorted = new HashMap();
        Map<String, Config> map = this.mapConfig.get(propertiesSourceConfiguration.getId());
        for (String id : map.keySet()) {
            Compatibility compatibility;
            Config config = map.get(id);
            if (tags != null && tags.length > 0 && !this.checkCompatibility(compatibility = config.getCompatibility(), Arrays.asList(tags))) continue;
            String labelId = config.getLabel();
            if (config.getSortLabel() != null) {
                labelId = config.getSortLabel();
            }
            l = null;
            if (mapSorted.containsKey(labelId)) {
                l = (List)mapSorted.get(labelId);
            } else {
                l = new ArrayList();
                mapSorted.put(labelId, l);
                mapSortedKeys.add(labelId);
            }
            l.add(id);
        }
        Collections.sort(mapSortedKeys);
        ArrayList<String> list = new ArrayList<String>();
        for (String labelId : mapSortedKeys) {
            l = (ArrayList)mapSorted.get(labelId);
            list.addAll((Collection<String>)l);
        }
        return list;
    }

    public List<String> convertToLabel(PropertiesSourceConfiguration propertiesSourceConfiguration, List<String> idList) {
        Map<String, Config> map = this.mapConfig.get(propertiesSourceConfiguration.getId());
        ArrayList<String> listLabels = new ArrayList<String>();
        for (String id : idList) {
            Config config = map.get(id);
            if (config != null) {
                String labelId = config.getLabel();
                listLabels.add(labelId);
                continue;
            }
            listLabels.add("Label non presente (id:" + id + ")");
        }
        return listLabels;
    }

    public Config getConfigurazione(PropertiesSourceConfiguration propertiesSourceConfiguration, String name) {
        return this.mapConfig.get(propertiesSourceConfiguration.getId()).get(name);
    }

    public boolean checkCompatibility(Compatibility compatibility, List<String> tags) {
        if (compatibility == null) {
            return true;
        }
        boolean isAnd = compatibility.getAnd();
        boolean isNot = compatibility.getNot();
        boolean esito = isAnd;
        for (Tags tag : compatibility.getTagsList()) {
            boolean resCondition = this.checkTags(tag, tags);
            esito = isAnd ? esito && resCondition : esito || resCondition;
        }
        return isNot ? !esito : esito;
    }

    private boolean checkTags(Tags tag, List<String> tags) {
        boolean isAnd = tag.getAnd();
        boolean isNot = tag.getNot();
        boolean esito = isAnd;
        for (String stringTag : tag.getTagList()) {
            boolean resCondition = tags.contains(stringTag);
            esito = isAnd ? esito && resCondition : esito || resCondition;
        }
        return isNot ? !esito : esito;
    }
}

