/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.plugins.utils.handlers;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.dao.jdbc.converter.PluginFieldConverter;
import org.openspcoop2.core.plugins.utils.PluginsDriverUtils;
import org.openspcoop2.core.plugins.utils.handlers.ConfigurazioneHandlerBean;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class HandlersDriverUtils {
    public static int numeroHandlerList(String tipologia, TipoPdD ruoloPorta, Long idPorta, TipoPlugin tipoPlugin, String nomeMetodo, Connection con, Logger log, String tipoDB) throws ServiceException {
        String tabella = "config_handlers";
        if (ruoloPorta != null) {
            if (ruoloPorta.equals(TipoPdD.DELEGATA)) {
                tabella = "pd_handlers";
            } else if (ruoloPorta.equals(TipoPdD.APPLICATIVA)) {
                tabella = "pa_handlers";
            }
        }
        Statement stmt = null;
        ResultSet risultato = null;
        try {
            PluginFieldConverter converter = new PluginFieldConverter(tipoDB);
            String tabellaPlugin = converter.toTable((IModel)Plugin.model());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addFromTable(tabellaPlugin);
            sqlQueryObject.addSelectCountField(tabella + ".id", "cont");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo=" + tabella + ".tipo");
            if (idPorta != null) {
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=?");
            }
            sqlQueryObject.addWhereCondition(tabella + ".tipologia=?");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo_plugin=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (idPorta != null) {
                stmt.setLong(index++, idPorta);
            }
            stmt.setString(index++, tipologia);
            stmt.setString(index++, tipoPlugin.getValue());
            risultato = stmt.executeQuery();
            int res = 0;
            if (risultato.next()) {
                res = risultato.getInt(1);
            }
            risultato.close();
            stmt.close();
            int n = res;
            return n;
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static List<ConfigurazioneHandlerBean> handlerList(ISearch ricerca, String tipologia, TipoPdD ruoloPorta, Long idPorta, String nomeMetodo, int idLista, TipoPlugin tipoPlugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String tabella = "config_handlers";
        if (ruoloPorta != null) {
            if (ruoloPorta.equals(TipoPdD.DELEGATA)) {
                tabella = "pd_handlers";
            } else if (ruoloPorta.equals(TipoPdD.APPLICATIVA)) {
                tabella = "pa_handlers";
            }
        }
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ConfigurazioneHandlerBean> lista = new ArrayList<ConfigurazioneHandlerBean>();
        try {
            PluginFieldConverter converter = new PluginFieldConverter(tipoDB);
            String tabellaPlugin = converter.toTable((IModel)Plugin.model());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addFromTable(tabellaPlugin);
            sqlQueryObject.addSelectCountField(tabella + ".id", "cont");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo=" + tabella + ".tipo");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition(tabellaPlugin + ".label", search, true, true);
            }
            if (idPorta != null) {
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=?");
            }
            sqlQueryObject.addWhereCondition(tabella + ".tipologia=?");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo_plugin=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (idPorta != null) {
                stmt.setLong(index++, idPorta);
            }
            stmt.setString(index++, tipologia);
            stmt.setString(index++, tipoPlugin.getValue());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addFromTable(tabellaPlugin);
            sqlQueryObject.addSelectAliasField(tabella, "id", "IdHandler");
            sqlQueryObject.addSelectField(tabella, "tipologia");
            String aliasTIPO = "tipoTabConf";
            sqlQueryObject.addSelectAliasField(tabella, "tipo", aliasTIPO);
            sqlQueryObject.addSelectField(tabella, "posizione");
            sqlQueryObject.addSelectField(tabella, "stato");
            if (idPorta != null) {
                sqlQueryObject.addSelectField(tabella, "id_porta");
            }
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo=" + tabella + ".tipo");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition(tabellaPlugin + ".label", search, true, true);
            }
            if (idPorta != null) {
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=?");
            }
            sqlQueryObject.addWhereCondition(tabella + ".tipologia=?");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo_plugin=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(tabella + ".posizione");
            sqlQueryObject.addOrderBy(aliasTIPO);
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (idPorta != null) {
                stmt.setLong(index++, idPorta);
            }
            stmt.setString(index++, tipologia);
            stmt.setString(index++, tipoPlugin.getValue());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ConfigurazioneHandler handler = new ConfigurazioneHandler();
                handler.setId(risultato.getLong("IdHandler"));
                handler.setPosizione(risultato.getInt("posizione"));
                handler.setStato(HandlersDriverUtils.getEnumStatoFunzionalita(risultato.getString("stato")));
                handler.setTipo(risultato.getString(aliasTIPO));
                Plugin plugin = PluginsDriverUtils.getPlugin(tipoPlugin.getValue(), handler.getTipo(), true, con, log, tipoDB);
                ConfigurazioneHandlerBean bean = new ConfigurazioneHandlerBean(handler, plugin);
                lista.add(bean);
            }
            risultato.close();
            stmt.close();
            ArrayList<ConfigurazioneHandlerBean> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int getMaxPosizioneHandlers(String tipologia, TipoPdD ruoloPorta, Long idPorta, String nomeMetodo, TipoPlugin tipoPlugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String tabella = "config_handlers";
        if (ruoloPorta != null) {
            if (ruoloPorta.equals(TipoPdD.DELEGATA)) {
                tabella = "pd_handlers";
            } else if (ruoloPorta.equals(TipoPdD.APPLICATIVA)) {
                tabella = "pa_handlers";
            }
        }
        Statement stmt = null;
        ResultSet risultato = null;
        int posizione = 0;
        try {
            PluginFieldConverter converter = new PluginFieldConverter(tipoDB);
            String tabellaPlugin = converter.toTable((IModel)Plugin.model());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addFromTable(tabellaPlugin);
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo=" + tabella + ".tipo");
            sqlQueryObject.addSelectMaxField(tabella + ".posizione", "posizione");
            if (idPorta != null) {
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=?");
            }
            sqlQueryObject.addWhereCondition(tabella + ".tipologia=?");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo_plugin=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (idPorta != null) {
                stmt.setLong(index++, idPorta);
            }
            stmt.setString(index++, tipologia);
            stmt.setString(index++, tipoPlugin.getValue());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                posizione = risultato.getInt("posizione");
            }
            risultato.close();
            stmt.close();
            int n = posizione;
            return n;
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsHandler(String tipologia, TipoPdD ruoloPorta, Long idPorta, String nomeMetodo, TipoPlugin tipoPlugin, String tipo, Connection con, Logger log, String tipoDB) throws ServiceException {
        String tabella = "config_handlers";
        if (ruoloPorta != null) {
            if (ruoloPorta.equals(TipoPdD.DELEGATA)) {
                tabella = "pd_handlers";
            } else if (ruoloPorta.equals(TipoPdD.APPLICATIVA)) {
                tabella = "pa_handlers";
            }
        }
        Statement stmt = null;
        ResultSet risultato = null;
        boolean exists = false;
        try {
            PluginFieldConverter converter = new PluginFieldConverter(tipoDB);
            String tabellaPlugin = converter.toTable((IModel)Plugin.model());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addFromTable(tabellaPlugin);
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo=" + tabella + ".tipo");
            sqlQueryObject.addSelectCountField(tabella + ".id", "cont");
            if (idPorta != null) {
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=?");
            }
            sqlQueryObject.addWhereCondition(tabella + ".tipologia=?");
            sqlQueryObject.addWhereCondition(tabella + ".tipo=?");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo_plugin=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (idPorta != null) {
                stmt.setLong(index++, idPorta);
            }
            stmt.setString(index++, tipologia);
            stmt.setString(index++, tipo);
            stmt.setString(index++, tipoPlugin.getValue());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                exists = risultato.getInt(1) > 0;
            }
            risultato.close();
            stmt.close();
            boolean bl = exists;
            return bl;
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static ConfigurazioneHandlerBean getHandler(String tipologia, TipoPdD ruoloPorta, Long idPorta, Long idHandler, String nomeMetodo, TipoPlugin tipoPlugin, Connection con, Logger log, String tipoDB) throws ServiceException {
        String tabella = "config_handlers";
        if (ruoloPorta != null) {
            if (ruoloPorta.equals(TipoPdD.DELEGATA)) {
                tabella = "pd_handlers";
            } else if (ruoloPorta.equals(TipoPdD.APPLICATIVA)) {
                tabella = "pa_handlers";
            }
        }
        Statement stmt = null;
        ResultSet risultato = null;
        ConfigurazioneHandlerBean bean = null;
        try {
            PluginFieldConverter converter = new PluginFieldConverter(tipoDB);
            String tabellaPlugin = converter.toTable((IModel)Plugin.model());
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable(tabella);
            sqlQueryObject.addFromTable(tabellaPlugin);
            sqlQueryObject.addSelectField(tabella + ".id");
            sqlQueryObject.addSelectField(tabella + ".tipologia");
            sqlQueryObject.addSelectField(tabella + ".tipo");
            sqlQueryObject.addSelectField(tabella + ".posizione");
            sqlQueryObject.addSelectField(tabella + ".stato");
            if (idPorta != null) {
                sqlQueryObject.addSelectField(tabella + ".id_porta");
            }
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo=" + tabella + ".tipo");
            sqlQueryObject.addWhereCondition(tabella + ".id=?");
            if (idPorta != null) {
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=?");
            }
            sqlQueryObject.addWhereCondition(tabella + ".tipologia=?");
            sqlQueryObject.addWhereCondition(tabellaPlugin + ".tipo_plugin=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idHandler);
            if (idPorta != null) {
                stmt.setLong(index++, idPorta);
            }
            stmt.setString(index++, tipologia);
            stmt.setString(index++, tipoPlugin.getValue());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ConfigurazioneHandler handler = new ConfigurazioneHandler();
                handler.setId(risultato.getLong("id"));
                handler.setPosizione(risultato.getInt("posizione"));
                handler.setStato(HandlersDriverUtils.getEnumStatoFunzionalita(risultato.getString("stato")));
                handler.setTipo(risultato.getString("tipo"));
                Plugin plugin = PluginsDriverUtils.getPlugin(tipoPlugin.getValue(), handler.getTipo(), true, con, log, tipoDB);
                bean = new ConfigurazioneHandlerBean(handler, plugin);
            }
            risultato.close();
            stmt.close();
            ConfigurazioneHandlerBean configurazioneHandlerBean = bean;
            return configurazioneHandlerBean;
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static StatoFunzionalita getEnumStatoFunzionalita(String value) {
        if (value == null) {
            return null;
        }
        return StatoFunzionalita.toEnumConstant(value);
    }
}

