/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoCooperazionePartecipanti;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioComposto;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.ConfigurazioneServizio;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Message;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.BindingStyle;
import org.openspcoop2.core.registry.constants.BindingUse;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.constants.TipiDocumentoCoordinamento;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class ValidazioneSemantica {
    private RegistroServizi registro = null;
    private List<String> errori = new ArrayList<String>();
    private Logger log = null;
    private boolean checkEsistenzaFileDefinitoTramiteURI = false;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private IDServizioFactory idServizioFactory = IDServizioFactory.getInstance();
    private List<String> tipoConnettori = new ArrayList<String>();
    private List<String> tipoSoggetti = new ArrayList<String>();
    private List<String> tipoServiziSoap = new ArrayList<String>();
    private List<String> tipoServiziRest = new ArrayList<String>();
    private Map<String, ServiceBinding> mappingAccordiToServiceBinding;

    private String getTipoConnettori() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoConnettori.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoConnettori.get(i));
        }
        return bf.toString();
    }

    private String getTipoSoggetti() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoSoggetti.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoSoggetti.get(i));
        }
        return bf.toString();
    }

    private String getTipoServiziSoap() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoServiziSoap.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServiziSoap.get(i));
        }
        return bf.toString();
    }

    private String getTipoServiziRest() {
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < this.tipoServiziRest.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServiziRest.get(i));
        }
        return bf.toString();
    }

    public ValidazioneSemantica(RegistroServizi registro, boolean checkEsistenzaFileDefinitoTramiteURI, String[] tipoConnettori, String[] tipoSoggetti, String[] tipiServiziSoapValidi, String[] tipiServiziRestValidi, Logger log) throws DriverRegistroServiziException {
        int i;
        this.registro = registro;
        this.checkEsistenzaFileDefinitoTramiteURI = checkEsistenzaFileDefinitoTramiteURI;
        this.log = log;
        if (tipoConnettori != null && tipoConnettori.length > 0) {
            for (i = 0; i < tipoConnettori.length; ++i) {
                this.tipoConnettori.add(tipoConnettori[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di connettori ammissibili non definiti");
        }
        if (tipoSoggetti != null && tipoSoggetti.length > 0) {
            for (i = 0; i < tipoSoggetti.length; ++i) {
                this.tipoSoggetti.add(tipoSoggetti[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di soggetti ammissibili non definiti");
        }
        boolean tipiSoapNonEsistenti = false;
        if (tipiServiziSoapValidi != null && tipiServiziSoapValidi.length > 0) {
            for (int i2 = 0; i2 < tipiServiziSoapValidi.length; ++i2) {
                this.tipoServiziSoap.add(tipiServiziSoapValidi[i2]);
            }
        } else {
            tipiSoapNonEsistenti = true;
        }
        boolean tipiRestNonEsistenti = false;
        if (tipiServiziRestValidi != null && tipiServiziRestValidi.length > 0) {
            for (int i3 = 0; i3 < tipiServiziRestValidi.length; ++i3) {
                this.tipoServiziRest.add(tipiServiziRestValidi[i3]);
            }
        } else {
            tipiRestNonEsistenti = true;
        }
        if (tipiSoapNonEsistenti && tipiRestNonEsistenti) {
            throw new DriverRegistroServiziException("Almeno dei tipo di servizi Soap o Rest ammissibili devono essere definiti");
        }
    }

    public ValidazioneSemantica(RegistroServizi registro, boolean checkEsistenzaFileDefinitoTramiteURI, String[] tipoConnettori, String[] tipoSoggetti, String[] tipiServiziSoapValidi, String[] tipiServiziRestValidi) throws DriverRegistroServiziException {
        this(registro, checkEsistenzaFileDefinitoTramiteURI, tipoConnettori, tipoSoggetti, tipiServiziSoapValidi, tipiServiziRestValidi, null);
    }

    private void printMsg(String msg) {
        if (this.log == null) {
            System.out.println(msg);
        } else {
            this.log.debug(msg);
        }
    }

    public void validazioneSemantica(boolean showIDOggettiAnalizzati) throws DriverRegistroServiziException {
        int i;
        if (showIDOggettiAnalizzati) {
            this.printMsg("---------------------------------------AccordiCooperazione(" + this.registro.sizeAccordoCooperazioneList() + ")--------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Accordo di cooperazione: " + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac));
            }
            this.validaAccordoCooperazione(ac);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------AccordiServizioParteComune(" + this.registro.sizeAccordoServizioParteComuneList() + ")-----------------------------------------------------");
        }
        this.mappingAccordiToServiceBinding = new HashMap<String, ServiceBinding>();
        for (i = 0; i < this.registro.sizeAccordoServizioParteComuneList(); ++i) {
            AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Accordo di servizio parte comune: " + this.idAccordoFactory.getUriFromAccordo(as));
            }
            this.validaAccordoServizioParteComune(as);
            this.mappingAccordiToServiceBinding.put(this.idAccordoFactory.getUriFromAccordo(as), as.getServiceBinding());
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Soggetti(" + this.registro.sizeSoggettoList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeSoggettoList(); ++i) {
            Soggetto sogg = this.registro.getSoggetto(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Soggetto: " + sogg.getTipo() + "/" + sogg.getNome());
            }
            this.validaSoggetto(sogg, showIDOggettiAnalizzati);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Porte di Dominio(" + this.registro.sizePortaDominioList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizePortaDominioList(); ++i) {
            PortaDominio pd = this.registro.getPortaDominio(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Porta di dominio: " + pd.getNome());
            }
            this.validaPortaDominio(pd);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Ruoli(" + this.registro.sizeRuoloList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeRuoloList(); ++i) {
            Ruolo ruolo = this.registro.getRuolo(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Ruolo: " + ruolo.getNome());
            }
            this.validaRuolo(ruolo);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Scope(" + this.registro.sizeScopeList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeScopeList(); ++i) {
            Scope scope = this.registro.getScope(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Scope: " + scope.getNome());
            }
            this.validaScope(scope);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Connettori(" + this.registro.sizeConnettoreList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeConnettoreList(); ++i) {
            Connettore con = this.registro.getConnettore(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Connettore: " + con.getNome());
            }
            this.validaConnettore(con, null, null);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n-----------------------------------------------------------------------------------------");
        }
        if (!this.errori.isEmpty()) {
            StringBuilder stringB = new StringBuilder().append("\n");
            Iterator<String> itE = this.errori.iterator();
            while (itE.hasNext()) {
                stringB.append(itE.next()).append("\n");
            }
            throw new DriverRegistroServiziException(stringB.toString());
        }
    }

    private void validaAccordoCooperazione(AccordoCooperazione ac) throws DriverRegistroServiziException {
        int i;
        if (ac.getNome() == null) {
            this.errori.add("Esiste un accordo di cooperazione senza nome");
            return;
        }
        IDAccordoCooperazione idAccordoCooperazione = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac);
        String uriAC = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoCooperazione);
        IdSoggetto acsr = ac.getSoggettoReferente();
        if (acsr != null) {
            if (acsr.getTipo() == null) {
                this.errori.add("Tipo di un soggetto referente dell'accordo cooperazione " + uriAC + " non definito");
            } else if (acsr.getNome() == null) {
                this.errori.add("Nome di un soggetto referente dell'accordo cooperazione " + uriAC + " non definito");
            } else if (!this.existsSoggetto(acsr.getTipo(), acsr.getNome())) {
                this.errori.add("Il soggetto referente [" + acsr.getTipo() + "/" + acsr.getNome() + "] dell'accordo cooperazione " + uriAC + " non corrisponde a nessuno dei soggetti registrati");
            }
        }
        if (ac.getElencoPartecipanti() != null) {
            AccordoCooperazionePartecipanti partecipanti = ac.getElencoPartecipanti();
            for (int i2 = 0; i2 < partecipanti.sizeSoggettoPartecipanteList(); ++i2) {
                IdSoggetto partecipante = partecipanti.getSoggettoPartecipante(i2);
                if (partecipante.getTipo() == null) {
                    this.errori.add("Tipo di un soggetto partecipante dell'accordo cooperazione " + uriAC + " non definito");
                    continue;
                }
                if (partecipante.getNome() == null) {
                    this.errori.add("Nome di un soggetto partecipante dell'accordo cooperazione " + uriAC + " non definito");
                    continue;
                }
                if (this.existsSoggetto(partecipante.getTipo(), partecipante.getNome())) continue;
                this.errori.add("Il soggetto partecipante [" + partecipante.getTipo() + "/" + partecipante.getNome() + "] dell'accordo cooperazione " + uriAC + " non corrisponde a nessuno dei soggetti registrati");
            }
            if (partecipanti.sizeSoggettoPartecipanteList() < 2) {
                this.errori.add("L'accordo di cooperazione [" + uriAC + "] non possiede il numero minimo di soggetti partecipanti (2)");
            }
        } else {
            this.errori.add("L'accordo di cooperazione [" + uriAC + "] non possiede soggetti partecipanti (attesi almeno 2)");
        }
        for (i = 0; i < ac.sizeAllegatoList(); ++i) {
            Documento allegato = ac.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, "accordoCooperazione[" + uriAC + "]");
        }
        for (i = 0; i < ac.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = ac.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, "accordoCooperazione[" + uriAC + "]");
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)ac.getNome(), (String)"^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome dell'accordo di cooperazione [" + uriAC + "] dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'accordo di cooperazione [" + uriAC + "]: " + e.getMessage(), e);
        }
        int numAc = 0;
        for (int j = 0; j < this.registro.sizeAccordoCooperazioneList(); ++j) {
            AccordoCooperazione tmpAc = this.registro.getAccordoCooperazione(j);
            if (!this.idAccordoCooperazioneFactory.getUriFromAccordo(ac).equals(this.idAccordoCooperazioneFactory.getUriFromAccordo(tmpAc))) continue;
            ++numAc;
        }
        if (numAc > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un accordo di cooperazione con uri " + uriAC);
        }
    }

    private void validaAccordoServizioParteComune(AccordoServizioParteComune as) throws DriverRegistroServiziException {
        StatoFunzionalita consOrd;
        StatoFunzionalita idColl;
        StatoFunzionalita confRic;
        StatoFunzionalita consOrd2;
        StatoFunzionalita idColl2;
        StatoFunzionalita confRic2;
        StatoFunzionalita filtroDup;
        ProfiloCollaborazione profColl;
        int i;
        int j;
        if (as.getNome() == null) {
            this.errori.add("Esiste un accordo di servizio senza nome");
            return;
        }
        IDAccordo idAccordoServizio = this.idAccordoFactory.getIDAccordoFromAccordo(as);
        Object uriAS = this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizio);
        AccordoServizioParteComuneServizioComposto assc = as.getServizioComposto();
        uriAS = assc != null ? "servizio composto [" + (String)uriAS + "]" : "accordo di servizio [" + (String)uriAS + "]";
        IdSoggetto assr = as.getSoggettoReferente();
        if (assr != null) {
            if (assr.getTipo() == null) {
                this.errori.add("Tipo di un soggetto referente nel " + (String)uriAS + " non definito");
            } else if (assr.getNome() == null) {
                this.errori.add("Nome di un soggetto referente nel " + (String)uriAS + " non definito");
            } else if (!this.existsSoggetto(assr.getTipo(), assr.getNome())) {
                this.errori.add("Il soggetto referente [" + assr.getTipo() + "/" + assr.getNome() + "] nel " + (String)uriAS + " non corrisponde a nessuno dei soggetti registrati");
            }
        }
        if (assc != null) {
            for (j = 0; j < assc.sizeServizioComponenteList(); ++j) {
                AccordoServizioParteComuneServizioCompostoServizioComponente asscsc = assc.getServizioComponente(j);
                if (asscsc.getTipo() == null) {
                    this.errori.add("Tipo di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (asscsc.getNome() == null) {
                    this.errori.add("Nome di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (asscsc.getVersione() == null) {
                    this.errori.add("Versione di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (asscsc.getTipoSoggetto() == null) {
                    this.errori.add("Tipo dell'erogatore di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (asscsc.getNomeSoggetto() == null) {
                    this.errori.add("Nome dell'erogatore di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (!this.existsAccordoServizioParteSpecifica(asscsc.getTipo(), asscsc.getNome(), asscsc.getVersione(), asscsc.getTipoSoggetto(), asscsc.getNomeSoggetto())) {
                    this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + ":" + asscsc.getVersione() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", non corrisponde a nessun servizio registrato");
                }
                if (asscsc.getAzione() == null) continue;
                AccordoServizioParteSpecifica serv = this.getAccordoServizioParteSpecifica(asscsc.getTipo(), asscsc.getNome(), asscsc.getVersione(), asscsc.getTipoSoggetto(), asscsc.getNomeSoggetto());
                if (serv != null && this.existsAccordoServizioParteComune(serv.getAccordoServizioParteComune())) {
                    AccordoServizioParteComune asServizioComposto = this.getAccordoServizioParteComune(serv.getAccordoServizioParteComune());
                    if (serv.getPortType() != null) {
                        if (this.existsPortType_AccordoServizioParteComune(asServizioComposto, serv.getPortType())) {
                            PortType pt = this.getPortType_AccordoServizioParteComune(asServizioComposto, serv.getPortType());
                            if (this.existsAzione_PortType_AccordoServizio(pt, asscsc.getAzione())) continue;
                            this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", utilizza un'azione [" + asscsc.getAzione() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizioParteComune() + "] implementato dal servizio componente (istanziato per il servizio [" + serv.getPortType() + "])");
                            continue;
                        }
                        this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", implementa un accordo di servizio [" + serv.getAccordoServizioParteComune() + "] che e' istanziato per uno specifico servizio [" + serv.getPortType() + "] che non risulta registrato");
                        continue;
                    }
                    if (this.existsAzione_AccordoServizioParteComune(asServizioComposto, asscsc.getAzione()) || this.existsResource_AccordoServizioParteComune(asServizioComposto, asscsc.getAzione())) continue;
                    this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", utilizza un'azione [" + asscsc.getAzione() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizioParteComune() + "] implementato dal servizio componente");
                    continue;
                }
                if (serv == null) {
                    this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + " non risulta registrato");
                    continue;
                }
                this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", implementa un accordo di servizio [" + serv.getAccordoServizioParteComune() + "] che non risulta registrato");
            }
            for (i = 0; i < assc.sizeSpecificaCoordinamentoList(); ++i) {
                Documento specificaCoordinamento = assc.getSpecificaCoordinamento(i);
                this.validateDocumento(specificaCoordinamento, RuoliDocumento.specificaCoordinamento, (String)uriAS);
            }
            if (assc.getAccordoCooperazione() == null) {
                this.errori.add("Nome dell'accordo di cooperazione implementato nel " + (String)uriAS + " non definito");
            } else if (!this.existsAccordoCooperazione(assc.getAccordoCooperazione())) {
                this.errori.add("L'accordo di cooperazione [" + assc.getAccordoCooperazione() + "] referenziato nel " + (String)uriAS + " non corrisponde a nessuno degli accordi di cooperazione registrati");
            }
        }
        for (j = 0; j < as.sizeAzioneList(); ++j) {
            String correlata;
            Azione az = as.getAzione(j);
            if (az.getNome() == null) {
                this.errori.add("Non \u00e8 stato definito il nome di un'azione nel " + (String)uriAS);
                continue;
            }
            try {
                if (!RegularExpressionEngine.isMatch((String)az.getNome(), (String)"^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                    this.errori.add("Il nome dell'azione [" + az.getNome() + "] nel " + (String)uriAS + " non e' valido; puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'azione [" + az.getNome() + "] nel " + (String)uriAS + " :" + e.getMessage(), e);
            }
            int numAz = 0;
            for (int k = 0; k < as.sizeAzioneList(); ++k) {
                Azione tmpAz = as.getAzione(k);
                if (!az.getNome().equals(tmpAz.getNome())) continue;
                ++numAz;
            }
            if (numAz > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + az.getNome() + " nel " + (String)uriAS);
            }
            if ((correlata = az.getCorrelata()) != null && !this.existsAzione_AccordoServizioParteComune(as, correlata)) {
                this.errori.add("L'azione [" + correlata + "] correlata all'azione " + az.getNome() + " nel " + (String)uriAS + " non corrisponde a nessuna delle azioni registrate");
            }
            if (!((profColl = az.getProfiloCollaborazione()) == null || profColl.equals(CostantiRegistroServizi.ONEWAY) || profColl.equals(CostantiRegistroServizi.SINCRONO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
                this.errori.add("Il profilo di collaborazione dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere un profilo " + String.valueOf(CostantiRegistroServizi.ONEWAY) + ", " + String.valueOf(CostantiRegistroServizi.SINCRONO) + ", " + String.valueOf(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) + " o " + String.valueOf(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO));
            }
            if ((filtroDup = az.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("Il filtro duplicati dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if ((confRic2 = az.getConfermaRicezione()) != null && !confRic2.equals(CostantiRegistroServizi.ABILITATO) && !confRic2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La conferma ricezione dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if ((idColl2 = az.getIdCollaborazione()) != null && !idColl2.equals(CostantiRegistroServizi.ABILITATO) && !idColl2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("L'id collaborazione dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if ((consOrd2 = az.getConsegnaInOrdine()) != null && !consOrd2.equals(CostantiRegistroServizi.ABILITATO) && !consOrd2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La consegna in ordine dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if (az.getScadenza() == null) continue;
            try {
                Integer.parseInt(az.getScadenza());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza dell'azione " + az.getNome() + " nel " + (String)uriAS + " dev'essere un numero intero");
            }
        }
        for (j = 0; j < as.sizePortTypeList(); ++j) {
            BindingStyle style;
            PortType pt = as.getPortType(j);
            if (pt.getNome() == null) {
                this.errori.add("Non \u00e8 stato definito il nome di un servizio nel " + (String)uriAS);
                continue;
            }
            try {
                if (!RegularExpressionEngine.isMatch((String)pt.getNome(), (String)"^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                    this.errori.add("Il nome del servizio [" + pt.getNome() + "] nel " + (String)uriAS + " non e' valido; puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del servizio [" + pt.getNome() + "] nel " + (String)uriAS + " :" + e.getMessage(), e);
            }
            int numPt = 0;
            for (int k = 0; k < as.sizePortTypeList(); ++k) {
                PortType tmpPt = as.getPortType(k);
                if (!pt.getNome().equals(tmpPt.getNome())) continue;
                ++numPt;
            }
            if (numPt > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un port-type con nome " + pt.getNome() + " nel " + (String)uriAS);
            }
            if ((style = pt.getStyle()) != null && !style.equals(CostantiRegistroServizi.WSDL_STYLE_DOCUMENT) && !style.equals(CostantiRegistroServizi.WSDL_STYLE_RPC)) {
                this.errori.add("Lo style del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.WSDL_STYLE_DOCUMENT) + " o " + String.valueOf(CostantiRegistroServizi.WSDL_STYLE_RPC));
            }
            if (!((profColl = pt.getProfiloCollaborazione()) == null || profColl.equals(CostantiRegistroServizi.ONEWAY) || profColl.equals(CostantiRegistroServizi.SINCRONO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
                this.errori.add("Il profilo di collaborazione del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere un profilo " + String.valueOf(CostantiRegistroServizi.ONEWAY) + ", " + String.valueOf(CostantiRegistroServizi.SINCRONO) + ", " + String.valueOf(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) + " o " + String.valueOf(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO));
            }
            if ((filtroDup = pt.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("Il filtro duplicati del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if ((confRic2 = pt.getConfermaRicezione()) != null && !confRic2.equals(CostantiRegistroServizi.ABILITATO) && !confRic2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La conferma ricezione del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if ((idColl2 = pt.getIdCollaborazione()) != null && !idColl2.equals(CostantiRegistroServizi.ABILITATO) && !idColl2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("L'id collaborazione del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if ((consOrd2 = pt.getConsegnaInOrdine()) != null && !consOrd2.equals(CostantiRegistroServizi.ABILITATO) && !consOrd2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La consegna in ordine del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
            }
            if (pt.getScadenza() != null) {
                try {
                    Integer.parseInt(pt.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere un numero intero");
                }
            }
            for (int k = 0; k < pt.sizeAzioneList(); ++k) {
                Message mo;
                Message mi;
                Operation op = pt.getAzione(k);
                if (op.getNome() == null) {
                    this.errori.add("Non \u00e8 stato definito il nome di un'azione del servizio " + pt.getNome() + " nel " + (String)uriAS);
                    continue;
                }
                try {
                    if (!RegularExpressionEngine.isMatch((String)op.getNome(), (String)"^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                        this.errori.add("Il nome dell'azione " + op.getNome() + " nel " + (String)uriAS + " puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'azione " + op.getNome() + " nel " + (String)uriAS + " :" + e.getMessage(), e);
                }
                int numOp = 0;
                for (int h = 0; h < pt.sizeAzioneList(); ++h) {
                    Operation tmpOp = pt.getAzione(h);
                    if (!op.getNome().equals(tmpOp.getNome())) continue;
                    ++numOp;
                }
                if (numOp > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + op.getNome() + " nel " + (String)uriAS);
                }
                String correlata = op.getCorrelata();
                String correlataServizio = op.getCorrelataServizio();
                if (correlata != null && correlataServizio != null) {
                    PortType ptCorrelata;
                    if (!this.existsPortType_AccordoServizioParteComune(as, correlataServizio)) {
                        this.errori.add("Il servizio [" + correlataServizio + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuno dei servizi registrati nel " + (String)uriAS);
                    }
                    if (!this.existsAzione_PortType_AccordoServizio(ptCorrelata = this.getPortType_AccordoServizioParteComune(as, correlataServizio), correlata)) {
                        this.errori.add("L'azione [" + correlata + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuna delle azioni registrate nel servizio correlato [" + correlataServizio + "] nel " + (String)uriAS);
                    }
                } else if (correlata != null) {
                    if (!this.existsAzione_PortType_AccordoServizio(pt, correlata)) {
                        this.errori.add("L'azione [" + correlata + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuna delle azioni registrate nel " + (String)uriAS);
                    }
                } else if (correlataServizio != null) {
                    this.errori.add("L'azione " + op.getNome() + " nel servizio " + pt.getNome() + " del " + (String)uriAS + " contiene una correlazione verso un altro servizio [" + correlataServizio + "] senza pero' aver definito l'azione correlata");
                }
                style = op.getStyle();
                if (style != null && !style.equals(CostantiRegistroServizi.WSDL_STYLE_DOCUMENT) && !style.equals(CostantiRegistroServizi.WSDL_STYLE_RPC)) {
                    this.errori.add("Lo style dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.WSDL_STYLE_DOCUMENT) + " o " + String.valueOf(CostantiRegistroServizi.WSDL_STYLE_RPC));
                }
                if (!((profColl = op.getProfiloCollaborazione()) == null || profColl.equals(CostantiRegistroServizi.ONEWAY) || profColl.equals(CostantiRegistroServizi.SINCRONO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
                    this.errori.add("Il profilo di collaborazione dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere un profilo " + String.valueOf(CostantiRegistroServizi.ONEWAY) + ", " + String.valueOf(CostantiRegistroServizi.SINCRONO) + ", " + String.valueOf(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) + " o " + String.valueOf(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO));
                }
                if ((filtroDup = op.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("Il filtro duplicati dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
                }
                if ((confRic2 = op.getConfermaRicezione()) != null && !confRic2.equals(CostantiRegistroServizi.ABILITATO) && !confRic2.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("La conferma ricezione del dell'azione " + op.getNome() + " servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
                }
                if ((idColl2 = op.getIdCollaborazione()) != null && !idColl2.equals(CostantiRegistroServizi.ABILITATO) && !idColl2.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("L'id collaborazione dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
                }
                if ((consOrd2 = op.getConsegnaInOrdine()) != null && !consOrd2.equals(CostantiRegistroServizi.ABILITATO) && !consOrd2.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("La consegna in ordine ddell'azione " + op.getNome() + " el servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
                }
                if (op.getScadenza() != null) {
                    try {
                        Integer.parseInt(op.getScadenza());
                    }
                    catch (Exception e) {
                        this.errori.add("Il valore associato alla scadenza dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere un numero intero");
                    }
                }
                if ((mi = op.getMessageInput()) != null) {
                    BindingUse useI = mi.getUse();
                    if (useI != null && !useI.equals(CostantiRegistroServizi.WSDL_USE_LITERAL) && !useI.equals(CostantiRegistroServizi.WSDL_USE_ENCODED)) {
                        this.errori.add("L'uso del message-input dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere " + String.valueOf(CostantiRegistroServizi.WSDL_USE_ENCODED) + " o " + String.valueOf(CostantiRegistroServizi.WSDL_USE_LITERAL));
                    }
                    for (int l = 0; l < mi.sizePartList(); ++l) {
                        MessagePart part = mi.getPart(l);
                        if (part.getName() == null) {
                            this.errori.add("Non \u00e8 stato definito il name del message-input dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS);
                        }
                        if (part.getElementName() != null && part.getTypeName() != null) {
                            this.errori.add("Nella definizione del message-input sono stati definiti sia parametri di tipologia 'element' che parametri di tipologia 'type', solo una delle due tipologie \u00e8 ammessa (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                            continue;
                        }
                        if (part.getElementName() == null && part.getTypeName() == null) {
                            this.errori.add("Nella definizione del message-input non sono stati definiti ne parametri di tipologia 'element' che parametri di tipologia 'type' (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                            continue;
                        }
                        if (part.getElementName() != null && part.getElementNamespace() == null) {
                            this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'element' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        }
                        if (part.getElementName() == null && part.getElementNamespace() != null) {
                            this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'element' che non presenta la definizione dell'element name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        }
                        if (part.getTypeName() != null && part.getTypeNamespace() == null) {
                            this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'type' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        }
                        if (part.getTypeName() != null || part.getTypeNamespace() == null) continue;
                        this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'type' che non presenta la definizione del type name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                }
                if ((mo = op.getMessageOutput()) == null) continue;
                BindingUse useO = mo.getUse();
                if (useO != null && !useO.equals(CostantiRegistroServizi.WSDL_USE_LITERAL) && !useO.equals(CostantiRegistroServizi.WSDL_USE_ENCODED)) {
                    this.errori.add("L'uso del message-output dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere " + String.valueOf(CostantiRegistroServizi.WSDL_USE_ENCODED) + " o " + String.valueOf(CostantiRegistroServizi.WSDL_USE_LITERAL));
                }
                for (int l = 0; l < mo.sizePartList(); ++l) {
                    MessagePart part = mo.getPart(l);
                    if (part.getName() == null) {
                        this.errori.add("Non \u00e8 stato definito il name del message-output dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS);
                    }
                    if (part.getElementName() != null && part.getTypeName() != null) {
                        this.errori.add("Nella definizione del message-output sono stati definiti sia parametri di tipologia 'element' che parametri di tipologia 'type', solo una delle due tipologie \u00e8 ammessa (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        continue;
                    }
                    if (part.getElementName() == null && part.getTypeName() == null) {
                        this.errori.add("Nella definizione del message-output non sono stati definiti ne parametri di tipologia 'element' che parametri di tipologia 'type' (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        continue;
                    }
                    if (part.getElementName() != null && part.getElementNamespace() == null) {
                        this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'element' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                    if (part.getElementName() == null && part.getElementNamespace() != null) {
                        this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'element' che non presenta la definizione dell'element name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                    if (part.getTypeName() != null && part.getTypeNamespace() == null) {
                        this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'type' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                    if (part.getTypeName() != null || part.getTypeNamespace() == null) continue;
                    this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'type' che non presenta la definizione del type name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                }
            }
        }
        for (i = 0; i < as.sizeAllegatoList(); ++i) {
            Documento allegato = as.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, (String)uriAS);
        }
        for (i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = as.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, (String)uriAS);
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)as.getNome(), (String)"^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome nel " + (String)uriAS + " dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome nel " + (String)uriAS + " :" + e.getMessage(), e);
        }
        ProfiloCollaborazione profColl2 = as.getProfiloCollaborazione();
        if (profColl2 == null) {
            this.errori.add("Il profilo di collaborazione nel " + (String)uriAS + " non \u00e8 definito; deve possedere un profilo " + String.valueOf(CostantiRegistroServizi.ONEWAY) + ", " + String.valueOf(CostantiRegistroServizi.SINCRONO) + ", " + String.valueOf(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) + " o " + String.valueOf(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO));
        } else if (!(profColl2.equals(CostantiRegistroServizi.ONEWAY) || profColl2.equals(CostantiRegistroServizi.SINCRONO) || profColl2.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl2.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
            this.errori.add("Il profilo di collaborazione nel " + (String)uriAS + " deve possedere un profilo " + String.valueOf(CostantiRegistroServizi.ONEWAY) + ", " + String.valueOf(CostantiRegistroServizi.SINCRONO) + ", " + String.valueOf(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) + " o " + String.valueOf(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO));
        }
        StatoFunzionalita filtroDup2 = as.getFiltroDuplicati();
        if (filtroDup2 != null && !filtroDup2.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup2.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("Il filtro duplicati nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if ((confRic = as.getConfermaRicezione()) != null && !confRic.equals(CostantiRegistroServizi.ABILITATO) && !confRic.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La conferma ricezione nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if ((idColl = as.getIdCollaborazione()) != null && !idColl.equals(CostantiRegistroServizi.ABILITATO) && !idColl.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("L'id collaborazione nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if ((consOrd = as.getConsegnaInOrdine()) != null && !consOrd.equals(CostantiRegistroServizi.ABILITATO) && !consOrd.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La consegna in ordine nel " + (String)uriAS + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if (as.getScadenza() != null) {
            try {
                Integer.parseInt(as.getScadenza());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza nel " + (String)uriAS + " dev'essere un numero intero");
            }
        }
        if (as.getWsdlConcettuale() != null) {
            try {
                HttpUtilities.validateUri((String)as.getWsdlConcettuale(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl concettuale nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlDefinitorio() != null) {
            try {
                HttpUtilities.validateUri((String)as.getWsdlDefinitorio(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl definitorio nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlLogicoErogatore() != null) {
            try {
                HttpUtilities.validateUri((String)as.getWsdlLogicoErogatore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico erogatore nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlLogicoFruitore() != null) {
            try {
                HttpUtilities.validateUri((String)as.getWsdlLogicoFruitore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico fruitore nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getSpecificaConversazioneConcettuale() != null) {
            try {
                HttpUtilities.validateUri((String)as.getSpecificaConversazioneConcettuale(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl concettuale nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getSpecificaConversazioneErogatore() != null) {
            try {
                HttpUtilities.validateUri((String)as.getSpecificaConversazioneErogatore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl definitorio nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getSpecificaConversazioneFruitore() != null) {
            try {
                HttpUtilities.validateUri((String)as.getSpecificaConversazioneFruitore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico erogatore nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (!as.getUtilizzoSenzaAzione() && as.sizeAzioneList() == 0 && as.sizePortTypeList() == 0) {
            this.errori.add("Il " + (String)uriAS + " non prevede l'utilizzo senza azioni, quindi dev'essere definita almeno un'azione o almeno un servizio (con relative azioni)");
        }
        int numAs = 0;
        for (int j2 = 0; j2 < this.registro.sizeAccordoServizioParteComuneList(); ++j2) {
            AccordoServizioParteComune tmpAs = this.registro.getAccordoServizioParteComune(j2);
            if (!this.idAccordoFactory.getUriFromAccordo(tmpAs).equals(this.idAccordoFactory.getUriFromAccordo(as))) continue;
            ++numAs;
        }
        if (numAs > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un accordo di servizio (o servizio composto) con nome " + this.idAccordoFactory.getUriFromAccordo(as));
        }
    }

    private void validaSoggetto(Soggetto sogg, boolean showIDOggettiAnalizzati) throws DriverRegistroServiziException {
        int i;
        if (sogg.getNome() == null) {
            this.errori.add("Esiste un soggetto senza nome");
            return;
        }
        if (sogg.getTipo() == null) {
            this.errori.add("Esiste un soggetto senza tipo");
            return;
        }
        Connettore conn = sogg.getConnettore();
        if (conn != null) {
            this.validaConnettore(conn, "soggetto", sogg.getTipo() + "/" + sogg.getNome());
        }
        for (int j = 0; j < sogg.sizeAccordoServizioParteSpecificaList(); ++j) {
            AccordoServizioParteSpecifica serv = sogg.getAccordoServizioParteSpecifica(j);
            if (showIDOggettiAnalizzati) {
                String uriServizio = this.idServizioFactory.getUriFromAccordo(serv);
                this.printMsg("\tServizio: " + uriServizio);
            }
            serv.setTipoSoggettoErogatore(sogg.getTipo());
            serv.setNomeSoggettoErogatore(sogg.getNome());
            this.validaAccordoServizioParteSpecifica(serv, sogg);
        }
        if (!this.tipoSoggetti.contains(sogg.getTipo())) {
            this.errori.add("Il tipo del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)sogg.getNome(), (String)"^[0-9A-Za-z]+$") && !sogg.getNome().endsWith("_serialNumberDifferente")) {
                this.errori.add("Il nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo caratteri e cifre");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " :" + e.getMessage(), e);
        }
        int numS = 0;
        for (int j = 0; j < this.registro.sizeSoggettoList(); ++j) {
            Soggetto tmpSogg = this.registro.getSoggetto(j);
            if (!sogg.getNome().equals(tmpSogg.getNome()) || !sogg.getTipo().equals(tmpSogg.getTipo())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto con nome " + sogg.getNome() + " e tipo " + sogg.getTipo());
        }
        if (sogg.getPortaDominio() != null && !this.existsPortaDominio(sogg.getPortaDominio())) {
            this.errori.add("La porta di dominio [" + sogg.getPortaDominio() + "] del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non corrisponde a nessuna delle porte di dominio registrate");
        }
        if (sogg.sizeCredenzialiList() > 0) {
            i = 0;
            for (CredenzialiSoggetto credenziale : sogg.getCredenzialiList()) {
                this.validaCredenziale(credenziale, "soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " (credenziale-i" + i + ")");
                ++i;
            }
        }
        if (sogg.getRuoli() != null) {
            for (i = 0; i < sogg.getRuoli().sizeRuoloList(); ++i) {
                String nomeRuolo = sogg.getRuoli().getRuolo(i).getNome();
                try {
                    if (RegularExpressionEngine.isMatch((String)nomeRuolo, (String)"^[0-9A-Za-z_]+$")) continue;
                    this.errori.add("Il ruolo [" + nomeRuolo + "] del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo da caratteri, cifre e '_'");
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " :" + e.getMessage(), e);
                }
            }
            for (i = 0; i < sogg.getRuoli().sizeRuoloList(); ++i) {
                int numRuolo = 0;
                String tmpRuolo = sogg.getRuoli().getRuolo(i).getNome();
                for (int j = 0; j < sogg.getRuoli().sizeRuoloList(); ++j) {
                    String checkRuolo = sogg.getRuoli().getRuolo(j).getNome();
                    if (!checkRuolo.equals(tmpRuolo)) continue;
                    ++numRuolo;
                }
                if (numRuolo <= true) continue;
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
            }
        }
    }

    private void validaCredenziale(CredenzialiSoggetto c, String oggetto) throws DriverRegistroServiziException {
        CredenzialeTipo tipo = CredenzialeTipo.SSL;
        if (c.getTipo() != null) {
            tipo = c.getTipo();
        }
        if (!(tipo.equals(CredenzialeTipo.BASIC) || tipo.equals(CredenzialeTipo.APIKEY) || tipo.equals(CredenzialeTipo.SSL) || tipo.equals(CredenzialeTipo.PRINCIPAL))) {
            this.errori.add("Il tipo delle credenziali del " + oggetto + " deve possedere i valori: " + CredenzialeTipo.BASIC.toString() + " o " + CredenzialeTipo.APIKEY.toString() + " o " + CredenzialeTipo.SSL.toString() + " o " + CredenzialeTipo.PRINCIPAL.toString());
        }
        if (c.getTipo().equals(CredenzialeTipo.BASIC) && (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals(""))) {
            this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
        }
        if (c.getTipo().equals(CredenzialeTipo.APIKEY) && (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals(""))) {
            this.errori.add("Le credenziali di tipo apikey del " + oggetto + " devono avere username e password valorizzati");
        }
        if (c.getTipo().equals(CredenzialeTipo.SSL)) {
            if ((c.getSubject() == null || c.getSubject().equals("")) && c.getCertificate() == null) {
                this.errori.add("Le credenziali di tipo ssl del " + oggetto + " devono avere subject valorizzato");
            } else {
                if (c.getSubject() != null && !"".equals(c.getSubject())) {
                    try {
                        CertificateUtils.validaPrincipal((String)c.getSubject(), (PrincipalType)PrincipalType.SUBJECT);
                    }
                    catch (Exception e) {
                        this.errori.add("Le credenziali di tipo ssl del " + oggetto + " possiedono un subject non valido: " + e.getMessage());
                    }
                }
                if (c.getIssuer() != null && !"".equals(c.getIssuer())) {
                    try {
                        CertificateUtils.validaPrincipal((String)c.getIssuer(), (PrincipalType)PrincipalType.ISSUER);
                    }
                    catch (Exception e) {
                        this.errori.add("Le credenziali di tipo ssl del " + oggetto + " possiedono un issuer non valido: " + e.getMessage());
                    }
                }
            }
        }
        if (c.getTipo().equals(CredenzialeTipo.PRINCIPAL) && (c.getUser() == null || c.getUser().equals(""))) {
            this.errori.add("Le credenziali di tipo principal del " + oggetto + " devono avere user valorizzato");
        }
    }

    private void validaAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps, Soggetto sogg) throws DriverRegistroServiziException {
        StatoFunzionalita consOrd;
        StatoFunzionalita idColl;
        StatoFunzionalita confRic;
        StatoFunzionalita filtroDup;
        int i;
        if (asps.getTipo() == null) {
            this.errori.add("Non e' stato fornito un tipo per l'accordo di servizio parte specifica");
            return;
        }
        if (asps.getNome() == null) {
            this.errori.add("Non e' stato fornito un nome per l'accordo di servizio parte specifica");
            return;
        }
        if (asps.getVersione() == null) {
            this.errori.add("Non e' stato fornito una versione per l'accordo di servizio parte specifica");
            return;
        }
        String uriServizio = this.idServizioFactory.getUriFromAccordo(asps);
        ConfigurazioneServizio serv = asps.getConfigurazioneServizio();
        if (serv != null) {
            Connettore conn = serv.getConnettore();
            if (conn != null) {
                this.validaConnettore(conn, "servizio", uriServizio);
            } else if (sogg.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(sogg.getConnettore().getTipo())) {
                this.errori.add("Il servizio [" + uriServizio + "] deve obbligatoriamente definire un connettore, poiche' il soggetto erogatore non ne possiede uno");
            }
            for (int k = 0; k < serv.sizeConfigurazioneAzioneList(); ++k) {
                ConfigurazioneServizioAzione az = serv.getConfigurazioneAzione(k);
                if (az.sizeAzioneList() <= 0) {
                    this.errori.add("Esiste una configurazione delle azioni del servizio " + uriServizio + " per cui non \u00e8 definito una azione");
                    continue;
                }
                for (String azione : az.getAzioneList()) {
                    int numA = 0;
                    for (int h = 0; h < serv.sizeConfigurazioneAzioneList(); ++h) {
                        ConfigurazioneServizioAzione tmpSsa = serv.getConfigurazioneAzione(h);
                        for (String azioneCheck : tmpSsa.getAzioneList()) {
                            if (!azione.equals(azioneCheck)) continue;
                            ++numA;
                        }
                    }
                    if (numA > 1) {
                        this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + azione + " nel servizio " + uriServizio);
                    }
                    if (!this.existsAccordoServizioParteComune(asps.getAccordoServizioParteComune())) continue;
                    AccordoServizioParteComune as = this.getAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                    if (as != null && ServiceBinding.SOAP.equals(as.getServiceBinding())) {
                        if (asps.getPortType() != null) {
                            PortType pt;
                            if (!this.existsPortType_AccordoServizioParteComune(as, asps.getPortType()) || this.existsAzione_PortType_AccordoServizio(pt = this.getPortType_AccordoServizioParteComune(as, asps.getPortType()), azione)) continue;
                            this.errori.add("Il servizio [" + uriServizio + "], utilizza un'azione [" + azione + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio (istanziato per il servizio [" + asps.getPortType() + "])");
                            continue;
                        }
                        if (this.existsAzione_AccordoServizioParteComune(as, azione)) continue;
                        this.errori.add("Il servizio [" + uriServizio + "], utilizza un'azione [" + azione + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio");
                        continue;
                    }
                    if (as == null) {
                        this.errori.add("API '" + asps.getAccordoServizioParteComune() + "' non trovata");
                        continue;
                    }
                    if (this.existsResource_AccordoServizioParteComune(as, azione)) continue;
                    this.errori.add("Il servizio [" + uriServizio + "], utilizza una risorsa [" + azione + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio");
                }
                if (az.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(az.getConnettore().getTipo())) {
                    this.errori.add("Non pu\u00f2 esistere una configurazione delle azioni nel servizio " + uriServizio + " che non definisce ne al suo interno un connettore");
                }
                if ((conn = az.getConnettore()) == null) continue;
                this.validaConnettore(conn, "Azioni [" + String.valueOf(az.getAzioneList()) + "] ridefinite nel Servizio", uriServizio);
            }
        }
        for (int k = 0; k < asps.sizeFruitoreList(); ++k) {
            Connettore conn;
            Fruitore fru = asps.getFruitore(k);
            if (fru.getTipo() == null) {
                this.errori.add("Esiste un fruitore del servizio [" + uriServizio + "] per cui non \u00e8 definito il tipo");
                continue;
            }
            if (fru.getNome() == null) {
                this.errori.add("Esiste un fruitore del servizio [" + uriServizio + "] per cui non \u00e8 definito il nome");
                continue;
            }
            if (!this.existsSoggetto(fru.getTipo(), fru.getNome())) {
                this.errori.add("Il fruitore " + fru.getTipo() + "/" + fru.getNome() + " del servizio " + uriServizio + " non corrisponde a nessuno dei soggetti registrati");
            }
            int numF = 0;
            for (int h = 0; h < asps.sizeFruitoreList(); ++h) {
                Fruitore tmpF = asps.getFruitore(h);
                if (!fru.getNome().equals(tmpF.getNome()) || !fru.getTipo().equals(tmpF.getTipo())) continue;
                ++numF;
            }
            if (numF > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un fruitore con nome " + fru.getNome() + " e tipo " + fru.getTipo() + " per il servizio " + uriServizio);
            }
            if ((conn = fru.getConnettore()) != null) {
                this.validaConnettore(conn, "fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio", uriServizio);
            }
            for (int j = 0; j < fru.sizeConfigurazioneAzioneList(); ++j) {
                ConfigurazioneServizioAzione az = fru.getConfigurazioneAzione(j);
                if (az.sizeAzioneList() <= 0) {
                    this.errori.add("Esiste una configurazione delle azioni del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + uriServizio + " per cui non \u00e8 definito una azione");
                    continue;
                }
                for (String azione : az.getAzioneList()) {
                    int numA = 0;
                    for (int h = 0; h < fru.sizeConfigurazioneAzioneList(); ++h) {
                        ConfigurazioneServizioAzione tmpSsa = fru.getConfigurazioneAzione(h);
                        for (String azioneCheck : tmpSsa.getAzioneList()) {
                            if (!azione.equals(azioneCheck)) continue;
                            ++numA;
                        }
                    }
                    if (numA > 1) {
                        this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + azione + " nel fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + uriServizio);
                    }
                    if (!this.existsAccordoServizioParteComune(asps.getAccordoServizioParteComune())) continue;
                    AccordoServizioParteComune as = this.getAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                    if (ServiceBinding.SOAP.equals(as.getServiceBinding())) {
                        if (asps.getPortType() != null) {
                            PortType pt;
                            if (!this.existsPortType_AccordoServizioParteComune(as, asps.getPortType()) || this.existsAzione_PortType_AccordoServizio(pt = this.getPortType_AccordoServizioParteComune(as, asps.getPortType()), azione)) continue;
                            this.errori.add("Il fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio [" + uriServizio + "], utilizza un'azione [" + azione + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio (istanziato per il servizio [" + asps.getPortType() + "])");
                            continue;
                        }
                        if (this.existsAzione_AccordoServizioParteComune(as, azione)) continue;
                        this.errori.add("Il fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio [" + uriServizio + "], utilizza un'azione [" + azione + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio");
                        continue;
                    }
                    if (this.existsResource_AccordoServizioParteComune(as, azione)) continue;
                    this.errori.add("Il fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio [" + uriServizio + "], utilizza una risorsa [" + azione + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio");
                }
                if (az.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(az.getConnettore().getTipo())) {
                    this.errori.add("Non pu\u00f2 esistere una configurazione delle azioni nel fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + uriServizio + " che non definisce ne al suo interno un connettore");
                }
                if ((conn = az.getConnettore()) == null) continue;
                this.validaConnettore(conn, "Azioni [" + String.valueOf(az.getAzioneList()) + "] ridefinite nel fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del Servizio", uriServizio);
            }
            if (fru.getWsdlImplementativoErogatore() != null) {
                try {
                    HttpUtilities.validateUri((String)fru.getWsdlImplementativoErogatore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
                }
                catch (Exception e) {
                    this.errori.add("Il wsdl implementativo erogatore del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + uriServizio + " non \u00e8 valido: " + e.getMessage());
                }
            }
            if (fru.getWsdlImplementativoFruitore() == null) continue;
            try {
                HttpUtilities.validateUri((String)fru.getWsdlImplementativoFruitore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il wsdl implementativo fruitore del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + uriServizio + " non \u00e8 valido: " + e.getMessage());
            }
        }
        for (i = 0; i < asps.sizeAllegatoList(); ++i) {
            Documento allegato = asps.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, "Servizio[" + uriServizio + "]");
        }
        for (i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = asps.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, "Servizio[" + uriServizio + "]");
        }
        for (i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
            Documento specificaLivelloServizio = asps.getSpecificaLivelloServizio(i);
            this.validateDocumento(specificaLivelloServizio, RuoliDocumento.specificaLivelloServizio, "Servizio[" + uriServizio + "]");
        }
        for (i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
            Documento specificaSicurezza = asps.getSpecificaSicurezza(i);
            this.validateDocumento(specificaSicurezza, RuoliDocumento.specificaSicurezza, "Servizio[" + uriServizio + "]");
        }
        ServiceBinding binding = this.mappingAccordiToServiceBinding.get(this.idAccordoFactory.normalizeUri(asps.getAccordoServizioParteComune()));
        if (binding == null) {
            this.errori.add("Il servizio " + uriServizio + " implementa un accordo parte comune [" + asps.getAccordoServizioParteComune() + "] non esistente");
        }
        if (ServiceBinding.SOAP.equals(binding)) {
            if (!this.tipoServiziSoap.contains(asps.getTipo())) {
                this.errori.add("Il tipo del servizio " + uriServizio + " non \u00e8 valido (tipi utilizzabili: " + this.getTipoServiziSoap() + ")");
            }
        } else if (!this.tipoServiziRest.contains(asps.getTipo())) {
            this.errori.add("Il tipo del servizio " + uriServizio + " non \u00e8 valido (tipi utilizzabili: " + this.getTipoServiziRest() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)asps.getNome(), (String)"^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome del servizio " + uriServizio + " dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del servizio " + uriServizio + " :" + e.getMessage(), e);
        }
        if (asps.getAccordoServizioParteComune() == null) {
            this.errori.add("Il Servizio " + uriServizio + " non implementa un accordo di servizio");
        } else if (!this.existsAccordoServizioParteComune(asps.getAccordoServizioParteComune())) {
            this.errori.add("L'accordo servizio " + asps.getAccordoServizioParteComune() + " del servizio " + uriServizio + " non corrisponde a nessuno degli accordi servizio registrati");
        } else {
            AccordoServizioParteComune as;
            String nomePT = asps.getPortType();
            if (nomePT != null && !this.existsPortType_AccordoServizioParteComune(as = this.getAccordoServizioParteComune(asps.getAccordoServizioParteComune()), nomePT)) {
                this.errori.add("Il servizio " + nomePT + " del servizio " + uriServizio + " non corrisponde a nessuno dei servizi dell'accordo servizio implementato [" + asps.getAccordoServizioParteComune() + "]");
            }
        }
        int numS = 0;
        for (int j = 0; j < sogg.sizeAccordoServizioParteSpecificaList(); ++j) {
            AccordoServizioParteSpecifica tmpS = sogg.getAccordoServizioParteSpecifica(j);
            if (!asps.getNome().equals(tmpS.getNome()) || !asps.getTipo().equals(tmpS.getTipo()) || asps.getVersione().intValue() != tmpS.getVersione().intValue() || !asps.getNomeSoggettoErogatore().equals(tmpS.getNomeSoggettoErogatore()) || !asps.getTipoSoggettoErogatore().equals(tmpS.getTipoSoggettoErogatore())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un servizio con tipo:" + asps.getTipo() + ", nome:" + asps.getNome() + ", versione:" + asps.getVersione() + " tipoSoggettoErogatore:" + asps.getTipoSoggettoErogatore() + " e nomeSoggettoErogatore " + asps.getNomeSoggettoErogatore());
        }
        if (asps.getWsdlImplementativoErogatore() != null) {
            try {
                HttpUtilities.validateUri((String)asps.getWsdlImplementativoErogatore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl implementativo erogatore del servizio " + uriServizio + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (asps.getWsdlImplementativoFruitore() != null) {
            try {
                HttpUtilities.validateUri((String)asps.getWsdlImplementativoFruitore(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl implementativo fruitore del servizio " + uriServizio + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if ((filtroDup = asps.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("Il filtro duplicati del servizio " + uriServizio + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if ((confRic = asps.getConfermaRicezione()) != null && !confRic.equals(CostantiRegistroServizi.ABILITATO) && !confRic.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La conferma ricezione del servizio " + uriServizio + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if ((idColl = asps.getIdCollaborazione()) != null && !idColl.equals(CostantiRegistroServizi.ABILITATO) && !idColl.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("L'id collaborazione del servizio " + uriServizio + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if ((consOrd = asps.getConsegnaInOrdine()) != null && !consOrd.equals(CostantiRegistroServizi.ABILITATO) && !consOrd.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La consegna in ordine del servizio " + uriServizio + " deve possedere il valore " + String.valueOf(CostantiRegistroServizi.ABILITATO) + " o " + String.valueOf(CostantiRegistroServizi.DISABILITATO));
        }
        if (asps.getScadenza() != null) {
            try {
                Integer.parseInt(asps.getScadenza());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza del servizio " + uriServizio + " dev'essere un numero intero");
            }
        }
    }

    private void validaPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd.getNome() == null) {
            this.errori.add("Esiste una porta di dominio senza nome");
            return;
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)pdd.getNome(), (String)"^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome della porta di dominio dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome della porta di dominio :" + e.getMessage(), e);
        }
        StatoFunzionalita clA = pdd.getClientAuth();
        if (clA != null && !clA.equals("abilitato") && !clA.equals("disabilitato")) {
            this.errori.add("Il client-auth della porta di dominio " + pdd.getNome() + " dev'essere abilitato o disabilitato");
        }
        if (pdd.getClientAuth() != null && pdd.getClientAuth().equals("abilitato") && (pdd.getSubject() == null || pdd.getSubject().equals(""))) {
            this.errori.add("Il subject della porta di dominio " + pdd.getNome() + " dev'essere fornito quando client-auth \u00e8 abilitato");
        }
        int numPd = 0;
        for (int j = 0; j < this.registro.sizePortaDominioList(); ++j) {
            PortaDominio tmpPd = this.registro.getPortaDominio(j);
            if (!pdd.getNome().equals(tmpPd.getNome())) continue;
            ++numPd;
        }
        if (numPd > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta di dominio con nome " + pdd.getNome());
        }
    }

    private void validaRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo.getNome() == null) {
            this.errori.add("Esiste un ruolo senza nome");
            return;
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)ruolo.getNome(), (String)"^[0-9A-Za-z_]+$")) {
                this.errori.add("Il nome del ruolo dev'essere formato solo da caratteri, cifre e '_'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del ruolo :" + e.getMessage(), e);
        }
        int numRuolo = 0;
        for (int j = 0; j < this.registro.sizeRuoloList(); ++j) {
            Ruolo tmpRuolo = this.registro.getRuolo(j);
            if (!ruolo.getNome().equals(tmpRuolo.getNome())) continue;
            ++numRuolo;
        }
        if (numRuolo > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + ruolo.getNome());
        }
    }

    private void validaScope(Scope scope) throws DriverRegistroServiziException {
        if (scope.getNome() == null) {
            this.errori.add("Esiste uno scope senza nome");
            return;
        }
        try {
            if (!RegularExpressionEngine.isMatch((String)scope.getNome(), (String)"^[0-9A-Za-z_]+$")) {
                this.errori.add("Il nome dello scope dev'essere formato solo da caratteri, cifre e '_'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dello scope :" + e.getMessage(), e);
        }
        int numScope = 0;
        for (int j = 0; j < this.registro.sizeScopeList(); ++j) {
            Scope tmpScope = this.registro.getScope(j);
            if (!scope.getNome().equals(tmpScope.getNome())) continue;
            ++numScope;
        }
        if (numScope > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di uno scope con nome " + scope.getNome());
        }
    }

    private void validaConnettore(Connettore conn, String oggetto, String tipoEnomeOggetto) throws DriverRegistroServiziException {
        block116: {
            int j;
            int j2;
            String nomeConn = conn.getNome();
            String tipoConn = conn.getTipo();
            if (nomeConn == null) {
                if (oggetto == null) {
                    this.errori.add("Esiste un connettore nella radice del registro per cui non \u00e8 definito il nome");
                } else {
                    this.errori.add("Esiste un connettore del " + oggetto + " " + tipoEnomeOggetto + " per cui non \u00e8 definito il nome");
                }
                return;
            }
            if (oggetto == null) {
                int numC = 0;
                for (j2 = 0; j2 < this.registro.sizeConnettoreList(); ++j2) {
                    Connettore tmpC = this.registro.getConnettore(j2);
                    if (!nomeConn.equals(tmpC.getNome())) continue;
                    ++numC;
                }
                if (numC > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un connettore con nome " + nomeConn + " definito come elemento radice del registro servizi");
                }
            } else {
                if (tipoConn == null) {
                    conn = null;
                    for (j = 0; j < this.registro.sizeConnettoreList(); ++j) {
                        Connettore connettore = this.registro.getConnettore(j);
                        if (!nomeConn.equals(connettore.getNome())) continue;
                        conn = connettore;
                        break;
                    }
                }
                if (conn == null) {
                    this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " non corrisponde a nessuno dei connettori registrati");
                } else {
                    tipoConn = conn.getTipo();
                }
            }
            if (!this.tipoConnettori.contains(tipoConn)) {
                if (oggetto == null) {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + ", definito nella radice del registro, non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                } else {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                }
            } else {
                for (j = 0; j < conn.sizePropertyList(); ++j) {
                    Property cp = conn.getProperty(j);
                    if (cp.getNome() == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                        }
                        return;
                    }
                    if (cp.getValore() != null) continue;
                    if (oggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                    }
                    return;
                }
                if (tipoConn.equals(TipiConnettore.HTTP.getNome())) {
                    String urlConn = null;
                    for (j2 = 0; j2 < conn.sizePropertyList(); ++j2) {
                        Property cp = conn.getProperty(j2);
                        if (!cp.getNome().equals("location")) continue;
                        urlConn = cp.getValore();
                        break;
                    }
                    if (urlConn == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            this.validaUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                                break block116;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.JMS.getNome())) {
                    String jmsNome = null;
                    String jmsTipo = null;
                    String jmsConnFact = null;
                    String jmsSendAs = null;
                    for (int j3 = 0; j3 < conn.sizePropertyList(); ++j3) {
                        Property cp = conn.getProperty(j3);
                        if (cp.getNome().equals("location")) {
                            jmsNome = cp.getValore();
                        }
                        if (cp.getNome().equals("tipo")) {
                            jmsTipo = cp.getValore();
                        }
                        if (cp.getNome().equals("connection-factory")) {
                            jmsConnFact = cp.getValore();
                        }
                        if (!cp.getNome().equals("send-as")) continue;
                        jmsSendAs = cp.getValore();
                    }
                    if (jmsNome == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        }
                    }
                    if (jmsTipo == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        }
                    } else if (!jmsTipo.equals("queue") && !jmsTipo.equals("topic")) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        }
                    }
                    if (jmsConnFact == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha una connection factory definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha una connection factory definita");
                        }
                    }
                    if (jmsSendAs == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        }
                    } else if (!jmsSendAs.equals("TextMessage") && !jmsSendAs.equals("BytesMessage")) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.HTTPS.getNome())) {
                    String urlConn = null;
                    String trustStoreLocation = null;
                    String trustStorePassword = null;
                    String keyStoreLocation = null;
                    String keyStorePassword = null;
                    String keyPassword = null;
                    String hostNameVerifier = null;
                    for (int j4 = 0; j4 < conn.sizePropertyList(); ++j4) {
                        Property cp = conn.getProperty(j4);
                        if (cp.getNome().equals("location")) {
                            urlConn = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStoreLocation")) {
                            trustStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStorePassword")) {
                            trustStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStoreLocation")) {
                            keyStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStorePassword")) {
                            keyStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyPassword")) {
                            keyPassword = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("hostnameVerifier")) continue;
                        hostNameVerifier = cp.getValore();
                    }
                    if (urlConn == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            this.validaUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                    if (trustStoreLocation != null) {
                        File f = new File(trustStoreLocation);
                        if (!f.exists()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (trustStorePassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            }
                        }
                    }
                    if (keyStoreLocation != null) {
                        File f = new File(keyStoreLocation);
                        if (!f.exists()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (keyStorePassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            }
                        } else if (keyPassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            }
                        }
                    }
                    if (hostNameVerifier != null) {
                        try {
                            Boolean.parseBoolean(hostNameVerifier);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                                break block116;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.DISABILITATO.getNome()) && conn.sizePropertyList() > 0) {
                    if (oggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    }
                }
            }
        }
    }

    private void validateDocumento(Documento doc, RuoliDocumento ruolo, String oggetto) {
        if (doc.getTipo() == null) {
            this.errori.add("Esiste un documento con ruolo (" + ruolo.toString() + ") per l'oggetto " + oggetto + " per cui non \u00e8 definito il tipo");
            return;
        }
        if (doc.getFile() == null) {
            this.errori.add("Esiste un documento con ruolo (" + ruolo.toString() + ") per l'oggetto " + oggetto + " per cui non \u00e8 definito il file");
            return;
        }
        String idDocumento = "(" + ruolo.toString() + ")(" + doc.getTipo() + ")(" + doc.getFile() + ") ";
        if (!RuoliDocumento.allegato.toString().equals(ruolo.toString())) {
            if (RuoliDocumento.specificaSemiformale.toString().equals(ruolo.toString())) {
                if (TipiDocumentoSemiformale.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoSemiformale.toStringArray();
                    StringBuilder bf = new StringBuilder();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica semiformale (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaCoordinamento.toString().equals(ruolo.toString())) {
                if (TipiDocumentoCoordinamento.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoCoordinamento.toStringArray();
                    StringBuilder bf = new StringBuilder();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica di coordinamento (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaLivelloServizio.toString().equals(ruolo.toString())) {
                if (TipiDocumentoLivelloServizio.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoLivelloServizio.toStringArray();
                    StringBuilder bf = new StringBuilder();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica dei livelli di servizio (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaSicurezza.toString().equals(ruolo.toString())) {
                if (TipiDocumentoSicurezza.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoSicurezza.toStringArray();
                    StringBuilder bf = new StringBuilder();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica di sicurezza (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else {
                this.errori.add(idDocumento + " ruolo non conosciuto (oggetto: " + oggetto + "): " + ruolo.toString());
            }
        }
        try {
            HttpUtilities.validateUri((String)doc.getFile(), (boolean)this.checkEsistenzaFileDefinitoTramiteURI);
        }
        catch (Exception e) {
            this.errori.add(idDocumento + " file non valido (oggetto: " + oggetto + "): " + e.getMessage());
        }
    }

    private void validaUrl(String url) throws MalformedURLException, URISyntaxException {
        URL testUrl = new URI(url).toURL();
        testUrl.toString();
    }

    private boolean existsAccordoCooperazione(String uriAccordo) throws DriverRegistroServiziException {
        return this.getAccordoCooperazione(uriAccordo) != null;
    }

    private AccordoCooperazione getAccordoCooperazione(String uriAccordo) throws DriverRegistroServiziException {
        for (int j = 0; j < this.registro.sizeAccordoCooperazioneList(); ++j) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(j);
            if (!this.idAccordoCooperazioneFactory.getUriFromAccordo(ac).equals(uriAccordo)) continue;
            return ac;
        }
        return null;
    }

    private boolean existsAccordoServizioParteComune(String uriAccordo) throws DriverRegistroServiziException {
        return this.getAccordoServizioParteComune(uriAccordo) != null;
    }

    private AccordoServizioParteComune getAccordoServizioParteComune(String uriAccordo) throws DriverRegistroServiziException {
        for (int j = 0; j < this.registro.sizeAccordoServizioParteComuneList(); ++j) {
            AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(j);
            if (!this.idAccordoFactory.getUriFromAccordo(as).equals(this.idAccordoFactory.normalizeUri(uriAccordo))) continue;
            return as;
        }
        return null;
    }

    private boolean existsResource_AccordoServizioParteComune(AccordoServizioParteComune as, String azione) throws DriverRegistroServiziException {
        return this.getResource_AccordoServizioParteComune(as, azione) != null;
    }

    private Resource getResource_AccordoServizioParteComune(AccordoServizioParteComune as, String azione) throws DriverRegistroServiziException {
        for (int j = 0; j < as.sizeResourceList(); ++j) {
            Resource r = as.getResource(j);
            if (!r.getNome().equals(azione)) continue;
            return r;
        }
        return null;
    }

    private boolean existsAzione_AccordoServizioParteComune(AccordoServizioParteComune as, String azione) throws DriverRegistroServiziException {
        return this.getAzione_AccordoServizioParteComune(as, azione) != null;
    }

    private Azione getAzione_AccordoServizioParteComune(AccordoServizioParteComune as, String azione) throws DriverRegistroServiziException {
        for (int j = 0; j < as.sizeAzioneList(); ++j) {
            Azione az = as.getAzione(j);
            if (!az.getNome().equals(azione)) continue;
            return az;
        }
        return null;
    }

    private boolean existsPortType_AccordoServizioParteComune(AccordoServizioParteComune as, String porttype) throws DriverRegistroServiziException {
        return this.getPortType_AccordoServizioParteComune(as, porttype) != null;
    }

    private PortType getPortType_AccordoServizioParteComune(AccordoServizioParteComune as, String porttype) throws DriverRegistroServiziException {
        for (int j = 0; j < as.sizePortTypeList(); ++j) {
            PortType pt = as.getPortType(j);
            if (!pt.getNome().equals(porttype)) continue;
            return pt;
        }
        return null;
    }

    private boolean existsAzione_PortType_AccordoServizio(PortType pt, String azione) throws DriverRegistroServiziException {
        return this.getAzione_PortType_AccordoServizio(pt, azione) != null;
    }

    private Operation getAzione_PortType_AccordoServizio(PortType pt, String azione) throws DriverRegistroServiziException {
        for (int j = 0; j < pt.sizeAzioneList(); ++j) {
            Operation az = pt.getAzione(j);
            if (!az.getNome().equals(azione)) continue;
            return az;
        }
        return null;
    }

    private boolean existsPortaDominio(String nome) {
        return this.getPortaDominio(nome) != null;
    }

    private PortaDominio getPortaDominio(String nome) {
        for (int j = 0; j < this.registro.sizePortaDominioList(); ++j) {
            PortaDominio pdd = this.registro.getPortaDominio(j);
            if (!nome.equals(pdd.getNome())) continue;
            return pdd;
        }
        return null;
    }

    private boolean existsSoggetto(String tipo, String nome) {
        return this.getSoggetto(tipo, nome) != null;
    }

    private Soggetto getSoggetto(String tipo, String nome) {
        for (int j = 0; j < this.registro.sizeSoggettoList(); ++j) {
            Soggetto ss = this.registro.getSoggetto(j);
            if (!tipo.equals(ss.getTipo()) || !nome.equals(ss.getNome())) continue;
            return ss;
        }
        return null;
    }

    private boolean existsAccordoServizioParteSpecifica(String tipo, String nome, Integer versione, String tipoSoggetto, String nomeSoggetto) {
        return this.getAccordoServizioParteSpecifica(tipo, nome, versione, tipoSoggetto, nomeSoggetto) != null;
    }

    private AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(String tipo, String nome, Integer versione, String tipoSoggetto, String nomeSoggetto) {
        for (int j = 0; j < this.registro.sizeSoggettoList(); ++j) {
            Soggetto ss = this.registro.getSoggetto(j);
            if (!tipoSoggetto.equals(ss.getTipo()) || !nomeSoggetto.equals(ss.getNome())) continue;
            for (int h = 0; h < ss.sizeAccordoServizioParteSpecificaList(); ++h) {
                AccordoServizioParteSpecifica serv = ss.getAccordoServizioParteSpecifica(h);
                if (!tipo.equals(serv.getTipo()) || !nome.equals(serv.getNome()) || versione.intValue() != serv.getVersione().intValue()) continue;
                return serv;
            }
        }
        return null;
    }
}

