/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.GruppiAccordo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiGruppiDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiGruppiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readAccordiGruppi(AccordoServizioParteComune as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readAccordiGruppi") : this.driver.globalConnection);
            if (as.getId() == null) throw new Exception("Accordo id non definito");
            if (as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_gruppi");
            sqlQueryObject.addFromTable("gruppi");
            sqlQueryObject.addSelectAliasField("gruppi", "id", "identificativoGruppo");
            sqlQueryObject.addSelectAliasField("gruppi", "nome", "nomeGruppo");
            sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo = gruppi.id");
            sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("gruppi.nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                if (as.getGruppi() == null) {
                    as.setGruppi(new GruppiAccordo());
                }
                GruppoAccordo gruppo = new GruppoAccordo();
                gruppo.setId(rs.getLong("identificativoGruppo"));
                gruppo.setNome(rs.getString("nomeGruppo"));
                as.getGruppi().addGruppo(gruppo);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readAccordiGruppi] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
    }
}

