/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneServizioCompostoServizioComponenteSintetico;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneServizioCompostoSintetico;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.AzioneSintetica;
import org.openspcoop2.core.registry.beans.GruppoSintetico;
import org.openspcoop2.core.registry.beans.OperationSintetica;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.beans.ResourceSintetica;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_utilsDriver;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiSinteticiDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiSinteticiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoServizioParteComuneSintetico getAccordoServizioParteComuneSintetico(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComuneSintetico] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComuneSintetico] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComuneSintetico] Parametro idAccordo.getNome non e' definito");
        }
        this.driver.logDebug("richiesto getAccordoServizioParteComuneSintetico: " + idAccordo.toString());
        long idAccordoLong = -1L;
        Connection con = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoServizioParteComuneSintetico(idAccordo)") : this.driver.globalConnection;
            idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.driver.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComuneSintetico] Accordo non trovato (id:" + String.valueOf(idAccordo) + ")");
            }
            this.driver.closeConnection(con);
            return this.getAccordoServizioParteComuneSintetico(idAccordoLong);
        }
        catch (DriverRegistroServiziNotFound se) {
            try {
                throw se;
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteComuneSintetico] Exception :" + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
    }

    protected AccordoServizioParteComuneSintetico getAccordoServizioParteComuneSintetico(long idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComuneSintetico(idAccordo, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoServizioParteComuneSintetico getAccordoServizioParteComuneSintetico(long idAccordo, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String tmp;
        String sqlQuery;
        ISQLQueryObject sqlQueryObject;
        AccordoServizioParteComuneSintetico accordoServizio = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam == null ? (this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoServizioParteComuneSintetico(idAccordoLong)") : this.driver.globalConnection) : conParam;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("accordi", "id");
            sqlQueryObject.addSelectField("accordi", "nome");
            sqlQueryObject.addSelectField("accordi", "descrizione");
            sqlQueryObject.addSelectField("accordi", "service_binding");
            sqlQueryObject.addSelectField("accordi", "profilo_collaborazione");
            sqlQueryObject.addSelectField("accordi", "formato_specifica");
            sqlQueryObject.addSelectField("accordi", "wsdl_definitorio");
            sqlQueryObject.addSelectField("accordi", "wsdl_concettuale");
            sqlQueryObject.addSelectField("accordi", "wsdl_logico_erogatore");
            sqlQueryObject.addSelectField("accordi", "wsdl_logico_fruitore");
            sqlQueryObject.addSelectField("accordi", "spec_conv_concettuale");
            sqlQueryObject.addSelectField("accordi", "spec_conv_erogatore");
            sqlQueryObject.addSelectField("accordi", "spec_conv_fruitore");
            sqlQueryObject.addSelectField("accordi", "utilizzo_senza_azione");
            sqlQueryObject.addSelectField("accordi", "superuser");
            sqlQueryObject.addSelectField("accordi", "privato");
            sqlQueryObject.addSelectField("accordi", "ora_registrazione");
            sqlQueryObject.addSelectField("accordi", "id_referente");
            sqlQueryObject.addSelectField("accordi", "utente_richiedente");
            sqlQueryObject.addSelectField("accordi", "data_creazione");
            sqlQueryObject.addSelectField("accordi", "utente_ultima_modifica");
            sqlQueryObject.addSelectField("accordi", "data_ultima_modifica");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addSelectField("accordi", "versione");
            sqlQueryObject.addSelectField("accordi", "stato");
            sqlQueryObject.addSelectField("accordi", "canale");
            sqlQueryObject.addWhereCondition("accordi.id = ?");
            sqlQueryObject.addWhereCondition("accordi.id_referente = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordo));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComuneSintetico] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordo));
            }
            accordoServizio = new AccordoServizioParteComuneSintetico();
            accordoServizio.setId(rs.getLong("id"));
            tmp = rs.getString("nome");
            accordoServizio.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("descrizione");
            accordoServizio.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("service_binding");
            accordoServizio.setServiceBinding(DriverRegistroServiziDB_LIB.getEnumServiceBinding(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("profilo_collaborazione");
            accordoServizio.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
            if (accordoServizio.getProfiloCollaborazione() == null) {
                accordoServizio.setProfiloCollaborazione(ProfiloCollaborazione.ONEWAY);
            }
            accordoServizio.setFormatoSpecifica(DriverRegistroServiziDB_LIB.getEnumFormatoSpecifica((tmp = rs.getString("formato_specifica")) == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("wsdl_definitorio");
            accordoServizio.setByteWsdlDefinitorio(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_concettuale");
            accordoServizio.setByteWsdlConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_logico_erogatore");
            accordoServizio.setByteWsdlLogicoErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_logico_fruitore");
            accordoServizio.setByteWsdlLogicoFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("spec_conv_concettuale");
            accordoServizio.setByteSpecificaConversazioneConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("spec_conv_erogatore");
            accordoServizio.setByteSpecificaConversazioneErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("spec_conv_fruitore");
            accordoServizio.setByteSpecificaConversazioneFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            accordoServizio.setUtilizzoSenzaAzione(rs.getInt("utilizzo_senza_azione") == 1);
            tmp = rs.getString("superuser");
            accordoServizio.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                accordoServizio.setPrivato(true);
            } else {
                accordoServizio.setPrivato(false);
            }
            if (rs.getTimestamp("ora_registrazione") != null) {
                accordoServizio.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            if (rs.getLong("id_referente") > 0L) {
                IdSoggetto assr = new IdSoggetto();
                assr.setTipo(rs.getString("tipo_soggetto"));
                assr.setNome(rs.getString("nome_soggetto"));
                assr.setId(rs.getLong("id_referente"));
                accordoServizio.setSoggettoReferente(assr);
            }
            if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                accordoServizio.setVersione(rs.getInt("versione"));
            }
            accordoServizio.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
            String canale = rs.getString("canale");
            accordoServizio.setCanale(canale);
            accordoServizio.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggettoSintetico(rs, false));
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("correlata");
            sqlQueryObject.addSelectField("profilo_azione");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordo));
            rs = stm.executeQuery();
            AzioneSintetica azione = null;
            while (rs.next()) {
                azione = new AzioneSintetica();
                tmp = rs.getString("nome");
                azione.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                azione.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("correlata");
                azione.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_azione");
                if (tmp == null || tmp.equals("")) {
                    azione.setProfAzione("default");
                } else {
                    azione.setProfAzione(tmp);
                }
                long idAzione = rs.getLong("id");
                azione.setId(idAzione);
                accordoServizio.getAzione().add(azione);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("profilo_collaborazione");
            sqlQueryObject.addSelectField("profilo_pt");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordo));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortTypeSintetico pt = new PortTypeSintetico();
                tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                pt.setIdAccordo(idAccordo);
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                accordoServizio.getPortType().add(pt);
            }
            rs.close();
            stm.close();
            if (!accordoServizio.getPortType().isEmpty()) {
                for (PortTypeSintetico pt : accordoServizio.getPortType()) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.addSelectField("profilo_collaborazione");
                    sqlQueryObject.addSelectField("correlata_servizio");
                    sqlQueryObject.addSelectField("correlata");
                    sqlQueryObject.addSelectField("profilo_pt_azione");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("id_port_type = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("nome");
                    sqlQueryObject.setSortType(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, pt.getId());
                    this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, pt.getId()));
                    rs = stm.executeQuery();
                    OperationSintetica azionePT = null;
                    while (rs.next()) {
                        azionePT = new OperationSintetica();
                        tmp = rs.getString("nome");
                        azionePT.setNome(tmp == null || tmp.equals("") ? null : tmp);
                        tmp = rs.getString("profilo_collaborazione");
                        azionePT.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                        tmp = rs.getString("correlata_servizio");
                        azionePT.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                        tmp = rs.getString("correlata");
                        azionePT.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                        tmp = rs.getString("profilo_pt_azione");
                        if (tmp == null || tmp.equals("")) {
                            azionePT.setProfAzione("default");
                        } else {
                            azionePT.setProfAzione(tmp);
                        }
                        azionePT.setIdPortType(pt.getId());
                        long idAzionePortType = rs.getLong("id");
                        azionePT.setId(idAzionePortType);
                        pt.getAzione().add(azionePT);
                    }
                    rs.close();
                    stm.close();
                }
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteComuneSintetico] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        sqlQueryObject.addFromTable("api_resources");
        sqlQueryObject.addSelectField("nome");
        sqlQueryObject.addSelectField("descrizione");
        sqlQueryObject.addSelectField("http_method");
        sqlQueryObject.addSelectField("path");
        sqlQueryObject.addSelectField("profilo_azione");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addWhereCondition("id_accordo = ?");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addOrderBy("path");
        sqlQueryObject.addOrderBy("http_method");
        sqlQueryObject.setSortType(true);
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idAccordo);
        this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordo));
        rs = stm.executeQuery();
        while (rs.next()) {
            ResourceSintetica resource = new ResourceSintetica();
            tmp = rs.getString("nome");
            resource.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("descrizione");
            resource.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("http_method");
            resource.setMethod(DriverRegistroServiziDB_LIB.getEnumHttpMethod(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("path");
            if (tmp != null && !"*".equals(tmp.trim())) {
                resource.setPath(tmp);
            }
            if ((tmp = rs.getString("profilo_azione")) == null || tmp.equals("")) {
                resource.setProfAzione("default");
            } else {
                resource.setProfAzione(tmp);
            }
            resource.setIdAccordo(idAccordo);
            long idResource = rs.getLong("id");
            resource.setId(idResource);
            accordoServizio.getResource().add(resource);
        }
        rs.close();
        stm.close();
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        sqlQueryObject.addFromTable("accordi_gruppi");
        sqlQueryObject.addFromTable("gruppi");
        sqlQueryObject.addSelectAliasField("gruppi", "id", "identificativoGruppo");
        sqlQueryObject.addSelectAliasField("gruppi", "nome", "nomeGruppo");
        sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo = gruppi.id");
        sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo = ?");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addOrderBy("gruppi.nome");
        sqlQueryObject.setSortType(true);
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idAccordo);
        this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordo));
        rs = stm.executeQuery();
        while (rs.next()) {
            GruppoSintetico gruppo = new GruppoSintetico();
            gruppo.setId(rs.getLong("identificativoGruppo"));
            gruppo.setNome(rs.getString("nomeGruppo"));
            accordoServizio.getGruppo().add(gruppo);
        }
        rs.close();
        stm.close();
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        sqlQueryObject.addFromTable("acc_serv_composti");
        sqlQueryObject.addSelectField("*");
        sqlQueryObject.addWhereCondition("id_accordo = ?");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQuery = sqlQueryObject.createSQLQuery();
        stm = con.prepareStatement(sqlQuery);
        stm.setLong(1, idAccordo);
        this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordo));
        rs = stm.executeQuery();
        AccordoServizioParteComuneServizioCompostoSintetico asComposto = null;
        if (rs.next()) {
            asComposto = new AccordoServizioParteComuneServizioCompostoSintetico();
            asComposto.setId(rs.getLong("id"));
            asComposto.setIdAccordoCooperazione(rs.getLong("id_accordo_cooperazione"));
            IDAccordoCooperazione idAccordoCooperazione = this.driver.getIdAccordoCooperazione(asComposto.getIdAccordoCooperazione(), con);
            String uriAccordo = this.driver.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoCooperazione);
            asComposto.setAccordoCooperazione(uriAccordo);
        }
        rs.close();
        stm.close();
        if (asComposto != null) {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio_composto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, asComposto.getId());
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, asComposto.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                AccordoServizioParteComuneServizioCompostoServizioComponenteSintetico asComponente = new AccordoServizioParteComuneServizioCompostoServizioComponenteSintetico();
                asComponente.setIdServizioComponente(rs.getLong("id_servizio_componente"));
                asComponente.setAzione(rs.getString("azione"));
                AccordoServizioParteSpecifica aspsServizioComponente = this.driver.getAccordoServizioParteSpecifica((long)asComponente.getIdServizioComponente(), con);
                asComponente.setTipo(aspsServizioComponente.getTipo());
                asComponente.setNome(aspsServizioComponente.getNome());
                asComponente.setVersione(aspsServizioComponente.getVersione());
                asComponente.setTipoSoggetto(aspsServizioComponente.getTipoSoggettoErogatore());
                asComponente.setNomeSoggetto(aspsServizioComponente.getNomeSoggettoErogatore());
                asComposto.getServizioComponente().add(asComponente);
            }
            rs.close();
            stm.close();
            accordoServizio.setServizioComposto(asComposto);
        }
        AccordoServizioParteComuneSintetico accordoServizioParteComuneSintetico = accordoServizio;
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return accordoServizioParteComuneSintetico;
    }

    protected List<AccordoServizioParteComuneSintetico> accordiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, false);
    }

    protected List<AccordoServizioParteComuneSintetico> accordiServizioParteComuneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, true);
    }

    protected List<AccordoServizioParteComuneSintetico> accordiServizioCompostiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, true, false);
    }

    private List<AccordoServizioParteComuneSintetico> accordiListEngine(String superuser, ISearch ricerca, boolean excludeASParteComune, boolean excludeASComposti) throws DriverRegistroServiziException {
        ArrayList<AccordoServizioParteComuneSintetico> arrayList;
        String nomeMetodo = "accordiList";
        int idLista = Liste.ACCORDI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        boolean searchByTipoSoggetto = tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0;
        String filterTipoAPI = SearchUtils.getFilter(ricerca, idLista, "filtroServiceBinding");
        String filterStatoAccordo = SearchUtils.getFilter(ricerca, idLista, "filtroStatoAccordo");
        String filterGruppo = SearchUtils.getFilter(ricerca, idLista, "filtroGruppo");
        String filterCanale = SearchUtils.getFilter(ricerca, idLista, "filtroCanale");
        String filtroModISicurezzaCanale = SearchUtils.getFilter(ricerca, idLista, "filtroModiSicCanale");
        String filtroModISicurezzaMessaggio = SearchUtils.getFilter(ricerca, idLista, "filtroModiSicMessaggio");
        String filtroModISorgenteToken = SearchUtils.getFilter(ricerca, idLista, "filtroModiGenToken");
        String filtroModIDigestRichiesta = SearchUtils.getFilter(ricerca, idLista, "filtroModiDigestRich");
        String filtroModIDPoP = SearchUtils.getFilter(ricerca, idLista, "filtroModiDPoP");
        String filtroModIInfoUtente = SearchUtils.getFilter(ricerca, idLista, "filtroModiInfoUtente");
        if (filtroModISicurezzaCanale != null && "".equals(filtroModISicurezzaCanale)) {
            filtroModISicurezzaCanale = null;
        }
        if (filtroModISicurezzaMessaggio != null && "".equals(filtroModISicurezzaMessaggio)) {
            filtroModISicurezzaMessaggio = null;
        }
        if (filtroModISorgenteToken != null && "".equals(filtroModISorgenteToken)) {
            filtroModISorgenteToken = null;
        }
        Boolean filtroModIDigestRichiestaEnabled = null;
        if ("abilitato".equals(filtroModIDigestRichiesta)) {
            filtroModIDigestRichiestaEnabled = true;
        } else if ("disabilitato".equals(filtroModIDigestRichiesta)) {
            filtroModIDigestRichiestaEnabled = false;
        }
        Boolean filtroModIDPoPEnabled = null;
        if ("abilitato".equals(filtroModIDPoP)) {
            filtroModIDPoPEnabled = true;
        } else if ("disabilitato".equals(filtroModIDPoP)) {
            filtroModIDPoPEnabled = false;
        }
        if (filtroModIInfoUtente != null && "".equals(filtroModIInfoUtente)) {
            filtroModIInfoUtente = null;
        }
        boolean filtroModI = filtroModISicurezzaCanale != null || filtroModISicurezzaMessaggio != null || filtroModISorgenteToken != null || filtroModIDigestRichiestaEnabled != null || filtroModIDPoPEnabled != null || filtroModIInfoUtente != null;
        boolean searchCanale = false;
        boolean canaleDefault = false;
        if (filterCanale != null && !filterCanale.equals("")) {
            searchCanale = true;
            if (filterCanale.startsWith("__DEFAULT__ ")) {
                filterCanale = filterCanale.substring("__DEFAULT__ ".length());
                canaleDefault = true;
            }
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterTipoAPI : " + filterTipoAPI);
        this.driver.logDebug("filterStatoAccordo : " + filterStatoAccordo);
        this.driver.logDebug("filterGruppo : " + filterGruppo);
        this.driver.logDebug("filterCanale : " + filterCanale);
        this.driver.logDebug("filtroModISicurezzaCanale : " + filtroModISicurezzaCanale);
        this.driver.logDebug("filtroModISicurezzaMessaggio : " + filtroModISicurezzaMessaggio);
        this.driver.logDebug("filtroModISorgenteToken : " + filtroModISorgenteToken);
        this.driver.logDebug("filtroModIDigestRichiesta : " + filtroModIDigestRichiesta);
        this.driver.logDebug("filtroModIInfoUtente : " + filtroModIInfoUtente);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComuneSintetico> lista = new ArrayList<AccordoServizioParteComuneSintetico>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiListEngine");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            if (excludeASComposti && excludeASParteComune) {
                throw new Exception("Non e' possibile invocare il metodo accordiListEngine con entrambi i parametri excludeASParteComune,excludeASComposti impostati al valore true");
            }
            ISQLQueryObject sqlQueryObjectExclude = null;
            if (excludeASComposti || excludeASParteComune) {
                sqlQueryObjectExclude = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExclude.addFromTable("acc_serv_composti");
                sqlQueryObjectExclude.addSelectField("acc_serv_composti", "id_accordo");
                sqlQueryObjectExclude.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.superuser = ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("accordi.nome", search, true, true)});
            }
            if (searchByTipoSoggetto) {
                sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.service_binding = ?");
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.stato = ?");
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                sqlQueryObject.addFromTable("accordi_gruppi");
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                sqlQueryObject.addWhereCondition("gruppi.nome = ?");
            }
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            if (searchCanale) {
                if (canaleDefault) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"accordi.canale = ?", "accordi.canale is null"});
                } else {
                    sqlQueryObject.addWhereCondition("accordi.canale = ?");
                }
            }
            if (filtroModI) {
                DBUtils.setFiltriModI(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIDPoPEnabled, filtroModIInfoUtente);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                stmt.setString(index++, filterTipoAPI);
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                stmt.setString(index++, filterGruppo);
            }
            if (searchCanale) {
                stmt.setString(index++, filterCanale);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("accordi", "id", "idAccordo");
            sqlQueryObject.addSelectAliasField("accordi", "nome", "nomeAccordo");
            sqlQueryObject.addSelectField("accordi", "versione");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.superuser = ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("accordi.nome", search, true, true)});
            }
            if (searchByTipoSoggetto) {
                sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.service_binding = ?");
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.stato = ?");
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                sqlQueryObject.addFromTable("accordi_gruppi");
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                sqlQueryObject.addWhereCondition("gruppi.nome = ?");
            }
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            if (searchCanale) {
                if (canaleDefault) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"accordi.canale = ?", "accordi.canale is null"});
                } else {
                    sqlQueryObject.addWhereCondition("accordi.canale = ?");
                }
            }
            if (filtroModI) {
                DBUtils.setFiltriModI(sqlQueryObject, this.driver.tipoDB, filtroModISicurezzaCanale, filtroModISicurezzaMessaggio, filtroModISorgenteToken, filtroModIDigestRichiestaEnabled, filtroModIDPoPEnabled, filtroModIInfoUtente);
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nomeAccordo");
            sqlQueryObject.addOrderBy("versione");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                stmt.setString(index++, filterTipoAPI);
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                stmt.setString(index++, filterGruppo);
            }
            if (searchCanale) {
                stmt.setString(index++, filterCanale);
            }
            risultato = stmt.executeQuery();
            AccordoServizioParteComuneSintetico accordo = null;
            while (risultato.next()) {
                Long id = risultato.getLong("idAccordo");
                accordo = this.getAccordoServizioParteComuneSintetico(id, con);
                lista.add(accordo);
            }
            this.driver.logDebug("size lista :" + (lista == null ? null : Integer.valueOf(lista.size())));
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

