/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_utilsDriver;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_gruppiDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_gruppiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Gruppo getGruppo(IDGruppo idGruppo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Gruppo gruppo;
        this.driver.logDebug("richiesto getGruppo: " + String.valueOf(idGruppo));
        if (idGruppo == null) {
            throw new DriverRegistroServiziException("[getGruppo] Parametro idGruppo is null");
        }
        if (idGruppo.getNome() == null || idGruppo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getGruppo] Parametro idGruppo.nome non e' definito");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getGruppo(nome)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getGruppo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("gruppi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setString(1, idGruppo.getNome());
            rs = stm.executeQuery();
            Gruppo gruppo2 = null;
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getGruppo] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idGruppo.getNome()));
            }
            gruppo2 = new Gruppo();
            gruppo2.setId(rs.getLong("id"));
            gruppo2.setNome(rs.getString("nome"));
            gruppo2.setDescrizione(rs.getString("descrizione"));
            String serviceBinding = rs.getString("service_binding");
            if (serviceBinding != null) {
                gruppo2.setServiceBinding(ServiceBinding.toEnumConstant(serviceBinding));
            }
            gruppo2.setSuperUser(rs.getString("superuser"));
            if (rs.getTimestamp("ora_registrazione") != null) {
                gruppo2.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            gruppo2.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggetto(rs, false));
            gruppo = gruppo2;
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getGruppo] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getGruppo] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return gruppo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Gruppo getGruppo(long idGruppo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getGruppo: " + idGruppo);
        if (idGruppo <= 0L) {
            throw new DriverRegistroServiziException("[getGruppo] Parametro idGruppo non valido");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getGruppo(id)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getGruppo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        IDGruppo idGruppoObject = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("gruppi");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addWhereCondition("id = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idGruppo);
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getGruppo] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idGruppo));
            }
            idGruppoObject = new IDGruppo(rs.getString("nome"));
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getGruppo] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getGruppo] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return this.getGruppo(idGruppoObject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDGruppo> getAllIdGruppi(FiltroRicercaGruppi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDGruppo> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean filtroRicercaTipo = false;
        if (filtroRicerca != null) {
            filtroRicercaTipo = filtroRicerca.getServiceBinding() != null;
        }
        List<String> tipoSoggettiProtocollo = null;
        try {
            if (filtroRicerca != null && (filtroRicerca.getProtocollo() != null || filtroRicerca.getProtocolli() != null && !filtroRicerca.getProtocolli().isEmpty())) {
                tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filtroRicerca.getProtocollo(), Filtri.convertToString(filtroRicerca.getProtocolli()));
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        boolean searchByTipoSoggetto = tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty();
        this.driver.logDebug("getAllIdGruppi...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdGruppi") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("gruppi");
            if (searchByTipoSoggetto) {
                sqlQueryObject.addFromTable("accordi_gruppi");
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addFromTable("soggetti");
            }
            sqlQueryObject.addSelectField("gruppi", "nome");
            if (searchByTipoSoggetto) {
                sqlQueryObject.setSelectDistinct(true);
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("gruppi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("gruppi.ora_registrazione < ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("gruppi.nome = ?");
                }
                if (filtroRicercaTipo) {
                    ISQLQueryObject sqlQueryObjectServiceBinding = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectServiceBinding.addWhereIsNullCondition("gruppi.service_binding");
                    sqlQueryObjectServiceBinding.addWhereCondition("gruppi.service_binding= ?");
                    sqlQueryObjectServiceBinding.setANDLogicOperator(false);
                    sqlQueryObject.addWhereCondition(sqlQueryObjectServiceBinding.createSQLConditions());
                }
                if (searchByTipoSoggetto) {
                    sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                    sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                    sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
                    sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                if (filtroRicerca.isOrdinaDataRegistrazione()) {
                    sqlQueryObject.addOrderBy("gruppi.ora_registrazione");
                }
                sqlQueryObject.addOrderBy("gruppi.nome");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMinDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMaxDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicercaTipo) {
                    this.driver.logDebug("serviceBinding stmt.setString(" + filtroRicerca.getServiceBinding().getValue() + ")");
                    stm.setString(indexStmt, filtroRicerca.getServiceBinding().getValue());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            ArrayList<IDGruppo> nomiGruppi = new ArrayList<IDGruppo>();
            while (rs.next()) {
                nomiGruppi.add(new IDGruppo(rs.getString("nome")));
            }
            if (nomiGruppi.isEmpty()) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Gruppi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Gruppi non trovati");
            }
            arrayList = nomiGruppi;
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException("getAllIdGruppi error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void createGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createGruppo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createGruppo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createGruppo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGruppo type = 1");
            DriverRegistroServiziDB_LIB.CRUDGruppo(1, gruppo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createGruppo] Errore durante la creazione del gruppo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsGruppo(IDGruppo idGruppo) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (idGruppo == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (idGruppo.getNome() == null || idGruppo.getNome().equals("")) {
            throw new DriverRegistroServiziException("Parametro vuoto non valido");
        }
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsGruppo");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsGruppo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("gruppi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idGruppo.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza gruppo: " + e.getMessage(), (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        return exist;
    }

    protected void updateGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateGruppo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateGruppo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateGruppo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGruppo type = 2");
            DriverRegistroServiziDB_LIB.CRUDGruppo(2, gruppo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateGruppo] Errore durante l'aggiornamento del gruppo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteGruppo(Gruppo gruppo) throws DriverRegistroServiziException {
        if (gruppo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteGruppo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteGruppo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteGruppo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDGruppo type = 3");
            DriverRegistroServiziDB_LIB.CRUDGruppo(3, gruppo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteGruppo] Errore durante l'eliminazione del gruppo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected List<Gruppo> gruppiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "gruppiList";
        int idLista = Liste.GRUPPI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterServiceBinding = SearchUtils.getFilter(ricerca, idLista, "filtroServiceBinding");
        ServiceBinding serviceBinding = null;
        if (filterServiceBinding != null) {
            serviceBinding = ServiceBinding.toEnumConstant(filterServiceBinding);
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Gruppo> lista = new ArrayList<Gruppo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("gruppiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<IDGruppo> listIdGruppi = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObjectServiceBinding = null;
            if (serviceBinding != null) {
                sqlQueryObjectServiceBinding = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectServiceBinding.addWhereIsNullCondition("service_binding");
                sqlQueryObjectServiceBinding.addWhereCondition("service_binding= ?");
                sqlQueryObjectServiceBinding.setANDLogicOperator(false);
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (serviceBinding != null) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectServiceBinding.createSQLConditions());
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (serviceBinding != null) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectServiceBinding.createSQLConditions());
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (serviceBinding != null) {
                stmt.setString(index++, serviceBinding.getValue());
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addSelectField("nome");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (serviceBinding != null) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectServiceBinding.createSQLConditions());
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addSelectField("nome");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (serviceBinding != null) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectServiceBinding.createSQLConditions());
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (serviceBinding != null) {
                stmt.setString(index++, serviceBinding.getValue());
            }
            risultato = stmt.executeQuery();
            listIdGruppi = new ArrayList<IDGruppo>();
            while (risultato.next()) {
                listIdGruppi.add(new IDGruppo(risultato.getString("nome")));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        if (listIdGruppi != null) {
            for (IDGruppo idGruppo : listIdGruppi) {
                try {
                    lista.add(this.getGruppo(idGruppo));
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new DriverRegistroServiziException(notFound.getMessage(), notFound);
                }
            }
        }
        return lista;
    }
}

