/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.test.TestEnumerations;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.JavaDate;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.JavaDeserializer;
import org.openspcoop2.utils.serialization.JavaSerializer;
import org.openspcoop2.utils.serialization.JsonJacksonDeserializer;
import org.openspcoop2.utils.serialization.JsonJacksonSerializer;
import org.openspcoop2.utils.serialization.SerializationConfig;
import org.slf4j.Logger;

public class SerializationClientTest {
    private static Logger log = null;

    public static void main(String[] args) throws Exception {
        SerializationClientTest.test(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String ... params) throws Exception {
        int i;
        Object[] vJsonArray;
        FileInputStream finJson;
        FileOutputStream foutJson;
        Object oJsonRead;
        JsonJacksonDeserializer jsonDeserializer;
        FileInputStream finJava;
        FileOutputStream foutJava;
        Object oJavaRead;
        JavaDeserializer javaDeserializer;
        File logFile = File.createTempFile("testSerializzazione_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration((Level)Level.ALL, (boolean)false, null, (File)logFile, (String)"%m %n");
        log = LoggerWrapperFactory.getLogger(SerializationClientTest.class);
        IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
        long dataInizio = -1L;
        long dataFine = -1L;
        File dir = new File(".");
        if (params != null && params.length > 0) {
            dir = new File(params[0].trim());
            if (dir.exists()) {
                if (dir.isDirectory()) {
                    throw new Exception("Directory [" + dir.getAbsolutePath() + "] gia' esistente");
                }
                throw new Exception("Location [" + dir.getAbsolutePath() + "] gia' esistente e inoltre non e' una directory");
            }
            if (!dir.mkdir()) {
                throw new Exception("Directory [" + dir.getAbsolutePath() + "] non creabile");
            }
        }
        log.info("Directory '" + dir.getAbsolutePath() + "'");
        DateManager.initializeDataManager((String)JavaDate.class.getName(), (Properties)new Properties(), null);
        Soggetto soggettoTest = new Soggetto();
        soggettoTest.setTipo("SPC");
        soggettoTest.setNome("SoggettoTest");
        soggettoTest.setCodiceIpa("o=test,c=it");
        soggettoTest.setIdentificativoPorta("PROVAID");
        soggettoTest.setDescrizione("Test package");
        soggettoTest.setOraRegistrazione(DateManager.getDate());
        soggettoTest.setPortaDominio("pdd");
        soggettoTest.setPrivato(false);
        soggettoTest.setVersioneProtocollo("linee guida");
        soggettoTest.setSuperUser("amministratore");
        Connettore connettore = new Connettore();
        connettore.setNome("ConnettoreTest");
        connettore.setTipo("http");
        Property pr = new Property();
        pr.setNome("location");
        pr.setValore("http://localhost:8080/govway/in");
        connettore.addProperty(pr);
        Property pr2 = new Property();
        pr2.setNome("location2");
        pr2.setValore("http://localhost:8080/govway/in");
        connettore.addProperty(pr2);
        soggettoTest.setConnettore(connettore);
        AccordoServizioParteComune as = new AccordoServizioParteComune();
        as.setNome("ASTEST");
        as.setVersione(1);
        IdSoggetto sogg = new IdSoggetto();
        sogg.setTipo("SPC");
        sogg.setNome("SoggettoReferente");
        as.setSoggettoReferente(sogg);
        as.setByteWsdlDefinitorio("<xsd>TEST<xsd>".getBytes());
        as.setByteWsdlConcettuale("<wsdl>TEST<wsdl>".getBytes());
        as.setByteWsdlLogicoErogatore("<wsdl>TEST<wsdl>".getBytes());
        as.setByteSpecificaConversazioneConcettuale("<spe>TEST</spe>".getBytes());
        as.setByteSpecificaConversazioneErogatore("<spe>TEST</spe>".getBytes());
        as.setByteSpecificaConversazioneFruitore("<spe>TEST</spe>".getBytes());
        as.setPrivato(false);
        Documento allegato1 = new Documento();
        allegato1.setFile("TEST.txt");
        allegato1.setByteContenuto("TEST HELLO WORLD".getBytes());
        as.addAllegato(allegato1);
        Soggetto s1 = (Soggetto)soggettoTest.clone();
        s1.setNome("SoggettoTest1");
        Soggetto s2 = (Soggetto)soggettoTest.clone();
        s2.setNome("SoggettoTest2");
        Soggetto s3 = (Soggetto)soggettoTest.clone();
        s3.setNome("SoggettoTest3");
        Soggetto s4 = (Soggetto)soggettoTest.clone();
        s4.setNome("SoggettoTest4");
        Soggetto s5 = (Soggetto)soggettoTest.clone();
        s5.setNome("SoggettoTest5");
        Soggetto s6 = (Soggetto)soggettoTest.clone();
        s6.setNome("SoggettoTest6");
        Soggetto s7 = (Soggetto)soggettoTest.clone();
        s7.setNome("SoggettoTest7");
        ArrayList<String> excludesJsonSoggetto = new ArrayList<String>();
        excludesJsonSoggetto.add("servizio");
        excludesJsonSoggetto.add("servizioCorrelato");
        excludesJsonSoggetto.add("property");
        ArrayList<String> excludesJsonAccordiServizio = new ArrayList<String>();
        excludesJsonAccordiServizio.add("specificaSemiformale");
        excludesJsonAccordiServizio.add("allegato");
        excludesJsonAccordiServizio.add("azione");
        excludesJsonAccordiServizio.add("portType");
        ArrayList<String> excludesJson_date = new ArrayList<String>();
        excludesJson_date.add("day");
        excludesJson_date.add("timezoneOffset");
        LinkedList<BaseBeanWithId> testSerializzazioneLista = new LinkedList<BaseBeanWithId>();
        testSerializzazioneLista.add(as);
        testSerializzazioneLista.add(s1);
        testSerializzazioneLista.add(s2);
        testSerializzazioneLista.add(s3);
        testSerializzazioneLista.add(s4);
        testSerializzazioneLista.add(s5);
        testSerializzazioneLista.add(s6);
        testSerializzazioneLista.add(s7);
        LinkedList<Soggetto> testSerializzazioneListaSoggetti = new LinkedList<Soggetto>();
        testSerializzazioneListaSoggetti.add(s1);
        testSerializzazioneListaSoggetti.add(s2);
        testSerializzazioneListaSoggetti.add(s3);
        testSerializzazioneListaSoggetti.add(s4);
        testSerializzazioneListaSoggetti.add(s5);
        testSerializzazioneListaSoggetti.add(s6);
        testSerializzazioneListaSoggetti.add(s7);
        LinkedList<AccordoServizioParteComune> testSerializzazioneListaAccordi = new LinkedList<AccordoServizioParteComune>();
        testSerializzazioneListaAccordi.add(as);
        HashSet<BaseBeanWithId> testSerializzazioneSet = new HashSet<BaseBeanWithId>();
        testSerializzazioneSet.add(as);
        testSerializzazioneSet.add(s1);
        testSerializzazioneSet.add(s2);
        testSerializzazioneSet.add(s3);
        testSerializzazioneSet.add(s4);
        testSerializzazioneSet.add(s5);
        testSerializzazioneSet.add(s6);
        testSerializzazioneSet.add(s7);
        HashSet<Soggetto> testSerializzazioneSetSoggetti = new HashSet<Soggetto>();
        testSerializzazioneSetSoggetti.add(s1);
        testSerializzazioneSetSoggetti.add(s2);
        testSerializzazioneSetSoggetti.add(s3);
        testSerializzazioneSetSoggetti.add(s4);
        testSerializzazioneSetSoggetti.add(s5);
        testSerializzazioneSetSoggetti.add(s6);
        testSerializzazioneSetSoggetti.add(s7);
        HashSet<AccordoServizioParteComune> testSerializzazioneSetAccordi = new HashSet<AccordoServizioParteComune>();
        testSerializzazioneSetAccordi.add(as);
        log.info("\n");
        log.info("********** Serializzazione Java (SingleObject) ****************");
        log.info("\n");
        File javaFileStream = new File(dir, "singleObjectStream.ser");
        try {
            FileOutputStream foutJava2 = new FileOutputStream(javaFileStream);
            FileInputStream finJava2 = new FileInputStream(javaFileStream);
            log.info("- Serializzazione (Stream in/out): ");
            JavaSerializer javaSerializer = new JavaSerializer();
            dataInizio = DateManager.getTimeMillis();
            javaSerializer.writeObject((Object)soggettoTest, (OutputStream)foutJava2);
            dataFine = DateManager.getTimeMillis();
            foutJava2.flush();
            foutJava2.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)javaFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Stream in/out): ");
            javaDeserializer = new JavaDeserializer();
            dataInizio = DateManager.getTimeMillis();
            oJavaRead = javaDeserializer.readObject((InputStream)finJava2, soggettoTest.getClass());
            dataFine = DateManager.getTimeMillis();
            finJava2.close();
            SerializationClientTest.equals(soggettoTest, (Soggetto)oJavaRead, dir, false);
            log.info("- OK, nome soggetto: " + ((Soggetto)oJavaRead).getTipo() + "/" + ((Soggetto)oJavaRead).getNome());
            log.info("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(javaFileStream.toPath());
        }
        File javaFileReader = new File(dir, "singleObjectReader.ser");
        try {
            FileWriter fwriterJava = new FileWriter(javaFileReader);
            FileReader freaderJava = new FileReader(javaFileReader);
            log.info("- Serializzazione (Reader/Writer): ");
            JavaSerializer javaSerializer = new JavaSerializer();
            dataInizio = DateManager.getTimeMillis();
            javaSerializer.writeObject((Object)as, (Writer)fwriterJava);
            dataFine = DateManager.getTimeMillis();
            fwriterJava.flush();
            fwriterJava.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)javaFileReader.length()));
            log.info("\n");
            log.info("- Deserializzazione (Reader/Writer): ");
            JavaDeserializer javaDeserializer2 = new JavaDeserializer();
            dataInizio = DateManager.getTimeMillis();
            Object oJavaRead2 = javaDeserializer2.readObject((Reader)freaderJava, as.getClass());
            dataFine = DateManager.getTimeMillis();
            freaderJava.close();
            SerializationClientTest.equals(as, (AccordoServizioParteComune)oJavaRead2, dir);
            log.info("- OK, accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)oJavaRead2) + " allegati:(" + ((AccordoServizioParteComune)oJavaRead2).sizeAllegatoList() + ")");
            log.info("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(javaFileReader.toPath());
        }
        log.info("- Serializzazione (Object): ");
        JavaSerializer javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        String javaSerializationObject = javaSerializer.getObject((Object)as);
        dataFine = DateManager.getTimeMillis();
        log.info("- OK");
        log.info("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)javaFileStream.length()));
        log.info("\n");
        log.info("- Deserializzazione (Object): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.getObject(javaSerializationObject, as.getClass());
        dataFine = DateManager.getTimeMillis();
        SerializationClientTest.equals(as, (AccordoServizioParteComune)oJavaRead, dir);
        log.info("- OK, accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)oJavaRead) + " allegati:(" + ((AccordoServizioParteComune)oJavaRead).sizeAllegatoList() + ")");
        log.info("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("\n");
        log.info("- Serializzazione (Enumerations): ");
        javaSerializer = new JavaSerializer();
        dataInizio = DateManager.getTimeMillis();
        javaSerializationObject = javaSerializer.getObject((Object)TestEnumerations.VALORE1);
        dataFine = DateManager.getTimeMillis();
        log.info("- OK");
        log.info("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)javaFileStream.length()));
        log.info("\n");
        log.info("- Deserializzazione (Enumerations): ");
        javaDeserializer = new JavaDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJavaRead = javaDeserializer.getObject(javaSerializationObject, TestEnumerations.class);
        dataFine = DateManager.getTimeMillis();
        if (!((TestEnumerations)((Object)oJavaRead)).toString().equals(TestEnumerations.VALORE1.toString())) {
            throw new Exception("Enumeration originale [" + TestEnumerations.VALORE1.toString() + "] e ricostruita[" + ((TestEnumerations)((Object)oJavaRead)).toString() + "] differiscono");
        }
        log.info("- OK, enum value: " + String.valueOf(oJavaRead));
        log.info("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("\n");
        log.info("\n");
        log.info("********** Serializzazione Java (Array/List/Set) ****************");
        log.info("\n");
        javaFileStream = new File(dir, "array.ser");
        try {
            foutJava = new FileOutputStream(javaFileStream);
            finJava = new FileInputStream(javaFileStream);
            log.info("- Serializzazione (Array): ");
            javaSerializer = new JavaSerializer();
            dataInizio = DateManager.getTimeMillis();
            javaSerializer.writeObject((Object)testSerializzazioneLista.toArray(), (OutputStream)foutJava);
            dataFine = DateManager.getTimeMillis();
            foutJava.flush();
            foutJava.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)javaFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Array): ");
            javaDeserializer = new JavaDeserializer();
            dataInizio = DateManager.getTimeMillis();
            oJavaRead = javaDeserializer.readObject((InputStream)finJava, testSerializzazioneLista.toArray().getClass());
            dataFine = DateManager.getTimeMillis();
            finJava.close();
            Object[] vJavaArray = (Object[])oJavaRead;
            SerializationClientTest.equalsOpenSPCoopObject(testSerializzazioneLista.toArray(), vJavaArray, dir);
            log.info("- OK, nome soggetto: " + ((Soggetto)vJavaArray[1]).getTipo() + "/" + ((Soggetto)vJavaArray[1]).getNome() + "   nome accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)vJavaArray[0]) + " allegati:(" + ((AccordoServizioParteComune)vJavaArray[0]).sizeAllegatoList() + ")");
            log.info("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(javaFileStream.toPath());
        }
        javaFileStream = new File(dir, "list.ser");
        try {
            foutJava = new FileOutputStream(javaFileStream);
            finJava = new FileInputStream(javaFileStream);
            log.info("- Serializzazione (List): ");
            javaSerializer = new JavaSerializer();
            dataInizio = DateManager.getTimeMillis();
            javaSerializer.writeObject(testSerializzazioneLista, (OutputStream)foutJava);
            dataFine = DateManager.getTimeMillis();
            foutJava.flush();
            foutJava.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)javaFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (List): ");
            javaDeserializer = new JavaDeserializer();
            dataInizio = DateManager.getTimeMillis();
            oJavaRead = javaDeserializer.readObject((InputStream)finJava, testSerializzazioneLista.getClass());
            dataFine = DateManager.getTimeMillis();
            finJava.close();
            List vJavaList = (List)oJavaRead;
            SerializationClientTest.equalsOpenSPCoopObject(testSerializzazioneLista.toArray(), vJavaList.toArray(), dir);
            log.info("- OK, nome soggetto: " + ((Soggetto)vJavaList.get(1)).getTipo() + "/" + ((Soggetto)vJavaList.get(1)).getNome() + "   nome accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)vJavaList.get(0)) + " allegati:(" + ((AccordoServizioParteComune)vJavaList.get(0)).sizeAllegatoList() + ")");
            log.info("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(javaFileStream.toPath());
        }
        javaFileStream = new File(dir, "set.ser");
        try {
            foutJava = new FileOutputStream(javaFileStream);
            finJava = new FileInputStream(javaFileStream);
            log.info("- Serializzazione (Set): ");
            javaSerializer = new JavaSerializer();
            dataInizio = DateManager.getTimeMillis();
            javaSerializer.writeObject(testSerializzazioneSet, (OutputStream)foutJava);
            dataFine = DateManager.getTimeMillis();
            foutJava.flush();
            foutJava.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)javaFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Set): ");
            javaDeserializer = new JavaDeserializer();
            dataInizio = DateManager.getTimeMillis();
            oJavaRead = javaDeserializer.readObject((InputStream)finJava, testSerializzazioneSet.getClass());
            dataFine = DateManager.getTimeMillis();
            finJava.close();
            Set vJavaSet = (Set)oJavaRead;
            SerializationClientTest.equalsOpenSPCoopObject(testSerializzazioneLista.toArray(), vJavaSet.toArray(), dir);
            log.info("- OK, dimensione set: " + vJavaSet.size() + ")");
            log.info("- Costo ms deserializzazione java: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
            log.info("\n");
        }
        finally {
            Files.delete(javaFileStream.toPath());
        }
        log.info("\n");
        log.info("\n");
        log.info("\n");
        log.info("\n");
        log.info("\n");
        log.info("********** Serializzazione Json (SingleObject) ****************");
        log.info("\n");
        File jsonFileStream = new File(dir, "singleObjectStream.json");
        try {
            FileOutputStream foutJson2 = new FileOutputStream(jsonFileStream);
            FileInputStream finJson2 = new FileInputStream(jsonFileStream);
            log.info("- Serializzazione (Stream in/out): ");
            Filter filter = new Filter();
            SerializationConfig config = new SerializationConfig();
            config.setFilter(filter);
            config.setExcludes(excludesJsonSoggetto);
            JsonJacksonSerializer jsonSerializer = new JsonJacksonSerializer(config);
            dataInizio = DateManager.getTimeMillis();
            jsonSerializer.writeObject((Object)soggettoTest, (OutputStream)foutJson2);
            dataFine = DateManager.getTimeMillis();
            foutJson2.flush();
            foutJson2.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)jsonFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Stream in/out): ");
            config = new SerializationConfig();
            config.setExcludes(excludesJson_date);
            jsonDeserializer = new JsonJacksonDeserializer(config);
            dataInizio = DateManager.getTimeMillis();
            oJsonRead = jsonDeserializer.readObject((InputStream)finJson2, soggettoTest.getClass());
            dataFine = DateManager.getTimeMillis();
            finJson2.close();
            Soggetto soggettoTestEquals = (Soggetto)soggettoTest.clone();
            soggettoTestEquals.getConnettore().getPropertyList().clear();
            soggettoTestEquals.setSuperUser(null);
            SerializationClientTest.equals(soggettoTestEquals, (Soggetto)oJsonRead, dir, false);
            log.info("- OK, nome soggetto: " + ((Soggetto)oJsonRead).getTipo() + "/" + ((Soggetto)oJsonRead).getNome());
            log.info("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(jsonFileStream.toPath());
        }
        File jsonFileReader = new File(dir, "singleObjectReader.json");
        try {
            FileWriter fwriterJson = new FileWriter(jsonFileReader);
            FileReader freaderJson = new FileReader(jsonFileReader);
            log.info("- Serializzazione (Reader/Writer): ");
            Filter filter = new Filter();
            SerializationConfig config = new SerializationConfig();
            config.setFilter(filter);
            config.setExcludes(excludesJsonAccordiServizio);
            JsonJacksonSerializer jsonSerializer = new JsonJacksonSerializer(config);
            dataInizio = DateManager.getTimeMillis();
            jsonSerializer.writeObject((Object)as, (Writer)fwriterJson);
            dataFine = DateManager.getTimeMillis();
            fwriterJson.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)jsonFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Reader/Writer): ");
            config = new SerializationConfig();
            config.setExcludes(excludesJson_date);
            JsonJacksonDeserializer jsonDeserializer2 = new JsonJacksonDeserializer(config);
            dataInizio = DateManager.getTimeMillis();
            Object oJsonRead2 = jsonDeserializer2.readObject((Reader)freaderJson, as.getClass());
            dataFine = DateManager.getTimeMillis();
            freaderJson.close();
            AccordoServizioParteComune asEquals = (AccordoServizioParteComune)as.clone();
            asEquals.getAllegatoList().clear();
            SerializationClientTest.equals(asEquals, (AccordoServizioParteComune)oJsonRead2, dir);
            log.info("- OK, accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)oJsonRead2) + " allegati:(" + ((AccordoServizioParteComune)oJsonRead2).sizeAllegatoList() + ")");
            log.info("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(jsonFileReader.toPath());
        }
        log.info("- Serializzazione (Object): ");
        Filter filter = new Filter();
        SerializationConfig config = new SerializationConfig();
        config.setFilter(filter);
        config.setExcludes(excludesJsonAccordiServizio);
        JsonJacksonSerializer jsonSerializer = new JsonJacksonSerializer(config);
        dataInizio = DateManager.getTimeMillis();
        String jsonSerializationObject = jsonSerializer.getObject((Object)as);
        dataFine = DateManager.getTimeMillis();
        log.info("- OK");
        log.info("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)jsonFileStream.length()));
        log.info("\n");
        log.info("- Deserializzazione (Object): ");
        config = new SerializationConfig();
        config.setExcludes(excludesJson_date);
        jsonDeserializer = new JsonJacksonDeserializer(config);
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.getObject(jsonSerializationObject, as.getClass());
        dataFine = DateManager.getTimeMillis();
        AccordoServizioParteComune asEquals = (AccordoServizioParteComune)as.clone();
        asEquals.getAllegatoList().clear();
        SerializationClientTest.equals(asEquals, (AccordoServizioParteComune)oJsonRead, dir);
        log.info("- OK, accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)oJsonRead) + " allegati:(" + ((AccordoServizioParteComune)oJsonRead).sizeAllegatoList() + ")");
        log.info("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("\n");
        jsonFileReader = new File(dir, "singleObjectReader.json");
        try {
            FileWriter fwriterJson = new FileWriter(jsonFileReader);
            FileReader freaderJson = new FileReader(jsonFileReader);
            log.info("- Serializzazione (Reader/Writer) senza esclusioni: ");
            config = new SerializationConfig();
            config.setFilter(filter);
            jsonSerializer = new JsonJacksonSerializer(config);
            dataInizio = DateManager.getTimeMillis();
            jsonSerializer.writeObject((Object)as, (Writer)fwriterJson);
            dataFine = DateManager.getTimeMillis();
            fwriterJson.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)jsonFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Reader/Writer) senza esclusioni: ");
            config = new SerializationConfig();
            config.setExcludes(excludesJson_date);
            jsonDeserializer = new JsonJacksonDeserializer(config);
            dataInizio = DateManager.getTimeMillis();
            oJsonRead = jsonDeserializer.readObject((Reader)freaderJson, as.getClass());
            dataFine = DateManager.getTimeMillis();
            freaderJson.close();
            SerializationClientTest.equals(as, (AccordoServizioParteComune)oJsonRead, dir);
            log.info("- OK, accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)oJsonRead) + " allegati:(" + ((AccordoServizioParteComune)oJsonRead).sizeAllegatoList() + ")");
            log.info("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(jsonFileReader.toPath());
        }
        log.info("- Serializzazione (Enumerations): ");
        config = new SerializationConfig();
        config.setFilter(filter);
        jsonSerializer = new JsonJacksonSerializer(config);
        dataInizio = DateManager.getTimeMillis();
        jsonSerializationObject = jsonSerializer.getObject((Object)TestEnumerations.VALORE1);
        dataFine = DateManager.getTimeMillis();
        log.info("- OK");
        log.info("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)jsonFileStream.length()));
        log.info("\n");
        log.info("- Deserializzazione (Enumerations): ");
        jsonDeserializer = new JsonJacksonDeserializer();
        dataInizio = DateManager.getTimeMillis();
        oJsonRead = jsonDeserializer.getObject(jsonSerializationObject, TestEnumerations.class);
        dataFine = DateManager.getTimeMillis();
        if (!((TestEnumerations)((Object)oJsonRead)).toString().equals(TestEnumerations.VALORE1.toString())) {
            throw new Exception("Enumeration originale [" + TestEnumerations.VALORE1.toString() + "] e ricostruita[" + ((TestEnumerations)((Object)oJsonRead)).toString() + "] differiscono");
        }
        log.info("- OK, enum value: " + String.valueOf(oJsonRead));
        log.info("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
        log.info("\n");
        log.info("\n");
        log.info("********** Serializzazione Json (Array/List/Set) ****************");
        log.info("\n");
        jsonFileStream = new File(dir, "array.accordi.json");
        try {
            foutJson = new FileOutputStream(jsonFileStream);
            finJson = new FileInputStream(jsonFileStream);
            log.info("- Serializzazione (Array)(Accordi): ");
            config = new SerializationConfig();
            config.setFilter(filter);
            config.setExcludes(excludesJsonAccordiServizio);
            jsonSerializer = new JsonJacksonSerializer(config);
            dataInizio = DateManager.getTimeMillis();
            AccordoServizioParteComune[] arrayJsonTestAccordi = testSerializzazioneListaAccordi.toArray(new AccordoServizioParteComune[1]);
            jsonSerializer.writeObject((Object)arrayJsonTestAccordi, (OutputStream)foutJson);
            dataFine = DateManager.getTimeMillis();
            foutJson.flush();
            foutJson.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)jsonFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Array)(Accordi): ");
            config = new SerializationConfig();
            config.setExcludes(excludesJson_date);
            jsonDeserializer = new JsonJacksonDeserializer(config);
            dataInizio = DateManager.getTimeMillis();
            oJsonRead = jsonDeserializer.readObject((InputStream)finJson, AccordoServizioParteComune[].class);
            dataFine = DateManager.getTimeMillis();
            finJson.close();
            vJsonArray = (Object[])oJsonRead;
            AccordoServizioParteComune[] vJsonArrayTestAccordi = new AccordoServizioParteComune[vJsonArray.length];
            for (int i2 = 0; i2 < vJsonArray.length; ++i2) {
                vJsonArrayTestAccordi[i2] = (AccordoServizioParteComune)vJsonArray[i2];
            }
            AccordoServizioParteComune[] arrayJsonTestAccordiEquals = new AccordoServizioParteComune[arrayJsonTestAccordi.length];
            i = 0;
            for (AccordoServizioParteComune accordoServizioParteComune : arrayJsonTestAccordi) {
                arrayJsonTestAccordiEquals[i] = (AccordoServizioParteComune)accordoServizioParteComune.clone();
                arrayJsonTestAccordiEquals[i].getAllegatoList().clear();
                ++i;
            }
            SerializationClientTest.equals(arrayJsonTestAccordiEquals, vJsonArrayTestAccordi, dir);
            log.info("- OK, nome accordo: " + idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)vJsonArray[0]) + " allegati:(" + ((AccordoServizioParteComune)vJsonArray[0]).sizeAllegatoList() + ")");
            log.info("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(jsonFileStream.toPath());
        }
        jsonFileStream = new File(dir, "array.soggetti.json");
        try {
            foutJson = new FileOutputStream(jsonFileStream);
            finJson = new FileInputStream(jsonFileStream);
            log.info("- Serializzazione (Array)(Soggetti): ");
            config = new SerializationConfig();
            config.setFilter(filter);
            config.setExcludes(excludesJsonSoggetto);
            jsonSerializer = new JsonJacksonSerializer(config);
            dataInizio = DateManager.getTimeMillis();
            Soggetto[] arrayJsonTestSoggetti = testSerializzazioneListaSoggetti.toArray(new Soggetto[testSerializzazioneListaSoggetti.size()]);
            jsonSerializer.writeObject((Object)arrayJsonTestSoggetti, (OutputStream)foutJson);
            dataFine = DateManager.getTimeMillis();
            foutJson.flush();
            foutJson.close();
            log.info("- OK");
            log.info("- Costo ms serializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("- Dimensione oggetto serializzato: " + Utilities.convertBytesToFormatString((long)jsonFileStream.length()));
            log.info("\n");
            log.info("- Deserializzazione (Array)(Soggetti): ");
            config = new SerializationConfig();
            config.setExcludes(excludesJson_date);
            jsonDeserializer = new JsonJacksonDeserializer(config);
            dataInizio = DateManager.getTimeMillis();
            oJsonRead = jsonDeserializer.readObject((InputStream)finJson, Soggetto[].class);
            dataFine = DateManager.getTimeMillis();
            finJson.close();
            vJsonArray = (Object[])oJsonRead;
            Soggetto[] vJsonArrayTestSoggetti = new Soggetto[vJsonArray.length];
            for (int i3 = 0; i3 < vJsonArray.length; ++i3) {
                vJsonArrayTestSoggetti[i3] = (Soggetto)vJsonArray[i3];
            }
            Soggetto[] arrayJsonTestSoggettiEquals = new Soggetto[arrayJsonTestSoggetti.length];
            i = 0;
            for (BaseBeanWithId baseBeanWithId : arrayJsonTestSoggetti) {
                arrayJsonTestSoggettiEquals[i] = (Soggetto)baseBeanWithId.clone();
                arrayJsonTestSoggettiEquals[i].getConnettore().getPropertyList().clear();
                arrayJsonTestSoggettiEquals[i].setSuperUser(null);
                ++i;
            }
            SerializationClientTest.equals(arrayJsonTestSoggettiEquals, vJsonArrayTestSoggetti, dir);
            log.info("- OK, nome soggetto: " + ((Soggetto)vJsonArray[1]).getTipo() + "/" + ((Soggetto)vJsonArray[1]).getNome());
            log.info("- Costo ms deserializzazione json: " + Utilities.convertSystemTimeIntoStringMillisecondi((long)(dataFine - dataInizio), (boolean)true));
            log.info("\n");
        }
        finally {
            Files.delete(jsonFileStream.toPath());
        }
        System.out.println("Testsuite terminata");
    }

    private static void equalsOpenSPCoopObject(Object[] originale, Object[] ricostruito, File dir) throws Exception {
        for (int i = 0; i < originale.length; ++i) {
            boolean find = false;
            for (int j = 0; j < ricostruito.length; ++j) {
                try {
                    if (originale[i] instanceof Soggetto && ricostruito[j] instanceof Soggetto) {
                        SerializationClientTest.equals((Soggetto)originale[i], (Soggetto)ricostruito[j], dir, true);
                        find = true;
                    }
                    if (!(originale[i] instanceof AccordoServizioParteComune) || !(ricostruito[j] instanceof AccordoServizioParteComune)) continue;
                    SerializationClientTest.equals((AccordoServizioParteComune)originale[i], (AccordoServizioParteComune)ricostruito[j], dir);
                    find = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (find) continue;
            File tmp = new File(dir, "originaleTestFailed.xml");
            FileOutputStream fout = new FileOutputStream(tmp);
            if (originale[i] instanceof Soggetto) {
                fout.write(((Soggetto)originale[i]).toString(false, true).getBytes());
            } else {
                fout.write(((AccordoServizioParteComune)originale[i]).toString(false, true).getBytes());
            }
            fout.flush();
            fout.close();
            for (int j = 0; j < ricostruito.length; ++j) {
                tmp = new File(dir, "ricostruitoTestFailed(" + j + ").xml");
                fout = new FileOutputStream(tmp);
                if (ricostruito[j] instanceof Soggetto) {
                    fout.write(((Soggetto)ricostruito[j]).toString(false, true).getBytes());
                } else {
                    fout.write(((AccordoServizioParteComune)ricostruito[j]).toString(false, true).getBytes());
                }
                fout.flush();
                fout.close();
            }
            throw new Exception("Liste non uguali: vedi file originaleTestFailed.xml e files ricostruitoTestFailed(i).xml per capire le differenze");
        }
    }

    private static void equals(Soggetto[] originale, Soggetto[] ricostruito, File dir) throws Exception {
        for (int i = 0; i < originale.length; ++i) {
            boolean find = false;
            for (int j = 0; j < ricostruito.length; ++j) {
                try {
                    SerializationClientTest.equals(originale[i], ricostruito[j], dir, true);
                    find = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (find) continue;
            File tmp = new File(dir, "originaleTestFailed.xml");
            FileOutputStream fout = new FileOutputStream(tmp);
            fout.write(originale[i].toString(false, true).getBytes());
            fout.flush();
            fout.close();
            for (int j = 0; j < ricostruito.length; ++j) {
                tmp = new File(dir, "ricostruitoTestFailed(" + j + ").xml");
                fout = new FileOutputStream(tmp);
                fout.write(ricostruito[j].toString(false, true).getBytes());
                fout.flush();
                fout.close();
            }
            throw new Exception("Liste non uguali: vedi file originaleTestFailed.xml e files ricostruitoTestFailed(i).xml per capire le differenze");
        }
    }

    private static void equals(AccordoServizioParteComune[] originale, AccordoServizioParteComune[] ricostruito, File dir) throws Exception {
        for (int i = 0; i < originale.length; ++i) {
            boolean find = false;
            for (int j = 0; j < ricostruito.length; ++j) {
                try {
                    SerializationClientTest.equals(originale[i], ricostruito[j], dir);
                    find = true;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (find) continue;
            File tmp = new File(dir, "originaleTestFailed.xml");
            FileOutputStream fout = new FileOutputStream(tmp);
            fout.write(originale[i].toString(false, true).getBytes());
            fout.flush();
            fout.close();
            for (int j = 0; j < ricostruito.length; ++j) {
                tmp = new File(dir, "ricostruitoTestFailed(" + j + ").xml");
                fout = new FileOutputStream(tmp);
                fout.write(ricostruito[j].toString(false, true).getBytes());
                fout.flush();
                fout.close();
            }
            throw new Exception("Liste non uguali: vedi file originaleTestFailed.xml e files ricostruitoTestFailed(i).xml per capire le differenze");
        }
    }

    private static void equals(Soggetto o1, Soggetto o2, File dir, boolean deleteFile) throws Exception {
        if (!o1.toString(false, true).equals(o2.toString(false, true))) {
            File tmp1 = new File(dir, "originaleTestFailedSoggetto.xml");
            File tmp2 = new File(dir, "ricostruitoTestFailedSoggetto.xml");
            try {
                FileOutputStream fout1 = new FileOutputStream(tmp1);
                fout1.write(o1.toString(false, true).getBytes());
                fout1.flush();
                fout1.close();
                FileOutputStream fout2 = new FileOutputStream(tmp2);
                fout2.write(o2.toString(false, true).getBytes());
                fout2.flush();
                fout2.close();
                throw new Exception("Soggetti non uguali: vedi file originaleTestFailedSoggetto.xml e ricostruitoTestFailedSoggetto.xml per capire le differenze");
            }
            catch (Throwable throwable) {
                if (deleteFile) {
                    Files.delete(tmp1.toPath());
                    Files.delete(tmp2.toPath());
                }
                throw throwable;
            }
        }
    }

    private static void equals(AccordoServizioParteComune o1, AccordoServizioParteComune o2, File dir) throws Exception {
        if (!o1.toString(false, true).equals(o2.toString(false, true))) {
            File tmp1 = new File(dir, "originaleTestFailedAS.xml");
            File tmp2 = new File(dir, "ricostruitoTestFailedAS.xml");
            FileOutputStream fout1 = new FileOutputStream(tmp1);
            fout1.write(o1.toString(false, true).getBytes());
            fout1.flush();
            fout1.close();
            FileOutputStream fout2 = new FileOutputStream(tmp2);
            fout2.write(o2.toString(false, true).getBytes());
            fout2.flush();
            fout2.close();
            throw new Exception("Accordi non uguali: vedi file originaleTestFailedAS.xml e ricostruitoTestFailedAS.xml per capire le differenze");
        }
    }
}

