/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.statistiche.utils;

import org.openspcoop2.core.statistiche.model.StatisticaModel;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;

public class StatisticheUtils {
    private StatisticheUtils() {
    }

    public static void selezionaRecordValidi(IExpression expr, StatisticaModel model) throws ExpressionNotImplementedException, ExpressionException {
        expr.greaterEquals(model.STATO_RECORD, (Object)1);
    }

    public static FunctionField calcolaMedia(ISQLFieldConverter fieldConverter, IField latenza, IField numeroRichieste, String alias) throws ExpressionException {
        String columnLatenza = fieldConverter.toColumn(latenza, false);
        String columnRichieste = fieldConverter.toColumn(numeroRichieste, false);
        String sbFunctionValue = StatisticheUtils.getSqlCalcolaMedia(columnLatenza, columnRichieste);
        Class<Long> functionValueType = Long.class;
        return new FunctionField(sbFunctionValue, functionValueType, "", "", alias);
    }

    public static String getSqlCalcolaMedia(String columnLatenza, String columnRichieste) {
        StringBuilder sbFunctionValue = new StringBuilder("(");
        sbFunctionValue.append("SUM(CASE WHEN ").append(columnLatenza).append(" >= 0 THEN ");
        sbFunctionValue.append(columnLatenza).append("*").append(columnRichieste);
        sbFunctionValue.append(" ELSE 0 END)");
        sbFunctionValue.append("/");
        sbFunctionValue.append("SUM(CASE WHEN ").append(columnLatenza).append(" >= 0 THEN ");
        sbFunctionValue.append(columnRichieste);
        sbFunctionValue.append(" ELSE 0 END)");
        sbFunctionValue.append(")");
        return sbFunctionValue.toString();
    }
}

