/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.utils.transport.TransportUtils;

public class PropertiesSerializator {
    public static final String TEMPLATE_RITORNO_A_CAPO = "#@$#@$#@$#";
    protected Map<String, List<String>> properties;

    public Map<String, List<String>> getProperties() {
        return this.properties;
    }

    public PropertiesSerializator(Map<String, List<String>> properties) {
        this.properties = properties;
    }

    public String convertToDBColumnValue() throws CoreException {
        StringBuilder bf = new StringBuilder();
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                if (key.contains(" ")) {
                    throw new CoreException("Chiave [" + key + "] contiene il carattere ' ' non ammesso");
                }
                List<String> values = this.properties.get(key);
                this.addDBColumnValue(values, bf, key);
            }
        }
        return bf.toString();
    }

    private void addDBColumnValue(List<String> values, StringBuilder bf, String key) {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                while (value.contains("\n")) {
                    value = value.replace("\n", TEMPLATE_RITORNO_A_CAPO);
                }
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append(key).append("=").append(value);
            }
        }
    }

    public static Map<String, List<String>> convertoFromDBColumnValue(String dbValue) throws CoreException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (dbValue != null && !"".equals(dbValue)) {
            String[] split = dbValue.split("\n");
            for (int i = 0; i < split.length; ++i) {
                String value;
                String key;
                String keyValueTmp = split[i].trim();
                String[] keyValue = keyValueTmp.split("=");
                if (keyValue.length == 1 && keyValueTmp.endsWith("=")) {
                    key = keyValue[0];
                    value = "";
                    TransportUtils.addHeader(map, (String)key, (String)value);
                    continue;
                }
                if (keyValue.length < 2) {
                    throw new CoreException("Valore [" + keyValueTmp + "] non contiene una coppia key=value");
                }
                key = keyValue[0];
                value = keyValueTmp.substring((key + "=").length());
                while (value.contains(TEMPLATE_RITORNO_A_CAPO)) {
                    value = value.replace(TEMPLATE_RITORNO_A_CAPO, "\n");
                }
                TransportUtils.addHeader(map, (String)key, (String)value);
            }
        }
        return map;
    }
}

