/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractSearchCredenziale;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeClientAddress;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.utils.UtilsException;

public class CredenzialeSearchClientAddress
extends AbstractSearchCredenziale {
    private boolean socketAddress;
    private boolean trasportAddress;
    private boolean andOperator;

    public CredenzialeSearchClientAddress(boolean socketAddress, boolean trasportAddress, boolean and) {
        super(TipoCredenzialeMittente.CLIENT_ADDRESS);
        this.socketAddress = socketAddress;
        this.trasportAddress = trasportAddress;
        this.andOperator = and;
    }

    @Override
    protected String getExactValueDatabase(String credentialParam, boolean ricercaEsatta) throws UtilsException {
        throw new UtilsException("Not Implemented");
    }

    @Override
    public IPaginatedExpression createExpression(ICredenzialeMittenteService credenzialeMittentiService, String credentialParam, boolean ricercaEsatta, boolean caseSensitive) throws UtilsException {
        try {
            IPaginatedExpression pagExpression = credenzialeMittentiService.newPaginatedExpression();
            pagExpression.and();
            String credentialSocket = this.convertToDBValue ? CredenzialeClientAddress.getSocketAddressDBValue(credentialParam, ricercaEsatta) : credentialParam;
            String credentialTransport = this.convertToDBValue ? CredenzialeClientAddress.getTransportAddressDBValue(credentialParam, ricercaEsatta) : credentialParam;
            pagExpression.equals(CredenzialeMittente.model().TIPO, (Object)this.tipo.getRawValue());
            this.setLikeCondition(credenzialeMittentiService, pagExpression, ricercaEsatta, caseSensitive, credentialSocket, credentialTransport, credentialParam);
            return pagExpression;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private void setLikeCondition(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, boolean ricercaEsatta, boolean caseSensitive, String credentialSocket, String credentialTransport, String credentialParam) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        if (ricercaEsatta) {
            if (caseSensitive) {
                this.setLikeConditionRicercaEsattaCaseSensitive(credenzialeMittentiService, pagExpression, credentialSocket, credentialTransport);
            } else {
                this.setLikeConditionRicercaEsattaCaseInsensitive(credenzialeMittentiService, pagExpression, credentialSocket, credentialTransport);
            }
        } else if (!caseSensitive) {
            pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialParam, LikeMode.ANYWHERE);
        } else {
            pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credentialParam, LikeMode.ANYWHERE);
        }
    }

    private void setLikeConditionRicercaEsattaCaseSensitive(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialSocket, String credentialTransport) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        if (this.socketAddress && this.trasportAddress) {
            this.setLikeConditionRicercaEsattaCaseSensitiveBoth(credenzialeMittentiService, pagExpression, credentialSocket, credentialTransport);
        } else if (this.socketAddress) {
            if (this.convertToDBValue) {
                pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credentialSocket, LikeMode.ANYWHERE);
            } else {
                pagExpression.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialSocket);
            }
        } else if (this.trasportAddress) {
            if (this.convertToDBValue) {
                pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credentialTransport, LikeMode.ANYWHERE);
            } else {
                pagExpression.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialTransport);
            }
        }
    }

    private void setLikeConditionRicercaEsattaCaseSensitiveBoth(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialSocket, String credentialTransport) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        IPaginatedExpression pagExpressionSocket = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionSocket.like(CredenzialeMittente.model().CREDENZIALE, credentialSocket, LikeMode.ANYWHERE);
        } else {
            pagExpressionSocket.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialSocket);
        }
        IPaginatedExpression pagExpressionTransport = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionTransport.like(CredenzialeMittente.model().CREDENZIALE, credentialTransport, LikeMode.ANYWHERE);
        } else {
            pagExpressionTransport.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialTransport);
        }
        if (this.andOperator) {
            pagExpression.and((IExpression)pagExpressionSocket, (IExpression)pagExpressionTransport);
        } else {
            pagExpression.or((IExpression)pagExpressionSocket, (IExpression)pagExpressionTransport);
        }
    }

    private void setLikeConditionRicercaEsattaCaseInsensitive(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialSocket, String credentialTransport) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        if (this.socketAddress && this.trasportAddress) {
            this.setLikeConditionRicercaEsattaCaseInsensitiveBoth(credenzialeMittentiService, pagExpression, credentialSocket, credentialTransport);
        } else if (this.socketAddress) {
            if (this.convertToDBValue) {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialSocket, LikeMode.ANYWHERE);
            } else {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialSocket, LikeMode.EXACT);
            }
        } else if (this.trasportAddress) {
            if (this.convertToDBValue) {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialTransport, LikeMode.ANYWHERE);
            } else {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialTransport, LikeMode.EXACT);
            }
        }
    }

    private void setLikeConditionRicercaEsattaCaseInsensitiveBoth(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialSocket, String credentialTransport) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        IPaginatedExpression pagExpressionSocket = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionSocket.ilike(CredenzialeMittente.model().CREDENZIALE, credentialSocket, LikeMode.ANYWHERE);
        } else {
            pagExpressionSocket.ilike(CredenzialeMittente.model().CREDENZIALE, credentialSocket, LikeMode.EXACT);
        }
        IPaginatedExpression pagExpressionTransport = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionTransport.ilike(CredenzialeMittente.model().CREDENZIALE, credentialTransport, LikeMode.ANYWHERE);
        } else {
            pagExpressionTransport.ilike(CredenzialeMittente.model().CREDENZIALE, credentialTransport, LikeMode.EXACT);
        }
        if (this.andOperator) {
            pagExpression.and((IExpression)pagExpressionSocket, (IExpression)pagExpressionTransport);
        } else {
            pagExpression.or((IExpression)pagExpressionSocket, (IExpression)pagExpressionTransport);
        }
    }
}

