/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.StringTokenizer;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.swing.plaf.LookAndFeelFactory;
import org.tp23.antinstaller.runtime.AutoSwingRunner;
import org.tp23.antinstaller.runtime.AutoTextRunner;
import org.tp23.antinstaller.runtime.Runner;
import org.tp23.antinstaller.runtime.SwingRunner;
import org.tp23.antinstaller.runtime.TextRunner;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class CreateUIFilter
implements ExecuteFilter {
    public void exec(InstallerContext ctx) throws InstallException {
        try {
            if (ctx.getInstaller().isVerbose()) {
                ctx.log("Creating UI classes");
            }
            ctx.setRunner(this.getRunner(ctx));
            ctx.log("Created UI classes");
        }
        catch (IOException e) {
            throw new InstallException("Unable to create the user interface", e);
        }
        catch (InstallException e) {
            throw new InstallException(e.getMessage(), e);
        }
    }

    private Runner getRunner(InstallerContext ctx) throws IOException, InstallException {
        if (ctx.getUIOverride() != null) {
            if (ctx.getUIOverride().equalsIgnoreCase("swing")) {
                if (this.isUi("swing", ctx.getInstaller().getUi())) {
                    new LookAndFeelFactory(ctx).setLAF();
                    return new SwingRunner(ctx);
                }
                throw new InstallException("Not a permited UI override, swing is not allowed");
            }
            if (ctx.getUIOverride().equalsIgnoreCase("text")) {
                if (this.isUi("text", ctx.getInstaller().getUi())) {
                    return new TextRunner(ctx);
                }
                throw new InstallException("Not a permited UI override, text is not allowed");
            }
            if (ctx.getUIOverride().equalsIgnoreCase("swing-auto")) {
                if (this.isUi("swing-auto", ctx.getInstaller().getUi())) {
                    new LookAndFeelFactory(ctx).setLAF();
                    return new AutoSwingRunner(ctx);
                }
                throw new InstallException("Not a permited UI override, swing-auto is not allowed");
            }
            if (ctx.getUIOverride().equalsIgnoreCase("text-auto")) {
                if (this.isUi("text-auto", ctx.getInstaller().getUi())) {
                    return new AutoTextRunner(ctx);
                }
                throw new InstallException("Not a permited UI override, text-auto is not allowed");
            }
        }
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            new LookAndFeelFactory(ctx).setLAF();
            return new SwingRunner(ctx);
        }
        catch (Throwable e) {
            System.out.println("No graphics environment available, reverting to text");
            System.out.println();
            return new TextRunner(ctx);
        }
    }

    private boolean isUi(String ui, String commaSeparatedUiList) {
        StringTokenizer st = new StringTokenizer(commaSeparatedUiList, ",");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(ui)) continue;
            return true;
        }
        return false;
    }
}

