/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.beans;

import org.openspcoop2.generic_project.beans.IField;

public class Field
implements IField {
    private String fieldName;
    private Class<?> fieldType;
    private String className;
    private Class<?> classType;

    public Field(String fieldName, Class<?> fieldType, String className, Class<?> classType) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.className = className;
        this.classType = classType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Class<?> getFieldType() {
        return this.fieldType;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Class<?> getClassType() {
        return this.classType;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Field)) {
            if (o instanceof IField) {
                return false;
            }
            throw new RuntimeException("Expected type [" + Field.class.getName() + "] different from the type found [" + o.getClass().getName() + "]");
        }
        Field f = (Field)o;
        String thisClassTypeName = this.classType.getName();
        String fClassTypeName = f.getClassType().getName();
        String thisFieldTypeName = this.fieldType.getName();
        String fFieldTypeName = f.getFieldType().getName();
        return this.className.equals(f.getClassName()) && thisClassTypeName.equals(fClassTypeName) && this.fieldName.equals(f.getFieldName()) && thisFieldTypeName.equals(fFieldTypeName);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder indentBuffer = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentBuffer.append("\t");
        }
        StringBuilder bf = new StringBuilder();
        bf.append(indentBuffer.toString());
        bf.append("- field name: " + this.fieldName);
        bf.append("\n");
        bf.append(indentBuffer.toString());
        bf.append("- field type: " + String.valueOf(this.fieldType));
        bf.append("\n");
        bf.append(indentBuffer.toString());
        bf.append("- class name: " + this.className);
        bf.append("\n");
        bf.append(indentBuffer.toString());
        bf.append("- class type: " + String.valueOf(this.classType));
        bf.append("\n");
        return bf.toString();
    }
}

