/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.dao.jdbc.JDBCLoggerProperties;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerTipoCostruttore;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.slf4j.Logger;

public class JDBCServiceManagerBase {
    protected DataSource datasource;
    protected Connection connection = null;
    protected Logger log = null;
    protected JDBCServiceManagerProperties jdbcProperties = null;
    private String connectionUrl;
    private String username;
    private String password;
    private int secondsToRefreshConnection = -1;
    private Date connectionDate;
    private static final String CREATE_ERROR_PREFIX = "Creating failure: ";
    private JDBCServiceManagerTipoCostruttore tipoCostruttore = null;
    private static Logger checkLogger = null;
    private static volatile boolean checkIsClosed = true;
    private static volatile boolean checkAutocommit = true;

    private void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    protected JDBCServiceManagerBase() {
    }

    public JDBCServiceManagerBase(String jndiName, Properties contextJNDI, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(jndiName, contextJNDI, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManagerBase(String jndiName, Properties contextJNDI, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(jndiName, contextJNDI, jdbcProperties, null);
    }

    public JDBCServiceManagerBase(String jndiName, Properties contextJNDI, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(jndiName, contextJNDI, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManagerBase(String jndiName, Properties contextJNDI, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.DATASOURCE_CFG;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManagerBase.class) : alog;
        try {
            GestoreJNDI gestoreJNDI = new GestoreJNDI(contextJNDI);
            this.datasource = (DataSource)gestoreJNDI.lookup(jndiName);
            if (this.datasource == null) {
                throw new ServiceException("Datasource is null");
            }
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.logError(CREATE_ERROR_PREFIX + e.getMessage(), e);
            throw new ServiceException(CREATE_ERROR_PREFIX + e.getMessage(), e);
        }
    }

    public JDBCServiceManagerBase(DataSource ds, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(ds, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManagerBase(DataSource ds, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(ds, jdbcProperties, null);
    }

    public JDBCServiceManagerBase(DataSource ds, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(ds, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManagerBase(DataSource ds, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.DATASOURCE_OBJECT;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManagerBase.class) : alog;
        try {
            this.datasource = ds;
            if (this.datasource == null) {
                throw new ServiceException("Datasource is null");
            }
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.logError(CREATE_ERROR_PREFIX + e.getMessage(), e);
            throw new ServiceException(CREATE_ERROR_PREFIX + e.getMessage(), e);
        }
    }

    public JDBCServiceManagerBase(String connectionUrl, String driverJDBC, String username, String password, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(connectionUrl, driverJDBC, username, password, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManagerBase(String connectionUrl, String driverJDBC, String username, String password, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(connectionUrl, driverJDBC, username, password, jdbcProperties, null);
    }

    public JDBCServiceManagerBase(String connectionUrl, String driverJDBC, String username, String password, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(connectionUrl, driverJDBC, username, password, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManagerBase(String connectionUrl, String driverJDBC, String username, String password, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.CONNECTION_CFG;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManagerBase.class) : alog;
        try {
            this.connectionUrl = connectionUrl;
            this.username = username;
            this.password = password;
            this.secondsToRefreshConnection = jdbcProperties.getSecondsToRefreshConnection();
            ClassLoaderUtilities.newInstance((String)driverJDBC);
            this.setConnection();
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.logError(CREATE_ERROR_PREFIX + e.getMessage(), e);
            throw new ServiceException(CREATE_ERROR_PREFIX + e.getMessage(), e);
        }
    }

    private void setConnection() throws SQLException {
        this.connection = this.username != null ? DriverManager.getConnection(this.connectionUrl, this.username, this.password) : DriverManager.getConnection(this.connectionUrl);
        this.connectionDate = DateManager.getDate();
    }

    private boolean isConnectionExpired() {
        if (this.secondsToRefreshConnection > 0) {
            Date now = DateManager.getDate();
            Date expireDate = new Date(this.connectionDate.getTime() + (long)(this.secondsToRefreshConnection * 1000));
            if (expireDate.before(now)) {
                return true;
            }
        }
        return false;
    }

    private void refreshConnection() throws SQLException {
        if (this.isConnectionExpired()) {
            this.internalRefreshConnection();
        }
    }

    private synchronized void internalRefreshConnection() throws SQLException {
        if (this.isConnectionExpired()) {
            try {
                if (this.connection != null) {
                    JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)this.connection, (boolean)checkAutocommit, (boolean)checkIsClosed);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setConnection();
        }
    }

    public JDBCServiceManagerBase(Connection connection, ServiceManagerProperties serviceManagerProperties) throws ServiceException {
        this(connection, new JDBCServiceManagerProperties(serviceManagerProperties), null);
    }

    public JDBCServiceManagerBase(Connection connection, JDBCServiceManagerProperties jdbcProperties) throws ServiceException {
        this(connection, jdbcProperties, null);
    }

    public JDBCServiceManagerBase(Connection connection, ServiceManagerProperties serviceManagerProperties, Logger alog) throws ServiceException {
        this(connection, new JDBCServiceManagerProperties(serviceManagerProperties), alog);
    }

    public JDBCServiceManagerBase(Connection connection, JDBCServiceManagerProperties jdbcProperties, Logger alog) throws ServiceException {
        this.tipoCostruttore = JDBCServiceManagerTipoCostruttore.CONNECTION_OBJECT;
        this.log = alog == null ? LoggerWrapperFactory.getLogger(JDBCServiceManagerBase.class) : alog;
        try {
            this.connection = connection;
            if (this.connection == null) {
                throw new ServiceException("Connection is null");
            }
            this.jdbcProperties = jdbcProperties;
            jdbcProperties.getDatabase();
        }
        catch (Exception e) {
            this.logError(CREATE_ERROR_PREFIX + e.getMessage(), e);
            throw new ServiceException(CREATE_ERROR_PREFIX + e.getMessage(), e);
        }
    }

    public void close() throws ServiceException {
        try {
            if (this.tipoCostruttore != null && JDBCServiceManagerTipoCostruttore.CONNECTION_CFG.equals((Object)this.tipoCostruttore) && this.connection != null) {
                JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)this.connection, (boolean)checkAutocommit, (boolean)checkIsClosed);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Close failure: " + e.getMessage(), e);
        }
    }

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        JDBCServiceManagerBase.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        JDBCServiceManagerBase.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        JDBCServiceManagerBase.checkLogger = checkLogger;
    }

    protected Connection getConnection() throws ServiceException {
        try {
            if (this.datasource != null) {
                return this.datasource.getConnection();
            }
            if (this.connection != null) {
                if (JDBCServiceManagerTipoCostruttore.CONNECTION_CFG.equals((Object)this.tipoCostruttore)) {
                    this.refreshConnection();
                }
                return this.connection;
            }
            throw new ServiceException("ServiceManager not initialized");
        }
        catch (Exception e) {
            throw new ServiceException("Get Connection failure: " + e.getMessage(), e);
        }
    }

    protected void closeConnection(Connection connection) throws ServiceException {
        block6: {
            try {
                if (connection == null) {
                    throw new ServiceException("Connection is null");
                }
                if (this.datasource != null) {
                    JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)connection, (boolean)checkAutocommit, (boolean)checkIsClosed);
                    break block6;
                }
                if (this.connection != null) {
                    if (connection.isClosed()) {
                        throw new ServiceException("The connection provided shall not be closed");
                    }
                    break block6;
                }
                throw new ServiceException("ServiceManager not initialized");
            }
            catch (Exception e) {
                throw new ServiceException("Get Connection failure: " + e.getMessage(), e);
            }
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public JDBCServiceManagerProperties getJdbcProperties() {
        return this.jdbcProperties;
    }

    public static void configureDefaultLog4jProperties(IProjectInfo project) throws ServiceException {
        JDBCLoggerProperties loggerProperties = new JDBCLoggerProperties(project);
        loggerProperties.configureLog4j();
    }

    public static void configureLog4jProperties(File log4jProperties) throws ServiceException {
        JDBCLoggerProperties loggerProperties = new JDBCLoggerProperties(null, log4jProperties);
        loggerProperties.configureLog4j();
    }
}

