/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.jdbc.utils;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.openspcoop2.generic_project.beans.AliasField;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.Field;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IAliasTableField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.beans.UnionOrderedColumn;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.beans.UpdateModel;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchSingleObject;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.expression.impl.OrderedField;
import org.openspcoop2.generic_project.expression.impl.sql.ExpressionSQL;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class GenericJDBCUtilities {
    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, List<String> aliasField, IField ... field) throws ExpressionException {
        GenericJDBCUtilities.setFields(sqlQueryObject, paginatedExpression, aliasField, true, field);
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, List<String> aliasField, boolean appendTablePrefix, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                paginatedExpression.addField(sqlQueryObject, field[i], aliasField.get(i), appendTablePrefix);
            }
        }
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, List<String> aliasField, IField ... field) throws ExpressionException {
        GenericJDBCUtilities.setFields(sqlQueryObject, expression, aliasField, true, field);
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, List<String> aliasField, boolean appendTablePrefix, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                expression.addField(sqlQueryObject, field[i], aliasField.get(i), appendTablePrefix);
            }
        }
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ExpressionException {
        GenericJDBCUtilities.setFields(sqlQueryObject, paginatedExpression, true, field);
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean appendTablePrefix, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                paginatedExpression.addField(sqlQueryObject, field[i], appendTablePrefix);
            }
        }
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, IField ... field) throws ExpressionException {
        GenericJDBCUtilities.setFields(sqlQueryObject, expression, true, field);
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, boolean appendTablePrefix, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                expression.addField(sqlQueryObject, field[i], appendTablePrefix);
            }
        }
    }

    public static void setAliasFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ExpressionException {
        GenericJDBCUtilities.setAliasFields(sqlQueryObject, paginatedExpression, true, field);
    }

    public static void setAliasFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean appendTablePrefix, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                paginatedExpression.addAliasField(sqlQueryObject, field[i], appendTablePrefix);
            }
        }
    }

    public static void setAliasFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, IField ... field) throws ExpressionException {
        GenericJDBCUtilities.setAliasFields(sqlQueryObject, expression, true, field);
    }

    public static void setAliasFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, boolean appendTablePrefix, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                expression.addAliasField(sqlQueryObject, field[i], appendTablePrefix);
            }
        }
    }

    public static void removeFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                paginatedExpression.removeFieldManuallyAdd(field[i]);
            }
        }
    }

    public static void removeFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, IField ... field) throws ExpressionException {
        if (field != null) {
            for (int i = 0; i < field.length; ++i) {
                expression.removeFieldManuallyAdd(field[i]);
            }
        }
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ExpressionException {
        GenericJDBCUtilities.setFields(sqlQueryObject, paginatedExpression, true, functionField);
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean appendTablePrefix, FunctionField ... functionField) throws ExpressionException {
        if (functionField != null) {
            for (int i = 0; i < functionField.length; ++i) {
                paginatedExpression.addField(sqlQueryObject, functionField[i], appendTablePrefix);
            }
        }
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ExpressionException {
        GenericJDBCUtilities.setFields(sqlQueryObject, expression, true, functionField);
    }

    public static void setFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, boolean appendTablePrefix, FunctionField ... functionField) throws ExpressionException {
        if (functionField != null) {
            for (int i = 0; i < functionField.length; ++i) {
                expression.addField(sqlQueryObject, functionField[i], appendTablePrefix);
            }
        }
    }

    public static void removeFields(ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ExpressionException {
        if (functionField != null) {
            for (int i = 0; i < functionField.length; ++i) {
                paginatedExpression.removeFieldManuallyAdd(functionField[i]);
            }
        }
    }

    public static void removeFields(ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ExpressionException {
        if (functionField != null) {
            for (int i = 0; i < functionField.length; ++i) {
                expression.removeFieldManuallyAdd(functionField[i]);
            }
        }
    }

    private static List<OrderedField> getOrderedFields(IExpression expression) {
        List<OrderedField> listOrderedFields = null;
        if (expression instanceof JDBCPaginatedExpression) {
            listOrderedFields = ((JDBCPaginatedExpression)expression).getOrderedFields();
        } else if (expression instanceof JDBCExpression) {
            listOrderedFields = ((JDBCExpression)expression).getOrderedFields();
        }
        return listOrderedFields;
    }

    private static SortOrder getSortOrder(IExpression expression) {
        SortOrder sortOrder = null;
        if (expression instanceof JDBCPaginatedExpression) {
            sortOrder = ((JDBCPaginatedExpression)expression).getSortOrder();
        } else if (expression instanceof JDBCExpression) {
            sortOrder = ((JDBCExpression)expression).getSortOrder();
        }
        return sortOrder;
    }

    private static List<IField> getGroupByFields(IExpression expression) {
        List<IField> listGroupByFields = null;
        if (expression instanceof JDBCPaginatedExpression) {
            listGroupByFields = ((JDBCPaginatedExpression)expression).getGroupByFields();
        } else if (expression instanceof JDBCExpression) {
            listGroupByFields = ((JDBCExpression)expression).getGroupByFields();
        }
        return listGroupByFields;
    }

    private static boolean isUsedForCountExpression(IExpression expression) {
        boolean isUsed = false;
        if (expression instanceof JDBCPaginatedExpression) {
            isUsed = ((JDBCPaginatedExpression)expression).isUsedForCountExpression();
        } else if (expression instanceof JDBCExpression) {
            isUsed = ((JDBCExpression)expression).isUsedForCountExpression();
        }
        return isUsed;
    }

    private static void setUsedForCountExpression(IExpression expression, boolean value) {
        if (expression instanceof JDBCPaginatedExpression) {
            ((JDBCPaginatedExpression)expression).setUsedForCountExpression(value);
        } else if (expression instanceof JDBCExpression) {
            ((JDBCExpression)expression).setUsedForCountExpression(value);
        }
    }

    private static void toSqlForPreparedStatementWithFromCondition(IExpression expression, ISQLQueryObject sqlQueryObject, List<Object> listaQuery, String table) throws ExpressionException, ExpressionNotImplementedException {
        if (expression instanceof JDBCPaginatedExpression) {
            ((JDBCPaginatedExpression)expression).toSqlForPreparedStatementWithFromCondition(sqlQueryObject, listaQuery, table);
        } else if (expression instanceof JDBCExpression) {
            ((JDBCExpression)expression).toSqlForPreparedStatementWithFromCondition(sqlQueryObject, listaQuery, table);
        }
    }

    private static List<Object> getFieldsManuallyAdd(IExpression expression) {
        List<Object> list = null;
        if (expression instanceof JDBCPaginatedExpression) {
            list = ((JDBCPaginatedExpression)expression).getFieldsManuallyAdd();
        } else if (expression instanceof JDBCExpression) {
            list = ((JDBCExpression)expression).getFieldsManuallyAdd();
        }
        return list;
    }

    public static NotFoundException newNotFoundException() {
        return new NotFoundException("Not Found");
    }

    public static NotImplementedException newNotImplementedException() {
        return new NotImplementedException("NotImplemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> prepareCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLFieldConverter sqlConverter, IModel<?> model) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, ServiceException {
        List<OrderedField> listOrderedFields = GenericJDBCUtilities.getOrderedFields(expression);
        SortOrder sortOrder = GenericJDBCUtilities.getSortOrder(expression);
        if (listOrderedFields != null && listOrderedFields.size() > 0 && sortOrder != null && !sortOrder.equals((Object)SortOrder.UNSORTED)) {
            throw new ServiceException("OrderBy conditions not allowed in count expression");
        }
        ArrayList<Object> listaQuery = new ArrayList<Object>();
        boolean oldValue = GenericJDBCUtilities.isUsedForCountExpression(expression);
        GenericJDBCUtilities.setUsedForCountExpression(expression, true);
        try {
            GenericJDBCUtilities.toSqlForPreparedStatementWithFromCondition(expression, sqlQueryObject, listaQuery, sqlConverter.toTable(model));
            ArrayList<Object> arrayList = listaQuery;
            return arrayList;
        }
        finally {
            GenericJDBCUtilities.setUsedForCountExpression(expression, oldValue);
        }
    }

    public static NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLFieldConverter sqlConverter, IModel<?> model, List<Object> listaQuery) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, ServiceException {
        long totale = 0L;
        String sql = null;
        List<IField> listGroupByFields = GenericJDBCUtilities.getGroupByFields(expression);
        if (listGroupByFields != null && listGroupByFields.size() > 0) {
            for (IField iField : listGroupByFields) {
                sqlQueryObject.addSelectField(sqlConverter.toColumn(iField, true));
            }
            ISQLQueryObject sqlCountGroup = sqlQueryObject.newSQLQueryObject();
            sqlCountGroup.addSelectCountField("groupCount");
            sqlCountGroup.addFromTable(sqlQueryObject);
            sql = sqlCountGroup.createSQLQuery();
        } else {
            sql = sqlQueryObject.createSQLQuery();
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        JDBCObject[] params = new JDBCObject[listaQuery.size()];
        int index = 0;
        for (Object param : listaQuery) {
            params[index++] = new JDBCObject(param, param.getClass());
        }
        totale = jdbcUtilities.count(sql, jdbcProperties.isShowSql(), params);
        return new NonNegativeNumber(totale);
    }

    public static List<Object> selectSingleObject(List<Map<String, Object>> map) throws NotFoundException {
        if (map.size() <= 0) {
            throw new NotFoundException("No result founds");
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < map.size(); ++i) {
            results.add(map.get(i).values().iterator().next());
        }
        return results;
    }

    public static Object selectAggregateObject(Map<String, Object> map, FunctionField functionField) throws NotFoundException {
        if (map.size() <= 0) {
            throw new NotFoundException("No result founds");
        }
        return map.get(functionField.getAlias());
    }

    private static List<Object> toSqlForPreparedStatementFromCondition(IExpression expression, ISQLQueryObject sqlQueryObject, List<Object> listaQuery, List<JDBCObject> params, ISQLFieldConverter sqlConverter, IModel<?> model) throws ExpressionException, ExpressionNotImplementedException {
        GenericJDBCUtilities.toSqlForPreparedStatementWithFromCondition(expression, sqlQueryObject, listaQuery, sqlConverter.toTable(model));
        List<Object> returnField = GenericJDBCUtilities.getFieldsManuallyAdd(expression);
        for (Object param : listaQuery) {
            params.add(new JDBCObject(param, param.getClass()));
        }
        return returnField;
    }

    private static List<Object> eliminaDuplicati(Collection<Object> returnField) {
        ArrayList<Object> listSenzaDuplicati = new ArrayList<Object>();
        for (Object o : returnField) {
            boolean found;
            Object field;
            if (o instanceof IField) {
                field = (IField)o;
                found = false;
                for (Object e : listSenzaDuplicati) {
                    IField iFieldCheck;
                    if (!(e instanceof IField) || !(iFieldCheck = (IField)e).equals(field)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                listSenzaDuplicati.add(o);
                continue;
            }
            if (!(o instanceof FunctionField)) continue;
            field = (FunctionField)o;
            found = false;
            for (Object e : listSenzaDuplicati) {
                FunctionField functionFieldCheck;
                if (!(e instanceof FunctionField) || !(functionFieldCheck = (FunctionField)e).equals((FunctionField)field)) continue;
                found = true;
                break;
            }
            if (found) continue;
            listSenzaDuplicati.add(o);
        }
        return listSenzaDuplicati;
    }

    private static List<Class<?>> readClassTypes(Collection<Object> returnField) {
        ArrayList returnClassTypes = new ArrayList();
        for (Object o : returnField) {
            Object field;
            if (o instanceof IField) {
                field = (IField)o;
                returnClassTypes.add(field.getFieldType());
                continue;
            }
            if (!(o instanceof FunctionField)) continue;
            field = (FunctionField)o;
            if (((FunctionField)field).getFieldType().toString().equals(java.util.Date.class.toString()) || ((FunctionField)field).getFieldType().toString().equals(Date.class.toString()) || ((FunctionField)field).getFieldType().toString().equals(Timestamp.class.toString()) || ((FunctionField)field).getFieldType().toString().equals(Calendar.class.toString())) {
                returnClassTypes.add(Long.class);
                continue;
            }
            returnClassTypes.add(((FunctionField)field).getFieldType());
        }
        return returnClassTypes;
    }

    private static List<List<String>> readAliases(Collection<Object> returnField) throws ServiceException {
        String nome;
        Object field;
        ArrayList<List<String>> returnClassAliases = new ArrayList<List<String>>();
        for (int i = 0; i < returnField.size(); ++i) {
            returnClassAliases.add(new ArrayList());
        }
        ArrayList<String> returnClassAliases_simple = new ArrayList<String>();
        int index = 0;
        for (Object o : returnField) {
            if (o instanceof Field) {
                field = (IField)o;
                nome = field.getFieldName();
                returnClassAliases_simple.add(nome);
                ((List)returnClassAliases.get(index)).add(nome);
            }
            ++index;
        }
        index = 0;
        for (Object o : returnField) {
            if (o instanceof IField) {
                if (o instanceof AliasField) {
                    AliasField af = (AliasField)o;
                    nome = af.getAlias();
                    if (returnClassAliases_simple.contains(nome)) {
                        throw new ServiceException("AliasField contains alias [" + nome + "] is already used for simple select field. Choose different alias name");
                    }
                    ((List)returnClassAliases.get(index)).add(nome);
                    IField field2 = af.getField();
                    StringBuilder bf = new StringBuilder();
                    GenericJDBCUtilities.buildAliasesPrefix(field2, bf);
                    String nomeField = bf.toString();
                    if (!returnClassAliases_simple.contains(nome)) {
                        ((List)returnClassAliases.get(index)).add(nomeField);
                    }
                } else if (o instanceof IAliasTableField) {
                    bf = new StringBuilder();
                    GenericJDBCUtilities.buildAliasesPrefix((IField)o, bf);
                    ((List)returnClassAliases.get(index)).add(bf.toString());
                } else if (o instanceof ComplexField) {
                    bf = new StringBuilder();
                    GenericJDBCUtilities.buildAliasesPrefix((IField)o, bf);
                    ((List)returnClassAliases.get(index)).add(bf.toString());
                }
            } else if (o instanceof FunctionField) {
                field = (FunctionField)o;
                nome = ((FunctionField)field).getAlias();
                if (returnClassAliases_simple.contains(nome)) {
                    throw new ServiceException("FunctionAliasName [" + nome + "] is already used for simple select field. Choose different alias name");
                }
                ((List)returnClassAliases.get(index)).add(nome);
            }
            ++index;
        }
        return returnClassAliases;
    }

    public static String getAlias(Object object) throws ServiceException {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(object);
        List<List<String>> ll = GenericJDBCUtilities.readAliases(l);
        if (ll == null || ll.size() <= 0) {
            throw new ServiceException("Build alias error");
        }
        if (ll.get(0) == null || ll.get(0).size() <= 0) {
            throw new ServiceException("Build alias error (internal)");
        }
        return ll.get(0).get(0);
    }

    private static void buildAliasesPrefix(IField field, StringBuilder prefix) {
        if (field instanceof IAliasTableField) {
            prefix.append(((IAliasTableField)field).getAliasTable()).append(".").append(field.getFieldName());
        } else {
            if (field instanceof ComplexField) {
                ComplexField c = (ComplexField)field;
                GenericJDBCUtilities.buildAliasesPrefix(c.getFather(), prefix);
            }
            if (prefix.length() > 0) {
                prefix.append(".");
            }
            prefix.append(field.getFieldName());
        }
    }

    public static List<Object> prepareSelect(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLFieldConverter sqlConverter, IModel<?> model, List<Object> listaQuery, List<JDBCObject> listaParams) throws NotFoundException, ServiceException, SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException {
        List<Object> returnField = GenericJDBCUtilities.toSqlForPreparedStatementFromCondition(expression, sqlQueryObject, listaQuery, listaParams, sqlConverter, model);
        return returnField;
    }

    public static ISQLQueryObject prepareSqlQueryObjectForSelectDistinct(boolean distinct, ISQLQueryObject sqlQueryObject, IExpression expression, Logger log, ISQLFieldConverter sqlFieldConverter, IField ... field) throws SQLQueryObjectException, ExpressionException {
        ISQLQueryObject sqlQueryObjectDistinct = null;
        if (distinct) {
            if (((SQLQueryObjectCore)sqlQueryObject).isSelectForUpdate()) {
                throw new SQLQueryObjectException("Non \u00e8 possibile abilitare il comando 'selectForUpdate' se viene utilizzata la clausola DISTINCT");
            }
            sqlQueryObjectDistinct = sqlQueryObject.newSQLQueryObject();
            JDBCPaginatedExpression paginatedExpressionTmp = new JDBCPaginatedExpression(sqlFieldConverter);
            GenericJDBCUtilities.setAliasFields(sqlQueryObjectDistinct, paginatedExpressionTmp, false, field);
            sqlQueryObjectDistinct.setSelectDistinct(true);
            List<OrderedField> listOrderedFields = GenericJDBCUtilities.getOrderedFields(expression);
            SortOrder sortOrder = GenericJDBCUtilities.getSortOrder(expression);
            if (listOrderedFields != null && listOrderedFields.size() > 0 && sortOrder != null && !SortOrder.UNSORTED.equals((Object)sortOrder)) {
                boolean orderBy = false;
                for (OrderedField orderedFieldBean : listOrderedFields) {
                    IField orderedField = orderedFieldBean.getField();
                    boolean contains = false;
                    for (int i = 0; i < field.length; ++i) {
                        if (!orderedField.equals(field[i])) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) continue;
                    sqlQueryObjectDistinct.addOrderBy(sqlFieldConverter.toColumn(orderedField, false), SortOrder.ASC.equals((Object)orderedFieldBean.getSortOrder()));
                    orderBy = true;
                }
                if (orderBy) {
                    sqlQueryObjectDistinct.setSortType(SortOrder.ASC.equals((Object)sortOrder));
                }
            }
        }
        return sqlQueryObjectDistinct;
    }

    public static ISQLQueryObject prepareSqlQueryObjectForSelectDistinct(ISQLQueryObject sqlQueryObject, ISQLQueryObject sqlQueryObjectDistinct) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObjectExecute = sqlQueryObject;
        if (sqlQueryObjectDistinct != null) {
            sqlQueryObjectDistinct.addFromTable(sqlQueryObject);
            sqlQueryObjectExecute = sqlQueryObjectDistinct;
        }
        return sqlQueryObjectExecute;
    }

    public static List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLFieldConverter sqlConverter, IModel<?> model, List<Object> listaQuery, List<JDBCObject> listaParams, List<Object> returnField) throws NotFoundException, ServiceException, SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException {
        List<OrderedField> listOrderedFields;
        List<IField> listGroupByFields = GenericJDBCUtilities.getGroupByFields(expression);
        if (listGroupByFields != null && listGroupByFields.size() > 0 && (listOrderedFields = GenericJDBCUtilities.getOrderedFields(expression)) != null && listOrderedFields.size() > 0) {
            for (OrderedField orderedField : listOrderedFields) {
                IField iField = orderedField.getField();
                if (listGroupByFields.contains(iField)) continue;
                throw new ServiceException("The field used for order by condition is invalid because it is not contained in GROUP BY clause. Field: [" + iField.toString() + "]");
            }
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        String sql = sqlQueryObject.createSQLQuery();
        JDBCObject[] params = null;
        if (listaParams.size() > 0) {
            params = listaParams.toArray(new JDBCObject[1]);
        }
        returnField = GenericJDBCUtilities.eliminaDuplicati(returnField);
        List<Class<?>> returnClassTypes = GenericJDBCUtilities.readClassTypes(returnField);
        List<List<String>> returnClassAliases = GenericJDBCUtilities.readAliases(returnField);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<List<Object>> resultExecuteQuery = jdbcUtilities.executeQuery(sql, jdbcProperties.isShowSql(), returnClassTypes, params);
        if (resultExecuteQuery.size() > 0) {
            for (int i = 0; i < resultExecuteQuery.size(); ++i) {
                List<Object> lista = resultExecuteQuery.get(i);
                if (lista == null) {
                    throw new ServiceException("Result[" + i + "] is null?");
                }
                if (lista.size() != returnField.size()) {
                    throw new ServiceException("Result[" + i + "] has wrong length (expected:" + returnField.size() + " founded:" + lista.size() + ")");
                }
                HashMap<String, Object> resultList = new HashMap<String, Object>();
                for (int j = 0; j < lista.size(); ++j) {
                    Object object = lista.get(j);
                    for (String key : returnClassAliases.get(j)) {
                        if (object != null) {
                            resultList.put(key, object);
                            continue;
                        }
                        resultList.put(key, ObjectUtils.NULL);
                    }
                }
                result.add(resultList);
            }
        }
        if (result.size() <= 0) {
            throw new NotFoundException("No result founds");
        }
        return result;
    }

    public static List<Class<?>> checkUnionExpression(UnionExpression ... expression) throws ServiceException {
        if (expression == null || expression.length <= 0) {
            throw new ServiceException("UnionExpression not found");
        }
        if (expression.length == 1) {
            throw new ServiceException("At least two expressions are required");
        }
        List<Class<?>> listClassReturnType = new ArrayList();
        for (int i = 0; i < expression.length; ++i) {
            UnionExpression ue = expression[i];
            List<String> aliasUe = ue.getReturnFieldAliases();
            if (aliasUe.size() <= 0) {
                throw new ServiceException("The expression n." + (i + 1) + " contains no select field");
            }
            for (int j = 0; j < expression.length; ++j) {
                if (j == i) continue;
                UnionExpression checkUe = expression[j];
                List<String> checkAliasUe = checkUe.getReturnFieldAliases();
                if (checkAliasUe.size() <= 0) {
                    throw new ServiceException("The expression n." + (j + 1) + " contains no select field");
                }
                String errorMsg = "All expressions must contain the same number of select field with the same alias in the same order. ";
                if (checkAliasUe.size() != aliasUe.size()) {
                    throw new ServiceException(errorMsg + "Found expression that contains a different number of select field (" + (i + 1) + "-exp:" + aliasUe.size() + " " + (j + 1) + "-exp:" + checkAliasUe.size() + ")");
                }
                int index = 0;
                for (String checkAlias : checkAliasUe) {
                    int index_interno = 0;
                    for (String ueAlias : aliasUe) {
                        if (index == index_interno && !checkAlias.equals(ueAlias)) {
                            throw new ServiceException(errorMsg + "Found expression that contains a different alias for select field n." + index + " (" + (i + 1) + "-exp alias:" + ueAlias + " " + (j + 1) + "-exp alias:" + checkAlias + ")");
                        }
                        ++index_interno;
                    }
                    ++index;
                }
            }
            if (i != 0) continue;
            ArrayList<Object> listaObject = new ArrayList<Object>();
            for (String alias : aliasUe) {
                listaObject.add(ue.getReturnField(alias));
            }
            listClassReturnType = GenericJDBCUtilities.readClassTypes(listaObject);
        }
        return listClassReturnType;
    }

    public static void checkUnionExpression(Union union, UnionExpression expressionComparator, ISQLQueryObject sqlQueryObject) throws ServiceException, SQLQueryObjectException {
        List<String> listaFields = union.getFields();
        if (listaFields != null && listaFields.size() > 0) {
            for (String string : listaFields) {
                Function function = union.getFunction(string);
                String paramAliasFunction = union.getParamAliasFunction(string);
                String customFieldValue = union.getCustomFieldValue(string);
                String aliasCheck = null;
                if (paramAliasFunction == null) {
                    if (customFieldValue == null) {
                        aliasCheck = string;
                    }
                } else {
                    aliasCheck = paramAliasFunction;
                }
                if (!(aliasCheck == null || expressionComparator.getReturnFieldAliases() != null && expressionComparator.getReturnFieldAliases().contains(aliasCheck))) {
                    throw new ServiceException("The alias [" + aliasCheck + "] is unknown. Check the alias used in the internal union expression");
                }
                if (paramAliasFunction == null) {
                    if (customFieldValue == null) {
                        sqlQueryObject.addSelectField(string);
                        continue;
                    }
                    sqlQueryObject.addSelectAliasField(customFieldValue, string);
                    continue;
                }
                ExpressionSQL.setFunction(function, false, paramAliasFunction, string, sqlQueryObject);
            }
        }
        if (union.getGroupByList() != null && union.getGroupByList().size() > 0) {
            List<String> aliasExpression = expressionComparator.getReturnFieldAliases();
            for (String aliasGroupBy : union.getGroupByList()) {
                if (!aliasExpression.contains(aliasGroupBy)) {
                    throw new ServiceException("The alias used in the condition of group by the union must be one of the aliases used in internal expressions");
                }
                sqlQueryObject.addGroupBy(aliasGroupBy);
            }
        }
        if (union.getOrderByList() != null && union.getOrderByList().size() > 0) {
            SortOrder sortOrderUnion = null;
            try {
                sortOrderUnion = union.getSortOrder();
            }
            catch (Exception exception) {
                throw new ServiceException(exception.getMessage(), exception);
            }
            if (!SortOrder.UNSORTED.equals((Object)sortOrderUnion)) {
                List<String> list = expressionComparator.getReturnFieldAliases();
                List<String> aliasExternalExpression = union.getFields();
                for (UnionOrderedColumn uoo : union.getOrderByList()) {
                    String aliasOrderBy = uoo.getAlias();
                    SortOrder sortOrder = uoo.getSortOrder();
                    if (!list.contains(aliasOrderBy) && !aliasExternalExpression.contains(aliasOrderBy)) {
                        throw new ServiceException("The alias '" + aliasOrderBy + "' used in the condition of order by the union must be one of the aliases used in internal or external expressions");
                    }
                    if (sortOrder == null) {
                        sqlQueryObject.addOrderBy(aliasOrderBy);
                        continue;
                    }
                    sqlQueryObject.addOrderBy(aliasOrderBy, SortOrder.ASC.equals((Object)sortOrder));
                }
                sqlQueryObject.setSortType(SortOrder.ASC.equals((Object)sortOrderUnion));
            }
        }
        if (union.getLimit() != null) {
            sqlQueryObject.setLimit(union.getLimit().intValue());
        }
        if (union.getOffset() != null) {
            sqlQueryObject.setOffset(union.getOffset().intValue());
        }
    }

    protected static void setFields(List<ISQLQueryObject> sqlQueryObjectInnerList, UnionExpression ... unionExpression) throws ExpressionException, ServiceException {
        GenericJDBCUtilities.manageFields(sqlQueryObjectInnerList, true, false, unionExpression);
    }

    protected static void removeFields(List<ISQLQueryObject> sqlQueryObjectInnerList, UnionExpression ... unionExpression) throws ExpressionException, ServiceException {
        GenericJDBCUtilities.manageFields(sqlQueryObjectInnerList, false, true, unionExpression);
    }

    private static void manageFields(List<ISQLQueryObject> sqlQueryObjectInnerList, boolean set, boolean remove, UnionExpression ... unionExpression) throws ExpressionException, ServiceException {
        if (unionExpression == null || unionExpression.length <= 0) {
            throw new ServiceException("UnionExpression not found");
        }
        if (unionExpression.length == 1) {
            throw new ServiceException("At least two expressions are required");
        }
        for (int i = 0; i < unionExpression.length; ++i) {
            ISQLQueryObject sqlQueryObject = sqlQueryObjectInnerList.get(i);
            UnionExpression ue = unionExpression[i];
            IExpression exp = ue.getExpression();
            List<String> aliasUE = ue.getReturnFieldAliases();
            for (String alias : aliasUE) {
                Object field;
                Object o = ue.getReturnField(alias);
                if (o instanceof IField) {
                    field = (IField)o;
                    if (set) {
                        ArrayList<String> lAlias = new ArrayList<String>();
                        lAlias.add(alias);
                        if (exp instanceof JDBCExpression) {
                            GenericJDBCUtilities.setFields(sqlQueryObject, (JDBCExpression)exp, lAlias, new IField[]{field});
                            continue;
                        }
                        GenericJDBCUtilities.setFields(sqlQueryObject, (JDBCPaginatedExpression)exp, lAlias, new IField[]{field});
                        continue;
                    }
                    if (exp instanceof JDBCExpression) {
                        GenericJDBCUtilities.removeFields(sqlQueryObject, (JDBCExpression)exp, new IField[]{field});
                        continue;
                    }
                    GenericJDBCUtilities.removeFields(sqlQueryObject, (JDBCPaginatedExpression)exp, new IField[]{field});
                    continue;
                }
                if (!(o instanceof FunctionField)) continue;
                field = (FunctionField)o;
                if (set) {
                    if (exp instanceof JDBCExpression) {
                        GenericJDBCUtilities.setFields(sqlQueryObject, (JDBCExpression)exp, new FunctionField[]{field});
                        continue;
                    }
                    GenericJDBCUtilities.setFields(sqlQueryObject, (JDBCPaginatedExpression)exp, new FunctionField[]{field});
                    continue;
                }
                if (exp instanceof JDBCExpression) {
                    GenericJDBCUtilities.removeFields(sqlQueryObject, (JDBCExpression)exp, new FunctionField[]{field});
                    continue;
                }
                GenericJDBCUtilities.removeFields(sqlQueryObject, (JDBCPaginatedExpression)exp, new FunctionField[]{field});
            }
        }
    }

    public static List<Class<?>> prepareUnion(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlConverter, IModel<?> model, List<ISQLQueryObject> sqlQueryObjectInnerList, List<JDBCObject> jdbcObjects, Union union, UnionExpression ... unionExpression) throws NotFoundException, ExpressionException, ExpressionNotImplementedException, SQLQueryObjectException, JDBCAdapterException, ServiceException {
        int i;
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("sqlQueryObject parameter is null");
        }
        if (sqlConverter == null) {
            throw new SQLQueryObjectException("sqlConverter parameter is null");
        }
        if (model == null) {
            throw new SQLQueryObjectException("model parameter is null");
        }
        if (sqlQueryObjectInnerList == null) {
            throw new SQLQueryObjectException("sqlQueryObjectInnerList parameter is null");
        }
        if (jdbcObjects == null) {
            throw new SQLQueryObjectException("jdbcObjects parameter is null");
        }
        if (union == null) {
            throw new SQLQueryObjectException("union parameter is null");
        }
        if (unionExpression == null) {
            throw new SQLQueryObjectException("unionExpression parameter is null");
        }
        List<Class<?>> returnClassTypes = GenericJDBCUtilities.checkUnionExpression(unionExpression);
        GenericJDBCUtilities.checkUnionExpression(union, unionExpression[0], sqlQueryObject);
        for (i = 0; i < unionExpression.length; ++i) {
            ISQLQueryObject sqlQueryObjectInner = sqlQueryObject.newSQLQueryObject();
            sqlQueryObjectInner.setANDLogicOperator(true);
            sqlQueryObjectInnerList.add(sqlQueryObjectInner);
        }
        GenericJDBCUtilities.setFields(sqlQueryObjectInnerList, unionExpression);
        for (i = 0; i < unionExpression.length; ++i) {
            IExpression expr = unionExpression[i].getExpression();
            ISQLQueryObject sqlQueryObjectInner = sqlQueryObjectInnerList.get(i);
            ArrayList<Object> listaQuery = new ArrayList<Object>();
            GenericJDBCUtilities.toSqlForPreparedStatementWithFromCondition(expr, sqlQueryObjectInner, listaQuery, sqlConverter.toTable(model));
            for (Object e : listaQuery) {
                jdbcObjects.add(new JDBCObject(e, e.getClass()));
            }
        }
        return returnClassTypes;
    }

    public static List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlConverter, IModel<?> model, List<ISQLQueryObject> sqlQueryObjectInnerList, List<JDBCObject> jdbcObjects, List<Class<?>> returnClassTypes, Union union, UnionExpression ... unionExpression) throws NotFoundException, ExpressionException, ExpressionNotImplementedException, SQLQueryObjectException, JDBCAdapterException, ServiceException {
        List<List<Object>> resultExecuteQuery;
        if (jdbcProperties == null) {
            throw new ServiceException("jdbcProperties is null");
        }
        if (sqlQueryObject == null) {
            throw new ServiceException("sqlQueryObject is null");
        }
        if (sqlQueryObjectInnerList == null) {
            throw new ServiceException("sqlQueryObjectInnerList is null");
        }
        if (jdbcObjects == null) {
            throw new ServiceException("jdbcObjects is null");
        }
        if (returnClassTypes == null) {
            throw new ServiceException("returnClassTypes is null");
        }
        if (union == null) {
            throw new ServiceException("union is null");
        }
        if (unionExpression == null) {
            throw new ServiceException("unionExpression is null");
        }
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        String sql = sqlQueryObject.createSQLUnion(union.isUnionAll(), sqlQueryObjectInnerList.toArray(new ISQLQueryObject[1]));
        List<String> returnClassAliases = unionExpression[0].getReturnFieldAliases();
        if (union.getFields() != null && union.getFields().size() > 0) {
            returnClassAliases = union.getFields();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        JDBCObject[] params = null;
        if (jdbcObjects.size() > 0) {
            params = jdbcObjects.toArray(new JDBCObject[1]);
        }
        if ((resultExecuteQuery = jdbcUtilities.executeQuery(sql, jdbcProperties.isShowSql(), returnClassTypes, params)).size() > 0) {
            for (int i = 0; i < resultExecuteQuery.size(); ++i) {
                List<Object> lista = resultExecuteQuery.get(i);
                if (lista == null) {
                    throw new ServiceException("Result[" + i + "] is null?");
                }
                if (lista.size() != returnClassTypes.size()) {
                    throw new ServiceException("Result[" + i + "] has wrong length (expected:" + returnClassTypes.size() + " founded:" + lista.size() + ")");
                }
                if (lista.size() != returnClassAliases.size()) {
                    throw new ServiceException("Result[" + i + "] has wrong length (alias) (expected:" + returnClassAliases.size() + " founded:" + lista.size() + ")");
                }
                HashMap<String, Object> resultList = new HashMap<String, Object>();
                int j = 0;
                for (String alias : returnClassAliases) {
                    Object object = lista.get(j);
                    if (object != null) {
                        resultList.put(alias, object);
                    } else {
                        resultList.put(alias, ObjectUtils.NULL);
                    }
                    ++j;
                }
                result.add(resultList);
            }
        }
        if (result.size() <= 0) {
            throw new NotFoundException("No result founds");
        }
        return result;
    }

    public static List<Class<?>> prepareUnionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlConverter, IModel<?> model, List<ISQLQueryObject> sqlQueryObjectInnerList, List<JDBCObject> jdbcObjects, Union union, UnionExpression ... unionExpression) throws NotFoundException, ExpressionException, ExpressionNotImplementedException, SQLQueryObjectException, JDBCAdapterException, ServiceException {
        if (union.getOrderByList().size() > 0 && union.getSortOrder() != null && !union.getSortOrder().equals((Object)SortOrder.UNSORTED)) {
            throw new ServiceException("OrderBy conditions not allowed in count expression");
        }
        if (union.getOffset() != null) {
            throw new ServiceException("Offset condition not allowed in count expression");
        }
        if (union.getLimit() != null) {
            throw new ServiceException("Limit condition not allowed in count expression");
        }
        return GenericJDBCUtilities.prepareUnion(jdbcProperties, log, connection, sqlQueryObject, sqlConverter, model, sqlQueryObjectInnerList, jdbcObjects, union, unionExpression);
    }

    public static NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlConverter, IModel<?> model, List<ISQLQueryObject> sqlQueryObjectInnerList, List<JDBCObject> jdbcObjects, List<Class<?>> returnClassTypes, Union union, UnionExpression ... unionExpression) throws NotFoundException, ExpressionException, ExpressionNotImplementedException, SQLQueryObjectException, JDBCAdapterException, ServiceException {
        long totale = 0L;
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        String sql = sqlQueryObject.createSQLUnionCount(union.isUnionAll(), "unionCount", sqlQueryObjectInnerList.toArray(new ISQLQueryObject[1]));
        JDBCObject[] params = null;
        if (jdbcObjects.size() > 0) {
            params = jdbcObjects.toArray(new JDBCObject[1]);
        }
        totale = jdbcUtilities.count(sql, jdbcProperties.isShowSql(), params);
        return new NonNegativeNumber(totale);
    }

    public static List<Object> prepareFindAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression paginatedExpression, ISQLFieldConverter sqlConverter, IModel<?> model) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, ServiceException {
        ArrayList<Object> listaQuery = new ArrayList<Object>();
        GenericJDBCUtilities.toSqlForPreparedStatementWithFromCondition(paginatedExpression, sqlQueryObject, listaQuery, sqlConverter.toTable(model));
        return listaQuery;
    }

    public static List<Object> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression paginatedExpression, ISQLFieldConverter sqlConverter, IModel<?> model, Class<?> objectIdClass, List<Object> listaQuery) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, ServiceException {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        JDBCObject[] params = new JDBCObject[listaQuery.size()];
        int index = 0;
        for (Object param : listaQuery) {
            params[index++] = new JDBCObject(param, param.getClass());
        }
        String sql = sqlQueryObject.createSQLQuery();
        return jdbcUtilities.executeQuery(sql, jdbcProperties.isShowSql(), objectIdClass, params);
    }

    public static List<List<Object>> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression paginatedExpression, ISQLFieldConverter sqlConverter, IModel<?> model, List<Class<?>> objectIdsClass, List<Object> listaQuery) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, ServiceException {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        JDBCObject[] params = new JDBCObject[listaQuery.size()];
        int index = 0;
        for (Object param : listaQuery) {
            params[index++] = new JDBCObject(param, param.getClass());
        }
        String sql = sqlQueryObject.createSQLQuery();
        return jdbcUtilities.executeQuery(sql, jdbcProperties.isShowSql(), objectIdsClass, params);
    }

    public static List<Object> prepareFind(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLFieldConverter sqlConverter, IModel<?> model) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, ServiceException, MultipleResultException {
        ArrayList<Object> listaQuery = new ArrayList<Object>();
        GenericJDBCUtilities.toSqlForPreparedStatementWithFromCondition(expression, sqlQueryObject, listaQuery, sqlConverter.toTable(model));
        return listaQuery;
    }

    public static Object find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLFieldConverter sqlConverter, IModel<?> model, Class<?> objectIdClass, List<Object> listaQuery) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, NotFoundException, ServiceException, MultipleResultException {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        JDBCObject[] params = new JDBCObject[listaQuery.size()];
        int index = 0;
        for (Object param : listaQuery) {
            params[index++] = new JDBCObject(param, param.getClass());
        }
        String sql = sqlQueryObject.createSQLQuery();
        return jdbcUtilities.executeQuerySingleResult(sql, jdbcProperties.isShowSql(), objectIdClass, params);
    }

    public static List<Object> find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLFieldConverter sqlConverter, IModel<?> model, List<Class<?>> objectIdsClass, List<Object> listaQuery) throws SQLQueryObjectException, JDBCAdapterException, ExpressionException, ExpressionNotImplementedException, NotFoundException, ServiceException, MultipleResultException {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        JDBCObject[] params = new JDBCObject[listaQuery.size()];
        int index = 0;
        for (Object param : listaQuery) {
            params[index++] = new JDBCObject(param, param.getClass());
        }
        String sql = sqlQueryObject.createSQLQuery();
        return jdbcUtilities.executeQuerySingleResult(sql, jdbcProperties.isShowSql(), objectIdsClass, params);
    }

    public static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchSingleObject<?, ?> serviceSingleObject, UpdateModel ... updateModels) throws ServiceException, NotImplementedException, Exception {
        GenericJDBCUtilities.updateFields(jdbcProperties, log, connection, sqlQueryObject, rootTable, mapTableToPKColumn, rootTableIdValues, sqlConverter, serviceSingleObject, null, null, updateModels);
    }

    public static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchWithId<?, ?, ?> serviceWithId, UpdateModel ... updateModels) throws ServiceException, NotImplementedException, Exception {
        GenericJDBCUtilities.updateFields(jdbcProperties, log, connection, sqlQueryObject, rootTable, mapTableToPKColumn, rootTableIdValues, sqlConverter, null, serviceWithId, null, updateModels);
    }

    public static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchWithoutId<?, ?> serviceWithoutId, UpdateModel ... updateModels) throws ServiceException, NotImplementedException, Exception {
        GenericJDBCUtilities.updateFields(jdbcProperties, log, connection, sqlQueryObject, rootTable, mapTableToPKColumn, rootTableIdValues, sqlConverter, null, null, serviceWithoutId, updateModels);
    }

    private static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchSingleObject<?, ?> serviceSingleObject, IJDBCServiceSearchWithId<?, ?, ?> serviceWithId, IJDBCServiceSearchWithoutId<?, ?> serviceWithoutId, UpdateModel ... updateModels) throws ServiceException, NotImplementedException, Exception {
        if (updateModels == null || updateModels.length <= 0) {
            throw new ServiceException("Parameter updateModels is not defined");
        }
        ArrayList<String> tableUpdated = new ArrayList<String>();
        for (UpdateModel updateModel : updateModels) {
            IModel<?> model = updateModel.getModel();
            IExpression condition = updateModel.getCondition();
            List<UpdateField> updateFields = updateModel.getUpdateFiels();
            if (updateFields == null || updateFields.size() <= 0) {
                throw new ServiceException("Parameter updateFields of model [" + String.valueOf(model) + "] is not defined");
            }
            String table = sqlConverter.toTable(model);
            if (table == null) {
                throw new ServiceException("Model [" + String.valueOf(model) + "] is not defined in sql converter");
            }
            for (UpdateField updateField : updateFields) {
                String tableField = sqlConverter.toTable(updateField.getField());
                if (table.equals(tableField)) continue;
                throw new ServiceException("Different update table: UpdateField [" + updateField.getField().getFieldName() + " of " + updateField.getField().getClassName() + "] (table:" + tableField + ") and Model [" + String.valueOf(model) + "] (table:" + table + ") ");
            }
            if (tableUpdated.contains(table)) continue;
            GenericJDBCUtilities._engineUpdateFields(jdbcProperties, log, connection, sqlQueryObject, sqlConverter, serviceSingleObject, serviceWithId, serviceWithoutId, rootTable, mapTableToPKColumn, rootTableIdValues, table, condition, updateFields);
            tableUpdated.add(table);
        }
    }

    public static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchSingleObject<?, ?> serviceSingleObject, IExpression condition, UpdateField ... updateFields) throws ServiceException, NotImplementedException, Exception {
        GenericJDBCUtilities.updateFields(jdbcProperties, log, connection, sqlQueryObject, rootTable, mapTableToPKColumn, rootTableIdValues, sqlConverter, serviceSingleObject, null, null, condition, updateFields);
    }

    public static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchWithId<?, ?, ?> serviceWithId, IExpression condition, UpdateField ... updateFields) throws ServiceException, NotImplementedException, Exception {
        GenericJDBCUtilities.updateFields(jdbcProperties, log, connection, sqlQueryObject, rootTable, mapTableToPKColumn, rootTableIdValues, sqlConverter, null, serviceWithId, null, condition, updateFields);
    }

    public static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchWithoutId<?, ?> serviceWithoutId, IExpression condition, UpdateField ... updateFields) throws ServiceException, NotImplementedException, Exception {
        GenericJDBCUtilities.updateFields(jdbcProperties, log, connection, sqlQueryObject, rootTable, mapTableToPKColumn, rootTableIdValues, sqlConverter, null, null, serviceWithoutId, condition, updateFields);
    }

    private static void updateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, ISQLFieldConverter sqlConverter, IJDBCServiceSearchSingleObject<?, ?> serviceSingleObject, IJDBCServiceSearchWithId<?, ?, ?> serviceWithId, IJDBCServiceSearchWithoutId<?, ?> serviceWithoutId, IExpression condition, UpdateField ... updateFields) throws ServiceException, NotImplementedException, Exception {
        if (updateFields == null || updateFields.length <= 0) {
            throw new ServiceException("Parameter updateFields is not defined");
        }
        HashMap<String, ArrayList<UpdateField>> updateMap = new HashMap<String, ArrayList<UpdateField>>();
        for (int i = 0; i < updateFields.length; ++i) {
            String tableName = sqlConverter.toTable(updateFields[i].getField());
            if (tableName == null) {
                throw new ServiceException("Field [" + updateFields[i].getField().getFieldName() + " of " + updateFields[i].getField().getClassName() + "] is not defined in sql converter");
            }
            ArrayList<UpdateField> list = (ArrayList<UpdateField>)updateMap.remove(tableName);
            if (list == null) {
                list = new ArrayList<UpdateField>();
            }
            list.add(updateFields[i]);
            updateMap.put(tableName, list);
        }
        for (String table : updateMap.keySet()) {
            GenericJDBCUtilities._engineUpdateFields(jdbcProperties, log, connection, sqlQueryObject, sqlConverter, serviceSingleObject, serviceWithId, serviceWithoutId, rootTable, mapTableToPKColumn, rootTableIdValues, table, condition, (List)updateMap.get(table));
        }
    }

    private static void _engineUpdateFields(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlConverter, IJDBCServiceSearchSingleObject<?, ?> serviceSingleObject, IJDBCServiceSearchWithId<?, ?, ?> serviceWithId, IJDBCServiceSearchWithoutId<?, ?> serviceWithoutId, String rootTable, Map<String, List<IField>> mapTableToPKColumn, List<Object> rootTableIdValues, String table, IExpression condition, List<UpdateField> updateFields) throws ServiceException, NotImplementedException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectUpdate = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectUpdate.setANDLogicOperator(true);
        sqlQueryObjectUpdate.addUpdateTable(table);
        ArrayList<JDBCObject> lstObjectsUpdate = new ArrayList<JDBCObject>();
        for (UpdateField updateField : updateFields) {
            sqlQueryObjectUpdate.addUpdateField(sqlConverter.toColumn(updateField.getField(), false), "?");
            lstObjectsUpdate.add(new JDBCObject(updateField.getValue(), updateField.getField().getFieldType()));
        }
        boolean update = true;
        JDBCPaginatedExpression rootTablePKExpresion = new JDBCPaginatedExpression(sqlConverter);
        rootTablePKExpresion.and();
        List<IField> rootTableListPKColumns = mapTableToPKColumn.get(rootTable);
        if (rootTableListPKColumns != null && rootTableIdValues != null) {
            if (rootTableListPKColumns.size() != rootTableIdValues.size()) {
                throw new ServiceException("Number of primary key column (" + rootTableListPKColumns.size() + ") and numbero of column values (" + rootTableIdValues.size() + ") isn't equals");
            }
            for (int i = 0; i < rootTableListPKColumns.size(); ++i) {
                rootTablePKExpresion.equals(rootTableListPKColumns.get(i), rootTableIdValues.get(i));
            }
        }
        if (condition != null) {
            rootTablePKExpresion.and(condition);
        }
        rootTablePKExpresion.sortOrder(SortOrder.ASC).addOrder(updateFields.get(0).getField());
        if (rootTable.equals(table) && condition == null) {
            if (rootTableListPKColumns != null && rootTableIdValues != null) {
                StringBuilder bfRowIdentification = new StringBuilder();
                bfRowIdentification.append("( ");
                for (int i = 0; i < rootTableListPKColumns.size(); ++i) {
                    if (i > 0) {
                        bfRowIdentification.append(" AND ");
                    }
                    IField columnId = rootTableListPKColumns.get(i);
                    bfRowIdentification.append(sqlConverter.toColumn(columnId, true)).append("=?");
                    lstObjectsUpdate.add(new JDBCObject(rootTableIdValues.get(i), columnId.getFieldType()));
                }
                bfRowIdentification.append(" )");
                sqlQueryObjectUpdate.addWhereCondition(bfRowIdentification.toString());
            }
        } else {
            ISQLQueryObject sqlQueryObjectSelect = sqlQueryObjectUpdate.newSQLQueryObject();
            sqlQueryObjectSelect.setANDLogicOperator(true);
            try {
                List<IField> columnIds = mapTableToPKColumn.get(table);
                if (columnIds != null && columnIds.size() > 0) {
                    List<Map<String, Object>> valueIds = null;
                    if (serviceSingleObject != null) {
                        valueIds = serviceSingleObject.select(jdbcProperties, log, connection, sqlQueryObjectSelect, rootTablePKExpresion, true, columnIds.toArray(new IField[0]));
                    } else if (serviceWithoutId != null) {
                        valueIds = serviceWithoutId.select(jdbcProperties, log, connection, sqlQueryObjectSelect, rootTablePKExpresion, true, columnIds.toArray(new IField[0]));
                    } else if (serviceWithId != null) {
                        valueIds = serviceWithId.select(jdbcProperties, log, connection, sqlQueryObjectSelect, rootTablePKExpresion, true, columnIds.toArray(new IField[0]));
                    }
                    if (valueIds != null) {
                        StringBuilder bfRowIdentification = new StringBuilder();
                        bfRowIdentification.append("( ");
                        for (int i = 0; i < valueIds.size(); ++i) {
                            if (i > 0) {
                                bfRowIdentification.append(" OR ");
                            }
                            Map<String, Object> mapColumnValue = valueIds.get(i);
                            bfRowIdentification.append("( ");
                            for (int j = 0; j < columnIds.size(); ++j) {
                                if (j > 0) {
                                    bfRowIdentification.append(" AND ");
                                }
                                IField columnId = columnIds.get(j);
                                bfRowIdentification.append(sqlConverter.toColumn(columnId, true)).append("=?");
                                lstObjectsUpdate.add(new JDBCObject(mapColumnValue.get(columnId.getFieldName()), columnId.getFieldType()));
                            }
                            bfRowIdentification.append(" )");
                        }
                        bfRowIdentification.append(" )");
                        sqlQueryObjectUpdate.addWhereCondition(bfRowIdentification.toString());
                    }
                }
            }
            catch (NotFoundException notFound) {
                update = false;
                log.debug("UpdateField[" + table + "]: NotFound");
            }
        }
        if (update) {
            int updateRow = jdbcUtilities.executeUpdate(sqlQueryObjectUpdate.createSQLUpdate(), jdbcProperties.isShowSql(), lstObjectsUpdate.toArray(new JDBCObject[0]));
            log.debug("UpdateField[" + table + "]: " + updateRow + " rows");
        }
    }

    public static List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws SQLQueryObjectException, JDBCAdapterException, ServiceException {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ArrayList<JDBCObject> listParams = new ArrayList<JDBCObject>();
        for (Object jdbcObject : param) {
            JDBCObject jdbc = new JDBCObject(jdbcObject, jdbcObject.getClass());
            listParams.add(jdbc);
        }
        JDBCObject[] paramArray = null;
        if (listParams.size() > 0) {
            paramArray = listParams.toArray(new JDBCObject[1]);
        }
        return jdbcUtilities.executeQuery(sql, jdbcProperties.isShowSql(), returnClassTypes, paramArray);
    }

    public static int nativeUpdate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, Object ... param) throws SQLQueryObjectException, JDBCAdapterException, ServiceException {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ArrayList<JDBCObject> listParams = new ArrayList<JDBCObject>();
        for (Object jdbcObject : param) {
            JDBCObject jdbc = new JDBCObject(jdbcObject, jdbcObject.getClass());
            listParams.add(jdbc);
        }
        JDBCObject[] paramArray = null;
        if (listParams.size() > 0) {
            paramArray = listParams.toArray(new JDBCObject[1]);
        }
        return jdbcUtilities.executeUpdate(sql, jdbcProperties.isShowSql(), paramArray);
    }
}

