/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.sql;

import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.InExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.expression.impl.sql.SQLMode;
import org.openspcoop2.generic_project.utils.IDGenerator;
import org.openspcoop2.utils.sql.ISQLQueryObject;

public class InExpressionSQL
extends InExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public InExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter, IField field, List<Object> objects) {
        super(objectFormatter, field, objects);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    private String toSqlEngine(SQLMode mode, List<Object> oggettiPreparedStatement, Map<String, Object> oggettiJPA) throws ExpressionException {
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        bf.append(this.sqlFieldConverter.toColumn(this.getField(), true));
        bf.append(" IN (");
        block7: for (int i = 0; i < this.getObjects().size(); ++i) {
            bf.append(" ");
            if (i > 0) {
                bf.append(", ");
            }
            switch (mode) {
                case STANDARD: {
                    try {
                        bf.append(super.getObjectFormatter().toSQLString(this.getObjects().get(i)));
                        continue block7;
                    }
                    catch (Exception e) {
                        return "ERROR[" + i + "]: " + e.getMessage();
                    }
                }
                case PREPARED_STATEMENT: {
                    bf.append("?");
                    oggettiPreparedStatement.add(this.getObjects().get(i));
                    continue block7;
                }
                case JPA: {
                    String id = "o" + i + "_" + IDGenerator.getUniqueID(this.getField());
                    bf.append(":" + id);
                    oggettiJPA.put(id, this.getObjects().get(i));
                }
            }
        }
        bf.append(" )");
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    private void toSqlEngine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Map<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSqlEngine(mode, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSqlEngine(SQLMode.STANDARD, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public String toSqlJPA(Map<String, Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.JPA, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Map<String, Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

