/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.utils;

import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.properties.PropertiesReader;

public class ServiceManagerProperties {
    private String databaseType;
    private boolean generateDdl;
    private boolean showSql;
    private boolean automaticTransactionManagement = true;
    private int secondsToRefreshConnection = -1;

    public String getDatabaseType() {
        if (this.databaseType != null && this.databaseType.contains("$")) {
            try {
                this.databaseType = PropertiesReader.convertValue((String)"DatabaseType", (String)this.databaseType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.databaseType;
    }

    public TipiDatabase getDatabase() throws ServiceException {
        TipiDatabase databaseTypeCheck = TipiDatabase.toEnumConstant((String)this.databaseType);
        if (TipiDatabase.DEFAULT.equals((Object)databaseTypeCheck)) {
            throw new ServiceException("Database [" + String.valueOf(databaseTypeCheck) + "] not supported");
        }
        return databaseTypeCheck;
    }

    public boolean isGenerateDdl() {
        return this.generateDdl;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setGenerateDdl(boolean generateDdl) {
        this.generateDdl = generateDdl;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public boolean isAutomaticTransactionManagement() {
        return this.automaticTransactionManagement;
    }

    public void setAutomaticTransactionManagement(boolean automaticTransactionManagement) {
        this.automaticTransactionManagement = automaticTransactionManagement;
    }

    public int getSecondsToRefreshConnection() {
        return this.secondsToRefreshConnection;
    }

    public void setSecondsToRefreshConnection(int secondsToRefreshConnection) {
        this.secondsToRefreshConnection = secondsToRefreshConnection;
    }
}

