/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.message.OpenSPCoop2DataContentHandlerInputStream;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.resources.Loader;

public class OpenSPCoop2DataContentHandler
implements DataContentHandler {
    public static final String OPENSPCOOP2_SIGNATURE = "===SIGNATURE=OPENSPCOOP2===";

    public static Object getContent(InputStream inputstream) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] bRead = new byte[8094];
            int byteLetti = 0;
            while ((byteLetti = inputstream.read(bRead)) != -1) {
                bout.write(bRead, 0, byteLetti);
            }
            bout.flush();
            bout.close();
            if (bout.size() <= OPENSPCOOP2_SIGNATURE.length()) {
                throw new Exception("OpenSPCoop2DataContentHandler Signature non presente (length is too small)");
            }
            boolean giaCodificato = true;
            String attach = bout.toString();
            for (int i = 0; i < OPENSPCOOP2_SIGNATURE.length(); ++i) {
                if (attach.charAt(i) == OPENSPCOOP2_SIGNATURE.charAt(i)) continue;
                giaCodificato = false;
                break;
            }
            if (!giaCodificato) {
                throw new Exception("OpenSPCoop2DataContentHandler Signature non presente");
            }
            attach = attach.substring(OPENSPCOOP2_SIGNATURE.length(), attach.length());
            OpenSPCoop2DataContentHandlerInputStream bin = new OpenSPCoop2DataContentHandlerInputStream(Base64Utilities.decode((String)attach));
            return bin;
        }
        catch (Exception e) {
            throw new IOException("@@@ OpenSPCoop2DataContentHandler.getContent() error: " + e.getMessage());
        }
    }

    public Object getContent(DataSource datasource) throws IOException {
        try {
            InputStream inputstream = datasource.getInputStream();
            return OpenSPCoop2DataContentHandler.getContent(inputstream);
        }
        catch (Exception e) {
            throw new IOException("@@@ OpenSPCoop2DataContentHandler.getContent() error: " + e.getMessage());
        }
    }

    public Object getTransferData(ActivationDataFlavor arg0, DataSource arg1) throws IOException {
        return null;
    }

    public ActivationDataFlavor[] getTransferDataFlavors() {
        ActivationDataFlavor[] adataflavor = new ActivationDataFlavor[1];
        try {
            adataflavor[0] = new ActivationDataFlavor(Loader.getInstance().forName("org.openspcoop2.message.OpenSPCoop2DataContentHandler"), "application/openspcoop2", "OpenSPCoop2AttachmentsTunnel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return adataflavor;
    }

    public void writeTo(Object obj, String s, OutputStream outputstream) throws IOException {
        try {
            byte[] content = null;
            if (obj instanceof InputStream) {
                InputStream inputstream = (InputStream)obj;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] bRead = new byte[8094];
                int byteLetti = 0;
                while ((byteLetti = inputstream.read(bRead)) != -1) {
                    bout.write(bRead, 0, byteLetti);
                }
                bout.flush();
                bout.close();
                content = bout.toByteArray();
            } else {
                content = (byte[])obj;
            }
            boolean giaCodificato = true;
            if (content.length >= OPENSPCOOP2_SIGNATURE.length() + 1) {
                for (int i = 0; i < OPENSPCOOP2_SIGNATURE.length(); ++i) {
                    if ((char)content[i] == OPENSPCOOP2_SIGNATURE.charAt(i)) continue;
                    giaCodificato = false;
                    break;
                }
            }
            if (giaCodificato) {
                outputstream.write(content);
            } else {
                String encoded = OPENSPCOOP2_SIGNATURE + Base64Utilities.encodeAsString((byte[])content);
                outputstream.write(encoded.getBytes());
            }
        }
        catch (Exception exception) {
            throw new IOException("@@@ OpenSPCoop2DataContentHandler.writeTo: Unable to run the Binary decoding on a stream " + exception.getMessage());
        }
    }
}

