/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.rest;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.rest.AbstractLazyContent;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class BinaryContent
extends AbstractLazyContent<byte[]> {
    public BinaryContent(InputStream is, String contentType) throws MessageException {
        try {
            this.init(is, contentType);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public BinaryContent(DumpByteArrayOutputStream contentBuffer, String contentType) throws MessageException {
        try {
            this.init(contentBuffer, contentType);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] buildContent(InputStream is) throws MessageException {
        return new byte[1];
    }

    @Override
    public byte[] buildContent(byte[] c) throws MessageException {
        return new byte[1];
    }

    @Override
    public void writeContentTo(OutputStream os, boolean consume) throws MessageException {
        super.writeTo(false, os, consume);
    }

    @Override
    public byte[] getContent() throws MessageException {
        if (this.contentBuffer != null) {
            try {
                if (this.contentBuffer.isSerializedOnFileSystem()) {
                    return FileSystemUtilities.readBytesFromFile((File)this.contentBuffer.getSerializedFile());
                }
                return this.contentBuffer.toByteArray();
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        }
        return this.contentByteArray;
    }
}

